

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_removeAlert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_removeAlert.sp,v $ $Id: TM_removeAlert.sp,v 1.4 2010/03/04 17:26:48 sbonilla Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 09/25/2009
-- Description:	set the alert for give taskId
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_removeAlert <<<'

IF EXISTS (select * from sysobjects where name='TM_removeAlert')
	drop procedure TM_removeAlert
IF EXISTS (select * from GxQscripts where name='TM_removeAlert')
	delete from GxQscripts where name = 'TM_removeAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_removeAlert')
	delete from GXDBVersions where aliasname = 'TM_removeAlert'
GO
print '... Creating Procedure: TM_removeAlert'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_removeAlert
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_taskId integer,
  @alertId integer
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
	DECLARE @entities XML
	DECLARE @xmlEntity NVARCHAR(MAX)
	DECLARE @oldTaskId	INTEGER
	DECLARE @oldPolicyId	INTEGER
	DECLARE @taskType	INTEGER
	SET @entities = ( SELECT CAST([xmlEntityList] AS XML) FROM ntnotificationrule WHERE id = @alertId)
	SET @oldPolicyId = @entities.value('(/CVGui_CommCellTreeNode/trackingSchedules/schedules/@policyId)[1]', 'int' )
	-- Check if already taskId is associated
	SET @oldTaskId = @entities.value('(/CVGui_CommCellTreeNode/trackingSchedules/schedules/@taskId)[1]', 'int' )
	--Only if @oldTaskId is null insert the taskId in XML Entities
	IF (@oldTaskId = @i_taskId) OR (@oldPolicyId = @i_taskId)
	BEGIN
		SET @entities.modify('
		delete (/CVGui_CommCellTreeNode/trackingSchedules[1]/schedules)[1]
		')
	END
	UPDATE ntnotificationrule SET [revision] = 0, status = 2, [xmlEntityList] = @entities WHERE  id = @alertId
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_removeAlert')
	delete from GxQscripts where name = 'TM_removeAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_removeAlert')
	delete from GXDBVersions where aliasname = 'TM_removeAlert'
GO

insert into GXDBVersions values(2, 'TM_removeAlert',  '00010004000000000000', 'TM_removeAlert', '00010004000000000000')
GO

