

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_maintenance.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_maintenance.sp,v $ $Id: TM_maintenance.sp,v 1.37.2.21 2020/12/07 21:13:05 rengu Exp $";
-- =============================================
-- Author:		Anand Vibhor
-- Create date: 14/06/2007
-- Description:	Do maintenance of Task Manager tables
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_maintenance')
BEGIN
	print '>>> Drop Stored Procedure: TM_maintenance <<<'
	drop procedure TM_maintenance
END
IF EXISTS (select * from GxQscripts where name='TM_maintenance')
	delete from GxQscripts where name = 'TM_maintenance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_maintenance')
	delete from GXDBVersions where aliasname = 'TM_maintenance'
GO
print '... Creating Procedure: TM_maintenance'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_maintenance
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @xmlText XML = '' OUTPUT
AS
SET NOCOUNT ON
BEGIN TRY
declare @errorCode	int
declare @errorString	NVARCHAR(1024) = ''
DECLARE @ownerId INT
DECLARE @currentTime INT = dbo.GetUnixTime(getdate())
DECLARE @numOfDays INT = ISNULL((SELECT CAST(value AS NVARCHAR(10)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='NumberOfDaysToKeepJobOptionsFromPruning'), 7)
DECLARE @lastWeek INT = @currentTime-(@numOfDays*24*60*60)
DECLARE @requestRows INT = ISNULL((SELECT CAST(value AS NVARCHAR(10)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='jobRequestRowsToPrune'), 10000)
DECLARE @nowUtcTime DATETIME = GETUTCDATE()
DECLARE @nowUtcUnix INT = datediff(second, '01/01/1970', @nowUtcTime)
DECLARE @taskHistoryExpired DATETIME = GETDATE()
SET @taskHistoryExpired = DATEADD(year, -1, @taskHistoryExpired)
-- ASSUME WE WILL HAVE NO ERROR --
set @errorCode = 0
	IF object_id('tempdb.dbo.#output_deleteInfoTable') is not null
		DROP TABLE #output_deleteInfoTable
	CREATE TABLE #output_deleteInfoTable
		(taskId INT, subTaskId INT, patternId INT, subclientId INT, reason NVARCHAR(1024))
	CREATE CLUSTERED INDEX output_deleteInfoTable_taskId_Index1 ON #output_deleteInfoTable ([taskId])
-- -------------------------------------------------------------------------------
-- DELETES THE PATTERN MARKED DELETED
-- -------------------------------------------------------------------------------
DELETE FROM [TM_PatternAssoc]
OUTPUT 0, deleted.subTaskId, deleted.patternId, 0, 'THE PATTERN MARKED DELETED'
INTO #output_deleteInfoTable
WHERE patternId IN ( SELECT patternId FROM  [TM_Pattern] WHERE deleted=1) AND patternId NOT IN ( SELECT DISTINCT PATTERNID FROM dbo.TM_RunTime WHERE runTimeId IN ( SELECT runTimeId FROM dbo.TM_RunTimeAssoc WHERE processed=0))
-- -------------------------------------------------------------------------------
-- DELETES THE SUBTASK FOR WHICH THERE IS NO PATTERN
-- -------------------------------------------------------------------------------
DELETE dbo.TM_SubTask
OUTPUT deleted.taskId, deleted.subTaskId, 0, 0, 'THE SUBTASK FOR WHICH THERE IS NO PATTERN'
INTO #output_deleteInfoTable
FROM dbo.TM_SubTask STK INNER JOIN
dbo.TM_Task T ON T.taskId = STK.taskId
WHERE T.taskType NOT IN ( 0, 1, 3, 5, 8 ) AND STK.defaultTask <> 1
AND subTaskId NOT IN ( SELECT  subtaskId FROM    TM_PatternAssoc  )
AND T.flags&0x4 = 0
-- -------------------------------------------------------------------------------
-- DELETES THE IMMEDIATE TASK WHICH ARE MARKED DELETED
-- -------------------------------------------------------------------------------
DELETE TOP (@requestRows) TM_Task
	OUTPUT deleted.taskId, 0, 0, 0, 'IMMEDIATE TASK MARKED DELETE'
	INTO #output_deleteInfoTable
WHERE taskType = 1 AND deleted = 1
AND flags = 0
-- -------------------------------------------------------------------------------
-- DELETES ONE TIME SCHEDULE TASK
-- -------------------------------------------------------------------------------
DELETE TOP (@requestRows) FROM TM_Task
	OUTPUT deleted.taskId, 0, 0, 0, 'ONE TIME SCHEDULE TASK'
	INTO #output_deleteInfoTable
WHERE taskType&4<>4 AND taskId IN (
	SELECT taskId FROM TM_SubTask WHERE subTaskId IN (
		SELECT subTaskId FROM TM_PatternAssoc WHERE patternId IN (
SELECT patternId FROM TM_Pattern WHERE freq_type&1=1 AND patternId IN (
				SELECT patternId FROM TM_RunTime WHERE processed <> 0
			)
		)
	)
) AND defaultTask <> 1
AND flags = 0
-- -------------------------------------------------------------------------------
-- DELETES THE TASK WHICH ARE ALREADY MARKED DELETED OR DIRTY
-- -------------------------------------------------------------------------------
--DELETE [TM_Task] WHERE status & (CAST(TASK_DELETED as INT) + CAST(TASK_DIRTY as INT))	<>  0		--TASK_DELETED	0x1, TASK_DIRTY      0x4
DELETE TOP (@requestRows) [TM_Task]
OUTPUT deleted.taskId, 0, 0, 0, 'THE TASK WHICH ARE ALREADY MARKED DELETED'
INTO #output_deleteInfoTable
WHERE deleted = 1
AND flags = 0
-- -------------------------------------------------------------------------------
-- MARK DELETE THE IMMEDIATE TASK
-- -------------------------------------------------------------------------------
        UPDATE  TM_Task set deleted = 1
WHERE   taskType = 1
-- -------------------------------------------------------------------------------
-- DELETES THE PATTERN WHICH ARE NO MORE USED
-- -------------------------------------------------------------------------------
DELETE FROM [TM_Pattern]
OUTPUT 0, 0, deleted.patternId, 0, 'UNUSED PATTERN'
INTO #output_deleteInfoTable
WHERE [patternId] NOT IN ( SELECT DISTINCT[patternId]  FROM  [TM_PatternAssoc] )
-- -------------------------------------------------------------------------------
-- DELETES THE TASK FOR WHICH THERE IS NO SUBTASK
-- -------------------------------------------------------------------------------
DELETE  TOP (@requestRows) dbo.TM_Task
OUTPUT deleted.taskId, 0, 0, 0, 'TASK FOR WHICH THERE IS NO SUBTASK'
INTO #output_deleteInfoTable
WHERE dbo.TM_Task.taskId NOT IN ( SELECT taskId FROM dbo.TM_SubTask)
AND dbo.TM_Task.flags=0
-- -------------------------------------------------------------------------------
-- DELETES THE ASSOCIATIONS OF DELETED SUBCLIENTS ON A SCHEDULES/POLICY
-- -------------------------------------------------------------------------------
DELETE AE
OUTPUT deleted.taskId, 0, 0, deleted.subclientId, 'ASSOCIATION FOR WHICH SUBCLIENT IS DELETED'
INTO #output_deleteInfoTable
FROM TM_AssocEntity AE
INNER JOIN TM_Task T ON T.taskId = AE.taskId
AND T.tasktype IN ( 2,4)
INNER JOIN APP_Application APP ON APP.id = AE.subclientId AND AE.assoctype = 7
WHERE APP.subclientStatus & 0x00004 > 0 AND AE.subclientId > 0
-- -------------------------------------------------------------------------------
-- DELETES TASK HISTORY TABLES
-- -------------------------------------------------------------------------------
DELETE TM_TaskHistory
WHERE created < @taskHistoryExpired
-- -------------------------------------------------------------------------------
-- DELETES THE PROCESSED RUN TIMES EXCEPT THE MOST RECENT ONE
-- -------------------------------------------------------------------------------
DELETE  TOP (@requestRows) TM_RunTime FROM TM_RunTime A
WHERE A.processed = 1
AND A.nextRunTime < (SELECT MAX(B.nextRunTime) FROM TM_RunTime B
		   WHERE B.processed = 1 AND B.patternId = A.patternId)
AND NOT EXISTS (SELECT 1 FROM TM_RunTimeAssoc C WHERE C.runTimeId = A.runTimeId AND C.processed = 0)
-----------------------------------------------------------------------------------------------------------------------------
-- DELETES THE JOB COUNTER TABLE. THIS IS SAFE BECAUSE JOB ID IS SAVED AS TABLE IDENTITY AND IT EXISTS UNTIL TRUNCATE IS DONE
-----------------------------------------------------------------------------------------------------------------------------
DELETE GxJobCounter
-----------------------------------------------------------------------------------------------------------------------------
--DELETE JOB REQUESTS WHICH DO NOT HAVE ANY JOBID
-----------------------------------------------------------------------------------------------------------------------------
-- Adding status 1 here in case JM processed job entry from tm_jobs but didnt mark it processed. Else on service restart
-- it will pick it up and process it again.
DELETE TOP (@requestRows) TM_JobRequest
FROM TM_JobRequest JR
LEFT OUTER JOIN TM_Jobs TJ WITH (NOLOCK) ON TJ.jobRequestId = JR.jobRequestId
WHERE NOT EXISTS(SELECT 1
	FROM TM_JobOptions JM WITH(READUNCOMMITTED)
	INNER JOIN TM_Jobs TM WITH(READUNCOMMITTED) ON TM.jobId = JM.jobId
	WHERE TM.jobRequestId = JR.jobRequestId) -- JOB OPTION IS PRUNED AND
	AND created < @lastWeek
	AND
	(
		TJ.status IN (1,2)	--JOB HAS BEEN PICKED UP BY JOB MANAGER
		OR
		TJ.status IS NULL	--ENTRY WAS DELETED IN AppPruneJobOptions.SP
	)
-----------------------------------------------------------------------------------------------------------------------------
--DELETE AUTO COPY SYNTHETIC JOB REQUESTS WHICH HAVE BEEN PROCESSED
-----------------------------------------------------------------------------------------------------------------------------
DELETE TOP (@requestRows) TM_JobSyntheticRequest
FROM TM_JobSyntheticRequest JR
	WHERE status&2 = 2 AND JR.created < @lastWeek
	AND JR.created < (SELECT MAX(created) FROM TM_JobSyntheticRequest WHERE subTaskId = JR.subTaskId AND subclientId = JR.subClientId) --DO NOT DELETE THE LAST ROW
DELETE TM_JobSyntheticRequest
FROM TM_JobSyntheticRequest JR
WHERE NOT EXISTS (SELECT 1 FROM TM_SubTask S WHERE S.subTaskId = JR.subTaskId)
-----------------------------------------------------------------------------------------------------------------------------
-- DELETES CREATE TASK REQUEST ENTRIES THAT HAVE BEEN PROCESSED AND ARE OLDER THAN A WEEK
-----------------------------------------------------------------------------------------------------------------------------
DELETE TM_CreateTaskRequest WHERE processed=1 AND created < @lastWeek
Update NTQueryList
set taskId = 0
where taskId not in
(
	select TM_task.TaskId from TM_task with (nolock)
	where deleted <> 1
)
-- For all deleted tasks, reset the taskId mapping to 0.
Update NTNotificationQueryMapping
set taskId = 0,isscheduled = 0,nextRunTime = DATEADD(SECOND,NTQueryList.defaultFrequency,GetUTCDate())
from NTQueryList with (nolock)
where NTNotificationQueryMapping.taskId not in
(
	select TM_task.TaskId from TM_task with (nolock)
	where deleted <> 1
)
and NTQueryList.queryId = NTNotificationQueryMapping.queryId
and NTNotificationQueryMapping.taskId <> 0
-- Delete all dangling custom query schedules
Update TM_Task
set deleted = 1
from TM_Task
inner join TM_Subtask on
TM_Task.taskid=TM_Subtask.taskId
inner join
(
	select subtaskId from tm_subtask
	where operationType=5014
	except
	select subtaskId from TM_SubtaskOptions
	where optionid = 1546197960 -- Ignore web schedules for metrics alerts.
) subTasks
on subTasks.subtaskId = TM_Subtask.subtaskId
where TM_Task.taskId not in
(
	select TaskId from NTQueryList with (nolock)
	union
	select taskId from NTNotificationQueryMapping with (nolock)
)
-- update flags to 0 for EDiscovery flag tasks when it is deleted, so that next time maintenance happens they are cleared
UPDATE TM_Task
SET flags = 0
WHERE flags & 0x80000 <> 0 AND deleted = 1
-----------------------------------------------------------------------------------------------------------------------------
-- DELETES VSA REPLICATION INFORMATION
-----------------------------------------------------------------------------------------------------------------------------
IF object_id('tempdb.dbo.#replicationIdTable') is not null
	DROP TABLE #replicationIdTable
SELECT T.replicationId
INTO #replicationIdTable
FROM
(
	SELECT replicationId, taskId
	FROM APP_VSAReplication VR
	WHERE NOT EXISTS (SELECT * FROM TM_Task T WITH (NOLOCK) WHERE T.taskId = VR.taskId)	--SCHEDULE GOT DELETED
	UNION
	SELECT replicationId, taskId
	FROM APP_VSAReplication VR
	WHERE flags & 1 = 1		--MARK FOR DELETION
) T
WHERE NOT EXISTS (
	SELECT 1 FROM JMRstJobInfo JR WITH (NOLOCK) --TABLE STORES THE SUBTASK NOT THE TASK ID
	JOIN TM_JobOptions JO (NOLOCK) ON JO.subTaskId = JR.rstTaskID	--ONLY WAY TO GET THE TASK ID IF TASK IS DELETED
	WHERE JO.taskId = T.taskId
	)
update T
set deleted =1
from TM_Task T
inner join APP_VSAReplicationProp prop
on prop.propertyTypeId = 2212
and prop.modified =0
and prop.propertyValue = T.taskid
inner join #replicationIdTable rep
on prop.replicationId = rep.replicationId
DELETE APP_VSAReplicationProp
FROM APP_VSAReplicationProp
WHERE replicationId IN (SELECT replicationId FROM #replicationIdTable)
DELETE APP_VSAReplication
WHERE replicationId IN (SELECT replicationId FROM #replicationIdTable)
IF object_id('tempdb.dbo.#replicationIdTable') is not null
	DROP TABLE #replicationIdTable
-----------------------------------------------------------------------------------------------------------------------------
-- DELETES LIVE SYNC REPLICATION INFORMATION
-----------------------------------------------------------------------------------------------------------------------------
DELETE APP_LiveSyncReplication
FROM APP_LiveSyncReplication LS
LEFT OUTER JOIN TM_Task T (NOLOCK) ON T.taskId = LS.taskId
LEFT OUTER JOIN JMRstJobInfo JR (NOLOCK) ON JR.rstTaskID = LS.subTaskId
WHERE JR.rstTaskID IS NULL AND (T.taskId IS NULL OR (LS.flags&1)>0 )
-- Flags = 1 indicates replication pair deleted
--Delete all dangling LM search schedules
Update TM_Task
set deleted = 1
where taskId in
(
	select taskId from TM_subtask with (nolock)
	where operationType = 5015
)
AND taskId NOT IN
(
	SELECT DISTINCT subtask.taskId FROM
	TM_SubTask subtask WITH (NOLOCK) INNER JOIN TM_SubTaskOptions subtaskoptions WITH (NOLOCK)
		ON subtaskoptions.optionId = 951244723 AND subtask.subTaskId = subtaskoptions.subTaskId
			 INNER JOIN LMUserSearch lmsearch WITH(NOLOCK)
	ON  lmsearch.status <> 1 AND value = lmsearch.searchId
)
-----------------------------------------------------------------------------------------------------------------------------
-- DELETES DR VM Failback and Backup taskIds from APP_VSAReplicationProp when schedule isn't found in TM_Task
-----------------------------------------------------------------------------------------------------------------------------
delete VSRepProp
FROM   APP_VSAReplicationProp  VSRepProp
left join tm_task t
on VSRepProp.propertyValue = t.taskId
where VSRepProp.propertyTypeId in (2204, 2212) --(2204, 2212)
and t.taskid is null
-- Having a try catch below to avoid blocking TM Maintenance.
BEGIN TRY
	DECLARE @filterJobCompletedUnixTime INT = dbo.getunixtime(getutcdate()) - 15*60 -- 15 mins before current time.. Remove all jobs which completed before this time from subscription list.
	IF object_id('tempdb.dbo.#jobsToDeleteFromSubscriptionFilter') is not null
		DROP TABLE #jobsToDeleteFromSubscriptionFilter
	CREATE table #jobsToDeleteFromSubscriptionFilter
	(
		subscriptionId INT ,
		jobId INT
		PRIMARY KEY(subscriptionId,jobId)
	)
	INSERT INTO #jobsToDeleteFromSubscriptionFilter(subscriptionId,jobId)
	SELECT DISTINCT NS.subscriptionId,x.value('@val','int') JobId
	FROM App_NotificationSubscription (NOLOCK) NS
	CROSS APPLY NS.filter.nodes('Api_NotificationFilter/filterIds/entityIds') M(x)
	LEFT JOIN JMBkpStats (NOLOCK) ON JMBkpStats.jobId = x.value('@val','int') AND JMBkpStats.commCellId=2
	AND JMBkpStats.servEndDate <= @filterJobCompletedUnixTime
	LEFT JOIN JMRestoreStats (NOLOCK) ON JMRestoreStats.jobId = x.value('@val','int') AND JMRestoreStats.commCellId=2
	AND JMRestoreStats.servEndTime <= @filterJobCompletedUnixTime
	LEFT JOIN JMAdminJobStatsTable (NOLOCK) ON JMAdminJobStatsTable.jobId = x.value('@val','int') AND JMAdminJobStatsTable.commCellId=2
	AND JMAdminJobStatsTable.servEnd <= @filterJobCompletedUnixTime
	where NS.Type = 0 AND NS.filter.value('(Api_NotificationFilter/@subType)[1]', 'int') = 14
	AND (JMBkpStats.jobId IS NOT NULL OR JMRestoreStats.jobId IS NOT NULL OR JMAdminJobStatsTable.jobId IS NOT NULL)
	UPDATE App_NotificationSubscription
	SET filter.modify('delete //Api_NotificationFilter/filterIds/entityIds[contains(sql:column("jobsToDelete.jobIds"), concat(concat(",",@val),"," ) )]')
	FROM App_NotificationSubscription
	INNER JOIN
	(
		SELECT DISTINCT jobsToDeleteFromSubscriptionFilter.subscriptionId,
			(SELECT ','+CONVERT(NVARCHAR(10), INNERTbl.jobId)
				FROM #jobsToDeleteFromSubscriptionFilter INNERTbl
				WHERE INNERTbl.subscriptionId = jobsToDeleteFromSubscriptionFilter.subscriptionId
				FOR XML PATH('')
			)+',' jobIds
			FROM #jobsToDeleteFromSubscriptionFilter jobsToDeleteFromSubscriptionFilter
	) jobsToDelete
	ON jobsToDelete.subscriptionId = App_NotificationSubscription.subscriptionId
	WHERE Type = 0 AND filter.value('(Api_NotificationFilter/@subType)[1]', 'int') = 14
	IF object_id('tempdb.dbo.#jobsToDeleteFromSubscriptionFilter') is not null
		DROP TABLE #jobsToDeleteFromSubscriptionFilter
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
END CATCH
-----------------------------------------------------------------------------------------------------------------------------
-- DELETES EXPIRED OPERATION WINDOWS
-----------------------------------------------------------------------------------------------------------------------------
DELETE
FROM APP_OpWindowRule
WHERE @nowUtcUnix > (endDate+endTime+(24*60*60))	--ADD 1 DAY FOR DIFFERENT CLIENT TIME ZONE
AND endDate > 0
DELETE FROM APP_OpWindowRule
WHERE clientGroupId <> 0 AND NOT EXISTS(SELECT 1 FROM APP_ClientGroup WITH(NOLOCK) WHERE id = clientGroupId)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
    -- Call procedure to get error information.
    EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
END CATCH;
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
	SET @xmlText = (
		SELECT @errorCode '@errorCode', @errorString '@errorString',
		(
			SELECT RI.taskId '@taskId', RI.subTaskId '@subTaskId', RI.patternId '@patternId', RI.subclientId '@subclientId', RI.reason '@runTimeId'
			FROM #output_deleteInfoTable RI
			FOR XML PATH('Info'), TYPE
		)
		FOR XML PATH('LoggingMaintenanceResponse')
	)
	SELECT @xmlText
	IF object_id('tempdb.dbo.#output_deleteInfoTable') is not null
		DROP TABLE #output_deleteInfoTable
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'TM_maintenance')
	delete from GxQscripts where name = 'TM_maintenance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_maintenance')
	delete from GXDBVersions where aliasname = 'TM_maintenance'
GO

insert into GXDBVersions values(2, 'TM_maintenance',  '00010037000200210000', 'TM_maintenance', '00010037000200210000')
GO

