

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_doesTaskNameExists.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_doesTaskNameExists <<<'

IF EXISTS (select * from sysobjects where name='TM_doesTaskNameExists')
	drop procedure TM_doesTaskNameExists
IF EXISTS (select * from GxQscripts where name='TM_doesTaskNameExists')
	delete from GxQscripts where name = 'TM_doesTaskNameExists'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_doesTaskNameExists')
	delete from GXDBVersions where aliasname = 'TM_doesTaskNameExists'
GO
print '... Creating Procedure: TM_doesTaskNameExists'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_doesTaskNameExists
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML OUTPUT
AS
BEGIN
	DECLARE @errorCode INT = 0
    DECLARE @localeId INT = 0
	DECLARE @errorString NVARCHAR(MAX) = ''
DECLARE @taskType INT = 2
DECLARE @taskName NVARCHAR(255)
DECLARE @subTaskName NVARCHAR(255)
	SELECT @subTaskName=ISNULL(st.value('@subtaskName', 'NVARCHAR(MAX)'), ''), @taskName=ISNULL(st.value('@taskName', 'NVARCHAR(MAX)'), ''), @taskType=ISNULL(ref.value('@taskType', 'INT'), @taskType),
        @localeId=ISNULL(pi.value('locale[1]/@localeId', 'INT'), @localeId)
		FROM @i_xmlText.nodes ('TMMsg_CheckTaskNameExists') R(ref)
		CROSS APPLY ref.nodes('./subTask') S(st)
        OUTER APPLY ref.nodes('./processinginstructioninfo') P(pi)
IF @taskType = 2
    BEGIN
	    IF EXISTS (SELECT 1
	        FROM TM_Task T
            JOIN TM_SubTask S ON S.subTaskName = @subTaskName AND S.taskId = T.taskId AND T.taskType = @taskType
	        WHERE T.deleted = 0
	        AND T.uninstalled = 0
	        AND T.invalid = 0
        )
SET @errorCode = (1442 | (CAST(POWER(2, 24) AS BIGINT) * 35))
    END
ELSE IF @taskType = 4
    BEGIN
	    IF EXISTS (SELECT 1
	        FROM TM_Task T
	        WHERE T.taskType = @taskType
    	    AND T.taskName = @taskName
	        AND T.deleted = 0
	        AND T.uninstalled = 0
	        AND T.invalid = 0
        )
SET @errorCode = (1440 | (CAST(POWER(2, 24) AS BIGINT) * 35))
    END
    IF @errorCode <> 0
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId, @errorCode, 0, 2)
    SET @i_xmlText = (
        SELECT  1           as TAG,
                NULL        as Parent,
            @errorCode      as [TMMsg_GenericResp!1!errorCode],
            @errorString    as [TMMsg_GenericResp!1!errorMessage]
        FOR XML EXPLICIT
    )
	SELECT @i_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_doesTaskNameExists')
	delete from GxQscripts where name = 'TM_doesTaskNameExists'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_doesTaskNameExists')
	delete from GXDBVersions where aliasname = 'TM_doesTaskNameExists'
GO

insert into GXDBVersions values(2, 'TM_doesTaskNameExists',  '00000000000000000000', 'TM_doesTaskNameExists', '00000000000000000000')
GO

