

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_doesReplicationTaskNeedToRun.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_doesReplicationTaskNeedToRun.sp,v $ $Id: TM_doesReplicationTaskNeedToRun.sp,v 1.21.2.45 2020/12/07 22:57:32 mnatarajan Exp $";
---- ============================================================================
---- Author:		Sergio Bonilla
---- Create date:	05/10/2014
---- Description:	Check if a Job Completed schedule needs to run.
---- ============================================================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_doesReplicationTaskNeedToRun')
BEGIN
	print '>>> Drop Stored Procedure: TM_doesReplicationTaskNeedToRun <<<'
	drop procedure TM_doesReplicationTaskNeedToRun
END
IF EXISTS (select * from GxQscripts where name='TM_doesReplicationTaskNeedToRun')
	delete from GxQscripts where name = 'TM_doesReplicationTaskNeedToRun'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_doesReplicationTaskNeedToRun')
	delete from GXDBVersions where aliasname = 'TM_doesReplicationTaskNeedToRun'
GO
print '... Creating Procedure: TM_doesReplicationTaskNeedToRun'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_doesReplicationTaskNeedToRun
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @iSubTaskId INT,
  @initFrom INT = 5,	--SCHEDULE
  @localeId INT,
  @oRunIt INT OUTPUT,
  @oErrorCode integer OUTPUT,
  @oErrorString nvarchar(MAX) OUTPUT,
  @oXmlString XML OUTPUT
AS
SET NOCOUNT ON
BEGIN
	DECLARE @nowTime DATETIME = GETDATE()
	DECLARE @nowUtcTime DATETIME = GETUTCDATE()
	DECLARE @runTimeId INT = 0
	DECLARE @taskId INT = 0
	DECLARE @nowUtcUnix INT = datediff(second, '01/01/1970', @nowUtcTime)
	DECLARE @nowTimeUnix INT = datediff(second, '01/01/1970', @nowTime)
	DECLARE @timeZoneName NVARCHAR(MAX) = ISNULL((SELECT dbo.GetClientTimeZone(2)), '')
	DECLARE @disableVMRevertReplication INT = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='disableVMRevertReplication'), 0)
	DECLARE @runTimeInfoTable TABLE (stId INT, subtaskName NVARCHAR(MAX), tkId INT, freqType INT, repGuid NVARCHAR(MAX), sourceGuid NVARCHAR(MAX), cgId INT, clId INT, apId INT, instId INT, bsId INT, scId INT, lastSuccessBkupTime INT, opType INT, auxJobEndTime INT, isScheduleUsingAllocationPolicy INT DEFAULT 0,
	copyPrecedenceApplicable INT default 0, copyPrecedence INT default 1, isIndexingV2Enabled INT DEFAULT 0)
	DECLARE @vsaInfoTable TABLE (stId INT, subtaskName NVARCHAR(MAX), tkId INT, repGuid NVARCHAR(MAX), sourceGuid NVARCHAR(MAX), sourceName NVARCHAR(MAX), destinationName NVARCHAR(MAX), cgId INT, clId INT, apId INT, instId INT, bsId INT, scId INT,
									lastSuccessBkupTime INT, opType INT, jId BIGINT, copyPrecedenceApplicable INT, copyPrecedence INT, freqType INT, spare1 NVARCHAR(MAX), spare2 NVARCHAR(MAX), status INT, replicationId INT, lastVSATime INT,
maxNumOfVMPerJob INT, flags INT, jobEndTime INT, lastBkpJobId INT, bkpJobsToSync VARCHAR(1024) default '', isIndexingV2Enabled INT DEFAULT 0)
	DECLARE @auxCopyTable TABLE (subTaskId INT, subclientId INT, archGrpId INT, archGrpCopy INT, maxCopiedTime INT, maxJobEndTime INT, fullCycleNumFullBackup INT DEFAULT 0)
	DECLARE @replicationTable TABLE (replicationId INT, optionId BIGINT)
	DECLARE @runIndividualVM INT = 0
DECLARE @runIndividualReplicationForVMV2 INT = ISNULL((SELECT CAST(value AS NVARCHAR(1024)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='RunIndividualReplicationForVMV2' AND Modified = 0), 0) -- In minutes. Convert it to seconds below.
	DECLARE @VSAREP_COMPLETE INT = 1
	DECLARE @VSAREP_PENDING INT = 2
	DECLARE @VSAREP_RUNNING INT = 3
	DECLARE @VSAREP_PAUSED INT = 4
	DECLARE @VSAREP_FAILED INT = 5
	DECLARE @VSAREP_DISABLED INT = 6
	DECLARE @VSAREP_ENABLED INT = 7
	DECLARE @VSAREP_VALIDATION_FAILED INT = 8
	DECLARE @VSAREP_JOB_QUEUED INT = 9
	DECLARE @VSAREP_REVERT_FAILED INT = 10
	DECLARE @VSAREP_STARTING INT = 11
	DECLARE @repJobId INT = 0
	--FAILOVERSTATUS VALUE
	DECLARE @VSAREP_FAILBACK_RUNNING INT = 6
	--FLAG VALUES
	DECLARE @VSAREP_DELETED INT = 1
	DECLARE @STARTED_SYNC_IMMEDIATE	INT = 2
	DECLARE @VSAREP_REVERSE_REP INT = 4
	DECLARE @scIdForDistribute INT = NULL
	DECLARE @isIndexingV2 INT = 0
	SET @oRunIt = 0
	IF object_id('tempdb.dbo.#fullCycleInfo ') is not null
		DROP TABLE #fullCycleInfo
	CREATE TABLE #fullCycleInfo(subTaskId INT, subclientId INT, archGrpId INT, archGrpCopyId INT, fullCycleNum INT, copyPrecedence INT, backupLevel INT)
	CREATE CLUSTERED INDEX fullCycleInfo_subTaskId_subclientId_Idx ON #fullCycleInfo(subTaskId, subclientId)
	IF EXISTS (SELECT 1 FROM JMJobAction WHERE clientId=1 AND appType=0 AND mediaAgentID=1 AND opType=1 AND appId=1 AND action=1)
	BEGIN
SET @oErrorCode = (645 | (CAST(POWER(2, 24) AS BIGINT) * 19))
		SET @oErrorString = dbo.fn_EvFormatEventMsgText(0, 0, @oErrorCode, 0, 2)
		GOTO EXIT_SP
	END
	IF object_id('tempdb.dbo.#xmlOption_InfoTable') is not null
		DROP TABLE #xmlOption_InfoTable
	CREATE TABLE #xmlOption_InfoTable(jobId INT, replicationID INT)
	CREATE CLUSTERED INDEX xmlOption_InfoTable_jobId_Index1 ON #xmlOption_InfoTable (replicationId)
	INSERT INTO @runTimeInfoTable
	SELECT ST.subTaskId, ST.subTaskName, ST.taskId, PT.freq_type, '' repGuid, '' sourceGuid, AE.clientGroupId, AE.clientId, AE.apptypeId, AE.instanceId, AE.backupsetId, AE.subclientId, 0 lastSuccessBkupTime, ST.operationType, 0 auxJobEndTime,0 isScheduleUsingAllocationPolicy, 0 copyPrecedenceApplicable,0 copyPrecedence,
	CASE WHEN App_ClientProp.componentNameID IS NULL THEN 0 ELSE 1 END
	FROM TM_SubTask ST WITH (NOLOCK)
	JOIN TM_AssocEntity AE WITH (NOLOCK) ON AE.taskId = ST.taskId
	LEFT OUTER JOIN TM_PatternAssoc PA WITH (NOLOCK) ON PA.subTaskId = ST.subTaskId  --OUTER JOIN NEEDED BECAUSE IMMEDIATE JOBS DO NOT HAVE A PATTERN
	LEFT OUTER JOIN TM_Pattern PT WITH (NOLOCK) ON PT.patternId = PA.patternId
	LEFT OUTER JOIN TM_RunTime RT WITH (NOLOCK) ON RT.patternId = PT.patternId AND RT.processed = 1
	LEFT JOIN App_ClientProp WITH (NOLOCK) ON App_ClientProp.componentNameID =  AE.clientId AND App_ClientProp.attrName='IndexingV2_VSA' AND App_ClientProp.modified=0 AND App_ClientProp.attrVal=N'1' --CV_PROP_VSA_INDEXING_V2 Check client is VSAv2 enabled.
WHERE ST.subTaskId = @iSubTaskId AND ST.operationType = 1007
	GROUP BY ST.subTaskId, ST.subTaskName, ST.taskId, PT.freq_type, AE.clientGroupId, AE.clientId, AE.apptypeId, AE.instanceId, AE.backupsetId, AE.subclientId, ST.operationType,App_ClientProp.componentNameID
	IF EXISTS(SELECT 1 FROM @runTimeInfoTable)
	BEGIN
			Update runTimeInfoTable
			set isScheduleUsingAllocationPolicy=1
			from @runTimeInfoTable runTimeInfoTable
			inner join TM_Subtaskoptions with (nolock) on runTimeInfoTable.stId=TM_Subtaskoptions.subtaskId
and TM_Subtaskoptions.optionId=1264497636
			and TM_Subtaskoptions.value='1'
			-- Update copy precedence for allocation policy schedules from copyPrecedence fields. In case allocation policy schedule has copyPrecedence specified and not Storagepolicy/copy.
			UPDATE runTimeInfoTable
			SET copyPrecedence=CONVERT(INT,TM_Subtaskoptions.value)
			from @runTimeInfoTable runTimeInfoTable
			INNER JOIN TM_Subtaskoptions with (nolock) on runTimeInfoTable.stId=TM_Subtaskoptions.subtaskId
and TM_Subtaskoptions.optionId=957862300
			and isScheduleUsingAllocationPolicy=1
			-- Update copyPrecedence for allocation policy schedules.
			Update runTimeInfoTable
			set copyPrecedence=ArchGroupcopy.copy
			from @runTimeInfoTable runTimeInfoTable
			inner join TM_Subtaskoptions with (nolock) on runTimeInfoTable.stId=TM_Subtaskoptions.subtaskId
and TM_Subtaskoptions.optionId=1019965049
			inner join ArchGroupcopy with (nolock) on TM_Subtaskoptions.value=convert(nvarchar(max),ArchGroupcopy.id)
			and isScheduleUsingAllocationPolicy=1
			Update runTimeInfoTable
			set copyPrecedenceApplicable=1
			from @runTimeInfoTable runTimeInfoTable
			where isScheduleUsingAllocationPolicy=1 and copyPrecedence>1
			IF object_id('tempdb.dbo.#subclientListTbl') is not null
				DROP TABLE #subclientListTbl
			CREATE TABLE #subclientListTbl(subclientId int primary key(subclientId) )
			IF object_id('tempdb.dbo.#taskReplicationguidPair') is not null
				DROP TABLE #taskReplicationguidPair
			CREATE TABLE #taskReplicationguidPair
			(
				taskId int,
				replicationGuid nvarchar(256)
				primary key(taskId) )
			Insert into #subclientListTbl
			select distinct scId from @runTimeInfoTable
			where isScheduleUsingAllocationPolicy=1
			Insert into #taskReplicationguidPair(taskId,replicationGuid)
			select distinct tkId,'' from @runTimeInfoTable
			where isScheduleUsingAllocationPolicy=1
			update taskReplicationguidPair
			set replicationGuid=App_VSAReplication.replicationGuid
			from #taskReplicationguidPair taskReplicationguidPair inner join App_VSAReplication with (nolock) on
			taskReplicationguidPair.taskId=App_VSAReplication.taskId
			update #taskReplicationguidPair
			set replicationGuid=newid()
			where replicationGuid is null or len(replicationGuid)=0
			-------------------------------------------------------------------------------------------------------------------------------------------
--- CODE BELOW HERE IS FROM TM_GetVMSubclientContent.spb  ----------
-- in order to use variables to be declared are : INPUT : temp table #subclientListTbl which has list of subclients.
	IF object_id('tempdb.dbo.#subclientContent_InfoTable') is not null
		DROP TABLE #subclientContent_InfoTable
	CREATE TABLE #subclientContent_InfoTable(subclientId INT, vmClientId INT, VMGuid nvarchar(256), VMName nvarchar(1024),vmJobId INT, childVMScId INT)
	CREATE CLUSTERED INDEX subclientContent_InfoTable_subclientId_VMClientId_Index1 ON #subclientContent_InfoTable (subclientId,vmClientId)
	-- Get Latest Job cycle. From that job cycle, get all vm's along with there status in that cycle mapped with latest job id for that vm
	-- Have the child VM subclient same as parent subclient by default.
			INSERT INTO #subclientContent_InfoTable( vmclientId,vmJobId, subclientId, childVMScId)
			SELECT AVM.VMclientId AS vmClientId, MAX(JB.jobId) AS jobId, JFC.ScId as ScId, JFC.ScId FROM APP_VMProp AVM WITH (NOLOCK)
					INNER JOIN JMBkpStats JB WITH (NOLOCK)
					ON JB.jobId = AVM.jobId
					INNER JOIN (
						SELECT MAX(fullCycleNum) AS jobFullCycle,
						subclientListTbl.subclientId as scId
						FROM   JMBkpStats JM WITH (NOLOCK)
						INNER JOIN #subclientListTbl subclientListTbl on
						JM.appId = subclientListTbl.subclientId AND JM.status in (1,3,14,16)
						and JM.commcellId=2
						group by subclientListTbl.subclientId ) JFC
					ON JFC.jobFullCycle=JB.fullCycleNum AND JB.appId=JFC.ScId
					and JB.commcellId=2
					and AVM.attrName='vmStatus' AND AVM.attrVal IN ('0', '3')
					GROUP BY AVM.VMclientId,JFC.ScId
			update subclientContent_InfoTable
			set VMGuid=App_vmprop.attrVal
			from #subclientContent_InfoTable subclientContent_InfoTable
			inner join App_vmprop WITH (NOLOCK)
			on subclientContent_InfoTable.vmJobId=APP_VMProp.jobId and APP_VMProp.commCellId=2
			and APP_VMProp.VMclientId=subclientContent_InfoTable.vmClientId
			and APP_VMProp.attrName='vmguid'
			update subclientContent_InfoTable
			set VMName=App_ClientProp.attrval
			from #subclientContent_InfoTable subclientContent_InfoTable
			INNER JOIN App_clientProp WITH (NOLOCK) ON App_clientProp.componentnameID = subclientContent_InfoTable.vmClientId
			AND App_ClientProp.attrname='Virtual machine name' --CV_PROP_VIRTUAL_SERVER_VM_NAME
			AND App_ClientProp.modified = 0
			-- Update subclientId with child subclient for V2 VSA
			UPDATE subclientContent_InfoTable
			SET  childVMScId = CHILD.ID
			FROM #subclientContent_InfoTable subclientContent_InfoTable
			INNER JOIN App_Application PARENT (NOLOCK) ON subclientContent_InfoTable.subclientId = PARENT.Id
			INNER JOIN App_ClientProp PARENTCLIENT (NOLOCK) ON PARENTCLIENT.ComponentnameId = PARENT.clientId
			AND PARENTCLIENT.attrName='IndexingV2_VSA' AND PARENTCLIENT.modified=0 AND PARENTCLIENT.attrVal=N'1' --CV_PROP_VSA_INDEXING_V2 ensure client is VSAv2 enabled.
			INNER JOIN APP_VMBackupSet (NOLOCK) ON PARENT.backupSet = APP_VMBackupSet.ParentBackupSetId
			INNER JOIN App_Application CHILD (NOLOCK) ON CHILD.backupSet = APP_VMBackupSet.ChildBackupSetId
			AND (CHILD.subclientstatus & (4|2))=0   --- We dont want deleted and uninstalled subclients _CV_STATUS_DELETED| CV_STATUS_UNINSTALLED
			AND CHILD.clientId = subclientContent_InfoTable.vmclientId -- Identify the correct child client based on VM Guid.
--- CODE ABOVE HERE IS FROM TM_GetVMSubclientContent.spb  ----------
			-------------------------------------------------------------------------------------------------------------------------------------------
		INSERT INTO @vsaInfoTable
		(stId, subtaskName, tkId, repGuid, sourceGuid, sourceName, destinationName, cgId, clId, apId, instId, bsId, scId, lastSuccessBkupTime, opType, jId, copyPrecedenceApplicable, copyPrecedence,
			freqType, spare1, spare2, status, replicationId, lastVSATime, maxNumOfVMPerJob, flags, jobEndTime, lastBkpJobId,isIndexingV2Enabled)
		SELECT stId, subtaskName, tkId, replicationGuid, sourceGuid, sourceName, destinationName, cgId, clId, apId, instId, bsId, scId, MAX(lastSuccessBkupTime), opType, MAX(jobId), copyPrecedenceApplicable, copyPrecedence,
			freqType, '' spare1, '' spare2, 0 status, 0 replicationId, 0 lastVSATime, 0 maxNumOfVMPerJob, 0 flags, 0 jobEndTime, 0 lastBkpJobId,isIndexingV2Enabled
		FROM
		(
			-- V1 Commcell console schedules and admin console schedules where VMs are in live sync schedule and latest backuptime
			-- comes from App_VMProp and JMBkpstats
			SELECT RI.stId, RI.subtaskName, RI.tkId, vs.value('virtualServerRstOption[1]/@replicationGuid', 'NVARCHAR(MAX)') replicationGuid, ad.value('@guid', 'NVARCHAR(MAX)') sourceGuid,
			ad.value('@name', 'NVARCHAR(MAX)') sourceName, ad.value('@newName', 'NVARCHAR(MAX)') destinationName, RI.cgId, RI.clId, RI.apId, RI.instId, RI.bsId, RI.scId, RI.opType, JB.servEndDate lastSuccessBkupTime,
			JB.jobId, vs.value('browseOption[1]/mediaOption[1]/copyPrecedence[1]/@copyPrecedenceApplicable', 'INT') copyPrecedenceApplicable, vs.value('browseOption[1]/mediaOption[1]/copyPrecedence[1]/@copyPrecedence', 'INT') copyPrecedence,
			RI.freqType, 0 maxNumOfVMPerJob,RI.isIndexingV2Enabled
			FROM @runTimeInfoTable RI
			JOIN TM_SubTaskXMLOptions SO WITH (NOLOCK) ON SO.subTaskId = RI.stId
			AND RI.isScheduleUsingAllocationPolicy=0
			AND RI.isIndexingV2Enabled = 0
			CROSS APPLY SO.xmlValue.nodes('TMMsg_JobOption/restoreOptions') V(vs)
			CROSS APPLY	vs.nodes('./virtualServerRstOption/diskLevelVMRestoreOption') D(dl)
			CROSS APPLY	dl.nodes('./advancedRestoreOptions') A(ad)
			JOIN APP_VMProp VP WITH (NOLOCK) ON VP.attrVal=ad.value('@guid', 'NVARCHAR(MAX)') AND VP.attrName='vmGUID'
			JOIN APP_VMProp VM (NOLOCK) ON VM.jobId = VP.jobId AND VM.VMclientId = VP.VMclientId AND VM.attrName='vmStatus' AND VM.attrVal IN ('0', '3')	--CHECK FOR VM BACKUP STATUS 0 (COMPLETED) OR 3 (PARTIAL SUCCESS)
			JOIN APP_Application APP (NOLOCK) ON
				(
					APP.id = RI.scId
					OR
					(
						RI.scId IN (0, -1)
						AND
						APP.backupSet = RI.bsId
					)
				)
			JOIN JMBkpStats JB WITH (NOLOCK) ON JB.jobId = VM.jobId
				AND JB.appId = APP.id
				AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
				AND JB.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/)
			UNION
			-- V1 admin console schedules where VMs are in subclient content and latest backuptime comes from App_VMProp and JMBkpstats
			SELECT distinct RI.stId, RI.subtaskName, RI.tkId, taskReplicationguidPair.replicationGuid , CT.VMGuid sourceGuid,
			CT.VMName sourceName, '' destinationName, RI.cgId, RI.clId, RI.apId, RI.instId, RI.bsId, RI.scId, RI.opType, JB.servEndDate lastSuccessBkupTime,
			JB.jobId,  RI.copyPrecedenceApplicable, RI.copyPrecedence,
			RI.freqType, 0 maxNumOfVMPerJob,RI.isIndexingV2Enabled
			FROM @runTimeInfoTable RI
			JOIN TM_SubTaskXMLOptions SO WITH (NOLOCK) ON SO.subTaskId = RI.stId
			JOIN #taskReplicationguidPair taskReplicationguidPair ON taskReplicationguidPair.taskId = RI.tkId
			AND RI.isScheduleUsingAllocationPolicy=1
			AND RI.isIndexingV2Enabled = 0
			LEFT JOIN App_ClientProp WITH (NOLOCK) ON App_ClientProp.componentNameID = RI.clId AND App_ClientProp.attrName='IndexingV2_VSA' AND App_ClientProp.modified=0 AND App_ClientProp.attrVal=N'1' --CV_PROP_VSA_INDEXING_V2 Check client is VSAv2 enabled.
			JOIN #subclientContent_InfoTable CT ON CT.subclientId = RI.scId
			CROSS APPLY SO.xmlValue.nodes('TMMsg_JobOption/restoreOptions') V(vs)
			CROSS APPLY	vs.nodes('./virtualServerRstOption/diskLevelVMRestoreOption') D(dl)
			JOIN APP_VMProp VM (NOLOCK) ON VM.VMclientId = CT.VMclientId AND VM.attrName='vmStatus' AND VM.attrVal IN ('0', '3')	--CHECK FOR VM BACKUP STATUS 0 (COMPLETED) OR 3 (PARTIAL SUCCESS)
			JOIN APP_Application APP (NOLOCK) ON
				(
					APP.id = RI.scId
					OR
					(
						RI.scId IN (0, -1)
						AND
						APP.backupSet = RI.bsId
					)
				)
			JOIN JMBkpStats JB WITH (NOLOCK) ON JB.jobId = VM.jobId
				AND JB.appId = APP.id
				AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
				AND JB.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/)
			UNION
			-- V2 admin console schedules where VMs are in subclient content and latest backuptime comes from child VMs backup time.
			SELECT distinct RI.stId, RI.subtaskName, RI.tkId, taskReplicationguidPair.replicationGuid , CT.VMGuid sourceGuid,
			CT.VMName sourceName, '' destinationName, RI.cgId, App_Application.clientId, App_Application.appTypeId, App_Application.instance, App_Application.backupset, App_Application.id,
			RI.opType, JB.servEndDate lastSuccessBkupTime,
			JB.jobId,  RI.copyPrecedenceApplicable, RI.copyPrecedence,
			RI.freqType, 0 maxNumOfVMPerJob,RI.isIndexingV2Enabled
			FROM @runTimeInfoTable RI
			JOIN TM_SubTaskXMLOptions SO WITH (NOLOCK) ON SO.subTaskId = RI.stId
			JOIN #taskReplicationguidPair taskReplicationguidPair ON taskReplicationguidPair.taskId = RI.tkId
			AND RI.isScheduleUsingAllocationPolicy=1
			AND RI.isIndexingV2Enabled = 1
			JOIN #subclientContent_InfoTable CT ON CT.subclientId = RI.scId
			CROSS APPLY SO.xmlValue.nodes('TMMsg_JobOption/restoreOptions') V(vs)
			CROSS APPLY	vs.nodes('./virtualServerRstOption/diskLevelVMRestoreOption') D(dl)
			INNER JOIN APP_VMBackupSet (NOLOCK) ON RI.bsId = APP_VMBackupSet.ParentBackupSetId
			INNER JOIN App_Application  (NOLOCK) ON App_Application.backupSet = APP_VMBackupSet.ChildBackupSetId
			AND App_Application.clientID = CT.VMClientId
			AND (App_Application.subclientstatus & (4|2))=0   --- We dont want deleted and uninstalled subclients _CV_STATUS_DELETED| CV_STATUS_UNINSTALLED
			JOIN JMBkpStats JB WITH (NOLOCK) ON JB.appId = App_Application.id
				AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
				AND JB.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/) -- No need to start replication after synthfull backup
			UNION
			-- V2 To handle scenario where live sync is configured at VSA level.
			SELECT RI.stId, RI.subtaskName, RI.tkId, vs.value('virtualServerRstOption[1]/@replicationGuid', 'NVARCHAR(MAX)') replicationGuid, ad.value('@guid', 'NVARCHAR(MAX)') sourceGuid,
			ad.value('@name', 'NVARCHAR(MAX)') sourceName, ad.value('@newName', 'NVARCHAR(MAX)') destinationName, RI.cgId, CHILD.clientId, CHILD.appTypeId, CHILD.instance, CHILD.backupset, CHILD.Id, RI.opType, JB.servEndDate lastSuccessBkupTime,
			JB.jobId, vs.value('browseOption[1]/mediaOption[1]/copyPrecedence[1]/@copyPrecedenceApplicable', 'INT') copyPrecedenceApplicable, vs.value('browseOption[1]/mediaOption[1]/copyPrecedence[1]/@copyPrecedence', 'INT') copyPrecedence,
			RI.freqType, 0 maxNumOfVMPerJob,RI.isIndexingV2Enabled
			FROM @runTimeInfoTable RI
			JOIN TM_SubTaskXMLOptions SO WITH (NOLOCK) ON SO.subTaskId = RI.stId
			AND RI.isScheduleUsingAllocationPolicy=0
			AND RI.isIndexingV2Enabled = 1
			CROSS APPLY SO.xmlValue.nodes('TMMsg_JobOption/restoreOptions') V(vs)
			CROSS APPLY	vs.nodes('./virtualServerRstOption/diskLevelVMRestoreOption') D(dl)
			CROSS APPLY	dl.nodes('./advancedRestoreOptions') A(ad)
			INNER JOIN App_ClientProp PARENTCLIENT (NOLOCK) ON PARENTCLIENT.ComponentnameId = RI.clId
			AND PARENTCLIENT.attrName='IndexingV2_VSA' AND PARENTCLIENT.modified=0 AND PARENTCLIENT.attrVal=N'1' --CV_PROP_VSA_INDEXING_V2 ensure client is VSAv2 enabled.
			INNER JOIN APP_VMBackupSet (NOLOCK) ON RI.bsId = APP_VMBackupSet.ParentBackupSetId
			INNER JOIN App_Application CHILD (NOLOCK) ON CHILD.backupSet = APP_VMBackupSet.ChildBackupSetId
			AND (CHILD.subclientstatus & (4|2))=0   --- We dont want deleted and uninstalled subclients _CV_STATUS_DELETED| CV_STATUS_UNINSTALLED
			INNER JOIN App_Clientprop CHILDCLIENT WITH (NOLOCK) ON CHILDCLIENT.componentNameId = CHILD.clientId -- Identify the correct child client based on VM Guid.
				AND CHILDCLIENT.attrName='Virtual Machine Instance UUID'
				AND CHILDCLIENT.modified = 0
				AND CHILDCLIENT.attrVal = ad.value('@guid', 'NVARCHAR(MAX)')
			JOIN JMBkpStats JB WITH (NOLOCK) ON JB.appId = CHILD.id
				AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
				AND JB.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/)
			UNION
				-- To handle scenario where live sync is configured at VM level instead of VSA level.
				SELECT RI.stId, RI.subtaskName, RI.tkId, vs.value('virtualServerRstOption[1]/@replicationGuid', 'NVARCHAR(MAX)') replicationGuid, ad.value('@guid', 'NVARCHAR(MAX)') sourceGuid,
					ad.value('@name', 'NVARCHAR(MAX)') sourceName, ad.value('@newName', 'NVARCHAR(MAX)') destinationName, RI.cgId, App_Application.clientId, App_Application.appTypeId, App_Application.instance, App_Application.backupset, App_Application.Id, RI.opType, JB.servEndDate lastSuccessBkupTime,
					JB.jobId, vs.value('browseOption[1]/mediaOption[1]/copyPrecedence[1]/@copyPrecedenceApplicable', 'INT') copyPrecedenceApplicable, vs.value('browseOption[1]/mediaOption[1]/copyPrecedence[1]/@copyPrecedence', 'INT') copyPrecedence,
					RI.freqType, 0 maxNumOfVMPerJob,RI.isIndexingV2Enabled
				FROM @runTimeInfoTable RI
				JOIN TM_SubTaskXMLOptions SO WITH (NOLOCK) ON SO.subTaskId = RI.stId
				AND RI.isScheduleUsingAllocationPolicy=0
				AND RI.isIndexingV2Enabled = 1
				CROSS APPLY SO.xmlValue.nodes('TMMsg_JobOption/restoreOptions') V(vs)
				CROSS APPLY	vs.nodes('./virtualServerRstOption/diskLevelVMRestoreOption') D(dl)
				CROSS APPLY	dl.nodes('./advancedRestoreOptions') A(ad)
				INNER JOIN App_Application  (NOLOCK) ON App_Application.backupSet = RI.bsId
				AND (App_Application.id = RI.scId OR RI.scId<=0)
				AND (App_Application.subclientstatus & (4|2))=0   --- We dont want deleted and uninstalled subclients _CV_STATUS_DELETED| CV_STATUS_UNINSTALLED
				INNER JOIN App_Clientprop WITH (NOLOCK) ON App_Clientprop.componentNameId = App_Application.clientId
				AND App_Clientprop.attrName='Virtual Machine Instance UUID'
				AND App_Clientprop.modified = 0
				AND App_Clientprop.attrVal = ad.value('@guid', 'NVARCHAR(MAX)')
				JOIN JMBkpStats JB WITH (NOLOCK) ON JB.appId = App_Application.id
					AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
					AND JB.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/) -- No need to start replication after synthfull backup
WHERE  RI.apId = 106 AND RI.opType = 1007
		) T
		GROUP BY stId, subTaskName, tkId, replicationGuid, sourceGuid, sourceName, destinationName, cgId, clId, apId, instId, bsId, scId, opType, copyPrecedenceApplicable, copyPrecedence, freqType, isIndexingV2Enabled
--
		SELECT @taskId = taskId FROM TM_SubTask (NOLOCK) WHERE subTaskId = @iSubTaskId
		--UPDATE TEMP TABLE FIELDS FROM APP_VSAReplication
		UPDATE @vsaInfoTable
			SET status = VR.status,
			spare1 = VR.spare1,
			spare2 = VR.spare2,
			replicationId = VR.replicationId,
			flags = VR.flags,
			scId = VR.subclientId,
			lastBkpJobId = VR.lastSyncedBkpJob
			FROM (
				SELECT status, lastSyncedBkpJob, replicationGuid, sourceGuid srcGuid, taskId, subclientId, replicationId, spare1, spare2, flags,App_application.backupset
				FROM APP_VSAReplication VR WITH (NOLOCK)
				INNER JOIN App_application ON VR.subclientId = App_application.Id
				WHERE
				(VR.flags & @VSAREP_DELETED) = 0	--DON'T GET ROW FOR VM MARK FOR DELETION OR WE WILL POPULATE THE WRONG INFORMATION
			) VR
			WHERE VR.replicationGuid = repGuid
			AND VR.srcGuid = sourceGuid
			AND VR.taskId = tkId
			AND VR.backupset = bsId --Same VMs could be part of multiple subclients. So we should identify the matching replication entry (from app_Vsareplication) for each entry in
			--@vsaInfoTable
		IF EXISTS(SELECT 1 FROM @vsaInfoTable VSA WHERE VSA.isIndexingV2Enabled = 1)
		BEGIN
			SET @IsindexingV2 = 1
		END
		-- IF replication is initated from schedule, then update last runtime if schedule is for indexing v2.
		-- No need to check for schedule configured at VSA subclient level since we are not supporting configuring schedule at VM level.
		-- if its indexing v2 and configured at vsa level then set scIdForDistribute
		IF @IsindexingV2 = 1
		BEGIN
			-- IF we want to run individual replications for each VM then we neednt set this
			IF @runIndividualReplicationForVMV2=0
			BEGIN
				SELECT @scIdForDistribute = TM_Assocentity.subclientId
				FROM TM_Assocentity (NOLOCK) WHERE TM_Assocentity.taskID = @taskId
			END
			-- Drop replications where job is running already since we allow parallel jobs now.
			INSERT INTO #xmlOption_InfoTable(jobId, replicationID)
			SELECT JR.mJobId, vs.value('@id1', 'INT')
			FROM
			(
				SELECT J.jobId mJobId, CAST(o.Value AS XML) xmlValue
				FROM TM_JobRequest R (NOLOCK)
				JOIN TM_Jobs J ON R.subTaskId = @iSubTaskId AND J.jobRequestId = R.jobRequestId AND J.status IN (0, 1,4097)  -- Refer to SP JMGetJopbsToProcessed there is an intermeridate state where 4096 flag is set
				-- Read only committed rows. To handle synchronization issues where TM submitted job but JM didnt pick it up yet. It could happen that JM didnt insert into JMRstJobInfo above and changed TM_Jobs status to 2 by the time code here is executed.
				-- No need to handle only for max job. So removing group by
				-- GROUP BY V.stId, J.status, V.tkId
JOIN TM_JobOptions O (NOLOCK) ON O.jobId = J.JobId AND O.optionId = 120012
			) JR
			CROSS APPLY JR.xmlValue.nodes('/TMMsg_EntityListResp/entities') V(vs)
			UNION
			--GET INFORMATION FOR ANY REPLICATION JOBS THAT ARE RUNNING
			SELECT JR.jobId, vs.value('@id1', 'INT')
			FROM
			(
				SELECT RS.jobId, CAST(O.value AS XML) xmlValue
				FROM JMRstJobInfo RS -- Read only committed rows. To handle synchronization issues where TM submitted job but JM didnt pick it up yet. It could happen that JM didnt insert into JMRstJobInfo here and changed TM_Jobs status to 2 by the time code below is executed.
				JOIN TM_JobOptions O (NOLOCK) ON RS.rstTaskID = @iSubTaskId
AND O.jobId = RS.jobId AND O.optionId = 120012
			) JR
			CROSS APPLY JR.xmlValue.nodes('/TMMsg_EntityListResp/entities') V(vs)
			DELETE vsaInfoTable FROM @vsaInfoTable vsaInfoTable
			INNER JOIN #xmlOption_InfoTable xmlOption_InfoTable ON
			vsaInfoTable.replicationId = xmlOption_InfoTable.replicationID
			-- if its initiated by schedule then update last run time.
IF @initFrom = 5
			AND NOT EXISTS(SELECT 1 FROM @vsaInfoTable WHERE status = @VSAREP_VALIDATION_FAILED)
			BEGIN
				UPDATE TM_SubtaskOptions
				SET value = CAST(@nowUtcUnix AS NVARCHAR(20) )
				WHERE subtaskID = @iSubTaskId
				AND optionId = 120019			-- RST_LAST_REPLICATION_RUNTIME
				IF @@ROWCOUNT = 0
				BEGIN
					INSERT INTO TM_SubTaskOptions(subTaskID,optionID,type,value)
					VALUES  (@iSubTaskId,120019,7 ,@nowUtcUnix)
				END
				--  if its initiated by scheduler then delete vms where last sync failed
				-- DELETE ENTRIES FOR WHICH THE LAST REPLICATION JOB WAS RAN IN LESS THAN 20 MINUTES AND FAILED (IN SYNC PENDING STATE)
				DELETE vsaInfoTable FROM @vsaInfoTable vsaInfoTable
				JOIN APP_VSAReplicationProp (NOLOCK) prop
ON vsaInfoTable.status = @VSAREP_PENDING AND prop.propertyTypeId = 2215
				AND vsaInfoTable.replicationId = prop.replicationId
				JOIN JMRestoreStats (NOLOCK) jmrststats ON jmrststats.jobId = CAST(prop.propertyValue AS INT)
				AND jmrststats.status IN (2,4)  -- FAIL=2,Killed = 4
				WHERE datediff(minute, dbo.getdatetime(jmrststats.servEndTime), getutcdate()) < 20 -- 20 MINUTES
			END
		END
		IF NOT EXISTS(SELECT * FROM @vsaInfoTable WHERE stId = @iSubTaskId)
		BEGIN
SET @oErrorCode = (63 | (CAST(POWER(2, 24) AS BIGINT) * 24))
			SET @oErrorString = dbo.fn_EvFormatEventMsgText(0, 0, @oErrorCode, 0, 2)
			GOTO EXIT_SP
		END
		INSERT INTO #fullCycleInfo(subTaskId , subclientId, archGrpId ,archGrpCopyId ,fullCycleNum ,copyPrecedence ,backupLevel )
		SELECT IT.stId subTaskId, S.AppId subclientId, S.archGrpId, S.archGrpCopyId, MAX(fullCycleNum) FullCycleNum, MAX(IT.copyPrecedence) copyPrecedence, MAX(J.bkpLevel)
		FROM @vsaInfoTable IT
		JOIN JMJobDataStats (NOLOCK) S ON S.appId = IT.scId
		JOIN archGroupCopy (NOLOCK) AC ON AC.archGroupId = S.archGrpId AND AC.copy = IT.copyPrecedence AND AC.id = S.archGrpCopyId
		JOIN JMBkpStats (NOLOCK) J ON J.jobId = S.jobId AND J.commCellId = S.commCellId
		WHERE IT.copyPrecedenceApplicable = 1
		AND J.bkpLevel IN (1, 64, 128, 16384)
		GROUP BY IT.scId, S.archGrpId, S.archGrpCopyId, S.AppId, S.JobId, S.CommCellId, IT.stId
		HAVING MAX(S.status) = 100 AND MIN(S.Status) = 100
		--GET THE LAST COPY TIME FOR SCHEDULES WITH COPY PRECEDENSE SET
		-- For indexing v1 case use below code.
		INSERT INTO @auxCopyTable (subTaskId, subclientId, archGrpId, archGrpCopy, maxJobEndTime, maxCopiedTime)
		SELECT S.subTaskId subTaskId, S.subclientId, S.archGrpId, S.archGrpCopyId, MAX(jobEndTime) maxJobEndTime, MAX(maxCopiedTime) maxCopiedTime
		FROM
		(
			SELECT F.subTaskId subTaskId, F.subclientId, D.archGrpId, D.archGrpCopyId, J.servEndDate jobEndTime, J.cycleSequence,
				--ROW_NUMBER() OVER (PARTITION BY F.SubtaskId, F.subclientId ORDER BY J.servEndDate) CopiedCycleSequenceNum, MAX(copiedTime) maxCopiedTime
				ROW_NUMBER() OVER (PARTITION BY F.SubtaskId, F.subclientId ORDER BY J.servEndDate) +
				(SELECT COUNT(*) FROM JMBkpStats B (NOLOCK) WHERE  F.subclientId = B.AppId AND J.fullCycleNum = B.FullCycleNum AND J.cycleSequence > B.cycleSequence AND B.Status IN (1, 3) and B.DataStatus = 3) CopiedCycleSequenceNum,
				MAX(copiedTime) maxCopiedTime
			FROM
			(
				SELECT subTaskId, subclientId, archGrpId, archGrpCopyId, MAX(fullCycleNum) FullCycleNum, ROW_NUMBER() OVER (PARTITION BY SubtaskId, subclientId ORDER BY MAX(fullCycleNum) DESC) FullCycleNumSPs, MAX(copyPrecedence) copyPrecedence
				FROM #fullCycleInfo
				GROUP BY subTaskId, subclientId, archGrpId, archGrpCopyId
			) F
			JOIN JMBkpStats (NOLOCK) J ON J.appId = F.subclientId AND J.fullCycleNum = F.FullCycleNum
			JOIN JMJobDataStats (NOLOCK) D ON J.jobId = D.jobId AND J.commCellId = D.commCellId
			JOIN archGroupCopy (NOLOCK) AC ON AC.archGroupId = D.archGrpId AND AC.copy = F.copyPrecedence AND AC.id = D.archGrpCopyId
			WHERE  F.FullCycleNumSPs = 1
			GROUP BY F.subclientId, D.archGrpId, D.archGrpCopyId, J.servEndDate, J.cycleSequence, F.subTaskId, J.fullCycleNum
			HAVING MAX(D.status) = 100 AND MIN(D.Status) = 100
		) S
		WHERE  S.cycleSequence = S.CopiedCycleSequenceNum
		GROUP BY S.subclientId, S.archGrpId, S.archGrpCopyId, S.subclientId, S.subTaskId
		UPDATE auxCopyTable
		SET fullcycleNumFullBackup = ISNULL(T.fullCycleNum, 0)
		FROM @auxCopyTable auxCopyTable INNER JOIN
		(
				SELECT fullCycleInfo.subtaskId, fullCycleInfo.subclientId, MAX(fullCycleInfo.fullCycleNum) fullCycleNum
				FROM #fullCycleInfo fullCycleInfo
				-- Get max fullcyclenum for full backups.
				WHERE fullCycleInfo.backupLevel = 1
				GROUP BY fullCycleInfo.subtaskId, fullCycleInfo.subclientId
		) T
		ON auxCopyTable.subTaskId =  T.subtaskID
		AND auxCopyTable.subclientId = T.subclientID
		UPDATE @vsaInfoTable
		SET jobEndTime = T.maxCopiedTime,
		lastSuccessBkupTime = T.servEndDate
		FROM
		(
			SELECT MAX(J2.jobid) jobId, MAX(J2.servEndDate) servEndDate, VS.sourceGuid srcBuid, J1.appId subclientId, MAX(AU.maxCopiedTime) maxCopiedTime, stID subTaskId
			FROM @vsaInfoTable VS
			JOIN JMBkpStats J1 (NOLOCK) ON J1.appId = VS.scId
			JOIN @auxCopyTable AU ON AU.subclientId = J1.appId AND AU.maxJobEndTime = J1.servEndDate
			JOIN JMBkpStats J2 (NOLOCK) ON J2.appId = J1.appId AND J2.fullCycleNum = J1.fullCycleNum
			JOIN APP_VMProp (NOLOCK) VP ON VP.jobId = J2.jobId AND VP.attrVal=VS.sourceGuid AND VP.attrName='vmGUID'
			JOIN APP_VMProp (NOLOCK) VM ON VM.jobId = VP.jobId AND VM.VMclientId = VP.VMclientId AND VM.attrName='vmStatus' AND VM.attrVal IN ('0', '3')	--CHECK FOR VM BACKUP STATUS 0 (COMPLETED) OR 3 (PARTIAL SUCCESS)
			WHERE J2.appId = scId AND AU.subTaskId = stId
			AND J2.jobId > lastBkpJobId
			AND J2.jobId <= J1.jobId
			AND J2.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/)
			GROUP BY VS.sourceGuid, J1.appId, stId
		) T
		WHERE copyPrecedenceApplicable = 1
		AND T.srcBuid = sourceGuid
		AND T.subclientId = scId
		AND isIndexingV2Enabled = 0
		AND T.subTaskID = stId
		UPDATE @vsaInfoTable
			SET jobEndTime = T.maxCopiedTime,
			lastSuccessBkupTime = T.servEndDate
			FROM
			(
				SELECT MAX(J2.servEndDate) servEndDate, VS.sourceGuid srcBuid, J1.appId subclientId, MAX(AU.maxCopiedTime) maxCopiedTime, stId subTaskId
				FROM @vsaInfoTable VS
				JOIN JMBkpStats J1 (NOLOCK) ON J1.appId = VS.scId
				JOIN @auxCopyTable AU ON AU.subclientId = J1.appId AND AU.maxJobEndTime = J1.servEndDate
				JOIN JMBkpStats J2 (NOLOCK) ON J2.appId = J1.appId AND J2.fullCycleNum = J1.fullCycleNum
				AND J2.status IN (1,3)
				WHERE AU.subTaskId = stId
				AND J2.jobId > lastBkpJobId
				AND J2.jobId <= J1.jobId
				AND J2.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/)
				GROUP BY VS.sourceGuid, J1.appId, stId
			) T
			WHERE T.srcBuid = sourceGuid
			AND T.subclientId = scId
			AND copyPrecedenceApplicable = 1
			AND isIndexingV2Enabled = 1
			AND T.subTaskID = stId
	END
	--ALWAYS RUN FOR FREQUENCY FREQ_TYPE_After_Job_Completes WHEN IT IS STARTED FROM A SCHEDULE.  ALWAYS CHECK FOR IMMEDIATED JOBS WHICH IS WHEN freq_type IS NULL
IF EXISTS(SELECT * FROM @runTimeInfoTable WHERE freqType <> 4096 OR (freqType = 4096 AND @initFrom <> 5) OR freqType IS NULL)
	BEGIN
		INSERT @replicationTable (replicationId, optionId)
		SELECT
			CASE c.value('@optionId', 'INT')
WHEN 120012	--_RST_REPLICATION_IDS
				THEN c.value('@value', 'INT')
			END, c.value('@optionId', 'INT')
		FROM @oXmlString.nodes('TMMsg_TaskOperationReq/runTaskOptions/options') R(c)
		INSERT @replicationTable (replicationId, optionId)
		SELECT
			CASE c.value('@optionId', 'INT')
WHEN 120017	--_RST_REPLICATION_FAILBACK_IDS
				THEN S.Data
			END, c.value('@optionId', 'INT')
		FROM @oXmlString.nodes('TMMsg_TaskOperationReq/runTaskOptions/options') R(c)
		CROSS APPLY dbo.SplitString(c.value('@value', 'VARCHAR(MAX)'), ',') S
		DELETE @replicationTable WHERE replicationId IS NULL --AND optionId = RST_REPLICATION_FAILBACK_IDS		--_RST_REPLICATION_FAILBACK_IDS
		IF @IsindexingV2 = 0
			SET @repJobId = ISNULL((SELECT TOP 1 jobId FROM JMRstJobInfo RS (NOLOCK) WHERE RS.rstTaskID = @iSubTaskId), 0)
		ELSE
		BEGIN
			SET @repJobId = ISNULL((SELECT TOP 1 xmlOption_InfoTable.jobId FROM #xmlOption_InfoTable xmlOption_InfoTable INNER JOIN @replicationTable replicationTable ON
			replicationTable.replicationID = xmlOption_InfoTable.replicationid ), 0)
		END
--
		IF @repJobId > 0 AND NOT EXISTS(SELECT * FROM @replicationTable)
		BEGIN
SET @oErrorCode = (1957 | (CAST(POWER(2, 24) AS BIGINT) * 19))
			SET @oErrorString = dbo.fn_EvFormatEventMsgText(0, 0, @oErrorCode, 0, 2)
			DELETE @runTimeInfoTable
			GOTO EXIT_SP
		END
		DELETE @runTimeInfoTable
		SET @oXmlString = NULL
		--REMOVE ANY WHICH ARE NOT SELECTED BY SYNC IMMEDIATE
		IF EXISTS (SELECT * FROM @replicationTable)
		BEGIN
			SET @runIndividualVM = 1
			DELETE @vsaInfoTable
			WHERE replicationId NOT IN (
					SELECT replicationId FROM @replicationTable
					)
		END
		IF NOT EXISTS(SELECT * FROM @vsaInfoTable WHERE stId = @iSubTaskId)
		BEGIN
SET @oErrorCode = (63 | (CAST(POWER(2, 24) AS BIGINT) * 24))
			SET @oErrorString = dbo.fn_EvFormatEventMsgText(0, 0, @oErrorCode, 0, 2)
			GOTO EXIT_SP
		END
		--REMOVE ANY VSA RESTORE JOBS WHICH ARE RUNNING
		IF EXISTS(SELECT replicationId FROM @replicationTable)
		BEGIN
			--FOR INDIVIDUAL REQUEST CHECK IF THE JOB THAT'S RUNNING FOR THE SCHEDULE IS RUNNING FOR THE SAME REPLICATION ID
			-- for indexing v2 check to remove vms is done above.
			IF (@isIndexingV2 = 0)
			BEGIN
			DELETE @vsaInfoTable
			WHERE tkId IN
			(
				SELECT taskId
				FROM
				(
					SELECT T.taskId, en.value('@id1', 'INT') replicationId
					FROM
					(
						SELECT CAST(O.value AS XML) value, ST.taskId, ST.subTaskId
						FROM JMRstJobInfo JR WITH (NOLOCK)
						JOIN TM_SubTask ST WITH (NOLOCK) ON ST.subTaskId = JR.rstTaskID
						OUTER APPLY dbo.GetAllJobOptions(JR.jobId) O
WHERE O.optionId = 120012
					) T
					JOIN TM_SubTaskXMLOptions SO WITH (NOLOCK) ON SO.subTaskId = T.subTaskId
					CROSS APPLY SO.xmlValue.nodes('TMMsg_JobOption/restoreOptions/virtualServerRstOption') V(vs)
					CROSS APPLY T.value.nodes('TMMsg_EntityListResp/entities') E(en)
				) R
				WHERE R.replicationId IN (SELECT replicationId FROM @replicationTable)
			)
			END
			--SET FLAG TO INDICATE THAT VM WAS STARTED MANUALLY
			UPDATE @vsaInfoTable SET flags = flags | @STARTED_SYNC_IMMEDIATE
		END
		ELSE
		BEGIN
			DELETE @vsaInfoTable
			WHERE tkId IN
			(
				SELECT ST.taskId
				FROM JMRstJobInfo JR WITH (NOLOCK)
				JOIN TM_SubTask ST WITH (NOLOCK) ON ST.subTaskId = JR.rstTaskID
				JOIN TM_SubTaskXMLOptions SO WITH (NOLOCK) ON SO.subTaskId = ST.subTaskId
				CROSS APPLY SO.xmlValue.nodes('TMMsg_JobOption/restoreOptions/virtualServerRstOption') V(vs)
				WHERE repGuid = vs.value('@replicationGuid', 'NVARCHAR(MAX)')
			)
		END
		IF NOT EXISTS(SELECT * FROM @vsaInfoTable WHERE stId = @iSubTaskId)
		BEGIN
SET @oErrorCode = (1957 | (CAST(POWER(2, 24) AS BIGINT) * 19))
			SET @oErrorString = dbo.fn_EvFormatEventMsgText(0, 0, @oErrorCode, 0, 2)
			GOTO EXIT_SP
		END
--
		--UPDATE LAST BACKUP TIME FROM AUX COPY JOB INFO
		--UPDATE @vsaInfoTable
		--	SET lastSuccessBkupTime = ISNULL ((SELECT MAX(maxCopiedTime) FROM @auxCopyTable AT
		--						WHERE AT.subclientId = scId AND AT.subTaskId = stId
		--						), 0
		--					)
		--WHERE copyPrecedenceApplicable = 1
		--REMOVE ANY RUNTIME WHICH BACKUP HAS NOT RUN
		DELETE @vsaInfoTable
		WHERE
		lastSuccessBkupTime = 0
		IF NOT EXISTS(SELECT * FROM @vsaInfoTable WHERE stId = @iSubTaskId)
		BEGIN
SET @oErrorCode = (1958 | (CAST(POWER(2, 24) AS BIGINT) * 19))
			SET @oErrorString = dbo.fn_EvFormatEventMsgText(0, 0, @oErrorCode, 0, 2)
			GOTO EXIT_SP
		END
		--REMOVE ANY VSA RESTORE JOBS WHICH HAVE ALREADY RUN AND NEW BACKUP HAS NOT COMPLETED
		DELETE @vsaInfoTable
		FROM @vsaInfoTable RT
		WHERE
		RT.status IN (@VSAREP_PAUSED, @VSAREP_COMPLETE, @VSAREP_ENABLED, @VSAREP_PENDING, @VSAREP_STARTING, @VSAREP_RUNNING, @VSAREP_FAILED, @VSAREP_REVERT_FAILED)
		AND CAST(RT.spare1 AS INT) > RT.lastSuccessBkupTime	--ONLY REMOVE THESE ENTRIES FOR WHICH A NEW BACKUP JOB HAS NOT BEEN RUN (DELETE ENTRY WHEN LAST REP TIME > LAST BACKUP TIME)
		AND RT.spare1 <> ''	--FIRST REPLICATION JOB FAILED ENTRY WAS NOT UPDATED BY JM
		IF NOT EXISTS(SELECT * FROM @vsaInfoTable WHERE stId = @iSubTaskId)
		BEGIN
SET @oErrorCode = (1960 | (CAST(POWER(2, 24) AS BIGINT) * 19))
			SET @oErrorString = dbo.fn_EvFormatEventMsgText(0, 0, @oErrorCode, 0, 2)
			GOTO EXIT_SP
		END
		--REMOVE ANY VSA RESTORE JOBS WHICH HAVE FAILED OR ALREADY RUN AND NEW BACKUP HAS NOT RUN
		DELETE @vsaInfoTable
		FROM @vsaInfoTable RT
		JOIN APP_VSAReplication VR WITH (NOLOCK)
			ON VR.replicationGuid = RT.repGuid
			AND VR.sourceGuid = RT.sourceGuid
		WHERE VR.status IN (@VSAREP_DISABLED, @VSAREP_FAILED)	--NEVER START JOB FOR THESE STATUS
		AND NOT EXISTS(			--REPLICATON SCHEDULE HAS OTHER VMS
						SELECT * FROM @vsaInfoTable
						WHERE replicationGuid = RT.repGuid AND status NOT in (@VSAREP_DISABLED, @VSAREP_FAILED)
					)
		AND RT.flags&@VSAREP_REVERSE_REP = 0		--DO NOT DELETE FOR VM MARKED FOR REVERSE REPLICATION
		AND FailoverStatus NOT IN (@VSAREP_FAILBACK_RUNNING)	--UNLESS FAILOVER REQUEST IS STARTED
		IF NOT EXISTS(SELECT * FROM @vsaInfoTable WHERE stId = @iSubTaskId)
		BEGIN
SET @oErrorCode = (1959 | (CAST(POWER(2, 24) AS BIGINT) * 19))
			SET @oErrorString = dbo.fn_EvFormatEventMsgText(0, 0, @oErrorCode, 0, 2)
			GOTO EXIT_SP
		END
		UPDATE @vsaInfoTable
		SET status =
		(
			CASE
			WHEN (status  IN (@VSAREP_COMPLETE, @VSAREP_ENABLED, @VSAREP_VALIDATION_FAILED, @VSAREP_PAUSED))
				AND (
						(spare2 < lastSuccessBkupTime AND copyPrecedenceApplicable = 0)
						OR
						(spare2 < jobEndTime AND copyPrecedenceApplicable = 1)
					)
            THEN @VSAREP_PENDING
			ELSE status
			END
		)
IF @initFrom = 1
		BEGIN
			UPDATE @vsaInfoTable
			SET status =
			(
				CASE
				WHEN (status  IN (@VSAREP_COMPLETE, @VSAREP_ENABLED, @VSAREP_VALIDATION_FAILED, @VSAREP_PAUSED))
					AND (
							spare1 = '' -- First restore job failed.
							OR
							(spare1 < lastSuccessBkupTime AND copyPrecedenceApplicable = 0)
							OR
							(spare1 < jobEndTime AND copyPrecedenceApplicable = 1)
						)
				THEN @VSAREP_PENDING
				ELSE status
				END
			)
		END
		--DONOT START ANY FAILED VMS IF FLAG IS NOT SET
		DELETE @vsaInfoTable
		WHERE flags&@VSAREP_VALIDATION_FAILED = @VSAREP_VALIDATION_FAILED
		AND @disableVMRevertReplication = 1
	--PERFORMANCE - USE SEPARATE QUERY TO NOT USE OR IN ONE QUERY
		UPDATE @vsaInfoTable
		SET status = @VSAREP_STARTING
		WHERE status = @VSAREP_PENDING
--
		--RE-POPULATE TABLE
		INSERT @runTimeInfoTable		--SET freqType = 0 SO CHECK TO RUN PASSES
		SELECT DISTINCT stId, subtaskName, tkId, 0, repGuid, sourceGuid, cgId, clId, apId, instId, bsId, 0, MAX(lastSuccessBkupTime), opType, CASE WHEN copyPrecedenceApplicable = 1 THEN jobEndTime ELSE '' END,0,0 copyPrecedenceApplicable,0 copyPrecedence, 0 isIndexingV2Enabled
		FROM @vsaInfoTable
		GROUP BY stId, subTaskName, tkId, repGuid, cgId, clId, apId, instId, bsId, opType, sourceGuid, freqType, jobEndTime, copyPrecedenceApplicable
		IF EXISTS (SELECT 1 FROM @vsaInfoTable)
		BEGIN
			--UPDATE APP_VSA TABLE
			-- no need to insert here to handle synchronization issues between this SP and TM_getvsajobcompletedpatterns.sp ...
			-- So changing merge to update.
			UPDATE VR
			SET
				VR.lastBackupTime = (CASE WHEN RT.lastSuccessBkupTime IS NULL OR RT.lastSuccessBkupTime = 0 THEN VR.lastBackupTime ELSE RT.lastSuccessBkupTime END),
				VR.modified = @nowTimeUnix,
				VR.flags =
						(
							CASE
							WHEN VR.status = @VSAREP_VALIDATION_FAILED THEN @VSAREP_VALIDATION_FAILED
							WHEN VR.status = @VSAREP_RUNNING THEN 0
							ELSE RT.flags
							END
						),
				VR.subclientId = scId,
				VR.status = RT.status
			FROM APP_VSAReplication AS VR
			INNER JOIN
			(
				SELECT repGuid, tkId, bsId, scId, lastSuccessBkupTime, sourceGuid, sourceName, destinationName, replicationId, status, flags
				FROM @vsaInfoTable
WHERE apId = 106	--CV_APPTYPE_VIRTUAL_SERVER
			) RT ON RT.replicationId = VR.replicationId --RT.repGuid = VR.replicationGuid AND RT.sourceGuid = VR.sourceGuid
		END
IF @initFrom = 1
		BEGIN
			UPDATE @vsaInfoTable
				SET bkpJobsToSync = ISNULL( (SELECT CASE WHEN MIN(JB.jobid) != MAX(JB.jobid) THEN CAST(MIN(JB.jobid) AS VARCHAR)+','+CAST(MAX(JB.jobid) AS VARCHAR) ELSE CAST(MAX(JB.jobid) AS VARCHAR) END
					FROM JMBkpStats (NOLOCK) JB
					JOIN APP_VMProp (NOLOCK) VP ON VP.jobId = JB.jobId AND VP.attrVal=sourceGuid AND VP.attrName='vmGUID'
					JOIN APP_VMProp (NOLOCK) VM ON VM.jobId = VP.jobId AND VM.VMclientId = VP.VMclientId AND VM.attrName='vmStatus' AND VM.attrVal IN ('0', '3')	--CHECK FOR VM BACKUP STATUS 0 (COMPLETED) OR 3 (PARTIAL SUCCESS)
					WHERE JB.appId = scId
					AND JB.jobId > lastBkpJobId
					AND lastBkpJobId > 0
					AND JB.dataStatus != 2 -- Adding check to ensure we dont include aged jobs in bkpJobsToSync
					AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
					AND JB.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/)	--MR:192409
					),'')
			WHERE copyPrecedenceApplicable = 0
			AND isIndexingv2Enabled=0
			-- For vsa v2, now App_VMProp doesnt have any entry for child subclient backups. so backups pending to sync doesnt have any value if we look at vm prop. So looking at JMBkpStats directly
			UPDATE @vsaInfoTable
			SET bkpJobsToSync = ISNULL( (SELECT CASE WHEN MIN(JB.jobid) != MAX(JB.jobid) THEN CAST(MIN(JB.jobid) AS VARCHAR)+','+CAST(MAX(JB.jobid) AS VARCHAR) ELSE CAST(MAX(JB.jobid) AS VARCHAR) END
					FROM JMBkpStats (NOLOCK) JB
					WHERE JB.appId = scId
					AND JB.jobId > lastBkpJobId
					AND lastBkpJobId > 0
					AND JB.dataStatus != 2 -- Adding check to ensure we dont include aged jobs in bkpJobsToSync
					AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
					AND JB.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/)     --MR:192409
					),'')
			WHERE copyPrecedenceApplicable = 0
			AND isIndexingv2Enabled=1
			--GET LIST OF BACKUP JOBS THAT HAVE BEEN AUXCOPIED TO BE REPLICATED
			UPDATE @vsaInfoTable
				SET bkpJobsToSync = ISNULL( (SELECT CASE WHEN MIN(J2.jobid) != MAX(J2.jobid) THEN CAST(MIN(J2.jobid) AS VARCHAR)+','+CAST(MAX(J2.jobid) AS VARCHAR) ELSE CAST(MAX(J2.jobid) AS VARCHAR) END
					FROM JMBkpStats J1 (NOLOCK)
					JOIN @auxCopyTable AU ON AU.subclientId = J1.appId AND AU.maxJobEndTime = J1.servEndDate
					JOIN JMBkpStats J2 (NOLOCK) ON J2.appId = J1.appId AND J2.fullCycleNum >= AU.fullCycleNumFullBackup
					JOIN APP_VMProp (NOLOCK) VP ON VP.jobId = J2.jobId AND VP.attrVal=sourceGuid AND VP.attrName='vmGUID'
					JOIN APP_VMProp (NOLOCK) VM ON VM.jobId = VP.jobId AND VM.VMclientId = VP.VMclientId AND VM.attrName='vmStatus' AND VM.attrVal IN ('0', '3')	--CHECK FOR VM BACKUP STATUS 0 (COMPLETED) OR 3 (PARTIAL SUCCESS)
					WHERE J2.appId = scId AND AU.subTaskId = stId
					AND J2.jobId > lastBkpJobId
					AND J2.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/)
					AND J2.dataStatus != 2 -- Adding check to ensure we dont include aged jobs bkpJobsToSync
					AND J2.jobId <= J1.jobId
					AND lastBkpJobId > 0),'')
			WHERE copyPrecedenceApplicable = 1
			AND isIndexingv2Enabled = 0
			UPDATE @vsaInfoTable
				SET bkpJobsToSync = ISNULL( (SELECT CASE WHEN MIN(J2.jobid) != MAX(J2.jobid) THEN CAST(MIN(J2.jobid) AS VARCHAR)+','+CAST(MAX(J2.jobid) AS VARCHAR) ELSE CAST(MAX(J2.jobid) AS VARCHAR) END
					FROM JMBkpStats J1 (NOLOCK)
					JOIN @auxCopyTable AU ON AU.subclientId = J1.appId AND AU.maxJobEndTime = J1.servEndDate
					JOIN JMBkpStats J2 (NOLOCK) ON J2.appId = J1.appId AND J2.fullCycleNum >= AU.fullCycleNumFullBackup
					AND J2.Status IN (1,3)
					WHERE J2.appId = scId AND AU.subTaskId = stId
					AND J2.jobId > lastBkpJobId
					AND J2.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/)
					AND J2.dataStatus != 2 -- Adding check to ensure we dont include aged jobs bkpJobsToSync
					AND J2.jobId <= J1.jobId
					AND lastBkpJobId > 0),'')
			WHERE copyPrecedenceApplicable = 1
			AND isIndexingv2Enabled = 1
			UPDATE APP_VSAReplication
			SET BkpJobsToSync =
								(
									CASE
									WHEN APP_VSAReplication.lastSyncedBkpJob > 0 THEN RT.bkpJobsToSync
									ELSE APP_VSAReplication.BkpJobsToSync
									END
								)
			FROM APP_VSAReplication INNER JOIN @vsaInfoTable RT
			ON APP_VSAReplication.replicationID = RT.replicationId
		END
	END
EXIT_SP:
	IF EXISTS(SELECT * FROM @runTimeInfoTable WHERE
(freqType = 4096 AND @initFrom = 5)
				OR
(freqType <> 4096)		--WAS ADDED IN CHECK IF VSA JOB NEEDS TO RUN, SO IT SHOULD BE RUN
			)
	BEGIN
		SET @oRunIt = 1
	END
	--RE-POPULATE TABLE
	DELETE @runTimeInfoTable
--
	INSERT @runTimeInfoTable
	(stId, subtaskName, tkId, freqType, repGuid, sourceGuid, cgId, clId, apId, instId, bsId, scId, lastSuccessBkupTime, opType, auxJobEndTime, copyPrecedenceApplicable)
	SELECT DISTINCT stId, subtaskName, tkId, freqType, repGuid, sourceGuid, cgId, clId, apId, instId, bsId, 0, MAX(lastSuccessBkupTime), opType, CASE WHEN copyPrecedenceApplicable = 1 THEN jobEndTime ELSE '' END auxJobEndTime, copyPrecedenceApplicable
	FROM @vsaInfoTable
	GROUP BY stId, subTaskName, tkId, repGuid, cgId, clId, apId, instId, bsId, opType, sourceGuid, freqType, jobEndTime, copyPrecedenceApplicable
	IF @oRunIt = 1
	BEGIN
		IF NOT EXISTS(SELECT * FROM @replicationTable)
		BEGIN
			--REMOVE FLAG FOR VM THAT WHERE STARTED MANUALLY WHEN SCHEDULE IS RUN
			UPDATE APP_VSAReplication SET flags = flags & ~@STARTED_SYNC_IMMEDIATE
			WHERE taskId IN (SELECT taskId FROM @vsaInfoTable)
		END
		--UPDATE THE SCHEDULE RUN TIME COLUMN FOR THOSE ENTRIES WHICH ARE GOING TO START A JOB
		UPDATE APP_VSAReplication
		SET spare2 = @nowUtcUnix,
		spare3 = @nowUtcUnix
		FROM App_VSAReplication
		INNER JOIN @vsaInfoTable vsaInfoTable ON App_VSAReplication.replicationID = vsaInfoTable.replicationID
		AND APP_VSAReplication.status = @VSAREP_STARTING
		--UPDATE THE SCHEDULE RUN TIME COLUMN FOR THOSE ENTRIES WHICH ARE GOING TO START A JOB
		UPDATE APP_VSAReplication
		SET spare2 = @nowUtcUnix,
		spare3 = @nowUtcUnix
		FROM App_VSAReplication
		INNER JOIN @vsaInfoTable vsaInfoTable ON App_VSAReplication.replicationID = vsaInfoTable.replicationID
		AND APP_VSAReplication.FailoverStatus IN (@VSAREP_FAILBACK_RUNNING)
	END
	IF EXISTS(SELECT * FROM @runTimeInfoTable WHERE stId = @iSubTaskId)
	BEGIN
		IF (EXISTS (SELECT * FROM @replicationTable))
		BEGIN
IF (EXISTS (SELECT * FROM @replicationTable WHERE optionId = 120017))	--_RST_REPLICATION_FAILBACK_IDS
			SET @oXmlString =
			(
				SELECT VR.replicationId '@replicationId', VR.replicationGuid '@replicationGuid', VR.sourceGuid '@sourceGuid', VR.sourceName '@sourceName', VR.spare1 '@spare1', VR.spare2 '@spare2', RT.lastSuccessBkupTime '@spare3',	--HIJACKING THIS FIELD TO AVOID XML CHANE
				VR.destinationGuid '@destinationGuid', VR.destinationName '@destinationName', VR.lastRestoreTime '@lastRestoreTime', VR.lastBackupTime '@lastBackupTime',
				VR.powerOn '@powerOn', VR.status '@status', VR.options '@options',
				CASE
				WHEN @disableVMRevertReplication = 0 THEN VR.flags & ~@STARTED_SYNC_IMMEDIATE
				ELSE 0 END '@flags', backupsetId 'entity/@backupsetId', subclientId 'entity/@subclientId',
				@scIdForDistribute 'parentSubclient/@subclientId'
				-- Dont include parent subclient info here since we want to launch one job per VM
				FROM APP_VSAReplication VR WITH (NOLOCK)
				JOIN @runTimeInfoTable RT ON RT.tkId = VR.taskId AND RT.repGuid = VR.replicationGuid AND RT.sourceGuid = VR.sourceGuid
				WHERE
				VR.replicationId IN (SELECT replicationId FROM @replicationTable)
				FOR XML PATH('siteInfo'),
				ROOT('App_GetVSAReplicationResp')
			)
			ELSE
			SET @oXmlString =
			(
				SELECT VR.replicationId '@replicationId', VR.replicationGuid '@replicationGuid', VR.sourceGuid '@sourceGuid', VR.sourceName '@sourceName', VR.spare1 '@spare1', VR.spare2 '@spare2', RT.lastSuccessBkupTime '@spare3',	--HIJACKING THIS FIELD TO AVOID XML CHANE
				VR.destinationGuid '@destinationGuid', VR.destinationName '@destinationName', VR.lastRestoreTime '@lastRestoreTime', VR.lastBackupTime '@lastBackupTime',
				VR.powerOn '@powerOn', VR.status '@status', VR.options '@options',
				CASE
				WHEN @disableVMRevertReplication = 0 THEN VR.flags & ~@STARTED_SYNC_IMMEDIATE
				ELSE 0 END '@flags', backupsetId 'entity/@backupsetId', subclientId 'entity/@subclientId',
				@scIdForDistribute 'parentSubclient/@subclientId'
				FROM APP_VSAReplication VR WITH (NOLOCK)
				JOIN @runTimeInfoTable RT ON RT.tkId = VR.taskId AND RT.repGuid = VR.replicationGuid AND RT.sourceGuid = VR.sourceGuid
				WHERE status=@VSAREP_STARTING
				AND
				VR.replicationId IN (SELECT replicationId FROM @replicationTable)
				FOR XML PATH('siteInfo'),
				ROOT('App_GetVSAReplicationResp')
			)
		END
		ELSE
		BEGIN
			SET @oXmlString =
			(
				SELECT VR.replicationId '@replicationId', VR.replicationGuid '@replicationGuid', VR.sourceGuid '@sourceGuid', VR.sourceName '@sourceName', VR.spare1 '@spare1', VR.spare2 '@spare2', RT.lastSuccessBkupTime '@spare3',	--HIJACKING THIS FIELD TO AVOID XML CHANE
				VR.destinationGuid '@destinationGuid', VR.destinationName '@destinationName', VR.lastRestoreTime '@lastRestoreTime', VR.lastBackupTime '@lastBackupTime',
				VR.powerOn '@powerOn', VR.status '@status', VR.options '@options',
				CASE
				WHEN @disableVMRevertReplication = 0 THEN VR.flags & ~@STARTED_SYNC_IMMEDIATE
				ELSE 0 END '@flags', backupsetId 'entity/@backupsetId', subclientId 'entity/@subclientId',
				@scIdForDistribute 'parentSubclient/@subclientId'
				FROM APP_VSAReplication VR WITH (NOLOCK)
				JOIN @runTimeInfoTable RT ON RT.tkId = VR.taskId AND RT.repGuid = VR.replicationGuid AND RT.sourceGuid = VR.sourceGuid
				WHERE status=@VSAREP_STARTING
				FOR XML PATH('siteInfo'),
				ROOT('App_GetVSAReplicationResp')
			)
		END
	END
END
IF object_id('tempdb.dbo.#subclientContent_InfoTable') is not null
	DROP TABLE #subclientContent_InfoTable
IF object_id('tempdb.dbo.#subclientListTbl') is not null
	DROP TABLE #subclientListTbl
IF object_id('tempdb.dbo.#taskReplicationguidPair') is not null
	DROP TABLE #taskReplicationguidPair
GO

IF EXISTS (select * from GxQscripts where name = 'TM_doesReplicationTaskNeedToRun')
	delete from GxQscripts where name = 'TM_doesReplicationTaskNeedToRun'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_doesReplicationTaskNeedToRun')
	delete from GXDBVersions where aliasname = 'TM_doesReplicationTaskNeedToRun'
GO

insert into GXDBVersions values(2, 'TM_doesReplicationTaskNeedToRun',  '00010021000200450000', 'TM_doesReplicationTaskNeedToRun', '00010021000200450000')
GO

