

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_doesLiveSyncTaskNeedToRun.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_doesLiveSyncTaskNeedToRun.sp,v $ $Id: TM_doesLiveSyncTaskNeedToRun.sp,v 1.1.2.38 2020/07/15 21:36:18 mnatarajan Exp $";
---- ============================================================================
---- Author:		Sergio Bonilla
---- Create date:	03/10/2018
---- Description:	Check if a Live Sync schedule needs to run.
---- ============================================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='TM_doesLiveSyncTaskNeedToRun')
BEGIN
	print '>>> Drop Stored Procedure: TM_doesLiveSyncTaskNeedToRun <<<'
	drop procedure TM_doesLiveSyncTaskNeedToRun
END
IF EXISTS (select * from GxQscripts where name='TM_doesLiveSyncTaskNeedToRun')
	delete from GxQscripts where name = 'TM_doesLiveSyncTaskNeedToRun'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_doesLiveSyncTaskNeedToRun')
	delete from GXDBVersions where aliasname = 'TM_doesLiveSyncTaskNeedToRun'
GO
print '... Creating Procedure: TM_doesLiveSyncTaskNeedToRun'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_doesLiveSyncTaskNeedToRun
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @iSubTaskId INT,
  @initFrom INT = 5,	--SCHEDULE
  @localeId INT,
  @oRunIt INT OUTPUT,
  @oErrorCode integer OUTPUT,
  @oErrorString nvarchar(MAX) OUTPUT,
  @oXmlString XML OUTPUT
AS
SET NOCOUNT ON
BEGIN
	DECLARE @nowTime DATETIME = GETDATE()
	DECLARE @nowUtcTime DATETIME = GETUTCDATE()
	DECLARE @runTimeId INT = 0
	DECLARE @taskId INT = 0
	DECLARE @nowUtcUnix INT = datediff(second, '01/01/1970', @nowUtcTime)
	DECLARE @nowTimeUnix INT = datediff(second, '01/01/1970', @nowTime)
	DECLARE @timeZoneName NVARCHAR(MAX) = ISNULL((SELECT dbo.GetClientTimeZone(2)), '')
	DECLARE @replicationTable TABLE (replicationId INT, optionId BIGINT)
	DECLARE @VSAREP_COMPLETE INT = 1
	DECLARE @VSAREP_PENDING INT = 2
	DECLARE @VSAREP_RUNNING INT = 3
	DECLARE @VSAREP_PAUSED INT = 4
	DECLARE @VSAREP_FAILED INT = 5
	DECLARE @VSAREP_DISABLED INT = 6
	DECLARE @VSAREP_ENABLED INT = 7
	DECLARE @VSAREP_VALIDATION_FAILED INT = 8
	DECLARE @VSAREP_REVERT_FAILED INT = 10
	DECLARE @VSAREP_STARTING INT = 11
	DECLARE @runTaskOptionIgnoreActivityCheck INT = 0
	--FAILOVERSTATUS VALUE
	DECLARE @VSAREP_FAILBACK_RUNNING INT = 6
	--FLAG VALUES
	DECLARE @VSAREP_DELETED INT = 1
	DECLARE @STARTED_SYNC_IMMEDIATE	INT = 2
	DECLARE @VSAREP_REVERSE_REP INT = 4
	-- By default its not supported for now. We will enable once its supported from IDA side also.
	DECLARE @supportLiveSyncForSQLDump INT = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='supportLiveSyncForDumpSQL'), 0)
	IF Exists(SELECT 1 FROM @oXmlString.nodes('TMMsg_TaskOperationReq/runTaskOptions/options') R(c)
WHERE c.value('@optionId', 'INT') = 1559962334
			AND c.value('@value', 'NVARCHAR(10)') != 'false' AND c.value('@value', 'NVARCHAR(10)')!='0')
	BEGIN
		SET @runTaskOptionIgnoreActivityCheck = 1
	END
	IF object_id('tempdb.dbo.#completedPattern_initInfoTable') is not null
		DROP TABLE #completedPattern_initInfoTable
	CREATE TABLE #completedPattern_initInfoTable
				(stId INT, tkId INT, patId INT, cgId INT, clId INT, apId INT, instId INT, bsId INT, scId INT, destClientId INT, destAppTypeId INT DEFAULT 0, destInstanceId INT DEFAULT 0, opType INT,
copyPrecedenceApplicable INT, copyPrecedence INT, freq_type INT, tkDisabled INT, status INT, syncRestore INT, baselineJobId INT, restoreSource NVARCHAR(1024) DEFAULT '', freq_interval INT DEFAULT 0)
	CREATE CLUSTERED INDEX completedPattern_initInfoTable_tkId_clId_destClientId_Index1 ON #completedPattern_initInfoTable ([tkId], [clId], [destClientId])
	IF object_id('tempdb.dbo.#completedPattern_IdaInfoTable') is not null
		DROP TABLE #completedPattern_IdaInfoTable
	CREATE TABLE #completedPattern_IdaInfoTable
				(stId INT, tkId INT, patId INT, cgId INT, clId INT, apId INT, instId INT, bsId INT, scId INT, destClientId INT, destAppTypeId INT DEFAULT 0, destInstanceId INT DEFAULT 0, lastSuccessBkupTime INT, opType INT,
jId BIGINT, copyPrecedenceApplicable INT, copyPrecedence INT, freq_type INT, tkDisabled INT, lastSyncedBkpJob INT DEFAULT 0, status INT DEFAULT 0, bkpJobsToSync VARCHAR(1024) DEFAULT '',
replicationId INT DEFAULT 0, lastScheduleRunTime INT DEFAULT 0, flags INT DEFAULT 0, lastRestoreTime INT DEFAULT 0, syncRestore INT, baselineJobId INT, restoreSource NVARCHAR(1024) DEFAULT '',
                bkpLevel INT DEFAULT 0,freq_interval INT DEFAULT 0, isSubclientIdComputed INT DEFAULT 0, lastBackupTimeAuxCopied INT DEFAULT NULL,
restoreDestination NVARCHAR(1024) DEFAULT '', isDumpSweepSc INT DEFAULT 0)
	CREATE CLUSTERED INDEX completedPattern_IdaInfoTable_tkId_replicationId_clId_destClientId_Index1 ON #completedPattern_IdaInfoTable ([tkId], [replicationId], [clId], [destClientId])
	IF object_id('tempdb.dbo.#completedPattern_runTimeInfoTable') is not null
		DROP TABLE #completedPattern_runTimeInfoTable
	CREATE TABLE #completedPattern_runTimeInfoTable (stId INT, taskId INT, patId INT, cgId INT DEFAULT 0, clId INT DEFAULT 0, apId INT DEFAULT 0, instId INT DEFAULT 0, bsId INT DEFAULT 0, scId INT DEFAULT 0,
				lastSuccessBkupTime INT DEFAULT 0, opType INT, freq_type INT, tkDisabled INT DEFAULT 0, status INT DEFAULT 0, copyPrecedenceApplicable INT DEFAULT 0, copyPrecedence INT DEFAULT 0,freq_interval INT DEFAULT 0)
	CREATE CLUSTERED INDEX completedPattern_runTimeInfoTable_taskId_stId_Index1 ON #completedPattern_runTimeInfoTable ([taskId], [stId])
	IF object_id('tempdb.dbo.#auxCopyTable') is not null
		DROP TABLE #auxCopyTable
	CREATE TABLE #auxCopyTable
				(subTaskId INT, subclientId INT, maxCopiedTime INT, maxJobEndTime INT)
	CREATE CLUSTERED INDEX auxCopyTable_subclientId_Index1 ON #auxCopyTable ([subclientId])
	SET @oRunIt = 0
	-- Check for activity at commcell level only if option forceRunonDisabledActivity is set to false or 0.
	IF @runTaskOptionIgnoreActivityCheck = 0
	BEGIN
		IF EXISTS (SELECT 1 FROM JMJobAction WHERE clientId=1 AND appType=0 AND mediaAgentID=1 AND opType=1 AND appId=1 AND action=1)
		BEGIN
SET @oErrorCode = (645 | (CAST(POWER(2, 24) AS BIGINT) * 19))
			SET @oErrorString = dbo.fn_EvFormatEventMsgText(0, 0, @oErrorCode, 0, 2)
			GOTO EXIT_SP
		END
	END
	INSERT INTO #completedPattern_runTimeInfoTable
	(stId, taskId, patId, cgId, clId, apId, instId, bsId, scId, opType, freq_type, tkDisabled)
	SELECT ST.subTaskId, ST.taskId, PT.patternId, AE.clientGroupId, AE.clientId, AE.apptypeId, AE.instanceId, AE.backupsetId, AE.subclientId, ST.operationType, PT.freq_type, T.disabled
	FROM TM_SubTask ST WITH (NOLOCK)
	JOIN TM_Task T (NOLOCK) ON T.taskId = ST.taskId
	JOIN TM_AssocEntity AE WITH (NOLOCK) ON AE.taskId = ST.taskId
	LEFT OUTER JOIN TM_PatternAssoc PA WITH (NOLOCK) ON PA.subTaskId = ST.subTaskId  --OUTER JOIN NEEDED BECAUSE IMMEDIATE JOBS DO NOT HAVE A PATTERN
	LEFT OUTER JOIN TM_Pattern PT WITH (NOLOCK) ON PT.patternId = PA.patternId
	LEFT OUTER JOIN TM_RunTime RT WITH (NOLOCK) ON RT.patternId = PT.patternId AND RT.processed = 1
WHERE ST.subTaskId = @iSubTaskId AND ST.operationType = 1007
	GROUP BY ST.subTaskId, ST.subTaskName, ST.taskId, PT.freq_type, AE.clientGroupId, AE.clientId, AE.apptypeId, AE.instanceId, AE.backupsetId, AE.subclientId, ST.operationType, PT.patternId, T.disabled
	UPDATE completedPattern_runTimeInfoTable
	SET freq_interval = PT.freq_interval
	FROM #completedPattern_runTimeInfoTable completedPattern_runTimeInfoTable
	INNER JOIN TM_PatternAssoc PA WITH (NOLOCK) ON PA.subTaskId = completedPattern_runTimeInfoTable.stId  --OUTER JOIN NEEDED BECAUSE IMMEDIATE JOBS DO NOT HAVE A PATTERN
	INNER JOIN TM_Pattern PT WITH (NOLOCK) ON PT.patternId = PA.patternId
AND PT.freq_type = 4096
	IF EXISTS(SELECT 1 FROM #completedPattern_runTimeInfoTable)
	BEGIN
		INSERT INTO #completedPattern_initInfoTable
		(stId, tkId, patId, cgId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, opType, copyPrecedenceApplicable, copyPrecedence, freq_type, tkDisabled,
			syncRestore, baselineJobId, restoreSource,freq_interval)
		SELECT stId, taskId, patId, cgId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, opType, copyPrecedenceApplicable, copyPrecedence, freq_type, tkDisabled,
			syncRestore, baselineJobId, ISNULL(restoreSource, ''),freq_interval
		FROM
		(
			SELECT RI.stId, RI.taskId, RI.patId, RI.cgId, RI.clId, RI.apId, RI.instId, RI.bsId, RI.scId, CASE WHEN ds.value('destinationInstance[1]/@clientId', 'INT') IS NULL THEN ds.value('destClient[1]/@clientId', 'INT') ELSE ds.value('destinationInstance[1]/@clientId', 'INT') END destClientId,
			ISNULL(ds.value('destinationInstance[1]/@applicationId', 'INT'), 0) destAppTypeId, ISNULL(ds.value('destinationInstance[1]/@instanceId', 'INT'), 0) destInstanceId, RI.opType,
			ro.value('browseOption[1]/mediaOption[1]/copyPrecedence[1]/@copyPrecedenceApplicable', 'INT') copyPrecedenceApplicable, ro.value('browseOption[1]/mediaOption[1]/copyPrecedence[1]/@copyPrecedence', 'INT') copyPrecedence,
			ro.value('commonOptions[1]/@syncRestore', 'INT') syncRestore, ro.value('commonOptions[1]/@baselineJobId', 'INT') baselineJobId, RI.freq_type, RI.tkDisabled,
CASE WHEN RI.apId = 81 THEN sq.value('@val','NVARCHAR(MAX)')
WHEN RI.apId = 37 OR RI.apId = 62 THEN '' -- For db2 and db2 unix, replication is at backupset level. So no need to have restoreSource.
			ELSE fs.value('@val','NVARCHAR(MAX)') END restoreSource,
			RI.freq_interval
			FROM #completedPattern_runTimeInfoTable RI
			JOIN TM_SubTaskXMLOptions SO WITH (NOLOCK) ON SO.subTaskId = RI.stId
			CROSS APPLY SO.xmlValue.nodes('TMMsg_JobOption/restoreOptions') R(ro)
			CROSS APPLY	ro.nodes('./destination') D(ds)
			OUTER APPLY ro.nodes('./sqlServerRstOption/restoreSource') Q(sq)
			OUTER APPLY ro.nodes('./fileOption/sourceItem') F(fs)
WHERE  RI.apId <> 106
		) T
		GROUP BY stId, taskId, patId, cgId, clId, apId, instId, bsId, scId, opType, copyPrecedenceApplicable, copyPrecedence, freq_type, tkDisabled,
				destClientId, destAppTypeId, destInstanceId, syncRestore, baselineJobId, restoreSource,freq_interval
		INSERT INTO #completedPattern_IdaInfoTable
		(stId, tkId, patId, cgId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, lastSuccessBkupTime, opType, jId, copyPrecedenceApplicable,
			copyPrecedence, freq_type, tkDisabled, syncRestore, baselineJobId, restoreSource, freq_interval)
		SELECT stId, tkId, patId, cgId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, MAX(lastSuccessBkupTime) lastSuccessBkupTime, opType, MAX(jobId) jobId, copyPrecedenceApplicable,
			copyPrecedence, freq_type, tkDisabled, syncRestore, baselineJobId, restoreSource,freq_interval
		FROM
		(
			SELECT RI.stId, RI.tkId, RI.patId, RI.cgId, RI.clId, RI.apId, RI.instId, RI.bsId, RI.scId, RI.destClientId, RI.destAppTypeId, RI.destInstanceId, RI.opType, JB.servEndDate lastSuccessBkupTime, JB.jobId,
			RI.copyPrecedenceApplicable, RI.copyPrecedence, RI.syncRestore, RI.baselineJobId, RI.freq_type, RI.tkDisabled, RI.restoreSource, RI.freq_interval
			FROM #completedPattern_initInfoTable RI
			JOIN APP_Application APP (NOLOCK) ON APP.backupSet = RI.bsId
			JOIN JMBkpStats JB WITH (NOLOCK) ON JB.appId = APP.id
				AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
				AND JB.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/, 18 /*BACKUP3RD*/)
				AND JB.jobId >= ISNULL(baselineJobId, 0)
				AND JB.servEndDate <= (@nowUtcUnix - ISNULL(RI.freq_interval*60,0) ) --In case replication job is to be launched in a delayed fashion then we pick up last backup time before the delay is met.
			LEFT OUTER JOIN App_SubclientProp WITH (NOLOCK) ON App_SubclientProp.componentNameID = APP.id AND App_SubclientProp.attrName='Enable Snap Backups' --  CV_PROP_ENABLE_SNAP_BACKUPS_NAME
					AND App_SubClientProp.cs_attrName = CHECKSUM(N'Enable Snap Backups')
					AND App_SubclientProp.attrVal = '1'
WHERE  RI.apId NOT IN (106, 81 ,135 ) OR
( RI.apId = 135 AND App_SubclientProp.attrVal IS NOT NULL)
		) T
		GROUP BY stId, tkId, patId, cgId, clId, apId, instId, bsId, scId, opType, copyPrecedenceApplicable, copyPrecedence, freq_type, tkDisabled,
				destClientId, destAppTypeId, destInstanceId, syncRestore, baselineJobId, restoreSource,freq_interval
		-- FOR SQL identify based on latest successful backup
		IF @supportLiveSyncForSQLDump>0
		BEGIN
			INSERT INTO #completedPattern_IdaInfoTable
			(stId, tkId, patId, cgId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, lastSuccessBkupTime, opType, jId, copyPrecedenceApplicable,
				copyPrecedence, freq_type, tkDisabled, syncRestore, baselineJobId, restoreSource, freq_interval, isDumpSweepSc)
			SELECT RI.stId, RI.tkId, RI.patId, RI.cgId, RI.clId, RI.apId, RI.instId, RI.bsId, SDI.appId scId, RI.destClientId, RI.destAppTypeId, RI.destInstanceId, SDI.LastOkBackupTime lastSuccessBkupTime, RI.opType, 0,
				RI.copyPrecedenceApplicable, RI.copyPrecedence, RI.freq_type, RI.tkDisabled, RI.syncRestore, RI.baselineJobId, RI.restoreSource, RI.freq_interval, 1
				FROM #completedPattern_initInfoTable RI
						JOIN APP_Application APP (NOLOCK) ON APP.backupSet = RI.bsId
						AND dbo.IsSubClientValid(APP.appTypeId, APP.subclientStatus, 0) = 1 AND ( APP.subclientStatus & (4|2) =0)	-- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED)
						JOIN SqlDatabaseInfo SDI (NOLOCK) ON RI.instId = SDI.instanceId AND SDI.appId = APP.id
						JOIN SqlDBBackupInfo on SDI.LastBackupSetId = SqlDBBackupInfo.id
						AND SDI.LastOkBackupTime != SqlDBBackupInfo.backup_finish_Date -- To identify databases backed up by dump sweep schedules, lastOkbackuptime for DB should vary from backup finish data for corresponding LastBackupSetId from SqlDatabaseInfo
						JOIN sqlNames SN (NOLOCK) ON SN.id = SDI.databaseId
						JOIN sqlNames2 SN2 (NOLOCK) ON SN2.id = SN.sqlId AND RI.restoreSource = SN2.name
WHERE RI.apId =  81
		END
		-- if we dont have TL backups for restoreSource (SQL IDA) then check whether we have full backup and if so, fill that in temp table.
		IF EXISTS(SELECT 1 FROM #completedPattern_initInfoTable RI
				LEFT JOIN #completedPattern_IdaInfoTable IdaTbl ON RI.stId = IdaTbl.stId AND RI.instId = idaTbl.instId AND RI.restoreSource = idaTbl.restoreSource
				WHERE IdaTbl.stId IS NULL
AND RI.apId =  81 )
		BEGIN
			INSERT INTO #completedPattern_IdaInfoTable
			(stId, tkId, patId, cgId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, lastSuccessBkupTime, opType, jId, copyPrecedenceApplicable,
				copyPrecedence, freq_type, tkDisabled, syncRestore, baselineJobId, restoreSource,freq_interval)
			SELECT stId, tkId, patId, cgId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, lastSuccessBkupTime, opType, jobId, copyPrecedenceApplicable,
				copyPrecedence, freq_type, tkDisabled, syncRestore, baselineJobId, restoreSource, freq_interval FROM
			(
			SELECT RI.stId, RI.tkId, RI.patId, RI.cgId, RI.clId, RI.apId, RI.instId, RI.bsId, SBI.appId scId, RI.destClientId, RI.destAppTypeId, RI.destInstanceId, RI.opType, NULL lastSuccessBkupTime, SBI.jobId,
				RI.copyPrecedenceApplicable, RI.copyPrecedence, RI.syncRestore, RI.baselineJobId, RI.freq_type, RI.tkDisabled, RI.restoreSource, RI.freq_interval,
				ROW_NUMBER() OVER (PARTITION BY RI.stId, RI.instId, RI.restoreSource ORDER BY SBI.backup_finish_date DESC) AS rowId
				FROM #completedPattern_initInfoTable RI
						LEFT JOIN #completedPattern_IdaInfoTable IdaTbl ON RI.stId = IdaTbl.stId AND RI.instId = idaTbl.instId AND RI.restoreSource = idaTbl.restoreSource
						JOIN APP_Application APP (NOLOCK) ON APP.backupSet = RI.bsId AND dbo.IsSubClientValid(APP.appTypeId, APP.subclientStatus, 0) = 1 AND ( APP.subclientStatus & (4|2) =0)	-- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED)
						JOIN sqlDbBackupInfo SBI (NOLOCK) ON RI.instId = SBI.instanceId AND SBI.appId = APP.id
						JOIN sqlNames SN (NOLOCK) ON SN.id = SBI.sqlNameId
						JOIN sqlNames2 SN2 (NOLOCK) ON SN2.id = SN.sqlId AND RI.restoreSource = SN2.name
				WHERE IdaTbl.stId IS NULL AND EXISTS(SELECT 1 FROM JMBkpStats JB WITH (NOLOCK) WHERE JB.jobId = SBI.jobId
					AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
					AND JB.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/) -- No need for synthfull to identify last backup time.
					AND JB.jobId >= ISNULL(RI.baselineJobId, 0)
					AND JB.BKpLevel NOT IN (1,4) --- Dont consider full or differential backups.
					AND JB.servEndDate <= (@nowUtcUnix - ISNULL(RI.freq_interval*60,0) ) --In case replication job is to be launched in a delayed fashion then we pick up last backup time before the delay is met.
				)
AND RI.apId =  81
			) T
			WHERE T.rowId = 1
		END
		-- if we dont have TL backups for restoreSource (SQL IDA) then check whether we have full backup and if so, fill that in temp table.
		IF EXISTS(SELECT 1 FROM #completedPattern_initInfoTable RI
				LEFT JOIN #completedPattern_IdaInfoTable IdaTbl ON RI.stId = IdaTbl.stId AND RI.instId = idaTbl.instId AND RI.restoreSource = idaTbl.restoreSource
				WHERE IdaTbl.stId IS NULL
AND RI.apId =  81 )
		BEGIN
			-- For replications where there are no TL backups, identify last full or differential job
			INSERT INTO #completedPattern_IdaInfoTable
			(stId, tkId, patId, cgId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, lastSuccessBkupTime, opType, jId, copyPrecedenceApplicable,
				copyPrecedence, freq_type, tkDisabled, syncRestore, baselineJobId, restoreSource,freq_interval)
			SELECT stId, tkId, patId, cgId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, lastSuccessBkupTime, opType, jobId, copyPrecedenceApplicable,
				copyPrecedence, freq_type, tkDisabled, syncRestore, baselineJobId, restoreSource, freq_interval FROM
			(
			SELECT RI.stId, RI.tkId, RI.patId, RI.cgId, RI.clId, RI.apId, RI.instId, RI.bsId, SBI.appId scId, RI.destClientId, RI.destAppTypeId, RI.destInstanceId, RI.opType, NULL lastSuccessBkupTime, SBI.jobId,
				RI.copyPrecedenceApplicable, RI.copyPrecedence, RI.syncRestore, RI.baselineJobId, RI.freq_type, RI.tkDisabled, RI.restoreSource, RI.freq_interval,
				ROW_NUMBER() OVER (PARTITION BY RI.stId, RI.instId, RI.restoreSource ORDER BY SBI.backup_finish_date DESC) AS rowId
				FROM #completedPattern_initInfoTable RI
				LEFT JOIN #completedPattern_IdaInfoTable IdaTbl ON RI.stId = IdaTbl.stId AND RI.instId = idaTbl.instId AND RI.restoreSource = idaTbl.restoreSource
						JOIN APP_Application APP (NOLOCK) ON APP.backupSet = RI.bsId AND dbo.IsSubClientValid(APP.appTypeId, APP.subclientStatus, 0) = 1 AND ( APP.subclientStatus & (4|2) =0)	-- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED)
						JOIN sqlDbBackupInfo SBI (NOLOCK) ON RI.instId = SBI.instanceId AND SBI.appId = APP.id
						JOIN sqlNames SN (NOLOCK) ON SN.id = SBI.sqlNameId
						JOIN sqlNames2 SN2 (NOLOCK) ON SN2.id = SN.sqlId AND RI.restoreSource = SN2.name
				WHERE IdaTbl.stId IS NULL AND EXISTS(SELECT 1 FROM JMBkpStats JB WITH (NOLOCK) WHERE JB.jobId = SBI.jobId
					AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
					AND JB.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/) -- No need for synthfull to identify last backup time.
					AND JB.jobId >= ISNULL(RI.baselineJobId, 0)
					AND JB.BKpLevel IN (1,4) --- Consider full or differential backups for replications which dont have TL backups yet.
					AND JB.servEndDate <= (@nowUtcUnix - ISNULL(RI.freq_interval*60,0) ) --In case replication job is to be launched in a delayed fashion then we pick up last backup time before the delay is met.
				)
AND RI.apId =  81
			) T
			WHERE T.rowId = 1
		END
--
		SELECT @taskId = taskId FROM TM_SubTask (NOLOCK) WHERE subTaskId = @iSubTaskId
		-- Update restore destination depending on the index of source.
		;WITH FSSubtasks (subTaskId)
		AS
		(
			SELECT stID
			FROM #completedPattern_IdaInfoTable RI
			INNER JOIN App_AppTypeGroupAssoc ON RI.apId = App_AppTypeGroupAssoc.appTypeid AND App_AppTypeGroupAssoc.typeOfGroup = 0
			INNER JOIN App_AppTypeGroup ON App_AppTypeGroup.typeOfGroup = 0 AND
			App_AppTypeGroup.groupName='APPGRP_FileSystemIDA'
			AND App_AppTypeGroupAssoc.appGroupId = App_AppTypeGroup.appTypeGroupId
		)
		UPDATE RI
		SET restoreDestination = DestItems.DestPAth
		FROM #completedPattern_IdaInfoTable RI
		INNER JOIN
		(
			SELECT FSSubtasks.subTaskId, fs.value('@val','NVARCHAR(MAX)') as RestoreSource, ROW_NUMBER() OVER (PARTITION BY FSSubtasks.subTaskId ORDER BY (SELECT 1) ) as SourceIndex
			FROM FSSubtasks JOIN TM_SubTaskXMLOptions SO WITH (NOLOCK) ON SO.subTaskId = FSSubtasks.subTaskId
			CROSS APPLY SO.xmlValue.nodes('TMMsg_JobOption/restoreOptions/fileOption/sourceItem') F(fs)
		) SourceItems ON
		RI.StId = SourceItems.subTaskID AND RI.restoreSource = SourceItems.RestoreSource
		INNER JOIN
		(
			SELECT FSSubtasks.subTaskId, fs.value('@val','NVARCHAR(MAX)') as DestPath, ROW_NUMBER() OVER (PARTITION BY FSSubtasks.subTaskId ORDER BY (SELECT 1) ) as SourceIndex
			FROM FSSubtasks JOIN TM_SubTaskXMLOptions SO WITH (NOLOCK) ON SO.subTaskId = FSSubtasks.subTaskId
			CROSS APPLY SO.xmlValue.nodes('TMMsg_JobOption/restoreOptions/destination/destPath') F(fs)
		) DestItems ON DestItems.subTaskId = SourceItems.subTaskID AND SourceItems.SourceIndex = DestItems.SourceIndex
		--UPDATE TEMP TABLE FIELDS FROM TABLE
		UPDATE #completedPattern_IdaInfoTable
			SET scId = ISNULL(
								(
									SELECT MAX(T.appId)
									FROM
									(
										SELECT appId FROM JMBkpStats JS WITH (NOLOCK)
										WHERE JS.jobId = baselineJobId
										UNION
										SELECT appId FROM JMBkpStats JS WITH (NOLOCK)
										WHERE JS.jobId = jId
									) T
								), 0
						),
				isSubclientIdComputed = 1
		WHERE (ISNULL(scId, 0) <= 0 )
AND apId <> 81
		-- In case baselineJob is still running then subclient may not be computed from above code. So below code to from jobinof table also.
			UPDATE #completedPattern_IdaInfoTable
				SET scId = JMBkpJobInfo.applicationId ,
				isSubclientIdComputed = 1
FROM #completedPattern_IdaInfoTable INNER JOIN JMBkpJobInfo WITH (NOLOCK) ON #completedPattern_IdaInfoTable.baseLineJobID = JMBkpJobInfo.jobId AND JMBkpJobInfo.commcellId = 2
			--ORACLE AGENTS SCHEDULES ARE ALWAYS CREATED AT BACKUPSET LEVEL AND SUBCLIENT IS -1. REPLICATION CAN START ON BACKUP FOR ANY OF SUBCLIENTS ON BACKUPSET
			WHERE ISNULL(scId, 0) <= 0
AND apId <> 81
		UPDATE #completedPattern_IdaInfoTable
		SET replicationId = T.repId,
		lastScheduleRunTime = lastRunTime,
		status = syncStatus
		FROM
		(
			SELECT taskId, subclientId, restoreSource resSource, replicationId repId, lastRunTime, status syncStatus, backupsetId, restoreDestination resDestination
			FROM APP_LiveSyncReplication LS
			-- Flags = 1 indicates replication pair deleted
			where (flags & @VSAREP_DELETED) = 0
		) T
		WHERE T.taskId = tkId
		-- Dont always match based on subclientId. Since for SQL and oracle Idas, subclientID can change depending on latest backup and if SQL db changed from one subclient content to another.
		AND (
			(T.subclientId = scId AND isSubclientIdComputed = 0) OR (T.backupsetId = bsId AND isSubclientIdComputed=1)
		)
		AND ISNULL(T.resSource, '') = restoreSource
		AND ISNULL(T.resDestination, '') = ISNULL(restoreDestination,'')
		-- Remove replications where jobs are already running.
		DELETE #completedPattern_IdaInfoTable
		FROM
		(
		--REMOVE RESTORE SCHEDULES THAT ARE ALREADY RUNNING
			SELECT CASE WHEN TM_JobOptions.Value IS NULL THEN 0 ELSE 1 END isDumpSweepReplicationJob
			FROM JMRstJobInfo (NOLOCK) RI
			LEFT JOIN TM_JobOptions (NOLOCK) ON TM_JobOptions.jobID = RI.JobID
AND TM_JobOptions.optionId = 120020 -- RST_IS_REPLICATION_DUMP_SWEEP
			AND TM_JobOptions.value = '1'
			WHERE RI.rstTaskID = @iSubTaskId
			UNION
			--GET INFORMATION FOR ANY REPLICATION JOBS THAT HAVE BEEN SUBMITTED TO START BUT JOB MANAGER HAS NOT STARTED
			SELECT CASE WHEN TM_JobOptions.Value IS NULL THEN 0 ELSE 1 END isDumpSweepReplicationJob
			FROM TM_JobRequest R (NOLOCK)
			JOIN TM_Jobs J (NOLOCK) ON J.jobRequestId = R.jobRequestId AND J.status IN (0, 1,4097)  -- Refer to SP JMGetJopbsToProcessed there is an intermeridate state where 4096 flag is set
			AND R.subTaskId = @iSubTaskId
			LEFT JOIN TM_JobOptions (NOLOCK) ON TM_JobOptions.jobID = J.JobID
AND TM_JobOptions.optionId = 120020 -- RST_IS_REPLICATION_DUMP_SWEEP
			AND TM_JobOptions.value = '1'
		) T
		WHERE T.isDumpSweepReplicationJob = isDumpSweepSc
		IF NOT EXISTS(SELECT 1 FROM #completedPattern_IdaInfoTable)
		BEGIN
SET @oErrorCode = (1957 | (CAST(POWER(2, 24) AS BIGINT) * 19))
			SET @oErrorString = dbo.fn_EvFormatEventMsgText(0, 0, @oErrorCode, 0, 2)
			DELETE #completedPattern_runTimeInfoTable
			GOTO EXIT_SP
		END
		INSERT INTO #auxCopyTable (subTaskId, subclientId, maxJobEndTime, maxCopiedTime)
		SELECT S.subTaskId subTaskId, S.subclientId, MAX(jobEndTime) maxJobEndTime, MAX(maxCopiedTime) maxCopiedTime
		FROM
		(
			SELECT F.subTaskId subTaskId, F.subclientId, J.servEndDate jobEndTime, J.cycleSequence,
				--ROW_NUMBER() OVER (PARTITION BY F.SubtaskId, F.subclientId ORDER BY J.servEndDate) CopiedCycleSequenceNum, MAX(copiedTime) maxCopiedTime
				ROW_NUMBER() OVER (PARTITION BY F.SubtaskId, F.subclientId ORDER BY J.servEndDate) + ISNULL(T.auxcopied,0) CopiedCycleSequenceNum,
				--(SELECT COUNT(*) FROM JMBkpStats B (NOLOCK) WHERE  F.subclientId = B.AppId AND J.fullCycleNum = B.FullCycleNum AND J.cycleSequence > B.cycleSequence AND B.Status IN (1, 3) and B.DataStatus = 3 AND B.servEndDate <= (@nowUtcUnix - ISNULL(F.freq_interval*60,0) )  ) ,
				ISNULL(T.cycleSeq,0) + 1 ActualCycleSeq,
				MAX(copiedTime) maxCopiedTime
			FROM
			(
				SELECT subTaskId, subclientId, archGrpId, archGrpCopyId, MAX(fullCycleNum) FullCycleNum, ROW_NUMBER() OVER (PARTITION BY SubtaskId, subclientId ORDER BY MAX(fullCycleNum) DESC) FullCycleNumSPs, MAX(copyPrecedence) copyPrecedence,
				freq_interval
				FROM
				(
					SELECT IT.stId subTaskId, S.AppId subclientId, S.archGrpId, S.archGrpCopyId, MAX(fullCycleNum) FullCycleNum, MAX(IT.copyPrecedence) copyPrecedence,IT.freq_interval
					FROM #completedPattern_IdaInfoTable IT
					-- for oracle RAC,oracle subclients we have to wait for both data and log jobs to be aux copied
JOIN JMJobDataStats (NOLOCK) S ON S.appId = IT.scId AND IT.apId NOT IN ( 22, 80 )
					JOIN archGroupCopy (NOLOCK) AC ON AC.archGroupId = S.archGrpId AND AC.copy = IT.copyPrecedence AND AC.id = S.archGrpCopyId
					JOIN JMBkpStats (NOLOCK) J ON J.jobId = S.jobId AND J.commCellId = S.commCellId
					AND J.servEndDate <= (@nowUtcUnix - ISNULL(IT.freq_interval*60,0) ) --In case replication job is to be launched in a delayed fashion then we pick up last backup time before the delay.
					--AND J.jobId >= ISNULL(IT.baselineJobId, 0) For getting the latest cycle aux copied, we dont need to check if it was greater than baseline job. We need to only check last job aux copied > baseline job
					LEFT OUTER JOIN App_SubclientProp WITH (NOLOCK) ON App_SubclientProp.componentNameID = S.AppId AND App_SubclientProp.attrName='Enable Snap Backups' --  CV_PROP_ENABLE_SNAP_BACKUPS_NAME
					AND App_SubClientProp.cs_attrName = CHECKSUM(N'Enable Snap Backups')
					AND App_SubclientProp.attrVal = '1'
					WHERE IT.copyPrecedenceApplicable = 1
					AND J.bkpLevel IN (1, 64, 128, 16384, 1024,32768) -- 1024 (SEL_OFFLINE_FULL): selective offline full , 32768 (0x8000)= SEL_ONLINE_FULL selective online full
AND ( ( IT.apId = 135 AND App_SubclientProp.attrVal IS NOT NULL) OR IT.apId != 135 )
					GROUP BY IT.scId, S.archGrpId, S.archGrpCopyId, S.AppId, S.JobId, S.CommCellId, IT.stId,IT.freq_interval
					HAVING MAX(S.status) = 100 AND MIN(S.Status) = 100
				) T
				GROUP BY subTaskId, subclientId, archGrpId, archGrpCopyId,freq_interval
			) F
			JOIN JMBkpStats (NOLOCK) J ON J.appId = F.subclientId AND J.fullCycleNum = F.FullCycleNum
			AND J.servEndDate <= (@nowUtcUnix - ISNULL(F.freq_interval*60,0) ) --In case replication job is to be launched in a delayed fashion then we pick up last backup time before the delay.
			JOIN JMJobDataStats (NOLOCK) D ON J.jobId = D.jobId AND J.commCellId = D.commCellId
			JOIN archGroupCopy (NOLOCK) AC ON AC.archGroupId = D.archGrpId AND AC.copy = F.copyPrecedence AND AC.id = D.archGrpCopyId
			CROSS APPLY
			(
				SELECT SUM(CASE WHEN INNERQ.DataStatus = 3 THEN 1 ELSE 0 END) auxcopied, COUNT(1) cycleSeq
				FROM JMBkpStats INNERQ
				WHERE INNERQ.appId = J.AppId AND INNERQ.fullCycleNum = J.FullCycleNum AND J.cycleSequence > INNERQ.cycleSequence AND INNERQ.Status IN (1, 3, 14)
			) T
			WHERE  F.FullCycleNumSPs = 1
			GROUP BY F.subclientId, J.servEndDate, J.cycleSequence, F.subTaskId, J.fullCycleNum,F.freq_interval,T.AuxCopied,T.cycleSeq
			HAVING MAX(D.status) = 100 AND MIN(D.Status) = 100
		) S
		WHERE  S.ActualCycleSeq = S.CopiedCycleSequenceNum
		GROUP BY S.subclientId, S.subTaskId
		OPTION (MAXDOP 2) --TM_GetJobCompletedPatterns and TM_DoesLiveSyncTaskNeedtoRun have high CPU usage on prodCS. So forcing MAXDOP here to avoid hogging CPU Resources.
		-- check whether there are any ORacle RAC or ORacle live sync schedules with copy precedence. IF so do below.
		IF EXISTS(SELECT 1 FROM #completedPattern_IdaInfoTable IT
WHERE IT.apId IN ( 22, 80  ) AND IT.copyPrecedenceApplicable = 1
		)
		BEGIN
		INSERT INTO #auxCopyTable (subTaskId, subclientId, maxJobEndTime, maxCopiedTime)
			SELECT S.subTaskId subTaskId, S.subclientId, MAX(jobEndTime) maxJobEndTime, MAX(maxCopiedTime) maxCopiedTime
			FROM
			(
				SELECT F.subTaskId subTaskId, F.subclientId, J.servEndDate jobEndTime, J.cycleSequence,
					--ROW_NUMBER() OVER (PARTITION BY F.SubtaskId, F.subclientId ORDER BY J.servEndDate) CopiedCycleSequenceNum, MAX(copiedTime) maxCopiedTime
					ROW_NUMBER() OVER (PARTITION BY F.SubtaskId, F.subclientId ORDER BY J.servEndDate) + ISNULL(T.auxcopied,0) CopiedCycleSequenceNum,
					--(SELECT COUNT(*) FROM JMBkpStats B (NOLOCK) WHERE  F.subclientId = B.AppId AND J.fullCycleNum = B.FullCycleNum AND J.cycleSequence > B.cycleSequence AND B.Status IN (1, 3) and B.DataStatus = 3 AND B.servEndDate <= (@nowUtcUnix - ISNULL(F.freq_interval*60,0) )  ) ,
					ISNULL(T.cycleSeq,0) + 1 ActualCycleSeq,
					CASE WHEN ISNULL(MAX(DataJobDataStats.copiedTime),0)>ISNULL(MAX(LogJobDataStats.copiedTime),0) THEN ISNULL(MAX(DataJobDataStats.copiedTime),0)
					ELSE ISNULL(MAX(LogJobDataStats.copiedTime),0)
					END maxCopiedTime
				FROM
				(
					SELECT subTaskId, subclientId, MAX(fullCycleNum) FullCycleNum, ROW_NUMBER() OVER (PARTITION BY SubtaskId, subclientId ORDER BY MAX(fullCycleNum) DESC) FullCycleNumSPs, MAX(copyPrecedence) copyPrecedence,
					freq_interval
					FROM
					(
						SELECT IT.stId subTaskId, App_Application.Id subclientId, MAX(fullCycleNum) FullCycleNum, MAX(IT.copyPrecedence) copyPrecedence,IT.freq_interval
						FROM #completedPattern_IdaInfoTable IT
						-- for oracle RAC,oracle subclients we have to wait for both data and log jobs to be aux copied. Also we have to check for all subclients on oracle instance.
						JOIN App_Application (NOLOCK) ON IT.instId = App_Application.instance AND (subclientstatus & (4|2))=0
						JOIN JMBkpStats (NOLOCK) J ON J.appId = App_Application.Id AND J.commCellId = 2 -- DEFAULT_COMMCELL_ID
						AND J.status in (1,3,14)	--_JMSUCCESS,_PARTIALSUCCESS,_JMSUCCESSWITHWARNINGS
						AND J.opType!=14		--_Synthetic Full
						AND J.servEndDate <= (@nowUtcUnix - ISNULL(IT.freq_interval*60,0) ) --In case replication job is to be launched in a delayed fashion then we pick up last backup time before the delay.
						AND J.bkpLevel IN (1, 64, 128, 16384, 1024,32768) -- 1024 (SEL_OFFLINE_FULL): selective offline full , 32768 (0x8000)= SEL_ONLINE_FULL selective online full
AND IT.apId IN ( 22, 80  ) AND IT.copyPrecedenceApplicable = 1
						LEFT JOIN ArchFile (NOLOCK) DataAF ON J.JobId = DataAF.JobId AND (DataAF.fileType & 1) > 0 -- CVA_AF_PIPE_DATA_FLAG
						LEFT JOIN ArchFile (NOLOCK) logAF ON  J.JobId = logAF.JobId  AND (logAF.fileType & 4) > 0 -- CVA_AF_PIPE_DATA_FLAG
LEFT JOIN JMJobDataStats (NOLOCK) DataJobDataStats ON DataJobDataStats.appId = App_Application.Id AND DataJobDataStats.dataType = 1 AND DataAF.JobId = DataJobDataStats.JobId AND DataJobDataStats.CommcellId = 2 -- Data
LEFT JOIN JMJobDataStats (NOLOCK) LogJobDataStats ON  LogJobDataStats.appId =  App_Application.Id AND LogJobDataStats.dataType = 4 -- Log
						LEFT JOIN archGroupCopy (NOLOCK) DataAC ON DataAF.archGroupId = DataJobDataStats.archGrpId AND DataAC.copy = IT.copyPrecedence AND DataAC.id = DataJobDataStats.archGrpCopyId
						LEFT JOIN archGroupCopy (NOLOCK) LogAC ON LogAC.archGroupId = LogJobDataStats.archGrpId AND LogAC.copy = IT.copyPrecedence AND LogAC.id = LogJobDataStats.archGrpCopyId
						WHERE  (DataAF.JobId IS NULL OR
							( DataAF.JobId IS NOT NULL AND DataJobDataStats.jobId IS NOT NULL AND DataAC.copy IS NOT NULL)
						) AND
						(logAF.JobId IS NULL OR
							( logAF.JobId IS NOT NULL AND LogJobDataStats.jobId IS NOT NULL AND LogAC.copy IS NOT NULL)
						)
						GROUP BY App_Application.Id,IT.stId,IT.freq_interval, J.JobId
						HAVING MAX(CASE WHEN  DataAF.JobId IS NOT NULL THEN DataJobDataStats.status ELSE 100 END) = 100
						AND MIN(CASE WHEN  DataAF.JobId IS NOT NULL THEN DataJobDataStats.status ELSE 100 END) = 100
						AND MAX(CASE WHEN  logAF.JobId IS NOT NULL THEN LogJobDataStats.status ELSE 100 END) = 100
						AND MIN(CASE WHEN  logAF.JobId IS NOT NULL THEN LogJobDataStats.status ELSE 100 END) = 100
					) T
					GROUP BY subTaskId, subclientId, freq_interval
				) F
				JOIN JMBkpStats (NOLOCK) J ON J.appId = F.subclientId AND J.fullCycleNum = F.FullCycleNum
				AND J.status in (1,3,14)	--_JMSUCCESS,_PARTIALSUCCESS,_JMSUCCESSWITHWARNINGS
				AND J.opType!=14		--_Synthetic Full
				AND J.servEndDate <= (@nowUtcUnix - ISNULL(F.freq_interval*60,0) ) --In case replication job is to be launched in a delayed fashion then we pick up last backup time before the delay.
				CROSS APPLY
				(
					SELECT SUM(CASE WHEN INNERQ.DataStatus = 3 THEN 1 ELSE 0 END) auxcopied, COUNT(1) cycleSeq
					FROM JMBkpStats INNERQ
					WHERE INNERQ.appId = J.AppId AND INNERQ.fullCycleNum = J.FullCycleNum AND J.cycleSequence > INNERQ.cycleSequence AND INNERQ.Status IN (1, 3, 14)
				) T
LEFT JOIN ArchFile (NOLOCK) DataAF ON J.JobId = DataAF.JobId AND (DataAF.fileType & 1) > 0 AND DataAF.CommcellId = 2 -- CVA_AF_PIPE_DATA_FLAG
LEFT JOIN ArchFile (NOLOCK) logAF ON  J.JobId = logAF.JobId  AND (logAF.fileType & 4) > 0 AND logAF.CommcellId = 2 -- CVA_AF_PIPE_DATA_FLAG
LEFT JOIN JMJobDataStats (NOLOCK) DataJobDataStats ON DataJobDataStats.appId = J.appId AND DataJobDataStats.dataType = 1 AND DataAF.JobId = DataJobDataStats.JobId AND DataJobDataStats.CommcellId = 2 -- Data
LEFT JOIN JMJobDataStats (NOLOCK) LogJobDataStats ON  LogJobDataStats.appId =  J.appId AND LogJobDataStats.dataType = 4 AND logAF.JobId = LogJobDataStats.JobId   AND LogJobDataStats.CommcellId = 2 -- Log
				LEFT JOIN archGroupCopy (NOLOCK) DataAC ON DataAF.archGroupId = DataJobDataStats.archGrpId AND DataAC.copy = F.copyPrecedence AND DataAC.id = DataJobDataStats.archGrpCopyId
				LEFT JOIN archGroupCopy (NOLOCK) LogAC ON LogAC.archGroupId = LogJobDataStats.archGrpId AND LogAC.copy = F.copyPrecedence AND LogAC.id = LogJobDataStats.archGrpCopyId
				WHERE  F.FullCycleNumSPs = 1
				AND (DataAF.JobId IS NULL OR
							( DataAF.JobId IS NOT NULL AND DataJobDataStats.jobId IS NOT NULL AND DataAC.copy IS NOT NULL)
				) AND
				(logAF.JobId IS NULL OR
					( logAF.JobId IS NOT NULL AND LogJobDataStats.jobId IS NOT NULL AND LogAC.copy IS NOT NULL)
				)
				GROUP BY F.subclientId, J.servEndDate, J.cycleSequence, F.subTaskId, J.fullCycleNum,F.freq_interval,T.AuxCopied,T.cycleSeq
				HAVING MAX(CASE WHEN  DataAF.JobId IS NOT NULL THEN DataJobDataStats.status ELSE 100 END) = 100
						AND MIN(CASE WHEN  DataAF.JobId IS NOT NULL THEN DataJobDataStats.status ELSE 100 END) = 100
						AND MAX(CASE WHEN  logAF.JobId IS NOT NULL THEN LogJobDataStats.status ELSE 100 END) = 100
						AND MIN(CASE WHEN  logAF.JobId IS NOT NULL THEN LogJobDataStats.status ELSE 100 END) = 100
			) S
			WHERE  S.ActualCycleSeq = S.CopiedCycleSequenceNum
			GROUP BY S.subclientId, S.subTaskId
			OPTION (MAXDOP 2) --TM_GetJobCompletedPatterns and TM_DoesLiveSyncTaskNeedtoRun have high CPU usage on prodCS. So forcing MAXDOP here to avoid hogging CPU Resources.
		END
		-- Now remove entries where baseLinejob>0 and where baseLinejob isnt aux copied.
		DELETE auxCopyTable FROM #auxCopyTable auxCopyTable
		INNER JOIN #completedPattern_IdaInfoTable IT
		ON IT.copyPrecedenceApplicable = 1
		AND IT.stId = auxCopyTable.subTaskId
		AND IT.baseLineJobId > 0
		INNER JOIN JMBkpStats ON IT.baseLineJobId = JMBkpStats.jobId AND JMBkpStats.CommcellID = 2 -- DEfault commcellID
		AND auxCopyTable.maxJobEndTime<JMBkpStats.servEndDate
		--FOR A REGUALR RESTORE SCHEDULE LOOK AT THE LAST TIME A BACKUP RAN FOR THE SUBCLIENT
		UPDATE #completedPattern_IdaInfoTable
			SET lastSuccessBkupTime = ISNULL(
												(
													SELECT MAX(endDate)
													FROM
													(
														SELECT servEndDate endDate
														FROM JMBkpStats (NOLOCK) BS
														LEFT JOIN App_AppTypeGroup ON App_AppTypeGroup.typeOfGroup = 0 AND
														App_AppTypeGroup.groupName='APPGRP_FileSystemIDA'
														LEFT JOIN App_AppTypeGroupAssoc ON apId = App_AppTypeGroupAssoc.appTypeid AND App_AppTypeGroupAssoc.typeOfGroup = 0
														AND App_AppTypeGroupAssoc.appGroupId = App_AppTypeGroup.appTypeGroupId
														WHERE BS.appId = scId
														AND BS.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
														AND copyPrecedenceApplicable = 0
														-- MR 213748 Sync job running after scan marked backup job is going to pending state
														-- For FS apptype, we should update lastSuccessBkupTime  only when backup job has backed up something.
														AND (BS.dataBackedUp>0 OR (BS.dataBackedUp = 0 AND App_AppTypeGroupAssoc.typeOfGroup IS NULL) )
														AND BS.servEndDate <= (@nowUtcUnix - ISNULL(freq_interval*60,0) ) --In case replication job is to be launched in a delayed fashion then we pick up last backup time before the delay.
														AND BS.jobId >= ISNULL(baselineJobId, 0)
														UNION
														SELECT maxCopiedTime endDate
														FROM #auxCopyTable AT
														WHERE AT.subclientId = scId AND AT.subTaskId = stId
														AND copyPrecedenceApplicable = 1
AND apId NOT IN ( 22, 80  )
														UNION
														SELECT maxCopiedTime endDate
														FROM #auxCopyTable AT
														INNER JOIN App_application (NOLOCK) ON App_application.instance = instId AND (subclientstatus & (4|2))=0
														WHERE AT.subclientId = App_application.Id AND AT.subTaskId = stId
														AND copyPrecedenceApplicable = 1
AND apId IN ( 22, 80  )
													) T
												), 0
											)
WHERE apId <> 81 --For SQL, we compute lastSuccessbkpTime during insertion into #completedPattern_IdaInfoTable
			-- For SQL update last success backup time and backup level based on jobId.
			UPDATE completedPattern_IdaInfoTable
			SET lastSuccessBkupTime = JMBkpStats.servEndDate,
			bkpLevel = JMBkpStats.bkpLevel
			FROM #completedPattern_IdaInfoTable completedPattern_IdaInfoTable
			INNER JOIN JMBkpStats ON completedPattern_IdaInfoTable.jId = JMBkpStats.jobID AND
JMBkpStats.commcellId = 2
AND apId = 81
			AND completedPattern_IdaInfoTable.copyPrecedenceApplicable = 0
			-- For SQL apptype where copy precedence is involved, lets compute lastSuccessbkuptime from auxCopyTable table.
			--Update backup level where copy precedence is applicable. Its needed for SQL to avoid triggering live sync when full job is aux copied. And its not first full.
			UPDATE IdaInfoTbl
			SET bkpLevel = JMBkpStats.bkpLevel,
			lastSuccessBkupTime = AT.maxCopiedTime
			FROM #completedPattern_IdaInfoTable IdaInfoTbl
			INNER JOIN #auxCopyTable AT ON AT.subclientId = IdaInfoTbl.scId AND AT.subTaskId = IdaInfoTbl.stId
AND IdaInfoTbl.opType = 1007
			AND IdaInfoTbl.copyPrecedenceApplicable = 1
AND IdaInfoTbl.apId = 81 -- Do this for sql apptype only.
			INNER JOIN JMBkpStats ON JMBkpStats.appID = IdaInfoTbl.scId
AND JMBkpStats.commcellID = 2  -- default commcell ID
			AND JMBkpStats.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/ , 18 /*BACKUP3RD*/ ) -- No need for synthfull to identify last backup time.
			AND AT.maxJobEndTime = JMBkpStats.servEndDate
			IF EXISTS(SELECT 1 FROM #completedPattern_IdaInfoTable WHERE apId IN
			 (SELECT appTypeId FROM APP_AppTypeGroupAssoc WHERE appGroupId = 35) -- APPGRP_FileSystemIDA
			 )
			BEGIN
					UPDATE #completedPattern_IdaInfoTable
					SET lastBackupTimeAuxCopied = AT.maxJobEndTime
					FROM #completedPattern_IdaInfoTable completedPattern_IdaInfoTable
					INNER JOIN #auxCopyTable AT ON AT.subclientId = completedPattern_IdaInfoTable.scId AND AT.subTaskId = completedPattern_IdaInfoTable.stId
					AND completedPattern_IdaInfoTable.copyPrecedenceApplicable = 1
			END
		END
	--ALWAYS RUN FOR FREQUENCY FREQ_TYPE_After_Job_Completes WHEN IT IS STARTED FROM A SCHEDULE.  ALWAYS CHECK FOR IMMEDIATED JOBS WHICH IS WHEN freq_type IS NULL
IF EXISTS(SELECT * FROM #completedPattern_runTimeInfoTable WHERE freq_type <> 4096 OR (freq_type = 4096 AND @initFrom <> 5) OR freq_type IS NULL)
	BEGIN
		INSERT @replicationTable (replicationId, optionId)
		SELECT
			CASE c.value('@optionId', 'INT')
WHEN 120012	--_RST_REPLICATION_IDS
				THEN c.value('@value', 'INT')
			END, c.value('@optionId', 'INT')
		FROM @oXmlString.nodes('TMMsg_TaskOperationReq/runTaskOptions/options') R(c)
		INSERT @replicationTable (replicationId, optionId)
		SELECT
			CASE c.value('@optionId', 'INT')
WHEN 120017	--_RST_REPLICATION_FAILBACK_IDS
				THEN S.Data
			END, c.value('@optionId', 'INT')
		FROM @oXmlString.nodes('TMMsg_TaskOperationReq/runTaskOptions/options') R(c)
		CROSS APPLY dbo.SplitString(c.value('@value', 'VARCHAR(MAX)'), ',') S
		DELETE @replicationTable WHERE replicationId IS NULL --AND optionId = RST_REPLICATION_FAILBACK_IDS		--_RST_REPLICATION_FAILBACK_IDS
		-- Remove replications from completedPattern_IdaInfoTable which are not in @replicationTable
		IF EXISTS(SELECT 1 FROM @replicationTable)
		BEGIN
			DELETE completedPattern_IdaInfoTable FROM #completedPattern_IdaInfoTable
			LEFT JOIN @replicationTable replicationTable ON completedPattern_IdaInfoTable.replicationID = replicationTable.replicationID
			WHERE replicationTable.replicationID IS NULL
		END
		-- If no replication is there in #completedPattern_IdaInfoTable throw error that replication job already ran. Thats only reason why its deleted abnove.
		IF NOT EXISTS(SELECT 1 FROM #completedPattern_IdaInfoTable)
		BEGIN
SET @oErrorCode = (1957 | (CAST(POWER(2, 24) AS BIGINT) * 19))
			SET @oErrorString = dbo.fn_EvFormatEventMsgText(0, 0, @oErrorCode, 0, 2)
			DELETE #completedPattern_runTimeInfoTable
			GOTO EXIT_SP
		END
IF  (@initFrom = 1 ) -- If its gui initiated job we just need to trigger
		BEGIN
			-- Update live sync table so that RST_REPLICATION_IDS is filled.
			UPDATE APP_LiveSyncReplication
			SET status = @VSAREP_STARTING
			FROM APP_LiveSyncReplication
			INNER JOIN #completedPattern_IdaInfoTable
			ON APP_LiveSyncReplication.replicationId = #completedPattern_IdaInfoTable.replicationId
			WHERE subTaskId=@iSubTaskId
			-- Flags = 1 indicates replication pair deleted
			AND (APP_LiveSyncReplication.Flags&1)=0
			GOTO EXIT_SP
		END
		DELETE #completedPattern_runTimeInfoTable
		SET @oXmlString = NULL
		IF NOT EXISTS(SELECT * FROM #completedPattern_IdaInfoTable WHERE stId = @iSubTaskId)
		BEGIN
SET @oErrorCode = (63 | (CAST(POWER(2, 24) AS BIGINT) * 24))
			SET @oErrorString = dbo.fn_EvFormatEventMsgText(0, 0, @oErrorCode, 0, 2)
			GOTO EXIT_SP
		END
		--REMOVE ANY FOR WHICH BASE JOB HAS NOT RUN
		DELETE #completedPattern_IdaInfoTable
		FROM
		(
			SELECT RT.tkId, RT.replicationId repId
			FROM #completedPattern_IdaInfoTable RT
			WHERE
			(
				RT.baselineJobId IS NOT NULL
				AND
				(
					NOT EXISTS(SELECT 1 FROM TM_Jobs JS (NOLOCK) WHERE JS.jobId >= RT.baselineJobId)		--BASE JOBID HAS NOT BEEN CREATED
					OR
					(
						--BASE JOBID HAS NOT COMPLETED
						NOT EXISTS(
							SELECT 1 FROM JMBkpStats JS (NOLOCK) WHERE JS.appId = scId AND JS.jobId >= RT.baselineJobId
						)
						AND		--BASE JOBID IS CURRENTLY RUNNING
						EXISTS(
							SELECT 1 FROM JMBkpJobInfo JS (NOLOCK) WHERE JS.applicationId = scId AND JS.jobId >= RT.baselineJobId
						)
					)
				)
			)
			UNION
			--FOR SQL AGENT ONLY START REPLICATION AFTER TRANSACTION LOG JOBS, EXCEPT FOR THE FIRST TIME
			SELECT I.tkId, I.replicationId repId
			FROM #completedPattern_IdaInfoTable I
			JOIN APP_LiveSyncReplication R (NOLOCK) ON R.replicationId = I.replicationId
            AND I.bkpLevel IN (1, 4) --FULL, DIFFERENTIAL
			AND I.lastScheduleRunTime > 0	--AT LEAST ONE BACKUP JOB HAS RUN
AND I.apId = 81
		) T
		WHERE replicationId = T.repId
		OR lastSuccessBkupTime = 0
		IF NOT EXISTS(SELECT * FROM #completedPattern_IdaInfoTable WHERE stId = @iSubTaskId)
		BEGIN
SET @oErrorCode = (1957 | (CAST(POWER(2, 24) AS BIGINT) * 19))
			SET @oErrorString = dbo.fn_EvFormatEventMsgText(0, 0, @oErrorCode, 0, 2)
			GOTO EXIT_SP
		END
		--REMOVE ANY RUNTIME WHICH BACKUP HAS NOT RUN
		DELETE #completedPattern_IdaInfoTable
		WHERE
		lastSuccessBkupTime = 0
		IF NOT EXISTS(SELECT * FROM #completedPattern_IdaInfoTable WHERE stId = @iSubTaskId)
		BEGIN
SET @oErrorCode = (1958 | (CAST(POWER(2, 24) AS BIGINT) * 19))
			SET @oErrorString = dbo.fn_EvFormatEventMsgText(0, 0, @oErrorCode, 0, 2)
			GOTO EXIT_SP
		END
		--REMOVE ANY SYNC RESTORE JOBS WHICH HAVE ALREADY RUN AND NEW BACKUP HAS NOT COMPLETED
		DELETE #completedPattern_IdaInfoTable
		FROM #completedPattern_IdaInfoTable RT
		WHERE
		--RESTORE JOB ALREADY RAN AFTER BACKUP
		EXISTS(
			-- For FS agents, we want to delete only last backup is before last replication start. There could be cases where last aux copy/last backup ran after restore start but before restore end. And we dont trigger replication in such cases after the last backup/aux copy.
			SELECT RS.servStartTime FROM JMRestoreStats RS (NOLOCK)
			LEFT JOIN JMJobOptions ON RS.jobId = JMJobOptions.jobId
			AND JMJobOptions.attributeName='Source path'
			LEFT JOIN App_AppTypeGroup ON App_AppTypeGroup.typeOfGroup = 0 AND
			App_AppTypeGroup.groupName='APPGRP_FileSystemIDA'
			LEFT JOIN App_AppTypeGroupAssoc ON apId = App_AppTypeGroupAssoc.appTypeid AND App_AppTypeGroupAssoc.typeOfGroup = 0
			AND App_AppTypeGroupAssoc.appGroupId = App_AppTypeGroup.appTypeGroupId
			WHERE RS.subTaskId = RT.stId AND RT.baselineJobId > 0 AND RS.servEndTime > lastSuccessBkupTime
			AND (App_AppTypeGroupAssoc.typeOfGroup IS NULL OR JMJobOptions.attributeValue= restoreSource) -- For FS agents, we want to compute servEndTime based on restore source. For other agents we want to compute servEndtime based on last retsore job from schedule.
			AND freq_interval = 0
AND apId != 135
			UNION
			SELECT RS.servEndTime FROM JMRestoreStats RS (NOLOCK)
			LEFT JOIN JMJobOptions ON RS.jobId = JMJobOptions.jobId
			AND JMJobOptions.attributeName='Source path'
			LEFT JOIN App_AppTypeGroup ON App_AppTypeGroup.typeOfGroup = 0 AND
			App_AppTypeGroup.groupName='APPGRP_FileSystemIDA'
			LEFT JOIN App_AppTypeGroupAssoc ON apId = App_AppTypeGroupAssoc.appTypeid AND App_AppTypeGroupAssoc.typeOfGroup = 0
			AND App_AppTypeGroupAssoc.appGroupId = App_AppTypeGroup.appTypeGroupId
			WHERE RS.subTaskId = RT.stId AND RT.baselineJobId IS NULL
			AND (
					-- For FS agents where copy precedence is applicable, we want to look at start time of last restore job since ida uses toTime passed by scheduler during job start. For other agents we want to compute servEndtime based on last restore job end time from schedule.
					(RS.servEndTime > lastSuccessBkupTime AND
						(App_AppTypeGroupAssoc.typeOfGroup IS NULL OR copyPrecedenceApplicable != 1)
					) OR
					(RS.servStartTime > lastSuccessBkupTime AND App_AppTypeGroupAssoc.typeOfGroup IS NOT NULL AND copyPrecedenceApplicable = 1)
				)
			AND (App_AppTypeGroupAssoc.typeOfGroup IS NULL OR JMJobOptions.attributeValue= restoreSource) -- For FS agents, we want to compute servEndTime based on restore source. For other agents we want to compute servEndtime based on last retsore job from schedule.
			AND freq_interval = 0
AND apId != 135
			UNION
			SELECT RS.servStartTime FROM JMRestoreStats RS (NOLOCK)
			WHERE RS.subTaskId = RT.stId
			AND freq_interval = 0
AND apId = 135
			AND RS.servStartTime > lastSuccessBkupTime
		)
		IF NOT EXISTS(SELECT * FROM #completedPattern_IdaInfoTable WHERE stId = @iSubTaskId)
		BEGIN
SET @oErrorCode = (1960 | (CAST(POWER(2, 24) AS BIGINT) * 19))
			SET @oErrorString = dbo.fn_EvFormatEventMsgText(0, 0, @oErrorCode, 0, 2)
			GOTO EXIT_SP
		END
		IF NOT EXISTS(SELECT * FROM #completedPattern_IdaInfoTable WHERE stId = @iSubTaskId)
		BEGIN
SET @oErrorCode = (1959 | (CAST(POWER(2, 24) AS BIGINT) * 19))
			SET @oErrorString = dbo.fn_EvFormatEventMsgText(0, 0, @oErrorCode, 0, 2)
			GOTO EXIT_SP
		END
		UPDATE #completedPattern_IdaInfoTable
		SET status =
		(
			CASE
			WHEN (status IN (@VSAREP_COMPLETE, @VSAREP_ENABLED, @VSAREP_PAUSED,0)) -- If failover is done and customer immediately fails back, live sync schedule may not have run before last sync. So IDA wouldnt have updated it to VSAREP_COMPLETE status.
				AND (
						(lastScheduleRunTime < lastSuccessBkupTime AND copyPrecedenceApplicable = 0)
						--OR
						--(lastScheduleRunTime < jobEndTime AND copyPrecedenceApplicable = 1)
					)
            THEN @VSAREP_PENDING
			ELSE status
			END
		)
--
		UPDATE #completedPattern_IdaInfoTable
		SET status = @VSAREP_STARTING
		WHERE status = @VSAREP_PENDING
		-- No need for checks to update starting status since if live sync schedule pattern is changed to daily/weekly etc, then replication status isnt set to starting
		-- And hence Ida isnt processing correctly.
		BEGIN
			-- Update live sync table so that RST_REPLICATION_IDS is filled.
			Update APP_LiveSyncReplication
			SET status = RI.status
			FROM APP_LiveSyncReplication INNER JOIN #completedPattern_IdaInfoTable RI
			ON APP_LiveSyncReplication.replicationID = RI.replicationId
			AND RI.status = @VSAREP_STARTING
		END
--
		--RE-POPULATE TABLE
		INSERT #completedPattern_runTimeInfoTable		--SET freqType = 0 SO CHECK TO RUN PASSES
		(stId, taskId, patId, cgId, clId, apId, instId, bsId, scId, opType, freq_type, tkDisabled)
		SELECT DISTINCT stId, tkId, 0, cgId, clId, apId, instId, bsId, scId, opType, freq_type, tkDisabled
		FROM #completedPattern_IdaInfoTable
		GROUP BY stId, tkId, cgId, clId, apId, instId, bsId, opType, freq_type, copyPrecedenceApplicable, tkDisabled, scId
	END
IF EXISTS(SELECT 1 FROM #completedPattern_IdaInfoTable WHERE apId = 81)
		AND NOT EXISTS(SELECT * FROM #completedPattern_IdaInfoTable WHERE stId = @iSubTaskId AND status = @VSAREP_STARTING)
    BEGIN
		DELETE FROM #completedPattern_runTimeInfoTable
SET @oErrorCode = (63 | (CAST(POWER(2, 24) AS BIGINT) * 24))
        SET @oErrorString = dbo.fn_EvFormatEventMsgText(0, 0, @oErrorCode, 0, 2)
        GOTO EXIT_SP
    END
EXIT_SP:
	IF EXISTS(SELECT * FROM #completedPattern_runTimeInfoTable WHERE
(freq_type = 4096 AND @initFrom = 5)
				OR
(freq_type <> 4096)		--WAS ADDED IN CHECK IF SYNC JOB NEEDS TO RUN, SO IT SHOULD BE RUN
				OR
(@runTaskOptionIgnoreActivityCheck = 1 AND @initFrom = 3 )
				OR
(@initFrom = 1 )
			)
	BEGIN
		SET @oRunIt = 1
	END
	-- For last sync if no replication is in starting stage then block the replication job.
IF ( @runTaskOptionIgnoreActivityCheck = 1 AND @initFrom = 3
		AND NOT EXISTS(SELECT 1 FROM APP_LiveSyncReplication(NOLOCK) WHERE status = @VSAREP_STARTING AND subTaskId = @iSubTaskId)
	)
	BEGIN
		SET @oRunIt = 0
	END
	--RE-POPULATE TABLE
	DELETE #completedPattern_runTimeInfoTable
--
	--INSERT WITHOUT THE STATUS OR MULBIPLE ENTRIES WILL BE CREATED FOR THAT SCHEDULE
	INSERT #completedPattern_runTimeInfoTable
	(stId, taskId, patId, cgId, clId, apId, instId, bsId, scId, lastSuccessBkupTime, opType, freq_type, tkDisabled)
	SELECT DISTINCT stId, tkId, patId, cgId, clId, apId, instId, bsId, 0, MAX(lastSuccessBkupTime), opType, freq_type, tkDisabled
	FROM #completedPattern_IdaInfoTable
	GROUP BY stId, tkId, patId, cgId, clId, apId, instId, bsId, opType, freq_type, tkDisabled
	-- For FS ida push the toTime to CSharp layer.
	IF EXISTS(SELECT 1 FROM #completedPattern_IdaInfoTable WHERE
		(lastBackupTimeAuxCopied is NOT NULL AND lastBackupTimeAuxCopied>0 ) OR
		isDumpSweepSc>0
	)
	BEGIN
		SET @oXmlString =
			(
				SELECT INFO.replicationId '@replicationId', INFO.lastBackupTimeAuxCopied '@toTimeForRestore',
				isDumpSweepSc '@isDumpEnabledSc'
				FROM #completedPattern_IdaInfoTable INFO
				WHERE INFO.status = @VSAREP_STARTING
				FOR XML PATH('siteInfo'),ROOT('App_LiveSyncReplicationResp')
			)
	END
IF object_id('tempdb.dbo.#auxCopyTable') is not null
	DROP TABLE #auxCopyTable
IF object_id('tempdb.dbo.#completedPattern_runTimeInfoTable') is not null
	DROP TABLE #completedPattern_runTimeInfoTable
IF object_id('tempdb.dbo.#completedPattern_IdaInfoTable') is not null
	DROP TABLE #completedPattern_IdaInfoTable
IF object_id('tempdb.dbo.#completedPattern_initInfoTable') is not null
	DROP TABLE #completedPattern_initInfoTable
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_doesLiveSyncTaskNeedToRun')
	delete from GxQscripts where name = 'TM_doesLiveSyncTaskNeedToRun'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_doesLiveSyncTaskNeedToRun')
	delete from GXDBVersions where aliasname = 'TM_doesLiveSyncTaskNeedToRun'
GO

insert into GXDBVersions values(2, 'TM_doesLiveSyncTaskNeedToRun',  '00010001000200380000', 'TM_doesLiveSyncTaskNeedToRun', '00010001000200380000')
GO

