

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_deleteRestoreTasks.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_deleteRestoreTasks.sp,v $ $Id: TM_deleteRestoreTasks.sp,v 1.3.278.1 2018/03/20 00:51:16 jiechen Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 08/20/2007
-- Description:	Wrapper for GetExtendedOptionString function .
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_deleteRestoreTasks <<<'

IF EXISTS (select * from sysobjects where name='TM_deleteRestoreTasks')
	drop procedure TM_deleteRestoreTasks
IF EXISTS (select * from GxQscripts where name='TM_deleteRestoreTasks')
	delete from GxQscripts where name = 'TM_deleteRestoreTasks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_deleteRestoreTasks')
	delete from GXDBVersions where aliasname = 'TM_deleteRestoreTasks'
GO
print '... Creating Procedure: TM_deleteRestoreTasks'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_deleteRestoreTasks
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_clientId integer,
  @i_apptypeId integer,
  @i_instanceId integer,
  @i_backupsetId integer
AS
  DECLARE @o_taskId integer
  DECLARE @o_apptypeId integer
BEGIN
SET NOCOUNT ON
	DECLARE @taskIdTbl TABLE (taskId INT, apptypeId INT)
	INSERT INTO @taskIdTbl
	SELECT T.taskId, E.apptypeId FROM TM_Task AS T
	INNER JOIN TM_AssocEntity AS E ON clientId = @i_clientId AND (apptypeId = @i_apptypeId OR @i_apptypeId = 0) AND
				(instanceId = @i_instanceId OR @i_instanceId = 0) AND (backupsetId = @i_backupsetId OR @i_backupsetId = 0)
	INNER JOIN TM_SubTask AS S ON S.taskId=T.taskId AND subTaskType = 3 --ONLY RESTORE SUBTASK
	UPDATE TM_Task SET deleted=1 WHERE taskId IN (SELECT @o_taskId FROM @taskIdTbl)
	SELECT taskId AS 'o_taskId', apptypeId AS 'o_apptypeId' FROM @taskIdTbl
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_deleteRestoreTasks')
	delete from GxQscripts where name = 'TM_deleteRestoreTasks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_deleteRestoreTasks')
	delete from GXDBVersions where aliasname = 'TM_deleteRestoreTasks'
GO

insert into GXDBVersions values(2, 'TM_deleteRestoreTasks',  '00010003027800010000', 'TM_deleteRestoreTasks', '00010003027800010000')
GO

