

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_decoupleTask.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- =======================================================
-- Author:		Gokul Pattabiraman
-- Create date: 8/11/2009
-- Description:	Decouple a task for the given association
-- =======================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_decoupleTask <<<'

IF EXISTS (select * from sysobjects where name='TM_decoupleTask')
	drop procedure TM_decoupleTask
IF EXISTS (select * from GxQscripts where name='TM_decoupleTask')
	delete from GxQscripts where name = 'TM_decoupleTask'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_decoupleTask')
	delete from GXDBVersions where aliasname = 'TM_decoupleTask'
GO
print '... Creating Procedure: TM_decoupleTask'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_decoupleTask
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID integer,
  @locale_in integer,
  @i_sequenceNumber varchar(255),
  @i_taskId integer,
  @i_assocId integer,
  @errorCode integer OUTPUT,
  @errorString nvarchar(MAX) OUTPUT
AS
DECLARE @created				INT
DECLARE @alertId				INT
DECLARE @patternCount			INT
DECLARE @tzId					INT
DECLARE @spName					NVARCHAR(255)
DECLARE @logOutput				NVARCHAR(MAX)
SET @spName ='TM_decoupleTask'
set @errorCode = 0
SET @created = dbo.getunixtime(GETUTCDATE())
SELECT @tzId = attrVal FROM APP_ClientProp WHERE attrName LIKE 'Commcell timezone Id' AND modified=0 AND componentNameId=2 --COMMSERVE time zone
-- INSERTING DATA IN TABLES --
BEGIN TRY
--BEGIN TRAN
	DECLARE @position INT
		SET @position = 1
	DECLARE @taskId   INT
	DECLARE @subTaskId INT
	DECLARE @subTaskType INT
	DECLARE @operationType INT
	DECLARE @patternId INT
	--CREATE TABLE VARIABLE TO STORE THE OUTPUT OF NEWLY CREATED ID
	DECLARE @patternIdTbl table( patternId INT );
	DELETE @patternIdTbl
	DECLARE GetNewInsertedSubTask CURSOR
	FOR SELECT subTaskId, subTaskType, operationType from TM_SubTask where taskId = @i_taskId order by subTaskId
	OPEN GetNewInsertedSubTask
	FETCH GetNewInsertedSubTask INTO @subTaskId, @subTaskType, @operationType
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE @jobOptionsXML XML
		DECLARE @newSubTaskId INT
		SET @newSubTaskId = 0
		--MAKE SURE THE TALBE IS CLEARED TO AVOID DUPLICATE
		DELETE FROM @patternIdTbl
		----------
		-- TASK --
		----------
		INSERT INTO TM_Task (status,		created,		modified,		ownerId,
							 runUserId,		localeId,		initiatedFrom,	sequenceNumber,
							 taskName,		flags,			taskType,		alertId,
							 description,	deleted,		disabled,		uninstalled,
							 invalid,		defaultTask,	serial,			savedReport,
							 policytype,	origCCId,		GUID,			isEZOperation,
							 isAgentlessSRM, 	hidden )
		SELECT				 status,		created,		modified,		ownerId,
							 runUserId,		localeId,		initiatedFrom,	sequenceNumber,
'',			flags | 0x1,	2, alertId,
							 description,	deleted,		0,		uninstalled,
							 invalid,		defaultTask,	serial,			savedReport,
							 policyType,	origCCId,		NEWID(),		isEZOperation,
							 isAgentlessSRM,	hidden
		FROM TM_Task WHERE taskId = @i_taskId
		SET @taskId = @@IDENTITY
		--------------------------
		-- ASSOCIATED ENTITIES	--
		--------------------------
		INSERT INTO TM_AssocEntity (taskId,			created,	assocType,	clientGroupId,
									clientId,		apptypeId,	instanceId,	backupsetId,
									subclientId,	policyId,	copyId,		srmReportSet,
									srmReportType,	flags,		exclude,	trackingPolicyId,
									MediaAgentId,	agentlessPolicyId, workflowId,	sidbStoreId,
									libraryId,	logMonitoringPolicyId)
		SELECT						@taskId,		@created,	assocType,	clientGroupId,
									clientId,		apptypeId,	instanceId, backupsetId,
									subclientId,	policyId,	copyId,		srmReportSet,
									srmReportType,	flags,		exclude,	trackingPolicyId,
									MediaAgentId,	agentlessPolicyId,	workflowId,	sidbStoreId,
									libraryId,	logMonitoringPolicyId
		FROM TM_AssocEntity WHERE assocId = @i_assocId
		--------------
		-- SUBTASKS --
		--------------
		INSERT INTO TM_SubTask (taskId,			subTaskType,	subTaskName,	operationType,
								flags,			subTaskOrder,	deleted,		uninstalled,
								defaultTask,	subOperationType)
		SELECT					@taskId,		subTaskType,	subTaskName,	operationType,
								flags,			subTaskOrder,	deleted,		uninstalled,
								defaultTask,	subOperationType
		FROM TM_SubTask WHERE subTaskId = @subTaskId
		SET @newSubTaskId = @@IDENTITY
		-------------------------
		-- SUBTASK XML OPTIONS --
		-------------------------
		--INSERT THE SUBTASK XML OPTIONS
		INSERT INTO TM_SubTaskXMLOptions (subTaskId,		xmlValue)
		SELECT							  @newSubTaskId,	xmlValue
		FROM TM_SubTaskXMLOptions WHERE subTaskId = @subTaskId
		---------------------
		-- SUBTASK OPTIONS --
		---------------------
		--INSERT THE SUBTASK OPTIONS
		INSERT INTO TM_SubTaskOptions (subTaskId,		optionId,
									   type,			value)
		SELECT						   @newSubTaskId,	optionId,
									   type,			value
		FROM TM_SubTaskOptions WHERE subTaskId = @subTaskId
		-----------------
		-- JOB OPTIONS --
		-----------------
		EXEC TM_InsertJobOptions 0, @taskId, @newSubTaskId, @ownerID, null, 0, @errorCode, @errorString
		-------------
		-- PATTERN --
		-------------
		INSERT INTO @patternIdTbl
		SELECT patternId FROM TM_PatternAssoc
		WHERE subTaskId = @subTaskId
		DECLARE @newPatternId INT
		DECLARE GetPatternIdCursor CURSOR
		FOR SELECT patternId FROM @patternIdTbl
		OPEN GetPatternIdCursor
		FETCH GetPatternIdCursor INTO @patternId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			--INSERT THE PATTERN AT SUBTASK LEVEL IN TM_PATTERN TABLE
			INSERT INTO TM_Pattern
				(ownerId, created, modified,status, name, flags, freq_type, freq_interval, freq_relative_interval, freq_recurrence_factor,
				 freq_subday_interval, skipOccurence, skipDayNumber, active_start_date, active_start_time, active_end_date,
				 active_end_time, active_end_occurence,  tzId, calendarId, description, local_start_date, local_end_date, disabled, deleted, scheduling, freq_restart_interval)
			SELECT ownerId, created, modified,status, name, flags, freq_type, freq_interval, freq_relative_interval, freq_recurrence_factor,
				 freq_subday_interval, skipOccurence, skipDayNumber, active_start_date, active_start_time, active_end_date,
				 active_end_time, active_end_occurence,  tzId, calendarId, description, local_start_date, local_end_date, disabled, deleted, scheduling, freq_restart_interval
			FROM TM_Pattern WHERE patternId = @patternId
			SET @newPatternId = @@IDENTITY
			------------------------------
			-- SUBTASK PATTERN	ASSOCIATION--
			------------------------------
			SET @patternCount = @@ROWCOUNT
			IF (@patternCount > 0)
			BEGIN
				--INSERT THE PATTERN ASSOCIATION AT SUBTASK LEVEL
				INSERT INTO TM_PatternAssoc (subTaskId,			patternId,		flags,
											 disabled,			deleted,		scheduling)
				SELECT						 @newSubTaskId,		@newPatternId,	0,
											 0,					0,				0
			END
			FETCH GetPatternIdCursor INTO @patternId
		END
		CLOSE GetPatternIdCursor
		DEALLOCATE GetPatternIdCursor
		SET @position = @position + 1
		FETCH GetNewInsertedSubTask INTO @subTaskId, @subTaskType, @operationType
	END
	CLOSE GetNewInsertedSubTask
	DEALLOCATE GetNewInsertedSubTask
	---------------------------------------------
	-- REMOVE ASSOCIATION FROM ORIGINAL POLICY --
	---------------------------------------------
	DELETE FROM TM_AssocEntity
	WHERE assocId = @i_assocId
--COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
    -- Call procedure to get error information.
    EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
    --Close cursor
    IF ( CURSOR_STATUS('global', 'GetNewInsertedSubTask') >= 0  /* cursor is open */
        OR CURSOR_STATUS('local', 'GetNewInsertedSubTask') >= 0 )
    CLOSE GetNewInsertedSubTask
	IF ( CURSOR_STATUS('global','GetNewInsertedSubTask') = -1  /* cursor is closed */
        OR CURSOR_STATUS('local','GetNewInsertedSubTask') = -1 )
    DEALLOCATE GetNewInsertedSubTask
    IF ( CURSOR_STATUS('global', 'GetPatternIdCursor') >= 0  /* cursor is open */
        OR CURSOR_STATUS('local', 'GetPatternIdCursor') >= 0 )
    CLOSE GetPatternIdCursor
	IF ( CURSOR_STATUS('global','GetPatternIdCursor') = -1  /* cursor is closed */
        OR CURSOR_STATUS('local','GetPatternIdCursor') = -1 )
    DEALLOCATE GetPatternIdCursor
    -- Rollback any active or uncommittable transactions before
    -- inserting information in the ErrorLog
--    IF XACT_STATE() <> 0
--    BEGIN
--        ROLLBACK TRANSACTION;
--    END
END CATCH;
GO

IF EXISTS (select * from GxQscripts where name = 'TM_decoupleTask')
	delete from GxQscripts where name = 'TM_decoupleTask'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_decoupleTask')
	delete from GXDBVersions where aliasname = 'TM_decoupleTask'
GO

insert into GXDBVersions values(2, 'TM_decoupleTask',  '00000000000000000000', 'TM_decoupleTask', '00000000000000000000')
GO

