

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_cloneTask.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_cloneTask.sp,v $ $Id: TM_cloneTask.sp,v 1.12.2.2.4.2 2021/03/20 03:33:08 rengu Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 12/21/2007
-- Description:	Create a copy of the task
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_cloneTask')
BEGIN
	print '>>> Drop Stored Procedure: TM_cloneTask <<<'
	drop procedure TM_cloneTask
END
IF EXISTS (select * from GxQscripts where name='TM_cloneTask')
	delete from GxQscripts where name = 'TM_cloneTask'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_cloneTask')
	delete from GXDBVersions where aliasname = 'TM_cloneTask'
GO
print '... Creating Procedure: TM_cloneTask'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_cloneTask
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID integer,
  @locale_in integer,
  @i_sequenceNumber varchar(255),
  @i_taskId integer,
  @i_description nvarchar(max) = NULL,
  @errorCode integer OUTPUT,
  @errorString nvarchar(MAX) OUTPUT
AS
DECLARE @taskId 				INT
DECLARE @initiatedFrom			INT
DECLARE @created				INT
DECLARE @alertId				INT
DECLARE @patternCount			INT
DECLARE @spName					NVARCHAR(255)
DECLARE @logOutput				NVARCHAR(MAX)
DECLARE @oldTaskUserId INT
SET @spName ='TM_cloneTask'
set @errorCode = 0
SET @created = dbo.getunixtime(GETUTCDATE())
--INSERTING DATA IN TABLES
--  BEGIN
BEGIN TRY
BEGIN TRAN
	--------------------------
	-- TASK  --
	--------------------------
	INSERT INTO TM_Task
		( status, created, modified, ownerId, runUserId, localeId, initiatedFrom, sequenceNumber, taskName, flags, taskType, alertId, description, deleted, disabled, uninstalled, invalid, defaultTask, serial, savedReport,  policyType, isEZOperation, isAgentlessSRM, hidden)
SELECT status, @created, modified, ownerId, runUserId, localeId, initiatedFrom, sequenceNumber, taskName + ' - Clone', flags & ~536870912, taskType, alertId, ISNULL(@i_description, description), deleted, disabled, uninstalled, invalid, defaultTask,serial, savedReport, policyType, isEZOperation, isAgentlessSRM, hidden
	FROM TM_Task WHERE taskId = @i_taskId
	SET @oldTaskUserId = (SELECT ownerId FROM TM_Task WITH(NOLOCK) WHERE taskId = @i_taskId)
	SET @taskId = @@IDENTITY
	--------------------------
	--ASSOC FILTER  --
	--------------------------
	--INSERT INTO ASSOC FILTER TABLE
	INSERT INTO TM_AssocFilter
		(taskId, flags, filter_type, filter_value)
	SELECT @taskId, flags, filter_type, filter_value
	FROM TM_AssocFilter WHERE taskId = @i_taskId
	--------------------------
	-- ASSOCIATED ENTITIES	--
	--------------------------
	INSERT INTO TM_AssocEntity
		(taskId, created, assocType, clientGroupId, clientId, apptypeId, instanceId, backupsetId, subclientId, policyId, copyId, srmReportSet, srmReportType, flags, exclude, trackingPolicyId, MediaagentId, agentlessPolicyId, workflowId,
		sidbStoreId, libraryId, logMonitoringPolicyId, entityId)
	SELECT @taskId, @created, assocType, clientGroupId, clientId, apptypeId, instanceId, backupsetId, subclientId, policyId, copyId, srmReportSet, srmReportType, flags, exclude, trackingPolicyId, MediaagentId, agentlessPolicyId, workflowId,
		sidbStoreId, libraryId, logMonitoringPolicyId, entityId
	FROM TM_AssocEntity WHERE taskId = @i_taskId
	--------------------------
	-- SUBTASK OPTIONS  AND FILES --
	--------------------------
	DECLARE @position INT
	SET @position = 1
	DECLARE @subTaskId INT
	DECLARE @subTaskType INT
	DECLARE @operationType INT
	DECLARE @patternId INT
	--CREATE TABLE VARIABLE TO STORE THE OUTPUT OF NEWLY CREATED ID
	DECLARE @patternIdTbl table( patternId INT );
	DELETE @patternIdTbl
	DECLARE GetNewInsertedSubTask CURSOR
	FOR SELECT subTaskId, subTaskType, operationType from TM_SubTask where taskId = @i_taskId order by subTaskId
	OPEN GetNewInsertedSubTask
	FETCH GetNewInsertedSubTask INTO @subTaskId, @subTaskType, @operationType
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE @jobOptionsXML XML
		DECLARE @clonedSubTaskId INT
		SET @clonedSubTaskId = 0
		--MAKE SURE THE TALBE IS CLEARED TO AVOID DUPLICATE
		DELETE FROM @patternIdTbl
		INSERT INTO TM_SubTask
			(taskId, subTaskType, subTaskName, operationType, flags, subTaskOrder, deleted, uninstalled, defaultTask, subOperationType)
		SELECT @taskId, subTaskType, subTaskName, operationType, 0, subTaskOrder, deleted, uninstalled, defaultTask, subOperationType
		FROM TM_SubTask WHERE subTaskId = @subTaskId
		SET @clonedSubTaskId = @@IDENTITY
		--INSERT THE SUBTASK XML OPTIONS
		INSERT INTO TM_SubTaskXMLOptions (subTaskId, xmlValue)
		SELECT @clonedSubTaskId, xmlValue
		FROM TM_SubTaskXMLOptions WHERE subTaskId = @subTaskId
		--INSERT THE SUBTASK OPTIONS
		INSERT INTO TM_SubTaskOptions (subTaskId, optionId, type, value)
		SELECT @clonedSubTaskId, optionId, type, value
		FROM TM_SubTaskOptions WHERE subTaskId = @subTaskId
		--INSERT THE JOB XML OPTIONS
		INSERT INTO TM_JobXMLOptions(jobId, xmlValue, taskId, subTaskId, lastJobId, created, modified)
		SELECT 0, xmlValue, @taskId, @clonedSubTaskId, 0, @created, 0
		FROM TM_SubTaskXMLOptions WHERE subTaskId = @subTaskId
		--INSERT THE JOB OPTIONS
		INSERT INTO TM_JobOptions (jobId, optionId, type, value, taskId, subTaskId, lastJobId, created, modified)
		SELECT jobId, optionId, type, value, @taskid, @clonedSubTaskId, 0, @created, modified
		FROM TM_JobOptions WHERE subTaskId = @subTaskId AND jobId = 0 AND modified = 0
		DELETE @patternIdTbl
		INSERT INTO @patternIdTbl
		SELECT patternId FROM TM_PatternAssoc
		WHERE subTaskId = @subTaskId
		DECLARE @newPatternId INT
		DECLARE GetPatternIdCursor CURSOR
		FOR SELECT patternId FROM @patternIdTbl
		OPEN GetPatternIdCursor
		FETCH GetPatternIdCursor INTO @patternId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			--INSERT THE PATTERN AT SUBTASK LEVEL IN TM_PATTERN TABLE
			INSERT INTO TM_Pattern
				(ownerId, created, modified,status, name, flags, freq_type, freq_interval, freq_relative_interval, freq_recurrence_factor,
				 freq_subday_interval, skipOccurence, skipDayNumber, active_start_date, active_start_time, active_end_date,
				 active_end_time, active_end_occurence,  tzId, calendarId, description, local_start_date, local_end_date, disabled, deleted, scheduling, freq_restart_interval)
			SELECT ownerId, created, modified,status, name, flags, freq_type, freq_interval, freq_relative_interval, freq_recurrence_factor,
				 freq_subday_interval, skipOccurence, skipDayNumber, active_start_date, active_start_time, active_end_date,
				 active_end_time, active_end_occurence,  tzId, calendarId, description, local_start_date, local_end_date, disabled, deleted, scheduling, freq_restart_interval
			FROM TM_Pattern WHERE patternId = @patternId
			SET @newPatternId = @@IDENTITY
			------------------------------
			-- SUBTASK PATTERN	ASSOCTIATION--
			------------------------------
			SET @patternCount = @@ROWCOUNT
			IF (@patternCount > 0)
				--INSERT THE PATTERN ASSOCIATION AT SUBTASK LEVEL
				INSERT INTO TM_PatternAssoc (subTaskId, patternId, flags, disabled, deleted, scheduling)
				SELECT  @clonedSubTaskId, @newPatternId, 0, 0, 0, 0
			FETCH GetPatternIdCursor INTO @patternId
		END
		CLOSE GetPatternIdCursor
		DEALLOCATE GetPatternIdCursor
		SET @position = @position + 1
		FETCH GetNewInsertedSubTask INTO @subTaskId, @subTaskType, @operationType
	END
	CLOSE GetNewInsertedSubTask
	DEALLOCATE GetNewInsertedSubTask
	--Giving rights to the previous schedule policy owner who is valid
IF EXISTS(SELECT 1 FROM UMUSERS WITH(NOLOCK) WHERE flags&0x001 <> 0  AND id = @oldTaskUserId)
	BEGIN
		EXEC sec_setSchedulePolicyCreator @oldTaskUserId, @taskId, @errorCode OUTPUT, @errorString OUTPUT
	END
	ELSE
	BEGIN
		EXEC sec_setSchedulePolicyCreator @ownerID, @taskId, @errorCode OUTPUT, @errorString OUTPUT
	END
	COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
    -- Call procedure to get error information.
    EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
    --Close cursor
    IF ( CURSOR_STATUS('global', 'GetNewInsertedSubTask') >= 0  /* cursor is open */
        OR CURSOR_STATUS('local', 'GetNewInsertedSubTask') >= 0 )
    CLOSE GetNewInsertedSubTask
	IF ( CURSOR_STATUS('global','GetNewInsertedSubTask') = -1  /* cursor is closed */
        OR CURSOR_STATUS('local','GetNewInsertedSubTask') = -1 )
    DEALLOCATE GetNewInsertedSubTask
    -- Rollback any active or uncommittable transactions before
    -- inserting information in the ErrorLog
    IF XACT_STATE() <> 0
    BEGIN
        ROLLBACK TRANSACTION;
    END
END CATCH;
GO

IF EXISTS (select * from GxQscripts where name = 'TM_cloneTask')
	delete from GxQscripts where name = 'TM_cloneTask'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_cloneTask')
	delete from GXDBVersions where aliasname = 'TM_cloneTask'
GO

insert into GXDBVersions values(2, 'TM_cloneTask',  'v1.12.2.2.4.2', 'TM_cloneTask', 'v1.12.2.2.4.2')
GO

