

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_WeeklyException.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_WeeklyException.sp,v $ $Id: TM_WeeklyException.sp,v 1.6.208.1 2017/02/10 20:42:00 sjohnson Exp $";
-- =============================================
-- Author:		Anand Vibhor
-- Create date: 01/28/2006
-- Description:	Check if the new time fall in the weekly exception
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_WeeklyException <<<'

IF EXISTS (select * from sysobjects where name='TM_WeeklyException')
	drop procedure TM_WeeklyException
IF EXISTS (select * from GxQscripts where name='TM_WeeklyException')
	delete from GxQscripts where name = 'TM_WeeklyException'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_WeeklyException')
	delete from GXDBVersions where aliasname = 'TM_WeeklyException'
GO
print '... Creating Procedure: TM_WeeklyException'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_WeeklyException
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @nextRunTime integer,
  @calId integer,
  @skipOccurence integer,
  @skipDay integer,
  @skipWhen integer,
  @skipDayNumber bigint,
  @retVal integer OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
DECLARE @nextRunDateTime as DATETIME = dbo.getDateTime(@nextRunTime)
DECLARE @year as INT
DECLARE @month as INT
DECLARE @dayOfYear as INT = DATEPART(dy, @nextRunDateTime)
DECLARE @dayOfMonth as BIGINT
	EXEC GetYearMonthOfDay @nextRunTime, @calId, @month output, @year output
	SET @retVal = 0  --INITIALIZE TO FALSE
	IF @skipDayNumber > 0
	BEGIN
		SET @dayOfMonth = (datediff(second, '01/01/1970', @nextRunDateTime)-datediff(second, '01/01/1970', dbo.GetDay(0, 0, 0, @year, @month, 2)))/(24*60*60)
		IF @dayOfMonth > 62	--Custom calendars can have more than 31 days
			GOTO EXCEPTION_DONE
		SET @dayOfMonth = POWER(CAST(2 AS BIGINT), @dayOfMonth)
		IF (@skipDayNumber&@dayOfMonth) = @dayOfMonth
			SET	@retVal =  1
		GOTO EXCEPTION_DONE
	END
	DECLARE @weekOfMonth INT = 1
	DECLARE @dayOfWeek INT = 1
	DECLARE @wmCount INT = 0
	DECLARE @dwCount INT = 0
IF(@skipWhen = 0 AND @skipOccurence = 0)
	BEGIN
		SET	@retVal =  0	--RETURN NO EXCEPTION WAS DEFINED
		GOTO EXCEPTION_DONE
	END
WHILE @wmCount <= 5
	BEGIN
		IF @skipOccurence&@weekOfMonth = @weekOfMonth
		BEGIN
			--LAST OCCURRENCE
			IF @weekOfMonth = 16
			BEGIN
				--LAST WEEKDAY
				IF(@skipDay&256 = 256)
				BEGIN
					IF (DATEPART(dy,dbo.getLastWeekDay(@year, @month, @calId)) = @dayOfYear)
						SET	@retVal =  1
					ELSE
						SET	@retVal =  0
				END
				--LAST WEEKEND
				ELSE IF(@skipDay&512 = 512)
				BEGIN
					IF (DATEPART(dy,dbo.getLastWeekend(@year, @month, @calId)) = @dayOfYear)
						SET	@retVal =  1
					ELSE
						SET	@retVal =  0
				END
				--DAY
				ELSE IF(@skipDay&128 = 128)
				BEGIN
					IF (DATEPART(dy,dbo.getEndDay(@year, @month, @calId)) = @dayOfYear)
						SET	@retVal =  1
					ELSE
						SET	@retVal =  0
				END
				--ANY DAY ( SUN, ... SAT)
				ELSE
				BEGIN
					SET @dwCount = 0
					SET @dayOfWeek = 1
WHILE @dwCount <= 10
					BEGIN
						IF (@skipDay&@dayOfWeek = @dayOfWeek)
						BEGIN
							IF (DATEPART(dy,dbo.GetLastWeekDayOfMonth(@dwCount+1, @year, @month, @calId)) = @dayOfYear)
							BEGIN
								SET	@retVal =  1
								BREAK
							END
							ELSE
								SET	@retVal =  0
						END
						SET @dwCount = @dwCount + 1
						SET @dayOfWeek = POWER(2, @dwCount)
					END
				END
			END
			ELSE
			BEGIN
				--WEEKDAY
				IF(@skipDay&256 = 256)
				BEGIN
					IF (DATEPART(dy,dbo.getNthWeekDay(@wmCount, @year, @month, @calId)) = @dayOfYear)
						SET	@retVal =  1
					ELSE
						SET	@retVal =  0
				END
				--WEEKEND
				ELSE IF(@skipDay&512 = 512)
				BEGIN
					IF (DATEPART(dy,dbo.getNthWeekendDay(@wmCount, @year, @month, @calId)) = @dayOfYear)
						SET	@retVal =  1
					ELSE
						SET	@retVal =  0
				END
				--DAY
				ELSE IF(@skipDay&128 = 128)
				BEGIN
					IF (DATEPART(dy,dbo.getDay(@wmCount, 0, 0, @year, @month, @calId)) = @dayOfYear)
						SET	@retVal =  1
					ELSE
						SET	@retVal =  0
				END
				--ANY DAY (SUN, .., SAT)
				ELSE
				BEGIN
					SET @dwCount = 0
					SET @dayOfWeek = 1
WHILE @dwCount <= 10
					BEGIN
						IF (@skipDay&@dayOfWeek = @dayOfWeek)
						BEGIN
							IF (DATEPART(dy,dbo.getDay(0, @wmCount+1, @dwCount+1, @year, @month, @calId)) = @dayOfYear)
							BEGIN
								SET	@retVal =  1
								BREAK
							END
							ELSE
								SET	@retVal =  0
						END
						SET @dwCount = @dwCount + 1
						SET @dayOfWeek = POWER(2, @dwCount)
					END
				END
			END
		END
		IF @retVal =  1
			BREAK
		SET @wmCount = @wmCount + 1
		SET @weekOfMonth = POWER(2, @wmCount)
	END
EXCEPTION_DONE:
SET NOCOUNT OFF
RETURN 0
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_WeeklyException')
	delete from GxQscripts where name = 'TM_WeeklyException'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_WeeklyException')
	delete from GXDBVersions where aliasname = 'TM_WeeklyException'
GO

insert into GXDBVersions values(2, 'TM_WeeklyException',  '00010006020800010000', 'TM_WeeklyException', '00010006020800010000')
GO

