

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_TaskDelete.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_TaskDelete.sp,v $ $Id: TM_TaskDelete.sp,v 1.4.60.1 2017/02/10 20:42:00 sjohnson Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 07/28/2011
-- Description:	Delete tasks associated with entity
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_TaskDelete <<<'

IF EXISTS (select * from sysobjects where name='TM_TaskDelete')
	drop procedure TM_TaskDelete
IF EXISTS (select * from GxQscripts where name='TM_TaskDelete')
	delete from GxQscripts where name = 'TM_TaskDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_TaskDelete')
	delete from GXDBVersions where aliasname = 'TM_TaskDelete'
GO
print '... Creating Procedure: TM_TaskDelete'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_TaskDelete
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN TRY
DECLARE @errorCode		INT=0
DECLARE @errorString	NVARCHAR(1024)
	DECLARE @i_workFlowId	INT=0
	SET @i_workFlowId = ISNULL (( SELECT ref.value('@workflowId', 'NVARCHAR(36)')
					FROM @i_xmlText.nodes ('TM_DeleteTasksForEntity/entity') R(ref)), 0)
	IF @i_workFlowId > 0
	BEGIN
		UPDATE [TM_Task] SET deleted = 1 WHERE taskId IN (
			SELECT taskId FROM TM_AssocEntity WHERE workflowId = @i_workFlowId
		)
		EXEC TM_maintenance
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
END CATCH;
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
SELECT	1			         as TAG,
		NULL		         as Parent,
	@errorCode			     as [TMMsg_GenericResp!1!errorCode],
	@errorString	         as [TMMsg_GenericResp!1!errorMessage]
FOR XML EXPLICIT
SET NOCOUNT OFF
--   END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_TaskDelete')
	delete from GxQscripts where name = 'TM_TaskDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_TaskDelete')
	delete from GXDBVersions where aliasname = 'TM_TaskDelete'
GO

insert into GXDBVersions values(2, 'TM_TaskDelete',  '00010004006000010000', 'TM_TaskDelete', '00010004006000010000')
GO

