

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_SubmitAdminJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_SubmitAdminJob.sp,v $ $Id: TM_SubmitAdminJob.sp,v 1.26.50.3 2018/03/20 00:51:01 jiechen Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 09/28/2007
-- Description:	Submit the admin job for given  subtaskId
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_SubmitAdminJob <<<'

IF EXISTS (select * from sysobjects where name='TM_SubmitAdminJob')
	drop procedure TM_SubmitAdminJob
IF EXISTS (select * from GxQscripts where name='TM_SubmitAdminJob')
	delete from GxQscripts where name = 'TM_SubmitAdminJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_SubmitAdminJob')
	delete from GXDBVersions where aliasname = 'TM_SubmitAdminJob'
GO
print '... Creating Procedure: TM_SubmitAdminJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_SubmitAdminJob
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_taskId integer,
  @i_subTaskId integer,
  @i_subTaskType integer,
  @i_predjobId bigint,
  @i_initFrom integer,
  @i_sequenceNumber varchar(255),
  @o_jobId bigint OUTPUT,
  @errorCode integer OUTPUT,
  @errorString nvarchar(MAX) OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
BEGIN TRY
--BEGIN TRAN	--START THE TRANSACTION
	DECLARE @jobRequestId INT
	DECLARE @flags INT
	DECLARE @status INT
	DECLARE @operationType INT
	DECLARE @t_JobId		TABLE( jobId int )	--Temp table
	DECLARE @nowTime		INT
	DECLARE @subOperationType	XML
	SET @nowTime = dbo.GetUnixTime (GetUTCdate())
	SELECT @operationType=operationType,@subOperationType=subOperationType FROM TM_SubTask where subtaskId = @i_subTaskId
	-------------
	--ADMIN----
	-------------
IF ( @i_subTaskType = 1 OR @i_subTaskType = 4)	-- SUB_TASK_TYPE_ADMIN_
	BEGIN
		DECLARE @reportType			INT
		DECLARE @reportSet			INT
		DECLARE @reportName			NVARCHAR(1024)
		DECLARE @reportSetName		NVARCHAR(1024)
		DECLARE @clientGroupId		INT
		DECLARE @clientId			INT
		DECLARE @appTypeId			INT
		DECLARE @instanceId			INT
		DECLARE @backupSetId		INT
		DECLARE @subclientId		INT
		DECLARE @policyId			INT
		DECLARE @copyId				INT
		DECLARE @srmReportSet		INT
		DECLARE @srmReportType		INT
		DECLARE @trackingPolicyId	INT
		DECLARE @mediaAgentId	INT
		DECLARE @otherOptions		INT
		SET @reportSet = 0
		SET @reportSetName = ''
		SET @clientGroupId = 0
		SET @clientId = 0
		SET @appTypeId = 0
		SET @instanceId = 0
		SET @backupSetId = 0
		SET @subclientId = 0
		SET @policyId = 0
		SET @copyId = 0
		SET @srmReportSet = 0
		SET @srmReportType = 0
		SET @otherOptions = 0
		IF object_id('tempdb.dbo.#tmpSrmRptTbl') is not null
    					DROP TABLE #tmpSrmRptTbl
		CREATE TABLE #tmpSrmRptTbl ( reportType INT, reportName NVARCHAR(1024) )
		--IF NOT SRM REPORT, MAKE SURE THERE IS SOME DATA IN TABLE
		IF (SELECT COUNT(*) FROM #tmpSrmRptTbl) = 0
			INSERT INTO #tmpSrmRptTbl VALUES (0, '')
		--INSERT THE ENTRY IN JOB REQUEST TABLE
	    INSERT INTO TM_JobRequest SELECT @i_taskId, @i_subTaskId ,@i_subTaskType, @operationType, @i_initFrom , ownerId, dbo.GetUnixTime(GETUTCDATE()), @subOperationType FROM TM_Task where taskId = @i_taskId
		SET @jobRequestId = @@IDENTITY
		IF (EXISTS(SELECT * FROM TM_AssocEntity WHERE taskId = @i_taskId))
			SET @otherOptions = 1
		--GET ENTITY INFORMATION
		SELECT @clientGroupId=clientGroupId, @clientId=clientId, @appTypeId=apptypeId, @instanceId=instanceId, @backupSetId=backupsetId,
			@subclientId=subclientId, @policyId=policyId, @copyId=copyId, @srmReportSet=srmReportSet, @srmReportType=srmReportType,
			@trackingPolicyId = trackingPolicyId,  @mediaAgentId=MediaAgentId
			FROM TM_AssocEntity WHERE taskId = @i_taskId
		DECLARE GetSrmReportEntry CURSOR FOR
		SELECT reportType, reportName FROM #tmpSrmRptTbl
		OPEN GetSrmReportEntry
		FETCH FROM  GetSrmReportEntry INTO @reportType, @reportName
		WHILE @@FETCH_STATUS = 0
		BEGIN
			--CREATE JOB ID
			--Insert into temp table to avoid sending it as a response
			INSERT INTO @t_JobId EXEC @o_jobId = TM_GetNextJobId
			--INSERT THE JOB
			INSERT INTO TM_Jobs ( jobId, jobRequestId, predecessor, status, timeToStart)
			VALUES( @o_jobId, @jobRequestId , @i_predjobId, 0, @nowTime )
			--SET @o_jobId = @@IDENTITY
			--INSERT THE JOB OPTIONS
			INSERT INTO TM_JobOptions SELECT @o_jobId, optionId, type, value, @i_taskId, @i_subTaskId, 0, @nowTime, 0 FROM TM_SubTaskOptions where subTaskId = @i_subTaskId
			--INSERT THE JOB XML OPTIONS
			INSERT INTO TM_JobXMLOptions SELECT @o_jobId, xmlValue, @i_taskId, @i_subTaskId, 0, @nowTime, 0 FROM TM_SubTaskXMLOptions where subTaskId = @i_subTaskId
			--INSERT THE SRM REPORT TYPE
INSERT INTO TM_JobOptions VALUES ( @o_jobId, 130001, 7, CAST(@reportType as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)	--RPT_SRM_RPT_TYPE_
			--INSERT THE SRM REPORT NAME
INSERT INTO TM_JobOptions VALUES ( @o_jobId, 130002, 7, CAST(@reportName as varchar(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)	--BKP_SRM_RPT_NAME_
			--INSERT THE SRM REPORT SET
INSERT INTO TM_JobOptions VALUES ( @o_jobId, 130003, 7, CAST(@reportSet as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)	--BKP_SRM_RPT_SET_ID_
			--INSERT THE SRM REPORT SET NAME
INSERT INTO TM_JobOptions VALUES ( @o_jobId, 130004, 7, CAST(@reportSetName as varchar(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)	--BKP_SRT_RPT_SET_NAME_
			--INSERT THE SEQUENCE NUMBER FOR SCHED RUN IMMEDIATE
INSERT INTO TM_JobOptions VALUES ( @o_jobId, 140001, 15, @i_sequenceNumber, @i_taskId, @i_subTaskId, 0, @nowTime, 0)	--COM_SEQUENCE_NUMBER_
			--INSERT THE JOB LIST OPTIONS
			--INSERT INTO TM_JobFiles SELECT @o_jobId,  type, value FROM TM_SubTaskFiles where subTaskId = @i_subTaskId
			IF (@otherOptions = 1)
			BEGIN
				--INSERT THE ENTITY INFO AS OPTION
INSERT INTO TM_JobOptions VALUES ( @o_jobId, 140002, 7, CAST(@clientGroupId as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)
INSERT INTO TM_JobOptions VALUES ( @o_jobId, 140003, 7, CAST(@clientId as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)
INSERT INTO TM_JobOptions VALUES ( @o_jobId, 140004, 7, CAST(@appTypeId as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)
INSERT INTO TM_JobOptions VALUES ( @o_jobId, 140005, 7, CAST(@instanceId as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)
INSERT INTO TM_JobOptions VALUES ( @o_jobId, 140006, 7, CAST(@backupSetId as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)
INSERT INTO TM_JobOptions VALUES ( @o_jobId, 140007, 7, CAST(@subclientId as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)
INSERT INTO TM_JobOptions VALUES ( @o_jobId, 140008, 7, CAST(@policyId as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)
INSERT INTO TM_JobOptions VALUES ( @o_jobId, 140009, 7, CAST(@copyId as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)
INSERT INTO TM_JobOptions VALUES ( @o_jobId, 140010, 7, CAST(@srmReportSet as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)
INSERT INTO TM_JobOptions VALUES ( @o_jobId, 140011, 7, CAST(@srmReportType as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)
INSERT INTO TM_JobOptions VALUES ( @o_jobId, 140012, 7, CAST(@trackingPolicyId as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)
			END
			FETCH FROM  GetSrmReportEntry INTO @reportType, @reportName
		END
		CLOSE GetSrmReportEntry
		DEALLOCATE GetSrmReportEntry
		--DROP THE TEMP TABLE
		DROP TABLE 		#tmpSrmRptTbl
	END
--COMMIT TRAN
END TRY
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to get error information.
    EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
    -- Rollback any active or uncommittable transactions before
    -- inserting information in the ErrorLog
--    IF XACT_STATE() <> 0
--    BEGIN
--        ROLLBACK TRANSACTION;
--    END
END CATCH;
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_SubmitAdminJob')
	delete from GxQscripts where name = 'TM_SubmitAdminJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_SubmitAdminJob')
	delete from GXDBVersions where aliasname = 'TM_SubmitAdminJob'
GO

insert into GXDBVersions values(2, 'TM_SubmitAdminJob',  '00010026005000030000', 'TM_SubmitAdminJob', '00010026005000030000')
GO

