

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_ResetRunTimesForClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Rohith Engu
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_ResetRunTimesForClient')
BEGIN
	print '>>> Drop Stored Procedure: TM_ResetRunTimesForClient <<<'
	drop procedure TM_ResetRunTimesForClient
END
IF EXISTS (select * from GxQscripts where name='TM_ResetRunTimesForClient')
	delete from GxQscripts where name = 'TM_ResetRunTimesForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_ResetRunTimesForClient')
	delete from GXDBVersions where aliasname = 'TM_ResetRunTimesForClient'
GO
print '... Creating Procedure: TM_ResetRunTimesForClient'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_ResetRunTimesForClient
  @i_clientId INT,
  @i_subclientId INT
AS
  DECLARE @errorCode INTEGER
  DECLARE @errorString VARCHAR(MAX)
BEGIN
	-- We call this SP when timezone changes for client or VSA subclient to reset runtimes for client timezone schedules
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @nowTime   integer
	SET     @nowTime  =   dbo.GetUnixTime (GetUTCdate())
	DECLARE @isTranStarted INT = 0
	SET @errorCode = 0
	SET @errorString = ''
BEGIN TRY
	IF @i_clientId = 0 AND @i_subclientId = 0
	BEGIN
		SELECT @errorCode,@errorString
		RETURN
	END
	DECLARE @appTypeID INT = 0, @instanceID INT = 0, @backupsetID INT = 0
	IF @i_subclientId > 0
	BEGIN
		SELECT @i_clientId = clientID, @appTypeID = appTypeID , @instanceID = instance, @backupsetID = backupset
		FROM App_Application(NOLOCK) WHERE id = @i_subclientId
	END
	IF object_id('tempdb.dbo.#runTimeIds') is NOT NULL
	BEGIN
		DROP TABLE #runTimeIds
	END
	CREATE TABLE #runTimeIds
	(
		runTimeID INTEGER
	)
	CREATE CLUSTERED INDEX runTimeIds_runTimeID_Idx ON #runTimeIds(runTimeID)
	-- 1001 is client timezone.
	IF @i_subclientId = 0
	BEGIN
		INSERT INTO #runTimeIds
		SELECT TM_Runtime.runtimeID
		FROM TM_Runtime (NOLOCK)
		INNER JOIN TM_Pattern (NOLOCK) ON TM_Pattern.patternId = TM_Runtime.patternId AND TM_pattern.Deleted = 0 AND TM_pattern.tzId = 1001
		AND TM_Runtime.Processed = 0
		INNER JOIN TM_PatternAssoc (NOLOCK) ON TM_PatternAssoc.patternId = TM_Pattern.patternId
		INNER JOIN TM_SubTask (NOLOCK) ON TM_SubTask.subTaskID = TM_PatternAssoc.subTaskID
		AND TM_Subtask.subtaskType = 2 -- backup
		INNER JOIN TM_Task (NOLOCK) ON TM_Task.taskID = TM_SubTask.taskID AND TM_Task.deleted = 0
		AND TM_Task.disabled = 0
		INNER JOIN TM_Associations (NOLOCK) ON TM_Associations.taskID = TM_Task.TaskId
		WHERE TM_Associations.clientID = @i_clientId
		UNION
		SELECT TM_Runtime.runtimeID
		FROM TM_Runtime (NOLOCK)
		INNER JOIN TM_Pattern (NOLOCK) ON TM_Pattern.patternId = TM_Runtime.patternId AND TM_pattern.Deleted = 0 AND TM_pattern.tzId = 1001
		AND TM_Runtime.Processed = 0
		INNER JOIN TM_PatternAssoc (NOLOCK) ON TM_PatternAssoc.patternId = TM_Pattern.patternId
		INNER JOIN TM_SubTask (NOLOCK) ON TM_SubTask.subTaskID = TM_PatternAssoc.subTaskID
		AND TM_Subtask.subtaskType = 2 -- backup
		INNER JOIN TM_Task (NOLOCK) ON TM_Task.taskID = TM_SubTask.taskID AND TM_Task.deleted = 0
		AND TM_Task.disabled = 0
		INNER JOIN TM_AssocEntity (NOLOCK) ON TM_AssocEntity.taskID = TM_Task.TaskId
		LEFT JOIN App_ClientGroupAssoc (NOLOCK) ON App_ClientGroupAssoc.clientID = @i_clientId
		WHERE (TM_AssocEntity.clientGroupId = App_ClientGroupAssoc.clientGroupId AND TM_AssocEntity.clientGroupId>0 AND TM_AssocEntity.clientID = 0)
	END
	ELSE
	BEGIN
		INSERT INTO #runTimeIds
		SELECT TM_Runtime.runtimeID
		FROM TM_Runtime (NOLOCK)
		INNER JOIN TM_Pattern (NOLOCK) ON TM_Pattern.patternId = TM_Runtime.patternId AND TM_pattern.Deleted = 0 AND TM_pattern.tzId = 1001
		AND TM_Runtime.Processed = 0
		INNER JOIN TM_PatternAssoc (NOLOCK) ON TM_PatternAssoc.patternId = TM_Pattern.patternId
		INNER JOIN TM_SubTask (NOLOCK) ON TM_SubTask.subTaskID = TM_PatternAssoc.subTaskID
		AND TM_Subtask.subtaskType = 2 -- backup
		INNER JOIN TM_Task (NOLOCK) ON TM_Task.taskID = TM_SubTask.taskID AND TM_Task.deleted = 0
		AND TM_Task.disabled = 0
		INNER JOIN TM_Associations TM_AssocEntity (NOLOCK)  ON TM_AssocEntity.taskID = TM_Task.TaskId
		WHERE TM_AssocEntity.clientID = @i_clientId
		AND (TM_AssocEntity.appTypeID = @appTypeId OR TM_AssocEntity.appTypeID = 0)
		AND (TM_AssocEntity.instanceID = @instanceID OR TM_AssocEntity.instanceId = 0)
		AND (TM_AssocEntity.backupsetID = @backupsetID OR TM_AssocEntity.backupsetID = 0)
		AND (TM_AssocEntity.subclientID = @i_subclientId OR TM_AssocEntity.subclientID = 0)
		UNION
		SELECT TM_Runtime.runtimeID
		FROM TM_Runtime (NOLOCK)
		INNER JOIN TM_Pattern (NOLOCK) ON TM_Pattern.patternId = TM_Runtime.patternId AND TM_pattern.Deleted = 0
		AND TM_pattern.tzId = 1001 AND TM_Runtime.Processed = 0
		INNER JOIN TM_PatternAssoc (NOLOCK) ON TM_PatternAssoc.patternId = TM_Pattern.patternId
		INNER JOIN TM_SubTask (NOLOCK) ON TM_SubTask.subTaskID = TM_PatternAssoc.subTaskID
		AND TM_Subtask.subtaskType = 2 -- backup
		INNER JOIN TM_Task (NOLOCK) ON TM_Task.taskID = TM_SubTask.taskID AND TM_Task.deleted = 0
		AND TM_Task.disabled = 0
		INNER JOIN TM_AssocEntity (NOLOCK) ON TM_AssocEntity.taskID = TM_Task.TaskId
		INNER JOIN App_ClientGroupAssoc (NOLOCK) ON App_ClientGroupAssoc.clientID = @i_clientId
		WHERE (TM_AssocEntity.clientGroupId = App_ClientGroupAssoc.clientGroupId AND TM_AssocEntity.clientGroupId>0 AND TM_AssocEntity.clientID = 0)
	END
	IF NOT EXISTS(SELECT 1 FROM #runTimeIds)
	BEGIN
		GOTO EXIT_CODE
	END
	IF @@TRANCOUNT = 0
	BEGIN
	    BEGIN TRAN
	    SET @isTranStarted = 1
	END
	-- we need to recompute start time for client timezone schedules
	DELETE TM_RunTime
	FROM TM_RunTime
	INNER JOIN #runTimeIDs DeletedRunTimes
	ON DeletedRunTimes.runTimeId = TM_RunTime.runTimeId
	AND TM_RunTime.processed = 0
	IF @isTranStarted = 1
	BEGIN
		COMMIT TRAN
	END
 END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
	IF XACT_STATE() <> 0 AND @isTranStarted = 1
    BEGIN
        ROLLBACK TRANSACTION;
    END
END CATCH
EXIT_CODE:
IF object_id('tempdb.dbo.#runTimeIds') is NOT NULL
BEGIN
	DROP TABLE #runTimeIds
END
SELECT @errorCode, @errorString
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_ResetRunTimesForClient')
	delete from GxQscripts where name = 'TM_ResetRunTimesForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_ResetRunTimesForClient')
	delete from GXDBVersions where aliasname = 'TM_ResetRunTimesForClient'
GO

insert into GXDBVersions values(2, 'TM_ResetRunTimesForClient',  '00000000000000000000', 'TM_ResetRunTimesForClient', '00000000000000000000')
GO

