

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_ResetNextStartTimeForContSched.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Rohith Engu
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_ResetNextStartTimeForContSched')
BEGIN
	print '>>> Drop Stored Procedure: TM_ResetNextStartTimeForContSched <<<'
	drop procedure TM_ResetNextStartTimeForContSched
END
IF EXISTS (select * from GxQscripts where name='TM_ResetNextStartTimeForContSched')
	delete from GxQscripts where name = 'TM_ResetNextStartTimeForContSched'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_ResetNextStartTimeForContSched')
	delete from GXDBVersions where aliasname = 'TM_ResetNextStartTimeForContSched'
GO
print '... Creating Procedure: TM_ResetNextStartTimeForContSched'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_ResetNextStartTimeForContSched
  @inputXml XML,
  @oErrorCode integer OUTPUT,
  @oErrorString nvarchar(MAX) OUTPUT
AS
  DECLARE @errorCode INTEGER
  DECLARE @errorString NVARCHAR(MAX)
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @nowTime   integer
	SET     @nowTime  =   dbo.GetUnixTime (GetUTCdate())
	DECLARE @isTranStarted INT = 0
	SET @oErrorCode = 0
	SET @oErrorString = ''
BEGIN TRY
	IF object_id('tempdb.dbo.#inEntity') is NOT NULL
	BEGIN
		DROP TABLE #inEntity
	END
	IF object_id('tempdb.dbo.#runTimeIds') is NOT NULL
	BEGIN
		DROP TABLE #runTimeIds
	END
	DECLARE @recomputeLastBackupTime INT = 0 -- Only used if subclients are passed.
	DECLARE @deleteRunTimesForClientTimezoneSchedules INT = 0
	DECLARE @scPropNextBackupTime NVARCHAR(1024) = N'Next backup start time Continuous '
	DECLARE @scPropLastBackupTimeSt NVARCHAR(1024) = N'Last backup start time Continuous '
	DECLARE @scPropLastBackupTime NVARCHAR(1024) = N'Last backup start time Continuous'
	DECLARE @scPropLastBackupFailedSt NVARCHAR(1024) = N'Last Backup Failed Time '
	DECLARE @scPropLastBackupFailed NVARCHAR(1024) = N'Last Backup Failed Time'
	DECLARE @lastBackupJobFailed INT = 0
	SET @recomputeLastBackupTime = ISNULL((SELECT  ref.value('@recomputeLastBackupTime', 'INT') AS Agent
      FROM    @inputXml.nodes('App_AssociationsForNextRunTimeRecompute') R ( ref )),0)
	SET @deleteRunTimesForClientTimezoneSchedules = ISNULL((SELECT  ref.value('@deleteRunTimesForClientTimezoneSchedules', 'INT') AS Agent
      FROM    @inputXml.nodes('App_AssociationsForNextRunTimeRecompute') R ( ref )),0)
	SET @lastBackupJobFailed = ISNULL((SELECT  ref.value('@jobFailed', 'INT') AS Agent
      FROM    @inputXml.nodes('App_AssociationsForNextRunTimeRecompute') R ( ref )),0)
	-- First get all the subclients for which we need to process.
	CREATE TABLE #inEntity
	(
		entityType INTEGER,
		entityId   INTEGER,
		subTaskId  INTEGER,
		attrName   NVARCHAR(512) DEFAULT N'',
		cs_attrName INT DEFAULT 0,
		PRIMARY KEY(entityType, entityId)
	)
	CREATE TABLE #runTimeIds
	(
		runTimeID INTEGER
	)
	CREATE CLUSTERED INDEX runTimeIds_runTimeID_Idx ON #runTimeIds(runTimeID)
	INSERT INTO #inEntity(entityType,entityId,subtaskId)
	SELECT ISNULL(Tbl.Col.value('@_type_', 'int'),0),
	CASE WHEN ISNULL(Tbl.Col.value('@_type_', 'int'),0) = 3 THEN ISNULL(Tbl.Col.value('@clientId', 'int'),0) -- CLIENT_ENTITY
		WHEN ISNULL(Tbl.Col.value('@_type_', 'int'),0) = 7 THEN ISNULL(Tbl.Col.value('@subclientId', 'int'),0) -- SUBCLIENT_ENTITY
		WHEN ISNULL(Tbl.Col.value('@_type_', 'int'),0) = 28 THEN ISNULL(Tbl.Col.value('@clientGroupId', 'int'),0) -- CLIENT_GROUP_ENTITY
		END,
		ISNULL(Tbl.Col.value('(subtask/@subtaskId)[1]', 'int'),0)
	FROM @inputXml.nodes('/App_AssociationsForNextRunTimeRecompute/entity') as Tbl(Col)
	UNION
	SELECT 68,
	ISNULL(Tbl.Col.value('@subtaskId', 'int'),0),
	ISNULL(Tbl.Col.value('@subtaskId', 'int'),0)
	FROM @inputXml.nodes('/App_AssociationsForNextRunTimeRecompute/scheduleEntity') as Tbl(Col)
	IF object_id('tempdb.dbo.#SubclientsToModify') is NOT NULL
	BEGIN
		DROP TABLE #SubclientsToModify
	END
	CREATE TABLE #SubclientsToModify
	(
		id INTEGER
	)
	CREATE CLUSTERED INDEX SubclientsToModify_Id_Index ON #SubclientsToModify (id)
	UPDATE #inEntity
	SET attrName = @scPropNextBackupTime+CONVERT(NVARCHAR(10),entityId ),  -- CV_SC_PROP_NEXT_BACKUP_START_TIME '
		cs_attrName = CHECKSUM(@scPropNextBackupTime+CONVERT(NVARCHAR(10),entityId ))
	WHERE entityType = 68 -- SUBTASK_ENTITY
	-- Delete all next run times computed for subclients for subTaskIds provided in the list. Their frequency has changed. So we need to recompute next run time from their last run time again.
	-- Identify all subclients and their properties to be deleted. And put them in temp table.
	INSERT INTO #SubclientsToModify
	SELECT DISTINCT App_SubclientProp.id
	FROM App_SubclientProp (NOLOCK)
	INNER JOIN #inEntity inEntity ON
	inEntity.entityType = 68 -- SUBTASK_ENTITY
	AND App_SubclientProp.attrName = inEntity.attrName
	AND App_SubclientProp.cs_attrName = inEntity.cs_attrName
	AND App_SubclientProp.modified = 0
	-- Delete all next run times as well as last run time for specified subclients against all schedules.
	INSERT INTO #SubclientsToModify
	SELECT DISTINCT App_SubclientProp.id
	FROM App_SubclientProp (NOLOCK)
	INNER JOIN
	(
		SELECT entityId, @scPropNextBackupTime+CONVERT(NVARCHAR(10),SubtaskId ) AS AttrName,
			CHECKSUM(@scPropNextBackupTime+CONVERT(NVARCHAR(10),SubtaskId )) AS cs_attrName -- CV_SC_PROP_NEXT_BACKUP_START_TIME
		FROM
		(
			SELECT inEntity.entityId, TM_SubTask.SubtaskId
			FROM #inEntity inEntity
			INNER JOIN App_Application (NOLOCK) ON inEntity.entityType = 7 -- SUBCLIENT_ENTITY
			AND inEntity.entityId = App_application.Id
			INNER JOIN TM_Associations TM_AssocEntity (NOLOCK) ON TM_AssocEntity.clientID = App_application.clientId
			AND (TM_AssocEntity.appTypeID = App_application.appTypeId OR TM_AssocEntity.appTypeID = 0)
			AND (TM_AssocEntity.instanceID = App_application.instance OR TM_AssocEntity.instanceId = 0)
			AND (TM_AssocEntity.backupsetID = App_application.backupset OR TM_AssocEntity.backupsetID = 0)
			AND (TM_AssocEntity.subclientID = App_application.Id OR TM_AssocEntity.subclientID = 0)
			INNER JOIN TM_SubTask (NOLOCK) ON TM_SubTask.TaskID = TM_AssocEntity.TaskId
			INNER JOIN TM_PatternAssoc (NOLOCK) ON TM_PatternAssoc.subtaskId = TM_SubTask.subTaskID
			INNER JOIN TM_Pattern (NOLOCK) ON TM_PatternAssoc.patternId = TM_Pattern.patternId
AND TM_Pattern.freq_type = 4096
			INNER JOIN TM_Task (NOLOCK) ON TM_Task.taskId = TM_subtask.taskId
			AND TM_Task.disabled = 0
			AND TM_Task.deleted = 0
			UNION
			SELECT inEntity.entityId, TM_SubTask.SubtaskId
			FROM #inEntity inEntity
			INNER JOIN App_Application (NOLOCK) ON inEntity.entityType = 7 -- SUBCLIENT_ENTITY
			AND inEntity.entityId = App_application.Id
			INNER JOIN App_ClientgroupAssoc (NOLOCK) ON App_ClientgroupAssoc.clientID = app_application.clientID
			INNER JOIN TM_Associations TM_AssocEntity (NOLOCK) ON TM_AssocEntity.clientGroupID = App_ClientgroupAssoc.clientGroupID
			INNER JOIN TM_SubTask (NOLOCK) ON TM_SubTask.TaskID = TM_AssocEntity.TaskId
			INNER JOIN TM_PatternAssoc (NOLOCK) ON TM_PatternAssoc.subtaskId = TM_SubTask.subTaskID
			INNER JOIN TM_Pattern (NOLOCK) ON TM_PatternAssoc.patternId = TM_Pattern.patternId
AND TM_Pattern.freq_type = 4096
			INNER JOIN TM_Task (NOLOCK) ON TM_Task.taskId = TM_subtask.taskId
			AND TM_Task.disabled = 0
			AND TM_Task.deleted = 0
		) T
	) inEntity ON inEntity.entityId = App_SubclientProp.componentnameId
	AND App_SubclientProp.attrName =inEntity.AttrName
	AND App_SubclientProp.cs_attrName = inEntity.cs_attrName
	AND App_SubclientProp.modified = 0
	IF @recomputeLastBackupTime = 1
	BEGIN
		UPDATE inEntity
SET attrName = CASE WHEN appTypeId = 137 OR appTypeId = 81 THEN @scPropLastBackupTimeSt+CONVERT(NVARCHAR(10),subTaskId)
		ELSE @scPropLastBackupTime END, -- CV_SC_PROP_LAST_BACKUP_START_TIME
cs_attrName = CHECKSUM(CASE WHEN appTypeId = 137 OR appTypeId = 81 THEN @scPropLastBackupTimeSt+CONVERT(NVARCHAR(10),subTaskId)
		ELSE @scPropLastBackupTime END)
		FROM #inEntity inEntity
		INNER JOIN App_application (NOLOCK) ON App_application.id = inEntity.entityId
		AND inEntity.entityType = 7 -- SUBCLIENT_ENTITY
		INSERT INTO #SubclientsToModify
		SELECT DISTINCT App_SubclientProp.id
		FROM App_SubclientProp (NOLOCK)
		INNER JOIN #inEntity inEntity ON
		inEntity.entityType = 7 -- SUBCLIENT_ENTITY
		AND inEntity.entityId = App_SubclientProp.componentnameId
		AND App_SubclientProp.attrName = inEntity.attrName
		AND App_SubclientProp.cs_attrName = inEntity.cs_attrName
		AND App_SubclientProp.modified = 0
	END
	-- If client or client group is specified, then remove next backup time computed for their subclients.
	INSERT INTO #SubclientsToModify
	SELECT DISTINCT App_SubclientProp.ID FROM App_SubclientProp (NOLOCK)
	INNER JOIN
	(
		SELECT Id, @scPropNextBackupTime+CONVERT(NVARCHAR(10),SubtaskId ) AS AttrName, -- CV_SC_PROP_NEXT_BACKUP_START_TIME
			CHECKSUM(@scPropNextBackupTime+CONVERT(NVARCHAR(10),SubtaskId )) as cs_attrName
		FROM
		(
			SELECT App_application.Id, TM_SubTask.SubtaskId
			FROM #inEntity inEntity
			INNER JOIN App_Application (NOLOCK) ON inEntity.entityType = 3 -- CLIENT_ENTITY
			AND inEntity.entityId = App_application.clientId
			INNER JOIN TM_Associations TM_AssocEntity (NOLOCK) ON TM_AssocEntity.clientID = App_application.clientId
			INNER JOIN TM_SubTask (NOLOCK) ON TM_SubTask.TaskID = TM_AssocEntity.TaskId
			INNER JOIN TM_PatternAssoc (NOLOCK) ON TM_PatternAssoc.subtaskId = TM_SubTask.subTaskID
			INNER JOIN TM_Pattern (NOLOCK) ON TM_PatternAssoc.patternId = TM_Pattern.patternId
AND TM_Pattern.freq_type = 4096
			INNER JOIN TM_Task (NOLOCK) ON TM_Task.taskId = TM_subtask.taskId
			AND TM_Task.disabled = 0
			AND TM_Task.deleted = 0
			UNION
			SELECT App_application.Id, TM_SubTask.SubtaskId
			FROM #inEntity inEntity
			INNER JOIN App_Application (NOLOCK) ON inEntity.entityType = 3 -- CLIENT_ENTITY
			AND inEntity.entityId = App_application.clientId
			INNER JOIN App_ClientgroupAssoc (NOLOCK) ON App_ClientgroupAssoc.clientID = app_application.clientID
			INNER JOIN TM_Associations TM_AssocEntity (NOLOCK) ON TM_AssocEntity.clientGroupID = App_ClientgroupAssoc.clientGroupID
			INNER JOIN TM_SubTask (NOLOCK) ON TM_SubTask.TaskID = TM_AssocEntity.TaskId
			INNER JOIN TM_PatternAssoc (NOLOCK) ON TM_PatternAssoc.subtaskId = TM_SubTask.subTaskID
			INNER JOIN TM_Pattern (NOLOCK) ON TM_PatternAssoc.patternId = TM_Pattern.patternId
AND TM_Pattern.freq_type = 4096
			INNER JOIN TM_Task (NOLOCK) ON TM_Task.taskId = TM_subtask.taskId
			AND TM_Task.disabled = 0
			AND TM_Task.deleted = 0
		) T
	) inEntity ON inEntity.Id = App_SubclientProp.componentnameId
	AND App_SubclientProp.attrName =inEntity.AttrName
	AND App_SubclientProp.cs_attrName = inEntity.cs_attrName
	AND App_SubclientProp.modified = 0
	IF EXISTS(SELECT 1 FROM #inEntity WHERE entityType = 3)
	BEGIN
		INSERT INTO #runTimeIds
		SELECT DISTINCT TM_Runtime.runtimeID
		FROM TM_Runtime (NOLOCK)
		INNER JOIN TM_Pattern (NOLOCK) ON TM_Pattern.patternId = TM_Runtime.patternId AND TM_pattern.Deleted =0 AND TM_Pattern.tzId = 1001 --- pattern is using client timezone.
		AND TM_Runtime.Processed = 0
		INNER JOIN TM_PatternAssoc (NOLOCK) ON TM_PatternAssoc.patternId = TM_Pattern.patternId
		INNER JOIN TM_SubTask (NOLOCK) ON TM_SubTask.subTaskID = TM_PatternAssoc.subTaskID
		INNER JOIN TM_Task (NOLOCK) ON TM_Task.taskID = TM_SubTask.taskID AND TM_Task.deleted = 0
AND (TM_Task.flags & 536870912 ) <> 0		-- _PLAN_ASSOCIATED_ENTITY
		INNER JOIN
		(
			SELECT TM_AssocEntity.taskID FROM TM_AssocEntity(NOLOCK)
			INNER JOIN #inEntity inEntity ON inEntity.entityType = 3  -- CLIENT_ENTITY
			LEFT JOIN App_ClientGroupAssoc (NOLOCK) ON App_ClientGroupAssoc.clientID = inEntity.entityId
			WHERE (TM_AssocEntity.clientID = inEntity.entityId AND inEntity.entityId>0) OR
			(TM_AssocEntity.clientGroupId = App_ClientGroupAssoc.clientGroupId AND TM_AssocEntity.clientGroupId>0)
			UNION
			SELECT TM_AssocEntity.taskID FROM TM_AssocEntity(NOLOCK)
			INNER JOIN #inEntity inEntity ON inEntity.entityType = 3  -- CLIENT_ENTITY
			INNER JOIN App_Application (NOLOCK) ON App_application.clientId = inEntity.entityId
			INNER JOIN App_SubclientProp SCP (NOLOCK) ON SCP.componentNameID = App_Application.ID AND SCP.attrName = 'Associated Plan' AND SCP.cs_attrName = CHECKSUM(N'Associated Plan')
			AND CAST(TM_AssocEntity.entityId AS NVARCHAR(10)) = SCP.attrVal
			AND TM_AssocEntity.assoctype = 158-- plan entity
			AND SCP.Modified = 0
		) Tasks
		ON Tasks.taskID = TM_Task.TaskId
	END
	-- For VSA subclients when job start time is changed recompute for schedules this subclient is associated to
	IF (@deleteRunTimesForClientTimezoneSchedules = 1)
	BEGIN
	IF EXISTS(SELECT 1 FROM #inEntity inEntity INNER JOIN App_application (NOLOCK) ON inEntity.entityType = 7 AND inEntity.entityId = App_application.ID
		AND App_application.appTypeId = 106) -- Virtual server
	BEGIN
		INSERT INTO #runTimeIds
		SELECT DISTINCT TM_Runtime.runtimeID
		FROM TM_Runtime (NOLOCK)
		INNER JOIN TM_Pattern (NOLOCK) ON TM_Pattern.patternId = TM_Runtime.patternId AND TM_pattern.Deleted =0
		AND TM_Pattern.tzId = 1001 --- pattern is using client timezone.
		AND TM_Runtime.Processed = 0
		INNER JOIN TM_PatternAssoc (NOLOCK) ON TM_PatternAssoc.patternId = TM_Pattern.patternId
		INNER JOIN TM_SubTask (NOLOCK) ON TM_SubTask.subTaskID = TM_PatternAssoc.subTaskID
		AND TM_Subtask.subtaskType = 2 -- backup
		INNER JOIN TM_Task (NOLOCK) ON TM_Task.taskID = TM_SubTask.taskID AND TM_Task.deleted = 0
AND (TM_Task.flags & 536870912 ) <> 0		-- _PLAN_ASSOCIATED_ENTITY
		INNER JOIN
		(
			SELECT TM_AssocEntity.taskId FROM TM_AssocEntity (NOLOCK)
			INNER JOIN #inEntity inEntity ON inEntity.entityType = 7  -- subclient_entity
			INNER JOIN App_application (NOLOCK) ON inEntity.entityId = App_application.ID
			LEFT JOIN App_ClientGroupAssoc (NOLOCK) ON App_ClientGroupAssoc.clientID = App_application.clientId
			WHERE (
				(TM_AssocEntity.clientID = App_application.clientID )
				AND (TM_AssocEntity.appTypeID = App_application.appTypeId OR TM_AssocEntity.appTypeID = 0)
				AND (TM_AssocEntity.instanceID = App_application.instance OR TM_AssocEntity.instanceId = 0)
				AND (TM_AssocEntity.backupsetID = App_application.backupset OR TM_AssocEntity.backupsetID = 0)
				AND (TM_AssocEntity.subclientID = App_application.ID OR TM_AssocEntity.subclientID = 0)
			)
			OR (TM_AssocEntity.clientGroupId = App_ClientGroupAssoc.clientGroupId AND TM_AssocEntity.clientGroupId>0 AND TM_assocentity.clientID = 0)
			UNION
			SELECT TM_AssocEntity.taskId FROM TM_AssocEntity (NOLOCK)
			INNER JOIN #inEntity inEntity ON inEntity.entityType = 7  -- subclient_entity
			INNER JOIN App_SubclientProp SCP (NOLOCK) ON SCP.componentNameID = inEntity.entityId AND SCP.attrName = 'Associated Plan' AND SCP.cs_attrName = CHECKSUM(N'Associated Plan')
			AND CAST(TM_AssocEntity.entityId AS NVARCHAR(10)) = SCP.attrVal
			AND TM_AssocEntity.assoctype = 158-- plan entity
			AND SCP.Modified = 0
		) Tasks
		ON Tasks.taskID = TM_Task.TaskId
	END
	END
	--If last backup job failled for RPO schedule then we need to Set the current time as property value for it on subclients
	IF @lastBackupJobFailed = 1
	BEGIN
		UPDATE inEntity
SET attrName = CASE WHEN appTypeId = 137 OR appTypeId = 81 THEN @scPropLastBackupFailedSt+CONVERT(NVARCHAR(10),subTaskId)
		ELSE @scPropLastBackupFailed END,  -- CV_SC_PROP_LAST_BACKUP_FAILED_TIME
cs_attrName = CHECKSUM(CASE WHEN appTypeId = 137 OR appTypeId = 81 THEN @scPropLastBackupFailedSt+CONVERT(NVARCHAR(10),subTaskId)
		ELSE @scPropLastBackupFailed END)
		FROM #inEntity inEntity
		INNER JOIN App_application (NOLOCK) ON App_application.id = inEntity.entityId
		AND inEntity.entityType = 7 -- SUBCLIENT_ENTITY
		UPDATE SCP SET SCP.attrVal = @nowTime, SCP.created = @nowTime
		FROM App_SubclientProp SCP
		INNER JOIN #inEntity inEntity
		ON inEntity.entityId = SCP.componentNameId AND inEntity.entityType = 7
		AND SCP.attrName = inEntity.attrName
		AND SCP.cs_attrName = inEntity.cs_attrName
		AND SCP.modified = 0
		INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
		SELECT DISTINCT inEntity.entityId, inEntity.attrName, 7, @nowTime, @nowTime,0,0
		FROM #inEntity inEntity
		LEFT JOIN APP_SubClientProp SCP ON inEntity.entityId = SCP.componentNameId
		AND	SCP.attrname = inEntity.attrName
		AND SCP.cs_attrName = inEntity.cs_attrName
		AND SCP.modified = 0
		WHERE inEntity.entityType = 7 --SUBCLIENT_ENTITY
		AND SCP.attrVal IS NULL
	END
	IF @@TRANCOUNT = 0
	BEGIN
		BEGIN TRAN
		SET @isTranStarted = 1
	END
	DELETE App_SubclientProp FROM App_SubclientProp
	INNER JOIN #SubclientsToModify T
	ON T.ID = App_SubclientProp.Id
	-- Also when job start time on client is modified, then we need to recompute start time for client timezone schedules
	IF EXISTS(SELECT 1 FROM #runTimeIds)
	BEGIN
		DELETE TM_RunTime
		FROM TM_RunTime
		INNER JOIN #runTimeIds DeletedRunTimes
		ON DeletedRunTimes.runTimeId = TM_RunTime.runTimeId
		AND TM_RunTime.processed = 0
	END
	IF @isTranStarted = 1
	BEGIN
		COMMIT TRAN
	END
 END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	EXECUTE dbo.GetError @oErrorString OUTPUT , @oErrorCode OUTPUT
	IF XACT_STATE() <> 0 AND @isTranStarted = 1
    BEGIN
        ROLLBACK TRANSACTION;
    END
END CATCH
	IF object_id('tempdb.dbo.#inEntity') is NOT NULL
	BEGIN
		DROP TABLE #inEntity
	END
	IF object_id('tempdb.dbo.#runTimeIds') is NOT NULL
	BEGIN
		DROP TABLE #runTimeIds
	END
	SELECT @oErrorCode, @oErrorString
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_ResetNextStartTimeForContSched')
	delete from GxQscripts where name = 'TM_ResetNextStartTimeForContSched'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_ResetNextStartTimeForContSched')
	delete from GXDBVersions where aliasname = 'TM_ResetNextStartTimeForContSched'
GO

insert into GXDBVersions values(2, 'TM_ResetNextStartTimeForContSched',  '00000000000000000000', 'TM_ResetNextStartTimeForContSched', '00000000000000000000')
GO

