

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_RemoveEntityFromOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_RemoveEntityFromOptions.sp,v $ $Id: TM_RemoveEntityFromOptions.sp,v 1.4.60.1 2017/02/10 20:42:00 sjohnson Exp $";
-- ==========================================================
-- Author:		Sergio Bonilla
-- Create date: 03/28/2010
-- Description:	Removes entities from job options
-- ==========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_RemoveEntityFromOptions <<<'

IF EXISTS (select * from sysobjects where name='TM_RemoveEntityFromOptions')
	drop procedure TM_RemoveEntityFromOptions
IF EXISTS (select * from GxQscripts where name='TM_RemoveEntityFromOptions')
	delete from GxQscripts where name = 'TM_RemoveEntityFromOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_RemoveEntityFromOptions')
	delete from GXDBVersions where aliasname = 'TM_RemoveEntityFromOptions'
GO
print '... Creating Procedure: TM_RemoveEntityFromOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_RemoveEntityFromOptions
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_clientId integer,
  @i_appTypeId integer,	
  @i_instanceId integer=0,	
  @i_backupSetId integer=0,	
  @i_subClientId integer=0,	
  @i_userId integer=1,
  @i_localeId integer=0,
  @errorCode integer OUTPUT,
  @errorString NVARCHAR(MAX) OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
DECLARE @xmlValue		XML
DECLARE @var			XML
DECLARE @iCount			INT
DECLARE @i				INT
DECLARE @subTaskId		INT
DECLARE @tempXml		XML
DECLARE @elementName	VARCHAR(100)
BEGIN TRY
	DECLARE entityOptionCursor CURSOR FOR
	SELECT subTaskId, xmlValue
	FROM TM_subTaskXMLOptions WITH (NOLOCK)
	WHERE (xmlValue.exist('//./@_type_[.="3"]')=1 AND @i_clientId <> 0)		--ENTITY_TYPE_CLIENT_ENTITY
	OR (xmlValue.exist('//./@_type_[.="4"]')=1 AND @i_appTypeId <> 0)		--ENTITY_TYPE_APPTYPE_ENTITY
	OR (xmlValue.exist('//./@_type_[.="5"]')=1 AND @i_instanceId <> 0)		--ENTITY_TYPE_INSTANCE_ENTITY
	OR (xmlValue.exist('//./@_type_[.="6"]')=1 AND @i_backupSetId <> 0)		--ENTITY_TYPE_BACKUPSET_ENTITY
	OR (xmlValue.exist('//./@_type_[.="7"]')=1 AND @i_subClientId <> 0)		--ENTITY_TYPE_SUBCLIENT_ENTITY
	OPEN entityOptionCursor
	FETCH NEXT FROM entityOptionCursor INTO @subTaskId, @xmlValue
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @i = 1
		SET @iCount = ISNULL((SELECT @xmlValue.value('count(//.[@_type_])','int')), 0)
		WHILE (@i <= @iCount)
		BEGIN
			--RECALCULATE NUMBER OF ELEMENTS AFTER ELEMENT IS DELETED
			SET @iCount = ISNULL((SELECT @xmlValue.value('count(//.[@_type_])','int')), 0)
			SET @tempXml = @xmlValue.query('(//.[@_type_])[sql:variable("@i")]')
			--GET THE ENTITY ELEMENT NAME
			SET @elementName = (SELECT x.y.value('local-name(.)', 'VARCHAR(50)')
									FROM @tempXml.nodes('//*') AS x(y))
			--REMOVE CLIENT ENTITY OPTIONS
			IF @i_clientId > 0 AND (@xmlValue.query('(//.[@_type_])[sql:variable("@i")]')).value('(//./@clientId)[1]', 'int') = @i_clientId
			BEGIN
				--SET @xmlValue.modify('delete (//*[local-name() = sql:variable("@elementName")])[sql:variable("@i")]')
				SET @xmlValue.modify('delete ((//../*[local-name() = sql:variable("@elementName")])/@clientId[. = sql:variable("@i_clientId")]/..)')
			END
			--REMOVE APPLICATION ENTITY OPTIONS
			IF @i_appTypeId > 0 AND (@xmlValue.query('(//.[@_type_])[sql:variable("@i")]')).value('(//./@applicationId)[1]', 'int') = @i_appTypeId
			BEGIN
				SET @xmlValue.modify('delete ((//../*[local-name() = sql:variable("@elementName")])/@applicationId[. = sql:variable("@i_appTypeId")]/..)')
			END
			--REMOVE INSTANCE ENTITY OPTIONS
			IF @i_instanceId > 0 AND (@xmlValue.query('(//.[@_type_])[sql:variable("@i")]')).value('(//./@instanceId)[1]', 'int') = @i_instanceId
			BEGIN
				SET @xmlValue.modify('delete ((//../*[local-name() = sql:variable("@elementName")])/@instanceId[. = sql:variable("@i_instanceId")]/..)')
			END
			--REMOVE BACKUPSET ENTITY OPTIONS
			IF @i_backupSetId > 0 AND (@xmlValue.query('(//.[@_type_])[sql:variable("@i")]')).value('(//./@backupsetId)[1]', 'int') = @i_backupSetId
			BEGIN
				SET @xmlValue.modify('delete ((//../*[local-name() = sql:variable("@elementName")])/@backupsetId[. = sql:variable("@i_backupSetId")]/..)')
			END
			--REMOVE SUBCLIENT ENTITY OPTIONS
			IF @i_subClientId > 0 AND (@xmlValue.query('(//.[@_type_])[sql:variable("@i")]')).value('(//./@subclientId)[1]', 'int') = @i_subClientId
			BEGIN
				SET @xmlValue.modify('delete ((//../*[local-name() = sql:variable("@elementName")])/@subclientId[. = sql:variable("@i_subClientId")]/..)')
			END
			UPDATE TM_SubTaskXMLOptions SET xmlValue=@xmlValue WHERE subTaskId=@subTaskId
			SET @i = @i + 1
		END
		FETCH NEXT FROM entityOptionCursor INTO @subTaskId, @xmlValue
	END
	CLOSE entityOptionCursor
	DEALLOCATE entityOptionCursor
END TRY
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to get error information.
    EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
	--Close cursor
	IF ( CURSOR_STATUS('global', 'entityOptionCursor') >= 0  /* cursor is open */
		OR CURSOR_STATUS('local', 'entityOptionCursor') >= 0 )
		CLOSE entityOptionCursor
	IF ( CURSOR_STATUS('global','entityOptionCursor') = -1  /* cursor is closed */
		OR CURSOR_STATUS('local','entityOptionCursor') = -1 )
		DEALLOCATE entityOptionCursor
END CATCH;
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_RemoveEntityFromOptions')
	delete from GxQscripts where name = 'TM_RemoveEntityFromOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_RemoveEntityFromOptions')
	delete from GXDBVersions where aliasname = 'TM_RemoveEntityFromOptions'
GO

insert into GXDBVersions values(2, 'TM_RemoveEntityFromOptions',  '00010004006000010000', 'TM_RemoveEntityFromOptions', '00010004006000010000')
GO

