

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_ProcessOSCRequest.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_ProcessOSCRequest.sp,v $ $Id: TM_ProcessOSCRequest.sp,v 1.10.60.5 2020/08/27 21:13:23 kvankadaru Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Description:	Process the automatic schedule request for Install Update/Install client jobs
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='TM_ProcessOSCRequest')
BEGIN
	print '>>> Drop Stored Procedure: TM_ProcessOSCRequest <<<'
	drop procedure TM_ProcessOSCRequest
END
IF EXISTS (select * from GxQscripts where name='TM_ProcessOSCRequest')
	delete from GxQscripts where name = 'TM_ProcessOSCRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_ProcessOSCRequest')
	delete from GXDBVersions where aliasname = 'TM_ProcessOSCRequest'
GO
print '... Creating Procedure: TM_ProcessOSCRequest'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_ProcessOSCRequest
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_taskId integer,
  @i_subTaskId integer,	
  @i_userId integer,
  @i_association XML,
  @o_jobIsRunning integer OUTPUT,
  @o_jobId bigint OUTPUT,
  @errorCode integer OUTPUT,
  @errorString nvarchar(MAX) OUTPUT
AS
BEGIN TRY
	DECLARE @maxNumOfClientsPerJob	INT = 1000
	DECLARE @maxJobRunTime			INT = 6
	DECLARE @maxWaitForUpgradeRetry	INT = 12
	DECLARE @nowTime				INT = dbo.GetUnixTime (GETUTCDATE())
	DECLARE @clientId				INT = 0
	DECLARE @clientName				NVARCHAR(255)
	DECLARE @jmJobRunningForClient	INT = 0
DECLARE @isUpgrade				INT = (SELECT value FROM TM_SubTaskOptions WHERE subTaskId=@i_subTaskId AND optionId = 967538445 )
	DECLARE @jmOpType				INT = 35 /*PATCHUPDATE*/
	DECLARE @subTaskOperationType   INT = 0
	DECLARE @clntXML XML
	SELECT @subTaskOperationType = operationType FROM TM_SubTask (NOLOCK) WHERE subtaskId = @i_subTaskId
	IF @subTaskOperationType = 4026 /*INSTALL_CLIENT = 4026*/
	BEGIN
		SET @jmOpType				=  67 /* INSTALLCLIENT = 67*/
	END
	SET @errorCode = 0
	SET @o_jobIsRunning = 0
	SET @maxNumOfClientsPerJob = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='MaximumNumberOfUpdatesJobsFromOSC'), @maxNumOfClientsPerJob)
	SET @maxJobRunTime = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='MaximumRunTimeForUpdatesJobsFromOSC'), @maxJobRunTime)
	SET @maxWaitForUpgradeRetry = ISNULL((SELECT value FROM GXGlobalParam WITH (NOLOCK) WHERE name='WaitTimeToRetryUpgradeJobsFromOSC'), @maxWaitForUpgradeRetry)
	SET @maxJobRunTime = (@maxJobRunTime*60*60)
	SET @maxWaitForUpgradeRetry = (@maxWaitForUpgradeRetry*60*60)
	--Get the client Information for OSC install update/install client request
	SELECT @clientId = ref.value('@clientId', 'INT'), @clientName = CL.name
	FROM @i_association.nodes ('/TMMsg_OperationEntity/associations') R(ref)
	LEFT OUTER JOIN APP_Client CL ON CL.id = ref.value('@clientId', 'INT')
	IF @clientId < 2 OR @clientName is null
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Invalid clientId [' + CAST(@clientId AS NVARCHAR(10)) + ']'
		GOTO EXIT_PROCESS_UPDATE_JOBS
	END
	-- Case 1 : First check if job is submitted for the client, but not picked up by JM. There should be 1 if any.
	SELECT TOP 1 @o_jobId = TMJOBS.jobId
	FROM TM_Jobs TMJOBS -- only committed rows
	INNER JOIN TM_JobOptions OPT WITH (NOLOCK) ON TMJOBS.jobId = OPT.jobId AND modified = 0
	INNER JOIN TM_JobRequest TMJOBREQ WITH (NOLOCK) ON TMJOBS.jobRequestId = TMJOBREQ.jobRequestId
	WHERE OPT.optionId = 130007 /*ADM_INSTALL_UPDATES_CLIENTS*/ AND (CAST(OPT.value AS INT) = @clientId) -- Same client
	AND TMJOBREQ.subTaskId = @i_subTaskId -- Same schedule
	AND ( TMJOBS.status = 0 OR ( (TMJOBS.status & 1) = 1 ) ) -- Not picked by JM
	IF @o_jobId <> 0
	BEGIN
		-- This means job is submitted for client but not picked up but JM. Just return job ID and exit.
		-- We are done
		SET @o_jobIsRunning = 1
		GOTO EXIT_PROCESS_UPDATE_JOBS
	END
	-- Case 2 : Now check if job is already running for this client. There should be only 1 if any.
	SELECT TOP 1 @o_jobId = JINFO.jobId
	FROM JMAdminJobInfoTable JINFO -- only committed rows
	INNER JOIN JMQinetixUpdateStatus JUPDATE WITH (NOLOCK) ON JINFO.jobId = JUPDATE.jobId AND JUPDATE.commCellId = JINFO.commCellId
	WHERE JUPDATE.clientId = @clientId -- Same client
	AND JINFO.subTaskId = @i_subTaskId -- Same schedule
	AND JINFO.commCellId = 2 /* DEFAULT_COMMCELL_ID */
	IF @o_jobId <> 0
	BEGIN
		-- A job is already running for the client. Just update the JMQinetixUpdateStatus table and exit
		IF (@isUpgrade = 1) --MR95203 - WAIT SOME TIME BEFORE RESUBMITTING THE UPGRADE JOB FOR CLIENT
		BEGIN
			UPDATE JMQinetixUpdateStatus SET status=5001 /*QGENERIC_TO_BE_DONE*/, category=7 /*QCATECORY_WAITING*/
			WHERE jobId=@o_jobId
			AND category in (3, /*QCATEGORY_FAILED*/
							 2, /*QCATEGORY_PENDING*/
							 0, /*QCATEGORY_UNKNOWN*/
							 6, /*QCATECORY_OPERATION_NOT_SUPPORTED*/
							 8 /*QCATEGORY_PARTIAL_SUCCESS*/
							)
			AND clientId = @clientId AND EXISTS (SELECT 1 FROM JMAdminJobInfoTable WHERE jobId = @o_jobId AND @nowTime > (servStart+@maxWaitForUpgradeRetry))
		END
		ELSE
		BEGIN
			UPDATE JMQinetixUpdateStatus SET status=5001 /*QGENERIC_TO_BE_DONE*/, category=7 /*QCATECORY_WAITING*/
			WHERE jobId=@o_jobId
			AND category in (3, /*QCATEGORY_FAILED*/
							 2, /*QCATEGORY_PENDING*/
							 0, /*QCATEGORY_UNKNOWN*/
							 6, /*QCATECORY_OPERATION_NOT_SUPPORTED*/
							 8 /*QCATEGORY_PARTIAL_SUCCESS*/
							)
			AND clientId = @clientId
		END
		-- We are done
		SET @o_jobIsRunning = 1
		GOTO EXIT_PROCESS_UPDATE_JOBS
	END
	-- At this point we have no job running for the client, so need to start a new job, or add client to existing job
	-- if count and time criteria are satisfied.
	IF (@isUpgrade = 1) --MR95203 - WAIT SOME TIME BEFORE STARTING A NEW UPGRADE JOB FOR CLIENT
	BEGIN
		SELECT TOP 1 @o_jobId = Q.jobId FROM JMQinetixUpdateStatus Q WITH (NOLOCK)
					JOIN JMAdminJobStatsTable JS WITH (NOLOCK) ON JS.jobId = Q.jobId
					WHERE Q.clientId = @clientId AND (JS.servStart+@maxWaitForUpgradeRetry) > @nowTime
					AND JS.opType = @jmOpType
					ORDER BY JS.servStart DESC
		IF @o_jobId > 0
		BEGIN
			SET @o_jobIsRunning = 1
			GOTO EXIT_PROCESS_UPDATE_JOBS
		END
	END
	-- Case 3 : First check if a job has been submitted for this subtask that is not yet picked by JM and satisfies count criteria. There should be 1 if any.
	SELECT TOP 1 @o_jobId = jobId
	FROM
		(SELECT TMJOBS.jobId, TMJOBREQ.subTaskId, COUNT(OPT.value) "clientCount"
		 FROM TM_Jobs TMJOBS
		 INNER JOIN TM_JobRequest TMJOBREQ WITH (NOLOCK) ON TMJOBS.jobRequestId  = TMJOBREQ.jobRequestId
		 INNER JOIN TM_JobOptions OPT WITH (NOLOCK) ON TMJOBS.jobId = OPT.jobId AND modified = 0 AND OPT.optionId = 130007 /*ADM_INSTALL_UPDATES_CLIENTS*/ -- Client option for count
		 WHERE ( TMJOBS.status = 0 OR ( (TMJOBS.status & 1) = 1 ) ) -- Not picked by JM.
		 AND TMJOBREQ.subTaskId = @i_subTaskId -- Same schedule
		 GROUP BY TMJOBS.jobId, TMJOBREQ.subTaskId
		)JOB
	WHERE JOB.clientCount < @maxNumOfClientsPerJob -- Count criteria
	IF @o_jobId <> 0
	BEGIN
		-- We have a suitable job to which this client can be added. Insert a row into TM_JobOptions table so that JM picks it up.
		IF @subTaskOperationType != 4026 /*INSTALL_CLIENT = 4026*/
		BEGIN
			INSERT INTO TM_JobOptions
SELECT @o_jobId, 239177580, 0,
			(
				SELECT @clientId '@clientId', @clientName '@clientName'
				FOR XML PATH('clientAndClientGroups')
			),
			@i_taskId, @i_subTaskId, 0, @nowtime, 0
		END
		ELSE
		BEGIN
			SET @clntXML = (SELECT
						@clientId AS 'clientEntity/@clientId',
						(SELECT name FROM APP_Client WITH (READUNCOMMITTED)
							WHERE id = @clientId)
								AS 'clientEntity/@clientName'
						FOR XML PATH ('clientDetails'))
			INSERT INTO TM_JobOptions
VALUES(@o_jobId, 150015, 0, CAST(@clntXML AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowtime, 0)
		END
		INSERT INTO TM_JobOptions
		VALUES(@o_jobId, 130007 /*ADM_INSTALL_UPDATES_CLIENTS*/, 0, CAST(@clientId AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)
		-- Also do a safety check, if job is in JMAdminJobInfo but no entry for our client in JMQinetixUpdateStatus
		-- then go ahead and insert it. This probably happened due to race condition and JM did not pick our inserted client job option.
		IF EXISTS		( SELECT * FROM JMAdminJobInfoTable -- only committed rows
						  WHERE jobId = @o_jobId AND commCellId = 2 /* DEFAULT_COMMCELL_ID */
						)
		AND NOT EXISTS	( SELECT * FROM JMQinetixUpdateStatus -- only committed rows
						  WHERE jobId = @o_jobId AND commCellId = 2 AND clientId = @clientId
					    )
		BEGIN
			INSERT INTO JMQinetixUpdateStatus
			VALUES(@o_jobId, 2 /*commcellId*/, @clientId, @clientName, 5001 /*QGENERIC_TO_BE_DONE*/, 7 /*QCATECORY_WAITING*/, 0, 0, '', '', '', '', 0)
		END
		-- We are done
		SET @o_jobIsRunning = 1
		GOTO EXIT_PROCESS_UPDATE_JOBS
	END
	-- Case 4 : Now check if there is already a running job that has client count < maxcount and runtime < maxruntime. There should be only 1 if any.
	SELECT TOP 1 @o_jobId = jobId
	FROM
		(SELECT JINFO.jobId, JINFO.subTaskId, COUNT(JUPDATE.clientId) "clientCount", JINFO.servStart
		 FROM JMAdminJobInfoTable JINFO -- only committed rows
		 INNER JOIN JMQinetixUpdateStatus JUPDATE  WITH (NOLOCK)ON JINFO.jobId = JUPDATE.jobId AND JUPDATE.commCellId = JINFO.commCellId
		 AND JINFO.subTaskId = @i_subTaskId -- Same schedule
		 AND JINFO.commcellId = 2 /* DEFAULT_COMMCELL_ID */
		 GROUP BY JINFO.jobId, JINFO.subTaskId, JINFO.servStart
		)JOB
	WHERE JOB.clientCount < @maxNumOfClientsPerJob -- Count criteria
	AND (@nowTime < (JOB.servStart + @maxJobRunTime)) -- Time criteria
	IF @o_jobId <> 0
	BEGIN
		-- We have a suitable job to which this client can be added. Insert a row into TM_JobOptions and JMQinetixUpdateStatus and exit
		IF @subTaskOperationType != 4026 /*INSTALL_CLIENT = 4026*/
		BEGIN
			INSERT INTO TM_JobOptions
SELECT @o_jobId, 239177580, 0,
			(
				SELECT @clientId '@clientId', @clientName '@clientName'
				FOR XML PATH('clientAndClientGroups')
			),
			@i_taskId, @i_subTaskId, 0, @nowtime, 0
		END
		ELSE
		BEGIN
			SET @clntXML = (SELECT
						@clientId AS 'clientEntity/@clientId',
						(SELECT name FROM APP_Client WITH (READUNCOMMITTED)
							WHERE id = @clientId)
								AS 'clientEntity/@clientName'
						FOR XML PATH ('clientDetails'))
			INSERT INTO TM_JobOptions
VALUES (@o_jobId, 150015, 0, CAST(@clntXML AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowtime, 0)
		END
		INSERT INTO TM_JobOptions
		VALUES(@o_jobId, 130007 /*ADM_INSTALL_UPDATES_CLIENTS*/, 0, CAST(@clientId AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)
		INSERT INTO JMQinetixUpdateStatus
		VALUES(@o_jobId, 2 /*commcellId*/, @clientId, @clientName, 5001 /*QGENERIC_TO_BE_DONE*/, 7 /*QCATECORY_WAITING*/, 0, 0, '', '', '', '', 0)
		-- Safety insert for jobs that might have been missed in previous execution of Case 3
		IF object_id('tempdb.dbo.#clientsToAdd') is NOT NULL
		BEGIN
			DROP TABLE #clientsToAdd
		END
		CREATE TABLE #clientsToAdd (t_id INT)
		CREATE CLUSTERED INDEX clientsToAdd_t_id_Idx ON #clientsToAdd(t_id)
		INSERT INTO #clientsToAdd
		SELECT CAST(OPT.value AS INT)
		FROM TM_JobOptions OPT WITH (NOLOCK)
		LEFT OUTER JOIN JMQinetixUpdateStatus JUPDATE WITH (NOLOCK)ON OPT.jobId = JUPDATE.jobId AND OPT.value = CAST(JUPDATE.clientId AS NVARCHAR(10))
		WHERE OPT.jobId = @o_jobId AND OPT.optionId = 130007 /*ADM_INSTALL_UPDATES_CLIENTS*/
		AND JUPDATE.jobId is null
		INSERT INTO JMQinetixUpdateStatus
		SELECT @o_jobId, 2 /*commcellId*/, CL.id, CL.name, 5001 /*QGENERIC_TO_BE_DONE*/, 7 /*QCATECORY_WAITING*/, 0, 0, '', '', '', '', 0
		FROM APP_Client CL WITH (NOLOCK) JOIN #clientsToAdd ON CL.id = t_id
		-- We are done
		SET @o_jobIsRunning = 1
		GOTO EXIT_PROCESS_UPDATE_JOBS
	END
	ELSE
	BEGIN
		-- Case 5: No valid jobs found. Create new job ID
		SET @o_jobIsRunning = 0
		EXEC @o_jobId = TM_GetNextJobId
	END
EXIT_PROCESS_UPDATE_JOBS:
END TRY
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
END CATCH;
IF object_id('tempdb.dbo.#clientsToAdd') is NOT NULL
BEGIN
	DROP TABLE #clientsToAdd
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_ProcessOSCRequest')
	delete from GxQscripts where name = 'TM_ProcessOSCRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_ProcessOSCRequest')
	delete from GXDBVersions where aliasname = 'TM_ProcessOSCRequest'
GO

insert into GXDBVersions values(2, 'TM_ProcessOSCRequest',  '00010010006000050000', 'TM_ProcessOSCRequest', '00010010006000050000')
GO

