

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_ModifyTask.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_ModifyTask.sp,v $ $Id: TM_ModifyTask.sp,v 1.3.12.10 2018/03/27 08:03:39 jiechen Exp $";
-- =========================================================
-- Author:		Sergio Bonilla
-- Create date: 09/28/2014
-- Description:	Add/Remove schedule policy info
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_ModifyTask <<<'

IF EXISTS (select * from sysobjects where name='TM_ModifyTask')
	drop procedure TM_ModifyTask
IF EXISTS (select * from GxQscripts where name='TM_ModifyTask')
	delete from GxQscripts where name = 'TM_ModifyTask'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_ModifyTask')
	delete from GXDBVersions where aliasname = 'TM_ModifyTask'
GO
print '... Creating Procedure: TM_ModifyTask'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_ModifyTask
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userId integer,
  @localeId_in integer,
  @xmlText XML OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
	DECLARE @now				INT = dbo.GetUnixTime(GETDATE())
DECLARE @assocType			INT = 28
	DECLARE @errorCode			INT = 0
	DECLARE @opEvMsgId			INT = 0
	DECLARE @dataIsEvent		INT = 0
	DECLARE @opMsgId			INT = 0
	DECLARE @opId				INT = 0
	DECLARE @paramMsgId			INT = 0
	DECLARE @deleted			INT = 0
	DECLARE @excluded			INT = 0
	DECLARE @patternId			INT = 0
	DECLARE @sendWorkqueue		INT = 0
	DECLARE @clientGroupId		INT = 0
	DECLARE @clientId			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @taskName			NVARCHAR(MAX) = ''
	DECLARE @subTaskName		NVARCHAR(MAX) = ''
	DECLARE @clientGroupName	NVARCHAR(MAX) = ''
	DECLARE @clientName			NVARCHAR(MAX) = ''
	DECLARE @apptypeName		NVARCHAR(MAX) = ''
	DECLARE @instanceName		NVARCHAR(MAX) = ''
	DECLARE @backupsetName		NVARCHAR(MAX) = ''
	DECLARE @subclientName		NVARCHAR(MAX) = ''
	DECLARE @agentName			NVARCHAR(MAX) = ''
	DECLARE @agentGroupName		NVARCHAR(MAX) = ''
	DECLARE @auditEnitities		NVARCHAR(MAX) = ''
	DECLARE @oldPattern			NVARCHAR(MAX) = ''
	DECLARE @newPattern			NVARCHAR(MAX) = ''
	DECLARE @auditPattern		NVARCHAR(MAX) = ''
	DECLARE @association		XML
	DECLARE @repeatPattern		XML
	DECLARE @xmlForSec			XML = @xmlText
	DECLARE @patternText		TABLE (description NVARCHAR(MAX))
	DECLARE @t_taskDetail		TABLE ( oXml XML )
DECLARE @workQOutPutTbl		TABLE (errCode INT, errString NVARCHAR(2048))
DECLARE @modEntity			TABLE (action  NVARCHAR(2048), clientGroupId INT, clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT, newExclude INT, oldExclude INT)
DECLARE @auditEntity		TABLE (clientGroupId INT, clientGroupName NVARCHAR(2048), clientId INT, clientName NVARCHAR(2048), appTypeId INT, appTypeName NVARCHAR(MAX), instanceId INT, instanceName NVARCHAR(2048), backupsetId INT, backupseName NVARCHAR(MAX), subclientId INT, subclientName NVARCHAR(MAX), deleted INT, excluded INT)
DECLARE @modAgent			TABLE (action  NVARCHAR(2048), agentGroupId INT, agentTypeId INT)
DECLARE @auditAgent			TABLE (agentGroupId INT, agentGroupName NVARCHAR(2048), agentTypeId INT, agentTypeName NVARCHAR(2048))
	DECLARE @modPattern			TABLE (patternId INT)
DECLARE @modFilter			TABLE (action  NVARCHAR(2048), filter_type INT, filter_value INT)
	IF OBJECT_ID('tempdb.dbo.#tmp__EntityNameToId') IS NOT null
		DROP TABLE #tmp__EntityNameToId
	CREATE TABLE #tmp__EntityNameToId (EntityNameToIdXml XML)
    INSERT INTO #tmp__EntityNameToId
	EXEC EntityNameToIdConverter @xmlText OUTPUT
	DECLARE @i_taskId INT = ISNULL (( SELECT ref.value('@taskId', 'INT')
					FROM @xmlText.nodes ('//taskInfo/task') R(ref)), 0)
	SELECT @i_taskId = ISNULL (( SELECT ref.value('@taskId', 'INT')
					FROM @xmlText.nodes ('//taskInfo/task/task') R(ref)), @i_taskId)
	DECLARE @i_subTaskId INT = ISNULL (( SELECT ref.value('@subTaskId', 'INT')
					FROM @xmlText.nodes ('//taskInfo/subTasks/subTask') R(ref)), 0)
	SET @association = (SELECT @xmlText.query('//taskInfo/associations'))
	SET @repeatPattern = (SELECT @xmlText.query('//taskInfo/subTasks/pattern/repeatPattern'))
	IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
		DROP TABLE #AssocEntity
	IF OBJECT_ID('tempdb.dbo.#AgentEntity') IS NOT null
		DROP TABLE #AgentEntity
	IF OBJECT_ID('tempdb.dbo.#PatternInfo') IS NOT null
		DROP TABLE #PatternInfo
	IF OBJECT_ID('tempdb.dbo.#RepeatInfo') IS NOT null
		DROP TABLE #RepeatInfo
SELECT @taskName = taskName FROM TM_Task (NOLOCK) WHERE taskId = @i_taskId AND taskType = 4
	-- If subtaskId=0 then take it from TM_subtask table for schedules.
	if @i_subTaskId=0
	begin
		SELECT @i_subTaskId = TM_SubTask.subTaskId FROM TM_SubTask (NOLOCK)
		inner join TM_Task on TM_subtask.taskid=TM_task.taskid
WHERE TM_task.taskid = @i_taskId AND TM_task.taskType = 2
	end
	IF @taskName = '' AND @i_subTaskId = 0 AND @i_taskId=0
	BEGIN
SET @errorCode =  (1464 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId_in, @errorCode, 0, 2)
		GOTO ERROR_EXIT
	END
	SELECT @subTaskName = subTaskName, @i_taskId = taskId FROM TM_SubTask (NOLOCK) WHERE subTaskId = @i_subTaskId AND (taskId = @i_taskId OR @i_taskId = 0)
	IF @subTaskName = '' AND @taskName = ''
	BEGIN
SET @errorCode =  (1464 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId_in, @errorCode, 0, 2)
		GOTO ERROR_EXIT
	END
	--NOT NEED ANY MORE WITH CHANGES IN STORED PROCEDURE TO ACCEPT ONLY WHAT HAS BEEN CHANGED
--GET SCHEDULE INFO
	--INSERT INTO @t_taskDetail EXECUTE TM_GetTaskDetail @i_taskId, @userId, @localeId_in
--
	--CHECK SECURITY ONLY ON ASSOCIATION BEING PASSED
	--SET @xmlForSec = ISNULL((SELECT TOP 1 oXml FROM @t_taskDetail), @xmlText)
	--IF @association IS NOT NULL AND CAST(@association AS NVARCHAR(MAX)) <> ''
	--BEGIN
	--	SET @xmlForSec.modify('delete //associations')
	--	SET @xmlForSec.modify('insert (sql:variable("@association")) into (//taskInfo)[1]')
	--END
--
	-- Now check whether we need to check for security. For admin users, he always has rights. So no need to check
	DECLARE @masterGroupId integer = dbo.GetMasterGroupID()
	if not exists(select 1 from UMUserGroup with (nolock) where groupId=@masterGroupId and userId=@userId)
	begin
		-- Now massage this input in case its needed... If subtaskNode is missing in taskInfo, then add it based on taskId since security SP expects it
		if (@xmlForSec.exist('//taskInfo/subTasks'))=0
		begin
			declare @xmlSubtask xml
			set @xmlSubtask = (select TM_SubTask.subTaskId as '@subTaskId',
								TM_SubTask.operationType as '@operationType'
								from TM_SubTask where taskId=@i_taskId
								for xml path('subTask'),root('subTasks'))
			set @xmlForSec.modify('insert sql:variable("@xmlSubtask") into (//taskInfo)[1]')
		end
		INSERT INTO @t_taskDetail EXECUTE TM_SecurityCheckForTask @userId, @localeId_in, 0, @xmlForSec OUTPUT
	--
		SET @errorCode = ISNULL (( SELECT ref.value('@errorCode', 'INT')
						FROM @xmlForSec.nodes ('//TMMsg_GenericResp') R(ref)), 0)
		IF @errorCode != 0
		BEGIN
			SET @errorString =  ISNULL (( SELECT ref.value('@errorMessage', 'NVARCHAR(MAX)')
						FROM @xmlForSec.nodes ('//TMMsg_GenericResp') R(ref)), '')
			SET @xmlText = @xmlForSec
			GOTO ERROR_EXIT
		END
	END
--
	CREATE TABLE #PatternInfo
		(active_end_occurence INT, active_end_date INT, active_end_time INT, active_start_date INT, active_start_time INT, freq_interval INT, freq_recurrence_factor INT,
			freq_relative_interval INT, freq_subday_interval INT, freq_restart_interval INT, freq_type INT, calendarId INT, TimeZoneID INT)
	CREATE TABLE #AssocEntity
		(assocType INT, commCellId INT, clientGroupId INT, clntId INT, appId INT, instanceId INT, backupsetId INT, subClientId INT, mediaAgentId INT,
			libraryId INT, archGroupId INT, archGroupCopyId INT, exclude INT, include INT, deleted INT)
	CREATE TABLE #AgentEntity
		(filter_type INT, filter_value INT, include INT, deleted INT)
	CREATE TABLE #RepeatInfo
		(exception INT, occurrence INT , onDay INT, onDayNumber INT, repeatOn INT)
	IF @xmlText.exist('//taskInfo/associations') = 1
	BEGIN
		--GET ENTITY INFORMATION
		INSERT INTO #AssocEntity
		SELECT
			CASE WHEN ASS.assocType is null THEN 0 ELSE ASS.assocType END [assocType],
			CASE WHEN ASS.commCellId is null THEN 2 ELSE ASS.commCellId END [commCellId],
			CASE WHEN ASS.clientGroupId is null THEN 0 ELSE ASS.clientGroupId END [clientGroupId],
			CASE WHEN ASS.clientId is null THEN 0 ELSE ASS.clientId END [clntId],
			CASE WHEN ASS.applicationId is null THEN 0 ELSE ASS.applicationId END [appId],
			CASE WHEN ASS.instanceId is null THEN 0 ELSE ASS.instanceId END [instanceId],
			CASE WHEN ASS.backupsetId is null THEN 0 ELSE ASS.backupsetId END [backupsetId],
			CASE WHEN ASS.subclientId is null THEN 0 ELSE ASS.subclientId END [subClientId],
			CASE WHEN ASS.mediaAgentId is null THEN 0 ELSE ASS.mediaAgentId END [mediaAgentId],
			CASE WHEN ASS.libraryId is null THEN 0 ELSE ASS.libraryId END [libraryId],
			CASE WHEN ASS.storagePolicyId is null THEN 0 ELSE ASS.storagePolicyId END [archGroupId],
			CASE WHEN ASS.copyId is null THEN 0 ELSE ASS.copyId END [archGroupCopyId],
			CASE WHEN ASS.exclude is null THEN 0 ELSE ASS.exclude END [exclude],
			CASE WHEN ASS.include is null THEN 0 ELSE ASS.include END [include],
			CASE WHEN ASS.deleted is null THEN 0 ELSE ASS.deleted END [deleted]
		--INTO #AssocEntity
		FROM
		(
			SELECT BA.assocType, BA.clientGroupId AS clientGroupId, BA.applicationId, BA.backupsetId, BA.clientId,
				BA.commCellId, BA.instanceId, BA.libraryId, BA.mediaAgentId, BA.storagePolicyId, BA.subclientId,
				BA.copyId, BA.exclude, BA.include, BA.deleted
			FROM
			(
				SELECT ref.value('@_type_','INT') assocType, ref.value('@commCellId','INT') commCellId, ref.value('@clientGroupId','INT') clientGroupId, ref.value('@clientId', 'INT') clientId,
					ref.value('@applicationId','INT') applicationId, ref.value('@instanceId', 'INT') instanceId, ref.value('@backupsetId','INT') backupsetId, ref.value('@subclientId', 'INT') subclientId,
					ref.value('@mediaAgentId','INT') mediaAgentId, ref.value('@libraryId', 'INT') libraryId, ref.value('@storagePolicyId', 'INT') storagePolicyId, ref.value('@copyId', 'INT') copyId,
					ref.value('flags[1]/@exclude', 'INT') exclude, ref.value('flags[1]/@deleted', 'INT') deleted, ref.value('flags[1]/@include', 'INT') include
				FROM
				@xmlText.nodes('//taskInfo/associations') AS T(ref)
				--CROSS APPLY @xmlText.nodes('//subTasks/subTask') AS O(op)
			) BA
		) ASS
	--
		IF EXISTS(
			SELECT subClientId FROM #AssocEntity AE
			JOIN APP_Application APP (NOLOCK) ON APP.id = AE.subClientId AND APP.subclientStatus&16=16
			WHERE deleted = 0 AND subClientId > 0
		)
		BEGIN
SET @errorCode =  (83 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId_in, @errorCode, 0, 2)
			GOTO ERROR_EXIT
		END
	--
		IF EXISTS (
					SELECT * FROM #AssocEntity
					WHERE
						(
							clntId = 0 AND (appId > 0 OR instanceId > 0 OR backupsetId > 0 OR subClientId > 0)
						)
						OR
						(
							appId = 0 AND (instanceId > 0 OR backupsetId > 0 OR subClientId > 0)
						)
						OR
						(
							instanceId = 0 AND (backupsetId > 0 OR subClientId > 0)
						)
						OR
						(
							backupsetId = 0 AND subClientId > 0
						)
				)
		BEGIN
			--ADD MISSING ENTITIES
			UPDATE #AssocEntity
			SET clntId = (SELECT DISTINCT clientId FROM APP_Application APP WITH (NOLOCK)
								WHERE
								(
									(APP.id = subClientId OR subClientId = 0)
									AND
									(APP.backupSet = backupsetId OR backupsetId = 0)
									AND
									(APP.instance = instanceId OR instanceId = 0)
									AND
									(APP.appTypeId = appId OR appId = 0)
								)
							)
							WHERE clntId = 0 AND (subClientId > 0 OR backupsetId > 0 OR instanceId > 0 OR appId > 0)
			UPDATE #AssocEntity
			SET appId = (SELECT DISTINCT appTypeId FROM APP_Application APP WITH (NOLOCK)
								WHERE
								(
									(APP.id = subClientId OR subClientId = 0)
									AND
									(APP.backupSet = backupsetId OR backupsetId = 0)
									AND
									(APP.instance = instanceId OR instanceId = 0)
								)
							)
							WHERE appId = 0 AND (subClientId > 0 OR backupsetId > 0 OR instanceId > 0)
			UPDATE #AssocEntity
			SET instanceId = (SELECT DISTINCT instance FROM APP_Application APP WITH (NOLOCK)
								WHERE
								(
									(APP.id = subClientId OR subClientId = 0)
									AND
									(APP.backupSet = backupsetId OR backupsetId = 0)
								)
							)
							WHERE instanceId = 0 AND (subClientId > 0 OR backupsetId > 0)
			UPDATE #AssocEntity
			SET backupsetId = (SELECT DISTINCT backupSet FROM APP_Application APP WITH (NOLOCK)
								WHERE
								(
									(APP.id = subClientId OR subClientId = 0)
								)
							)
							WHERE backupsetId = 0 AND (subClientId > 0)
		END
	--
		IF EXISTS(
			SELECT *
			FROM #AssocEntity E
			WHERE E.clientGroupId IS NULL
			OR E.clntId IS NULL
			OR E.appId IS NULL
			OR E.instanceId IS NULL
			OR E.backupsetId IS NULL
			OR E.subClientId IS NULL
			OR E.mediaAgentId IS NULL
			OR E.archGroupId IS NULL
			OR E.archGroupCopyId IS NULL
			OR ( E.clientGroupId > 0 AND NOT EXISTS (SELECT * FROM APP_ClientGroup WHERE id = E.clientGroupId
					)
				)
			)
		OR		--CHECK FOR INVALID ENTRY
		NOT EXISTS(
			SELECT * FROM #AssocEntity AE
			JOIN APP_Application (NOLOCK) AP ON (AP.clientId = AE.clntId OR AE.clntId = 0)
			AND (AP.appTypeId = AE.appId OR (AE.appId = 0 AND AE.instanceId = 0 AND AE.backupsetId = 0  AND AE.subclientId = 0))
			AND (AP.instance = AE.instanceId OR (AE.instanceId = 0 AND AE.backupsetId = 0  AND AE.subclientId = 0))
			AND (AP.backupSet = AE.backupsetId OR (AE.backupsetId = 0 AND AE.subclientId = 0))
			AND (AP.id = AE.subClientId OR (AE.subclientId = 0))
		)
		BEGIN
SET @errorCode =  (83 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId_in, @errorCode, 0, 2)
			GOTO ERROR_EXIT
		END
	END
--
	IF @xmlText.exist('//taskInfo/appGroup') = 1
	BEGIN
		--GET AGENT INFORMATION
		INSERT INTO #AgentEntity
		SELECT
			ASS.filter_type,
			ASS.filter_value,
			CASE WHEN ASS.include is null THEN 0 ELSE ASS.include END [include],
			CASE WHEN ASS.deleted is null THEN 0 ELSE ASS.deleted END [deleted]
		--INTO #AgentEntity
		FROM
		(
			SELECT 1 filter_type, ref.value('@appGroupId','INT') filter_value,
				ref.value('flags[1]/@deleted', 'INT') deleted, ref.value('flags[1]/@include', 'INT') include
			FROM
			@xmlText.nodes('//taskInfo/appGroup/appGroups') AS T(ref)
			UNION ALL
			SELECT 2 filter_type, ref.value('@appTypeId','INT') filter_value,
				ref.value('flags[1]/@deleted', 'INT') deleted, ref.value('flags[1]/@include', 'INT') include
			FROM
			@xmlText.nodes('//taskInfo/appGroup/appTypes') AS T(ref)
		)
		ASS
	END
--
	IF EXISTS(SELECT * FROM #AgentEntity)
		AND
		NOT EXISTS(SELECT * FROM #AgentEntity
				WHERE EXISTS(SELECT * FROM dbo.GetAppTypesForAppGroup(filter_value, 0) WHERE filter_type = 1)
				OR EXISTS(SELECT * FROM dbo.APP_iDAType (NOLOCK) WHERE type IN (filter_value) AND filter_type = 2)
				)
	BEGIN
SET @errorCode =  (25 | (CAST(POWER(2, 24) AS BIGINT) * 20))		--	Unknown agent selection.
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId_in, @errorCode, 0, 2)
		GOTO ERROR_EXIT
	END
--
	IF @xmlText.exist('//taskInfo/subTasks/pattern') = 1
	BEGIN
		--GET PATTERN INFORMATION
		INSERT INTO #PatternInfo
		SELECT
			ISNULL(PAT.active_end_occurence, 0)active_end_occurence,
			ISNULL(PAT.active_end_date, 0)active_end_date,
			ISNULL(PAT.active_end_time, 0)active_end_time,
			ISNULL(PAT.active_start_date, 0) active_start_date,
			ISNULL(PAT.active_start_time, 0) active_start_time,
			ISNULL(PAT.freq_interval, 0) freq_interval,
			ISNULL(PAT.freq_recurrence_factor, 1) freq_recurrence_factor,
			ISNULL(PAT.freq_relative_interval, 0) active_start_date,
			ISNULL(PAT.freq_subday_interval, 0) freq_subday_interval,
			ISNULL(PAT.freq_restart_interval, 0) freq_restart_interval,
			ISNULL(PAT.freq_type, 0) freq_type,
			PAT.calendarId,
			PAT.TimeZoneID
		--INTO #PatternInfo
		FROM
		(
			SELECT ref.value('pattern[1]/@active_end_occurence', 'INT')active_end_occurence,  ref.value('pattern[1]/@active_end_date', 'INT')active_end_date, ref.value('pattern[1]/@active_end_time', 'INT')active_end_time, ref.value('pattern[1]/@active_start_date', 'INT')active_start_date, ref.value('pattern[1]/@active_start_time', 'INT')active_start_time,
				ref.value('pattern[1]/@freq_interval', 'INT')freq_interval, ref.value('pattern[1]/@freq_recurrence_factor', 'INT')freq_recurrence_factor, ref.value('pattern[1]/@freq_relative_interval', 'INT')freq_relative_interval, ref.value('pattern[1]/@freq_subday_interval', 'INT')freq_subday_interval, ref.value('pattern[1]/@freq_restart_interval', 'INT')freq_restart_interval,
				ref.value('pattern[1]/@freq_type', 'INT')freq_type, ref.value('pattern[1]/calendar[1]/@calendarId', 'INT')calendarId, ref.value('pattern[1]/timeZone[1]/@TimeZoneID', 'INT')TimeZoneID
			FROM
			@xmlText.nodes('//taskInfo/subTasks') AS T(ref)
		)
		PAT
	END
	IF @xmlText.exist('//repeatPattern') = 1
	BEGIN
		INSERT INTO #RepeatInfo
		--GET REPEAT PATTERN INFORMATION
		SELECT
			REP.exception,
			REP.occurrence,
			REP.onDay,
			REP.onDayNumber,
			REP.repeatOn
		--INTO #RepeatInfo
		FROM
		(
			SELECT ref.value('@exception', 'INT')exception, ref.value('@occurrence', 'INT')occurrence,
				ref.value('@onDay', 'INT')onDay, ref.value('@onDayNumber', 'INT')onDayNumber, ref.value('@repeatOn', 'INT')repeatOn
			FROM
			@repeatPattern.nodes('//repeatPattern') AS P(ref)
		)
		REP
	END
	BEGIN TRAN
		IF EXISTS(SELECT * FROM #AssocEntity)
		BEGIN
			--CHANGE ENTITY INFORMATION
			MERGE TM_AssocEntity AS TA
			USING
			(
				SELECT assocType, clientGroupId, clntId, appId, instanceId, backupsetId, subClientId, mediaAgentId, archGroupId, archGroupCopyId, exclude, include, deleted
				FROM #AssocEntity
			) AS AE ON TA.taskId = @i_taskId AND AE.assocType = TA.assocType AND AE.clientGroupId = TA.clientGroupId AND AE.clntId = TA.clientId
					AND AE.appId = TA.appTypeId AND AE.instanceId = TA.instanceId AND AE.backupsetId = TA.backupsetId AND AE.subClientId = TA.subClientId
					AND AE.mediaAgentId = TA.mediaAgentId AND AE.archGroupId = TA.policyId AND AE.archGroupCopyId = TA.copyId
			WHEN MATCHED AND AE.deleted = 0 THEN
				UPDATE SET
				TA.exclude = (CASE WHEN AE.include = 1 OR AE.exclude = 0 THEN 0 ELSE 1 END)
			WHEN MATCHED AND AE.deleted = 1 THEN
				DELETE
			WHEN NOT MATCHED AND (AE.include = 1 OR AE.deleted = 0)
				AND NOT EXISTS	--CHECK THAT ASSOCIATION DOES NOT ALREADY EXISTS OR IT IS NOT AT A HIGHER LEVEL
					(
						SELECT * FROM TM_AssocEntity
						WHERE taskId = @i_taskId
						AND
						(
							AE.exclude = 0
							AND
							(
								(
(assocType = 1 OR assocType = 2)  --CHECK ASSOCIATION FOR ALL CLIENTS
								)
								OR
								(
									clientId = AE.clntId AND clientGroupId = AE.clientGroupId
									AND (apptypeId = 0 OR apptypeId = AE.appId)
									AND (instanceId = 0 OR instanceId = AE.instanceId)
									AND (backupsetId = 0 OR backupsetId = AE.backupsetId)
									AND (subclientId = 0 OR subclientId = -1 OR subclientId = AE.subclientId)
									AND exclude = AE.exclude
								)
								OR
								(
									clientGroupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc (NOLOCK) WHERE clientId = AE.clntId)
									AND exclude = AE.exclude
								)
							)
						)
					)
				OR		--MAKE SURE THERE IS AN ASSOCIATION AT HIGHER LEVEL BEFORE EXCLUDING AN ENTITY
				(
					AE.exclude = 1
					AND
					EXISTS
						(
							SELECT * FROM TM_AssocEntity
							WHERE taskId = @i_taskId AND exclude = 0
							AND
							(
((assocType = 1 OR assocType = 2) AND AE.clientGroupId = 0) --CHECK ALL CLIENTS SELECTED. EXCLUSION SHOULD NOT BE AT CLIENT GROUP
								OR
								(
									(clientGroupId = AE.clientGroupId OR AE.clientGroupId = 0)
									AND
									(clientId = AE.clntId OR (clientId = 0 AND clientGroupId = AE.clientGroupId))
									AND (AE.appId = 0 OR (apptypeId = 0 AND instanceId = 0 AND backupsetId = 0  AND subclientId = 0))
									AND (AE.instanceId = 0 OR (apptypeId = AE.appId AND instanceId = 0 AND backupsetId = 0  AND subclientId = 0))
									AND (AE.backupsetId = 0 OR (instanceId = AE.instanceId AND backupsetId = 0 AND subclientId = 0))
									AND (AE.subclientId = 0 OR (backupsetId = AE.backupsetId AND subclientId = 0))
								)
							)
						)
					AND
					NOT EXISTS	--ENTITY HAS NOT BEEN ALREADY EXCLUDED
						(
							SELECT * FROM TM_AssocEntity
							WHERE taskId = @i_taskId AND exclude = 0
							AND
							(clientId = AE.clntId AND apptypeId = AE.appId AND instanceId = AE.instanceId AND backupsetId = AE.backupsetId AND subclientId = AE.subclientId)
						)
				)
			THEN
				INSERT (assocType, taskId, flags, created, clientGroupId, clientId, apptypeId, instanceId, backupsetId, subclientId, policyId, copyId, srmReportSet, srmReportType, exclude, trackingPolicyId, MediaAgentId, agentlessPolicyId, workflowId, sidbStoreId, libraryId, logMonitoringPolicyId)
				VALUES(AE.assocType, @i_taskId, 0, @now, AE.clientGroupId, AE.clntId, AE.appId, AE.instanceId, AE.backupsetId, AE.subclientId, AE.archGroupId, AE.archGroupCopyId, 0, 0, AE.exclude, 0, AE.MediaAgentId, 0, 0, 0, 0, 0)
			OUTPUT $action, AE.clientGroupId, AE.clntId, AE.appId, AE.instanceId, AE.backupsetId, AE.subclientId, inserted.exclude, deleted.exclude
			INTO @modEntity;
--
			--SPECIAL CASE WHEN PARENT ASSOCIATION IS SELECTED FOR DELETION BUT ASSOCIATION IS AT CHILD
			IF NOT EXISTS (SELECT * FROM @modEntity) AND EXISTS (SELECT * FROM #AssocEntity WHERE deleted = 1 AND clntId > 0)
			BEGIN
				DELETE TM_AssocEntity
				OUTPUT 'DELETE', deleted.clientGroupId, deleted.clientId, deleted.apptypeId, deleted.instanceId, deleted.backupsetId, deleted.subclientId, 0, deleted.exclude
				INTO @modEntity
				FROM
				(
					SELECT E.assocId
					FROM TM_AssocEntity E
					JOIN #AssocEntity AE ON E.taskId = @i_taskId
					AND
					(
						E.clientId = AE.clntId
						AND (AE.appId = E.apptypeId OR (AE.appId = 0 AND AE.instanceId = 0 AND AE.backupsetId = 0  AND AE.subclientId = 0))
						AND (AE.instanceId = E.instanceId OR (AE.instanceId = 0 AND AE.backupsetId = 0  AND AE.subclientId = 0))
						AND (AE.backupsetId = E.backupsetId OR (AE.backupsetId = 0 AND AE.subclientId = 0))
						AND (AE.subclientId = E.subclientId OR (AE.subclientId = 0))
					)
				) A
				WHERE A.assocId = TM_AssocEntity.assocId
			END
--
			IF EXISTS(SELECT * FROM #AssocEntity AE
						LEFT OUTER JOIN @modEntity ME ON ME.clientId = AE.clntId
						WHERE ISNULL(ME.action, '') = ''
					)
			BEGIN
				SELECT TOP 1 @deleted = deleted, @excluded = exclude FROM #AssocEntity AE
						LEFT OUTER JOIN @modEntity ME ON ME.clientId = AE.clntId
						WHERE ISNULL(ME.action, '') = ''
				IF @deleted = 1
SET @errorCode =  (75 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				ELSE
SET @errorCode =  (71 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId_in, @errorCode, 0, 2)
				GOTO ERROR
			END
		END
--
		IF EXISTS(SELECT * FROM #AgentEntity)
		BEGIN
			--CHANGE AGENT INFORMATION
			MERGE TM_AssocFilter AS AF
			USING
			(
				SELECT filter_type, filter_value, include, deleted
				FROM #AgentEntity
			) AS AA ON AF.taskId = @i_taskId AND AF.filter_type = AA.filter_type AND AF.filter_value = AA.filter_value
			WHEN MATCHED AND AA.deleted = 1 THEN
				DELETE
			WHEN NOT MATCHED AND (AA.include = 1 OR AA.deleted = 0) THEN
				INSERT (taskId, filter_type, filter_value, flags)
					VALUES(@i_taskId, AA.filter_type, AA.filter_value, 0)
				OUTPUT $action, AA.filter_type, AA.filter_value
				INTO @modFilter;
	--
			IF EXISTS(SELECT * FROM #AgentEntity AE
						JOIN @modFilter MF ON MF.filter_value = AE.filter_value AND MF.filter_type = AE.filter_type
						WHERE ISNULL(MF.action, '') = ''
					)
			BEGIN
				SELECT TOP 1 @deleted = deleted FROM #AgentEntity AE
				LEFT OUTER JOIN @modFilter MF ON MF.filter_value = AE.filter_value AND MF.filter_type = AE.filter_type
				WHERE ISNULL(MF.action, '') = ''
				IF @deleted = 1
SET @errorCode =  (75 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				ELSE
SET @errorCode =  (71 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId_in, @errorCode, 0, 2)
				GOTO ERROR
			END
		END
--
		IF @i_subTaskId > 0 AND EXISTS (SELECT * FROM #PatternInfo)
		BEGIN
			SET @patternId = ISNULL((SELECT patternId FROM TM_PatternAssoc WHERE subTaskId = @i_subTaskId), 0)
			DELETE @patternText
			INSERT INTO @patternText
			EXECUTE GetSchedulePattern @patternId, @localeId_in
			SELECT TOP 1 @oldPattern = description FROM @patternText
			--CHANGE PATTERN INFORMATION
			MERGE TM_Pattern AS P
			USING
			(
				SELECT active_end_occurence, active_end_date, active_end_time, active_start_date, active_start_time, freq_interval, freq_recurrence_factor, freq_relative_interval,
					freq_subday_interval, freq_restart_interval, freq_type, calendarId, TimeZoneID, @patternId AS patternId
				FROM #PatternInfo
			) AS PX ON PX.patternId = P.patternId
			WHEN MATCHED AND P.patternId > 0 THEN
				UPDATE SET
				active_end_occurence = PX.active_end_occurence,
				active_end_date =
					CASE WHEN PX.active_end_date IS NULL THEN P.active_end_date
					ELSE
						dbo.GetDateTime(PX.active_end_date) END,
				active_end_time =
					CASE WHEN PX.active_end_time IS NULL THEN P.active_end_time
					ELSE
						PX.active_end_time END,
				active_start_date =
					CASE WHEN PX.active_start_date IS NULL THEN P.active_start_date
					ELSE
						dbo.GetDateTime(PX.active_start_date) END,
				active_start_time =
					CASE WHEN PX.active_start_time IS NULL THEN P.active_start_time
					ELSE
						PX.active_start_time END,
				freq_interval =
					CASE WHEN PX.freq_interval IS NULL THEN P.freq_interval
					ELSE
						PX.freq_interval END,
				freq_recurrence_factor =  PX.freq_recurrence_factor,
				freq_relative_interval =
					CASE WHEN PX.freq_relative_interval IS NULL THEN P.freq_relative_interval
					ELSE
						PX.freq_relative_interval END,
				freq_subday_interval =  PX.freq_subday_interval,
				freq_type =
					CASE WHEN PX.freq_type IS NULL THEN P.freq_type
					ELSE
						PX.freq_type END,
				tzId =
					CASE WHEN PX.TimeZoneID IS NULL THEN P.tzId
					ELSE
						PX.TimeZoneID END,
				calendarId =
					CASE WHEN PX.calendarId IS NULL THEN P.calendarId
					ELSE
						PX.calendarId END,
				local_start_date = PX.active_start_date,
				local_end_date = ISNULL(PX.active_end_date, 0),
				modified = @now
			WHEN NOT MATCHED THEN
				INSERT (name, ownerId, status, flags, active_end_occurence, active_end_date, active_end_time, active_start_date, active_start_time, freq_interval, freq_recurrence_factor, freq_relative_interval,
					freq_subday_interval, freq_type, created, modified, tzId, calendarId, description, local_start_date, local_end_date, disabled, deleted, scheduling, freq_restart_interval)
				VALUES('', @userId, 0, 0, PX.active_end_occurence, dbo.GetDateTime(PX.active_end_date), PX.active_end_time, dbo.GetDateTime(PX.active_start_date), PX.active_start_time, PX.freq_interval, PX.freq_recurrence_factor, PX.freq_relative_interval,
					PX.freq_subday_interval, PX.freq_type, @now, 0, PX.TimeZoneID, PX.calendarId, '', PX.active_start_date, PX.active_end_date, 0, 0, 0, ISNULL(PX.freq_restart_interval, 0))
			OUTPUT inserted.patternId
			INTO @modPattern;
--
			SET @patternId = ISNULL((SELECT patternId FROM @modPattern), @patternId)
			MERGE TM_PatternAssoc AS PA
			USING
			(
				SELECT @i_subTaskId AS stId, @patternId AS patId
			) AS T ON PA.subTaskId = T.stId
			WHEN MATCHED THEN
				UPDATE SET patternId = T.patId
			WHEN NOT MATCHED THEN
				INSERT (patternId, subTaskId, flags, disabled, deleted, scheduling)
				VALUES (T.patId, T.stId, 0, 0, 0, 0);
			MERGE TM_RepeatPattern AS RP
			USING
			(
				SELECT DISTINCT @patternId patternId, RI.exception, RI.occurrence, RI.onDay, RI.onDayNumber, RI.repeatOn, PX.TimeZoneID tzId
				FROM #RepeatInfo RI, #PatternInfo PX
			) AS R ON R.patternId = RP.patternId AND R.exception = RP.exception AND R.occurrence = RP.onOccurence AND R.onDay = RP.onDay AND R.onDayNumber = RP.onDayNumber AND R.repeatOn = RP.repeatOn AND R.tzId = RP.tzId
			WHEN NOT MATCHED THEN
				INSERT (patternId, onOccurence, onDay, onDayNumber, created, modified, tzId, exception, repeatOn)
				VALUES (R.patternId, R.occurrence, R.onDay, R.onDayNumber, @now, 0, R.tzId, R.exception, ISNULL(R.repeatOn, 0));
			--RE-CALCULATE THE NEXT RUN TIME
			DELETE TM_RunTime WHERE patternId = @patternId
			DELETE @patternText
			INSERT INTO @patternText
			EXECUTE GetSchedulePattern @patternId, @localeId_in
			SELECT TOP 1 @newPattern = description FROM @patternText
			UPDATE TM_Pattern SET description = @newPattern WHERE patternId = @patternId
		END
		--REMOVE FROM AUDIT ANY ROW WHICH HAS NOT CHANGED
		DELETE @modEntity
		WHERE newExclude = oldExclude AND action='UPDATE'
		--DO AUDIT
		IF EXISTS (SELECT * FROM @modEntity)
		BEGIN
			INSERT @auditEntity
			SELECT ME.clientGroupId, CG.name, ME.clientId, C.name, ME.appTypeId,  IDA.displayName, ME.instanceId, INS.name, ME.backupsetId, BS.name, ME.subclientId, AP.subclientName,
			CASE WHEN ME.action = 'DELETED' THEN 1
				ELSE 0
			END,
			CASE WHEN (ME.action = 'INSERT' OR ME.action = 'UPDATE') AND ME.newExclude = 1 THEN 1
				ELSE 0
			END
			FROM @modEntity ME
			LEFT OUTER JOIN APP_ClientGroup CG (NOLOCK) ON CG.id = ME.clientGroupId
			LEFT OUTER JOIN APP_Client C (NOLOCK) ON C.id = ME.clientId
			LEFT OUTER JOIN APP_iDAType IDA (NOLOCK) ON IDA.type = ME.appTypeId
			LEFT OUTER JOIN APP_InstanceName INS (NOLOCK) ON INS.id = ME.instanceId
			LEFT OUTER JOIN APP_BackupSetName BS (NOLOCK) ON BS.id = ME.backupsetId
			LEFT OUTER JOIN APP_Application AP (NOLOCK) ON AP.id = ME.subclientId
			IF EXISTS(SELECT 1 FROM TM_SubTask S (NOLOCK)
				JOIN TM_Task T (NOLOCK) ON T.taskId = S.taskId AND T.disabled = 0 AND T.taskId = @i_taskId
				JOIN TM_PatternAssoc A (NOLOCK) ON A.subTaskId = S.subTaskId
JOIN  TM_Pattern P (NOLOCK) ON P.patternId = A.patternId AND P.freq_type = 1024
			)
			BEGIN
				SET @sendWorkqueue = 1
			END
		END
		IF EXISTS (SELECT * FROM @modAgent)
		BEGIN
			INSERT @auditAgent
			SELECT MA.agentGroupId, AG.groupName, MA.agentTypeId, IDA.displayName
			FROM @modAgent MA
			LEFT OUTER JOIN APP_AppTypeGroup AG (NOLOCK) ON AG.appTypeGroupId = MA.agentGroupId
			LEFT OUTER JOIN APP_iDAType IDA (NOLOCK) ON IDA.type = MA.agentTypeId
		END
		IF EXISTS (SELECT * FROM @auditEntity) OR EXISTS (SELECT * FROM @auditAgent)
		BEGIN
			-- SET GUI AUDIT OPERATION
SET @opMsgId = (82 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @taskName, @dataIsEvent
SET @paramMsgId = (1444 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
	--
			DECLARE EntityCursor CURSOR
			FOR SELECT clientGroupId, clientGroupName, clientId, clientName, appTypeName, instanceName, backupseName, subclientName, deleted, excluded
			FROM @auditEntity
	--
			OPEN EntityCursor
			FETCH EntityCursor INTO @clientGroupId, @clientGroupName, @clientId, @clientName, @apptypeName, @instanceName, @backupsetName, @subclientName, @deleted, @excluded
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @auditEnitities = ''
				IF @clientGroupName IS NOT NULL AND @clientGroupName <> '' AND @clientName IS NULL
				BEGIN
SET @paramMsgId = (1903 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					SET @auditEnitities =  (SELECT message FROM EvLocaleMsgs (NOLOCK) WHERE messageId = @paramMsgId AND [localeId] = @localeId_in)
					SET @auditEnitities = REPLACE(@auditEnitities, '^1%s', @clientGroupName)
				END
				ELSE IF @clientName IS NOT NULL AND @clientName <> ''
				BEGIN
					IF @clientGroupName IS NOT NULL AND @clientGroupName <> ''
					BEGIN
SET @paramMsgId = (1921 | (CAST(POWER(2, 24) AS BIGINT) * 35))
						SET @auditEnitities = (SELECT message FROM EvLocaleMsgs (NOLOCK) WHERE messageId = @paramMsgId AND [localeId] = @localeId_in)
						SET @auditEnitities = REPLACE(@auditEnitities, '^1%s', @clientGroupName)
						SET @auditEnitities = REPLACE(@auditEnitities, '^2%s', @clientName)
					END
					IF @subclientName IS NOT NULL AND @subclientName <> ''
					BEGIN
SET @paramMsgId = (1875 | (CAST(POWER(2, 24) AS BIGINT) * 35))
						SET @auditEnitities = @auditEnitities + (SELECT message FROM EvLocaleMsgs (NOLOCK) WHERE messageId = @paramMsgId AND [localeId] = @localeId_in)
						SET @auditEnitities = REPLACE(@auditEnitities, '^1%s', @clientName)
						SET @auditEnitities = REPLACE(@auditEnitities, '^2%s', @apptypeName)
						SET @auditEnitities = REPLACE(@auditEnitities, '^3%s', @instanceName)
						SET @auditEnitities = REPLACE(@auditEnitities, '^4%s', @backupsetName)
						SET @auditEnitities = REPLACE(@auditEnitities, '^5%s', @subclientName)
					END
					ELSE IF @backupsetName IS NOT NULL AND @backupsetName <> ''
					BEGIN
SET @paramMsgId = (1874 | (CAST(POWER(2, 24) AS BIGINT) * 35))
						SET @auditEnitities = @auditEnitities + (SELECT message FROM EvLocaleMsgs (NOLOCK) WHERE messageId = @paramMsgId AND [localeId] = @localeId_in)
						SET @auditEnitities = REPLACE(@auditEnitities, '^1%s', @clientName)
						SET @auditEnitities = REPLACE(@auditEnitities, '^2%s', @apptypeName)
						SET @auditEnitities = REPLACE(@auditEnitities, '^3%s', @instanceName)
						SET @auditEnitities = REPLACE(@auditEnitities, '^4%s', @backupsetName)
					END
					ELSE IF @instanceName IS NOT NULL AND @instanceName <> ''
					BEGIN
SET @paramMsgId = (1873 | (CAST(POWER(2, 24) AS BIGINT) * 35))
						SET @auditEnitities = @auditEnitities + (SELECT message FROM EvLocaleMsgs (NOLOCK) WHERE messageId = @paramMsgId AND [localeId] = @localeId_in)
						SET @auditEnitities = REPLACE(@auditEnitities, '^1%s', @clientName)
						SET @auditEnitities = REPLACE(@auditEnitities, '^2%s', @apptypeName)
						SET @auditEnitities = REPLACE(@auditEnitities, '^3%s', @instanceName)
					END
					ELSE IF @apptypeName IS NOT NULL AND @apptypeName <> ''
					BEGIN
SET @paramMsgId = (1872 | (CAST(POWER(2, 24) AS BIGINT) * 35))
						SET @auditEnitities = @auditEnitities + (SELECT message FROM EvLocaleMsgs (NOLOCK) WHERE messageId = @paramMsgId AND [localeId] = @localeId_in)
						SET @auditEnitities = REPLACE(@auditEnitities, '^1%s', @clientName)
						SET @auditEnitities = REPLACE(@auditEnitities, '^2%s', @apptypeName)
					END
					ELSE
					BEGIN
SET @paramMsgId = (1871 | (CAST(POWER(2, 24) AS BIGINT) * 35))
						SET @auditEnitities = @auditEnitities + (SELECT message FROM EvLocaleMsgs (NOLOCK) WHERE messageId = @paramMsgId AND [localeId] = @localeId_in)
						SET @auditEnitities = REPLACE(@auditEnitities, '^1%s', @clientName)
					END
					IF @deleted = 1
SET @paramMsgId = (2521 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					ELSE IF @excluded = 1
SET @paramMsgId = (2522 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					ELSE
SET @paramMsgId = (835 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					-- SET GUI AUDIT PARAMETER
					EXEC EvGuiAuditSetParamData @opId, @auditEnitities, @dataIsEvent
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
					IF @sendWorkqueue = 1
					BEGIN
						--CLEAR THE CLIENT GROUP FOR WHEN SELECTION OF CLIENT IS AT THE CLIENT GROUP LEVEL
						IF @clientId > 0
							SET @clientGroupId = 0
						INSERT INTO @workQOutPutTbl
						EXEC AppWorkQueueSubmitRequest 4/*WORK_TOKEN_OSC,*/, 0, 0, @clientId, @clientGroupId, ''
					END
				END
				FETCH EntityCursor INTO @clientGroupId, @clientGroupName, @clientId, @clientName, @apptypeName, @instanceName, @backupsetName, @subclientName, @deleted, @excluded
			END
			IF @newPattern <> @oldPattern AND @newPattern <> ''
			BEGIN
SET @paramMsgId = (36 | (CAST(POWER(2, 24) AS BIGINT) * 61))
				SET @auditPattern = dbo.fn_EvFormatEventMsgText(0, @localeId_in, @paramMsgId, 0, 2) + ' [' + @subTaskName + ']'
SET @paramMsgId = (842 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				-- SET GUI AUDIT PARAMETER
				EXEC EvGuiAuditSetParamData @opId, @auditPattern, @dataIsEvent
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
SET @paramMsgId = (626 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				SET @auditPattern =  (SELECT message FROM EvLocaleMsgs (NOLOCK) WHERE messageId = @paramMsgId AND [localeId] = @localeId_in)
				SET @auditPattern = REPLACE(@auditPattern, '^1%s', '')
				SET @auditPattern = REPLACE(@auditPattern, '^2%s', @oldPattern)
				SET @auditPattern = REPLACE(@auditPattern, '^3%s', @newPattern)
SET @paramMsgId = (935 | (CAST(POWER(2, 24) AS BIGINT) * 74))
				-- SET GUI AUDIT PARAMETER
				EXEC EvGuiAuditSetParamData @opId, @auditPattern, @dataIsEvent
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
			END
		END
ERROR:
	IF @errorCode <> 0
		ROLLBACK TRAN
	ELSE
		COMMIT TRAN
ERROR_EXIT:
	--IF @errorCode != 0
	BEGIN
		SET @xmlText = (
			SELECT  1           as TAG,
					NULL        as Parent,
				@errorCode      as [TMMsg_GenericResp!1!errorCode],
				@errorString    as [TMMsg_GenericResp!1!errorMessage]
			FOR XML EXPLICIT
		)
	END
	SELECT @xmlText
	IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
		DROP TABLE #AssocEntity
	IF OBJECT_ID('tempdb.dbo.#AgentEntity') IS NOT null
		DROP TABLE #AgentEntity
	IF OBJECT_ID('tempdb.dbo.#PatternInfo') IS NOT null
		DROP TABLE #PatternInfo
	IF OBJECT_ID('tempdb.dbo.#RepeatInfo') IS NOT null
		DROP TABLE #RepeatInfo
	IF OBJECT_ID('tempdb.dbo.#tmp__EntityNameToId') IS NOT null
		DROP TABLE #tmp__EntityNameToId
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_ModifyTask')
	delete from GxQscripts where name = 'TM_ModifyTask'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_ModifyTask')
	delete from GXDBVersions where aliasname = 'TM_ModifyTask'
GO

insert into GXDBVersions values(2, 'TM_ModifyTask',  '00010003001200100000', 'TM_ModifyTask', '00010003001200100000')
GO

