

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_InsertRunTaskOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_InsertRunTaskOptions.sp,v $ $Id: TM_InsertRunTaskOptions.sp,v 1.3.60.2 2018/05/04 17:46:09 mnatarajan Exp $";
-- =============================================
-- Author:		Gokul Pattabiraman
-- Description:	Insert the job specific special options when doing a run task operation.
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_InsertRunTaskOptions <<<'

IF EXISTS (select * from sysobjects where name='TM_InsertRunTaskOptions')
	drop procedure TM_InsertRunTaskOptions
IF EXISTS (select * from GxQscripts where name='TM_InsertRunTaskOptions')
	delete from GxQscripts where name = 'TM_InsertRunTaskOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_InsertRunTaskOptions')
	delete from GXDBVersions where aliasname = 'TM_InsertRunTaskOptions'
GO
print '... Creating Procedure: TM_InsertRunTaskOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_InsertRunTaskOptions
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_taskId integer,
  @i_subTaskId integer,	
  @i_jobId bigint,
  @i_xml XML,
  @errorCode integer OUTPUT,
  @errorString nvarchar(MAX) OUTPUT
AS
BEGIN
BEGIN TRY
	DECLARE @nowTime INT = dbo.GetUnixTime (GetDate())
	DECLARE @optionTbl TABLE(optionId INT, optionValue NVARCHAR(MAX))
	INSERT INTO @optionTbl
	SELECT ref.value('@optionId', 'INT'), ref.value('@value', 'NVARCHAR(MAX)')
	FROM @i_xml.nodes ('TMMsg_TaskOperationReq/runTaskOptions/options') R(ref)
	DELETE FROM TM_JobOptions
	WHERE jobId = @i_jobId
	AND OptionId IN
	(
		SELECT OP.optionId
		FROM @optionTbl OP
		INNER JOIN TM_StaticTaskOption STO WITH(NOLOCK) ON OP.optionId = STO.optionId
		AND STO.IsList = 0
	)
	INSERT INTO TM_JobOptions
	SELECT @i_jobId, OP.optionId, STO.type, OP.optionValue, @i_taskId, @i_subTaskId, 0, @nowTime, 0
	FROM @optionTbl OP
	INNER JOIN TM_StaticTaskOption STO WITH(NOLOCK) ON OP.optionId = STO.optionId
END TRY
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to get error information.
    EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
END CATCH;
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_InsertRunTaskOptions')
	delete from GxQscripts where name = 'TM_InsertRunTaskOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_InsertRunTaskOptions')
	delete from GXDBVersions where aliasname = 'TM_InsertRunTaskOptions'
GO

insert into GXDBVersions values(2, 'TM_InsertRunTaskOptions',  '00010003006000020000', 'TM_InsertRunTaskOptions', '00010003006000020000')
GO

