

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_InsertJobResubmitOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_InsertJobResubmitOptions.sp,v $ $Id: TM_InsertJobResubmitOptions.sp,v 1.3.60.1 2017/02/10 20:42:00 sjohnson Exp $";
-- =============================================
-- Author:		Anand Vibhor
-- Create date: 08/19/2009
-- Description:	insert the options
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_InsertJobResubmitOptions <<<'

IF EXISTS (select * from sysobjects where name='TM_InsertJobResubmitOptions')
	drop procedure TM_InsertJobResubmitOptions
IF EXISTS (select * from GxQscripts where name='TM_InsertJobResubmitOptions')
	delete from GxQscripts where name = 'TM_InsertJobResubmitOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_InsertJobResubmitOptions')
	delete from GXDBVersions where aliasname = 'TM_InsertJobResubmitOptions'
GO
print '... Creating Procedure: TM_InsertJobResubmitOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_InsertJobResubmitOptions
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_taskId integer,
  @i_userId integer,
  @i_submitjobId bigint,	
  @errorCode integer OUTPUT,
  @errorString nvarchar(MAX) OUTPUT
AS
BEGIN
BEGIN TRY
	DECLARE @oldUserId		int
	DECLARE @subTaskId int
	SET @errorCode = 0
	SET @errorString = 0
	BEGIN
		SET @subTaskId = (SELECT subTaskId from TM_SubTask WITH (READUNCOMMITTED) where taskId = @i_taskId)
		SET @oldUserId = ISNULL((select userId from TM_JobRequest WITH (READUNCOMMITTED) where jobRequestId = ( select jobRequestId from TM_Jobs WITH (READUNCOMMITTED) where jobId = @i_submitjobId)), 0)
		if(@oldUserId = @i_userId)
		BEGIN
			select * from TM_JobOptions WITH (READUNCOMMITTED) where jobId = @i_submitjobId
			insert into TM_SubTaskOptions select @subTaskId , optionId, type, value
			FROM [CommServ].[dbo].[GetAllJobOptions] (@i_submitjobId) where optionId in ( select optionId from TM_StaticTaskOption where type = 3)
			AND optionId NOT IN ( select optionId from TM_SubTaskOptions WITH (READUNCOMMITTED) where subTaskId = @subTaskId)
		END
	END
END TRY
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to get error information.
    EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
END CATCH;
EXIT_INSERT_JOB_OPTIONS:
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_InsertJobResubmitOptions')
	delete from GxQscripts where name = 'TM_InsertJobResubmitOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_InsertJobResubmitOptions')
	delete from GXDBVersions where aliasname = 'TM_InsertJobResubmitOptions'
GO

insert into GXDBVersions values(2, 'TM_InsertJobResubmitOptions',  '00010003006000010000', 'TM_InsertJobResubmitOptions', '00010003006000010000')
GO

