

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_InsertJobOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_InsertJobOptions.sp,v $ $Id: TM_InsertJobOptions.sp,v 1.19.60.5 2020/08/28 05:13:05 mnatarajan Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 07/15/2009
-- Description:	insert the options
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='TM_InsertJobOptions')
BEGIN
	print '>>> Drop Stored Procedure: TM_InsertJobOptions <<<'
	drop procedure TM_InsertJobOptions
END
IF EXISTS (select * from GxQscripts where name='TM_InsertJobOptions')
	delete from GxQscripts where name = 'TM_InsertJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_InsertJobOptions')
	delete from GXDBVersions where aliasname = 'TM_InsertJobOptions'
GO
print '... Creating Procedure: TM_InsertJobOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_InsertJobOptions
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_jobRequestId integer,
  @i_taskId integer,
  @i_subTaskId integer,	
  @i_userId integer,
  @i_association XML,
  @o_jobId bigint,
  @errorCode integer OUTPUT,
  @errorString nvarchar(MAX) OUTPUT
AS
BEGIN
BEGIN TRY
	DECLARE @xmlText		XML
	DECLARE @nowTime		INT = dbo.GetUnixTime (GetDate())
	DECLARE @operationType	INT = 0
	SET @errorCode = 0
	SET @errorString = 0
	BEGIN
		DECLARE @firstId	BIGINT
		DECLARE @lastId		BIGINT
		DECLARE @taskType	INT
		--FIRST DELETE OPTIONS FROM SCHEDULE THAT HAS NEVER RUN
		--IF (@i_jobRequestId = 0)
		--	DELETE TM_JobOptions WHERE taskId=@i_taskId AND subTaskId=@i_subTaskId AND jobId=0
		--SELECT @taskType=taskType FROM TM_Task WHERE taskId=@i_taskId
		SELECT @operationType=ST.operationType, @taskType=T.taskType
		FROM TM_SubTask AS ST WITH(READUNCOMMITTED)
		INNER JOIN TM_Task AS T WITH(READUNCOMMITTED) ON T.taskId = ST.taskId
		WHERE ST.subTaskId=@i_subTaskId
		--SELECT TOP 1 @firstId=jobId FROM TM_JobOptions WITH(READUNCOMMITTED) WHERE taskId=@i_taskId AND subTaskId=@i_subTaskId ORDER BY jobId ASC
		--NEW JOB OPTIONS
IF (@i_jobRequestId = 0 OR @taskType = 1 OR @taskType = 6 OR @operationType = 4019 OR @operationType = 4020 OR @operationType = 4026 OR @operationType = 5025)
		BEGIN
IF (@i_jobRequestId = 0 AND @operationType <> 4011)
			BEGIN
				UPDATE TM_JobOptions SET modified=@nowTime WHERE taskId=@i_taskId AND subTaskId=@i_subTaskId AND modified=0 AND jobId=0
				UPDATE TM_JobXMLOptions SET modified=@nowTime WHERE taskId=@i_taskId AND subTaskId=@i_subTaskId AND modified=0
			END
			--INSERT THE JOB OPTIONS
IF (@operationType = 4019 OR @operationType = 4020)
			BEGIN
				--IF ASSOCIATION NOT SET INSERT ALL ENTRIES FOR OPTION
				IF (@i_association.exist('/TMMsg_OperationEntity/associations') <> 1)
				BEGIN
					INSERT INTO TM_JobOptions SELECT @o_jobId, optionId, type, value, @i_taskId, @i_subTaskId, 0, @nowTime, 0 FROM TM_SubTaskOptions WITH(READUNCOMMITTED)
WHERE subTaskId = @i_subTaskId AND optionId = (239177580)
				END
				ELSE	--INSERT ONLY ASSOCIATIONS PASSED AS INPUT
				BEGIN
					DECLARE @optionTable TABLE (clientId int, clientGroupId int, storagePolicyId int)
					DECLARE @opXmlText XML
					INSERT INTO @optionTable
					SELECT ref.value('@clientId', 'INT') AS clientId, ref.value('@clientGroupId', 'INT') AS clientGroupId,
						ref.value('@storagePolicyId', 'INT') AS storagePolicyId
						FROM @i_association.nodes ('/TMMsg_OperationEntity/associations') R(ref)
					IF EXISTS(SELECT * FROM @optionTable WHERE clientId > 0 OR clientGroupId > 0)
					BEGIN
						SET @opXmlText = ( SELECT clientId '@clientId', clientGroupId '@clientGroupId'
							FROM @optionTable
						FOR XML PATH('clientAndClientGroups'))
						INSERT INTO TM_JobOptions
SELECT @o_jobId, 239177580, 0, CAST(@opXmlText AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
					END
					IF EXISTS(SELECT * FROM @optionTable WHERE storagePolicyId > 0)
					BEGIN
						INSERT INTO TM_JobOptions
SELECT @o_jobId, 140008, 0, CAST(storagePolicyId AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
						FROM @optionTable WHERE storagePolicyId>0
					END
				END
			END
			-- Only for install update scheduled jobs, populate an additional client list option to enable OSC processing.
IF @operationType = 4020 AND @o_jobId <> 0
			BEGIN
				DECLARE @clientTable TABLE (clientId INT)
				INSERT INTO @clientTable
				EXEC APPGetClientListforInstallUpdate 0 /* inIsJMContext*/, 35 /* inOpType = Install Updates*/,  @o_jobId
				INSERT INTO TM_JobOptions
SELECT @o_jobId, 130007, 0, CAST(clientId AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				FROM @clientTable
				WHERE clientId >1
			END
			--For Push Install Changes inserting Client ID for push install job
IF @operationType = 4026 AND @o_jobId <> 0
			BEGIN
				DECLARE @clntId INT =  0
				-- This logic will change when batching is done for clients
				IF (@i_association.exist('/TMMsg_OperationEntity/associations') > 0)
				BEGIN
					SET @clntId = ISNULL((SELECT ref.value('@clientId', 'INT') FROM @i_association.nodes ('/TMMsg_OperationEntity/associations') R(ref)),0)
				END
				-- If association is passed then fill TM_ClientInfo from that. Else fill it from tm_SubtaskOptions.
				IF @clntId <> 0
				BEGIN
					DECLARE @clntXML XML
					SET @clntXML = (SELECT
									@clntId AS 'clientEntity/@clientId',
									(SELECT name FROM APP_Client WITH (READUNCOMMITTED)
										WHERE id = @clntId)
											AS 'clientEntity/@clientName'
									FOR XML PATH ('clientDetails'))
					INSERT INTO TM_JobOptions
SELECT @o_jobId, 150015, 0,CAST(@clntXML AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
					UNION ALL
SELECT @o_jobId, 130007, 0, CAST(@clntId AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				END
				ELSE
				BEGIN
					INSERT INTO TM_JobOptions SELECT @o_jobId, optionId, type, value, @i_taskId, @i_subTaskId, 0, @nowTime, 0 FROM TM_SubTaskOptions WITH(READUNCOMMITTED)
WHERE subTaskId = @i_subTaskId AND optionId = (150015)
				END
			END
			INSERT INTO TM_JobOptions SELECT @o_jobId, O.optionId, O.type, O.value, @i_taskId, @i_subTaskId, 0, @nowTime, 0
			FROM TM_SubTaskOptions AS O WITH(READUNCOMMITTED)
			INNER JOIN TM_StaticTaskOption ST WITH(READUNCOMMITTED) ON ST.optionId = O.optionId AND ST.defVal<>O.value
WHERE subTaskId = @i_subTaskId AND O.optionId NOT IN (152984797, 587329586, 1189579219, 1496752764, 38201114, 458405394, 239177580, 150015 )
			-- Insert TM_CLient_info where not already there.
IF NOT EXISTS(SELECT 1 FROM TM_JobOptions (NOLOCK) WHERE jobID = @o_jobId AND OptionID = 150015 )
			BEGIN
				INSERT INTO TM_JobOptions SELECT @o_jobId, O.optionId, O.type, O.value, @i_taskId, @i_subTaskId, 0, @nowTime, 0
				FROM TM_SubTaskOptions AS O WITH(READUNCOMMITTED)
				INNER JOIN TM_StaticTaskOption ST WITH(READUNCOMMITTED) ON ST.optionId = O.optionId AND ST.defVal<>O.value
WHERE subTaskId = @i_subTaskId AND O.optionId = 150015
			END
IF (@i_jobRequestId = 0 OR @taskType = 1 OR @taskType = 6)
			BEGIN
				--INSERT THE JOB XML OPTIONS
				SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WITH(READUNCOMMITTED) WHERE subTaskId = @i_subTaskId)
				INSERT INTO TM_JobXMLOptions SELECT @o_jobId, @xmlText, @i_taskId, @i_subTaskId, @o_jobId, @nowTime, 0
			END
		END
		--UPDATE THE JOBID INFO
		--ELSE IF	(@firstId IS NOT null)
		--BEGIN
			--ADD THIS JOBID TO OPTION LIST
			--UPDATE TM_JobOptions SET lastJobId=@o_jobId WHERE taskId=@i_taskId AND subTaskId=@i_subTaskId AND jobId <> 0 AND jobId<>@o_jobId AND lastJobId <> 0
			--UPDATE TM_JobXMLOptions SET lastJobId=@o_jobId WHERE taskId=@i_taskId AND subTaskId=@i_subTaskId AND jobId <> 0 AND jobId<>@o_jobId AND lastJobId <> 0
			--FIRST TIME A JOB RUNS FROM A SCHEDULE, THE JOBID IS NOT SET
			--UPDATE TM_JobOptions SET jobId=@o_jobId, lastJobId=@o_jobId WHERE taskId=@i_taskId AND subTaskId=@i_subTaskId AND jobId=0
			--UPDATE TM_JobOptions SET jobId=@o_jobId WHERE taskId=@i_taskId AND subTaskId=@i_subTaskId AND jobId=0
			--UPDATE TM_JobXMLOptions SET jobId=@o_jobId, lastJobId=@o_jobId WHERE taskId=@i_taskId AND subTaskId=@i_subTaskId AND jobId=0
			--UPDATE TM_JobXMLOptions SET jobId=@o_jobId WHERE taskId=@i_taskId AND subTaskId=@i_subTaskId AND jobId=0
		--END
	END
END TRY
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to get error information.
    EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
END CATCH;
EXIT_INSERT_JOB_OPTIONS:
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_InsertJobOptions')
	delete from GxQscripts where name = 'TM_InsertJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_InsertJobOptions')
	delete from GXDBVersions where aliasname = 'TM_InsertJobOptions'
GO

insert into GXDBVersions values(2, 'TM_InsertJobOptions',  '00010019006000050000', 'TM_InsertJobOptions', '00010019006000050000')
GO

