

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_InsertJobAndOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_InsertJobAndOptions.sp,v $ $Id: TM_InsertJobAndOptions.sp,v 1.81.2.48.4.4 2021/05/03 23:39:05 samrutkar Exp $";
-- =============================================
-- Author:		Anand Vibhor
-- Create date: 04/15/2008
-- Description:	insert the job and their options
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_InsertJobAndOptions')
BEGIN
	print '>>> Drop Stored Procedure: TM_InsertJobAndOptions <<<'
	drop procedure TM_InsertJobAndOptions
END
IF EXISTS (select * from GxQscripts where name='TM_InsertJobAndOptions')
	delete from GxQscripts where name = 'TM_InsertJobAndOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_InsertJobAndOptions')
	delete from GXDBVersions where aliasname = 'TM_InsertJobAndOptions'
GO
print '... Creating Procedure: TM_InsertJobAndOptions'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_InsertJobAndOptions
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_jobRequestId integer,
  @i_assocId integer,
  @i_taskId integer,
  @i_subTaskId integer,	
  @i_subTaskType integer,	
  @i_predjobId bigint,
  @i_sequenceNumber varchar(255),
  @i_appId integer,
  @i_submissionStatus integer,
  @i_userId integer,
  @i_backupLevel bigint,
  @i_assocPosition integer,
  @i_association XML,
  @i_jobOptionsXML XML,
  @o_jobId bigint OUTPUT,	
  @errorCode integer OUTPUT,
  @errorString NVARCHAR(MAX) OUTPUT
AS
BEGIN
BEGIN TRY
	DECLARE @flags INT
	DECLARE @t_JobId		TABLE( jobId bigint )	--Temp table
	DECLARE @t_optionId		TABLE( optionId bigint )	--Temp table
	DECLARE @logInput		NVARCHAR(MAX)
	DECLARE @spName			NVARCHAR(255)
	DECLARE @clientGroupId	INT = 0
	DECLARE @clientId		INT = 0
	DECLARE @appTypeId		INT = 0
	DECLARE @instanceId		INT = 0
	DECLARE @backupSetId	INT = 0
	DECLARE @subclientId	INT = 0
	DECLARE @policyId		INT = 0
	DECLARE @copyId			INT = 0
	DECLARE @trackingPolicy	INT = 0
	DECLARE @srmReportSet	INT = 0
	DECLARE @srmReportType	INT = 0
	DECLARE @mediaAgentId	INT = 0
	DECLARE @agentlessPolicyId	INT = 0
	DECLARE @userName		NVARCHAR(255)
	DECLARE @xmlText		XML
	DECLARE @searchId		INT = 0
	DECLARE @nowTime		INT = dbo.GetUnixTime (GetDate())
	DECLARE @nowUtcTime		INT = dbo.GetUnixTime (GETUTCDATE())
	DECLARE @subTaskType	INT = 0
	DECLARE @operationType	INT = 0
	DECLARE @taskType		INT = 0
	DECLARE @userId			INT = 0
	DECLARE @alertId		INT = 0
	DECLARE @ownerId		INT = 0
	DECLARE @localeId		INT = 0
	DECLARE @addTblOption	INT = 1		--FLAG TO AVOID RE-INSERTING OPTION
	DECLARE @agentlessPolicyName NVARCHAR(MAX) = ''
	DECLARE @workflowId		INT = 0
	DECLARE @initFrom		INT = 0
	DECLARE @oscJob			INT = 0
	DECLARE @jobStaggerTime	INT = 0
	DECLARE @LIVESYNC_STARTING INT = 11
	DECLARE @numOfDays		INT = 0
	DECLARE @autoCopy		INT = 0
	DECLARE @scStatus		INT = 0
	DECLARE @backupLevel	INT = 0
	DECLARE @autoSyntheticDay	INT = 0
	DECLARE @enableRunConsolidateFull	INT = 0
	DECLARE @isSubclientHierarchyOptionInserted INT = 0
	-------------
	--BACKUP-----
	-------------
	BEGIN
		SELECT @subTaskType=ST.subTaskType, @operationType=ST.operationType, @taskType=T.taskType, @userId=T.runUserId,
			@alertId=T.alertId, @ownerId=T.ownerId, @localeId=T.localeId
		FROM TM_SubTask AS ST WITH(READUNCOMMITTED)
		INNER JOIN TM_Task AS T WITH(READUNCOMMITTED) ON T.taskId = ST.taskId
		WHERE ST.subTaskId=@i_subTaskId
		IF ( (@taskType & 4) = 4) -- Only if from Schedule Policy consider job stagger time
		BEGIN
SELECT TOP 1 @jobStaggerTime = value FROM TM_SubTaskOptions WITH(READUNCOMMITTED) WHERE subTaskId = @i_subTaskId AND optionId IN (1922941841)
			IF @jobStaggerTime > 10
				SET @jobStaggerTime = 10
		END
		SET @jobStaggerTime = ISNULL((@nowUtcTime + (@i_assocPosition * @jobStaggerTime)), 0)
		IF @o_jobId > 0
			SET @oscJob = 1
SET @searchId = ISNULL((SELECT TOP 1 value FROM TM_SubTaskOptions WITH(READUNCOMMITTED) WHERE subTaskId = @i_subTaskId AND  optionId IN (307086581, 869221685)), 0)
		IF (@searchId = 0)
		BEGIN
			--CREATE JOB ID
			IF @oscJob = 0
				--Insert into temp table to avoid sending it as a response
				INSERT INTO @t_JobId EXEC @o_jobId = TM_GetNextJobId
		END
		ELSE
		BEGIN
			SET @o_jobId = @searchId
		END
		--INSERT THE JOB
		IF @oscJob = 0
			INSERT INTO TM_Jobs ( jobId, jobRequestId, predecessor, status, timeToStart)
			VALUES( @o_jobId, @i_jobRequestId , @i_predjobId, @i_submissionStatus, @jobStaggerTime )
		--INSERT THE JOB OPTIONS
		--INSERT INTO TM_JobOptions SELECT @o_jobId, optionId, type, value, @i_taskId, @i_subTaskId, 0, @nowTime, 0 FROM TM_SubTaskOptions
		--	WHERE subTaskId = @i_subTaskId AND optionId NOT IN (BACKUPSET_CLIENT_ID, BACKUPSET_APPLICATION_ID, BACKUPSET_INSTANCE_ID, BROWSEOPTION_COMM_CELL_ID)
		--GET ENTITY INFORMATION
IF ( @i_subTaskType = 2 OR @i_subTaskType = 3)
		BEGIN
			IF @i_appId > 0
				SELECT
					@clientGroupId=AE.clientGroupId,
					@clientId=APP.clientId,
					@appTypeId=APP.appTypeId,
					@instanceId=APP.instance,
					@backupSetId=APP.backupSet,
					@subclientId=APP.id, @policyId=policyId, @copyId=copyId, @srmReportSet=srmReportSet, @srmReportType=srmReportType,
					@trackingPolicy=trackingPolicyId, @mediaAgentId=MediaAgentId, @agentlessPolicyId=agentlessPolicyId, @workflowId=workflowId
					FROM TM_AssocEntity AE WITH(READUNCOMMITTED)
					LEFT OUTER JOIN APP_ClientGroupAssoc ACG WITH(NOLOCK) ON (AE.assocType = 28 AND AE.clientGroupId = ACG.clientGroupId)
					LEFT OUTER JOIN APP_Client C WITH(NOLOCK) ON (ACG.clientId = C.id OR AE.clientId = C.id )
					LEFT OUTER JOIN App_SubclientProp SCP WITH(NOLOCK) ON SCP.attrName = 'Associated Plan' AND SCP.cs_attrName = CHECKSUM(N'Associated Plan')
					AND CAST(AE.entityId AS NVARCHAR(10)) = SCP.attrVal
					AND AE.assoctype = 158-- plan entity
					AND SCP.modified = 0
					LEFT OUTER JOIN APP_Application APP WITH(NOLOCK) ON
					(
						c.id = APP.clientId
						AND (AE.appTypeId=APP.appTypeId OR AE.appTypeId = 0)
						AND (AE.instanceId =APP.instance OR AE.instanceId= 0)
						AND (AE.backupsetId = APP.backupSet OR AE.backupsetId=0)
					)
					OR App.ID = SCP.componentNameID
					WHERE AE.taskId = @i_taskId AND APP.id = @i_appId
			ELSE
				SELECT @clientGroupId=clientGroupId, @clientId=clientId, @appTypeId=apptypeId, @instanceId=instanceId, @backupSetId=backupsetId,
					@subclientId=subclientId, @policyId=policyId, @copyId=copyId, @srmReportSet=srmReportSet, @srmReportType=srmReportType,
					@trackingPolicy=trackingPolicyId, @mediaAgentId=MediaAgentId, @agentlessPolicyId=agentlessPolicyId, @workflowId=workflowId
					FROM TM_AssocEntity WITH(READUNCOMMITTED) WHERE taskId = @i_taskId
		END
ELSE IF ( @i_subTaskType = 1 OR @i_subTaskType = 4)
		BEGIN
			SELECT @clientGroupId=clientGroupId, @clientId=clientId, @appTypeId=apptypeId, @instanceId=instanceId, @backupSetId=backupsetId,
				@subclientId=subclientId, @policyId=policyId, @copyId=copyId, @srmReportSet=srmReportSet, @srmReportType=srmReportType,
				@trackingPolicy=trackingPolicyId,  @mediaAgentId=MediaAgentId, @agentlessPolicyId = agentlessPolicyId, @workflowId=workflowId
				FROM TM_AssocEntity WITH(READUNCOMMITTED) WHERE taskId = @i_taskId AND assocId = @i_assocId
		END
		IF (@agentlessPolicyId IS NOT null AND @agentlessPolicyId > 0)
		BEGIN
			--INSERT THE JOB XML OPTIONS
			SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WITH(READUNCOMMITTED) WHERE subTaskId = (SELECT TOP 1 subTaskId FROM TM_SubTask WITH(READUNCOMMITTED) WHERE taskId=@agentlessPolicyId))
INSERT INTO TM_JobOptions VALUES ( @o_jobId, 150016, 1, CAST(@xmlText AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)
			--INSERT INTO TM_JobOptions VALUES ( @o_jobId, COM_AGENTLESS_POLICY_ID, TM_OPTION_TYPE_INTEGER, CAST(@agentlessPolicyId as NVARCHAR(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)
			--SET @agentlessPolicyName = (SELECT taskName FROM TM_Task WITH(READUNCOMMITTED) WHERE taskId = @agentlessPolicyId)
			--INSERT INTO TM_JobOptions VALUES ( @o_jobId, COM_AGENTLESS_POLICY_NAME, TM_OPTION_TYPE_STRING, @agentlessPolicyName, @i_taskId, @i_subTaskId, 0, @nowTime, 0)
		END
		SELECT @flags = T.flags
		FROM TM_Task T WITH(NOLOCK)
		WHERE T.taskId = @i_taskId
		SELECT @initFrom=initiatedFrom
		FROM TM_JobRequest (NOLOCK)
		WHERE jobRequestId = @i_jobRequestId
IF ( @i_subTaskType = 2)	--			SUBTASK_BACKUP = 2
		BEGIN
			--INSERT THE APPID
			INSERT INTO TM_JobOptions
select @o_jobId, 100001, 7, CAST(@i_appId as NVARCHAR(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0	--BKP_APPID_
			where @i_appId != 0
			union all
select @o_jobId, 140007, 7, CAST(@i_appId as NVARCHAR(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0	--BKP_APPID_
			where @i_appId != 0
			union all
select @o_jobId, 140008, 7, CAST(@policyId as NVARCHAR(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @policyId!=0
			union all
select @o_jobId, 140009, 7, CAST(@copyId as NVARCHAR(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @copyId != 0
			union all
select @o_jobId, 458405394, 15, CAST(@i_backupLevel as NVARCHAR(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where  @i_backupLevel != 0
			--For Activate FSO as the schedule cannot support adding some options so we are adding additional job options instead of the client
			IF @i_appId != 0
			BEGIN
				INSERT INTO TM_JobOptions(jobId, optionId, type, value, taskId, subTaskId,lastJobId, created, modified)
SELECT @o_jobId, 1510939499, 2, CASE WHEN SCP.attrVal = '0' THEN '1' WHEN SCP.attrVal IS NULL THEN NULL ELSE '0' END, @i_taskId, @i_subTaskId, 0, @nowTime, 0
					FROM APP_SubclientProp SCP WITH(NOLOCK)
LEFT JOIN TM_SubTaskOptions JO WITH(NOLOCK) ON JO.optionId = 1510939499 AND JO.subTaskId = @i_subTaskId
					WHERE SCP.componentNameId = @i_appId AND SCP.attrName = 'adHoc One Time Archive' AND SCP.modified = 0 AND SCP.cs_attrName = checksum(N'adHoc One Time Archive') AND JO.optionId IS NULL
				UNION ALL
SELECT @o_jobId, 698216185, 1, SCP.attrVal, @i_taskId, @i_subTaskId, 0, @nowTime, 0
					FROM APP_SubclientProp SCP WITH(NOLOCK)
LEFT JOIN TM_SubTaskOptions JO WITH(NOLOCK) ON JO.optionId = 698216185 AND JO.subTaskId = @i_subTaskId
					WHERE SCP.componentNameId = @i_appId AND SCP.attrName = 'adHoc Archive Rules' AND SCP.cs_attrName = checksum(N'adHoc Archive Rules') AND SCP.modified = 0 AND JO.optionId IS NULL
				UNION ALL
SELECT @o_jobId, 1772132903,7, SCP.attrVal, @i_taskId, @i_subTaskId, 0, @nowTime, 0
					FROM APP_SubclientProp SCP WITH(NOLOCK)
LEFT JOIN TM_SubTaskOptions JO WITH(NOLOCK) ON JO.optionId = 1772132903 AND JO.subTaskId = @i_subTaskId
					WHERE SCP.componentNameId = @i_appId AND SCP.attrName = 'Live Crawl SubClientId' AND SCP.cs_attrName = checksum(N'Live Crawl SubClientId') AND SCP.modified = 0 AND JO.optionId IS NULL
			END
SET @autoCopy = ISNULL((SELECT value FROM TM_SubTaskOptions WITH(READUNCOMMITTED) WHERE subTaskId = @i_subTaskId AND  optionId = 1013376701), 0)
			IF @autoCopy = 1
			BEGIN
SET @backupLevel = ISNULL((SELECT value FROM TM_SubTaskOptions WITH(READUNCOMMITTED) WHERE subTaskId = @i_subTaskId AND  optionId = 458405394), 0)
SET @numOfDays = ISNULL((SELECT value FROM TM_SubTaskOptions WITH(READUNCOMMITTED) WHERE subTaskId = @i_subTaskId AND  optionId = 1765126965), 0)
SET @autoSyntheticDay = ISNULL((SELECT value FROM TM_SubTaskOptions WITH(READUNCOMMITTED) WHERE subTaskId = @i_subTaskId AND  optionId = 1778633837), 0)
SET @enableRunConsolidateFull = ISNULL((SELECT value FROM TM_SubTaskOptions WITH(READUNCOMMITTED) WHERE subTaskId = @i_subTaskId AND  optionId = 328367274), 0)
IF (@numOfDays > 0 OR @autoSyntheticDay = 1 OR @enableRunConsolidateFull = 1) AND @backupLevel = 4 AND @i_backupLevel = 1
				BEGIN
					SELECT @appTypeId=appTypeId, @backupSetId=backupSet, @scStatus = subclientStatus
					FROM APP_Application (READUNCOMMITTED) WHERE id = @i_appId
					--IF IT DOES NOT SUPPORT SYNTHETIC THE BACKUP TYPE HAS BEEN CONVERTED THEN SET THE INIT TO SCHEDULE TO AVOID JM TREATING IT AS AN OSC JOB
					IF ( 	(@appTypeId IN (SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(33, 0))  --APPGRP_SynthFullNotSupported
							AND NOT EXISTS (SELECT 1 FROM APP_BackupSetProp WHERE componentNameId=@backupSetId AND attrName='NAS Turbo Backupset' AND attrVal='1' AND modified=0)
							AND NOT EXISTS (SELECT 1 FROM APP_SubClientProp WHERE componentNameId=@i_appId AND attrName='Is Turbo Subclient' AND attrVal='1' AND modified=0 AND cs_attrName = CHECKSUM(N'Is Turbo Subclient'))
							AND NOT EXISTS (SELECT 1 FROM APP_SubClientProp WHERE componentNameId=@i_appId AND attrName='Use block level backup' AND attrVal='1' AND modified=0 AND cs_attrName = CHECKSUM(N'Use block level backup')
AND @appTypeId IN (22, 80, 104, 125, 37 , 62, 5, 135)
											)
							AND (@scStatus&0x10000=0) --CV_STATUS_REFCOPY_SUB
							)
							OR
@appTypeId IN (3, 55, 125, 135, 61, 79,
13, 104, 76, 87
											)
					)
SET @initFrom = 5
				END
			END
		END
ELSE IF ( @i_subTaskType = 3)	--			SUBTASK_RESTORE = 3
		BEGIN
			IF object_id('tempdb.dbo.#xmlOption_InfoTable') is not null
				DROP TABLE #xmlOption_InfoTable
			CREATE TABLE #xmlOption_InfoTable(replicationId INT, xmlValue XML)
			--INSERT THE APPID
			DECLARE @sourceClientId INT
			DECLARE @sourceAppTypeId INT
			DECLARE @sourceInstanceId INT
			DECLARE @sourceBsetId INT
			DECLARE @indexFree INT
			DECLARE @insertJobXmlOption INT = 0
			DECLARE @jobOptionXml xml = NULL
			SELECT @sourceClientId = clientId, @sourceAppTypeId = apptypeId, @sourceInstanceId = instanceId, @sourceBsetId = backupsetId FROM TM_AssocEntity WITH(READUNCOMMITTED) WHERE taskId = @i_taskId
			IF (@sourceClientId = 0)
				SET @sourceClientId = 2
			SET @indexFree = ISNULL((SELECT ref.value('@indexFreeRestore', 'int')
										FROM @xmlText.nodes('TMMsg_JobOption/restoreOptions/commonOptions') R( ref ) ),
										0)
IF (@indexFree <> 0 AND @appTypeId = 1000)
			BEGIN
				DECLARE @cId INT
				SET @cId = (SELECT clientId FROM APP_CommCell WITH(READUNCOMMITTED) WHERE id=2)
				SELECT @sourceClientId=clientId, @backupSetId=backupSet FROM APP_Application WITH(READUNCOMMITTED)
WHERE clientId=@cId AND appTypeId = 1000
				IF (@sourceClientId = 0)
				BEGIN
					SET @errorCode = 10001
					SET @errorString = 'Could not get source client for ER Task'
					GOTO EXIT_INSERT_JOB_OPTIONS
				END
				IF (@backupSetId = 0)
				BEGIN
					SET @errorCode = 10002
					SET @errorString = 'Could not get backupset for ER Task'
					GOTO EXIT_INSERT_JOB_OPTIONS
				END
			END
			--DETERMINE DEFAULT BACKUPSET ID FOR REPLICATION RECOVERY JOBS
IF (@appTypeId = 47 OR @appTypeId = 50)
			BEGIN
				IF (@backupSetId = 0)
				BEGIN
					SELECT @backupSetId=id FROM APP_BackupSetName WITH(READUNCOMMITTED) WHERE status&8=8 AND id IN (
						SELECT backupSet FROM APP_Application WITH(READUNCOMMITTED) WHERE clientId=@sourceClientId AND appTypeId=@appTypeId)
				END
			END
			INSERT INTO TM_JobOptions
select  @o_jobId, 152984797, 7, CAST(@sourceClientId as NVARCHAR(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0	--BACKUPSET_CLIENT_ID_
			where @sourceClientId != 0
			union all
select  @o_jobId, 587329586, 7, CAST(@sourceAppTypeId as NVARCHAR(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0	--BACKUPSET_APPLICATION_ID_
			where @sourceAppTypeId != 0
			union all
select 	@o_jobId, 1189579219, 7, CAST(@sourceInstanceId as NVARCHAR(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0	--BACKUPSET_INSTANCE_ID_
			where @sourceInstanceId != 0
			union all
select 	@o_jobId, 1496752764, 7, '2', @i_taskId, @i_subTaskId, 0, @nowTime, 0	--BROWSEOPTION_COMM_CELL_ID_
IF (@operationType = 1007)
			BEGIN
				-- In case its not vSA apptype, for FS live sync in case copy precedence is specified then we specify toTime in JobOptions.
IF (@sourceAppTypeId <> 106 AND @i_association IS NOT NULL AND
					CAST(@i_association as NVARCHAR(MAX)) != '')
				BEGIN
					;WITH siteReplicationInfoXML(replicationId, TotimeForRestore)
					AS
					(
						SELECT ref.value('@replicationId', 'INT'), ref.value('@toTimeForRestore', 'INT')
						FROM @i_association.nodes('App_LiveSyncReplicationResp/siteInfo') R(ref)
					),
					LiveSyncReplicationTbl(ReplicationId, restoreSource, isDumpSweepSc)
					AS
					(
						SELECT App_LiveSyncReplication.replicationId, restoreSource, isDumpSweepSc
						FROM siteReplicationInfoXML
						INNER JOIN App_LiveSyncReplication (NOLOCK) ON
						App_LiveSyncReplication.replicationId = siteReplicationInfoXML.replicationId
						WHERE App_LiveSyncReplication.taskId = @i_taskId
						AND status = @LIVESYNC_STARTING
						-- Flags = 1 indicates replication pair deleted
						AND (Flags&1)=0
					),
					toTimeForRestoreTbl(toTimeForRestore)
					AS
					(
						SELECT MIN(TotimeForRestore) TotimeForRestore
						FROM siteReplicationInfoXML
						WHERE  ISNULL(TotimeForRestore,0)>0
					)
					INSERT INTO TM_JobOptions
					(jobId, optionId, type, value, taskId, subTaskId, lastJobId, created, modified)
SELECT @o_jobId, 237388043, 7, CAST(TotimeForRestore AS NVARCHAR(10)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
					FROM toTimeForRestoreTbl
					WHERE TotimeForRestore IS NOT NULL
					UNION
SELECT @o_jobId, 120012, 1,
					(
						SELECT replicationId '@id1', restoreSource '@name'
						FROM LiveSyncReplicationTbl
						FOR XML PATH('entities'),
						ROOT ('TMMsg_EntityListResp')
					),
					@i_taskId, @i_subTaskId, 0, @nowTime, 0
					UNION
SELECT @o_jobId, 120020, 7, '1', @i_taskId, @i_subTaskId, 0, @nowTime, 0
					FROM LiveSyncReplicationTbl
					WHERE  isDumpSweepSc>0
					SET @i_association = NULL
				END
				IF CAST(@i_association as NVARCHAR(MAX)) != ''
				BEGIN
					INSERT INTO #xmlOption_InfoTable
					(replicationId, xmlValue)
					SELECT ref.value('@id1', 'INT'), ref.value('@name', 'NVARCHAR(MAX)')
					FROM @i_association.nodes('/TMMsg_EntityListResp/entities') R(ref)
					INSERT INTO TM_JobOptions
					(jobId, optionId, type, value, taskId, subTaskId, lastJobId, created, modified)
select  @o_jobId, 120012, 1, CAST(@i_association as NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0	--RST_REPLICATION_IDS_
					union all
SELECT @o_jobId, 120014, 1, sourceGuid, @i_taskId, @i_subTaskId, 0, @nowTime, 0
					FROM APP_VSAReplication VS (NOLOCK)
					WHERE VS.replicationId IN (
						SELECT ref.value('@id1', 'INT') FROM @i_association.nodes('/TMMsg_EntityListResp/entities') R(ref)
					)
					UNION ALL
SELECT @o_jobId, 237388043, 7, MAX(bs.value('@toTime', 'VARCHAR(10)')), @i_taskId, @i_subTaskId, 0, @nowTime, 0
					FROM #xmlOption_InfoTable T
					CROSS APPLY T.xmlValue.nodes('/TMMsg_BrowseOption/timeRange') B(bs)
					SELECT @jobOptionXml = xmlValue from TM_jobxmlOptions
						WHERE subtaskid=@i_subTaskId and jobId=0
AND @sourceAppTypeId = 106
					IF EXISTS(SELECT 1 FROM GxGlobalParam WHERE name='skipIPCustomizationForLiveSync' AND modified=0 AND value='1')
					BEGIN
						SET @insertJobXmlOption = 1
						DECLARE @skipIPCustomization INT = 1
						-- check whether there are any VMS which need to be inserted skipIPCustomization attribute
						IF @jobOptionXml IS NOT NULL AND EXISTS(SELECT 1 FROM APP_VSAReplication (NOLOCK)
								WHERE replicationId IN (
									SELECT ref.value('@id1', 'INT') FROM @i_association.nodes('/TMMsg_EntityListResp/entities') R(ref)
								)
								AND failoverStatus <> 2 -- failover in progress
							)
						BEGIN
							DECLARE @jobXmlTempTable TABLE
							(
								advancedRestorejobOption XML
							)
							INSERT INTO @jobXmlTempTable
							select ref.query('.')
							FROM @jobOptionXML.nodes('TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions') R(ref)
							UPDATE @jobXmlTempTable
							SET advancedRestorejobOption.modify('insert (attribute skipIPCustomization {sql:variable("@skipIPCustomization")}) into (advancedRestoreOptions[@guid=sql:column("APP_VSAReplication.sourceGuid")])[1]')
							FROM APP_VSAReplication
								WHERE replicationId IN (
									SELECT ref.value('@id1', 'INT') FROM @i_association.nodes('/TMMsg_EntityListResp/entities') R(ref)
								)
								AND failoverStatus <> 2
							DECLARE @advancedRestoreOptionsXmlTemp XML
							SET @advancedRestoreOptionsXmlTemp = (SELECT advancedRestorejobOption.query('.') FROM @jobXmlTempTable FOR XML PATH('') )
							if @advancedRestoreOptionsXmlTemp is not null
							BEGIN
								set @jobOptionXml.modify('delete TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions')
								SET @jobOptionXml.modify('insert ( sql:variable("@advancedRestoreOptionsXmlTemp")) into (TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption)[1]')
							END
						END
					END
				END
				-- Changes to run post restore script to launch a workqueue based on global param
				DECLARE @siteReplicationPostScript NVARCHAR(MAX)
				SET @siteReplicationPostScript = ISNULL((SELECT value FROM GXGlobalParam
														 WHERE name = 'VSASiteReplicationPostScript'), '')
				IF @siteReplicationPostScript <> ''
				BEGIN
INSERT INTO TM_JobOptions VALUES( @o_jobId, 50443400, 1, CAST(@siteReplicationPostScript as NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0)
				END
				-- Check whether this schedule is using allocation policy and if so, then populate destination clientId option
				declare @isScheduleUsingAllocationPolicy int = 0
				declare @vcenterInstanceXml xml
				select @isScheduleUsingAllocationPolicy = 1 from TM_Subtaskoptions with (nolock)
				where TM_Subtaskoptions.subtaskId=@i_subTaskId
and TM_Subtaskoptions.optionId=1264497636
				and TM_Subtaskoptions.value='1'
				declare @allocationPolicyId int = 0
				declare @isFailBackJob int =0
				declare @proxyClientEntityId int = 0
				declare @replicationGroupId int =0
				select @replicationGroupId = componentnameid from App_ReplicationGroupAssociation where taskid = @i_taskId
				-- in case of live sync job
				if @operationType = 1007
				begin
					select @allocationPolicyId = value from TM_Subtaskoptions with (nolock)
					where TM_Subtaskoptions.subtaskId=@i_subTaskId
and TM_Subtaskoptions.optionId=1008442949
					if @allocationPolicyId is not null and @allocationPolicyId>0
					begin
						select @proxyClientEntityId = CAST(attrVal AS INT) from [dbo].[App_VMAllocationPolicyProp] with (nolock)
						WHERE App_VMAllocationPolicyProp.componentNameId=@allocationPolicyId
						and attrname='ProxyClientEntity'
						select @isFailBackJob = value from TM_Subtaskoptions with (nolock)
						where TM_Subtaskoptions.subtaskId=@i_subTaskId
and TM_Subtaskoptions.optionId=120017
						if @proxyClientEntityId>0 and @isFailBackJob=0 and
						(isnull(@replicationGroupId ,0) >0  or @isScheduleUsingAllocationPolicy = 1 )
						begin
INSERT INTO TM_JobOptions VALUES( @o_jobId, 293753447, 7,@proxyClientEntityId , @i_taskId, @i_subTaskId, 0, @nowTime, 0)
						end
					end
				end
				if @isScheduleUsingAllocationPolicy = 1 AND @operationType = 1007 --adding this check only for live sync task
				begin
					IF object_id('tempdb.dbo.#replicationIdList') is not null
						DROP TABLE #replicationIdList
					CREATE TABLE #replicationIdList(replicationId int primary key(replicationId) )
					Insert into #replicationIdList
					SELECT distinct ref.value('@id1', 'INT') FROM @i_association.nodes('/TMMsg_EntityListResp/entities') R(ref)
					if @allocationPolicyId is not null and @allocationPolicyId>0
					begin
						declare @destinationHyperVClientEntityId int = 0
						select @destinationHyperVClientEntityId = CAST(attrVal AS INT) from [dbo].[App_VMAllocationPolicyProp] with (nolock)
						WHERE App_VMAllocationPolicyProp.componentNameId=@allocationPolicyId
						and attrname='destinationHyperV'
						-- Also frame vcenterInstance xml node.
							set @vcenterInstanceXml = (
									select top 1 App_client.id '@clientId',App_client.name '@clientName', App_application.apptypeId '@applicationId', 'Virtual Server' '@appName',App_application.instance '@instanceId',App_InstanceName.name '@instanceName'
									from App_application with (nolock)
									inner join App_client with (nolock) on App_application.clientId=App_client.id and App_client.id=@destinationHyperVClientEntityId
									inner join App_instanceName with (nolock) on App_application.instance=App_InstanceName.id
where App_application.apptypeId=106
									for xml path('vCenterInstance')
								)
					end
					-- Also get the source client and insert it here.
					select @clientId = App_Application.clientId,@appTypeId = App_application.AppTypeid, @instanceId = App_application.instance, @backupSetId = App_application.backupset, @subclientId=App_application.id
					FROM APP_VSAReplication VS (NOLOCK)
					inner join #replicationIdList replicationIdList on
					VS.replicationId = replicationIdList.replicationId
					inner join App_Application (NOLOCK) on
					VS.subclientId = App_Application.id
					INSERT INTO TM_JobOptions
select @o_jobId, 140003, 7, CAST(@clientId as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
					where @clientId != 0
					union all
select @o_jobId, 140004, 7, CAST(@appTypeId as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
					where @appTypeId != 0
					union all
select @o_jobId, 140005, 7, CAST(@instanceId as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
					where @instanceId != 0
					union all
select @o_jobId, 140006, 7, CAST(@backupSetId as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
					where @backupSetId != 0
					union all
select @o_jobId, 140007, 7, CAST(@subclientId as varchar(28)), @i_taskId, @i_subTaskId, 0,  @nowTime, 0
					where (@subclientId != 0)
					union all
SELECT @o_jobId, 150001, 150001, '\'+sourceGuid, @i_taskId, @i_subTaskId, 0, @nowTime, 0
					FROM APP_VSAReplication VS (NOLOCK)
					inner join #replicationIdList replicationIdList on
					VS.replicationId = replicationIdList.replicationId
					union all
SELECT @o_jobId, 1802064491, 1, replicationguid, @i_taskId, @i_subTaskId, 0, @nowTime, 0
					FROM APP_VSAReplication VS (NOLOCK)
					inner join #replicationIdList replicationIdList on
					VS.replicationId = replicationIdList.replicationId
					SET @isSubclientHierarchyOptionInserted = 1
					DECLARE @copyPrecedence int = 0
					DECLARE @copyPrecedenceApplicable int = 0
					DECLARE @replicationGuidVSA NVARCHAR(255) = ''
					SELECT @replicationGuidVSA = replicationguid
					FROM APP_VSAReplication VS (NOLOCK)
					INNER JOIN #replicationIdList replicationIdList ON
					VS.replicationId = replicationIdList.replicationId
					SELECT @copyPrecedence = CONVERT(INT,TM_Subtaskoptions.value)
					FROM TM_Subtaskoptions WITH (NOLOCK)
					WHERE TM_Subtaskoptions.subtaskId = @i_subTaskId
and TM_Subtaskoptions.optionId=957862300
					select @copyPrecedence = ArchGroupcopy.copy
					from TM_Subtaskoptions with (nolock)
					inner join ArchGroupcopy with (nolock) on TM_Subtaskoptions.subtaskId = @i_subTaskId
and TM_Subtaskoptions.optionId=1019965049
					and TM_Subtaskoptions.value=convert(nvarchar(max),ArchGroupcopy.id)
					if (@copyPrecedence>0)
					begin
						set @copyPrecedenceApplicable = 1
					end
					INSERT INTO TM_JobOptions (jobId, optionId, type, value, taskId, subTaskId, lastJobId, created, modified)
SELECT @o_jobId, 957862300, 7, @copyPrecedence, @i_taskId, @i_subTaskId, 0, @nowTime, 0
					union
SELECT @o_jobId, 626266533, 7, @copyPrecedenceApplicable, @i_taskId, @i_subTaskId, 0, @nowTime, 0
					-- If the schedule is using allocation policy, then populate advancedRestoreOptions under diskLevelVMRestoreOption
					declare @vmDetailsForReplication table
					(
						replicationId int,
						sourceGuid nvarchar(256),
						sourceName nvarchar(1024),
						newName nvarchar(2048),
						skipIPCustomization INT,
						needsDestinationNameUpdate INT
					)
					Insert into @vmDetailsForReplication(replicationId,sourceGuid, sourceName,newName,skipIPCustomization, needsDestinationNameUpdate)
					SELECT VS.replicationId, VS.sourceGuid, VS.sourceName,CASE WHEN VS.destinationName IS NOT NULL AND LEN(VS.destinationName)>0 THEN VS.destinationName ELSE VS.sourceName END,
						CASE WHEN VS.failoverStatus = 2 THEN 0 ELSE 1 END,
						CASE WHEN VS.destinationName IS NOT NULL AND LEN(VS.destinationName)>0 THEN 0 ELSE 1 END -- If destination is there then use the same. Else compute destination name from source name and prefix/suffix from recovery target.
					FROM APP_VSAReplication VS (NOLOCK)
					inner join #replicationIdList replicationIdList on
					VS.replicationId = replicationIdList.replicationId
					-- Update destination name for the replication VM based on allocation policy property
					declare @vmNameEditType int
					declare @vmNameEditString nvarchar(max)
					select @vmNameEditType=vxml.value('(policy/@vmNameEditType)[1]', 'int'), @vmNameEditString=isnull(vxml.value('(policy/@vmNameEditString)[1]', 'nvarchar(1024)'),'')
					from App_VmallocationPolicy with (nolock)
					where id=@allocationPolicyId
					if (@vmNameEditType=1) -- Prefix vm name
					begin
						update @vmDetailsForReplication
						set newName=@vmNameEditString+newName
						WHERE needsDestinationNameUpdate = 1
					end
					else
					begin	-- Suffix vm name
						update @vmDetailsForReplication
						set newName=newName+@vmNameEditString
						WHERE needsDestinationNameUpdate = 1
					end
					declare @policyType int =0
					declare @securityGroups xml
					declare @vmSize  nvarchar(max)=''
					-- Get the nic xml from allocation policy
					declare @networkDetailsXml xml
					declare @esxServerName nvarchar(max) = ''
					declare @dataStoreName nvarchar(max) = ''
					declare @resourcePoolPath nvarchar(max) = ''
					declare @datacenterName nvarchar(max) =''
					declare @availabilityzone nvarchar(max)=''
					declare @vmuserName nvarchar(1024) =''
					declare @domainName nvarchar(1024)=''
					declare @password nvarchar(1024) =''
					DECLARE @folderPath nvarchar(1024) =''
					DECLARE @amazonVolumeType nvarchar(1024) =''
					select @networkDetailsXml=vxml.query('policy/networkList'),
						@securityGroups = vxml.query('policy/secuirtyGroups'),
						@esxServerName= vxml.value('(policy/esxServers/@esxServerName)[1]','nvarchar(max)'),
						@dataStoreName= vxml.value('(policy/dataStores/@dataStoreName)[1]','nvarchar(max)'),
						@resourcePoolPath= vxml.value('(policy/@resourcePoolPath)[1]','nvarchar(max)'),
						@policyType = isnull(vxml.value('(policy/entity/@policyType)[1]','int'),0),
						@datacenterName = isnull(vxml.value('(policy/dataCenter/@dataCenterName)[1]','nvarchar(max)'),''),
						@availabilityzone = isnull(vxml.value('(policy/amazonPolicy/availabilityZones/@availabilityZoneName)[1]','nvarchar(max)'),''),
						@vmSize = isnull(vxml.value('(policy/amazonPolicy/vmInstanceTypes/vmInstanceTypeName)[1]','nvarchar(max)'),
								  isnull(vxml.value('(policy/amazonPolicy/instanceTypes/vmInstanceTypeName)[1]','nvarchar(max)'),'')),
						@domainName = isnull(vxml.value('(policy/vmCredentials/@domainName)[1]','nvarchar(1024)'),''),
						@vmuserName = isnull(vxml.value('(policy/vmCredentials/@userName)[1]','nvarchar(1024)'),''),
						@password = isnull(vxml.value('(policy/vmCredentials/@password)[1]','nvarchar(1024)'),''),
						@folderPath = isnull(vxml.value('(policy/@folderPath)[1]','nvarchar(1024)'),''),
						@amazonVolumeType = vxml.value('(policy/amazonPolicy/@volumeType)[1]','nvarchar(1024)')
					from App_VmallocationPolicy with (nolock)
					where id=@allocationPolicyId
					set @networkDetailsXml = replace(replace(convert(nvarchar(max),@networkDetailsXml),'<networkList','<nics'),'</networkList>','</nics>')
					if ( @policyType = 0 )
					begin
						-- Also modify networkDetailsXml to have sourceNetwork as *
						set @networkDetailsXml.modify('delete nics/@sourceNetwork')
						set @networkDetailsXml.modify('insert attribute sourceNetwork {"*" } into (nics)[1]')
					end
					declare @volumrestoreoption xml = '<volumeRstOption volumeLeveRestore="0" volumeLevelRestoreType="1" destinationVendor="0" />'
					if ( @policyType = 7)
					begin
						-- modify security groups
						declare @groupId nvarchar(max) =''
						select @groupId = isnull(@securityGroups.value('(securityGroups/groupId)[1]','nvarchar(max)'), '')
						if @groupId != ''
						begin
							set @securityGroups = replace(convert(nvarchar(max),@securityGroups),'name','groupName')
						end
						if @vmSize='' or @vmSize = '--Auto Select--'
							set @vmSize =''
						else
							set @vmSize = SUBSTRING(@vmSize,1,(CHARINDEX(' ',@vmSize + ' ')-1))
						set @volumrestoreoption  = '<volumeRstOption volumeLeveRestore="0" volumeLevelRestoreType="1" destinationVendor="7" />'
					end
					if ( @policyType = 1)
					begin
						set @volumrestoreoption  = '<volumeRstOption volumeLeveRestore="0" volumeLevelRestoreType="1" destinationVendor="4" />'
						set @esxServerName = @availabilityzone
					end
					-- Get MaxSnapShotPerDRVM and add it in advancerestorexmloptions
					DECLARE @xmlValue XML
					SELECT @xmlValue = xmlValue FROM tm_subtaskxmloptions WHERE subtaskid = @i_subTaskId
					DECLARE @nMaxSnapshotsPerDRVM INT = -1
					SELECT @nMaxSnapshotsPerDRVM = ISNULL(@xmlValue.value('(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions/@nMaxSnapshotsPerDRVM)[1]','INT'),-1)
					-- Now that destination names are updated, frame the advancedRestoreOptions xml.
					declare @advancedRestoreOptionsXml xml
					set @advancedRestoreOptionsXml = (
						select sourceGuid '@guid', sourceName '@name', newName '@newName',
							@esxServerName '@esxHost',
							@dataStoreName '@Datastore',
							@vmSize '@vmSize',
							@skipIPCustomization '@skipIPCustomization',
							@dataCenterName '@datacenter',
							@folderPath '@FolderPath',
							case when len(@resourcePoolPath)>0 then @resourcePoolPath else NULL end '@resourcePoolPath',
							@vmuserName '@destComputerUserName',
							@domainName '@destComputerName',
							@password '@instanceAdminPassword',
							@amazonVolumeType '@volumeType',
							CASE WHEN @nMaxSnapshotsPerDRVM > 0 THEN @nMaxSnapshotsPerDRVM ELSE NULL END '@nMaxSnapshotsPerDRVM',
							@networkDetailsXml.query('.'),
							@securityGroups.query('.')
						from @vmDetailsForReplication
						for xml path('advancedRestoreOptions')
					)
					if @advancedRestoreOptionsXml is not null
					begin
						SET @insertJobXmlOption = 1
						set @jobOptionXml.modify('delete TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions')
						SET @jobOptionXml.modify('insert ( sql:variable("@advancedRestoreOptionsXml")) into (TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption)[1]')
						if @vcenterInstanceXml is not null
						begin
							set @jobOptionXml.modify('delete TMMsg_JobOption/restoreOptions/virtualServerRstOption/vCenterInstance')
							SET @jobOptionXml.modify('insert ( sql:variable("@vcenterInstanceXml")) into (TMMsg_JobOption/restoreOptions/virtualServerRstOption)[1]')
						end
						if @volumrestoreoption is not null
						begin
							set @jobOptionXml.modify('delete TMMsg_JobOption/restoreOptions/volumeRstOption')
							SET @jobOptionXml.modify('insert ( sql:variable("@volumrestoreoption")) into (TMMsg_JobOption/restoreOptions)[1]')
						end
						IF (LEN(@replicationGuidVSA)>0)
						BEGIN
							IF (@jobOptionXml.exist('TMMsg_JobOption/restoreOptions/virtualServerRstOption/@replicationGuid') != 0)
							BEGIN
								SET @jobOptionXml.modify('replace value of (TMMsg_JobOption/restoreOptions/virtualServerRstOption/@replicationGuid)[1] with sql:variable("@replicationGuidVSA")')
							END
							ELSE
							BEGIN
								SET @jobOptionXml.modify('insert (attribute replicationGuid {sql:variable("@replicationGuidVSA")}) into (TMMsg_JobOption/restoreOptions/virtualServerRstOption)[1]')
							END
						END
						DECLARE @copyPrecedenceOptionXML XML
						SET @copyPrecedenceOptionXML = (SELECT @copyPrecedence '@copyPrecedence', @copyPrecedenceApplicable '@copyPrecedenceApplicable'
						FOR XML PATH ('copyPrecedence'))
						SET @jobOptionXml.modify('delete TMMsg_JobOption/restoreOptions/browseOption/mediaOption/copyPrecedence')
						SET @jobOptionXml.modify('insert ( sql:variable("@copyPrecedenceOptionXML")) into (TMMsg_JobOption/restoreOptions/browseOption/mediaOption)[1]')
					end
				END
ELSE IF (@sourceAppTypeId = 106 AND
					EXISTS(SELECT 1 FROM App_ClientProp (NOLOCK) WHERE ComponentNameID = @sourceClientId AND attrName='IndexingV2_VSA' AND Attrval='1' AND Modified=0) AND
					( (SELECT COUNT(1) FROM #xmlOption_InfoTable) = 1)
				)
				BEGIN
DECLARE @runIndividualReplicationForVMV2 INT = ISNULL((SELECT CAST(value AS NVARCHAR(1024)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='RunIndividualReplicationForVMV2' AND Modified = 0), 0)
					IF @runIndividualReplicationForVMV2 = 1
					BEGIN
						-- If there is only one replication for which live sync is being run, change source to VM client.
						SELECT @clientId = App_Application.clientId,@appTypeId = App_application.AppTypeid, @instanceId = App_application.instance, @backupSetId = App_application.backupset, @subclientId=App_application.id
						FROM APP_VSAReplication VS (NOLOCK) inner join #xmlOption_InfoTable replicationIdList on
						VS.replicationId = replicationIdList.replicationId
						inner join App_Application (NOLOCK) on
						VS.subclientId = App_Application.id
						INSERT INTO TM_JobOptions
select @o_jobId, 140003, 7, CAST(@clientId as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
						where @clientId != 0
						union all
select @o_jobId, 140004, 7, CAST(@appTypeId as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
						where @appTypeId != 0
						union all
select @o_jobId, 140005, 7, CAST(@instanceId as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
						where @instanceId != 0
						union all
select @o_jobId, 140006, 7, CAST(@backupSetId as varchar(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
						where @backupSetId != 0
						union all
select @o_jobId, 140007, 7, CAST(@subclientId as varchar(28)), @i_taskId, @i_subTaskId, 0,  @nowTime, 0
						where (@subclientId != 0)
						SET @isSubclientHierarchyOptionInserted = 1
					END
				END
				SET @i_association = NULL
				IF @jobOptionXml IS NOT NULL AND @insertJobXmlOption = 1
				BEGIN
					INSERT INTO TM_JobXMLOptions SELECT @o_jobId, @jobOptionXml, @i_taskId, @i_subTaskId, @o_jobId, @nowTime, 0
				END
IF  (@sourceAppTypeId <> 106 )
				BEGIN
IF NOT EXISTS(SELECT 1 FROM TM_JobOptions(NOLOCK) WHERE Jobid = @o_jobId AND OptionID = 120012 )
					AND EXISTS(select 1 from App_LiveSyncReplication  (NOLOCK)
                            WHERE taskId = @i_taskId
                            AND status = @LIVESYNC_STARTING)
					BEGIN
						INSERT INTO TM_JobOptions (jobId, optionId, type, value, taskId, subTaskId, lastJobId, created, modified)
SELECT @o_jobId, 120012, 1,
								(
									SELECT replicationId '@id1', restoreSource '@name'
									FROM APP_LiveSyncReplication (NOLOCK)
									WHERE taskId = @i_taskId
									AND status = @LIVESYNC_STARTING
									-- Flags = 1 indicates replication pair deleted
									AND (Flags&1)=0
									FOR XML PATH('entities'),
									ROOT ('TMMsg_EntityListResp')
								),
								@i_taskId, @i_subTaskId, 0, @nowTime, 0
					END
				END
			END
		END
IF ( @i_subTaskType = 1 OR @i_subTaskType = 4)
		BEGIN
			DECLARE @reportType			INT = 0
			DECLARE @reportSet			INT = 0
			DECLARE @reportName			NVARCHAR(1024)
			DECLARE @reportSetName		NVARCHAR(1024)
			DECLARE @subclientTbl		TABLE( scId INT primary key(scId) )
			DECLARE @insertEntity	INT = 0
			DECLARE @bsId	INT	= 0
			DECLARE @scId	INT	= 0
			DECLARE @FS		INT = 0
			SET @reportSetName = ''
IF (@operationType = 4011)
			BEGIN
SET @scId = ISNULL((SELECT value FROM TM_SubTaskOptions WITH(READUNCOMMITTED) WHERE subTaskId = @i_subTaskId AND  optionId = 38201114), 0)
SET @bsId = ISNULL((SELECT value FROM TM_SubTaskOptions WITH(READUNCOMMITTED) WHERE subTaskId = @i_subTaskId AND  optionId = 1058706181), 0)
				--PERFORM OPERATION ON ALL VALID SUBCLIENTS
				IF (@scId = 0)
				BEGIN
					INSERT INTO @subclientTbl
					SELECT id FROM APP_Application WITH(READUNCOMMITTED)
					WHERE backupSet=@bsId AND
					subclientStatus&4<>4 AND subclientStatus&16<>16 AND subclientStatus&32<>32
				END
				ELSE
				BEGIN
					--PERFORM OPERATION ON SELECTED SUBCLIENT
					INSERT INTO @subclientTbl VALUES(@scId)
				END
			END
			ELSE
			BEGIN
				INSERT INTO @subclientTbl VALUES(@subclientId)
			END
			IF ((SELECT @i_association.exist('/TMMsg_OperationEntity/associations')) = 1)
			BEGIN
				DECLARE @optionTable TABLE (policyId int, copyId int, sidbStoreId int, clientGroupId INT, clientId INT, appTypeId INT, instanceId INT, backupsetId INT, appId INT)
				DECLARE @opXmlText XML
				INSERT INTO @optionTable
				SELECT	ref.value('@storagePolicyId', 'INT') AS policyId,
						ref.value('@copyId', 'INT') AS copyId,
						ref.value('@sidbStoreId', 'INT') AS sidbStoreId,
						ref.value('@clientGroupId', 'INT') AS clientGroupId,
						ref.value('@clientId', 'INT') AS clientId,
						ref.value('@applicationId', 'INT') AS appTypeId,
						ref.value('@instanceId', 'INT') AS instanceId,
						ref.value('@backupsetId', 'INT') AS backupsetId,
						ref.value('@subclientId', 'INT') AS appId
					FROM @i_association.nodes ('/TMMsg_OperationEntity/associations') R(ref)
				INSERT INTO TM_JobOptions
SELECT @o_jobId, 140008, 0, CAST(policyId AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				FROM @optionTable WHERE policyId>0
				union all
SELECT @o_jobId, 140009, 0, CAST(copyId AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				FROM @optionTable WHERE copyId>0
				union all
SELECT @o_jobId, 229570007, 0, CAST(sidbStoreId AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				FROM @optionTable WHERE sidbStoreId>0
				union all
SELECT @o_jobId, 140002, 0, CAST(clientGroupId AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				FROM @optionTable WHERE clientGroupId>0
				UNION all
SELECT @o_jobId, 140003, 0, CAST(clientId AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				FROM @optionTable WHERE clientId>0
				UNION all
SELECT @o_jobId, 140004, 0, CAST(appTypeId AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				FROM @optionTable WHERE appTypeId>0
				UNION all
SELECT @o_jobId, 140005, 0, CAST(instanceId AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				FROM @optionTable WHERE instanceId>0
				UNION all
SELECT @o_jobId, 140006, 0, CAST(backupsetId AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				FROM @optionTable WHERE backupsetId>0
				UNION all
SELECT @o_jobId, 140007, 0, CAST(appId AS NVARCHAR(MAX)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				FROM @optionTable WHERE appId>0
			END
			IF (EXISTS(SELECT * FROM TM_AssocEntity WITH(READUNCOMMITTED) WHERE taskId = @i_taskId and assocId = @i_assocId))
			BEGIN
				SET @insertEntity = 1
			END
			DECLARE StartJobForSubClient CURSOR LOCAL FORWARD_ONLY STATIC READ_ONLY FOR
			SELECT scId FROM @subclientTbl WHERE scId <> 0
			OPEN StartJobForSubClient
			FETCH FROM StartJobForSubClient INTO @scId
			--START MULTIPLE JOBS FOR TASK_OPERATION_TYPE_SELECTIVE_DELETE_ OPERATION
			SET @FS	= @@FETCH_STATUS
			WHILE @FS = 0
			BEGIN
				INSERT INTO TM_JobOptions
select @o_jobId, 38201114, 7, CAST(@scId as NVARCHAR(28)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				where @scId != 0
				union all
select @o_jobId, 140016, 7, CAST(@taskType as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				where @taskType != 0
				union all
select @o_jobId, 140017, 7, CAST(@subTaskType as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				where @subTaskType != 0
				union all
select @o_jobId, 140018, 7, CAST(@operationType as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				where @operationType != 0
				union all
select @o_jobId, 140019, 7, CAST(@i_userId as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				where @i_userId != 0
				union all
select @o_jobId, 140020, 7, CAST(@alertId as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				where @alertId != 0
				union all
select @o_jobId, 140021, 7, CAST(@ownerId as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				where @ownerId != 0
				union all
select @o_jobId, 140022, 7, CAST(@localeId as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				where @localeId != 0
				union all
select @o_jobId, 140001, 15, CAST(@i_sequenceNumber as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0	--COM_SEQUENCE_NUMBER_
				where @i_sequenceNumber != ''
				union all
select 	@o_jobId, 140026, 7, CAST(@i_taskId as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				where @i_taskId != 0
				union all
select @o_jobId, 140030, 7, CAST(@initFrom as varchar(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
				where @initFrom != 0
				SET @addTblOption = 0
				EXEC TM_InsertJobOptions @i_jobRequestId, @i_taskId, @i_subTaskId, @i_userId, @i_association, @o_jobId, @errorCode OUTPUT, @errorString OUTPUT
				IF @errorCode <> 0
					GOTO EXIT_INSERT_JOB_OPTIONS
				--CHECK FOR ASSOCIATION ENTRY BEFORE INSERTING OPTIONS
				IF (@insertEntity = 1)
				BEGIN
					EXEC TM_InsertEntitiesAsOptions @i_assocId, @i_taskId, @i_subTaskId, @i_subTaskType, @i_userId, @o_jobId, @nowTime, @operationType, 0, @errorCode OUTPUT, @errorString OUTPUT, @i_appId
					IF @errorCode <> 0
						GOTO EXIT_INSERT_JOB_OPTIONS
				END
				FETCH FROM  StartJobForSubClient INTO @scId
				SET @FS	= @@FETCH_STATUS
				--DO NOT CALCULATE AN EXTRA JOBID
				IF @FS = 0
				BEGIN
					INSERT INTO @t_JobId EXEC @o_jobId = TM_GetNextJobId
					INSERT INTO TM_Jobs ( jobId, jobRequestId, predecessor, status, timeToStart)
					VALUES( @o_jobId, @i_jobRequestId , @i_predjobId, @i_submissionStatus, @jobStaggerTime )
				END
			END
			CLOSE StartJobForSubClient
			DEALLOCATE StartJobForSubClient
		END
		--CHECK BEFORE RE-INSERTING THESE OPTIONS
IF (@addTblOption = 1 AND @operationType <> 5025)
		BEGIN
			INSERT INTO TM_JobOptions
select @o_jobId, 140016, 7, CAST(@taskType as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @taskType != 0
			union all
select @o_jobId, 140017, 7, CAST(@subTaskType as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @subTaskType != 0
			union all
select @o_jobId, 140018, 7, CAST(@operationType as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @operationType != 0
			union all
select @o_jobId, 140019, 7, CAST(@i_userId as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @i_userId != 0
			union all
select @o_jobId, 140020, 7, CAST(@alertId as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @alertId != 0
			union all
select @o_jobId, 140021, 7, CAST(@ownerId as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @ownerId != 0
			union all
select 	@o_jobId, 140022, 7, CAST(@localeId as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @localeId != 0
			union all
select @o_jobId, 140001, 15, CAST(@i_sequenceNumber as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0	--COM_SEQUENCE_NUMBER_
			where @i_sequenceNumber != ''
			union all
select @o_jobId, 140026, 7, CAST(@i_taskId as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @i_taskId != 0
			union all
select @o_jobId, 140030, 7, CAST(@initFrom as varchar(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @initFrom != 0
			union all
select @o_jobId, 140031, 7, CAST(@flags as varchar(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @flags != 0
			EXEC TM_InsertJobOptions @i_jobRequestId, @i_taskId, @i_subTaskId, @i_userId, @i_association, @o_jobId, @errorCode OUTPUT, @errorString OUTPUT
			IF @errorCode <> 0
				GOTO EXIT_INSERT_JOB_OPTIONS
			EXEC TM_InsertEntitiesAsOptions @i_assocId, @i_taskId, @i_subTaskId, @i_subTaskType, @i_userId, @o_jobId, @nowTime, @operationType, @isSubclientHierarchyOptionInserted, @errorCode OUTPUT, @errorString OUTPUT, @i_appId
			IF @errorCode <> 0
				GOTO EXIT_INSERT_JOB_OPTIONS
		END
ELSE IF (@i_jobOptionsXML IS NOT NULL AND @addTblOption = 1 AND @operationType = 5025 AND @i_subTaskType = 1)
		BEGIN
			DECLARE @EDiscoveryOptionTable TABLE (optionId BIGINT,type INT,value NVARCHAR(MAX))
			INSERT INTO @EDiscoveryOptionTable
			SELECT	ref.value('@optionId', 'BIGINT') AS optionId,
						ref.value('@type', 'INT') AS type,
						ref.value('@value', 'NVARCHAR(MAX)') AS value
					FROM @i_jobOptionsXML.nodes ('/TMMsg_RunTaskOptions/options') R(ref)
			INSERT INTO TM_JobOptions
select @o_jobId, 140016, 7, CAST(@taskType as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @taskType != 0
			union all
select @o_jobId, 140017, 7, CAST(@subTaskType as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @subTaskType != 0
			union all
select @o_jobId, 140019, 7, CAST(@i_userId as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @i_userId != 0
			union all
select @o_jobId, 140020, 7, CAST(@alertId as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @alertId != 0
			union all
select @o_jobId, 140021, 7, CAST(@ownerId as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @ownerId != 0
			union all
select 	@o_jobId, 140022, 7, CAST(@localeId as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @localeId != 0
			union all
select @o_jobId, 140001, 15, CAST(@i_sequenceNumber as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0	--COM_SEQUENCE_NUMBER_
			where @i_sequenceNumber != ''
			union all
select @o_jobId, 140026, 7, CAST(@i_taskId as NVARCHAR(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @i_taskId != 0
			union all
select @o_jobId, 140030, 7, CAST(@initFrom as varchar(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @initFrom != 0
			union all
select @o_jobId, 140031, 7, CAST(@flags as varchar(1024)), @i_taskId, @i_subTaskId, 0, @nowTime, 0
			where @flags != 0
			union all
			SELECT @o_jobId, JO.optionId, JO.type, JO.value, @i_taskId, @i_subTaskId, 0, @nowTime, 0
			FROM @EDiscoveryOptionTable JO
			EXEC TM_InsertJobOptions @i_jobRequestId, @i_taskId, @i_subTaskId, @i_userId, @i_association, @o_jobId, @errorCode OUTPUT, @errorString OUTPUT
			IF @errorCode <> 0
				GOTO EXIT_INSERT_JOB_OPTIONS
		END
	END
END TRY
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to get error information.
	IF @errorCode = 0
		EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
    --Close cursor
    IF ( CURSOR_STATUS('local', 'StartJobForSubClient') >= 0 )
		CLOSE StartJobForSubClient
	IF ( CURSOR_STATUS('local','StartJobForSubClient') = -1 )
		DEALLOCATE StartJobForSubClient
END CATCH;
EXIT_INSERT_JOB_OPTIONS:
IF object_id('tempdb.dbo.#replicationIdList') is not null
	DROP TABLE #replicationIdList
IF object_id('tempdb.dbo.#xmlOption_InfoTable') is not null
	DROP TABLE #xmlOption_InfoTable
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_InsertJobAndOptions')
	delete from GxQscripts where name = 'TM_InsertJobAndOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_InsertJobAndOptions')
	delete from GXDBVersions where aliasname = 'TM_InsertJobAndOptions'
GO

insert into GXDBVersions values(2, 'TM_InsertJobAndOptions',  'v1.81.2.48.4.4', 'TM_InsertJobAndOptions', 'v1.81.2.48.4.4')
GO

