

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_InsertEntitiesAsOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_InsertEntitiesAsOptions.sp,v $ $Id: TM_InsertEntitiesAsOptions.sp,v 1.8.60.8.4.1 2021/01/13 14:35:51 mnatarajan Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 04/25/2010
-- Description:	insert the entities as options
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_InsertEntitiesAsOptions')
BEGIN
	print '>>> Drop Stored Procedure: TM_InsertEntitiesAsOptions <<<'
	drop procedure TM_InsertEntitiesAsOptions
END
IF EXISTS (select * from GxQscripts where name='TM_InsertEntitiesAsOptions')
	delete from GxQscripts where name = 'TM_InsertEntitiesAsOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_InsertEntitiesAsOptions')
	delete from GXDBVersions where aliasname = 'TM_InsertEntitiesAsOptions'
GO
print '... Creating Procedure: TM_InsertEntitiesAsOptions'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_InsertEntitiesAsOptions
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_assocId integer,
  @i_taskId integer,
  @i_subTaskId integer,	
  @i_subTaskType integer,	
  @i_userId integer,
  @i_jobId bigint,
  @i_nowTime integer,
  @i_operationType integer,
  @i_isSubclientHierarchyOptionInserted integer,
  @errorCode integer OUTPUT,
  @errorString nvarchar(MAX) OUTPUT,
  @i_appId integer
AS
BEGIN
BEGIN TRY
	DECLARE @clientGroupId	INT = 0
	DECLARE @clientId		INT = 0
	DECLARE @appTypeId		INT = 0
	DECLARE @instanceId		INT = 0
	DECLARE @backupSetId	INT = 0
	DECLARE @subclientId	INT = 0
	DECLARE @policyId		INT = 0
	DECLARE @copyId			INT = 0
	DECLARE @trackingPolicy	INT = 0
	DECLARE @srmReportSet	INT = 0
	DECLARE @srmReportType	INT = 0
	DECLARE @mediaAgentId	INT = 0
	DECLARE @agentlessPolicyId	INT = 0
	DECLARE @agentlessPolicyName NVARCHAR(MAX) = ''
	DECLARE @userName		NVARCHAR(255) = ''
	DECLARE @workflowId		INT = 0
	--GET USER NAME
	SET @userName = (SELECT login FROM UMUsers WITH(READUNCOMMITTED) WHERE id = @i_userId)
	--GET ENTITY INFORMATION
IF ( @i_subTaskType = 2 OR @i_subTaskType = 3)
	BEGIN
		IF @i_appId > 0
				SELECT
					@clientGroupId=AE.clientGroupId,
					@clientId=APP.clientId,
					@appTypeId=APP.appTypeId,
					@instanceId=APP.instance,
					@backupSetId=APP.backupSet,
					@subclientId=APP.id, @policyId=policyId, @copyId=copyId, @srmReportSet=srmReportSet, @srmReportType=srmReportType,
					@trackingPolicy=trackingPolicyId, @mediaAgentId=MediaAgentId, @agentlessPolicyId=agentlessPolicyId, @workflowId=workflowId
					FROM TM_AssocEntity AE WITH(READUNCOMMITTED)
					LEFT OUTER JOIN APP_ClientGroupAssoc ACG WITH(NOLOCK) ON (AE.assocType = 28 AND AE.clientGroupId = ACG.clientGroupId)
					LEFT OUTER JOIN APP_Client C WITH(NOLOCK) ON (ACG.clientId = C.id OR AE.clientId = C.id )
					LEFT OUTER JOIN App_SubclientProp SCP WITH(NOLOCK) ON SCP.attrName = 'Associated Plan' AND SCP.cs_attrName = CHECKSUM(N'Associated Plan')
					AND CAST(AE.entityId AS NVARCHAR(10)) = SCP.attrVal
					AND AE.assoctype = 158-- plan entity
					AND SCP.modified = 0
					LEFT OUTER JOIN APP_Application APP WITH(NOLOCK) ON
					(
						c.id = APP.clientId
						AND (AE.appTypeId=APP.appTypeId OR AE.appTypeId = 0)
						AND (AE.instanceId =APP.instance OR AE.instanceId= 0)
						AND (AE.backupsetId = APP.backupSet OR AE.backupsetId=0)
					) OR App.ID = SCP.componentNameID
					WHERE AE.taskId = @i_taskId AND APP.id = @i_appId
		ELSE
		SELECT @clientGroupId=clientGroupId, @clientId=clientId, @appTypeId=apptypeId, @instanceId=instanceId, @backupSetId=backupsetId,
			@subclientId=subclientId, @policyId=policyId, @copyId=copyId, @srmReportSet=srmReportSet, @srmReportType=srmReportType,
			@trackingPolicy=trackingPolicyId, @mediaAgentId=MediaAgentId, @agentlessPolicyId=agentlessPolicyId, @workflowId=workflowId
			FROM TM_AssocEntity WITH(READUNCOMMITTED) WHERE taskId = @i_taskId
	END
ELSE IF ( @i_subTaskType = 1 OR @i_subTaskType = 4)
	BEGIN
		SELECT @clientGroupId=clientGroupId, @clientId=clientId, @appTypeId=apptypeId, @instanceId=instanceId, @backupSetId=backupsetId,
			@subclientId=subclientId, @policyId=policyId, @copyId=copyId, @srmReportSet=srmReportSet, @srmReportType=srmReportType,
			@trackingPolicy=trackingPolicyId,  @mediaAgentId=MediaAgentId, @agentlessPolicyId = agentlessPolicyId, @workflowId = workflowId
			FROM TM_AssocEntity WITH(READUNCOMMITTED) WHERE taskId = @i_taskId AND assocId = @i_assocId
	END
	IF @clientId = 0
		SET @clientId = 2
	declare @allocationPolicyId int = 0
    -- Check whether this schedule is using allocation policy and if so, then populate destination clientId option
    declare @isScheduleUsingAllocationPolicy int = 0
    select @isScheduleUsingAllocationPolicy = 1 from TM_Subtaskoptions with (nolock)
    where TM_Subtaskoptions.subtaskId=@i_subTaskId
and TM_Subtaskoptions.optionId=1264497636
    and TM_Subtaskoptions.value='1'
	IF ( @isScheduleUsingAllocationPolicy = 1 )
        BEGIN
		select @allocationPolicyId = value from TM_Subtaskoptions with (nolock)
		where TM_Subtaskoptions.subtaskId=@i_subTaskId
and TM_Subtaskoptions.optionId=1008442949
	END
	--INSERT THE ENTITY INFO AS OPTION
	IF @clientGroupId != 0
INSERT INTO TM_JobOptions VALUES ( @i_jobId, 140002, 7, CAST(@clientGroupId as varchar(28)), @i_taskId, @i_subTaskId, 0, @i_nowTime, 0)
	-- For live sync jobs using allocation policy com_client_id is inserted in tm_insertjobandoptions. So dont insert here again.
	IF (@clientId != 0 and (@allocationPolicyId is null OR @allocationPolicyId=0 or @i_operationType <> 1007) AND @i_isSubclientHierarchyOptionInserted = 0) --insert clientId for job other than operationType 1007
	begin
INSERT INTO TM_JobOptions VALUES ( @i_jobId, 140003, 7, CAST(@clientId as varchar(28)), @i_taskId, @i_subTaskId, 0, @i_nowTime, 0)
	end
	IF ( @appTypeId != 0 and (@allocationPolicyId is null OR @allocationPolicyId=0 or @i_operationType <> 1007) AND @i_isSubclientHierarchyOptionInserted = 0)
INSERT INTO TM_JobOptions VALUES ( @i_jobId, 140004, 7, CAST(@appTypeId as varchar(28)), @i_taskId, @i_subTaskId, 0, @i_nowTime, 0)
	IF (@instanceId != 0 and (@allocationPolicyId is null OR @allocationPolicyId=0 or @i_operationType <> 1007) AND @i_isSubclientHierarchyOptionInserted = 0 )
INSERT INTO TM_JobOptions VALUES ( @i_jobId, 140005, 7, CAST(@instanceId as varchar(28)), @i_taskId, @i_subTaskId, 0, @i_nowTime, 0)
	IF (@backupSetId != 0 and (@allocationPolicyId is null OR @allocationPolicyId=0 or @i_operationType <> 1007) AND @i_isSubclientHierarchyOptionInserted = 0)
INSERT INTO TM_JobOptions VALUES ( @i_jobId, 140006, 7, CAST(@backupSetId as varchar(28)), @i_taskId, @i_subTaskId, 0, @i_nowTime, 0)
IF (@subclientId != 0 AND @i_subTaskType <> 2 and (@allocationPolicyId is null OR @allocationPolicyId=0 or @i_operationType <> 1007) AND @i_isSubclientHierarchyOptionInserted = 0 )
INSERT INTO TM_JobOptions VALUES ( @i_jobId, 140007, 7, CAST(@subclientId as varchar(28)), @i_taskId, @i_subTaskId, 0,  @i_nowTime, 0)
	IF @policyId != 0
INSERT INTO TM_JobOptions VALUES ( @i_jobId, 140008, 7, CAST(@policyId as varchar(28)), @i_taskId, @i_subTaskId, 0, @i_nowTime, 0)
	IF @copyId != 0
INSERT INTO TM_JobOptions VALUES ( @i_jobId, 140009, 7, CAST(@copyId as varchar(28)), @i_taskId, @i_subTaskId, 0, @i_nowTime, 0)
	IF @srmReportSet != 0
INSERT INTO TM_JobOptions VALUES ( @i_jobId, 140010, 7, CAST(@srmReportSet as varchar(28)), @i_taskId, @i_subTaskId, 0, @i_nowTime, 0)
	IF @srmReportType != 0
INSERT INTO TM_JobOptions VALUES ( @i_jobId, 140011, 7, CAST(@srmReportType as varchar(28)), @i_taskId, @i_subTaskId, 0, @i_nowTime, 0)
	IF @userName != ''
INSERT INTO TM_JobOptions VALUES ( @i_jobId, 120008, 1, @userName, @i_taskId, @i_subTaskId, 0, @i_nowTime, 0)
	IF @mediaAgentId != 0
INSERT INTO TM_JobOptions VALUES ( @i_jobId, 140013, 7, CAST(@mediaAgentId as varchar(28)), @i_taskId, @i_subTaskId, 0, @i_nowTime, 0)
	IF @agentlessPolicyId != 0
INSERT INTO TM_JobOptions VALUES ( @i_jobId, 140024, 7, CAST(@agentlessPolicyId as varchar(28)), @i_taskId, @i_subTaskId, 0, @i_nowTime, 0)
	IF @workflowId != 0
INSERT INTO TM_JobOptions VALUES ( @i_jobId, 140034, 7, CAST(@workflowId as varchar(28)), @i_taskId, @i_subTaskId, 0, @i_nowTime, 0)
INSERT INTO TM_JobOptions VALUES ( @i_jobId, 140028, 7, CAST(@i_subTaskId as varchar(28)), @i_taskId, @i_subTaskId, 0, @i_nowTime, 0)
	IF (@agentlessPolicyId IS NOT null AND @agentlessPolicyId > 0)
	BEGIN
		SET @agentlessPolicyName = (SELECT taskName FROM TM_Task WITH(READUNCOMMITTED) WHERE taskId = @agentlessPolicyId)
INSERT INTO TM_JobOptions VALUES ( @i_jobId, 140025, 1, @agentlessPolicyName, @i_taskId, @i_subTaskId, 0, @i_nowTime, 0)
	END
IF (@i_operationType = 4036)
	BEGIN
		MERGE TM_JobOptions AS JO
		USING (SELECT SIDBStoreId FROM archGroupCopy WHERE id = @copyId) AS TMP
ON (jobId=@i_jobId AND subTaskId = @i_subTaskId AND optionId=1777365717)
		--WHEN MATCHED THEN
		--	UPDATE SET JO.value = CAST(TMP.SIDBStoreId as varchar(28))
		WHEN NOT MATCHED THEN
INSERT VALUES( @i_jobId, 1777365717, 7, CAST(TMP.SIDBStoreId as varchar(28)), @i_taskId, @i_subTaskId, 0, @i_nowTime, 0);
	END
END TRY
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to get error information.
    EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
END CATCH;
EXIT_INSERT_JOB_OPTIONS:
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_InsertEntitiesAsOptions')
	delete from GxQscripts where name = 'TM_InsertEntitiesAsOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_InsertEntitiesAsOptions')
	delete from GXDBVersions where aliasname = 'TM_InsertEntitiesAsOptions'
GO

insert into GXDBVersions values(2, 'TM_InsertEntitiesAsOptions',  'v1.8.60.8.4.1', 'TM_InsertEntitiesAsOptions', 'v1.8.60.8.4.1')
GO

