

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_IncrementMonthByPattern.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_IncrementMonthByPattern.sp,v $ $Id: TM_IncrementMonthByPattern.sp,v 1.2 2006/04/24 22:38:09 gbuilder Exp $";
-- =============================================
-- Author:		Anand Vibhor
-- Create date: 01/28/2006
-- Description:	Check if the new time fall in the weekly exception
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_IncrementMonthByPattern <<<'

IF EXISTS (select * from sysobjects where name='TM_IncrementMonthByPattern')
	drop procedure TM_IncrementMonthByPattern
IF EXISTS (select * from GxQscripts where name='TM_IncrementMonthByPattern')
	delete from GxQscripts where name = 'TM_IncrementMonthByPattern'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_IncrementMonthByPattern')
	delete from GXDBVersions where aliasname = 'TM_IncrementMonthByPattern'
GO
print '... Creating Procedure: TM_IncrementMonthByPattern'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_IncrementMonthByPattern
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @year integer,
  @month integer,
  @calId integer,
  @freq_relative_interval integer,
  @freq_interval integer,
  @nextRunUTCTime integer OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
DECLARE @nextRunTime as DATETIME
SET @nextRunUTCTime = 0 --INITIALIZE
    IF(@freq_relative_interval = 0)
		RETURN 0	--RETURN NO EXCEPTION WAS DEFINED
    ELSE IF(@freq_relative_interval = 5)	--LAST OCCURENCE
	BEGIN
		--WEEKDAY
		IF(@freq_interval = 9)
		BEGIN
			SET @nextRunTime = dbo.getLastWeekDay(@year, @month, @calId)
		END
        --WEEKEND
		ELSE IF(@freq_interval = 10)
		BEGIN
			SET @nextRunTime = dbo.getLastWeekend(@year, @month, @calId)
		END
		--DAY
		ELSE IF(@freq_interval = 8)
		BEGIN
			SET @nextRunTime = dbo.getEndDay(@year, @month, @calId)
		END
        --ANY DAY ( SUN, ... SAT)
		ELSE
		BEGIN
			SET @nextRunTime = dbo.GetLastWeekDayOfMonth(@freq_interval, @year, @month, @calId)
		END
	END
	ELSE --FIRST, SECOND , THIRD OR FORTH
	BEGIN
		--WEEKDAY
		IF(@freq_interval = 9)
		BEGIN
			SET @nextRunTime = dbo.getNthWeekDay(@freq_relative_interval, @year, @month, @calId)
		END
        --WEEKEND
		ELSE IF(@freq_interval = 10)
		BEGIN
			SET @nextRunTime = dbo.getNthWeekendDay(@freq_relative_interval, @year, @month, @calId)
		END
		--DAY
		ELSE IF(@freq_interval = 8)
		BEGIN
			SET @nextRunTime = dbo.getDay(@freq_relative_interval, 0, 0, @year, @month, @calId)
		END
        --ANY DAY (SUN, .., SAT)
		ELSE
		BEGIN
			SET @nextRunTime = dbo.getDay(0, @freq_relative_interval, @freq_interval, @year, @month, @calId)
		END
	END
SET NOCOUNT OFF
SET @nextRunUTCTime = dbo.getUnixTime(@nextRunTime)
RETURN 0
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_IncrementMonthByPattern')
	delete from GxQscripts where name = 'TM_IncrementMonthByPattern'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_IncrementMonthByPattern')
	delete from GXDBVersions where aliasname = 'TM_IncrementMonthByPattern'
GO

insert into GXDBVersions values(2, 'TM_IncrementMonthByPattern',  '00010002000000000000', 'TM_IncrementMonthByPattern', '00010002000000000000')
GO

