

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_IncrementMonthByCustomCal.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_IncrementMonthByCustomCal.sp,v $ $Id: TM_IncrementMonthByCustomCal.sp,v 1.1 2006/04/20 18:23:48 avibhor Exp $";
-- =============================================
-- Author:		Anand Vibhor
-- Create date: 01/28/2006
-- Description:	Check if the new time fall in the weekly exception
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_IncrementMonthByCustomCal <<<'

IF EXISTS (select * from sysobjects where name='TM_IncrementMonthByCustomCal')
	drop procedure TM_IncrementMonthByCustomCal
IF EXISTS (select * from GxQscripts where name='TM_IncrementMonthByCustomCal')
	delete from GxQscripts where name = 'TM_IncrementMonthByCustomCal'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_IncrementMonthByCustomCal')
	delete from GXDBVersions where aliasname = 'TM_IncrementMonthByCustomCal'
GO
print '... Creating Procedure: TM_IncrementMonthByCustomCal'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_IncrementMonthByCustomCal
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @lastRunTime integer,
  @calId integer,
  @incrCount integer,
  @nextRunTime integer OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
DECLARE @year int
DECLARE @month int
DECLARE @totalMonth int
--INITIALIZE
SET @nextRunTime = @lastRunTime
--VERIFY THE INPUT
IF (@incrCount < 1)
	RETURN 0
--EXEC THE SP TO GET THE START DAY , MONTH AND YEAR
EXEC GetYearMonthOfDay @lastRunTime, @calId ,@month OUTPUT, @year OUTPUT
--INCREMENT THE MONTH
SET @totalMonth = @year * 12 + @month + @incrCount
SET @month = @totalMonth % 12
SET @year =  @totalMonth / 12
--CHECK FOR ROLLOVER IT'S LAST MONTH
IF ( @month = 0)
BEGIN
	SET @year = @year -1
	SET @month = 12
END
--RETURN THE NEW TIME BASED ON MONTH, YEAR AND CALENDAR
SET @nextRunTime =  dbo.getUnixTime(dbo.getStartDay(@year, @month,@calId))
SET NOCOUNT OFF
RETURN 0
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_IncrementMonthByCustomCal')
	delete from GxQscripts where name = 'TM_IncrementMonthByCustomCal'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_IncrementMonthByCustomCal')
	delete from GXDBVersions where aliasname = 'TM_IncrementMonthByCustomCal'
GO

insert into GXDBVersions values(2, 'TM_IncrementMonthByCustomCal',  '00010001000000000000', 'TM_IncrementMonthByCustomCal', '00010001000000000000')
GO

