

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_HasOSCTask.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_HasOSCTask.sp,v $ $Id: TM_HasOSCTask.sp,v 1.2.178.1.112.1 2021/01/13 14:35:39 mnatarajan Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 02/14/2012
-- Description:	Get the list of OSC schedules.
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_HasOSCTask')
BEGIN
	print '>>> Drop Stored Procedure: TM_HasOSCTask <<<'
	drop procedure TM_HasOSCTask
END
IF EXISTS (select * from GxQscripts where name='TM_HasOSCTask')
	delete from GxQscripts where name = 'TM_HasOSCTask'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_HasOSCTask')
	delete from GXDBVersions where aliasname = 'TM_HasOSCTask'
GO
print '... Creating Procedure: TM_HasOSCTask'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_HasOSCTask
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userId integer,
  @localeId_in integer,
  @clientId integer,
  @upgradeOnly integer
AS
  DECLARE @noTasks integer
BEGIN
SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--
	SELECT COUNT(TA.taskId) AS [noTasks]
	FROM    TM_Task TA WITH (NOLOCK)
			LEFT OUTER JOIN dbo.TM_Associations TE (NOLOCK) ON TA.taskId = TE.taskId
			INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = TA.taskId
			INNER JOIN TM_PatternAssoc PA WITH (NOLOCK) ON PA.subTaskId = SA.subTaskId
			INNER JOIN TM_Pattern P WITH (NOLOCK) ON P.patternId = PA.patternId
LEFT OUTER JOIN TM_SubTaskOptions SO WITH (NOLOCK) ON SO.subTaskId = SA.subTaskId AND optionId = 967538445
WHERE P.freq_type=1024
			AND
			(
				(	--UDATE SCHEDULES ONLY
SA.subTaskType = 1 AND SA.operationType=4020 AND SA.subTaskId IN
					(
						SELECT subTaskId FROM
						TM_subTaskOptions WITH (NOLOCK)
						WHERE
( optionId = 239177580 AND
							(
								(CAST(value AS XML).exist('/clientAndClientGroups/@clientId')=1 AND CAST(value AS XML).value('(/clientAndClientGroups/@clientId)[1]', 'INT') = @clientId)
								OR
								( CAST(value AS XML).exist('/clientAndClientGroups/@clientGroupId')=1 AND CAST(value AS XML).value('(/clientAndClientGroups/@clientGroupId)[1]', 'INT') IN (
										SELECT  clientGroupId
										FROM    APP_ClientGroupAssoc CG WITH (NOLOCK)
										WHERE   clientId = @clientId )
								)
								OR CAST(value AS XML).exist('/clientAndClientGroups/@_type_[.="2"]')=1
							)
						)
					)
				)
				OR	--BACKUP SCHEDULES
				(
SA.subTaskType = 2
					AND
					(
						TE.clientId = @clientId
						OR TE.clientGroupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE clientId = @clientId AND exclude=0)
					)
				)
			)
			AND TA.[deleted] = 0
			AND TA.[invalid] = 0
			AND TA.[uninstalled] = 0
			AND TA.[savedReport] = 0
			AND TA.[disabled] = 0
AND TA.[taskType] IN ( 2, 4 )
AND ((SA.operationType = 4020 AND @upgradeOnly = 1 AND SO.value = '1') OR @upgradeOnly = 0)
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_HasOSCTask')
	delete from GxQscripts where name = 'TM_HasOSCTask'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_HasOSCTask')
	delete from GXDBVersions where aliasname = 'TM_HasOSCTask'
GO

insert into GXDBVersions values(2, 'TM_HasOSCTask',  'v1.2.178.1.112.1', 'TM_HasOSCTask', 'v1.2.178.1.112.1')
GO

