

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetXMLJobOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetXMLJobOptions.sp,v $ $Id: TM_GetXMLJobOptions.sp,v 1.8 2012/09/05 19:19:36 sbonilla Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 08/15/2009
-- Description:	Wrapper for GetXMLJobOptions
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_GetXMLJobOptions <<<'

IF EXISTS (select * from sysobjects where name='TM_GetXMLJobOptions')
	drop procedure TM_GetXMLJobOptions
IF EXISTS (select * from GxQscripts where name='TM_GetXMLJobOptions')
	delete from GxQscripts where name = 'TM_GetXMLJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetXMLJobOptions')
	delete from GXDBVersions where aliasname = 'TM_GetXMLJobOptions'
GO
print '... Creating Procedure: TM_GetXMLJobOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_GetXMLJobOptions
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @jobId bigint
AS
  DECLARE @xmlValue XML
BEGIN
	DECLARE @taskId		INT
	DECLARE @subTaskId	INT
	DECLARE @refTime	INT
	SELECT TOP 1 @taskId=[taskId], @subTaskId=[subTaskId], @refTime=[created] FROM TM_JobRequest WITH (READUNCOMMITTED) WHERE jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WITH (READUNCOMMITTED) WHERE [jobId]=@jobId)
	--GET THE LIST OF OPTION VALUES FROM THE TM_JOBXMLOPTIONS TABLE
	SELECT xmlValue AS Column1  FROM TM_JobXMLOptions WITH (READUNCOMMITTED) WHERE (jobId=@jobId)
	UNION ALL	--ONLY ONE QUERY WILL RETURN OUTPUT BUT UNION ALL IS NEEDED BECAUSE XML CANNOT BE DISTINCT
	SELECT xmlValue AS Column1 FROM TM_JobXMLOptions AS TJ WITH (READUNCOMMITTED) WHERE (
			(jobId=0 AND subTaskId=@subTaskId AND created <= @refTime AND (modified=0 OR modified > @refTime))
		) AND
		NOT EXISTS(SELECT * FROM TM_JobXMLOptions AS LT WITH (READUNCOMMITTED) WHERE (jobId=@jobId))
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetXMLJobOptions')
	delete from GxQscripts where name = 'TM_GetXMLJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetXMLJobOptions')
	delete from GXDBVersions where aliasname = 'TM_GetXMLJobOptions'
GO

insert into GXDBVersions values(2, 'TM_GetXMLJobOptions',  '00010008000000000000', 'TM_GetXMLJobOptions', '00010008000000000000')
GO

