

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetVSAJobCompletedPatterns.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetVSAJobCompletedPatterns.sp,v $ $Id: TM_GetVSAJobCompletedPatterns.sp,v 1.1.2.63.16.1 2021/03/07 07:47:08 mnatarajan Exp $";
---- ==============================================================================================
---- Author:		Sergio Bonilla
---- Create date:	05/10/2014
---- Description:	Get the information to start a Job Completed schedule for VSA replication.
----				Moved code from TM_GetJobCompletedPatterns
---- ==============================================================================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_GetVSAJobCompletedPatterns')
BEGIN
	print '>>> Drop Stored Procedure: TM_GetVSAJobCompletedPatterns <<<'
	drop procedure TM_GetVSAJobCompletedPatterns
END
IF EXISTS (select * from GxQscripts where name='TM_GetVSAJobCompletedPatterns')
	delete from GxQscripts where name = 'TM_GetVSAJobCompletedPatterns'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetVSAJobCompletedPatterns')
	delete from GXDBVersions where aliasname = 'TM_GetVSAJobCompletedPatterns'
GO
print '... Creating Procedure: TM_GetVSAJobCompletedPatterns'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_GetVSAJobCompletedPatterns
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @oErrorCode integer OUTPUT,
  @oErrorString nvarchar(MAX) OUTPUT
AS
SET NOCOUNT ON
BEGIN
	DECLARE @nowTime DATETIME = GETDATE()
	DECLARE @nowUtcTime DATETIME = GETUTCDATE()
	DECLARE @nowUtcUnix INT = datediff(second, '01/01/1970', @nowUtcTime)
	DECLARE @runTimeId INT = 0
	DECLARE @nowTimeUnix INT = datediff(second, '01/01/1970', @nowTime)
DECLARE @timeZoneName NVARCHAR(1024) = ISNULL((SELECT dbo.GetClientTimeZone(2)), '')
DECLARE @startSyntheticFullAfterOSC INT = ISNULL((SELECT CAST(value AS NVARCHAR(1024)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='startSyntheticFullAfterOSC'), 1)
DECLARE @minutesToCheckForAutoSyntheticFulls INT = ISNULL((SELECT CAST(value AS NVARCHAR(1024)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='minutesToCheckForAutoSyntheticFulls'), 30)
	DECLARE @runTimeTable table (runTimeId INT, patternId INT)
DECLARE @logChanges INT = ISNULL((SELECT CAST(value AS NVARCHAR(1024)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='logVSAReplicationChanges'), 1)
DECLARE @disableVMRevertReplication INT = ISNULL((SELECT CAST(value AS NVARCHAR(1024)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='disableVMRevertReplication'), 0)
DECLARE @runIndividualReplicationForVMV2 INT = ISNULL((SELECT CAST(value AS NVARCHAR(1024)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='RunIndividualReplicationForVMV2' AND Modified = 0), 0) -- In minutes. Convert it to seconds below.
	DECLARE @intervalBetweenV2JobsSecs INT = 0
	IF @runIndividualReplicationForVMV2 = 0
	BEGIN
SELECT @intervalBetweenV2JobsSecs = ISNULL((SELECT CAST(value AS NVARCHAR(1024)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='IntervalBetweenV2ReplicationJobs' AND Modified = 0), 15) -- In minutes. Convert it to seconds below.
	END
	-- have above as 0 to not have any effect.
	DECLARE @VSAREP_COMPLETE INT = 1
	DECLARE @VSAREP_PENDING INT = 2
	DECLARE @VSAREP_RUNNING INT = 3
	DECLARE @VSAREP_PAUSED INT = 4
	DECLARE @VSAREP_FAILED INT = 5
	DECLARE @VSAREP_DISABLED INT = 6
	DECLARE @VSAREP_ENABLED INT = 7
	DECLARE @VSAREP_VALIDATION_FAILED INT = 8
	DECLARE @VSAREP_JOB_QUEUED INT = 9
	DECLARE @VSAREP_REVERT_FAILED INT = 10
	DECLARE @VSAREP_STARTING INT = 11
	--JM STATUS
	DECLARE @STATE_RUNNING INT = 1
	DECLARE @STATE_COMPLETE INT = 2
	DECLARE @STATE_PENDING INT = 3
	--FLAG VALUES
	DECLARE @VSAREP_DELETED INT = 1
	DECLARE @STARTED_SYNC_IMMEDIATE INT = 2
	DECLARE @VSAREP_REVERSE_REP INT = 4
	SET @oErrorCode = 0
	SET @oErrorString = ''
	SET @intervalBetweenV2JobsSecs = @intervalBetweenV2JobsSecs*60 -- Convert it into Seconds
	IF object_id('tempdb.dbo.#completedPattern_initVsaInfoTable') is not null
		DROP TABLE #completedPattern_initVsaInfoTable
	CREATE TABLE #completedPattern_initVsaInfoTable
(stId INT, tkId INT, repGuid VARCHAR(100), sourceGuid VARCHAR(100), sourceName NVARCHAR(2048), destinationName NVARCHAR(2048), patId INT, cgId INT, clId INT, apId INT, instId INT,
				bsId INT, scId INT, opType INT, copyPrecedenceApplicable INT, copyPrecedence INT, freq_type INT, tkDisabled INT, maxNumOfVMPerJob INT, isScheduleUsingAllocationPolicy INT DEFAULT 0, isIndexingV2Enabled INT DEFAULT 0)
	CREATE CLUSTERED INDEX completedPattern_initVsaInfoTable_tkId_repGuid_sourceGuid_Index1 ON #completedPattern_initVsaInfoTable ([tkId], [repGuid], [sourceGuid])
	IF object_id('tempdb.dbo.#completedPattern_vmInfoTable') is not null
		DROP TABLE #completedPattern_vmInfoTable
	CREATE TABLE #completedPattern_vmInfoTable
(stId INT, tkId INT, repGuid VARCHAR(100), sourceGuid VARCHAR(100), sourceName NVARCHAR(2048), destinationName NVARCHAR(2048), patId INT, cgId INT, clId INT, apId INT, instId INT,
				bsId INT, scId INT, opType INT, copyPrecedenceApplicable INT, copyPrecedence INT, freq_type INT, tkDisabled INT, maxNumOfVMPerJob INT, jobId INT, clientId INT, isScheduleUsingAllocationPolicy INT DEFAULT 0, isIndexingV2Enabled INT DEFAULT 0)
	CREATE CLUSTERED INDEX completedPattern_vmInfoTable_tkId_repGuid_sourceGuid_Index1 ON #completedPattern_vmInfoTable ([tkId], [repGuid], [sourceGuid])
	CREATE NONCLUSTERED INDEX #completedPattern_vmInfoTable_apId_opType_jobId_clientId_Index ON #completedPattern_vmInfoTable ([apId],[opType],[jobId],[clientId])
		INCLUDE ([stId],[tkId],[repGuid],[sourceGuid],[sourceName],[destinationName],[patId],[cgId],[clId],[instId],[bsId],[copyPrecedenceApplicable],[copyPrecedence],[freq_type],[tkDisabled],[maxNumOfVMPerJob])
	IF object_id('tempdb.dbo.#completedPattern_VsaInfoTable') is not null
		DROP TABLE #completedPattern_VsaInfoTable
	CREATE TABLE #completedPattern_VsaInfoTable
(stId INT, tkId INT, repGuid VARCHAR(100), sourceGuid VARCHAR(100), sourceName NVARCHAR(2048), destinationName NVARCHAR(2048), patId INT, cgId INT, clId INT, apId INT, instId INT,
				bsId INT, scId INT, lastSuccessBkupTime INT, opType INT, jId BIGINT, vsaJobId BIGINT default 0, copyPrecedenceApplicable INT, copyPrecedence INT, freq_type INT, tkDisabled INT, lastSyncedBkpJob INT default 0,
status INT default 0, bkpJobsToSync VARCHAR(1024) default '', replicationId INT default 0, lastVSATime INT default 0, maxNumOfVMPerJob INT, lastScheduleRunTime INT default 0, flags INT default 0,
                spare2 INT default 0, maxcopyTime INT DEFAULT 0, isIndexingV2Enabled INT DEFAULT 0, isScheduleUsingAllocationPolicy INT DEFAULT 0, scIdForDistribute INT DEFAULT 0, destClientID INT DEFAULT 0)
	CREATE CLUSTERED INDEX completedPattern_VsaInfoTable_tkId_repGuid_sourceGuid_replicationId_Index1 ON #completedPattern_VsaInfoTable ([tkId], [repGuid], [sourceGuid], [replicationId])
	IF object_id('tempdb.dbo.#completedPattern_runTimeInfoTable') is not null
		DROP TABLE #completedPattern_runTimeInfoTable
	CREATE TABLE #completedPattern_runTimeInfoTable (stId INT, taskId INT, patId INT, cgId INT, clId INT, apId INT, instId INT, bsId INT, scId INT, lastSuccessBkupTime INT DEFAULT 0, opType INT, freq_type INT,
				tkDisabled INT, status INT DEFAULT 0, maxNumOfVMPerJob INT DEFAULT 0, copyPrecedenceApplicable INT DEFAULT 0, copyPrecedence INT DEFAULT 0, isScheduleUsingAllocationPolicy INT DEFAULT 0)
	CREATE CLUSTERED INDEX #completedPattern_runTimeInfoTable_taskId_stId_Index1 ON #completedPattern_runTimeInfoTable ([taskId], [stId])
	IF object_id('tempdb.dbo.#completedPattern_InfoTable') is not null
		DROP TABLE #completedPattern_InfoTable
	CREATE TABLE #completedPattern_InfoTable
(stId INT, tkId INT, patId INT, nextTime INT, opType INT, freq_type INT, optionId BIGINT, value NVARCHAR(1024))
	CREATE CLUSTERED INDEX completedPattern_InfoTable_tkId_Index1 ON #completedPattern_InfoTable ([tkId])
	IF object_id('tempdb.dbo.#output_VsaInfoTable') is not null
		DROP TABLE #output_VsaInfoTable
	CREATE TABLE #output_VsaInfoTable
				(replicationId INT, tkId INT, repGuid VARCHAR(100), sourceGuid VARCHAR(100), statusIn INT, spare2In INT, spare3In INT, lastBackupTimeIn INT, bkpJobsToSyncIn VARCHAR(1024), action NVARCHAR(100), statusOut INT, spare2Out INT, spare3Out INT, lastBackupTimeOut INT, bkpJobsToSyncOut VARCHAR(1024) , time DATETIME)
	CREATE CLUSTERED INDEX output_VsaInfoTable_replicationId_Index1 ON #output_VsaInfoTable ([replicationId])
	IF object_id('tempdb.dbo.#auxCopyTable') is not null
		DROP TABLE #auxCopyTable
	CREATE TABLE #auxCopyTable
				(subTaskId INT, subclientId INT, archGrpId INT, archGrpCopy INT, maxCopiedTime INT, maxJobEndTime INT, fullcycleNumFullBackup INT DEFAULT 0)
	CREATE CLUSTERED INDEX auxCopyTable_subclientId_Index1 ON #auxCopyTable ([subclientId])
	IF object_id('tempdb.dbo.#fullCycleInfo ') is not null
		DROP TABLE #fullCycleInfo
	CREATE TABLE #fullCycleInfo(subTaskId INT, subclientId INT, archGrpId INT, archGrpCopyId INT, fullCycleNum INT, copyPrecedence INT, backupLevel INT)
	CREATE CLUSTERED INDEX fullCycleInfo_subTaskId_subclientId_Idx ON #fullCycleInfo(subTaskId, subclientId)
	IF object_id('tempdb.dbo.#xmlOption_InfoTable') is not null
		DROP TABLE #xmlOption_InfoTable
	CREATE TABLE #xmlOption_InfoTable
				(stId INT, taskId INT, jobId INT, servEndTime INT DEFAULT 0, xmlValue XML, state INT DEFAULT 0, status INT DEFAULT 0)
	CREATE CLUSTERED INDEX xmlOption_InfoTable_stId_jobId_Index1 ON #xmlOption_InfoTable (stId, jobId)
	IF object_id('tempdb.dbo.#xmltoTimeOption_InfoTable') is not null
		DROP TABLE #xmltoTimeOption_InfoTable
	CREATE TABLE #xmltoTimeOption_InfoTable
				(repId INT, stId INT, taskId INT, jobId INT, xmlValue XML, state INT DEFAULT 0, status INT DEFAULT 0)
	CREATE CLUSTERED INDEX xmltoTimeOption_InfoTable_repId_stId_Index1 ON #xmltoTimeOption_InfoTable (repId, stId)
	IF object_id('tempdb.dbo.#toTime_InfoTable') is not null
		DROP TABLE #toTime_InfoTable
	CREATE TABLE #toTime_InfoTable
				(repId INT, toTime INT DEFAULT 0)
	CREATE CLUSTERED INDEX toTime_InfoTable_repId_Index1 ON #toTime_InfoTable (repId)
--
	INSERT INTO #completedPattern_runTimeInfoTable
	(stId, taskId, patId, cgId, clId, apId, instId, bsId, scId, opType, freq_type, tkDisabled)
	SELECT ST.subTaskId, ST.taskId, PT.patternId, AE.clientGroupId, AE.clientId, AE.apptypeId, AE.instanceId, AE.backupsetId, AE.subclientId, ST.operationType, PT.freq_type, T.disabled
	FROM TM_SubTask ST WITH (NOLOCK)
	JOIN TM_PatternAssoc PA WITH (NOLOCK) ON PA.subTaskId = ST.subTaskId
	JOIN TM_Pattern PT WITH (NOLOCK) ON PT.patternId = PA.patternId --AND PT.freq_type IN (FREQ_TYPE_Automatic_Schedule, FREQ_TYPE_After_Job_Completes)
	JOIN TM_AssocEntity AE WITH (NOLOCK) ON AE.taskId = ST.taskId
	JOIN TM_Task T WITH (NOLOCK) ON T.taskId = ST.taskId
	WHERE T.deleted = 0
	--AND T.disabled = 0  --UPDATE STATUS OF DISABLED SCHEDULES
AND AE.apptypeId = 106
AND ST.operationType = 1007
	SET @oErrorString = 'Failed after completing step 1'
	IF EXISTS(SELECT * FROM #completedPattern_runTimeInfoTable)
	BEGIN
		--REMOVE ANY RUNTIME WHICH ARE BEING PROCESSED
		DELETE #completedPattern_runTimeInfoTable
		FROM #completedPattern_runTimeInfoTable VT
		JOIN TM_RunTime R (NOLOCK) ON R.patternId = VT.patId
		--REMOVE ANY SCHEDULES WHICH RUN TIME HAS BEEN MARKED PROCESSED BUT RUN TIME ASSOC IS NOT MARKED PROCESSED. In case there is any exception in processing then runtime is marked processed but runtime assoc is marked processed. So when backup runs, this admin SP ends up
		-- inserting into runtime assoc again.
		JOIN TM_RunTimeAssoc RA (NOLOCK) ON RA.runtimeId = R.runtimeId
		WHERE (R.processed = 0 OR RA.processed = 0)
AND VT.freq_type = 4096
IF EXISTS (SELECT 1 FROM #completedPattern_runTimeInfoTable WHERE apId = 106 AND opType = 1007)
		BEGIN
			-- Check whether schedules use allocationPolicy or not.
			-- RESTOREOPTION_USE_ALLOCATION_POLICY_FOR_RESTORE
			Update completedPattern_runTimeInfoTable
			set isScheduleUsingAllocationPolicy=1
			from #completedPattern_runTimeInfoTable completedPattern_runTimeInfoTable
			inner join TM_Subtaskoptions with (nolock) on completedPattern_runTimeInfoTable.stId=TM_Subtaskoptions.subtaskId
and TM_Subtaskoptions.optionId=1264497636
			and TM_Subtaskoptions.value='1'
			-- Update copy precedence for allocation policy schedules from copyPrecedence fields. In case allocation policy schedule has copyPrecedence specified and not Storagepolicy/copy.
			UPDATE completedPattern_runTimeInfoTable
			SET copyPrecedence=CONVERT(INT,TM_Subtaskoptions.value)
			from #completedPattern_runTimeInfoTable completedPattern_runTimeInfoTable
			INNER JOIN TM_Subtaskoptions with (nolock) on completedPattern_runTimeInfoTable.stId=TM_Subtaskoptions.subtaskId
and TM_Subtaskoptions.optionId=957862300
			and isScheduleUsingAllocationPolicy=1
			-- Update copyPrecedence for allocation policy schedules.
			Update completedPattern_runTimeInfoTable
			set copyPrecedence=ArchGroupcopy.copy
			from #completedPattern_runTimeInfoTable completedPattern_runTimeInfoTable
			inner join TM_Subtaskoptions with (nolock) on completedPattern_runTimeInfoTable.stId=TM_Subtaskoptions.subtaskId
and TM_Subtaskoptions.optionId=1019965049
			inner join ArchGroupcopy on TM_Subtaskoptions.value=convert(nvarchar(max),ArchGroupcopy.id)
			and isScheduleUsingAllocationPolicy=1
			Update completedPattern_runTimeInfoTable
			set copyPrecedenceApplicable=1
			from #completedPattern_runTimeInfoTable completedPattern_runTimeInfoTable
			where isScheduleUsingAllocationPolicy=1 and copyPrecedence>1
			IF object_id('tempdb.dbo.#subclientListTbl') is not null
				DROP TABLE #subclientListTbl
			CREATE TABLE #subclientListTbl(subclientId int primary key(subclientId) )
			IF object_id('tempdb.dbo.#taskReplicationguidPair') is not null
				DROP TABLE #taskReplicationguidPair
			CREATE TABLE #taskReplicationguidPair
			(
				taskId int,
				replicationGuid nvarchar(256)
				primary key(taskId) )
			Insert into #subclientListTbl
			select distinct scId from #completedPattern_runTimeInfoTable
			where isScheduleUsingAllocationPolicy=1
			Insert into #taskReplicationguidPair(taskId,replicationGuid)
			select distinct taskId,'' from #completedPattern_runTimeInfoTable
			where isScheduleUsingAllocationPolicy=1
			update taskReplicationguidPair
			set replicationGuid=App_VSAReplication.replicationGuid
			from #taskReplicationguidPair taskReplicationguidPair inner join App_VSAReplication with (nolock) on
			taskReplicationguidPair.taskId=App_VSAReplication.taskId
			update #taskReplicationguidPair
			set replicationGuid=newid()
			where replicationGuid is null or len(replicationGuid)=0
			-------------------------------------------------------------------------------------------------------------------------------------------
--- CODE BELOW HERE IS FROM TM_GetVMSubclientContent.spb  ----------
-- in order to use variables to be declared are : INPUT : temp table #subclientListTbl which has list of subclients.
	IF object_id('tempdb.dbo.#subclientContent_InfoTable') is not null
		DROP TABLE #subclientContent_InfoTable
	CREATE TABLE #subclientContent_InfoTable(subclientId INT, vmClientId INT, VMGuid nvarchar(256), VMName nvarchar(1024),vmJobId INT, childVMScId INT)
	CREATE CLUSTERED INDEX subclientContent_InfoTable_subclientId_VMClientId_Index1 ON #subclientContent_InfoTable (subclientId,vmClientId)
	-- Get Latest Job cycle. From that job cycle, get all vm's along with there status in that cycle mapped with latest job id for that vm
	-- Have the child VM subclient same as parent subclient by default.
			INSERT INTO #subclientContent_InfoTable( vmclientId,vmJobId, subclientId, childVMScId)
			SELECT AVM.VMclientId AS vmClientId, MAX(JB.jobId) AS jobId, JFC.ScId as ScId, JFC.ScId FROM APP_VMProp AVM WITH (NOLOCK)
					INNER JOIN JMBkpStats JB WITH (NOLOCK)
					ON JB.jobId = AVM.jobId
					INNER JOIN (
						SELECT MAX(fullCycleNum) AS jobFullCycle,
						subclientListTbl.subclientId as scId
						FROM   JMBkpStats JM WITH (NOLOCK)
						INNER JOIN #subclientListTbl subclientListTbl on
						JM.appId = subclientListTbl.subclientId AND JM.status in (1,3,14,16)
						and JM.commcellId=2
						group by subclientListTbl.subclientId ) JFC
					ON JFC.jobFullCycle=JB.fullCycleNum AND JB.appId=JFC.ScId
					and JB.commcellId=2
					and AVM.attrName='vmStatus' AND AVM.attrVal IN ('0', '3')
					GROUP BY AVM.VMclientId,JFC.ScId
			update subclientContent_InfoTable
			set VMGuid=App_vmprop.attrVal
			from #subclientContent_InfoTable subclientContent_InfoTable
			inner join App_vmprop WITH (NOLOCK)
			on subclientContent_InfoTable.vmJobId=APP_VMProp.jobId and APP_VMProp.commCellId=2
			and APP_VMProp.VMclientId=subclientContent_InfoTable.vmClientId
			and APP_VMProp.attrName='vmguid'
			update subclientContent_InfoTable
			set VMName=App_ClientProp.attrval
			from #subclientContent_InfoTable subclientContent_InfoTable
			INNER JOIN App_clientProp WITH (NOLOCK) ON App_clientProp.componentnameID = subclientContent_InfoTable.vmClientId
			AND App_ClientProp.attrname='Virtual machine name' --CV_PROP_VIRTUAL_SERVER_VM_NAME
			AND App_ClientProp.modified = 0
			-- Update subclientId with child subclient for V2 VSA
			UPDATE subclientContent_InfoTable
			SET  childVMScId = CHILD.ID
			FROM #subclientContent_InfoTable subclientContent_InfoTable
			INNER JOIN App_Application PARENT (NOLOCK) ON subclientContent_InfoTable.subclientId = PARENT.Id
			INNER JOIN App_ClientProp PARENTCLIENT (NOLOCK) ON PARENTCLIENT.ComponentnameId = PARENT.clientId
			AND PARENTCLIENT.attrName='IndexingV2_VSA' AND PARENTCLIENT.modified=0 AND PARENTCLIENT.attrVal=N'1' --CV_PROP_VSA_INDEXING_V2 ensure client is VSAv2 enabled.
			INNER JOIN APP_VMBackupSet (NOLOCK) ON PARENT.backupSet = APP_VMBackupSet.ParentBackupSetId
			INNER JOIN App_Application CHILD (NOLOCK) ON CHILD.backupSet = APP_VMBackupSet.ChildBackupSetId
			AND (CHILD.subclientstatus & (4|2))=0   --- We dont want deleted and uninstalled subclients _CV_STATUS_DELETED| CV_STATUS_UNINSTALLED
			AND CHILD.clientId = subclientContent_InfoTable.vmclientId -- Identify the correct child client based on VM Guid.
--- CODE ABOVE HERE IS FROM TM_GetVMSubclientContent.spb  ----------
			-------------------------------------------------------------------------------------------------------------------------------------------
			-- delete the VMs for schedules using replication policy which are no longer part of subclient content
			Insert into #output_VsaInfoTable
				(replicationId, tkId , repGuid , sourceGuid , statusIn , spare2In , spare3In , lastBackupTimeIn , bkpJobsToSyncIn , action , statusOut , spare2Out , spare3Out , lastBackupTimeOut , bkpJobsToSyncOut , time )
			select 	App_VsaReplication.replicationId, taskId,replicationGuid,sourceGuid,	0,0,0,0,'','DELETED',0,0,0,0,'',@nowTime
				from App_VsaReplication inner join
				(
					--- Get all replicationIds for allocation policy schedules.
					select distinct App_VSAReplication.replicationID from App_VSAReplication with (nolock)
					inner join #completedPattern_runTimeInfoTable RI on RI.taskId=App_vsaReplication.taskId
					and RI.isScheduleUsingAllocationPolicy=1
					and (flags&@VSAREP_DELETED)=0
					except
					--- Get all replicationIds for allocation policy schedules part of current subclient content.
					select distinct App_VSAReplication.replicationID from App_VSAReplication with (nolock)
					inner join #completedPattern_runTimeInfoTable RI on RI.taskId=App_vsaReplication.taskId
					and RI.isScheduleUsingAllocationPolicy=1
					inner join #subclientContent_InfoTable CT ON
					App_VSAReplication.sourceGuid=CT.VMguid
					and App_vsaReplication.subclientId = CT.childVMScId
					AND CT.subclientId = RI.scId
				) temp
				on temp.replicationId=App_VsaReplication.replicationId
			UPDATE APP_VSAReplication
			SET flags = flags | @VSAREP_DELETED
			from APP_VSAReplication inner join #output_VsaInfoTable output_VsaInfoTable
			on output_VsaInfoTable.replicationId=APP_VSAReplication.replicationId
			and output_VsaInfoTable.action='DELETED'
			INSERT INTO #completedPattern_initVsaInfoTable
			(stId, tkId, repGuid, sourceGuid, sourceName, destinationName, patId, cgId, clId, apId, instId, bsId, scId, opType, copyPrecedenceApplicable, copyPrecedence, freq_type, tkDisabled, maxNumOfVMPerJob, isScheduleUsingAllocationPolicy, isIndexingV2Enabled)
			SELECT RI.stId, RI.taskId, vs.value('virtualServerRstOption[1]/@replicationGuid', 'NVARCHAR(MAX)') replicationGuid, ad.value('@guid', 'NVARCHAR(MAX)') sourceGuid, ad.value('@name', 'NVARCHAR(MAX)') sourceName,
			ad.value('@newName', 'NVARCHAR(MAX)') destinationName, RI.patId, RI.cgId, RI.clId, RI.apId, RI.instId, RI.bsId, RI.scId, RI.opType,
			vs.value('browseOption[1]/mediaOption[1]/copyPrecedence[1]/@copyPrecedenceApplicable', 'INT') copyPrecedenceApplicable, vs.value('browseOption[1]/mediaOption[1]/copyPrecedence[1]/@copyPrecedence', 'INT') copyPrecedence,
			RI.freq_type, RI.tkDisabled, 0 maxNumOfVMPerJob, RI.isScheduleUsingAllocationPolicy, CASE WHEN App_ClientProp.componentNameID IS NULL THEN 0 ELSE 1 END
			FROM #completedPattern_runTimeInfoTable RI
			LEFT JOIN App_ClientProp WITH (NOLOCK)  ON App_ClientProp.componentNameID = RI.clId AND App_ClientProp.attrName='IndexingV2_VSA' AND App_ClientProp.modified=0 AND App_ClientProp.attrVal=N'1' --CV_PROP_VSA_INDEXING_V2 Check client is VSAv2 enabled.
			JOIN TM_SubTaskXMLOptions SO WITH (NOLOCK) ON SO.subTaskId = RI.stId and RI.isScheduleUsingAllocationPolicy=0
			CROSS APPLY SO.xmlValue.nodes('TMMsg_JobOption/restoreOptions') V(vs)
			CROSS APPLY	vs.nodes('./virtualServerRstOption/diskLevelVMRestoreOption') D(dl)
			CROSS APPLY	dl.nodes('./advancedRestoreOptions') A(ad)
			UNION
			SELECT RI.stId, RI.taskId, taskReplicationguidPair.replicationGuid replicationGuid, CT.VMGuid sourceGuid, CT.VMName sourceName,
			'' destinationName, RI.patId, RI.cgId, RI.clId, RI.apId, RI.instId, RI.bsId, RI.scId, RI.opType,
			copyPrecedenceApplicable copyPrecedenceApplicable, copyPrecedence copyPrecedence,
			RI.freq_type, RI.tkDisabled, 0 maxNumOfVMPerJob, RI.isScheduleUsingAllocationPolicy, CASE WHEN App_ClientProp.componentNameID IS NULL THEN 0 ELSE 1 END
			FROM #completedPattern_runTimeInfoTable RI
			LEFT JOIN App_ClientProp WITH (NOLOCK) ON App_ClientProp.componentNameID = RI.clId AND App_ClientProp.attrName='IndexingV2_VSA' AND App_ClientProp.modified=0 AND App_ClientProp.attrVal=N'1' --CV_PROP_VSA_INDEXING_V2 Check client is VSAv2 enabled.
			JOIN #subclientContent_InfoTable CT ON CT.subclientId = RI.scId
			AND RI.isScheduleUsingAllocationPolicy=1
			JOIN TM_SubTaskXMLOptions SO WITH (NOLOCK) ON SO.subTaskId = RI.stId
			JOIN #taskReplicationguidPair taskReplicationguidPair ON taskReplicationguidPair.taskId = RI.taskId
			CROSS APPLY SO.xmlValue.nodes('TMMsg_JobOption/restoreOptions') V(vs)
			CROSS APPLY	vs.nodes('./virtualServerRstOption/diskLevelVMRestoreOption') D(dl)
			--MAKE SURE NOT TO GET ANY VMS WHICH HAVE BEEN MARKED FOR DELETION
			--DO NOT DELETE FROM TABLE HERE BECAUSE JOB MAY BE RUNNING, IT WILL GET REMOVED AT THE END
			DELETE #completedPattern_initVsaInfoTable
			FROM #completedPattern_initVsaInfoTable VS
			JOIN APP_VSAReplication VO (NOLOCK) ON VO.replicationGuid = VS.repGuid AND VO.sourceGuid = VS.sourceGuid AND VO.taskId = VS.tkId AND VO.destinationName = VS.destinationName
			WHERE VO.flags & @VSAREP_DELETED = @VSAREP_DELETED
			INSERT INTO #completedPattern_vmInfoTable
			(stId, tkId, repGuid, sourceGuid, sourceName, destinationName, patId, cgId, clId, apId, instId, bsId, scId, opType, copyPrecedenceApplicable, copyPrecedence, freq_type, tkDisabled, maxNumOfVMPerJob, jobId, clientId, isScheduleUsingAllocationPolicy,isIndexingV2Enabled)
			SELECT stId, tkId, repGuid, sourceGuid, sourceName, destinationName, patId, cgId, clId, apId, instId, bsId, scId, opType, copyPrecedenceApplicable,
			copyPrecedence, freq_type, tkDisabled, 0 maxNumOfVMPerJob, VP.jobId, VP.VMclientId, isScheduleUsingAllocationPolicy ,isIndexingV2Enabled
			FROM #completedPattern_initVsaInfoTable VS
			JOIN APP_VMProp VP WITH (NOLOCK) ON VP.attrVal=VS.sourceGuid AND VP.attrName='vmGUID'
			AND VS.isIndexingV2Enabled = 0 -- No need to look up App_VMProp for indexing V2 VMs since we look for their backup on VM subclient.
			INSERT INTO #completedPattern_VsaInfoTable
			(stId, tkId, repGuid, sourceGuid, sourceName, destinationName, patId, cgId, clId, apId, instId, bsId, scId, lastSuccessBkupTime, opType, jId, copyPrecedenceApplicable, copyPrecedence, freq_type, tkDisabled, maxNumOfVMPerJob,isScheduleUsingAllocationPolicy,isIndexingV2Enabled,
				scIdForDistribute)
			SELECT stId, tkId, repGuid, sourceGuid, sourceName, destinationName, patId, cgId, clId, apId, instId, bsId, scId, MAX(lastSuccessBkupTime) lastSuccessBkupTime, opType, MAX(jobId), copyPrecedenceApplicable,
				copyPrecedence, freq_type, tkDisabled, 0 maxNumOfVMPerJob,isScheduleUsingAllocationPolicy,isIndexingV2Enabled, scId
			FROM
			(
				SELECT stId, tkId, repGuid, sourceGuid, sourceName, destinationName, patId, cgId, clId, apId, instId, bsId, VP.scId, VP.opType, JB.servEndDate lastSuccessBkupTime, JB.jobId, copyPrecedenceApplicable,
				copyPrecedence, freq_type, tkDisabled, 0 maxNumOfVMPerJob, VP.isScheduleUsingAllocationPolicy,VP.isIndexingV2Enabled
				FROM #completedPattern_vmInfoTable VP
				JOIN APP_VMProp VM (NOLOCK) ON VM.jobId = VP.jobId AND VM.VMclientId = VP.clientId AND VM.attrName='vmStatus' AND VM.attrVal IN ('0', '3')	--CHECK FOR VM BACKUP STATUS 0 (COMPLETED) OR 3 (PARTIAL SUCCESS)
				-- Do this for indexing V1 . For V2 we need to look for backups on child subclient.
				AND VP.isIndexingV2Enabled = 0
				JOIN APP_Application APP (NOLOCK) ON APP.backupSet = VP.bsId AND (APP.ID = VP.ScID OR VP.ScID <= 0 ) -- For schedules created from commcell console subclientId in tm_assocentity is -1.
				-- If association is at subclient level then we check for backup on subclient only from JMBkpStats. If association is at backupset level then we check at backupset level
				JOIN JMBkpStats JB WITH (NOLOCK) ON JB.jobId = VM.jobId
					AND JB.appId = APP.id
					AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
					AND JB.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/) -- No need to start replication after synthfull backup
WHERE  VP.apId = 106 AND VP.opType = 1007
				UNION
				SELECT stId, tkId, repGuid, sourceGuid, sourceName, destinationName, patId, cgId, App_Application.clientId, App_Application.appTypeId, App_Application.instance, App_Application.backupset, App_Application.id, VP.opType, JB.servEndDate lastSuccessBkupTime, JB.jobId, copyPrecedenceApplicable,
				copyPrecedence, freq_type, tkDisabled, 0 maxNumOfVMPerJob, VP.isScheduleUsingAllocationPolicy,VP.isIndexingV2Enabled
				FROM #completedPattern_initVsaInfoTable VP
				INNER JOIN APP_VMBackupSet (NOLOCK) ON VP.bsId = APP_VMBackupSet.ParentBackupSetId AND VP.isIndexingV2Enabled = 1
				INNER JOIN App_Application  (NOLOCK) ON App_Application.backupSet = APP_VMBackupSet.ChildBackupSetId
				AND (App_Application.subclientstatus & (4|2))=0   --- We dont want deleted and uninstalled subclients _CV_STATUS_DELETED| CV_STATUS_UNINSTALLED
				INNER JOIN App_Clientprop WITH (NOLOCK) ON App_Clientprop.componentNameId = App_Application.clientId
				AND App_Clientprop.attrName='Virtual Machine Instance UUID'
				AND App_Clientprop.modified = 0
				AND App_Clientprop.attrVal = VP.sourceGuid
				JOIN JMBkpStats JB WITH (NOLOCK) ON JB.appId = App_Application.id
					AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
					AND JB.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/) -- No need to start replication after synthfull backup
WHERE  VP.apId = 106 AND VP.opType = 1007
				UNION
				-- To handle scenario where live sync is configured at VM level instead of VSA level.
				SELECT stId, tkId, repGuid, sourceGuid, sourceName, destinationName, patId, cgId, App_Application.clientId, App_Application.appTypeId, App_Application.instance, App_Application.backupset, App_Application.id, VP.opType, JB.servEndDate lastSuccessBkupTime, JB.jobId, copyPrecedenceApplicable,
				copyPrecedence, freq_type, tkDisabled, 0 maxNumOfVMPerJob, VP.isScheduleUsingAllocationPolicy,VP.isIndexingV2Enabled
				FROM #completedPattern_initVsaInfoTable VP
				INNER JOIN App_Application  (NOLOCK) ON App_Application.backupSet = VP.bsId
				AND (App_Application.id = VP.scId OR VP.scId<=0)
				AND (App_Application.subclientstatus & (4|2))=0   --- We dont want deleted and uninstalled subclients _CV_STATUS_DELETED| CV_STATUS_UNINSTALLED
				AND VP.isIndexingV2Enabled = 1
				INNER JOIN App_Clientprop WITH (NOLOCK) ON App_Clientprop.componentNameId = App_Application.clientId
				AND App_Clientprop.attrName='Virtual Machine Instance UUID'
				AND App_Clientprop.modified = 0
				AND App_Clientprop.attrVal = VP.sourceGuid
				JOIN JMBkpStats JB WITH (NOLOCK) ON JB.appId = App_Application.id
					AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
					AND JB.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/) -- No need to start replication after synthfull backup
WHERE  VP.apId = 106 AND VP.opType = 1007
			) T
			GROUP BY stId, tkId, repGuid, sourceGuid, sourceName, destinationName, patId, cgId, clId, apId, instId, bsId, scId, opType, copyPrecedenceApplicable, copyPrecedence, freq_type, tkDisabled, isScheduleUsingAllocationPolicy,isIndexingV2Enabled
--
			SET @oErrorString = 'Failed after completing step 2'
			--REMOVE VSA ENTRIES FROM TEMP TABLE THEY WILL GET REPOPULATED BELOW
			DELETE #completedPattern_runTimeInfoTable
			--CLEAR LAST BACKUP TIME WHEN COPY PRECEDENCE IS SET TO AVOID STARTING WHEN BACKUP HAS RUN BUT NOTHING HAS BEEN COPIED
			UPDATE #completedPattern_VsaInfoTable
			SET lastSuccessBkupTime = 0
			WHERE copyPrecedenceApplicable = 1
--
			--SOURCE VM CAN BE IN MULTIPLE SUBCLIENTS. UPDATE SC INFORMATION HERE TO AVOID DUPLICATE ENTRIES
			UPDATE #completedPattern_VsaInfoTable
				SET scId = ISNULL ((SELECT appId FROM JMBkpStats JS WITH (NOLOCK)
									--JOIN APP_VMProp (NOLOCK) VM ON VM.jobId = JS.jobId AND VM.attrVal=sourceGuid AND VM.attrName='vmGUID'
									WHERE JS.jobId = jId
									), 0
								),
				scIdforDistribute = ISNULL ((SELECT appId FROM JMBkpStats JS WITH (NOLOCK)
									--JOIN APP_VMProp (NOLOCK) VM ON VM.jobId = JS.jobId AND VM.attrVal=sourceGuid AND VM.attrName='vmGUID'
									WHERE JS.jobId = jId
									), 0
								)
				WHERE scId <= 0
				AND isIndexingV2Enabled = 0
			INSERT INTO #fullCycleInfo(subTaskId , subclientId, archGrpId ,archGrpCopyId ,fullCycleNum ,copyPrecedence ,backupLevel )
			SELECT IT.stId subTaskId, S.AppId subclientId, S.archGrpId, S.archGrpCopyId, MAX(fullCycleNum) FullCycleNum, MAX(IT.copyPrecedence) copyPrecedence, MAX(J.bkpLevel)
			FROM #completedPattern_VsaInfoTable IT
			JOIN JMJobDataStats (NOLOCK) S ON S.appId = IT.scId
			JOIN archGroupCopy (NOLOCK) AC ON AC.archGroupId = S.archGrpId AND AC.copy = IT.copyPrecedence AND AC.id = S.archGrpCopyId
			JOIN JMBkpStats (NOLOCK) J ON J.jobId = S.jobId AND J.commCellId = S.commCellId
			WHERE IT.copyPrecedenceApplicable = 1
			AND J.bkpLevel IN (1, 64, 128, 16384)
			GROUP BY IT.scId, S.archGrpId, S.archGrpCopyId, S.AppId, S.JobId, S.CommCellId, IT.stId
			HAVING MAX(S.status) = 100 AND MIN(S.Status) = 100
			--GET THE LAST COPY TIME FOR SCHEDULES WITH COPY PRECEDENSE SET
			-- For indexing v1 case use below code.
			INSERT INTO #auxCopyTable (subTaskId, subclientId, archGrpId, archGrpCopy, maxJobEndTime, maxCopiedTime)
			SELECT S.subTaskId subTaskId, S.subclientId, S.archGrpId, S.archGrpCopyId, MAX(jobEndTime) maxJobEndTime, MAX(maxCopiedTime) maxCopiedTime
			FROM
			(
				SELECT F.subTaskId subTaskId, F.subclientId, D.archGrpId, D.archGrpCopyId, J.servEndDate jobEndTime, J.cycleSequence,
					--ROW_NUMBER() OVER (PARTITION BY F.SubtaskId, F.subclientId ORDER BY J.servEndDate) CopiedCycleSequenceNum, MAX(copiedTime) maxCopiedTime
					ROW_NUMBER() OVER (PARTITION BY F.SubtaskId, F.subclientId ORDER BY J.servEndDate) +
					(SELECT COUNT(*) FROM JMBkpStats B (NOLOCK) WHERE  F.subclientId = B.AppId AND J.fullCycleNum = B.FullCycleNum AND J.cycleSequence > B.cycleSequence AND B.Status IN (1, 3) and B.DataStatus = 3) CopiedCycleSequenceNum,
					MAX(copiedTime) maxCopiedTime
				FROM
				(
					SELECT subTaskId, subclientId, archGrpId, archGrpCopyId, MAX(fullCycleNum) FullCycleNum, ROW_NUMBER() OVER (PARTITION BY SubtaskId, subclientId ORDER BY MAX(fullCycleNum) DESC) FullCycleNumSPs, MAX(copyPrecedence) copyPrecedence
					FROM #fullCycleInfo
					GROUP BY subTaskId, subclientId, archGrpId, archGrpCopyId
				) F
				JOIN JMBkpStats (NOLOCK) J ON J.appId = F.subclientId AND J.fullCycleNum = F.FullCycleNum
				JOIN JMJobDataStats (NOLOCK) D ON J.jobId = D.jobId AND J.commCellId = D.commCellId
				JOIN archGroupCopy (NOLOCK) AC ON AC.archGroupId = D.archGrpId AND AC.copy = F.copyPrecedence AND AC.id = D.archGrpCopyId
				WHERE  F.FullCycleNumSPs = 1
				GROUP BY F.subclientId, D.archGrpId, D.archGrpCopyId, J.servEndDate, J.cycleSequence, F.subTaskId, J.fullCycleNum
				HAVING MAX(D.status) = 100 AND MIN(D.Status) = 100
			) S
			WHERE  S.cycleSequence = S.CopiedCycleSequenceNum
			GROUP BY S.subclientId, S.archGrpId, S.archGrpCopyId, S.subclientId, S.subTaskId
			--DON'T GET VMS MARKED FOR DELETION, CREATE NEW ENTRY. APS
			--UPDATE TEMP TABLE FIELDS FROM APP_VSAReplication
			-- When same VMs are part of multiple subclients and assigned to same plan, then replicationId needs to be assigned based on subclientId also.
			UPDATE #completedPattern_VsaInfoTable
				SET replicationId = VR.replicationId
				FROM (
					SELECT replicationGuid, sourceGuid srcGuid, taskId, subclientId, replicationId
					FROM APP_VSAReplication VR WITH (NOLOCK)
					WHERE flags & @VSAREP_DELETED = 0
				) VR
				WHERE VR.replicationGuid = repGuid
				AND VR.srcGuid = sourceGuid
				AND VR.taskId = tkId
				-- Assign replicationId based on whether subclientId is there in tm_assocentity or not. For schedules from commcell console then subclientId isnt there in tm_Assocentity and for them isScheduleUsingAllocationPolicy will be set to 0.
				-- For schedules created from admin console with isScheduleUsingAllocationPolicy set, we should create seperate entries based on subclientId.
				AND ( (VR.subclientId = scId AND isScheduleUsingAllocationPolicy>0) OR isScheduleUsingAllocationPolicy=0)
				AND isIndexingV2enabled =0
				UPDATE completedPattern_VsaInfoTable
				SET replicationId = VR.replicationId
				FROM #completedPattern_VsaInfoTable  completedPattern_VsaInfoTable
				INNER JOIN APP_VSAReplication VR WITH (NOLOCK)
				ON VR.replicationGuid = completedPattern_VsaInfoTable.repGuid
				AND VR.sourceGuid = completedPattern_VsaInfoTable.sourceGuid
				AND VR.taskId = tkId
				AND VR.flags & @VSAREP_DELETED = 0
				-- Assign replicationId based on whether subclientId is there in tm_assocentity or not. For schedules from commcell console then subclientId isnt there in tm_Assocentity and for them isScheduleUsingAllocationPolicy will be set to 0.
				-- For schedules created from admin console with isScheduleUsingAllocationPolicy set, we should create seperate entries based on subclientId.
				AND VR.subclientId = scId
				-- Mark flags where the VM isnt part of live sync schedule any more.
				-- Mark replications deleted in App_VSAReplication table which have been removed and no longer in subtask xml options.
				UPDATE LS
				SET flags=@VSAREP_DELETED
				FROM APP_VSAReplication LS
				INNER JOIN #completedPattern_VsaInfoTable VsainfoTbl ON LS.taskID = VsainfoTbl.tkID
				LEFT JOIN #completedPattern_VsaInfoTable RT
				ON LS.replicationID = RT.ReplicationID
				LEFT JOIN #completedPattern_initVsaInfoTable completedPattern_initVsaInfoTable ON  -- dont remove VMs which are part of live sync schedule. Even though they may not be backed up.
				-- Post failback for OPENSTACK source VM Guid is changed. So it wont be part of backup. But we still dont want replication entry to be removed.
				completedPattern_initVsaInfoTable.tkId = LS.taskId
				AND completedPattern_initVsaInfoTable.sourceGuid = LS.sourceGuid
				WHERE RT.ReplicationID IS NULL
				AND VsainfoTbl.isScheduleUsingAllocationPolicy = 0 -- For schedules using allocation policy marking flag deleted is done above.
				AND completedPattern_initVsaInfoTable.sourceGuid IS NULL
				UPDATE auxCopyTable
				SET fullcycleNumFullBackup = ISNULL(T.fullCycleNum, 0)
				FROM #auxCopyTable auxCopyTable INNER JOIN
				(
					SELECT fullCycleInfo.subtaskId, fullCycleInfo.subclientId, MAX(fullCycleInfo.fullCycleNum) fullCycleNum
					FROM #fullCycleInfo fullCycleInfo
					WHERE fullCycleInfo.backupLevel = 1 -- Need only fullcycleNo corresponding to full backup
					GROUP BY fullCycleInfo.subtaskId, fullCycleInfo.subclientId
				) T
				ON auxCopyTable.subTaskId =  T.subtaskID
				AND auxCopyTable.subclientId = T.subclientID
			--SPARE2 IS TIME SCHEDULE GOT STARTED.  UPDATE BASED ON REQPLICATION ID SINCE WE CAN START VMs IN GROUPS
			UPDATE #completedPattern_VsaInfoTable
				SET status = VR.status,
				spare2 = VR.spare2,
				lastSyncedBkpJob = VR.lastSyncedBkpJob,
				replicationId = VR.replicationId,
				lastVSATime = VR.spare1,
				flags = VR.flags,
				lastScheduleRunTime = VR.spare3		--THIS IS THE TIME IN UTC THAT THE SCHEDULE STARTED
				FROM (
					SELECT status, lastSyncedBkpJob, replicationGuid, replicationId, spare3, spare1, spare2, flags
					FROM APP_VSAReplication VR WITH (NOLOCK)
					WHERE flags & @VSAREP_DELETED = 0
				) VR
				WHERE VR.replicationId = #completedPattern_VsaInfoTable.replicationId
			--UPDATE LAST SUCCESSFULL BACKUP TIME FROM AUX COPY JOB INFO
			UPDATE #completedPattern_VsaInfoTable
			SET lastSuccessBkupTime = T.servEndDate,
			maxcopyTime = T.maxCopiedTime
			FROM
			(
				SELECT MAX(J2.servEndDate) servEndDate, VS.sourceGuid srcBuid, J1.appId subclientId, MAX(AU.maxCopiedTime) maxCopiedTime,VS.stId subTaskId
				FROM #completedPattern_VsaInfoTable VS
				JOIN JMBkpStats J1 (NOLOCK) ON J1.appId = VS.scId
				JOIN #auxCopyTable AU ON AU.subclientId = J1.appId AND AU.maxJobEndTime = J1.servEndDate
				JOIN JMBkpStats J2 (NOLOCK) ON J2.appId = J1.appId AND J2.fullCycleNum = J1.fullCycleNum
				JOIN APP_VMProp (NOLOCK) VP ON VP.jobId = J2.jobId AND VP.attrVal=VS.sourceGuid AND VP.attrName='vmGUID'
				JOIN APP_VMProp (NOLOCK) VM ON VM.jobId = VP.jobId AND VM.VMclientId = VP.VMclientId AND VM.attrName='vmStatus' AND VM.attrVal IN ('0', '3')	--CHECK FOR VM BACKUP STATUS 0 (COMPLETED) OR 3 (PARTIAL SUCCESS)
				WHERE J2.appId = scId AND AU.subTaskId = stId
				AND J2.jobId > lastSyncedBkpJob
				AND J2.jobId <= J1.jobId
				AND J2.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/)
				GROUP BY VS.sourceGuid, J1.appId, VS.stId
			) T
			WHERE T.srcBuid = sourceGuid
			AND T.subclientId = scId
			AND copyPrecedenceApplicable = 1
			AND isIndexingV2Enabled = 0
			AND T.subTaskId = stID
			UPDATE #completedPattern_VsaInfoTable
			SET lastSuccessBkupTime = T.servEndDate,
			maxcopyTime = T.maxCopiedTime
			FROM
			(
				SELECT MAX(J2.servEndDate) servEndDate, VS.sourceGuid srcBuid, J1.appId subclientId, MAX(AU.maxCopiedTime) maxCopiedTime, VS.stID subTaskId
				FROM #completedPattern_VsaInfoTable VS
				JOIN JMBkpStats J1 (NOLOCK) ON J1.appId = VS.scId
				JOIN #auxCopyTable AU ON AU.subclientId = J1.appId AND AU.maxJobEndTime = J1.servEndDate
				JOIN JMBkpStats J2 (NOLOCK) ON J2.appId = J1.appId AND J2.fullCycleNum = J1.fullCycleNum
				AND J2.status IN (1,3)
				WHERE AU.subTaskId = stId
				AND J2.jobId > lastSyncedBkpJob
				AND J2.jobId <= J1.jobId
				AND J2.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/)
				GROUP BY VS.sourceGuid, J1.appId, VS.stID
			) T
			WHERE T.srcBuid = sourceGuid
			AND T.subclientId = scId
			AND copyPrecedenceApplicable = 1
			AND isIndexingV2Enabled = 1
			AND T.subTaskID = stID
			--GET INFORMATION FOR ANY REPLICATION JOBS THAT HAVE BEEN SUBMITTED TO START BUT JOB MANAGER HAS NOT STARTED
			INSERT INTO #xmlOption_InfoTable
				(stId, taskId, jobId, servEndTime, xmlValue, state, status)
				SELECT JR.stId, JR.tkId, JR.mJobId, JR.mCreated, O.value, @STATE_PENDING, JR.status
				FROM
				(
					SELECT R.created mCreated, V.stId, V.tkId, J.status, J.jobId mJobId
					FROM #completedPattern_VsaInfoTable V
					JOIN TM_JobRequest R (NOLOCK) ON R.subTaskId = V.stId
					JOIN TM_Jobs J ON J.jobRequestId = R.jobRequestId AND J.status IN (0, 1,4097)  -- Refer to SP JMGetJopbsToProcessed there is an intermeridate state where 4096 flag is set
					-- Read only committed rows. To handle synchronization issues where TM submitted job but JM didnt pick it up yet. It could happen that JM didnt insert into JMRstJobInfo above and changed TM_Jobs status to 2 by the time code here is executed.
					-- No need to handle only for max job. So removing group by
					-- GROUP BY V.stId, J.status, V.tkId
				) JR
JOIN TM_JobOptions O (NOLOCK) ON O.jobId = JR.mJobId AND O.optionId = 120012
			--GET INFORMATION FOR ANY REPLICATION JOBS THAT ARE RUNNING
			INSERT INTO #xmlOption_InfoTable
				(stId, taskId, jobId, xmlValue, state)
				SELECT DISTINCT VR.stId, VR.tkId, RS.jobId, O.value, @STATE_RUNNING
				FROM JMRstJobInfo RS -- Read only committed rows. To handle synchronization issues where TM submitted job but JM didnt pick it up yet. It could happen that JM didnt insert into JMRstJobInfo here and changed TM_Jobs status to 2 by the time code below is executed.
				JOIN #completedPattern_VsaInfoTable VR ON VR.stId = RS.rstTaskID
JOIN TM_JobOptions O (NOLOCK) ON O.jobId = RS.jobId AND O.optionId = 120012
			--GET INFORMATION FOR ANY REPLICATION JOBS THAT HAVE ALREADY RAN
			INSERT INTO #xmlOption_InfoTable
				(stId, taskId, jobId, servEndTime, xmlValue, state, status)
				SELECT DISTINCT VR.stId, VR.tkId, RS.jobId, RS.servEndTime, O.value, @STATE_COMPLETE, RS.status
				FROM JMRestoreStats RS (NOLOCK)
				JOIN #completedPattern_VsaInfoTable VR ON VR.stId = RS.subTaskId
JOIN TM_JobOptions O (NOLOCK) ON O.jobId = RS.jobId AND O.optionId = 120012
				--GET INFORMATION EVEN IF JOB FAILED SO THAT WE CAN DETERMINE IF WE ALREADY STARTED A JOB
				--AND RS.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
			--GET THE TOTIME INFORMATION TO DETERMINE IF JOB HAS ALREADY RUN FOR COPY PRECEDENCE
			INSERT INTO #xmltoTimeOption_InfoTable
				(repId, stId, taskId, jobId, xmlValue, state, status)
				SELECT vs.value('@id1', 'INT') repId, stId, taskId, jobId, vs.value('@name', 'NVARCHAR(MAX)'), state, status
				FROM #xmlOption_InfoTable T
				CROSS APPLY T.xmlValue.nodes('/TMMsg_EntityListResp/entities') V(vs)
				WHERE status <> 2 AND status <> 4 -- CVJobStatus: FAIL=2, KILLED=4
			--GET THE MAX TOTIME FOR EACH VM
			INSERT INTO #toTime_InfoTable
			(repId, toTime)
			SELECT T.repId, vs.value('@toTime', 'INT') toTime
			FROM #xmltoTimeOption_InfoTable T
				CROSS APPLY T.xmlValue.nodes('/TMMsg_BrowseOption/timeRange') V(vs)
			--UPDATE THE VSA REPLICATION JOB
			UPDATE #completedPattern_VsaInfoTable
				SET vsaJobId = UP.jobId
				FROM
				(
					SELECT jobId, repId, subTaskId
					FROM (	--GET JOB THAT HAS REPLICATION ID AS OPTION
							SELECT T.jobId, vs.value('@id1', 'INT') repId, T.stId subTaskId
							FROM #xmlOption_InfoTable T
							CROSS APPLY T.xmlValue.nodes('/TMMsg_EntityListResp/entities') V(vs)
							WHERE T.state IN (@STATE_PENDING, @STATE_RUNNING)
							--JOB RAN FOR ALL VMS IN SCHEDULE
							UNION
							SELECT DISTINCT RS.jobId, 0 repId, VR.stId subTaskId
							FROM JMRstJobInfo RS (NOLOCK)
							JOIN #completedPattern_VsaInfoTable VR ON VR.stId = RS.rstTaskID
WHERE NOT EXISTS (SELECT 1 FROM TM_JobOptions O (NOLOCK) WHERE O.jobId = RS.jobId AND O.optionId = 120012)
					) RJ
				) UP
				WHERE (replicationId = UP.repId AND replicationId <> 0) OR (UP.repId = 0 AND UP.subTaskId = stId)
			--GET LAST RESTORE JOB FROM JM TABLE.  JM MAY NOT UPDATE THE SPARE1 COLUMN BEFORE JOB IS MOVED FROM JMRstJobInfo TO JMRestoreStats AND STATUS WILL BE SET INCORRECTLY
			--JOB RAN FOR ALL VMS IN SCHEDULE
			UPDATE #completedPattern_VsaInfoTable
				SET lastVSATime = CASE WHEN UP.servEndTime > lastVSATime THEN UP.servEndTime ELSE lastVSATime END
				FROM
				(
					SELECT DISTINCT MAX(RS.servEndTime) servEndTime, VR.stId subTaskId
					FROM JMRestoreStats RS (NOLOCK)
					JOIN #completedPattern_VsaInfoTable VR ON VR.stId = RS.subTaskId
WHERE NOT EXISTS (SELECT 1 FROM TM_JobOptions O (NOLOCK) WHERE O.jobId = RS.jobId AND O.optionId = 120012)
AND NOT EXISTS (SELECT 1 FROM TM_JobOptions O (NOLOCK) WHERE O.subTaskId = VR.stId AND O.optionId = 120012)
					AND RS.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
					GROUP BY VR.stId
				) UP
				WHERE UP.subTaskId = stId AND replicationId <> 0
			UPDATE #completedPattern_VsaInfoTable
				SET lastVSATime = CASE WHEN UP.servEndTime > lastVSATime THEN UP.servEndTime ELSE lastVSATime END
				FROM
				(
					SELECT MAX(servEndTime) servEndTime, repId, subTaskId
					FROM (
							SELECT T.servEndTime, vs.value('@id1', 'INT') repId, T.stId subTaskId
							FROM
							(
								SELECT R.servEndTime, R.jobId, R.xmlValue, R.stId
								FROM #xmlOption_InfoTable R
								WHERE R.state = @STATE_COMPLETE
								AND status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
							) T
							CROSS APPLY T.xmlValue.nodes('/TMMsg_EntityListResp/entities') V(vs)
					) RJ
					GROUP BY repId, subTaskId
					--ORDER BY repId, subTaskId
				) UP
				WHERE replicationId = UP.repId AND replicationId <> 0
			DELETE #completedPattern_VsaInfoTable
			WHERE
			lastSuccessBkupTime = 0	-- REMOVE IF BACKUP HAS NOT RUN
			AND
			copyPrecedenceApplicable = 0
			IF NOT EXISTS(SELECT * FROM #completedPattern_VsaInfoTable)
			BEGIN
				SET @oErrorString = 'No backups have run'
				GOTO EXIT_VSA
			END
			-- Remove entries from #completedPattern_VsaInfoTable which have reverse replication flag set. Since they will be triggered by
			-- "Run immediate" on live sync schedule from DR orchestration layer
			--REMOVE VMS SET FOR REVERSE REPLICATION. DO NOT START JOBS FOR THESE VMS
			DELETE #completedPattern_VsaInfoTable
			WHERE (flags & @VSAREP_REVERSE_REP) = @VSAREP_REVERSE_REP
			--IF VALIDATION FAIL STATUS FOUND, START ONLY FOR VM WITH THAT STATUS
			--NEXT ITERATION SHOULD PICKUP OTHER VMS
			DELETE #completedPattern_VsaInfoTable
			FROM
			(
				SELECT tkId taskId, replicationId repId FROM #completedPattern_VsaInfoTable
				WHERE status = @VSAREP_VALIDATION_FAILED
			) T WHERE T.taskId = tkId
			AND status != @VSAREP_VALIDATION_FAILED
			-- Reset Sync in progress status for VMs for which no replication job is running. MR 231238	. Change the status of "sync in progress" vms to "needs sync", if there are no active jobs running.
			UPDATE #completedPattern_VsaInfoTable
			SET STATUS = @VSAREP_COMPLETE
			WHERE status = @VSAREP_RUNNING AND vsaJobId = 0
			--SET FLAGS BASED ON EXISTING STATUS SET IN DB BEFORE UPDATING NEW STATUS VALUE
			UPDATE #completedPattern_VsaInfoTable
			SET flags =
			(
				CASE
				--CLEAR THE FLAG VALUE ONCE THE JOB WAS STARTED
				WHEN flags = @VSAREP_VALIDATION_FAILED
					AND (spare2 > lastSuccessBkupTime OR lastVSATime > lastSuccessBkupTime)
					THEN 0		--CLEAR AFTER REPLICATION JOB RUNS OR NEW BACKUP JOB COMPLETES
				--SET FLAGS BASED ON EXISTING STATUS SET IN DB BEFORE UPDATING NEW STATUS VALUE
				WHEN status = @VSAREP_VALIDATION_FAILED
					AND tkDisabled = 0
					AND @disableVMRevertReplication = 0
					THEN @VSAREP_VALIDATION_FAILED		--STORE THE VALUE OF STATUS IN FLAG COLUMN
				ELSE flags
				END
			),
			--SET VM STATUS ON TEMP TABLE
			--START BY SETING STATUS TO PENDING ON ALL VALID VMS THAT BACKUP HAS RUN.
			--THEN WE WILL DETERMIN WHICH VMS BELONG TO DIFFERENT SUBCLIENTS
			--IF DISTRIBUTE OPTION IS SET WE WILL SET SOME OF THE VMS TO QUEUE STATE SO THAT THEY GET PICKET UP AFTER REPLICATION COMPLETES
			-- FOR NEW REPLICATIONS, WE WANT TO START IF COPY PRECEDENCE is applicable only after aux copy job has run.
			status =
			(
				CASE
				WHEN status IN (@VSAREP_COMPLETE, @VSAREP_ENABLED, @VSAREP_PAUSED, @VSAREP_REVERT_FAILED)
					AND (
							(spare2 < lastSuccessBkupTime AND copyPrecedenceApplicable = 0)
							OR
							(spare2 < maxcopyTime AND copyPrecedenceApplicable = 1)
						)
					THEN @VSAREP_PENDING
				--START REVERT JOB EVEN IF BACKUP HAS NOT RUN
				WHEN status IN (@VSAREP_VALIDATION_FAILED)
					--FOR REVERT ONLY CHANGE STATUS WHEN JOB IS TO GET STARTED
					AND tkDisabled = 0
					THEN @VSAREP_PENDING
				WHEN status in (@VSAREP_JOB_QUEUED)
					THEN @VSAREP_PENDING
				WHEN replicationId = 0 AND (
							(copyPrecedenceApplicable = 0)
							OR
							(spare2 < maxcopyTime AND copyPrecedenceApplicable = 1)
						)
					THEN @VSAREP_PENDING
				-- For new replications, if copy precedence is applicable and aux copy is run then we set status to pending above. Else we set it to complete below.
				WHEN replicationId = 0
					THEN @VSAREP_COMPLETE
				ELSE status
				END
			)
			--REMOVE ANY ENTRIES WITH SAME SCHEDULE FOR WHICH REPLICATION JOB IS RUNNING
			DELETE #completedPattern_VsaInfoTable
			FROM
			(
				SELECT replicationId repId, stId subTaskId
				FROM #completedPattern_VsaInfoTable
				WHERE vsaJobId > 0
			) T
			WHERE
			T.subTaskId = stId AND ISIndexingv2Enabled=0
			-- For VSA v2 remove only replications which are already running.
			DELETE #completedPattern_VsaInfoTable
			FROM
			(
				SELECT replicationId repId, stId subTaskId
				FROM #completedPattern_VsaInfoTable
				WHERE vsaJobId > 0
			) T
			WHERE
			T.repId = replicationId AND ISIndexingv2Enabled>0
			--REMOVE ANY ENTRIES FOR WHICH REPLICATION JOB IS RUNNING AND JOB HAS NOT BEEN STARTED
			DELETE #completedPattern_VsaInfoTable
			FROM
			(
				SELECT vs.value('@id1', 'INT') repId, T.stId subTaskId, T.created, T.jobId, T.status
				FROM
				(
					SELECT JR.servEndTime created, JR.status, JR.stId, JR.jobId, JR.xmlValue
					FROM #xmlOption_InfoTable JR
JOIN TM_JobOptions O (NOLOCK) ON O.jobId = JR.jobId AND JR.state = @STATE_PENDING AND O.optionId = 120012
				) T
				CROSS APPLY T.xmlValue.nodes('/TMMsg_EntityListResp/entities') V(vs)
			) V
			WHERE V.repId = replicationId
			AND
			(
				V.status IN (0, 1,4097)	-- JM HAS NOT STARTED THE JOB. Refer to SP JMGetJopbsToProcessed there is an intermeridate state where 4096 flag is set
				OR
				(
					V.status = 2	-- JM HAS STARTED THE LAST REPLICATION JOB THAT WAS SUBMITTED BY SCHEDULER
					AND
					V.created < datediff(second, '01/01/1970', dbo.UTCToClientLocalTime(dateadd(second,spare2, '01/01/1970'), 2))
				)
			)
			--REMOVE ANY RUNTIME WHICH WERE ENTERED IN PREVIOUS ITERATION
			DELETE #completedPattern_VsaInfoTable
			FROM #completedPattern_VsaInfoTable VT
			INNER JOIN
			(
				SELECT RT.stId subtaskId
				FROM #completedPattern_VsaInfoTable RT
JOIN TM_PatternAssoc (NOLOCK) PA ON PA.subTaskId = RT.stId AND RT.freq_type = 4096
				JOIN TM_Pattern (NOLOCK) P ON P.patternId = PA.patternId
				JOIN TM_RunTime (NOLOCK) RProcessed ON RProcessed.patternId = P.patternId
				JOIN TM_RunTimeAssoc (NOLOCK) RProcessedAssoc ON RProcessed.runTimeId = RProcessedAssoc.runTimeId
				GROUP BY RT.stId
				HAVING DATEDIFF(s, MAX(RProcessedAssoc.nextRunTime), @nowTime) > 0 AND DATEDIFF(s, MAX(RProcessedAssoc.nextRunTime), @nowTime) < 60
				-- if last processed runtime assoc time for schedule was less than 60 seconds, then dont enter again.
			) T
			ON T.subtaskId = VT.stId
AND VT.freq_type = 4096
			--CHANGE STATUS TO PENDING ANY VMS THAT WERE STARTED BUT JOB FAILED AND STATUS DID NOT GET CHANGED BY VSRST
			UPDATE #completedPattern_VsaInfoTable SET status = @VSAREP_PENDING
			WHERE status = @VSAREP_STARTING
			IF NOT EXISTS(SELECT * FROM #completedPattern_VsaInfoTable)
			BEGIN
				SET @oErrorString = 'job already running for all schedules'
				GOTO EXIT_VSA
			END
			--GET LIST OF REGULAR BACKUP JOBS TO BE REPLICATED
			UPDATE #completedPattern_VsaInfoTable
				SET bkpJobsToSync = ISNULL( (SELECT CASE WHEN MIN(JB.jobid) != MAX(JB.jobid) THEN CAST(MIN(JB.jobid) AS VARCHAR)+','+CAST(MAX(JB.jobid) AS VARCHAR) ELSE CAST(MAX(JB.jobid) AS VARCHAR) END
					FROM JMBkpStats (NOLOCK) JB
					JOIN APP_VMProp (NOLOCK) VP ON VP.jobId = JB.jobId AND VP.attrVal=sourceGuid AND VP.attrName='vmGUID'
					JOIN APP_VMProp (NOLOCK) VM ON VM.jobId = VP.jobId AND VM.VMclientId = VP.VMclientId AND VM.attrName='vmStatus' AND VM.attrVal IN ('0', '3')	--CHECK FOR VM BACKUP STATUS 0 (COMPLETED) OR 3 (PARTIAL SUCCESS)
					WHERE JB.appId = scId
					AND JB.jobId > lastSyncedBkpJob
					AND lastSyncedBkpJob > 0
					AND JB.dataStatus != 2 -- Adding check to ensure we dont include aged jobs in bkpJobsToSync
					AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
					AND JB.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/)	--MR:192409
					),'')
			WHERE copyPrecedenceApplicable = 0
			AND ISIndexingv2Enabled=0
			-- For vsa v2, now App_VMProp doesnt have any entry for child subclient backups. so backups pending to sync doesnt have any value if we look at vm prop. So looking at JMBkpStats directly
			UPDATE #completedPattern_VsaInfoTable
			SET bkpJobsToSync = ISNULL( (SELECT CASE WHEN MIN(JB.jobid) != MAX(JB.jobid) THEN CAST(MIN(JB.jobid) AS VARCHAR)+','+CAST(MAX(JB.jobid) AS VARCHAR) ELSE CAST(MAX(JB.jobid) AS VARCHAR) END
					FROM JMBkpStats (NOLOCK) JB
					WHERE JB.appId = scId
					AND JB.jobId > lastSyncedBkpJob
					AND lastSyncedBkpJob > 0
					AND JB.dataStatus != 2 -- Adding check to ensure we dont include aged jobs in bkpJobsToSync
					AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
					AND JB.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/)     --MR:192409
					),'')
			WHERE copyPrecedenceApplicable = 0
			AND ISIndexingv2Enabled=1
			--GET LIST OF BACKUP JOBS THAT HAVE BEEN AUXCOPIED TO BE REPLICATED
			UPDATE #completedPattern_VsaInfoTable
				SET bkpJobsToSync = ISNULL( (SELECT CASE WHEN MIN(J2.jobid) != MAX(J2.jobid) THEN CAST(MIN(J2.jobid) AS VARCHAR)+','+CAST(MAX(J2.jobid) AS VARCHAR) ELSE CAST(MAX(J2.jobid) AS VARCHAR) END
					FROM JMBkpStats J1 (NOLOCK)
					JOIN #auxCopyTable AU ON AU.subclientId = J1.appId AND AU.maxJobEndTime = J1.servEndDate
					JOIN JMBkpStats J2 (NOLOCK) ON J2.appId = J1.appId AND J2.fullCycleNum >= AU.fullcycleNumFullBackup
					JOIN APP_VMProp (NOLOCK) VP ON VP.jobId = J2.jobId AND VP.attrVal=sourceGuid AND VP.attrName='vmGUID'
					JOIN APP_VMProp (NOLOCK) VM ON VM.jobId = VP.jobId AND VM.VMclientId = VP.VMclientId AND VM.attrName='vmStatus' AND VM.attrVal IN ('0', '3')	--CHECK FOR VM BACKUP STATUS 0 (COMPLETED) OR 3 (PARTIAL SUCCESS)
					WHERE J2.appId = scId AND AU.subTaskId = stId
					AND J2.jobId > lastSyncedBkpJob
					AND J2.dataStatus != 2 -- Adding check to ensure we dont include aged jobs bkpJobsToSync
					AND J2.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/)
					AND J2.jobId <= J1.jobId
					AND lastSyncedBkpJob > 0
					),'')
			WHERE copyPrecedenceApplicable = 1
			AND ISIndexingv2Enabled=0
			--GET LIST OF BACKUP JOBS THAT HAVE BEEN AUXCOPIED TO BE REPLICATED for indexing v2 case
			UPDATE #completedPattern_VsaInfoTable
				SET bkpJobsToSync = ISNULL( (SELECT CASE WHEN MIN(J2.jobid) != MAX(J2.jobid) THEN CAST(MIN(J2.jobid) AS VARCHAR)+','+CAST(MAX(J2.jobid) AS VARCHAR) ELSE CAST(MAX(J2.jobid) AS VARCHAR) END
					FROM JMBkpStats J1 (NOLOCK)
					JOIN #auxCopyTable AU ON AU.subclientId = J1.appId AND AU.maxJobEndTime = J1.servEndDate
					JOIN JMBkpStats J2 (NOLOCK) ON J2.appId = J1.appId AND J2.fullCycleNum >= AU.fullcycleNumFullBackup
					AND J2.Status IN (1,3)
					WHERE J2.appId = scId AND AU.subTaskId = stId
					AND J2.jobId > lastSyncedBkpJob
					AND J2.dataStatus != 2 -- Adding check to ensure we dont include aged jobs bkpJobsToSync
					AND J2.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/)
					AND J2.jobId <= J1.jobId
					AND lastSyncedBkpJob > 0
					),'')
			WHERE copyPrecedenceApplicable = 1
			AND ISIndexingv2Enabled=1
			-- SAVE JOB ID OF THE LAST JOB THAT WAS AUX COPIED INTO APP_VSAReplicationProp TABLE
			MERGE APP_VSAReplicationProp AS target
			USING
			(
				SELECT distinct vsa.replicationId replicationId,
				(
					CASE WHEN bkpJobsToSync = '' THEN 0
						 WHEN CHARINDEX(',', bkpJobsToSync) = 0 THEN CAST(bkpJobsToSync AS INT)
						 WHEN CHARINDEX(',', bkpJobsToSync) <> 0 AND CHARINDEX(',', bkpJobsToSync) < LEN(bkpJobsToSync) THEN CAST(SUBSTRING(bkpJobsToSync, CHARINDEX(',', bkpJobsToSync) + 1, LEN(bkpJobsToSync))  AS INT)
						 ELSE 0 END
				) lastCopiedJobId
				FROM #completedPattern_VsaInfoTable vsa
				WHERE vsa.replicationId <> 0
) AS source ON target.propertyTypeId = 2223 AND target.replicationId = source.replicationId
			WHEN MATCHED AND source.lastCopiedJobId <> 0 AND propertyValue <> source.lastCopiedJobId
				THEN UPDATE SET target.propertyValue = source.lastCopiedJobId
			WHEN NOT MATCHED AND source.lastCopiedJobId <> 0
				THEN INSERT (replicationId, propertyTypeId, propertyValue, created, modified)
VALUES (source.replicationId, 2223, source.lastCopiedJobId, @nowTimeUnix, 0);
			IF EXISTS (SELECT 1 FROM #completedPattern_VsaInfoTable)
			BEGIN
				SET @oErrorString = 'Failed after completing step 5'
				--UPDATE APP_VSA TABLE
				MERGE APP_VSAReplication AS VR
				USING
				(
					SELECT repGuid, tkId, bsId, scId, lastSuccessBkupTime, sourceGuid, sourceName, destinationName, freq_type, bkpJobsToSync, tkDisabled, replicationId, lastVSATime, status, flags
					FROM #completedPattern_VsaInfoTable
WHERE apId = 106	--CV_APPTYPE_VIRTUAL_SERVER
				) AS RT ON RT.replicationId = VR.replicationId --RT.repGuid = VR.replicationGuid AND RT.sourceGuid = VR.sourceGuid
				WHEN MATCHED THEN
					UPDATE SET
					--VR.lastRestoreTime = @nowTimeUnix,	--UPDATE RESTORE TIME TO AVOID RESTARTING THE JOB
					VR.lastBackupTime =
								(
									CASE
									WHEN RT.lastSuccessBkupTime IS NULL OR RT.lastSuccessBkupTime = 0 THEN VR.lastBackupTime
									ELSE RT.lastSuccessBkupTime
									END
								),
					--VR.modified = @nowTimeUnix,
					VR.flags = RT.flags,
					VR.BkpJobsToSync =
								(
									CASE
									WHEN VR.lastSyncedBkpJob > 0 THEN RT.bkpJobsToSync
									ELSE VR.BkpJobsToSync
									END
								),
					VR.subclientId = RT.scId,
					VR.status = RT.status
				WHEN NOT MATCHED THEN
					INSERT (replicationGuid, sourceGuid, sourceName, destinationGuid, destinationName, lastRestoreTime, lastBackupTime, backupsetId, subclientId, taskId, powerOn, options, spare1,
							spare2, spare3, created, modified, flags, status, lastSyncedBkpJob, VMSyncedTillTime, BkpJobsToSync, ValidationFailCount, FailoverStatus)
					VALUES(RT.repGuid, sourceGuid, sourceName, '', destinationName, 0, ISNULL(RT.lastSuccessBkupTime, 0), ISNULL(RT.bsId, 0), ISNULL(RT.scId, 0), ISNULL(RT.tkId, 0), 0, '0', '',
							'', '', @nowTimeUnix, 0, 0, RT.status, 0, 0, RT.bkpJobsToSync, 0, 0)
				OUTPUT INSERTED.replicationId, INSERTED.taskId, INSERTED.replicationGuid, INSERTED.sourceGuid, INSERTED.status, INSERTED.spare2, INSERTED.spare3, INSERTED.lastBackupTime, INSERTED.bkpJobsToSync,
				$action, DELETED.status, DELETED.spare2, DELETED.spare3, DELETED.lastBackupTime, DELETED.bkpJobsToSync, @nowTime INTO #output_VsaInfoTable
					;
			END
		--NOW FIGURE OUT IF WE NEED TO START A JOB
			--REMOVE FROM OUTPUT TABLE ANY ENTRIES WHICH HAVE NOT CHANGED
			DELETE #output_VsaInfoTable WHERE statusIn=statusOut AND spare3In=spare3Out AND lastBackupTimeIn=lastBackupTimeOut AND bkpJobsToSyncIn = bkpJobsToSyncOut AND action = 'UPDATE'
			--REMOVE ANY ENTRIES FOR SCHEDULES THAT ARE DISABLED
			--DELETE #output_VsaInfoTable
			--WHERE tkId IN (SELECT tkId FROM #completedPattern_VsaInfoTable WHERE tkDisabled=1)
			DELETE #completedPattern_VsaInfoTable
			WHERE tkDisabled = 1
			IF NOT EXISTS(SELECT * FROM #completedPattern_VsaInfoTable)
			BEGIN
				SET @oErrorString = 'All schedules have been disabled'
				GOTO EXIT_VSA
			END
			IF EXISTS(SELECT 1 FROM JMJobAction (NOLOCK) WHERE opType=28 AND action=1 AND clientId = 1 AND appType = 0 AND mediaAgentID = 1)
			BEGIN
				SET @oErrorString = 'Schedules will skipped because scheduler activity is disable'
				GOTO EXIT_VSA
			END
			--SET REPLICATION ID FOR NEW ENTRIES ADDED TO TABLE
			UPDATE #completedPattern_VsaInfoTable
			SET replicationId = repId
			FROM
			(
				SELECT replicationId repId, tkId taskId, repGuid replicationGuid, sourceGuid srcGuid
				FROM #output_VsaInfoTable
			) T
			WHERE replicationId = 0 AND tkId = taskId AND repGuid = replicationGuid AND sourceGuid = srcGuid
			--BELOW CODE IS TO REMOVE ENTRIES FROM TEMP TABLE THAT WERE ONLY USED TO UPDATE THE MAIN TABLE AND ARE NOT NEEDED TO START THE SCHEDULE
			DELETE #completedPattern_VsaInfoTable
			WHERE
			lastSuccessBkupTime = 0	-- REMOVE IF AUXCOPY HAS NOT RUN
			AND
			copyPrecedenceApplicable = 1
			IF NOT EXISTS(SELECT * FROM #completedPattern_VsaInfoTable)
			BEGIN
				SET @oErrorString = 'No Aux copy job has run for any schedule with copy precedence option set'
				GOTO EXIT_VSA
			END
			--REMOVE ANY RUNTIME WHICH HAS ALREADY BEEN CALCULATED
			DELETE #completedPattern_VsaInfoTable
			FROM #completedPattern_VsaInfoTable VT
			WHERE
			EXISTS (SELECT * FROM TM_RunTime RT WITH (NOLOCK) WHERE RT.patternId = patId AND RT.nextTime >= datediff(second, '01/01/1970', dbo.UTCToClientLocalTime(dateadd(second,lastSuccessBkupTime, '01/01/1970'), 2)))
			AND
VT.freq_type = 4096
			AND
			VT.flags & (@VSAREP_VALIDATION_FAILED | @VSAREP_REVERSE_REP) = 0
			AND
			(VT.maxNumOfVMPerJob = 0 OR VT.maxNumOfVMPerJob IS NULL)
			AND copyPrecedenceApplicable = 0
			IF NOT EXISTS(SELECT * FROM #completedPattern_VsaInfoTable)
			BEGIN
				SET @oErrorString = 'Nothing to run'
				GOTO EXIT_VSA
			END
--
			SET @oErrorString = 'Failed after completing step 3a'
			--REMOVE ANY VSA RESTORE JOBS WHICH HAVE ALREADY RUN AND NEW BACKUP HAS NOT COMPLETED
			DELETE #completedPattern_VsaInfoTable
			FROM #completedPattern_VsaInfoTable RT
			JOIN APP_VSAReplication VR WITH (NOLOCK)
				ON VR.replicationId = RT.replicationId
			WHERE
apId = 106
AND opType = 1007
			AND
			(
				--REMOVE ANY VSA RESTORE JOBS WHICH HAVE FAILED OR ALREADY RUN AND NEW BACKUP HAS NOT RUN
				VR.status IN (@VSAREP_DISABLED, @VSAREP_FAILED, @VSAREP_REVERT_FAILED)	--NEVER START JOB FOR THESE STATUS
				OR
				--REMOVE ANY AUTOMATIC VSA RESTORE JOBS WHICH HAVE ALREADY RUN AND NEW BACKUP HAS NOT COMPLETED
				(
					VR.status IN (@VSAREP_PAUSED, @VSAREP_COMPLETE, @VSAREP_ENABLED, @VSAREP_PENDING, @VSAREP_STARTING, @VSAREP_RUNNING, @VSAREP_FAILED, @VSAREP_REVERT_FAILED)
AND freq_type = 4096
					AND RT.flags NOT IN (@VSAREP_VALIDATION_FAILED)
					AND CAST(VR.spare2 AS INT) > RT.lastSuccessBkupTime	--ONLY REMOVE THESE ENTRIES FOR WHICH A NEW BACKUP JOB HAS NOT BEEN RUN (DELETE ENTRY WHEN LAST REP TIME > LAST BACKUP TIME)
				)
				OR
				--REMOVE VMS SET FOR REVERSE REPLICATION. DO NOT START JOBS FOR THESE VMS
				RT.flags & @VSAREP_REVERSE_REP = @VSAREP_REVERSE_REP
			)
			AND copyPrecedenceApplicable = 0	--DO THIS ONLY FOR BACKUP JOBS
			--IF JOB WITH TO TIME HAS ALREDY RUN DO NOT START IT AGAIN
			DELETE #completedPattern_VsaInfoTable
			WHERE replicationId IN (
				SELECT T.repId
				FROM #completedPattern_VsaInfoTable V
				JOIN #toTime_InfoTable T ON T.repId = V.replicationId
				WHERE T.toTime = V.lastSuccessBkupTime
				AND V.flags NOT IN (@VSAREP_VALIDATION_FAILED)
			)
			AND copyPrecedenceApplicable = 1
			IF NOT EXISTS(SELECT * FROM #completedPattern_VsaInfoTable)
			BEGIN
				SET @oErrorString = 'Replication job already ran'
				GOTO EXIT_VSA
			END
			--REMOVE ANY REGULAR SCHEDULES WHICH HAVE NOT STARTED
			DELETE #completedPattern_VsaInfoTable
			FROM #completedPattern_VsaInfoTable RT
WHERE apId = 106
AND opType = 1007
			AND
			(
				status NOT IN (@VSAREP_PENDING)
				OR
				(
freq_type != 4096
					AND maxNumOfVMPerJob > 0
					AND
					(
						--ANY REGULAR SCHEDULES WHICH HAVE VM STARTED BY IMMEDIATE REQUEST, MEANS THAT SCHEDULE HAS NOT RUN SO DON'T TRY TO START JOB FOR OTHER VMS
						EXISTS (SELECT 1 FROM #completedPattern_VsaInfoTable V WHERE V.stId = RT.stId AND flags & @STARTED_SYNC_IMMEDIATE = @STARTED_SYNC_IMMEDIATE)
						OR
						--ANY REGULAR SCHEDULES WHICH HAVE NOT STARTED TO AVOID STARTING THEM
						EXISTS (SELECT 1 FROM #completedPattern_VsaInfoTable V
												WHERE V.stId = RT.stId
												GROUP BY V.stId
												HAVING MAX(V.lastScheduleRunTime) < MAX(V.lastSuccessBkupTime)
								)
					)
				)
			)
--
			SET @oErrorString = 'Failed after completing step 3b'
			IF NOT EXISTS(SELECT * FROM #completedPattern_VsaInfoTable)
			BEGIN
				SET @oErrorString = 'All VMs are in sync. Nothting to run'
				GOTO EXIT_VSA
			END
			--REMOVE ANY VSA RESTORE JOBS WHICH ARE RUNNING OR SCHEDULER HAS SUBMITED TO JM
			DELETE #completedPattern_VsaInfoTable
			FROM
			(	--CHECK REPLICATION ID OF THE JOB THAT IS RUNNING
				SELECT vs.value('@id1', 'INT') repId, T.taskId
				FROM
				(
					SELECT R.xmlValue, R.taskId
					FROM #xmlOption_InfoTable R
					WHERE R.state IN (@STATE_RUNNING, @STATE_PENDING)
				) T
				CROSS APPLY T.xmlValue.nodes('/TMMsg_EntityListResp/entities') V(vs)
			) D
			WHERE tkId = D.taskId AND replicationId = D.repId
			IF (@intervalBetweenV2JobsSecs>0)
			BEGIN
				-- For V2 have interval between jobs to aggregate VMs as much as possible @intervalBetweenV2JobsSecs.
				-- Do this for live sync schedule created at VSA subclient instead of at vm  level.
				DELETE #completedPattern_VsaInfoTable
				FROM #completedPattern_VsaInfoTable VT
				INNER JOIN TM_SubtaskOptions (NOLOCK) ON TM_SubtaskOptions.subtaskId = VT.stID
				AND TM_SubtaskOptions.optionId = 120019			-- RST_LAST_REPLICATION_RUNTIME
				AND CAST(TM_SubtaskOptions.Value AS INT)+@intervalBetweenV2JobsSecs > @nowUtcUnix
AND VT.freq_type = 4096
				AND VT.isIndexingV2Enabled = 1
				-- And if there is vm with validation failed status then dont wait for interval
				LEFT JOIN
				(
					SELECT tkId taskId FROM #completedPattern_VsaInfoTable
					WHERE status = @VSAREP_VALIDATION_FAILED
				) ValFailed ON ValFailed.taskId = VT.tkId
				WHERE ValFailed.taskId IS NULL
			END
			SET @oErrorString = 'Failed after completing step 4'
			IF NOT EXISTS(SELECT * FROM #completedPattern_VsaInfoTable)
			BEGIN
				SET @oErrorString = 'Jobs are running for all schedules'
				GOTO EXIT_VSA
			END
			-- Delete for which operation window for restore operation type isnt met.
--- CODE BELOW HERE IS FROM TM_AppIdTblCreate.spb  ----------
		-------------------------------
		--CREATE TEMP TABLE------------
		-------------------------------
		-- None of these temp tables should ever exist when this procedure is called!
		if object_id('tempdb.dbo.#appIdTbl') is not null
    		DROP TABLE #appIdTbl
		CREATE TABLE #appIdTbl (
			appId INT,
			appTypeId INT,
			clientId INT,
			instanceId INT,
			backupsetId INT,
			STATUS INT,
			bkpLevel INT,
			storagePolicy INT,
timezoneName nvarchar(255) DEFAULT '',
			ignoreHigherLevelOpWindowRules	INT DEFAULT 0,
			jmOperationType INT DEFAULT 0,
			taskID			INT DEFAULT 0,
			parentJobId int DEFAULT 0,
			parentAppID int DEFAULT 0,
			vmDiscovered INT DEFAULT 0,
			utcdateTime     DATETIME DEFAULT '1970-01-01 00:00:00.000', -- Needed for Predict SLA project where we need to identify if backup time is outside operation window.
			stID		INT DEFAULT 0
		)
		CREATE CLUSTERED INDEX appIdTbl_idx ON #appIdTbl (appId)
		CREATE NONCLUSTERED INDEX appIdTbl_clientId_idx ON #appIdTbl ([clientId])
		CREATE NONCLUSTERED INDEX appIdTbl_appTypeId_idx ON #appIdTbl ([appTypeId])
		CREATE NONCLUSTERED INDEX appIdTbl_timezoneName_idx ON #appIdTbl ([timezoneName])
--- CODE ABOVE HERE IS FROM TM_AppIdTblCreate.spb  ----------
			UPDATE completedPattern_VsaInfoTable
			SET destClientID = CASE WHEN TM_Subtaskoptions.value IS NOT NULL THEN CAST(TM_Subtaskoptions.value AS INT) ELSE completedPattern_VsaInfoTable.clId END
			FROM #completedPattern_VsaInfoTable completedPattern_VsaInfoTable
			LEFT JOIN TM_Subtaskoptions WITH (NOLOCK) on completedPattern_VsaInfoTable.stId=TM_Subtaskoptions.subtaskId
AND TM_Subtaskoptions.optionId=293753447
			AND ISNUMERIC(TM_Subtaskoptions.Value) = 1
			INSERT INTO #appIdTbl(clientId, appTypeID, taskId, jmOperationType)
			SELECT DISTINCT destClientID , apId, tkId, 8 --OPERATION_DATA_RECOVERY
			FROM #completedPattern_VsaInfoTable
			EXEC TMFilterSubclientsByOperationWindow 1
			-- Remove entries where operation window isnt met.
			DELETE completedPattern_VsaInfoTable FROM #completedPattern_VsaInfoTable completedPattern_VsaInfoTable
			LEFT JOIN #appIdTbl appIdTbl ON completedPattern_VsaInfoTable.destClientId = appIdTbl.clientID AND completedPattern_VsaInfoTable.apId = appIdTbl.appTypeID
			AND completedPattern_VsaInfoTable.tkID = appIdTbl.taskId
			WHERE appIdTbl.taskId IS NULL
			-- DELETE ENTRIES FOR WHICH THE LAST REPLICATION JOB WAS RAN IN LESS THAN 20 MINUTES AND FAILED (IN SYNC PENDING STATE)
			DELETE completedPattern_VsaInfoTable
			FROM #completedPattern_VsaInfoTable completedPattern_VsaInfoTable
JOIN APP_VSAReplicationProp prop ON completedPattern_VsaInfoTable.status = @VSAREP_PENDING AND prop.propertyTypeId = 2215 AND completedPattern_VsaInfoTable.replicationId = prop.replicationId
			JOIN JMRestoreStats jmrststats ON jmrststats.jobId = CAST(prop.propertyValue AS INT)
			AND jmrststats.status IN (2,4)  -- FAIL=2,Killed = 4
			WHERE datediff(minute, dbo.getdatetime(jmrststats.servEndTime), getutcdate()) < 20 -- 20 MINUTES
		--REPOPULATE ENTRIES IN TEMP TABLE USED TO START THE JOBS
			--INSERT VMS WITHOUT THE STATUS OR MULBIPLE ENTRIES WILL BE CREATED FOR THAT SCHEDULE
			INSERT #completedPattern_runTimeInfoTable
			(stId, taskId, patId, cgId, clId, apId, instId, bsId, scId, lastSuccessBkupTime, opType, freq_type, tkDisabled, status, maxNumOfVMPerJob, copyPrecedenceApplicable, copyPrecedence)
			SELECT DISTINCT stId, tkId, patId, cgId, clId, apId, instId, bsId, 0, MAX(lastSuccessBkupTime), opType, freq_type, tkDisabled, 0, 0 maxNumOfVMPerJob, 0, 0
			FROM #completedPattern_VsaInfoTable
			GROUP BY stId, tkId, patId, cgId, clId, apId, instId, bsId, opType, freq_type, tkDisabled
--
			--SET STATUS WHEN REPLICATIONS ARE PENDING
			UPDATE #completedPattern_runTimeInfoTable
			SET status = ISNULL((
				SELECT TOP 1 status FROM #completedPattern_VsaInfoTable
				WHERE tkId = taskId
				AND status IN (@VSAREP_PENDING, @VSAREP_FAILED, @VSAREP_REVERT_FAILED)
				AND EXISTS (SELECT * FROM #completedPattern_VsaInfoTable WHERE tkId = taskId AND status = @VSAREP_JOB_QUEUED)
				ORDER BY status
				), status)
			--SET STATUS WHEN THERE'S NO REPLICATION PENDING
			UPDATE #completedPattern_runTimeInfoTable
			SET status = ISNULL((
				SELECT TOP 1 status FROM #completedPattern_VsaInfoTable
				WHERE tkId = taskId
				AND NOT EXISTS (SELECT * FROM #completedPattern_VsaInfoTable WHERE tkId = taskId AND status = @VSAREP_JOB_QUEUED)
				ORDER BY status DESC, lastVSATime
				), status)
			--REMOVE ANY SCHEDULES THAT ONLY HAVE ENTRIES WITH QUEUE STATUS TO AVOID STARTING JOBS
			DELETE #completedPattern_runTimeInfoTable
WHERE apId = 106 AND opType = 1007
			AND
			NOT EXISTS (SELECT * FROM #completedPattern_VsaInfoTable WHERE tkId = taskId AND status <> @VSAREP_JOB_QUEUED)
			--AVOID STARTING JOBS FOR ENTRIES THAT ARE IN QUEUE STATE
			DELETE #completedPattern_VsaInfoTable
			WHERE status = @VSAREP_JOB_QUEUED
			--SET STATUS BASED ON FLAGS WHEN REVERT STATUS IS STORED IN FLAGS OR REGULAR SCHEDULES WILL BE DELETED WHEN CHECKING FOR maxNumOfVMPerJob BELOW
			UPDATE #completedPattern_runTimeInfoTable
			SET status = ISNULL((
				SELECT TOP 1 flags FROM #completedPattern_VsaInfoTable
				WHERE tkId = taskId
AND freq_type != 4096
AND opType = 1007
				AND flags IN (@VSAREP_VALIDATION_FAILED)
				ORDER BY lastVSATime
				), status)
			--DELETE REGULAR SCHEDULES FOR WHICH MAX VM OPTION IS NOT SET
			DELETE #completedPattern_runTimeInfoTable
WHERE freq_type != 4096
AND opType = 1007
			AND status NOT IN (@VSAREP_VALIDATION_FAILED)	--START JOB FOR ANY VM THAT NEEDS REVERT
			AND
			(
				maxNumOfVMPerJob = 0 OR maxNumOfVMPerJob IS NULL
			)
			--UPDATE THE SCHEDULE RUN TIME COLUMN FOR THOSE ENTRIES WHICH ARE GOING TO START A JOB
			UPDATE APP_VSAReplication
			SET spare2 = @nowUtcUnix,
			spare3 = @nowUtcUnix,
			status = @VSAREP_STARTING
			FROM
			(
				SELECT V.replicationId, V.spare2
				FROM #completedPattern_runTimeInfoTable R
				JOIN #completedPattern_VsaInfoTable	V ON V.tkId = R.taskId --AND R.freq_type = FREQ_TYPE_After_Job_Completes
					AND V.status = R.status AND R.status = @VSAREP_PENDING
			) T
			WHERE T.replicationId = APP_VSAReplication.replicationId
		END
--
		--DELETE DISABLED SCHEDULES
		DELETE #completedPattern_runTimeInfoTable
		WHERE tkDisabled != 0
		--START JOB FOR THOSE ENTRIES WHICH ARE LEFT
		SET @oErrorString = 'Failed after completing step 6'
		--ADD TM_RUNTIME TABLE
		INSERT TM_RunTime
		(patternId, occurence, flags, nextRunTime, processed, firing, nextTime)
			OUTPUT INSERTED.runTimeId, INSERTED.patternId
				INTO @runTimeTable
		SELECT distinct R.patId, 1, 0, @nowTime, 0, 0, @nowTimeUnix
		FROM #completedPattern_runTimeInfoTable R
		--JOIN APP_VSAReplication VR WITH (NOLOCK) ON VR.taskId = R.tkId
		SET @oErrorString = 'Failed after completing step 7'
		--ADD TM_RUNTIMEASSOC TABLE
		INSERT TM_RunTimeAssoc
		(runTimeId, timeZoneNames, nextRunTime, flags, processed, firing)
		SELECT distinct RT.runTimeId, @timeZoneName, @nowTime, 0, 0, 0
		FROM TM_RunTime RT WITH (NOLOCK)
		JOIN #completedPattern_runTimeInfoTable R ON R.patId = RT.patternId AND RT.processed = 0
		JOIN @runTimeTable T ON T.runTimeId = RT.runTimeId		--REGULAR SCHEDULES ALREDAY HAVE AN ENTRY IN TM_RunTime WITH processed = 0. ONLY INSERT NEW ENTRIES ADDED ABOVE
		SET @oErrorString = ''
	END
EXIT_VSA:
	IF @oErrorCode = 0
	BEGIN
		IF @logChanges = 1 AND EXISTS(SELECT 1 FROM #output_VsaInfoTable)
		begin
			declare @loggingResponse xml
			SET @loggingResponse = (
				SELECT @oErrorString '@info',
				(
					SELECT
					(
						SELECT VS.tkId '@taskId', VS.stId '@subTaskId', VS.patId '@patternId', R.runTimeId '@runTimeId',
						(
							SELECT V.replicationId '@replicationId', V.action '@action',
							statusIn '@statusIn', statusOut '@statusOut', spare2In '@spare2In', spare2Out '@spare2Out',
							spare3In '@spare3In', spare3Out '@spare3Out', lastBackupTimeIn '@lastBackupTimeIn', lastBackupTimeOut '@lastBackupTimeOut',
							bkpJobsToSyncIn '@bkpJobsToSyncIn', bkpJobsToSyncOut '@bkpJobsToSyncOut'
							FROM #output_VsaInfoTable V
							WHERE V.tkId = VS.tkId
							AND V.replicationId = VS.replicationId
							AND V.action<>'DELETED'
							FOR XML PATH('siteInfo'), TYPE
						)
						FOR XML PATH('subTaskInfo'), TYPE
					)
					FROM #completedPattern_VsaInfoTable VS
					LEFT OUTER JOIN @runTimeTable R ON R.patternId = VS.patId
					FOR XML PATH(''), TYPE
				)
				FOR XML PATH('LoggingVSAResponse')
			)
			declare @deletedSiteInfoxml xml
			set @deletedSiteInfoxml = (SELECT V.tkId '@taskId', V.replicationId '@replicationId', VR.sourceGuid '@sourceGuid'
						FROM #output_VsaInfoTable V
						left join App_VSAReplication VR on
						V.replicationId=VR.replicationId
						WHERE V.action='DELETED'
						for xml path('deletedReplications'))
			SET @loggingResponse.modify('insert ( sql:variable("@deletedSiteInfoxml")) into (LoggingVSAResponse)[1]')
			set @oErrorString = convert(nvarchar(max),@loggingResponse)
		end
		ELSE
			SET @oErrorString = ''
		--COPY CODE FROM MAINTENANCE THREAD SINCE THIS CODE RUNS EVERY 40sec. AND IT MAKE TAKE UP TO 4 HOURS FOR ENTRY TO BE DELETED SINCE THAT THREAD RUNS EVERY 4 HOURS
		--IT MAY APPEAR TO USER THAT VM IS NOT DELETED SINCE IT MIGHT NOT GET REMOVED FROM MONITOR UNTIL MAINTANCE THREAD RUNS.
		--ALSO, IF VM IS RE-ADDED TO SCHEDULE THERE MAY BE SOME ISSUES DURING REPLICATION IF OLD ENTRY IS STILL THERE AND IT LOOKS LIKE SOME CUSTOMERS ARE CONSTANTLY REMOVING AND ADDING BACK VMS
		IF object_id('tempdb.dbo.#replicationIdTable') is not null
			DROP TABLE #replicationIdTable
		--DO ALL NECESSARY CHECKS BEFORE DELETING ENTRIES
		SELECT T.replicationId
		INTO #replicationIdTable
		FROM
		(
			--CHECK FOR SCHEDULE HAVING BEEN DELETED
			SELECT replicationId, taskId
			FROM APP_VSAReplication VR
			WHERE NOT EXISTS (SELECT * FROM TM_Task T WITH (NOLOCK) WHERE T.taskId = VR.taskId)	--SCHEDULE NOT FOUND
			UNION
			--CHECK FOR VM MARKED DELETED IN REPLICATION TABLE
			SELECT replicationId, taskId
			FROM APP_VSAReplication VR
			WHERE flags & @VSAREP_DELETED = @VSAREP_DELETED		--MARK FOR DELETION
			UNION
			-- we need to handle schedules (created from replication plan) which are not associated to any subclient now
			-- and has replications to be cleaned up.
			SELECT VR.replicationId, VR.taskId
			FROM App_VsaReplication VR WITH (NOLOCK)
			JOIN TM_Task T WITH (NOLOCK) ON T.taskId = VR.taskId
			LEFT JOIN TM_AssocEntity AE WITH (NOLOCK) ON AE.taskId = VR.taskId
			WHERE AE.taskId IS NULL -- This schedule is not associated to any subclient now but has replications which needs to be cleaned up
		) T
		WHERE
			--MAKE SURE THAT THERE ARE NO JOBS RUNNING FOR THE THIS SCHEDULE
			NOT EXISTS (
			SELECT 1 FROM JMRstJobInfo JR WITH (NOLOCK) --TABLE STORES THE SUBTASK NOT THE TASK ID
			JOIN TM_SubTask S (NOLOCK) ON S.subTaskId = JR.rstTaskID	--ONLY WAY TO GET THE TASK ID IF TASK IS DELETED
			WHERE S.taskId = T.taskId
			)
		--ADD TRY/CATCH BLOCK TO AVOID HAVING ANY POSSIBLE EXCEPTION DURING DELETION
    	BEGIN TRY
			update T
			set deleted =1
			from TM_Task T
			inner join APP_VSAReplicationProp prop
on prop.propertyTypeId = 2212
			and prop.modified =0
			and prop.propertyValue = T.taskid
			inner join #replicationIdTable rep
			on prop.replicationId = rep.replicationId
			DELETE APP_VSAReplicationProp
			FROM APP_VSAReplicationProp
			WHERE replicationId IN (SELECT replicationId FROM #replicationIdTable)
			DELETE APP_VSAReplication
			WHERE replicationId IN (SELECT replicationId FROM #replicationIdTable)
	    END TRY
	    BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	      	SET @oErrorString = 'Error deleting VM from replication table'
	    END CATCH
		IF object_id('tempdb.dbo.#replicationIdTable') is not null
			DROP TABLE #replicationIdTable
	END
	IF object_id('tempdb.dbo.#completedPattern_initVsaInfoTable') is not null
		DROP TABLE #completedPattern_initVsaInfoTable
	IF object_id('tempdb.dbo.#completedPattern_vmInfoTable') is not null
		DROP TABLE #completedPattern_vmInfoTable
	IF object_id('tempdb.dbo.#completedPattern_VsaInfoTable') is not null
		DROP TABLE #completedPattern_VsaInfoTable
	IF object_id('tempdb.dbo.#completedPattern_runTimeInfoTable') is not null
		DROP TABLE #completedPattern_runTimeInfoTable
	IF object_id('tempdb.dbo.#completedPattern_InfoTable') is not null
		DROP TABLE #completedPattern_InfoTable
	IF object_id('tempdb.dbo.#output_VsaInfoTable') is not null
		DROP TABLE #output_VsaInfoTable
	IF object_id('tempdb.dbo.#auxCopyTable') is not null
		DROP TABLE #auxCopyTable
	IF object_id('tempdb.dbo.#xmlOption_InfoTable') is not null
		DROP TABLE #xmlOption_InfoTable
    IF object_id('tempdb.dbo.#taskReplicationguidPair') is not null
		DROP TABLE #taskReplicationguidPair
	IF object_id('tempdb.dbo.#xmltoTimeOption_InfoTable') is not null
		DROP TABLE #xmltoTimeOption_InfoTable
	IF object_id('tempdb.dbo.#toTime_InfoTable') is not null
		DROP TABLE #toTime_InfoTable
	IF object_id('tempdb.dbo.#subclientContent_InfoTable') is not null
		DROP TABLE #subclientContent_InfoTable
	IF object_id('tempdb.dbo.#subclientListTbl') is not null
		DROP TABLE #subclientListTbl
    IF object_id('tempdb.dbo.#taskReplicationguidPair') is not null
		DROP TABLE #taskReplicationguidPair
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetVSAJobCompletedPatterns')
	delete from GxQscripts where name = 'TM_GetVSAJobCompletedPatterns'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetVSAJobCompletedPatterns')
	delete from GXDBVersions where aliasname = 'TM_GetVSAJobCompletedPatterns'
GO

insert into GXDBVersions values(2, 'TM_GetVSAJobCompletedPatterns',  'v1.1.2.63.16.1', 'TM_GetVSAJobCompletedPatterns', 'v1.1.2.63.16.1')
GO

