

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetTimeZoneList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetTimeZoneList.sp,v $ $Id: TM_GetTimeZoneList.sp,v 1.10.210.1 2017/02/10 20:42:00 sjohnson Exp $";
---- =============================================
---- Author:		Anand Vibhor
---- Create date:	01/28/2006
---- Description:	Get the static list of timezones
---- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_GetTimeZoneList <<<'

IF EXISTS (select * from sysobjects where name='TM_GetTimeZoneList')
	drop procedure TM_GetTimeZoneList
IF EXISTS (select * from GxQscripts where name='TM_GetTimeZoneList')
	delete from GxQscripts where name = 'TM_GetTimeZoneList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetTimeZoneList')
	delete from GXDBVersions where aliasname = 'TM_GetTimeZoneList'
GO
print '... Creating Procedure: TM_GetTimeZoneList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_GetTimeZoneList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
AS
BEGIN
  DECLARE @xmlText XML 
	SET @xmlText = (
		SELECT [TimeZoneID] '@TimeZoneID',
		[TimeZoneName]  '@TimeZoneName',
		[TimeZoneStdName]  '@TimeZoneStdName',
		[DSTFlag] '@DSTFlag',
		((24 * 60 * 60)-[Bias]) '@Bias',
		((24 * 60 * 60)-[DSTBias]) '@DSTBias',
		[STDMonth] '@STDMonth',
		[STDDayOfWeek]'@STDDayOfWeek',
		[STDDay] '@STDDay',
		[STDSeconds]/60 '@STDSeconds',
		[STDBias] '@STDBias',
		[DSTMonth] '@DSTMonth',
		[DSTDayOfWeek]'@DSTDayOfWeek',
		[DSTDay] '@DSTDay',
		[DSTSeconds]/60 '@DSTSeconds'
FROM [SchedTimeZone] WHERE TimeZoneID > 0 AND (Flags & CONVERT(int, 0x1)) <> 0x1 ORDER BY Bias
		FOR XML PATH('timeZone'), ROOT('TMMsg_TimeZoneListResp')
	)
SELECT @xmlText AS o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetTimeZoneList')
	delete from GxQscripts where name = 'TM_GetTimeZoneList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetTimeZoneList')
	delete from GXDBVersions where aliasname = 'TM_GetTimeZoneList'
GO

insert into GXDBVersions values(2, 'TM_GetTimeZoneList',  '00010010021000010000', 'TM_GetTimeZoneList', '00010010021000010000')
GO

