

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetTasksWithOption.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetTasksWithOption.sp,v $ $Id: TM_GetTasksWithOption.sp,v 1.5 2011/06/06 20:57:31 sbonilla Exp $";
---- =============================================
---- Author:		Sergio Bonilla
---- Create date:	09/28/2010
---- Description:	Get the schedules which have a specific optionId with optional option value.
---- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_GetTasksWithOption <<<'

IF EXISTS (select * from sysobjects where name='TM_GetTasksWithOption')
	drop procedure TM_GetTasksWithOption
IF EXISTS (select * from GxQscripts where name='TM_GetTasksWithOption')
	delete from GxQscripts where name = 'TM_GetTasksWithOption'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetTasksWithOption')
	delete from GXDBVersions where aliasname = 'TM_GetTasksWithOption'
GO
print '... Creating Procedure: TM_GetTasksWithOption'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_GetTasksWithOption
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @optionId bigint,
  @userId integer=1,
  @localeId_in integer=0,
  @optionValue NVARCHAR(MAX)=''
AS
  DECLARE @o_taskId INT
  DECLARE @o_subTaskId INT
  DECLARE @o_subTaskType INT
BEGIN
DECLARE @subTaskTable TABLE (taskId int, subTaskId int, subTaskType int)
	INSERT INTO @subTaskTable
	SELECT [taskId], [subTaskId], [subTaskType]
	FROM TM_SubTask WITH (NOLOCK)
	WHERE [subTaskId] IN (SELECT [subTaskId] FROM TM_SubTaskOptions WITH (NOLOCK) WHERE [optionId] = @optionId AND ([value] = @optionValue OR @optionValue = ''))
	SELECT taskId as [o_taskId], subTaskId as [o_subTaskId], subTaskType as [o_subTaskType] FROM @subTaskTable
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetTasksWithOption')
	delete from GxQscripts where name = 'TM_GetTasksWithOption'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetTasksWithOption')
	delete from GXDBVersions where aliasname = 'TM_GetTasksWithOption'
GO

insert into GXDBVersions values(2, 'TM_GetTasksWithOption',  '00010005000000000000', 'TM_GetTasksWithOption', '00010005000000000000')
GO

