

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetTaskList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetTaskList.sp,v $ $Id: TM_GetTaskList.sp,v 1.176.48.13 2019/10/29 18:16:35 rengu Exp $";
-- =============================================
-- Author:		Anand Vibhor
-- Create date: 01/28/2006
-- Description:	Get the list of schedules.
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='TM_GetTaskList')
BEGIN
	print '>>> Drop Stored Procedure: TM_GetTaskList <<<'
	drop procedure TM_GetTaskList
END
IF EXISTS (select * from GxQscripts where name='TM_GetTaskList')
	delete from GxQscripts where name = 'TM_GetTaskList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetTaskList')
	delete from GXDBVersions where aliasname = 'TM_GetTaskList'
GO
print '... Creating Procedure: TM_GetTaskList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_GetTaskList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userId integer,
  @localeId_in integer,
  @xmlText XML OUTPUT,
  @toOutput integer = 0
AS
BEGIN
SET NOCOUNT ON
	DECLARE @instanceId INT
	DECLARE @backupsetId INT
	DECLARE @subclientId INT
	DECLARE @appTypeId INT
	DECLARE @clientId INT
	DECLARE @clientGroupId INT
	DECLARE @srmReportSet INT
	DECLARE @srmReportType INT
	DECLARE @spName NVARCHAR(255)
	DECLARE @position INT
	DECLARE @savedReports INT
	DECLARE @agentlessSRM INT
	DECLARE @policy INT
	DECLARE @schedules INT
	DECLARE @otherReports INT
	DECLARE @libraryId INT
	DECLARE @copyId INT
	DECLARE @policyId INT
	DECLARE @configPolicyId INT
	DECLARE @mediaAgentId INT
	DECLARE @trackingPolicyId INT
	DECLARE @agentlessPolicyId INT
	DECLARE @srmTemplateId INT
	DECLARE @cdPolicyId INT
	DECLARE @instanceName NVARCHAR(MAX)
	DECLARE @backupsetName  NVARCHAR(MAX)
	DECLARE @subclientName  NVARCHAR(MAX)
	DECLARE @appName  NVARCHAR(MAX)
	DECLARE @clientName  NVARCHAR(MAX)
	DECLARE @clientGroupName  NVARCHAR(MAX)
	DECLARE @invalidEntityName NVARCHAR(MAX)
	DECLARE @workFlowId INT
	DECLARE @isWorkFlow int
	DECLARE @dataSourceId INT
	DECLARE @base BIGINT
	DECLARE @isCalendar INT = 0
	DECLARE @isSRMReports INT = 0
	DECLARE @automaticSchedules INT = 0
	DECLARE @isUserAdmin INT = 0
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX) = ''
	set @base = 2
DECLARE @_EV_VIEW					BIGINT = POWER(@base, 31-1)
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--GET SMART SCHEDULES FLAG
	SET @automaticSchedules = ISNULL(( SELECT ref.value('@automaticSchedules',
													'int')
									FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
								), 0)
	IF @automaticSchedules = 1
	BEGIN
		EXEC TM_GetOSCTaskList @userId, @localeId_in, @xmlText OUTPUT
		GOTO EXIT_GET_TASK_LIST
	END
--INITIALIZATION
	DECLARE @taskTble TABLE ( taskId INT )
	DECLARE @clientTable TABLE ( clientId INT )
	DECLARE @operationFilter TABLE ( operationType INT )
	DECLARE @subTaskFilter TABLE ( subTaskType INT )
	DECLARE @entityCount TABLE ( taskId INT, nCount INT )
	--GET POLICY FLAG
	SET @policy = ISNULL(( SELECT  ref.value('@policy', 'int')
	FROM    @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
							), 0)
	--GET SCHEDULE FLAG
	SET @schedules = ISNULL(( SELECT ref.value('@schedules', 'int')
								FROM @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
							), 0)
	SET @isWorkFlow = ISNULL(( SELECT ref.value('@isWorkflow', 'int')
								FROM @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
							), 0)
	IF ( @policy = 1 )
	AND ( @schedules = 0 )
	BEGIN
		EXEC TM_GetPolicyTaskList @userId, @localeId_in, @xmlText OUTPUT
		GOTO EXIT_GET_TASK_LIST
	END
	IF object_id('tempdb.dbo.#entitiesWithViewSchedCapability') is not null
		DROP TABLE #entitiesWithViewSchedCapability
create table  #entitiesWithViewSchedCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	IF object_id('tempdb.dbo.#subTaskList') is not null
			DROP TABLE #subTaskList
	CREATE TABLE #subTaskList (subTaskId INT NOT NULL)
	CREATE CLUSTERED INDEX subTaskList_subTaskId_Index ON #subTaskList (subTaskId)
EXEC sec_getNonIdaObjectsForThisUser @userId, 68, 0, '#subTaskList'
	-- For all subtasks which are explcility associated to user, add their tasks to #entitiesWithViewSchedCapability
	-- Also add all associations for schedules which are shared with this user. Created by tenant admin if the logged in user is part of tenant admin group.
	INSERT INTO #entitiesWithViewSchedCapability(capabilities, TaskId)
	SELECT DISTINCT @_EV_VIEW, TM_Subtask.taskId -- Assign view capabilities to this taskId
	FROM #subTaskList subTaskList
	INNER JOIN TM_Subtask ON TM_Subtask.subtaskId = subTaskList.subtaskId
	IF @policy = 1
	AND @schedules = 1
	BEGIN
		--GET CLIENT GROUP
		SET @clientGroupId = ISNULL(( SELECT ref.value('@clientGroupId', 'int')
									FROM @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
									), 0)
		--GET CLIENT
		SET @clientId = ISNULL(( SELECT ref.value('@clientId', 'int')
								FROM   @xmlText.nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
								), 0)
		--GET APPTYPE
		SET @apptypeId = ISNULL(( SELECT    ref.value('@applicationId', 'int')
									FROM      @xmlText.nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
								), 0)
		--GET INSTANCE
		SET @instanceId = ISNULL(( SELECT   ref.value('@instanceId', 'int')
									FROM     @xmlText.nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
									), 0)
		--GET BACKUPSET
		SET @backupsetId = ISNULL(( SELECT  ref.value('@backupsetId', 'int')
									FROM    @xmlText.nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
									), 0)
		--GET SUBCLIENT
		SET @subclientId = ISNULL(( SELECT ref.value('@subclientId', 'int')
									FROM @xmlText.nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
									), 0)
		--GET STORAGE POLICY ID
		SET @policyId = ISNULL(( SELECT ref.value('@storagePolicyId', 'int')
									FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
								), 0)
		--GET STORAGE COPY ID
		SET @copyId = ISNULL(( SELECT   ref.value('@copyId', 'int')
								FROM     @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
								), 0)
		--GET STORAGE COPY ID
		SET @libraryId = ISNULL(( SELECT   ref.value('@libraryId', 'int')
								FROM     @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
								), 0)
		--GET Configuration Policy ID
		SET @configPolicyId = ISNULL(( SELECT   ref.value('@policyId', 'int')
								FROM     @xmlText . nodes('TMMsg_GetTaskListReq/filter/configPolicyEntity') R ( ref )
								), 0)
		--GET Inventory(datasource) Id
		SET @dataSourceId = ISNULL(( SELECT   ref.value('@seaDataSourceId', 'int')
								FROM     @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
								), 0)
		SELECT  @clientGroupName=ISNULL(ref.value('@clientGroupName','NVARCHAR(MAX)'), ''), @clientName=ISNULL(ref.value('@clientName','NVARCHAR(MAX)'), ''), @appName=ISNULL(ref.value('@appName','NVARCHAR(MAX)'), ''),
				@instanceName=ISNULL(ref.value('@instanceName','NVARCHAR(MAX)'), ''), @backupsetName=ISNULL(ref.value('@backupsetName','NVARCHAR(MAX)'), ''), @subclientName=ISNULL(ref.value('@subclientName','NVARCHAR(MAX)'), '')
		FROM    @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
--
		IF @clientGroupId <= 0 AND @clientGroupName <> ''
		BEGIN
SET @errorCode = (1861 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @invalidEntityName = @clientGroupName
			GOTO EXIT_GET_TASK_LIST
		END
		ELSE IF @clientId <= 0 AND @clientName <> ''
		BEGIN
SET @errorCode = (1862 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @invalidEntityName = @clientName
			GOTO EXIT_GET_TASK_LIST
		END
		ELSE IF @appTypeId <= 0 AND @appName <> ''
		BEGIN
SET @errorCode = (1860 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @invalidEntityName = @appName
			GOTO EXIT_GET_TASK_LIST
		END
		ELSE IF @instanceId <= 0 AND @instanceName <> ''
		BEGIN
SET @errorCode = (1863 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @invalidEntityName = @instanceName
			GOTO EXIT_GET_TASK_LIST
		END
		ELSE IF @backupsetId <= 0 AND @backupsetName <> ''
		BEGIN
SET @errorCode = (2056 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @invalidEntityName = @backupsetName
			GOTO EXIT_GET_TASK_LIST
		END
		ELSE IF @subclientId <= 0 AND @subclientName <> ''
		BEGIN
SET @errorCode = (2057 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @invalidEntityName = @subclientName
			GOTO EXIT_GET_TASK_LIST
		END
		EXEC sec_getUserObjects @userId, 0, 0, '#entitiesWithViewSchedCapability'
		-- needed so that we can join on a user with no privilages
		IF (SELECT COUNT(*) FROM #entitiesWithViewSchedCapability) = 0
		--AVOID DUPLICATE ROWS WHEN CHECKING OWNER
		BEGIN
			INSERT INTO #entitiesWithViewSchedCapability (capabilities, flag, commCellId, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subClientId,
			mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId, reviewSetId, querySetId, downloadSetId, ermId, legalHoldId, tagId, cdPolicyId, complianceReportId, taskId)
			VALUES (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
		END
		IF @clientGroupId = 0
		AND @clientId = 0
		AND @apptypeId = 0
		AND @instanceId = 0
		AND @backupsetId = 0
		AND @subclientId = 0
		AND @policyId = 0
		AND @copyId = 0
		AND @libraryId = 0
		AND @configPolicyId = 0
		AND @dataSourceId = 0
		BEGIN
			EXEC TM_GetCommCellTaskList @userId, @localeId_in, @xmlText OUTPUT
			GOTO EXIT_GET_TASK_LIST
		END
		ELSE
		BEGIN
			IF @policyId = 0
			AND @copyId = 0
			AND @libraryId = 0
			AND @configPolicyId = 0
			AND @dataSourceId = 0
			BEGIN
				IF (@subclientId <> 0)	--GET MISSING INFO USING SC ID
				BEGIN
					SELECT TOP 1 @clientId=clientId, @appTypeId=appTypeId, @instanceId=instance, @backupSetId=backupSet FROM APP_Application WITH(NOLOCK) WHERE (id=@subclientId OR @subclientId=0) AND (clientId=@clientId OR @clientId=0) AND
							(appTypeId=@appTypeId OR @appTypeId=0) AND (instance=@instanceId OR @instanceId=0) AND (backupSet=@backupSetId OR @backupSetId=0)
				END
				ELSE IF (@backupSetId <> 0)	--GET MISSING INFO EXCEPT SC ID USING BS ID
				BEGIN
					SELECT TOP 1 @clientId=clientId, @appTypeId=appTypeId, @instanceId=instance FROM APP_Application WITH(NOLOCK) WHERE (id=@subclientId OR @subclientId=0) AND (clientId=@clientId OR @clientId=0) AND
							(appTypeId=@appTypeId OR @appTypeId=0) AND (instance=@instanceId OR @instanceId=0) AND (backupSet=@backupSetId)
				END
				ELSE IF (@instanceId <> 0)	--GET MISSING INFO EXCEPT SC AND BS ID USING INST ID
				BEGIN
					SELECT TOP 1 @clientId=clientId, @appTypeId=appTypeId FROM APP_Application WITH(NOLOCK) WHERE (id=@subclientId OR @subclientId=0) AND (clientId=@clientId OR @clientId=0) AND
							(appTypeId=@appTypeId OR @appTypeId=0) AND (instance=@instanceId)
				END
				EXEC TM_GetClientEntityTaskList @userId, @localeId_in, @clientGroupId, @clientId, @appTypeId, @instanceId, @backupsetId, @subclientId, @xmlText OUTPUT
				GOTO EXIT_GET_TASK_LIST
			END
			ELSE
			BEGIN
				IF @libraryId = 0
				AND @configPolicyId = 0
				AND @dataSourceId = 0
				BEGIN
					EXEC TM_GetStoragePolicyTaskList @userId, @localeId_in, @policyId, @copyId, @xmlText OUTPUT
					GOTO EXIT_GET_TASK_LIST
				END
				ELSE IF @configPolicyId <> 0
				BEGIN
					EXEC TM_GetConfigPolicyTaskList @userId, @localeId_in, @configPolicyId, @xmlText OUTPUT
					GOTO EXIT_GET_TASK_LIST
				END
				ELSE IF @libraryId <> 0
				BEGIN
					EXEC TM_GetLibraryTaskList @userId, @localeId_in, @libraryId, @xmlText OUTPUT
					GOTO EXIT_GET_TASK_LIST
				END
				ELSE IF @dataSourceId > 0
				BEGIN
					EXEC TM_GetDataSourceTaskList @userId, @localeId_in, @dataSourceId, @xmlText OUTPUT
					GOTO EXIT_GET_TASK_LIST
				END
			END
		END
	END
	ELSE
	BEGIN
		--GET SAVED REPORTS FLAG
		SET @savedReports = ISNULL(( SELECT ref.value('@savedReports', 'int')
										FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
									), 0)
		--GET AGENTLESS SRM FLAG
		SET @agentlessSRM = ISNULL(( SELECT ref.value('@agentlessSRM', 'int')
										FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
									), 0)
		--GET OTHER REPORTS FLAG
		SET @otherReports = ISNULL(( SELECT ref.value('@otherReports', 'int')
										FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
									), 0)
		--GET SRM REPORTS FLAG
		SET @isSRMReports = ISNULL(( SELECT    ref.value('@isSRMReports', 'int')
									FROM      @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
								), 0)
		--GET SRM REPORT SET
		SET @srmReportSet = ISNULL(( SELECT ref.value('@srmReportSet', 'int')
										FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
									), 0)
		--GET SRM REPORT TYPE
		SET @srmReportType = ISNULL(( SELECT    ref.value('@srmReportType', 'int')
										FROM      @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
									), 0)
		SET @mediaAgentId = ISNULL(( SELECT   ref.value('@mediaAgentId', 'int')
								FROM     @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
								), 0)
		SET @trackingPolicyId =   ISNULL(( SELECT   ref.value('@trackingPolicyId', 'int')
								FROM     @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
								), 0)
		--GET AGENTLESS POLICY ID
		SET @agentlessPolicyId = ISNULL(( SELECT ref.value('@agentlessPolicyId', 'int')
									FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
								), 0)
		--GET SRM REPORT ID
		SET @srmTemplateId = ISNULL(( SELECT ref.value('@srmTemplateId', 'int')
									FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
								), 0)
		-- Compliance director policy
		SET @cdPolicyId = ISNULL(( SELECT   ref.value('@compliancePolicyId', 'int')
								FROM     @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
								), 0)
		SET @workFlowId = ISNULL(( SELECT ref.value('@workflowId', 'int')
									FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
								), 0)
		--GET Configuration Policy ID
		SET @configPolicyId = ISNULL(( SELECT   ref.value('@policyId', 'int')
								FROM     @xmlText . nodes('TMMsg_GetTaskListReq/filter/configPolicyEntity') R ( ref )
								), 0)
		--GET Inventory(datasource) Id
		SET @dataSourceId = ISNULL(( SELECT   ref.value('@seaDataSourceId', 'int')
								FROM     @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
								), 0)
		-- CHECK FOR DIFFERENT ENTRY POINTS
		-- 1. Saved Reports
		IF  @srmReportType = 0
			AND @srmReportSet = 0
			AND @mediaAgentId = 0
			AND @trackingPolicyId = 0
			AND @savedReports = 1
			AND @agentlessSRM = 0
			AND @policy = 0
			AND @schedules = 0
			AND @agentlessPolicyId = 0
			AND @isSRMReports = 0
			AND @cdPolicyId = 0
			AND @configPolicyId = 0
			AND @dataSourceId = 0
			BEGIN
				SET @xmlText = ( SELECT	 --TASKLIST
									( SELECT 	--TASK
												[TM_Task].taskId AS '@taskId' ,
												[TM_Task].taskName AS '@taskName' ,
												[TM_Task].taskType AS '@taskType' ,
												[TM_Task].alertId AS '@alertId' ,
												[NTnotificationRule].notificationName AS '@alertName' ,
												[TM_Task].ownerId AS '@ownerId' ,
												[TM_Task].runUserId AS '@runUserId' ,
												[TM_Task].description AS '@description' ,
												USR.login AS '@ownerName' ,
												[TM_Task].policyType AS '@policyType' ,
												--dbo.GetEntityCount([TM_Task].taskId) AS '@associatedObjects' ,
												[TM_Task].GUID ,
												( SELECT -- alert
															[TM_Task].alertId AS '@alertId' ,
															NT.notificationName AS '@alertName'
													FROM    dbo.NTnotificationRule
															AS NT WITH (NOLOCK)
													WHERE   NT.id = [TM_Task].alertId
												FOR
													XML PATH('alert') ,
														TYPE
												) ,
												(SELECT
													[TM_Task].taskId AS '@taskId',
													[TM_Task].taskName AS '@taskName'
												FOR
													XML PATH ('task'),
														TYPE
												),
												( SELECT-- origCC
															[TM_Task].origCCId AS '@commCellId'
												FOR
													XML PATH('originalCC') ,
														TYPE
												) ,
												( SELECT  --TaskFlags
															[TM_Task].disabled AS '@disabled' ,
															[TM_Task].uninstalled AS '@uninstalled' ,
															[TM_Task].isEZOperation AS '@isEZOperation',
CASE WHEN [TM_Task].flags & 0x40 <> 0 THEN 1
															ELSE 0
															END AS '@isEdgeDrive',
CASE WHEN [TM_Task].flags & 0x4 <> 0 THEN 1
															ELSE 0
															END AS '@isSystem',
CASE WHEN [TM_Task].flags & 0x80 <> 0 THEN 1
															ELSE 0
															END AS '@isIndexBackup'
												FOR
													XML PATH('taskFlags') ,
														TYPE
												)
									FOR
										XML PATH('task') ,
											TYPE
									),
									( SELECT		--SUBTASKINFO
												( SELECT	DISTINCT --SUBTASK
															STASK.subTaskId AS '@subTaskId' ,
															STASK.subTaskType AS '@subTaskType' ,
															STASK.operationType AS '@operationType' ,
															STASK.flags AS '@flags' ,
															STASK.subTaskOrder AS '@subTaskOrder' ,
															STASK.subTaskName AS '@subTaskName'
												FOR
													XML PATH('subTask') ,
														TYPE
												) ,
												( SELECT  --OPTIONS
															SOPTIONS.xmlValue.query('/TMMsg_JobOption/*') AS 'options'
													FROM    TM_SubTaskXMLOptions SOPTIONS
													WHERE   SOPTIONS.subTaskId = STASK.subTaskId
												FOR
													XML PATH('') ,
														TYPE
												)
										FROM      TM_subTask AS STASK WITH (NOLOCK)
										WHERE     STASK.taskId = [TM_Task].taskId
									FOR
										XML PATH('subTasks') ,
											TYPE
									)
								FROM   dbo.TM_Task WITH (NOLOCK)
									--INNER JOIN #entitiesWithViewSchedCapability sec ON
									--	(capabilities&16384) <> 0
									INNER JOIN dbo.UMUsers AS USR WITH (NOLOCK) ON dbo.TM_Task.ownerId = USR.id
									LEFT OUTER JOIN dbo.NTnotificationRule WITH (NOLOCK) ON dbo.NTnotificationRule.id = dbo.TM_Task.alertId
								WHERE  [TM_Task].[deleted] = 0
									AND [TM_Task].[invalid] = 0
									AND [TM_Task].[uninstalled] = 0
									AND [TM_Task].[savedReport] = 1
									AND [TM_Task].[hidden] = 0
									AND [USR].[id] = @userId
							FOR
								XML PATH('taskDetail') ,
									ROOT('TMMsg_GetTaskListResp')
							)
			END
		-- Other Reports
		ELSE IF @srmReportType = 0
			AND @srmReportSet = 0
			AND @mediaAgentId = 0
			AND @trackingPolicyId = 0
			AND @otherReports = 1
			AND @policy = 0
			AND @schedules = 0
			AND @agentlessPolicyId = 0
			AND @isSRMReports = 0
			AND @cdPolicyId = 0
			AND @configPolicyId = 0
			AND @dataSourceId = 0
			BEGIN
				EXEC sec_getUserObjects @userId, 0, 0, '#entitiesWithViewSchedCapability'
				SET @xmlText = ( SELECT	 --TASKLIST
									( SELECT 	--TASK
												[TM_Task].taskId AS '@taskId' ,
												[TM_Task].taskName AS '@taskName' ,
												[TM_Task].taskType AS '@taskType' ,
												[TM_Task].alertId AS '@alertId' ,
												[NTnotificationRule].notificationName AS '@alertName' ,
												[TM_Task].ownerId AS '@ownerId' ,
												[TM_Task].runUserId AS '@runUserId' ,
												[TM_Task].description AS '@description' ,
												USR.login AS '@ownerName' ,
												[TM_Task].policyType AS '@policyType' ,
												--dbo.GetEntityCount([TM_Task].taskId) AS '@associatedObjects' ,
												[TM_Task].GUID ,
												( SELECT -- alert
															[TM_Task].alertId AS '@alertId' ,
															NT.notificationName AS '@alertName'
													FROM    dbo.NTnotificationRule
															AS NT WITH (NOLOCK)
													WHERE   NT.id = [TM_Task].alertId
												FOR
													XML PATH('alert') ,
														TYPE
												) ,
												(SELECT
													[TM_Task].taskId AS '@taskId',
													[TM_Task].taskName AS '@taskName'
												FOR
													XML PATH ('task'),
														TYPE
												),
												( SELECT-- origCC
															[TM_Task].origCCId AS '@commCellId'
												FOR
													XML PATH('originalCC') ,
														TYPE
												) ,
												( SELECT  --TaskFlags
															[TM_Task].disabled AS '@disabled' ,
															[TM_Task].uninstalled AS '@uninstalled' ,
															[TM_Task].isEZOperation AS '@isEZOperation',
CASE WHEN [TM_Task].flags & 0x40 <> 0 THEN 1
															ELSE 0
															END AS '@isEdgeDrive',
CASE WHEN [TM_Task].flags & 0x4 <> 0 THEN 1
															ELSE 0
															END AS '@isSystem',
CASE WHEN [TM_Task].flags & 0x80 <> 0 THEN 1
															ELSE 0
															END AS '@isIndexBackup'
												FOR
													XML PATH('taskFlags') ,
														TYPE
												)
									FOR
										XML PATH('task') ,
											TYPE
									),
									( SELECT		--SUBTASKINFO
												( SELECT	DISTINCT --SUBTASK
															STASK.subTaskId AS '@subTaskId' ,
															STASK.subTaskType AS '@subTaskType' ,
															STASK.operationType AS '@operationType' ,
															STASK.flags AS '@flags' ,
															STASK.subTaskOrder AS '@subTaskOrder' ,
															STASK.subTaskName AS '@subTaskName'
												FOR
													XML PATH('subTask') ,
														TYPE
												) ,
												( SELECT  --OPTIONS
															SOPTIONS.xmlValue.query('/TMMsg_JobOption/*') AS 'options'
													FROM    TM_SubTaskXMLOptions AS SOPTIONS WITH (NOLOCK)
													WHERE   SOPTIONS.subTaskId = STASK.subTaskId
												FOR
													XML PATH('') ,
														TYPE
												)
										FROM      TM_subTask AS STASK WITH (NOLOCK)
										WHERE     STASK.taskId = [TM_Task].taskId
									FOR
										XML PATH('subTasks') ,
											TYPE
									)
								FROM   dbo.TM_Task WITH (NOLOCK)
									INNER JOIN #entitiesWithViewSchedCapability sec ON
										(capabilities&16384) <> 0
									LEFT OUTER JOIN dbo.UMUsers AS USR WITH (NOLOCK) ON dbo.TM_Task.ownerId = USR.id
									LEFT OUTER JOIN dbo.NTnotificationRule WITH (NOLOCK) ON dbo.NTnotificationRule.id = dbo.TM_Task.alertId
								WHERE  [TM_Task].[deleted] = 0
									AND [TM_Task].[invalid] = 0
									AND [TM_Task].[uninstalled] = 0
									AND [TM_Task].[savedReport] = 1
									AND [TM_Task].[ownerId] <> @userId
									AND [TM_Task].[hidden] = 0
AND (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
							FOR
								XML PATH('taskDetail') ,
									ROOT('TMMsg_GetTaskListResp')
							)
			END
		-- Agentless SRM
		ELSE IF @srmReportType = 0
			AND @srmReportSet = 0
			AND @trackingPolicyId = 0
			AND @savedReports = 0
			AND @agentlessSRM = 1
			AND @policy = 0
			AND @schedules = 0
			AND @agentlessPolicyId = 0
			AND @isSRMReports = 0
			AND @cdPolicyId = 0
			AND @configPolicyId = 0
			AND @dataSourceId = 0
			BEGIN
				SET @xmlText = ( SELECT	 --TASKLIST
									( SELECT 	--TASK
												[TM_Task].taskId AS '@taskId' ,
												[TM_Task].taskName AS '@taskName' ,
												[TM_Task].taskType AS '@taskType' ,
												[TM_Task].alertId AS '@alertId' ,
												[NTnotificationRule].notificationName AS '@alertName' ,
												[TM_Task].ownerId AS '@ownerId' ,
												[TM_Task].runUserId AS '@runUserId' ,
												[TM_Task].description AS '@description' ,
												USR.login AS '@ownerName' ,
												[TM_Task].policyType AS '@policyType' ,
												--dbo.GetEntityCount([TM_Task].taskId) AS '@associatedObjects' ,
												[TM_Task].GUID ,
												( SELECT -- alert
															[TM_Task].alertId AS '@alertId' ,
															NT.notificationName AS '@alertName'
													FROM    dbo.NTnotificationRule
															AS NT WITH (NOLOCK)
													WHERE   NT.id = [TM_Task].alertId
												FOR
													XML PATH('alert') ,
														TYPE
												) ,
												(SELECT
													[TM_Task].taskId AS '@taskId',
													[TM_Task].taskName AS '@taskName'
												FOR
													XML PATH ('task'),
														TYPE
												),
												( SELECT-- origCC
															[TM_Task].origCCId AS '@commCellId'
												FOR
													XML PATH('originalCC') ,
														TYPE
												) ,
												( SELECT  --TaskFlags
															[TM_Task].disabled AS '@disabled' ,
															[TM_Task].uninstalled AS '@uninstalled' ,
															[TM_Task].isEZOperation AS '@isEZOperation',
CASE WHEN [TM_Task].flags & 0x40 <> 0 THEN 1
															ELSE 0
															END AS '@isEdgeDrive',
CASE WHEN [TM_Task].flags & 0x4 <> 0 THEN 1
															ELSE 0
															END AS '@isSystem',
CASE WHEN [TM_Task].flags & 0x80 <> 0 THEN 1
															ELSE 0
															END AS '@isIndexBackup'
												FOR
													XML PATH('taskFlags') ,
														TYPE
												)
									FOR
										XML PATH('task') ,
											TYPE
									),
									( SELECT		--SUBTASKINFO
												( SELECT	DISTINCT --SUBTASK
															STASK.subTaskId AS '@subTaskId' ,
															STASK.subTaskType AS '@subTaskType' ,
															STASK.operationType AS '@operationType' ,
															STASK.flags AS '@flags' ,
															STASK.subTaskOrder AS '@subTaskOrder' ,
															STASK.subTaskName AS '@subTaskName'
												FOR
													XML PATH('subTask') ,
														TYPE
												) ,
												( SELECT  --OPTIONS
															SOPTIONS.xmlValue.query('/TMMsg_JobOption/*') AS 'options'
													FROM    TM_SubTaskXMLOptions SOPTIONS WITH (NOLOCK)
													WHERE   SOPTIONS.subTaskId = STASK.subTaskId
												FOR
													XML PATH('') ,
														TYPE
												)
										FROM      TM_subTask AS STASK WITH (NOLOCK)
										WHERE     STASK.taskId = [TM_Task].taskId
									FOR
										XML PATH('subTasks') ,
											TYPE
									)
								FROM   dbo.TM_Task WITH (NOLOCK)
									INNER JOIN dbo.UMUsers AS USR WITH (NOLOCK) ON dbo.TM_Task.ownerId = USR.id
									LEFT OUTER JOIN dbo.NTnotificationRule WITH (NOLOCK) ON dbo.NTnotificationRule.id = dbo.TM_Task.alertId
								WHERE  [TM_Task].[deleted] = 0
									AND [TM_Task].[invalid] = 0
									AND [TM_Task].[uninstalled] = 0
									AND [TM_Task].[isAgentlessSRM] = 1
							FOR
								XML PATH('taskDetail') ,
									ROOT('TMMsg_GetTaskListResp')
							)
			END
			-- Workflow schedules
		ELSE IF @srmReportType = 0
			AND @srmReportSet = 0
			AND @trackingPolicyId = 0
			AND @savedReports = 0
			AND @agentlessSRM = 0
			AND @agentlessPolicyId = 0
			AND @isSRMReports = 0
			AND @cdPolicyId = 0
			AND @isWorkFlow = 1
			AND @configPolicyId = 0
			AND @dataSourceId = 0
			BEGIN
				EXEC sec_getUserObjects @userId, 0, 0, '#entitiesWithViewSchedCapability'
				-- needed so that we can join on a user with no privilages
				IF (SELECT COUNT(*) FROM #entitiesWithViewSchedCapability) = 0
				--AVOID DUPLICATE ROWS WHEN CHECKING OWNER
				BEGIN
				INSERT INTO #entitiesWithViewSchedCapability (capabilities, flag, commCellId, clientGroupId, clientId, appTypeId,						instanceId, backupsetId, subClientId,mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId, reviewSetId, querySetId, downloadSetId, ermId, legalHoldId, tagId, cdPolicyId, complianceReportId, taskId)
					VALUES (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
				END
				DECLARE @optionFilter TABLE (optionId BIGINT, value NVARCHAR(MAX))
				--GET OPTIONS FILTER
				INSERT  INTO @optionFilter
				SELECT  ref.value('@optionId', 'bigint') AS optionId, ref.value('@value', 'NVARCHAR(MAX)') AS value
				FROM    @xmlText.nodes('TMMsg_GetTaskListReq/filter/options') R ( ref )
				IF object_id('tempdb.dbo.#taskList') is not null
				DROP TABLE #taskList
				CREATE TABLE #taskList (taskId INT NOT NULL)
				IF exists ( select top 1 * from @optionFilter)
				BEGIN
					INSERT INTO #taskList
					SELECT DISTINCT S.taskId
					FROM TM_SubTaskOptions SO
					JOIN TM_SubTask S ON S.subTaskId = SO.subTaskId
					JOIN TM_Task T ON T.taskId = S.taskId
					JOIN @optionFilter optF ON optF.optionId = SO.optionId and optF.value = SO.value
				END
				ELSE
				BEGIN
					INSERT INTO #taskList
					SELECT  taskId
					FROM TM_Task
				END
				IF object_id('tempdb.dbo.#taskTbl') IS NOT NULL
				DROP TABLE #taskTbl
				CREATE TABLE #taskTbl (taskid INT ,workflowId INT,ownerId INT,PRIMARY KEY(taskid,workflowId))
				INSERT INTO #taskTbl(taskid,workflowId, ownerId)
				SELECT T.taskid ,TA.workflowId,T.ownerId
				FROM TM_task T WITH(NOLOCK)
				INNER JOIN TM_AssocEntity TA WITH(NOLOCK)
				ON t.taskid = ta.taskid
				UNION
				SELECT T.taskid,TWA.workflowId,T.ownerId
				FROM TM_task T WITH(NOLOCK)
				INNER JOIN TM_AssocWorkFlowEntity TWA WITH(NOLOCK)
				ON t.taskid = TWA.taskid
				SET @xmlText = ( SELECT	 --TASKLIST
								( SELECT 	--TASK
											[TM_Task].taskId AS '@taskId' ,
											[TM_Task].taskName AS '@taskName' ,
											[TM_Task].taskType AS '@taskType' ,
											[TM_Task].alertId AS '@alertId' ,
											[NTnotificationRule].notificationName AS '@alertName' ,
											[TM_Task].ownerId AS '@ownerId' ,
											[TM_Task].runUserId AS '@runUserId' ,
											[TM_Task].description AS '@description' ,
											USR.login AS '@ownerName' ,
											[TM_Task].policyType AS '@policyType' ,
											--dbo.GetEntityCount([TM_Task].taskId) AS '@associatedObjects' ,
											[TM_Task].GUID ,
											( SELECT -- alert
														[TM_Task].alertId AS '@alertId' ,
														NT.notificationName AS '@alertName'
												FROM    dbo.NTnotificationRule
														AS NT WITH (NOLOCK)
												WHERE   NT.id = [TM_Task].alertId
											FOR
												XML PATH('alert') ,
													TYPE
											) ,
											(SELECT
												[TM_Task].taskId AS '@taskId',
												[TM_Task].taskName AS '@taskName'
											FOR
												XML PATH ('task'),
													TYPE
											),
											( SELECT-- origCC
														[TM_Task].origCCId AS '@commCellId'
											FOR
												XML PATH('originalCC') ,
													TYPE
											) ,
											( SELECT  --TaskFlags
														[TM_Task].disabled AS '@disabled' ,
														[TM_Task].uninstalled AS '@uninstalled' ,
														[TM_Task].isEZOperation AS '@isEZOperation',
CASE WHEN [TM_Task].flags & 0x40 <> 0 THEN 1
														ELSE 0
														END AS '@isEdgeDrive',
CASE WHEN [TM_Task].flags & 0x4 <> 0 THEN 1
														ELSE 0
														END AS '@isSystem',
CASE WHEN [TM_Task].flags & 0x80 <> 0 THEN 1
														ELSE 0
														END AS '@isIndexBackup'
											FOR
												XML PATH('taskFlags') ,
													TYPE
											)
								FOR
									XML PATH('task') ,
										TYPE
								),
								(
									SELECT WF.WorkflowId '@workflowId',
									WF.Name '@workflowName'
									FROM WF_Definition WF (NOLOCK)
									JOIN TM_AssocEntity ASS (NOLOCK) ON ASS.workflowId = WF.workflowId
									WHERE ASS.taskId = [TM_Task].taskId
									FOR
										XML PATH('associations') ,
											TYPE
								),
								( SELECT		--SUBTASKINFO
					                --TASK RUN TIME FROM TM_RunTime Table
											NRT.nextTime AS '@nextScheduleTime' ,
											ABS(datediff(second, '01/01/1970', GETUTCDATE()) - datediff(second, '01/01/1970', NRT.nextRunTime)) '@relativeTime',
											( SELECT	DISTINCT --SUBTASK
														STASK.subTaskId AS '@subTaskId' ,
														STASK.subTaskType AS '@subTaskType' ,
														STASK.operationType AS '@operationType' ,
														STASK.flags AS '@flags' ,
														STASK.subTaskOrder AS '@subTaskOrder' ,
														STASK.subTaskName AS '@subTaskName'
											FOR
												XML PATH('subTask') ,
													TYPE
											) ,
											( SELECT --PATTERN
														PAT.patternId '@patternId' ,
														PAT.name '@name' ,
														PAT.flags '@flags' ,
														PAT.freq_type '@freq_type' ,
														PAT.freq_interval '@freq_interval' ,
														PAT.freq_relative_interval '@freq_relative_interval' ,
														PAT.freq_recurrence_factor '@freq_recurrence_factor' ,
														PAT.freq_subday_interval '@freq_subday_interval' ,
														PAT.skipOccurence '@skipOccurence' ,
														PAT.skipDayNumber '@skipDayNumber' ,
														PAT.local_start_date '@active_start_date' ,
														PAT.active_start_time '@active_start_time' ,
														PAT.local_end_date '@active_end_date' ,
														PAT.active_end_time '@active_end_time' ,
														PAT.active_end_occurence '@active_end_occurence' ,
														PAT.description '@description' ,
														PAT.freq_restart_interval '@freq_restart_interval',
														( SELECT  --TimeZone
														PAT.tzId AS '@TimeZoneID'
														FOR
														XML
														PATH('timeZone') ,
														TYPE
														) ,
														( SELECT  --Calendar
														PAT.calendarId AS '@calendarId'
														FOR
														XML
														PATH('calendar') ,
														TYPE
														),
														( SELECT  --Repeat Pattern
														REP.onOccurence AS '@occurrence',
														REP.onDay AS '@onDay',
														REP.repeatOn AS '@repeatOn',
														REP.onDayNumber AS '@onDayNumber',
														1				  AS '@exception',
														REP.description AS '@description'
														FROM TM_RepeatPattern AS REP WITH (NOLOCK)
														WHERE REP.patternId = PAT.patternId
														FOR
														XML
														PATH('repeatPattern') ,
														TYPE
														)
												FROM    TM_Pattern AS PAT WITH (NOLOCK),
														TM_PatternAssoc PASOC WITH (NOLOCK)
												WHERE   [PASOC].[patternId] = PAT.[patternId]
														AND PASOC.subTaskId = STASK.subTaskId
											FOR
												XML PATH('pattern') ,
													TYPE
											) ,
											( SELECT  --OPTIONS
														SOPTIONS.xmlValue.value('/TMMsg_JobOption[1]/@workflowJobOptions','nvarchar(max)') as '@workflowJobOptions',
                                                        SOPTIONS.xmlValue.query('/TMMsg_JobOption/*')
                                              FROM      TM_SubTaskXMLOptions SOPTIONS WITH (NOLOCK)
                                              WHERE     SOPTIONS.subTaskId = STASK.subTaskId
												FOR XML PATH('options'),
                                                  TYPE
											)
									FROM      TM_subTask AS STASK WITH (NOLOCK)
											LEFT OUTER JOIN TM_PatternAssoc
												AS PAS WITH (NOLOCK) ON PAS.subTaskId = STASK.subTaskId
											LEFT OUTER JOIN TM_Pattern
												AS PAT WITH (NOLOCK) ON PAT.patternId = PAS.patternId
											LEFT OUTER JOIN TM_RunTime
												AS NRT WITH (NOLOCK) ON NRT.patternId = PAS.patternId
														AND NRT.processed = 0
									WHERE     STASK.taskId = [TM_Task].taskId
								FOR
									XML PATH('subTasks') ,
										TYPE
								)
							FROM   dbo.TM_Task WITH (NOLOCK)
								INNER JOIN #taskList tempTask
								on TM_Task.taskId = tempTask.taskId
								INNER JOIN dbo.UMUsers AS USR WITH (NOLOCK) ON dbo.TM_Task.ownerId = USR.id
								LEFT OUTER JOIN dbo.NTnotificationRule WITH (NOLOCK) ON dbo.NTnotificationRule.id = dbo.TM_Task.alertId
							WHERE  [TM_Task].[deleted] = 0
								AND [TM_Task].[invalid] = 0
								AND [TM_Task].[uninstalled] = 0
AND ([TM_Task].taskType = 4 OR [TM_Task].taskType = 2)
								AND TM_Task.taskid in
								(
									select T.taskid from #taskTbl T
									LEFT OUTER JOIN #entitiesWithViewSchedCapability sec ON
										T.ownerid = @userid OR
										(
											((capabilities&@_EV_VIEW) <> 0)
											AND
											(
												sec.workflowID =  T.workflowId Or
												(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
												)
											)
										)
										LEFT OUTER JOIN TM_subtask ON TM_subtask.TaskId = T.taskid
										LEFT OUTER JOIN #subtaskList subtaskList ON subtaskList.subTaskId = TM_subtask.subtaskId
									where (
											(subtaskList.subTaskId IS NOT NULL AND subtaskList.subTaskId>0)
											OR sec.workflowID IS NOT NULL
										) AND
										T.workflowId > 0 and (T.workflowId = @workflowId OR @workflowId = 0 )
								)
						FOR
							XML PATH('taskDetail') ,
								ROOT('TMMsg_GetTaskListResp')
						)
			END
		ELSE IF @srmReportType = 0
			AND @srmReportSet = 0
			AND @trackingPolicyId = 0
			AND @savedReports = 0
			AND @agentlessSRM = 0
			AND @agentlessPolicyId = 0
			AND @isSRMReports = 0
			AND @cdPolicyId = 0
			AND @isWorkFlow = 0
			AND @configPolicyId > 0
			AND @dataSourceId = 0
		BEGIN
			EXEC TM_GetConfigPolicyTaskList @userId, @localeId_in, @configPolicyId, @xmlText OUTPUT
			GOTO EXIT_GET_TASK_LIST
		END
		ELSE IF @srmReportType = 0
			AND @srmReportSet = 0
			AND @trackingPolicyId = 0
			AND @savedReports = 0
			AND @agentlessSRM = 0
			AND @agentlessPolicyId = 0
			AND @isSRMReports = 0
			AND @cdPolicyId = 0
			AND @isWorkFlow = 0
			AND @configPolicyId = 0
			AND @dataSourceId > 0
		BEGIN
			EXEC TM_GetDataSourceTaskList @userId, @localeId_in, @dataSourceId, @xmlText OUTPUT
			GOTO EXIT_GET_TASK_LIST
		END
		ELSE
		BEGIN
			SET @xmlText = ( SELECT	 --TASKLIST
								( SELECT 	--TASK
											[TM_Task].taskId AS '@taskId' ,
											[TM_Task].taskName AS '@taskName' ,
											[TM_Task].taskType AS '@taskType' ,
											[TM_Task].alertId AS '@alertId' ,
											[NTnotificationRule].notificationName AS '@alertName' ,
											[TM_Task].ownerId AS '@ownerId' ,
											[TM_Task].runUserId AS '@runUserId' ,
											[TM_Task].description AS '@description' ,
											USR.login AS '@ownerName' ,
											[TM_Task].policyType AS '@policyType' ,
											--dbo.GetEntityCount([TM_Task].taskId) AS '@associatedObjects' ,
											[TM_Task].GUID ,
											( SELECT -- alert
														[TM_Task].alertId AS '@alertId' ,
														NT.notificationName AS '@alertName'
												FROM    dbo.NTnotificationRule
														AS NT WITH (NOLOCK)
												WHERE   NT.id = [TM_Task].alertId
											FOR
												XML PATH('alert') ,
													TYPE
											) ,
											(SELECT
												[TM_Task].taskId AS '@taskId',
												[TM_Task].taskName AS '@taskName'
											FOR
												XML PATH ('task'),
													TYPE
											),
											( SELECT-- origCC
														[TM_Task].origCCId AS '@commCellId'
											FOR
												XML PATH('originalCC') ,
													TYPE
											) ,
											( SELECT  --TaskFlags
														[TM_Task].disabled AS '@disabled' ,
														[TM_Task].uninstalled AS '@uninstalled' ,
														[TM_Task].isEZOperation AS '@isEZOperation',
CASE WHEN [TM_Task].flags & 0x40 <> 0 THEN 1
														ELSE 0
														END AS '@isEdgeDrive',
CASE WHEN [TM_Task].flags & 0x4 <> 0 THEN 1
														ELSE 0
														END AS '@isSystem',
CASE WHEN [TM_Task].flags & 0x80 <> 0 THEN 1
														ELSE 0
														END AS '@isIndexBackup'
											FOR
												XML PATH('taskFlags') ,
													TYPE
											)
								FOR
									XML PATH('task') ,
										TYPE
								),
								( SELECT		--SUBTASKINFO
					                --TASK RUN TIME FROM TM_RunTime Table
											NRT.nextTime AS '@nextScheduleTime' ,
											ABS(datediff(second, '01/01/1970', GETUTCDATE()) - datediff(second, '01/01/1970', NRT.nextRunTime)) '@relativeTime',
											( SELECT	DISTINCT --SUBTASK
														STASK.subTaskId AS '@subTaskId' ,
														STASK.subTaskType AS '@subTaskType' ,
														STASK.operationType AS '@operationType' ,
														STASK.flags AS '@flags' ,
														STASK.subTaskOrder AS '@subTaskOrder' ,
														STASK.subTaskName AS '@subTaskName'
											FOR
												XML PATH('subTask') ,
													TYPE
											) ,
											( SELECT --PATTERN
														PAT.patternId '@patternId' ,
														PAT.name '@name' ,
														PAT.flags '@flags' ,
														PAT.freq_type '@freq_type' ,
														PAT.freq_interval '@freq_interval' ,
														PAT.freq_relative_interval '@freq_relative_interval' ,
														PAT.freq_recurrence_factor '@freq_recurrence_factor' ,
														PAT.freq_subday_interval '@freq_subday_interval' ,
														PAT.skipOccurence '@skipOccurence' ,
														PAT.skipDayNumber '@skipDayNumber' ,
														PAT.local_start_date '@active_start_date' ,
														PAT.active_start_time '@active_start_time' ,
														PAT.local_end_date '@active_end_date' ,
														PAT.active_end_time '@active_end_time' ,
														PAT.active_end_occurence '@active_end_occurence' ,
														PAT.description '@description' ,
														PAT.freq_restart_interval '@freq_restart_interval',
														( SELECT  --TimeZone
														PAT.tzId AS '@TimeZoneID'
														FOR
														XML
														PATH('timeZone') ,
														TYPE
														) ,
														( SELECT  --Calendar
														PAT.calendarId AS '@calendarId'
														FOR
														XML
														PATH('calendar') ,
														TYPE
														),
														( SELECT  --Repeat Pattern
														REP.onOccurence AS '@occurrence',
														REP.onDay AS '@onDay',
														REP.repeatOn AS '@repeatOn',
														REP.onDayNumber AS '@onDayNumber',
														1				  AS '@exception',
														REP.description AS '@description'
														FROM TM_RepeatPattern AS REP WITH (NOLOCK)
														WHERE REP.patternId = PAT.patternId
														FOR
														XML
														PATH('repeatPattern') ,
														TYPE
														)
												FROM    TM_Pattern AS PAT WITH (NOLOCK),
														TM_PatternAssoc PASOC WITH (NOLOCK)
												WHERE   [PASOC].[patternId] = PAT.[patternId]
														AND PASOC.subTaskId = STASK.subTaskId
														AND PAT.deleted = 0
											FOR
												XML PATH('pattern') ,
													TYPE
											) ,
											( SELECT  --OPTIONS
														SOPTIONS.xmlValue.query('/TMMsg_JobOption/*') AS 'options'
												FROM    TM_SubTaskXMLOptions SOPTIONS
												WHERE   SOPTIONS.subTaskId = STASK.subTaskId
											FOR
												XML PATH('') ,
													TYPE
											)
									FROM      TM_subTask AS STASK WITH (NOLOCK)
											LEFT OUTER JOIN TM_PatternAssoc
												AS PAS WITH (NOLOCK) ON PAS.subTaskId = STASK.subTaskId
											LEFT OUTER JOIN TM_Pattern
												AS PAT WITH (NOLOCK) ON PAT.patternId = PAS.patternId
											LEFT OUTER JOIN TM_RunTime
												AS NRT WITH (NOLOCK) ON NRT.patternId = PAS.patternId
														AND NRT.processed = 0
									WHERE     STASK.taskId = [TM_Task].taskId
									AND PAT.deleted = 0
								FOR
									XML PATH('subTasks') ,
										TYPE
								)
							FROM   dbo.TM_Task WITH (NOLOCK)
								INNER JOIN dbo.UMUsers AS USR WITH (NOLOCK) ON dbo.TM_Task.ownerId = USR.id
								LEFT OUTER JOIN dbo.NTnotificationRule WITH (NOLOCK) ON dbo.NTnotificationRule.id = dbo.TM_Task.alertId
							WHERE  [TM_Task].[deleted] = 0
								AND [TM_Task].[invalid] = 0
								AND [TM_Task].[uninstalled] = 0
AND ( (@policy = 1 AND [TM_Task].taskType = 4) OR (@schedules = 1 AND [TM_Task].taskType = 2))
								AND [TM_Task].[taskId] IN
								(
									SELECT taskId FROM TM_AssocEntity WITH (NOLOCK)
									WHERE
									(@isSRMReports = 1 AND ((srmReportType = @srmTemplateId AND @srmTemplateId <> 0) OR (@srmTemplateId = 0 AND srmReportType <> 0))) -- SRM REPORT TEMPLATES
											OR
									(@isSRMReports = 0 AND
									(trackingPolicyId = @trackingPolicyId OR @trackingPolicyId = 0)-- VAULT TRACKER POLICIES
									AND (agentlessPolicyId = @agentlessPolicyId OR @agentlessPolicyId = 0)
									AND workflowId = 0)
								)
						FOR
							XML PATH('taskDetail') ,
								ROOT('TMMsg_GetTaskListResp')
						)
		END
	END
	IF @xmlText IS null
		BEGIN
			SET @xmlText = '<TMMsg_GetTaskListResp/>'
		END
EXIT_GET_TASK_LIST:
	IF object_id('tempdb.dbo.#entitiesWithViewSchedCapability') is not null
		DROP TABLE #entitiesWithViewSchedCapability
	IF object_id('tempdb.dbo.#subTaskList') is not null
		DROP TABLE #subTaskList
SET NOCOUNT OFF
	IF @errorCode <> 0
	BEGIN
		SET @errorString = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @errorCode AND [localeId] = @localeId_in)
		SET @errorString = REPLACE(@errorString, '^1%s', @invalidEntityName)
		SET @xmlText = (
			SELECT  1           as TAG,
					NULL        as Parent,
				@errorCode      as [TMMsg_GenericResp!1!errorCode],
				@errorString    as [TMMsg_GenericResp!1!errorMessage]
			FOR XML EXPLICIT
		)
	END
if @toOutput = 0
	SELECT  @xmlText as o_xml
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetTaskList')
	delete from GxQscripts where name = 'TM_GetTaskList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetTaskList')
	delete from GXDBVersions where aliasname = 'TM_GetTaskList'
GO

insert into GXDBVersions values(2, 'TM_GetTaskList',  '00010176004800130000', 'TM_GetTaskList', '00010176004800130000')
GO

