

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetTaskDetailByJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetTaskDetailByJob.sp,v $ $Id: TM_GetTaskDetailByJob.sp,v 1.43.56.8 2020/06/13 05:15:54 rengu Exp $";
---- =============================================
---- Author:		Anand Vibhor
---- Create date:	01/28/2006
---- Description:	Get the detailed information of task including subtaskInfo for the given taskId.
---- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='TM_GetTaskDetailByJob')
BEGIN
	print '>>> Drop Stored Procedure: TM_GetTaskDetailByJob <<<'
	drop procedure TM_GetTaskDetailByJob
END
IF EXISTS (select * from GxQscripts where name='TM_GetTaskDetailByJob')
	delete from GxQscripts where name = 'TM_GetTaskDetailByJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetTaskDetailByJob')
	delete from GXDBVersions where aliasname = 'TM_GetTaskDetailByJob'
GO
print '... Creating Procedure: TM_GetTaskDetailByJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_GetTaskDetailByJob
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @jobId bigint,
  @userId integer,
  @localeId_in integer,
  @xmlText XML  OUTPUT 
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @initFrom		INT
	DECLARE @operationType	INT
	DECLARE @taskType		INT
	DECLARE @currentTime INT = dbo.GetUnixTime(getdate())
	DECLARE @jobSubmissionTime INT = 0
	DECLARE @numOfDays INT = 0
	DECLARE @jmInitFrom		INT
	DECLARE @sidbStoreId	INT
	-- Generic message
DECLARE @errorCode INT = (2320 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	DECLARE @errorString NVARCHAR(MAX) = dbo.fn_EvFormatEventMsgText(0, @localeId_in, @errorCode, 0,2)
    IF OBJECT_ID('tempdb.dbo.#TM_AssocEntity') IS NOT null
        DROP TABLE #TM_AssocEntity
    IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
        DROP TABLE #AssocEntity
	SELECT @initFrom=initiatedFrom, @operationType=operationType, @jobSubmissionTime = created FROM TM_JobRequest WHERE jobRequestId in (
		SELECT jobRequestId FROM TM_Jobs WHERE jobId=@jobId
	)
	DECLARE @unsupportedFlags BIGINT = (CAST(0x4000000 AS BIGINT) |CAST(0x100000000000000 AS BIGINT)) --JMBKP_EX_PSEUDO_CHILD_JOB|JMBKP_EX_VSA_PARENT_SYNTHFULL
IF EXISTS(SELECT 1 FROM JMBkpStats WHERE jobId = @jobId AND bkpAttributesEx & @unsupportedFlags > 0) OR @operationType = 5025 -- Inventory Crawl jobs resubmit not currently supported
	BEGIN
SET @errorCode = (2933 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId_in, @errorCode, 0,2)
		SET @xmlText = (SELECT	@errorCode AS '@errorCode',
							@errorString AS '@errorMessage'
					FOR XML PATH ('TMMsg_GenericResp'), TYPE)
		GOTO EXIT_GETDETAILS
	END
	IF NOT EXISTS(SELECT 1 FROM TM_JobOptions WHERE [jobId]=@jobId)
	BEGIN
		--
		-- If Command line job
		IF @initFrom = 2
		BEGIN
SET @errorCode = (2321 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId_in, @errorCode, 0,2)
		END
		ELSE
		BEGIN
			SET @jmInitFrom = ISNULL(	((SELECT initFrom FROM JMAdminJobStatsTable
								A WHERE jobId = @jobId AND commCellId = 2)
								UNION ALL
								(SELECT initFrom FROM JMBkpStats
								A WHERE jobId = @jobId AND commCellId = 2)
								UNION ALL
								(SELECT initFrom FROM JMRestoreStats
								A WHERE jobId = @jobId AND commCellId = 2))
								, 0)
			-- Application command line jobs
			IF @jmInitFrom = 1
			BEGIN
SET @errorCode = (2323 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId_in, @errorCode, 0,2)
			END
			ELSE
			BEGIN
				SET @numOfDays = ISNULL((SELECT CAST(value AS INT) FROM GXGlobalParam WHERE name='NumberOfDaysToKeepJobOptionsFromPruning'), 7)
				DECLARE @lastWeek INT = @currentTime-(@numOfDays*24*60*60)
				-- If job is aged
				IF @jobSubmissionTime < @lastWeek
				BEGIN
SET @errorCode = (2322 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT Message FROM EvLocaleMsgs WITH (NOLOCK) WHERE MessageID=(2322 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND LocaleID=@localeId_in)
					--SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId_in, @errorCode, 0,2)
					SET @errorString = REPLACE(@errorString, '^1%d', CAST(@numOfDays AS NVARCHAR(MAX)))
				END
			END
		END
		SET @xmlText = (SELECT	@errorCode AS '@errorCode',
								@errorString AS '@errorMessage'
						FOR XML PATH ('TMMsg_GenericResp'), TYPE)
		GOTO EXIT_GETDETAILS
	END
	SELECT
[100001] AS appId,
		--[COM_CLIENT_GROUP_ID] AS clientGroupId,
[140003] AS clientId,
[140004] AS appTypeId,
[140005] AS instanceId,
[140006] AS backupsetId,
[140007] AS subclientId,
[140008] AS policyId,
[140009] AS copyId,
[140010] AS srmReportSet,
[140011] AS srmReportType,
[140012] AS trackingPolicy,
[140013] AS MediaAgentId,
[140024] AS agentlessPolicyId,
[140034] AS workflowId,
[140016] AS taskType,
[229570007]AS sidbStoreId
INTO    #TM_AssocEntity
FROM    ( SELECT    value,
                    optionId
          FROM      dbo.GetAllJobOptions(@jobId)
) AS SourceTable PIVOT ( MAX(value) FOR OPTIONID IN ([100001], --[COM_CLIENT_GROUP_ID],
[140003], [140004], [140005], [140006], [140007] ,[140008], [140009],
[140010],[140011], [140012], [140013], [140024], [140034], [140016],[229570007] )
		) AS PIVOTTABLE
--IF this IS backup job, please fill other information too.
UPDATE #TM_AssocEntity SET appTypeId = APP.appTypeid, clientId = APP.clientId, instanceId = APP.instance, backupsetId = APP.backupSet, subclientId = APP.id
FROM dbo.APP_Application AS APP WHERE id = ISNULL(appId,subclientId)
--DO NOT SEND CLIENT INFO FOR DV2 JOBS
UPDATE #TM_AssocEntity SET clientId = NULL WHERE sidbStoreId IS NOT NULL AND @operationType = 4007
--DO NOT SEND CLIENT INFO FOR Aux copy jobs
UPDATE #TM_AssocEntity SET clientId = NULL WHERE policyId IS NOT NULL AND @operationType = 4003
SELECT @taskType=taskType FROM #TM_AssocEntity
IF @taskType = 4
SET @taskType = 2
        SELECT  --TA.clientGroupId,
                --dbo.APP_ClientGroup.name AS clientGroupName,
                TA.clientId,
                dbo.APP_Client.name AS clientName,
                TA.apptypeId,
                dbo.APP_iDAType.name AS appTypeName,
                TA.instanceId,
                dbo.EncodeInvalidXMLChar(dbo.APP_InstanceName.name) AS instanceName,
                TA.backupsetId,
                dbo.APP_BackupSetName.name AS backupsetName,
                TA.subclientId,
                dbo.APP_Application.subclientName,
                TA.policyId,
                dbo.archGroup.name AS policyName,
                TA.copyId,
                dbo.archGroupCopy.name AS copyName,
                TA.srmReportSet AS srmReportSet,
                TA.srmReportType AS srmReportType,
                '' AS srmReportName,
                TA.mediaAgentId,
                dbo.APP_Client.name AS mediaAgentName,
                TA.agentlessPolicyId,
                TA.trackingPolicy,
                dbo.VTPolicy.policyName AS trackingPolicyName,
                TA.workflowId,
				TA.sidbStoreId
        INTO    #AssocEntity
        FROM    #TM_AssocEntity AS TA
                LEFT OUTER JOIN dbo.APP_Application WITH (NOLOCK) ON TA.appId = dbo.APP_Application.id OR TA.subclientId = dbo.APP_Application.id
                LEFT OUTER JOIN dbo.APP_Client WITH (NOLOCK) ON TA.clientId = dbo.APP_Client.id AND TA.clientId <> 0 --OR #AssocEntity.MediaAgentId = dbo.APP_Client.id
                LEFT OUTER JOIN dbo.APP_iDAType WITH (NOLOCK) ON TA.apptypeId = dbo.APP_iDAType.type AND TA.apptypeId <> 0
                LEFT OUTER JOIN dbo.APP_BackupSetName WITH (NOLOCK) ON TA.backupsetId = dbo.APP_BackupSetName.id
                LEFT OUTER JOIN dbo.APP_InstanceName WITH (NOLOCK) ON TA.instanceId = dbo.APP_InstanceName.id
                LEFT OUTER JOIN dbo.archGroup WITH (NOLOCK) ON TA.policyId = dbo.archGroup.id
                LEFT OUTER JOIN dbo.archGroupCopy WITH (NOLOCK) ON TA.copyId = dbo.archGroupCopy.id AND TA.copyId <> 0
                --LEFT OUTER JOIN dbo.CRReportTemplates WITH (NOLOCK) ON TA.srmReportType = CRReportTemplates.id -- CRReportTemplates table is being removed
                --LEFT OUTER JOIN dbo.APP_ClientGroup ON dbo.APP_ClientGroup.id = TA.clientGroupId
                LEFT OUTER JOIN dbo.VTPolicy WITH (NOLOCK) ON dbo.VTPolicy.policyId = TA.trackingPolicy
	DECLARE @xmlJObOptions XML = dbo.GetXMLJobOptions(@jobId)
	IF @xmlJObOptions IS NULL
	BEGIN
SET @xmlText = '<TMMsg_GenericResp errorCode="'+CAST((1736 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AS NVARCHAR(10))+'" errorMessage="'+dbo.fn_EvFormatEventMsgText(0, @localeId_in, (1736 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0,2)+'"/>'
		GOTO EXIT_GETDETAILS
	END
	SELECT TOP 1 @sidbStoreId = sidbStoreId FROM #AssocEntity
	IF @sidbStoreId > 0 AND (@xmlJObOptions.exist('/TMMsg_JobOption/adminOpts/archiveCheckOption/sidbStore')=0)
	BEGIN
		IF (@xmlJObOptions.exist('/TMMsg_JobOption/adminOpts/archiveCheckOption')=0)
		BEGIN
			SET @xmlJObOptions.modify('insert <archiveCheckOption /> into (/TMMsg_JobOption/adminOpts)[1]')
		END
		IF (@xmlJObOptions.exist('/TMMsg_JobOption/adminOpts/archiveCheckOption/sidbStore')=0)
		BEGIN
			SET @xmlJObOptions.modify('insert <sidbStore /> into (/TMMsg_JobOption/adminOpts/archiveCheckOption)[1]')
		END
		SET @xmlJObOptions.modify('insert (attribute sidbStoreId {sql:variable("@sidbStoreId")}) into (/TMMsg_JobOption/adminOpts/archiveCheckOption/sidbStore)[1]')
	END
	--REMOVE JOB ID FOR POWER RESTORE JOBS --MR93025
	IF (@xmlJObOptions.exist('/TMMsg_JobOption/restoreOptions/searchOption/@powerSearchId')=1)
		SET @xmlJObOptions.modify('delete (/TMMsg_JobOption/restoreOptions/searchOption/@powerSearchId)')
	IF (@xmlJObOptions.exist('/TMMsg_JobOption/serverOptions/@jobId')=1)
		SET @xmlJObOptions.modify('delete (/TMMsg_JobOption/serverOptions/@jobId)')
	-- Below block is no longer needed as OSC is implemented.
	-- Fix for MR:78561 - issue 1
	/*
IF (@operationType = 4020)
	BEGIN
		IF EXISTS(SELECT 1 FROM JMQinetixUpdateStatus WHERE jobId=@jobId)
		BEGIN
			IF (@xmlJObOptions.exist('/TMMsg_JobOption/adminOpts/updateOption/clientGroup')=1)
				SET @xmlJObOptions.modify('delete (/TMMsg_JobOption/adminOpts/updateOption/clientGroup)')
			IF (@xmlJObOptions.exist('/TMMsg_JobOption/adminOpts/updateOption/clientAndClientGroups')=1)
				SET @xmlJObOptions.modify('delete (/TMMsg_JobOption/adminOpts/updateOption/clientAndClientGroups)')
			IF (@xmlJObOptions.exist('/TMMsg_JobOption/adminOpts/updateOption/clientId')=1)
				SET @xmlJObOptions.modify('delete (/TMMsg_JobOption/adminOpts/updateOption/clientId)')
			--DECLARE @clientId XML = (
			--	SELECT Q.clientId '@clientId'
			--	FROM JMQinetixUpdateStatus Q
			--	WHERE jobId=@jobId
			--	FOR XML PATH('clientId')
			--	)
			DECLARE @clientAndGroup XML = (
				SELECT 3 '@_type_', Q.clientId '@clientId', C.name '@clientName'
				FROM JMQinetixUpdateStatus Q
				INNER JOIN APP_Client C WITH (NOLOCK) ON C.id=Q.clientId
				WHERE jobId=@jobId
				FOR XML PATH('clientAndClientGroups')
				)
			SET @xmlJObOptions.modify('insert sql:variable("@clientAndGroup") into (/TMMsg_JobOption/adminOpts/updateOption)[1]')
		END
	END
	*/
----------------------------
--CONSTRUCT THE XML---------
----------------------------
SET @xmlText =
		(SELECT			--TASKLIST
				(SELECT		--TASK
JREQUEST.userId as '@ownerId', JREQUEST.userId as '@runUserId', 1 as '@taskType'	--ALWAYS SEND IMMEDIATE FOR RESUBMIT JOBS MR-76263
				FOR XML PATH('task'), TYPE) ,
					(SELECT  --entitis
				--EASOC.clientGroupId '@clientGroupId', EASOC.clientGroupName '@clientGroupName',
				EASOC.clientId '@clientId', EASOC.clientName '@clientName',
				EASOC.apptypeId '@applicationId', EASOC.appTypeName '@appName', EASOC.instanceId '@instanceId',
				CASE CHARINDEX('', EASOC.instanceName)
				WHEN 0 THEN	EASOC.instanceName
				ELSE
					'|'+REPLACE(EASOC.instanceName,
					'', '|#12!')
				END '@instanceName',
				EASOC.backupsetId '@backupsetId', EASOC.backupsetName '@backupsetName', EASOC.subclientId '@subclientId', EASOC.subclientName '@subclientName',
				EASOC.policyId '@storagePolicyId', EASOC.policyName '@storagePolicyName', EASOC.copyId '@copyId', EASOC.copyName '@copyName',
				EASOC.agentlessPolicyId '@agentlessPolicyId', EASOC.mediaAgentId '@mediaAgentId', EASOC.srmReportSet '@srmReportSet', EASOC.srmReportType '@srmTemplateId',
				EASOC.trackingPolicy '@trackingPolicyId', EASOC.trackingPolicyName '@trackingPolicyName', EASOC.workflowId '@workflowId', EASOC.sidbStoreId '@sidbStoreId'
				FROM  #AssocEntity as EASOC
				FOR XML PATH('associations'), TYPE),
				(SELECT		--SUBTASKINFO
					(SELECT		--SUBTASK
					JREQUEST.subTaskType as '@subTaskType', JREQUEST.operationType as '@operationType'
					FOR XML PATH('subTask'), TYPE),
					(SELECT  --OPTIONS
					@xmlJObOptions.query('/TMMsg_JobOption/*') AS 'options'
					FOR XML PATH(''), TYPE)
				FOR XML PATH('subTasks'), TYPE	)
		FROM dbo.TM_JobRequest AS JREQUEST WITH (NOLOCK)
		INNER join dbo.TM_Jobs AS JOBS WITH (NOLOCK) ON JREQUEST.jobRequestId = JOBS.jobRequestId
		WHERE JOBS.jobId = @jobId
		FOR XML PATH('taskInfo'), ROOT('TMMsg_GetTaskDetailResp'))
EXIT_GETDETAILS:
SELECT @xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetTaskDetailByJob')
	delete from GxQscripts where name = 'TM_GetTaskDetailByJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetTaskDetailByJob')
	delete from GXDBVersions where aliasname = 'TM_GetTaskDetailByJob'
GO

insert into GXDBVersions values(2, 'TM_GetTaskDetailByJob',  '00010043005600080000', 'TM_GetTaskDetailByJob', '00010043005600080000')
GO

