

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetTaskDetail.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetTaskDetail.sp,v $ $Id: TM_GetTaskDetail.sp,v 1.62.2.30.4.1 2021/01/13 14:35:45 mnatarajan Exp $";
---- =============================================
---- Author:		Anand Vibhor
---- Create date:	01/28/2006
---- Description:	Get the detailed information of task including subtaskInfo for the given taskId.
---- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_GetTaskDetail')
BEGIN
	print '>>> Drop Stored Procedure: TM_GetTaskDetail <<<'
	drop procedure TM_GetTaskDetail
END
IF EXISTS (select * from GxQscripts where name='TM_GetTaskDetail')
	delete from GxQscripts where name = 'TM_GetTaskDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetTaskDetail')
	delete from GXDBVersions where aliasname = 'TM_GetTaskDetail'
GO
print '... Creating Procedure: TM_GetTaskDetail'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_GetTaskDetail
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @taskId integer,
  @userId integer,
  @localeId_in integer
AS
  DECLARE @xmlText XML 
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @freqTypeWeekly		INT
SET @freqTypeWeekly	= 8
DECLARE @freqTypeEvery		INT
SET @freqTypeEvery	= 2048
DECLARE @freqTypeMonthly		INT
SET @freqTypeMonthly	= 16
DECLARE @freqTypeMonthlyRelative INT
SET @freqTypeMonthlyRelative = 32
DECLARE @freqType		INT
	SET @freqType = 0
DECLARE @freqInterval			INT
DECLARE @freqRelativeInterval	INT
DECLARE @true		nvarchar(16)
	SET @true = '1'
DECLARE @false		nvarchar(16)
	SET @false = '0'
DECLARE @patternText	XML
DECLARE @patternCount INT
DECLARE @i INT
	SET @i = 1
DECLARE @j INT
	SET @j = 0
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(1023) = ''
DECLARE @o_isUserAdmin INT = 0
DECLARE @VSAREP_DELETED INT = 1
DECLARE @taskType INT = 0
--FETCH THE DEFAULT SUBTASKID
IF EXISTS (SELECT 1 FROM TM_Task WHERE taskId = @taskId AND deleted = 1)
BEGIN
SET @errorCode =  (1466 | (CAST(POWER(2, 24) AS BIGINT) * 35))
    SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId_in, @errorCode, 0, 2)
    GOTO ERROR_EXIT
END
DECLARE @isDefaultDataAnalyticsSched INT = 0
SELECT @isDefaultDataAnalyticsSched = CASE
WHEN (flags & 0x10000 ) <> 0		-- TASK_FLAGS_DATA_ANALYTICS
									THEN 1
								ELSE 0
							END,
		@taskType = taskType
	FROM TM_Task WITH (NOLOCK)
	WHERE taskId = @taskId
IF object_id('tempdb.dbo.#entitiesWithViewSchedCapabilityDetail') is not null
		DROP TABLE #entitiesWithViewSchedCapabilityDetail
-- check whether taskId is visible to user. Get all the schedules visible to user and check whether this is part of this list.
create table  #entitiesWithViewSchedCapabilityDetail ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
IF OBJECT_ID('tempdb.dbo.#PlansList')   IS NOT NULL DROP TABLE #PlansList
CREATE TABLE #PlansList(planId INT NOT NULL)
CREATE CLUSTERED INDEX PlansList_planId_idx ON #PlansList(planId)
EXECUTE sec_isUserAdmin   @userId ,@o_isUserAdmin OUTPUT
DECLARE @subTaskOpType int = 0
DECLARE @subTaskType int = 0
DECLARE @subTaskId int
SELECT @subTaskOpType = operationType, @subTaskType = subTaskType FROM TM_SubTask WITH (NOLOCK) WHERE    taskId = @taskId
DECLARE @_EV_VIEW BIGINT = POWER(2, 31-1)
SET @subTaskId = IsNull(( SELECT TOP 1 s.subTaskId
                       FROM     TM_SubTask s WITH (NOLOCK)
OUTER APPLY ( SELECT 1 Ordering FROM  tm_subtaskoptions STO (NOLOCK) WHERE Sto.subTaskId =s.subTaskId AND optionid=458405394 and value =4) Custom
                       WHERE    s.taskId = @taskId
					   ORDER BY Isnull(Custom.Ordering,0) asc --MR 195943
                       ),0)
DECLARE @SundayBit INT = 0x1
DECLARE @MondayBit INT = 0x2
DECLARE @TuesdayBit INT = 0x4
DECLARE @WednesdayBit INT = 0x8
DECLARE @ThursdayBit INT = 0x10
DECLARE @FridayBit INT = 0x20
DECLARE @SaturdayBit INT = 0x40
-- Do securty check for backup and restore schedules only. Admin schedules and report schedules have additional security checks
IF  ( (@subTaskType = 2 OR @subTaskType = 3 )
	AND @taskType IN (2,4) -- schedule/schedule policy
	AND @o_isUserAdmin=0 and not exists(SELECT 1 FROM TM_Task WHERE taskId = @taskId AND ownerId = @userId) )
BEGIN
		DECLARE @userHasPermission INT = 0
		IF exists(SELECT 1 FROM TM_Task WHERE taskId = @taskId and taskType=4) -- schedule policy
		BEGIN
			--MR=164867 - USER WITHOUT RIGHTS SHOULD NOT BE ABLE TO VIEW SCHEDULE POLICIES
EXEC sec_checkPermissionOnEntity @userId,0,@userHasPermission OUTPUT,  35, @taskId
		END
		ELSE IF exists(SELECT 1 FROM TM_Task WHERE taskId = @taskId and taskType=2) -- schedule
		BEGIN
EXEC sec_checkPermissionOnEntity @userId,0,@userHasPermission OUTPUT,  68, @subtaskId
		END
		IF (@userHasPermission=0)
		begin
			EXEC sec_getUserObjects @userId, 0, 0, '#entitiesWithViewSchedCapabilityDetail'
			DECLARE @doesUserHaveCCBackupCap    INT = 0
			DECLARE @doesUserHaveCCViewCap INT = 0
DECLARE @_EV_SCHEDULE_APPLICATION   INT = POWER(2, 3-1)
DECLARE @_EV_BACKUP                 INT = POWER(2, 12-1)
DECLARE @_EV_SCHEDULE_ADMIN         INT = POWER(2, 1-1)
			DECLARE @capabilitiesCCLevel		INT = 0
			SELECT @capabilitiesCCLevel = @capabilitiesCCLevel | capabilities FROM #entitiesWithViewSchedCapabilityDetail sec
WHERE ( sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0 )
			IF ( (((@capabilitiesCCLevel& @_EV_BACKUP) <> 0) AND ((@capabilitiesCCLevel & @_EV_SCHEDULE_APPLICATION) <> 0)) OR ((@capabilitiesCCLevel&@_EV_VIEW) <> 0))
			BEGIN
				SET @doesUserHaveCCBackupCap = 1
			END
			IF ((@capabilitiesCCLevel& @_EV_VIEW) <> 0)
			BEGIN
				SET @doesUserHaveCCViewCap = 1
			END
			-- -- plans visible to the user
EXEC sec_getNonIdaObjectsForThisUser @userId, 158, 31, '#PlansList'
			-- Identify clients owned by user and return schedule policy if its associated to one of those clients.
			IF OBJECT_ID('tempdb.dbo.#OwnedClients') IS NOT null
				DROP TABLE #OwnedClients
			CREATE TABLE #OwnedClients(clientId INT)
			INSERT INTO #OwnedClients
			SELECT owners.clientId FROM sec_getClientOwnersExpandUG owners WHERE owners.userId = @userID
			INSERT INTO #entitiesWithViewSchedCapabilityDetail(capabilities,commCellId, clientId )
			SELECT @_EV_VIEW, 2, OwnedClients.clientID
			FROM #OwnedClients OwnedClients
			LEFT JOIN #entitiesWithViewSchedCapabilityDetail entitiesWithViewSchedCapabilityDetail
			ON entitiesWithViewSchedCapabilityDetail.clientId = OwnedClients.clientID
			AND entitiesWithViewSchedCapabilityDetail.commcellId = 2
			WHERE entitiesWithViewSchedCapabilityDetail.clientId IS NULL
			-- Update capability for existing owned clients with view capability
			UPDATE entitiesWithViewSchedCapabilityDetail
			SET capabilities = capabilities | @_EV_VIEW
			FROM #entitiesWithViewSchedCapabilityDetail entitiesWithViewSchedCapabilityDetail
			INNER JOIN #OwnedClients OwnedClients
			ON entitiesWithViewSchedCapabilityDetail.clientId = OwnedClients.clientID
			AND entitiesWithViewSchedCapabilityDetail.commcellId = 2
			AND entitiesWithViewSchedCapabilityDetail.appTypeId = 0
			AND entitiesWithViewSchedCapabilityDetail.instanceId = 0
			AND entitiesWithViewSchedCapabilityDetail.backupsetId = 0
			AND entitiesWithViewSchedCapabilityDetail.subClientId = 0
			IF OBJECT_ID('tempdb.dbo.#BackupAssocociationsDetail') IS NOT null
				DROP TABLE #BackupAssocociationsDetail
			CREATE TABLE #BackupAssocociationsDetail
			(
					assocType INT,
					taskId INT,
					clientGroupId INT,
					clientId INT,
					apptypeId INT,
					instanceId INT,
					backupsetId INT,
					subclientId INT,
					policyId INT,
					copyId INT,
					mediaAgentId INT,
					srmReportSet INT,
					srmReportType INT,
					trackingPolicyId INT,
					agentlessPolicyId INT,
					workflowId INT,
					sidbStoreId INT,
					exclude INT,
					entityId INT
			)
			CREATE INDEX BackupAssocociationsDetail_taskId_clientId_clientGroupId_Idx ON #BackupAssocociationsDetail(taskId, clientId, clientGroupId)
			INSERT INTO    #BackupAssocociationsDetail
			SELECT DISTINCT dbo.TM_AssocEntity.assocType ,
					dbo.TM_AssocEntity.taskId ,
					dbo.TM_AssocEntity.clientGroupId ,
					dbo.TM_AssocEntity.clientId ,
					dbo.TM_AssocEntity.apptypeId ,
					dbo.TM_AssocEntity.instanceId ,
					dbo.TM_AssocEntity.backupsetId ,
					dbo.TM_AssocEntity.subclientId ,
					dbo.TM_AssocEntity.policyId ,
					dbo.TM_AssocEntity.copyId ,
					dbo.TM_AssocEntity.mediaAgentId,
					dbo.TM_AssocEntity.srmReportSet AS srmReportSet,
					dbo.TM_AssocEntity.srmReportType AS srmReportType,
					dbo.TM_AssocEntity.trackingPolicyId AS trackingPolicyId,
					dbo.TM_AssocEntity.agentlessPolicyId,
					dbo.TM_AssocEntity.workflowId,
					dbo.TM_AssocEntity.sidbStoreId,
					dbo.TM_AssocEntity.exclude,
					0 -- entityID
			FROM	dbo.TM_AssocEntity WITH (NOLOCK)
					INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = dbo.TM_AssocEntity.taskId and TA.taskId=@taskId
INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = dbo.TM_AssocEntity.taskId AND SA.subTaskType = 2
					AND TM_AssocEntity.assocType!=158 -- plan entity
			UNION
			--Expand association for subclients from plan
			SELECT dbo.TM_AssocEntity.assocType ,
					dbo.TM_AssocEntity.taskId ,
					dbo.TM_AssocEntity.clientGroupId ,
					App_Application.clientId ,
					App_Application.apptypeId ,
					App_Application.instance ,
					App_Application.backupset ,
					App_Application.Id,
					dbo.TM_AssocEntity.policyId ,
					dbo.TM_AssocEntity.copyId ,
					dbo.TM_AssocEntity.mediaAgentId,
					dbo.TM_AssocEntity.srmReportSet AS srmReportSet,
					dbo.TM_AssocEntity.srmReportType AS srmReportType,
					dbo.TM_AssocEntity.trackingPolicyId AS trackingPolicyId,
					dbo.TM_AssocEntity.agentlessPolicyId,
					dbo.TM_AssocEntity.workflowId,
					dbo.TM_AssocEntity.sidbStoreId,
					dbo.TM_AssocEntity.exclude,
					dbo.TM_AssocEntity.entityId
			FROM	dbo.TM_AssocEntity WITH (NOLOCK)
					INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = dbo.TM_AssocEntity.taskId and TA.taskId=@taskId
INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = dbo.TM_AssocEntity.taskId AND SA.subTaskType = 2
					LEFT JOIN App_SubclientProp SCP WITH(NOLOCK) ON SCP.attrName = 'Associated Plan' AND SCP.cs_attrName = CHECKSUM(N'Associated Plan')
					AND CAST(TM_AssocEntity.entityId AS NVARCHAR(10)) = SCP.attrVal
					AND SCP.modified = 0
					LEFT JOIN App_Application (NOLOCK) ON App_Application.id = SCP.componentNameId
					WHERE TM_AssocEntity.assocType = 158-- plan entity
			-- If its default analytics schedule then insert associations
			IF @isDefaultDataAnalyticsSched=1
			BEGIN
				-- Inserting into backup associations since security check for DA associations is similar to backup
				INSERT INTO    #BackupAssocociationsDetail
				SELECT 7, -- subclient association type
					@taskId ,
					0 ,
					Ref.clientId,
					Ref.appTypeId,
					Ref.instance,
					Ref.backupset,
					Ref.subclientID ,
					0 ,
					0 ,
					0,
					0 AS srmReportSet,
					0 AS srmReportType,
					0 AS trackingPolicyId,
					0,
					0,
					0,
					0,
					0
				FROM dbo.TM_AssocForDefaultDATask Ref
			END
			if not exists(SELECT 1
			FROM	#BackupAssocociationsDetail AEN
					INNER JOIN #entitiesWithViewSchedCapabilityDetail sec ON
					((capabilities&1073743876) <> 0) AND
					(
						--((EV_BACKUP AND EV_MANAGE_APPLICATION) OR EV_VISIBILITY)
						(
							(((capabilities&2048) <> 0) AND ((capabilities & 4) <> 0)) OR ((capabilities&1073741824) <> 0))
						AND
						(
							( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
								AEN.clientId <> 0 AND AEN.clientId = sec.clientId
								AND (AEN.appTypeId     = sec.appTypeId   OR  AEN.appTypeId = 0  OR sec.appTypeId = 0 )
								AND (AEN.instanceId    = sec.instanceId  OR  AEN.instanceId  = 0  OR sec.instanceId = 0 )
								AND (AEN.backupsetId   = sec.backupSetId OR  AEN.backupsetId = 0  OR sec.backupSetId = 0 )
								AND (AEN.subclientId   = sec.subClientId OR  AEN.subclientId = 0  OR sec.subClientId = 0 )
								AND (AEN.taskId   = sec.taskId OR sec.taskId = 0 )
							)
						)
					)
			UNION ALL
			SELECT 1
			FROM	#BackupAssocociationsDetail AEN
					JOIN APP_ClientGroupAssoc GA WITH (NOLOCK) ON GA.clientGroupId=AEN.clientGroupId AND AEN.clientId = 0	--MAKE SURE ASSOCIATION IS ONLY FOR CLIENT GROUP
					INNER JOIN #entitiesWithViewSchedCapabilityDetail sec ON
					((capabilities&1073743876) <> 0) AND
					(
						--((EV_BACKUP AND EV_MANAGE_APPLICATION) OR EV_VISIBILITY)
						(
							(((capabilities&2048) <> 0) AND ((capabilities & 4) <> 0)) OR ((capabilities&1073741824) <> 0))
						AND
						(
							( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
								(
									(
										AEN.clientId = 0
										AND
										AEN.clientGroupId <> 0
										AND
										(	--ASSOCIATION AT CLIENT GROUP
											sec.clientGroupId = AEN.clientGroupId --SECURITY AT CLIENT GROUP
										)
									)
								)
								AND (AEN.appTypeId     = sec.appTypeId   OR  AEN.appTypeId = 0  OR sec.appTypeId = 0 )
								AND (AEN.instanceId    = sec.instanceId  OR  AEN.instanceId  = 0  OR sec.instanceId = 0 )
								AND (AEN.backupsetId   = sec.backupSetId OR  AEN.backupsetId = 0  OR sec.backupSetId = 0 )
								AND (AEN.subclientId   = sec.subClientId OR  AEN.subclientId = 0  OR sec.subClientId = 0 )
								AND (AEN.taskId   = sec.taskId OR sec.taskId = 0 )
							)
						)
					)
			UNION ALL
			SELECT 1
			FROM	#BackupAssocociationsDetail AEN
					JOIN APP_ClientGroupAssoc GA WITH (NOLOCK) ON GA.clientGroupId=AEN.clientGroupId AND AEN.clientId = 0	--MAKE SURE ASSOCIATION IS ONLY FOR CLIENT GROUP
					INNER JOIN #entitiesWithViewSchedCapabilityDetail sec ON
					((capabilities&1073743876) <> 0) AND
					(
						--((EV_BACKUP AND EV_MANAGE_APPLICATION) OR EV_VISIBILITY)
						(
							(((capabilities&2048) <> 0) AND ((capabilities & 4) <> 0)) OR ((capabilities&1073741824) <> 0))
						AND
						(
							( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
								(
									(
										AEN.clientId = 0
										AND
										AEN.clientGroupId <> 0
										AND
										(
											--SECURITY AT CLIENT WHICH BELONGS TO CLIENT GROUP
											(
												sec.clientId = GA.clientId
												AND	--CHECK FOR WHEN CLIENTID = 0 WILL GIVE FALSE POSITIVE WHEN ASSOCIATION IS NOT A CLIENT ENTITY
												GA.clientId > 0
											)
										)
									)
								)
								AND (AEN.appTypeId     = sec.appTypeId   OR  AEN.appTypeId = 0  OR sec.appTypeId = 0 )
								AND (AEN.instanceId    = sec.instanceId  OR  AEN.instanceId  = 0  OR sec.instanceId = 0 )
								AND (AEN.backupsetId   = sec.backupSetId OR  AEN.backupsetId = 0  OR sec.backupSetId = 0 )
								AND (AEN.subclientId   = sec.subClientId OR  AEN.subclientId = 0  OR sec.subClientId = 0 )
								AND (AEN.taskId   = sec.taskId OR sec.taskId = 0 )
							)
						)
					)
				UNION ALL
				SELECT 1
				FROM    #BackupAssocociationsDetail AEN
				WHERE @doesUserHaveCCBackupCap = 1
				UNION ALL
				SELECT 1
				FROM	#BackupAssocociationsDetail AEN
				INNER JOIN #plansList sec ON  AEN.assocType = 158 -- plan entity
				AND AEN.entityId = sec.planId
				UNION ALL
				SELECT 1
				FROM    dbo.TM_AssocEntity WITH (NOLOCK)
					INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = dbo.TM_AssocEntity.taskId and TA.taskId=@taskId
INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = dbo.TM_AssocEntity.taskId AND SA.subTaskType=3
					LEFT OUTER JOIN APP_ClientGroupAssoc GA WITH (NOLOCK) ON GA.clientGroupId=dbo.TM_AssocEntity.clientGroupId AND dbo.TM_AssocEntity.clientId = 0	--MAKE SURE ASSOCIATION IS ONLY FOR CLIENT GROUP
					INNER JOIN #entitiesWithViewSchedCapabilityDetail sec ON
					((capabilities&1076363268) <> 0) AND
					(
						(
							(
								--((EV_RESTORE_IN_PLACE OR EV_RESTORE_OUTOF_PLACE) AND (EV_MANAGE_APPLICATION)) OR EV_VISIBILITY
								(((capabilities&524288) <> 0) OR ((capabilities&2097152) <> 0)) AND ((capabilities & 4) <> 0))  OR ((capabilities&1073741824) <> 0)
							)
						AND
						(
							( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
								(
									(
										(dbo.TM_AssocEntity.clientId <> 0 AND
											(dbo.TM_AssocEntity.clientId = sec.clientId  OR (
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
												)
											)
										)
										OR
										(
											dbo.TM_AssocEntity.clientId = 0
											AND
											dbo.TM_AssocEntity.clientGroupId <> 0
											AND
											(	--ASSOCIATION AT CLIENT GROUP
												sec.clientGroupId = dbo.TM_AssocEntity.clientGroupId --SECURITY AT CLIENT GROUP
												OR --SECURITY AT CLIENT WHICH BELONGS TO CLIENT GROUP
												(
													sec.clientId = GA.clientId
													AND	--CHECK FOR WHEN CLIENTID = 0 WILL GIVE FALSE POSITIVE WHEN ASSOCIATION IS NOT A CLIENT ENTITY
													GA.clientId > 0
												)
												--dbo.TM_AssocEntity.clientGroupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE clientId=sec.clientId)
											)
										)
									)
									AND (dbo.TM_AssocEntity.appTypeId     = sec.appTypeId   OR  dbo.TM_AssocEntity.appTypeId = 0  OR sec.appTypeId = 0 )
									AND (dbo.TM_AssocEntity.instanceId    = sec.instanceId  OR  dbo.TM_AssocEntity.instanceId  = 0  OR sec.instanceId = 0 )
									AND (dbo.TM_AssocEntity.backupsetId   = sec.backupSetId OR  dbo.TM_AssocEntity.backupsetId = 0  OR sec.backupSetId = 0 )
									AND (dbo.TM_AssocEntity.subclientId   = sec.subClientId OR  dbo.TM_AssocEntity.subclientId = 0  OR sec.subClientId = 0 )
									AND (TA.taskId   = sec.taskId OR sec.taskId = 0 )
								)
								OR --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
								(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
								)
							)
						)
					)
					union all
					SELECT 1
				FROM    dbo.TM_AssocEntity WITH (NOLOCK)
					INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = dbo.TM_AssocEntity.taskId and TA.taskId=@taskId
					INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = dbo.TM_AssocEntity.taskId AND SA.operationType=1007 -- SITE_REPLICATION
					INNER JOIN App_VSAReplication WITH (NOLOCK) ON SA.taskId = App_VSAReplication.taskID AND (App_VSAReplication.flags & @VSAREP_DELETED) = 0
					INNER JOIN App_clientProp WITH (NOLOCK) ON App_clientProp.attrName='Virtual Machine INstance UUID' -- const string    CV_PROP_VIRTUAL_SERVER_INSTANCE_UUID = "Virtual Machine Instance UUID";
					AND App_clientProp.attrval = App_VSAReplication.sourceGuid
					INNER JOIN #entitiesWithViewSchedCapabilityDetail sec ON
					((capabilities&1076363268) <> 0) AND
					(
						(
							(
								--((EV_RESTORE_IN_PLACE OR EV_RESTORE_OUTOF_PLACE) AND (EV_MANAGE_APPLICATION)) OR EV_VISIBILITY
								(((capabilities&524288) <> 0) OR ((capabilities&2097152) <> 0)) AND ((capabilities & 4) <> 0))  OR ((capabilities&1073741824) <> 0)
							)
						AND
						(
							( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
								(
									(dbo.App_clientProp.componentNameId <> 0 AND dbo.App_clientProp.componentNameId = sec.clientId)
								)
								OR --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
								(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
								)
							)
						)
					)
			)
			BEGIN
SET @errorCode =  (1878 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId_in, @errorCode, 0, 2)
				GOTO ERROR_EXIT
			END
		END
	END
	-- There is no need for specific check for saved report. Its covered in security check for admin schedule.
DECLARE @defSubTaskId			INT
SET @defSubTaskId = (SELECT subTaskId FROM TM_SubTask WITH (NOLOCK) WHERE defaultTask = 1 )  --0x1
DECLARE @associationEntity XML
SET @associationEntity = (SELECT
							(SELECT @taskId as '@taskId'
								FOR XML PATH('subtask'), TYPE)
							FOR XML PATH('entity')
							)
DECLARE @taskSecurity XML = @associationEntity
DECLARE @securityAssociations XML
EXEC [dbo].[APPGetEntitySecurityXML]
			@xmlText = @taskSecurity OUTPUT
EXEC [dbo].[sec_getSecurityForEntity] @userId, @securityAssociations OUTPUT, 35, @taskId
declare @taskEntityCount int
set @taskEntityCount = 0
if @subTaskId<>0
begin
	IF ( EXISTS ( SELECT    *
                    FROM      TM_SubTask WITH (NOLOCK)
                    WHERE     subTaskId = @subTaskId
AND subTaskType = 1 )
    )
    BEGIN
		EXEC TM_GetAdminEntityCount @taskId, @subTaskId, @taskEntityCount OUTPUT
    END
	ELSE IF ( NOT EXISTS ( SELECT    *
                    FROM      TM_SubTask WITH (NOLOCK)
                    WHERE     subTaskId = @subTaskId
AND subTaskType = 3 )
    )
    BEGIN
		EXEC TM_GetBackupEntityCount @taskId,@subTaskId, NULL, @taskEntityCount OUTPUT
    END
end
if @taskEntityCount is NULL
begin
	set @taskEntityCount=0
end
--if the user is a hidden createAs user, set ownername as userGroup name
DECLARE @isUser INT
DECLARE @checkForAssocSec INT = 0
DECLARE @createAsName NVARCHAR(250)
DECLARE @createAsId INT = (SELECT runUserId FROM TM_TASK WHERE taskId = @taskId)
SELECT @createAsName = name, @createAsId = id, @isUser = isUser FROM sec_getUserOrGroupNameForUserId(@createAsId)
--CREATE THE TEMP TABLE--
	-- Do assoc sec check for schedule policy alone. Not for schedules
	IF OBJECT_ID('tempdb.dbo.#GetAssociatedEntities_userObjectDetail') IS NOT null
		   DROP TABLE #GetAssociatedEntities_userObjectDetail
create table  #GetAssociatedEntities_userObjectDetail ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	if exists(select 1 from tm_task where taskType=4 and taskId=@taskId)
	begin
		if (@o_isUserAdmin=0)
		begin
			-- If its not admin user and its a schedule policy, check security for returning associations
			-- If user is admin then we dont need to check for security
			set @checkForAssocSec = 1
			EXEC sec_getUserObjects @userId, 0, 0, '#GetAssociatedEntities_userObjectDetail'
		end
	end
	if @checkForAssocSec = 0
	begin
		Insert into #GetAssociatedEntities_userObjectDetail(capabilities, flag, commCellId, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subClientId,
		mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId, reviewSetId, querySetId, downloadSetId, ermId, legalHoldId, tagId, cdPolicyId, complianceReportId, taskId)
		VALUES (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
	end
	else
	begin
		if exists(select 1 from #GetAssociatedEntities_userObjectDetail sec
where sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0 )
		begin
			set @checkForAssocSec = 0
		end
	end
        IF OBJECT_ID('tempdb.dbo.#AssocEntityDetail') IS NOT null
            DROP TABLE #AssocEntityDetail
        IF OBJECT_ID('tempdb.dbo.#AssocEntityWOSecurity') IS NOT null
            DROP TABLE #AssocEntityWOSecurity
        SELECT * INTO #AssocEntityWOSecurity
        FROM TM_AssocEntity (NoLock)
        WHERE TaskID = @taskId
		AND assocType!=158 -- plan entity
        IF @isDefaultDataAnalyticsSched=1
        BEGIN
        	-- Inserting into backup associations since security check for DA associations is similar to backup
        	INSERT INTO  #AssocEntityWOSecurity(assocType, taskId, flags, clientId, apptypeId ,instanceId ,backupsetId, subclientId, clientGroupId,
			policyId, copyId ,srmReportSet ,srmReportType , exclude , trackingPolicyId, MediaAgentId ,	agentlessPolicyId ,workflowId ,
			sidbStoreId	,libraryId , logMonitoringPolicyId,created )
		SELECT 7, -- subclient association type
			@taskId ,
			0 ,
			Ref.clientId,
			Ref.appTypeId,
			Ref.instance,
			Ref.backupset,
			Ref.subclientID ,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0
			FROM dbo.TM_AssocForDefaultDATask Ref
	END
		INSERT INTO  #AssocEntityWOSecurity(assocType, taskId, flags, clientId, apptypeId ,instanceId ,backupsetId, subclientId, clientGroupId,
			policyId, copyId ,srmReportSet ,srmReportType , exclude , trackingPolicyId, MediaAgentId ,	agentlessPolicyId ,workflowId ,
			sidbStoreId	,libraryId , logMonitoringPolicyId,created,entityId )
		SELECT assocType, -- plan entity association type
			@taskId ,
			0 ,
		ISNULL(	App_Application.clientId,0),
		ISNULL(	App_Application.appTypeId,0),
		ISNULL(	App_Application.instance,0),
		ISNULL(	App_Application.backupset,0),
		ISNULL(	App_Application.ID,0) ,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			entityId
		FROM	dbo.TM_AssocEntity WITH (NOLOCK)
					INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = dbo.TM_AssocEntity.taskId and TA.taskId=@taskId
INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = dbo.TM_AssocEntity.taskId AND SA.subTaskType = 2
					LEFT JOIN App_SubclientProp SCP WITH(NOLOCK) ON SCP.attrName = 'Associated Plan' AND SCP.cs_attrName = CHECKSUM(N'Associated Plan')
					AND CAST(TM_AssocEntity.entityId AS NVARCHAR(10)) = SCP.attrVal
					AND SCP.modified =0
					LEFT JOIN App_Application (NOLOCK) ON App_Application.id = SCP.componentNameId
					WHERE TM_AssocEntity.assocType = 158-- plan entity
        SELECT DISTINCT TM_AssocEntity.assocType,
                TM_AssocEntity.taskId,
                TM_AssocEntity.clientGroupId,
CASE WHEN TM_AssocEntity.assocType != 158 THEN TM_AssocEntity.clientId ELSE 0 END AS clientId,
CASE WHEN TM_AssocEntity.assocType != 158 THEN TM_AssocEntity.apptypeId ELSE 0 END AS apptypeId,
CASE WHEN TM_AssocEntity.assocType != 158 THEN TM_AssocEntity.instanceId ELSE 0 END AS instanceId,
CASE WHEN TM_AssocEntity.assocType != 158 THEN TM_AssocEntity.backupsetId ELSE 0 END AS backupsetId,
CASE WHEN TM_AssocEntity.assocType != 158 THEN TM_AssocEntity.subclientId ELSE 0 END AS subclientId,
                TM_AssocEntity.policyId,
                archGroup.name AS policyName,
                TM_AssocEntity.copyId,
                archGroupCopy.name AS copyName,
                TM_AssocEntity.srmReportSet AS srmReportSet,
                TM_AssocEntity.srmReportType AS srmReportType,
                '' AS srmReportName,
                TM_AssocEntity.mediaAgentId,
                MAName.name AS mediaAgentName,
                dbo.APP_ClientGroup.name AS clientGroupName,
CASE WHEN TM_AssocEntity.assocType != 158 THEN dbo.APP_Client.name ELSE NULL END AS clientName,
CASE WHEN TM_AssocEntity.assocType != 158 THEN dbo.APP_Client.displayName ELSE NULL END AS displayName,
CASE WHEN TM_AssocEntity.assocType != 158 THEN dbo.APP_iDAType.name ELSE NULL END AS appTypeName,
CASE WHEN TM_AssocEntity.assocType != 158 THEN dbo.APP_Application.subclientName ELSE NULL END AS subclientName,
CASE WHEN TM_AssocEntity.assocType != 158 THEN dbo.APP_BackupSetName.name ELSE NULL END AS backupsetName,
CASE WHEN TM_AssocEntity.assocType != 158 THEN dbo.APP_InstanceName.name ELSE NULL END AS instanceName,
                TM_AssocEntity.trackingPolicyId,
                dbo.VTPolicy.policyName AS trackingPolicyName,
                TM_AssocEntity.agentlessPolicyId AS agentlessPolicyId,
                TM_AssocEntity.exclude AS exclude,
				TM_AssocEntity.workflowId as workflowId,
                WFD.Name as workFlowName,
                TM_AssocEntity.sidbStoreId as SidbStoreId,
                dbo.IdxSIDBStore.SIDBStoreName as SidbStoreName,
CASE WHEN TM_AssocEntity.assocType = 132 THEN TM_AssocEntity.entityId ELSE NULL END as seaDataSourceId,
CASE WHEN TM_AssocEntity.assocType = 132 THEN SEDataSource.DataSourceName ELSE NULL END as seaDataSourceName,
CASE WHEN TM_AssocEntity.assocType = 158 THEN TM_AssocEntity.entityId ELSE NULL END as planId,
CASE WHEN TM_AssocEntity.assocType = 158 THEN P.name ELSE NULL END as planName
        INTO    #AssocEntityDetail
		FROM
		(
			SELECT * FROM #AssocEntityWOSecurity WITH (NOLOCK)
			WHERE  @checkForAssocSec = 0
			UNION
			SELECT TM_AssocEntity.* FROM #AssocEntityWOSecurity TM_AssocEntity WITH (NOLOCK)
				INNER JOIN #GetAssociatedEntities_userObjectDetail associatedEntities on @checkForAssocSec <>0 AND (
				(associatedEntities.clientGroupId = TM_AssocEntity.clientGroupId
					AND (associatedEntities.clientId = TM_AssocEntity.clientId OR TM_AssocEntity.clientGroupId>0) -- If client groupId >0 then security check can be done for CG only
					AND ( TM_AssocEntity.clientGroupId>0 OR associatedEntities.appTypeId= TM_AssocEntity.appTypeId OR associatedEntities.appTypeId=0 OR TM_AssocEntity.appTypeId=0)
					AND ( TM_AssocEntity.clientGroupId>0 OR associatedEntities.instanceId= TM_AssocEntity.instanceId OR associatedEntities.instanceId=0 OR TM_AssocEntity.instanceId=0)
					AND ( TM_AssocEntity.clientGroupId>0 OR associatedEntities.backupsetId= TM_AssocEntity.backupsetId OR associatedEntities.backupsetId=0 OR TM_AssocEntity.backupsetId=0)
					AND ( TM_AssocEntity.clientGroupId>0 OR associatedEntities.subClientId= TM_AssocEntity.subClientId OR associatedEntities.subClientId=0 OR TM_AssocEntity.subClientId=0)
					AND  associatedEntities.mediaAgentId = TM_AssocEntity.mediaAgentId
					AND associatedEntities.libraryId = TM_AssocEntity.libraryId
					AND associatedEntities.archGroupId = TM_AssocEntity.policyId
					AND associatedEntities.vtPolicyId = TM_AssocEntity.trackingPolicyId
					AND associatedEntities.workflowId  = TM_AssocEntity.workflowId
					AND (TM_AssocEntity.assocType!=158 OR TM_AssocEntity.clientId>0)
					-- Do this security check for plan schedule policies associated to plan only when plan is associated to some subclient.
					-- Else return plan association only when plan is visible which is done below.
					)
				)
				UNION
				SELECT TM_AssocEntity.* FROM #AssocEntityWOSecurity TM_AssocEntity
				INNER JOIN #plansList sec ON @checkForAssocSec <>0
				AND TM_AssocEntity.assocType = 158 -- plan entity
				AND TM_AssocEntity.entityId = sec.planId
			) TM_AssocEntity
                LEFT OUTER JOIN dbo.APP_ClientGroup WITH (NOLOCK) ON TM_AssocEntity.clientGroupId = dbo.APP_ClientGroup.id
                LEFT OUTER JOIN dbo.APP_Client WITH (NOLOCK) ON TM_AssocEntity.clientId = dbo.APP_Client.id
                LEFT OUTER JOIN dbo.APP_iDAType WITH (NOLOCK) ON TM_AssocEntity.apptypeId = dbo.APP_iDAType.type AND TM_AssocEntity.apptypeId > 0
                LEFT OUTER JOIN dbo.APP_Application WITH (NOLOCK) ON TM_AssocEntity.subclientId = dbo.APP_Application.id
                LEFT OUTER JOIN dbo.APP_BackupSetName WITH (NOLOCK) ON TM_AssocEntity.backupsetId = dbo.APP_BackupSetName.id
                LEFT OUTER JOIN dbo.APP_InstanceName WITH (NOLOCK) ON TM_AssocEntity.instanceId = dbo.APP_InstanceName.id
                LEFT OUTER JOIN dbo.archGroup WITH (NOLOCK) ON TM_AssocEntity.policyId = dbo.archGroup.id
                LEFT OUTER JOIN dbo.archGroupCopy WITH (NOLOCK) ON TM_AssocEntity.copyId = dbo.archGroupCopy.id  and dbo.archGroupCopy.id > 0
                --LEFT OUTER JOIN dbo.CRReportTemplates WITH (NOLOCK) ON TM_AssocEntity.srmReportType = CRReportTemplates.id -- CRReportTemplates table is being removed
                LEFT OUTER JOIN dbo.VTPolicy WITH (NOLOCK) ON TM_AssocEntity.trackingPolicyId = dbo.VTPolicy.policyId
                LEFT OUTER JOIN dbo.APP_Client as MAName WITH (NOLOCK) ON TM_AssocEntity.mediaAgentId = MAName.id
				LEFT OUTER JOIN dbo.WF_Definition as WFD WITH (NOLOCK) ON TM_AssocEntity.workflowId = WFD.WorkflowId
				LEFT OUTER JOIN dbo.IdxSIDBStore WITH (NOLOCK) ON TM_AssocEntity.sidbStoreId = IdxSIDBStore.SIDBStoreId AND TM_AssocEntity.sidbStoreId>0
LEFT OUTER JOIN dbo.SEDataSource WITH (NOLOCK) ON TM_AssocEntity.entityId = SEDataSource.DataSourceId AND TM_AssocEntity.assocType = 132
LEFT OUTER JOIN App_Plan P WITH(NOLOCK) ON TM_AssocEntity.entityId = P.id AND TM_AssocEntity.assocType = 158
        WHERE   TM_AssocEntity.taskId = @taskId --AND TM_AssocEntity.exclude = 0
        IF OBJECT_ID('tempdb.dbo.#AssocWorkFlowEntityDetail') IS NOT null
            DROP TABLE #AssocWorkFlowEntityDetail
	IF OBJECT_ID('tempdb.dbo.#AssocEntityWOSecurity') IS NOT null
            DROP TABLE #AssocEntityWOSecurity
		SELECT assocId, assocType, taskId, E.flags, E.created, E.workflowId, E.clientId, entityTitle, workflowOption, exclude, WFD.Name wfName
		INTO #AssocWorkFlowEntityDetail
		FROM TM_AssocWorkFlowEntity E
		JOIN dbo.WF_Definition as WFD WITH (NOLOCK) ON E.workflowId = WFD.WorkflowId
        WHERE taskId = @taskId
----------------------------
--CONSTRUCT THE XML---------
----------------------------
        SET @xmlText = ( SELECT			--TASKLIST
                                ( SELECT		--TASK
                                            TASK.taskId AS '@taskId',
                                            TASK.taskName AS '@taskName',
                                            Task.taskType AS '@taskType',
                                            TASK.alertId AS '@alertId',
                                            TASK.ownerId AS '@ownerId',
                                            TASK.runUserId AS '@runUserId',
                                            TASK.description AS '@description',
                                            USR.name AS '@ownerName',
                                            TASK.policyType AS '@policyType',
                                            TASK.GUID AS '@GUID',
											@taskEntityCount AS '@associatedObjects' ,
                                            ( SELECT -- alert
                                                        TASK.alertId AS '@alertId',
                                                        NT.notificationName AS '@alertName'
                                              FROM      dbo.NTnotificationRule
                                                        AS NT WITH (NOLOCK)
                                              WHERE     NT.id = TASK.alertId
                                            FOR
                                              XML PATH('alert'),
                                                  TYPE
                                            ),
                                            ( SELECT-- origCC
                                                        TASK.origCCId AS '@commCellId'
                                            FOR
                                              XML PATH('originalCC'),
                                                  TYPE
                                            ),
                                            ( SELECT  --TaskFlags
                                                        TASK.disabled AS '@disabled',
                                                        TASK.uninstalled AS '@uninstalled',
                                                        TASK.isEZOperation AS '@isEZOperation',
														CASE TASK.flags&32
														WHEN 32 THEN 1
														ELSE 0
														END '@forDDB',
CASE WHEN TASK.flags & 0x40 <> 0 THEN 1
														ELSE 0
														END AS '@isEdgeDrive',
CASE WHEN TASK.flags & 0x4 <> 0 THEN 1
														ELSE 0
														END AS '@isSystem',
CASE WHEN TASK.flags & 0x80 <> 0 THEN 1
                                                        ELSE 0
                                                        END AS '@isIndexBackup',
CASE WHEN TASK.flags & 0x80000 <> 0 THEN 1
														ELSE 0
														END AS '@isEdiscovery'
                                            FOR
                                              XML PATH('taskFlags'),
                                                  TYPE
                                            ),
											(SELECT
												TASK.taskId AS '@taskId',
												TASK.taskName AS '@taskName'
											FOR
												XML PATH ('task'),
													TYPE
											),
											(SELECT
														@taskSecurity
											FOR
												XML PATH ('taskSecurity'),
													TYPE
											),
											(SELECT
														@securityAssociations
											FOR
												XML PATH ('securityAssociations'),
													TYPE
											),
											(SELECT
												CASE @isUser
												WHEN 1 THEN (SELECT @createAsName AS 'user/@userName' ,
																	@createAsId AS 'user/@userId' FOR  XML PATH('user'), TYPE)
												ELSE (SELECT @createAsName AS '@userGroupName' ,
										                     @createAsId AS '@userGroupId' FOR  XML PATH('userGroup'), TYPE)
												END
											  FOR
												XML PATH ('createAs'),
													TYPE
											)
                                FOR
                                  XML PATH('task'),
                                      TYPE
                                ),
                                ( SELECT  --APPGROUP
                                            ( SELECT  --GROUP SELECTED
                                                        TFIL.filter_value AS '@appGroupId',
                                                        AIT.groupName AS '@appGroupName'
                                              FROM      TM_AssocFilter AS TFIL WITH (NOLOCK)
                                                        LEFT JOIN APP_AppTypeGroup as AIT ON TFIL.filter_value = AIT.appTypeGroupId
                                                        AND AIT.typeOfGroup = 3
                                                        WHERE TFIL.filter_type = 1 AND TFIL.taskId = @taskId
                                            FOR
                                              XML PATH('appGroups'),
                                                  TYPE
                                            ),
                                            ( SELECT  --TYPES SELECTED
                                                        TFIL.filter_value AS '@appTypeId',
                                                        AIT.name as '@appTypeName'
                                              FROM      TM_AssocFilter AS TFIL WITH (NOLOCK),
                                              APP_iDAType as AIT
                                              WHERE     TFIL.filter_type = 2
                                                        AND TFIL.taskId = @taskId
														AND TFIL.filter_value = AIT.type
                                            FOR
                                              XML PATH('appTypes'),
                                                  TYPE
                                            )
                                FOR
                                  XML PATH('appGroup'),
                                      TYPE
                                ),
                                ( SELECT DISTINCT --ASSOC
                                            ASSOC.assocType '@_type_',
                                            ASSOC.clientGroupId '@clientGroupId',
                                            ASSOC.clientGroupName '@clientGroupName',
                                            ASSOC.clientId '@clientId',
                                            ASSOC.clientName '@clientName',
											ASSOC.displayName '@displayName',
                                            ASSOC.apptypeId '@applicationId',
                                            ASSOC.appTypeName '@appName',
                                            ASSOC.policyId '@storagePolicyId',
                                            ASSOC.policyName '@storagePolicyName',
                                            ASSOC.mediaAgentId '@mediaAgentId',
                                            ASSOC.mediaAgentName '@mediaAgentName',
                                            ASSOC.instanceId '@instanceId',
					    CASE CHARINDEX('', ASSOC.instanceName)
						WHEN 0 THEN	ASSOC.instanceName
						ELSE
							'|'+REPLACE(ASSOC.instanceName,
									'', '|#12!')
						END '@instanceName',
                                            ASSOC.backupsetId '@backupsetId',
                                            ASSOC.copyId '@copyId',
                                            ASSOC.copyName '@copyName',
                                            ASSOC.srmReportSet '@srmReportSet',
                                            ASSOC.srmReportType '@srmTemplateId',
                                            ASSOC.srmReportName '@srmTemplateName',
                                            ASSOC.backupsetName '@backupsetName',
                                            ASSOC.subclientId '@subclientId',
                                            ASSOC.subclientName '@subclientName',
                                            ASSOC.trackingPolicyId '@trackingPolicyId',
                                            ASSOC.trackingPolicyName '@trackingPolicyName',
                                            ASSOC.agentlessPolicyId '@agentlessPolicyId',
                                            ASSOC.workflowid '@workflowId',
                                            ASSOC.workflowName '@workflowName',
                                            ASSOC.SidbStoreId '@sidbStoreId',
                                            ASSOC.SidbStoreName '@sidbStoreName',
											ASSOC.seaDataSourceId '@seaDataSourceId',
											ASSOC.seaDataSourceName '@seaDataSourceName',
											ASSOC.planId '@planId',
											ASSOC.planName '@planName',
                                            ASSOC.exclude 'flags/@exclude'
                                  FROM      #AssocEntityDetail AS ASSOC
                                  WHERE     ASSOC.taskId = @taskId
                                FOR
                                  XML PATH('associations'),
                                      TYPE
                                ),
                                ( SELECT DISTINCT --ASSOC
											WASSOC.workflowOption '@workflowJobOptions',
                                            WASSOC.entityTitle '@workflowTitle',
                                            WASSOC.assocType 'workflow/@_type_',
                                            WASSOC.workflowid 'workflow/@workflowId',
                                            WASSOC.wfName 'workflow/@workflowName',
                                            WASSOC.exclude 'workflow/flags/@exclude',
                                            WASSOC.clientId 'clientEntity/@clientId'
                                  FROM      #AssocWorkFlowEntityDetail AS WASSOC
                                  WHERE     WASSOC.taskId = @taskId
                                FOR
                                  XML PATH('workflows'),
                                      TYPE
                                ),
                                ( SELECT		--SUBTASKINFO
                                            ( SELECT		--SUBTASK
                                                        STASK.subTaskId AS '@subTaskId',
                                                        STASK.subTaskType AS '@subTaskType',
                                                        STASK.operationType AS '@operationType',
                                                        STASK.flags AS '@flags' ,
                                                        STASK.subTaskOrder AS '@subTaskOrder',
                                                        STASK.subTaskName AS '@subTaskName',
														( SELECT		--SUBTASK
																	STASK.subTaskId AS '@subtaskId',
																	STASK.subTaskName AS '@subtaskName'
														FOR
														  XML PATH('subTask'),
															  TYPE
														)
                                            FOR
                                              XML PATH('subTask'),
                                                  TYPE
                                            ),
                                            ( SELECT  --OPTIONS
														SOPTIONS.xmlValue.value('/TMMsg_JobOption[1]/@workflowJobOptions','nvarchar(max)') as '@workflowJobOptions',
                                                        SOPTIONS.xmlValue.query('/TMMsg_JobOption/*')
                                              FROM      TM_SubTaskXMLOptions SOPTIONS WITH (NOLOCK)
                                              WHERE     SOPTIONS.subTaskId = STASK.subTaskId
                                            FOR
                                              XML PATH('options'),
                                                  TYPE
                                            ),
                                            ( SELECT --PATTERN
                                                        PAT.patternId '@patternId',
                                                        PAT.name '@name',
                                                        PAT.flags '@flags',
                                                        PAT.freq_type '@freq_type',
                                                        PAT.freq_interval '@freq_interval',
                                                        PAT.freq_relative_interval '@freq_relative_interval',
                                                        PAT.freq_recurrence_factor '@freq_recurrence_factor',
                                                        PAT.freq_subday_interval '@freq_subday_interval',
                                                        PAT.skipOccurence '@skipOccurence',
                                                        PAT.skipDayNumber '@skipDayNumber',
                                                        PAT.local_start_date '@active_start_date',
                                                        PAT.active_start_time '@active_start_time',
                                                        PAT.local_end_date '@active_end_date',
                                                        PAT.active_end_time '@active_end_time',
                                                        PAT.active_end_occurence '@active_end_occurence',
                                                        PAT.description '@description',
                                                        PAT.freq_restart_interval '@freq_restart_interval',
                                                        ( SELECT  --TimeZone
                                                                    PAT.tzId AS '@TimeZoneID' --,
                                                                    --ST.TimeZoneName AS '@TimeZoneName'
                                                        FOR
                                                          XML PATH('timeZone'),
                                                              TYPE
                                                        ),
                                                        ( SELECT  --Calendar
                                                                    PAT.calendarId AS '@calendarId',
                                                                    CAL.name AS '@calendarName'
                                                        FOR
                                                          XML PATH('calendar'),
                                                              TYPE
                                                        ),
														( SELECT  --Repeat Pattern
														REP.onOccurence AS '@occurrence',
														REP.onDay AS '@onDay',
														REP.repeatOn AS '@repeatOn',
														REP.onDayNumber AS '@onDayNumber',
														1				  AS '@exception',
														REP.description AS '@description'
														FROM TM_RepeatPattern AS REP WITH (NOLOCK)
														WHERE REP.patternId = PAT.patternId
														FOR
														XML
														PATH('repeatPattern') ,
														TYPE
														),
														(
															SELECT '0' '@week', '0' '@day',
																CASE WHEN (PAT.freq_interval & @SundayBit) = @SundayBit THEN '1' ELSE NULL END '@Sunday',
																CASE WHEN (PAT.freq_interval & @MondayBit) = @MondayBit THEN '1' ELSE NULL END '@Monday',
																CASE WHEN (PAT.freq_interval & @TuesdayBit) = @TuesdayBit THEN '1' ELSE NULL END '@Tuesday',
																CASE WHEN (PAT.freq_interval & @WednesdayBit) = @WednesdayBit THEN '1' ELSE NULL END '@Wednesday',
																CASE WHEN (PAT.freq_interval & @ThursdayBit) = @ThursdayBit THEN '1' ELSE NULL END '@Thursday',
																CASE WHEN (PAT.freq_interval & @FridayBit) = @FridayBit THEN '1' ELSE NULL END '@Friday',
																CASE WHEN (PAT.freq_interval & @SaturdayBit) = @SaturdayBit THEN '1' ELSE NULL END '@Saturday'
															WHERE PAT.freq_type = @freqTypeWeekly OR PAT.freq_type = @freqTypeEvery
															FOR XML PATH('daysToRun'),TYPE
														),
														(
															SELECT  PAT.freq_interval '@onDayNumber'
															WHERE PAT.freq_type = @freqTypeMonthly
															FOR XML PATH('daysToRun'),TYPE
														),
														(
															SELECT  PAT.freq_relative_interval '@week', PAT.freq_interval '@day'
															WHERE PAT.freq_type = @freqTypeMonthlyRelative
															FOR XML PATH('daysToRun'),TYPE
														)
                                              FROM      TM_Pattern AS PAT WITH (NOLOCK),
                                                        TM_PatternAssoc PASOC WITH (NOLOCK),
                                                        --SchedTimeZone AS ST,
                                                        APP_CustomCalendar AS CAL WITH (NOLOCK)
                                              WHERE     [PASOC].[patternId] = PAT.[patternId]
                                                        AND PASOC.subTaskId = STASK.subTaskId
                                                        --AND ST.TimeZoneID = PAT.tzId
                                                        AND CAL.id = PAT.calendarId
                                            FOR
                                              XML PATH('pattern'),
                                                  TYPE
                                            )
                                  FROM      TM_subTask AS STASK WITH (NOLOCK)
								  --MR184594 - DO NOT SHOW SCHEDULES WHICH ARE DONE RUNNING (LIKE ONE TIME) WHEN VIEWING SCHEDULE POLICY
								  LEFT OUTER JOIN TM_PatternAssoc (NOLOCK) PAS ON PAS.subTaskId = STASK.subTaskId
								  LEFT OUTER JOIN TM_Pattern (NOLOCK) PAT ON PAT.patternId = PAS.patternId
                                  WHERE     STASK.taskId = @taskId
								  AND
								  (
									PAT.deleted = 0 OR PAT.deleted IS NULL
								  )
                                FOR
                                  XML PATH('subTasks'),
                                      TYPE
                                )
                         FROM   TM_TASK AS TASK WITH (NOLOCK)
                         LEFT OUTER JOIN dbo.UMUsers AS USR WITH (NOLOCK) ON TASK.ownerId = USR.id
						LEFT OUTER JOIN dbo.NTnotificationRule WITH (NOLOCK) ON dbo.NTnotificationRule.id = TASK.alertId
                         WHERE  TASK.taskId = @taskId
                       FOR
                         XML PATH('taskInfo'),
                             ROOT('TMMsg_GetTaskDetailResp')
                       )
		-- Changes required for mapping values to enums
		SET @patternCount = @xmltext.value('count(//.[@patternId])','int')
	IF @xmlText IS null
	BEGIN
		SET @xmlText = '<TMMsg_GetTaskDetailResp/>'
	END
ERROR_EXIT:
    IF @errorCode != 0
    BEGIN
        SET @xmlText = (
            SELECT  1           as TAG,
                    NULL        as Parent,
                @errorCode      as [TMMsg_GenericResp!1!errorCode],
                @errorString    as [TMMsg_GenericResp!1!errorMessage]
            FOR XML EXPLICIT
        )
    END
	SELECT @xmlText AS o_xmlText
END
IF OBJECT_ID('tempdb.dbo.#OwnedClients') IS NOT null
	DROP TABLE #OwnedClients
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetTaskDetail')
	delete from GxQscripts where name = 'TM_GetTaskDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetTaskDetail')
	delete from GXDBVersions where aliasname = 'TM_GetTaskDetail'
GO

insert into GXDBVersions values(2, 'TM_GetTaskDetail',  'v1.62.2.30.4.1', 'TM_GetTaskDetail', 'v1.62.2.30.4.1')
GO

