

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetStoragePolicyTaskList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetStoragePolicyTaskList.sp,v $ $Id: TM_GetStoragePolicyTaskList.sp,v 1.14.2.15.4.1 2021/01/13 14:35:43 mnatarajan Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 02/14/2012
-- Description:	Get the list of OSC schedules.
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_GetStoragePolicyTaskList')
BEGIN
	print '>>> Drop Stored Procedure: TM_GetStoragePolicyTaskList <<<'
	drop procedure TM_GetStoragePolicyTaskList
END
IF EXISTS (select * from GxQscripts where name='TM_GetStoragePolicyTaskList')
	delete from GxQscripts where name = 'TM_GetStoragePolicyTaskList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetStoragePolicyTaskList')
	delete from GXDBVersions where aliasname = 'TM_GetStoragePolicyTaskList'
GO
print '... Creating Procedure: TM_GetStoragePolicyTaskList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_GetStoragePolicyTaskList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userId integer,
  @localeId_in integer,
  @policyId integer,
  @copyId integer,
  @xmlText XML	OUTPUT
AS
BEGIN
SET NOCOUNT ON
	DECLARE @type INT
DECLARE @allBackup INT = 1
DECLARE @allRestore INT = 8
DECLARE @allAdmin INT = 2000
DECLARE @subTaskTypeAdmin INT = 1
DECLARE @subTaskTypeBackup INT = 2
DECLARE @subTaskTypeRestore INT = 3
	DECLARE @allTasks INT = 0
	DECLARE @showAllTasks INT = 0
--INITIALIZATION
	DECLARE @taskTble TABLE ( taskId INT )
	DECLARE @operationFilter TABLE ( operationType INT )
	DECLARE @subTaskFilter TABLE ( subTaskType INT )
    --GET OPERATION TYPES
    INSERT  INTO @operationFilter
            SELECT  ref.value('@val', 'int') AS operationType
            FROM    @xmlText.nodes('TMMsg_GetTaskListReq/filter/operationTypes') R ( ref )
	--IF object_id('tempdb.dbo.#entitiesWithViewSchedCapability') is not null
	--	DROP TABLE #entitiesWithViewSchedCapability
	--create table  #entitiesWithViewSchedCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null, [clientGroupId] int	NOT null, [clientId]      int	NOT null, [appTypeId]     int	NOT null, [instanceId]    int	NOT null, [backupsetId]   int	NOT null, [subClientId]   int	NOT null, [mediaAgentId]  int	NOT null, [libraryId]     int	NOT null, [archGroupId]   int	NOT null, [vtContainerId] int	NOT null, [vtPolicyId]    int	NOT null, [vtShelfId]     int	NOT null, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	--EXEC sec_getUserObjects @userId, 0, 0, '#entitiesWithViewSchedCapability'
	-- needed so that we can join on a user with no privilages
	--IF (SELECT COUNT(*) FROM #entitiesWithViewSchedCapability) = 0
	--AVOID DUPLICATE ROWS WHEN CHECKING OWNER
	--BEGIN
	--	INSERT INTO #entitiesWithViewSchedCapability (capabilities, flag, commCellId, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subClientId,
	--	mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId, reviewSetId, querySetId, downloadSetId, ermId, legalHoldId, tagId, cdPolicyId, complianceReportId, taskId)
	--	VALUES (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
	--END
	--CREATE THE TEMP TABLE--
	IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
		DROP TABLE #AssocEntity
	CREATE TABLE #AssocEntity
	(
			assocType INT,
			taskId INT,
			clientGroupId INT,
			clientId INT,
			apptypeId INT,
			instanceId INT,
			backupsetId INT,
			subclientId INT,
			policyId INT,
			policyName NVARCHAR(1024),
			copyId INT,
			mediaAgentId INT,
			mediaAgentName NVARCHAR(1024),
			srmReportSet INT,
			srmReportType INT,
			srmReportName NVARCHAR(1024),
			copyName  NVARCHAR(1024),
			clientGroupName  NVARCHAR(1024),
			clientName  NVARCHAR(1024),
			displayName  NVARCHAR(1024),
			appTypeName  NVARCHAR(1024),
			subclientName  NVARCHAR(1024),
			backupsetName  NVARCHAR(1024),
			instanceName NVARCHAR(1024),
			trackingPolicyId INT,
			agentlessPolicyId INT,
			sidbStoreId int,
			sidbStoreName NVARCHAR(1024),
			exclude INT,
			planId INT DEFAULT 0,
			planName NVARCHAR(1024) DEFAULT ''
	)
	--DO ADMIN SCHEDULES SECURITY CHECK
	INSERT INTO    #AssocEntity
	SELECT DISTINCT dbo.TM_AssocEntity.assocType ,
		dbo.TM_AssocEntity.taskId ,
		dbo.TM_AssocEntity.clientGroupId ,
		dbo.TM_AssocEntity.clientId ,
		dbo.TM_AssocEntity.apptypeId ,
		dbo.TM_AssocEntity.instanceId ,
		dbo.TM_AssocEntity.backupsetId ,
		dbo.TM_AssocEntity.subclientId ,
		dbo.TM_AssocEntity.policyId ,
		dbo.archGroup.name AS policyName ,
		dbo.TM_AssocEntity.copyId ,
		dbo.TM_AssocEntity.mediaAgentId,
		MAEntity.name AS mediaAgentName,
		dbo.TM_AssocEntity.srmReportSet AS srmReportSet,
		dbo.TM_AssocEntity.srmReportType AS srmReportType,
		'' AS srmReportName,
		dbo.archGroupCopy.name AS copyName ,
		dbo.APP_ClientGroup.name AS clientGroupName ,
		dbo.APP_Client.name AS clientName ,
		dbo.APP_Client.displayName AS displayName ,
		dbo.APP_iDAType.name AS appTypeName ,
		dbo.APP_Application.subclientName ,
		dbo.APP_BackupSetName.name AS backupsetName ,
		dbo.APP_InstanceName.name AS instanceName,
		dbo.TM_AssocEntity.trackingPolicyId AS trackingPolicyId,
		dbo.TM_AssocEntity.agentlessPolicyId,
		dbo.TM_AssocEntity.sidbStoreId,
		dbo.IdxSIDBStore.SIDBStoreName as SidbStoreName,
		dbo.TM_AssocEntity.exclude,
		0,
		''
	FROM dbo.TM_AssocEntity WITH (NOLOCK)
	INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = dbo.TM_AssocEntity.taskId
INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = dbo.TM_AssocEntity.taskId AND SA.subTaskType IN (1, 4, 5)
	INNER JOIN #entitiesWithViewSchedCapability sec ON  @userId = TA.ownerId OR
	((capabilities&1073741825) <> 0) AND
	(
		--EV_SCHEDULE_ADMIN  OR EV_VISIBILITY
		(((capabilities&1) <> 0) OR ((capabilities&1073741824) <> 0))
		AND
		(
			( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
				(
					(
						dbo.TM_AssocEntity.clientId = sec.clientId
						OR
						(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
						)
					)
					OR
					(
						dbo.TM_AssocEntity.clientId = 0
						AND
						(sec.clientGroupId = dbo.TM_AssocEntity.clientGroupId OR
							dbo.TM_AssocEntity.clientGroupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId=sec.clientId)
						)
					)
				)
				AND (dbo.TM_AssocEntity.policyId = sec.archGroupId OR  (dbo.TM_AssocEntity.policyId = 0  AND sec.archGroupId = 0) )
				AND (dbo.TM_AssocEntity.trackingPolicyId  = sec.vtPolicyId OR  (dbo.TM_AssocEntity.trackingPolicyId = 0  AND sec.vtPolicyId = 0 ))
				AND (TA.taskId   = sec.taskId OR sec.taskId = 0 )
				--IGNORE SECURITY CHECK FOR ADMIN TASK FOR NOW, IT WILL BE DONE AT THE VIEW LEVEL BELOW
				AND NOT
				(
					dbo.TM_AssocEntity.clientId = 0 AND dbo.TM_AssocEntity.clientGroupId = 0 AND dbo.TM_AssocEntity.appTypeId = 0
					AND dbo.TM_AssocEntity.instanceId = 0 AND dbo.TM_AssocEntity.backupsetId = 0 AND dbo.TM_AssocEntity.subclientId = 0
					AND dbo.TM_AssocEntity.MediaAgentId = 0 AND dbo.TM_AssocEntity.policyId = 0 AND dbo.TM_AssocEntity.trackingPolicyId = 0 AND TM_AssocEntity.copyId = 0
				)
			)
			OR --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
			(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
			)
		)
	)
	LEFT OUTER JOIN dbo.APP_ClientGroup WITH (NOLOCK) ON dbo.TM_AssocEntity.clientGroupId = dbo.APP_ClientGroup.id
	LEFT OUTER JOIN dbo.APP_Client WITH (NOLOCK) ON dbo.TM_AssocEntity.clientId = dbo.APP_Client.id
	LEFT OUTER JOIN dbo.APP_iDAType WITH (NOLOCK) ON dbo.TM_AssocEntity.apptypeId = dbo.APP_iDAType.type		--MR:113482 - BACKUP COPY CAN BE CREATED FOR SUBCLIENT
	LEFT OUTER JOIN dbo.APP_Application WITH (NOLOCK) ON dbo.TM_AssocEntity.subclientId = dbo.APP_Application.id
	LEFT OUTER JOIN dbo.APP_BackupSetName WITH (NOLOCK) ON dbo.TM_AssocEntity.backupsetId = dbo.APP_BackupSetName.id
	LEFT OUTER JOIN dbo.APP_InstanceName WITH (NOLOCK) ON dbo.TM_AssocEntity.instanceId = dbo.APP_InstanceName.id
	LEFT OUTER JOIN dbo.APP_Client MAEntity WITH (NOLOCK) ON dbo.TM_AssocEntity.mediaAgentId = MAEntity.id
	LEFT OUTER JOIN dbo.archGroup WITH (NOLOCK) ON dbo.TM_AssocEntity.policyId = dbo.archGroup.id
	LEFT OUTER JOIN dbo.archGroupCopy WITH (NOLOCK) ON dbo.TM_AssocEntity.copyId = dbo.archGroupCopy.id
	LEFT OUTER JOIN dbo.IdxSIDBStore WITH (NOLOCK) ON dbo.TM_AssocEntity.sidbStoreId = IdxSIDBStore.SIDBStoreId
	--LEFT OUTER JOIN dbo.CRReportTemplates WITH (NOLOCK) ON TM_AssocEntity.srmReportType = CRReportTemplates.id -- CRReportTemplates table is being removed
	WHERE
	dbo.TM_AssocEntity.exclude = 0
	AND
	(
		(
			dbo.TM_AssocEntity.policyId = @policyId
			AND
			(dbo.TM_AssocEntity.copyId = @copyId OR @copyId = 0 OR dbo.TM_AssocEntity.copyId = 0)
		)
		OR
dbo.TM_AssocEntity.assocType = 155
	)
	--select 'debug1',* from  #AssocEntity
IF NOT EXISTS(SELECT 1 FROM @operationFilter WHERE operationType = 2000)
	BEGIN
	--ADD NON ADMIN SCHEDULES FOR STORAGE POLICY AND COPYID LEVEL
	--DO BACKUP SCHEDULES SECURITY CHECK
	INSERT INTO    #AssocEntity
	SELECT DISTINCT ASS.assocType ,
		ASS.taskId ,
		ASS.clientGroupId ,
		CASE WHEN assocType!=158 THEN ASS.clientId ELSE 0 END,
		CASE WHEN assocType!=158 THEN ASS.apptypeId ELSE 0 END,
		CASE WHEN assocType!=158 THEN ASS.instanceId ELSE 0 END,
		CASE WHEN assocType!=158 THEN ASS.backupsetId ELSE 0 END,
		CASE WHEN assocType!=158 THEN ASS.subclientId ELSE 0 END,
		ASS.policyId ,
		'' AS policyName ,
		ASS.copyId ,
		ASS.mediaAgentId,
		MAEntity.name AS mediaAgentName,
		ASS.srmReportSet AS srmReportSet,
		ASS.srmReportType AS srmReportType,
		'' AS srmReportName,
		'' AS copyName ,
		dbo.APP_ClientGroup.name AS clientGroupName ,
		CASE WHEN assocType!=158 THEN dbo.APP_Client.name ELSE NULL END AS clientName ,
		CASE WHEN assocType!=158 THEN dbo.APP_Client.displayName ELSE NULL END AS displayName ,
		CASE WHEN assocType!=158 THEN dbo.APP_iDAType.name ELSE NULL END AS appTypeName ,
		CASE WHEN assocType!=158 THEN dbo.APP_Application.subclientName ELSE NULL END AS subclientName,
		CASE WHEN assocType!=158 THEN dbo.APP_BackupSetName.name ELSE NULL END AS backupsetName ,
		CASE WHEN assocType!=158 THEN dbo.APP_InstanceName.name ELSE NULL END AS instanceName,
		ASS.trackingPolicyId AS trackingPolicyId,
		ASS.agentlessPolicyId,
		0,
		'',
		ASS.exclude,
CASE WHEN ASS.assocType = 158 THEN ASS.entityID ELSE 0 END,
		dbo.App_Plan.name
	FROM
	(
		SELECT assocId , assocType , taskId	,flags , created , clientGroupId , clientId , apptypeId , instanceId , backupsetId , subclientId , policyId	, copyId , srmReportSet	,srmReportType ,exclude	,trackingPolicyId ,MediaAgentId	,agentlessPolicyId ,workflowId,sidbStoreId	,libraryId, logMonitoringPolicyId, entityId FROM dbo.TM_AssocEntity WITH (NOLOCK)
WHERE assocType!=158
		UNION
		SELECT assocId , assocType , taskId	,flags , TM_AssocEntity.created , clientGroupId , App_Application.clientId , App_Application.apptypeId , App_Application.instance , App_Application.backupset, App_Application.Id , policyId	, copyId , srmReportSet	,srmReportType ,exclude	,trackingPolicyId ,MediaAgentId	,agentlessPolicyId ,workflowId,sidbStoreId	,libraryId, logMonitoringPolicyId, entityId FROM dbo.TM_AssocEntity WITH (NOLOCK)
		LEFT JOIN App_SubclientProp SCP WITH(NOLOCK) ON SCP.attrName = 'Associated Plan' AND SCP.cs_attrName = CHECKSUM(N'Associated Plan')
					AND CAST(TM_AssocEntity.entityId AS NVARCHAR(10)) = SCP.attrVal
					AND SCP.modified = 0
		LEFT JOIN App_Application (NOLOCK) ON App_Application.id = SCP.componentNameId
WHERE TM_AssocEntity.assocType = 158
	) ASS
	INNER JOIN TM_Task TK WITH (NOLOCK) ON TK.taskId = ASS.taskId
	INNER JOIN APP_Application AS APP WITH (NOLOCK) ON APP.dataArchGrpId = @policyId
INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = TK.taskId AND SA.subTaskType=2
	INNER JOIN #entitiesWithViewSchedCapability sec ON  @userId = TK.ownerId OR
	((capabilities&1073743876) <> 0) AND
	(
		--((EV_BACKUP AND EV_MANAGE_APPLICATION) OR EV_VISIBILITY)
		(
			(((capabilities&2048) <> 0) AND ((capabilities & 4) <> 0)) OR ((capabilities&1073741824) <> 0))
		AND
		(
			( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
				(
					(
						(
							ASS.clientId = sec.clientId
							OR
							(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
							)
						)
						OR
						(
							ASS.clientId = 0
							AND
							(sec.clientGroupId = ASS.clientGroupId OR
								ASS.clientGroupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId=sec.clientId)
							)
						)
					)
					AND (ASS.appTypeId     = sec.appTypeId   OR  ASS.appTypeId = 0  OR sec.appTypeId = 0 )
					AND (ASS.instanceId    = sec.instanceId  OR  ASS.instanceId  = 0  OR sec.instanceId = 0 )
					AND (ASS.backupsetId   = sec.backupSetId OR  ASS.backupsetId = 0  OR sec.backupSetId = 0 )
					AND (ASS.subclientId   = sec.subClientId OR  ASS.subclientId = 0  OR sec.subClientId = 0 )
					AND (ASS.taskId = sec.taskId OR sec.taskId = 0 )
				)
				OR --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
				(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
				)
			)
		)
	)
	LEFT OUTER JOIN dbo.APP_ClientGroup WITH (NOLOCK) ON ASS.clientGroupId = dbo.APP_ClientGroup.id
	LEFT OUTER JOIN dbo.APP_Client WITH (NOLOCK) ON ASS.clientId = dbo.APP_Client.id
	LEFT OUTER JOIN dbo.APP_Client MAEntity WITH (NOLOCK) ON ASS.mediaAgentId = MAEntity.id
	LEFT OUTER JOIN dbo.APP_iDAType WITH (NOLOCK) ON ASS.apptypeId = dbo.APP_iDAType.type
	LEFT OUTER JOIN dbo.APP_Application WITH (NOLOCK) ON ASS.subclientId = dbo.APP_Application.id
	LEFT OUTER JOIN dbo.APP_BackupSetName WITH (NOLOCK) ON ASS.backupsetId = dbo.APP_BackupSetName.id
	LEFT OUTER JOIN dbo.APP_InstanceName WITH (NOLOCK) ON ASS.instanceId = dbo.APP_InstanceName.id
	LEFT OUTER JOIN dbo.App_Plan WITH (NOLOCK) ON ASS.entityID = App_Plan.Id AND
ASS.assocType = 158
	WHERE
	(
		( ASS.[clientId] = [APP].[clientId] )
		OR
		( ASS.[clientId] = 0 AND ASS.[clientGroupId] IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE clientId=[APP].[clientId])
		)
		OR -- SCHEDULE POLICY FOR ALL CLIENTS
		(
			ASS.clientGroupId = 0 AND ASS.clientId = 0 AND ASS.MediaAgentId = 0 AND ASS.policyId = 0 AND ASS.trackingPolicyId = 0 AND
			ASS.agentlessPolicyId = 0 AND ASS.srmReportSet = 0 AND ASS.srmReportType = 0 AND ASS.workflowId = 0 AND
			ASS.sidbStoreId = 0 AND ASS.libraryId = 0 AND ASS.logMonitoringPolicyId = 0
		)
	)
	AND ( ASS.[apptypeId] = [APP].[appTypeId]
			OR ASS.[apptypeId] = 0
		)
	AND ( ASS.[instanceId] = [APP].[instance]
			OR ASS.[instanceId] = 0
		)
	AND ( ASS.[backupsetId] = [APP].[backupSet]
			OR ASS.[backupsetId] = 0
		)
	AND ( ASS.[subclientId] = [APP].[id]
			OR ASS.[subclientId] = 0
		)
	AND    -- FILTER OUT ASSOCIATION FROM SCHEDULE POLICIES WHICH ARE FOR A DIFFERENT APPTYPE, ONDEMAND BACKUPSET AND EXCLUDED ASSOCIATION
	(
TK.taskType = 2
		OR
		(
TK.taskType = 4
			AND
			(
				ASS.backupsetId = 0
				OR
				(
					ASS.backupsetId <> 0
					AND
					NOT EXISTS (SELECT componentNameId
							FROM App_BackupSetProp WITH (NOLOCK)
							WHERE attrName = 'OnDemand Backupset' AND attrVal=1 AND componentNameId=ASS.backupsetId
							)
				)
			)
			AND
				ASS.exclude <> 1
			AND
			(
				NOT EXISTS ( SELECT taskId
							FROM [TM_AssocFilter] WITH (NOLOCK)
							WHERE taskId = TK.taskId
						)
				OR
				(
					EXISTS ( SELECT taskId
								FROM [TM_AssocFilter] WITH (NOLOCK)
								WHERE taskId = TK.taskId
							)
					AND EXISTS
					(
						SELECT taskId
						FROM [TM_AssocFilter] FLT WITH (NOLOCK)
						WHERE FLT.taskId = TK.taskId
						AND
						(  -- filter_type, 1 is appgroup and 2 is individual apptype
							(
								FLT.filter_type = 2
								AND
								(
									FLT.filter_value = ASS.apptypeId
									OR
									(
										ASS.apptypeId = 0
										AND	--FILTER OUT BY AGENT TYPE
										(	--CLIENT ASSOCIATION
											FLT.filter_value = [APP].[appTypeId]  -- Match it against appTypeId from App_application table.
										)
									)
									OR -- SCHEDULE POLICY FOR ALL CLIENTS
									(
										(
											ASS.clientGroupId = 0 AND ASS.clientId = 0 AND ASS.MediaAgentId = 0 AND ASS.policyId = 0 AND ASS.trackingPolicyId = 0 AND
											ASS.agentlessPolicyId = 0 AND ASS.srmReportSet = 0 AND ASS.srmReportType = 0 AND ASS.workflowId = 0 AND
											ASS.sidbStoreId = 0 AND ASS.libraryId = 0 AND ASS.logMonitoringPolicyId = 0
										)
										AND
										(
											FLT.filter_value = APP.appTypeId	-- WHICH HAVE APPTYPE FOR SCHEDULE AGENT TYPE
										)
									)
								)
							)
							OR
							(
								FLT.filter_type = 1
								AND EXISTS
								(
									SELECT FLT.filter_value
									FROM [APP_AppTypeGroupAssoc] WITH (NOLOCK)
									WHERE appGroupId = FLT.filter_value
									AND
									(
										appTypeId = ASS.apptypeId
										OR
										(
											ASS.apptypeId = 0
											AND	--FILTER OUT BY AGENT GROUP
											(
												appTypeId = [APP].[appTypeId]	 -- Match it against appTypeId from App_application table.
											)
										)
										OR -- SCHEDULE POLICY FOR ALL CLIENTS
										(
											(
												ASS.clientGroupId = 0 AND ASS.clientId = 0 AND ASS.MediaAgentId = 0 AND ASS.policyId = 0 AND ASS.trackingPolicyId = 0 AND
												ASS.agentlessPolicyId = 0 AND ASS.srmReportSet = 0 AND ASS.srmReportType = 0 AND ASS.workflowId = 0 AND
												ASS.sidbStoreId = 0 AND ASS.libraryId = 0 AND ASS.logMonitoringPolicyId = 0
											)
											AND
											(
												apptypeId = APP.appTypeId	-- WHICH HAVE APPTYPE FOR SCHEDULE AGENT TYPE
											)
										)
									)
								)
							)
						)
					)
				)
			)
		)
	)
	END
	--select 'debug2',* from  #AssocEntity
	----ADD RESTORE SCHEDULES
	--INSERT INTO    #AssocEntity
	--SELECT DISTINCT [TA].assocType ,
	--	[TA].taskId ,
	--	[TA].clientGroupId ,
	--	[TA].clientId ,
	--	[TA].apptypeId ,
	--	[TA].instanceId ,
	--	[TA].backupsetId ,
	--	[TA].subclientId ,
	--	[TA].policyId ,
	--	'' AS policyName ,
	--	[TA].copyId ,
	--	[TA].mediaAgentId,
	--	MAEntity.name AS mediaAgentName,
	--	[TA].srmReportSet AS srmReportSet,
	--	[TA].srmReportType AS srmReportType,
	--	'' AS srmReportName,
	--	'' AS copyName ,
	--	dbo.APP_ClientGroup.name AS clientGroupName ,
	--	dbo.APP_Client.name AS clientName ,
	--	dbo.APP_Client.displayName AS displayName ,
	--	dbo.APP_iDAType.name AS appTypeName ,
	--	dbo.APP_Application.subclientName ,
	--	dbo.APP_BackupSetName.name AS backupsetName ,
	--	dbo.APP_InstanceName.name AS instanceName,
	--	[TA].trackingPolicyId AS trackingPolicyId,
	--	[TA].agentlessPolicyId,
	--	[TA].exclude
	--FROM    [TM_AssocEntity] AS TA WITH (NOLOCK)
	--INNER JOIN TM_Task TK WITH (NOLOCK) ON TK.taskId = [TA].taskId
	--INNER JOIN APP_Application AS APP WITH (NOLOCK) ON APP.dataArchGrpId = @policyId
	--INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = TA.taskId AND SA.subTaskType=SUB_TASK_TYPE_RESTORE
	--INNER JOIN #entitiesWithViewSchedCapability sec ON @userId = TK.ownerId OR
	--((capabilities&1076363268) <> 0) AND
	--(
	--	--((EV_RESTORE_IN_PLACE OR EV_RESTORE_OUTOF_PLACE) AND (EV_MANAGE_APPLICATION)) OR EV_VISIBILITY)
	--	(((((capabilities&524288) <> 0) OR ((capabilities&2097152) <> 0)) AND ((capabilities & 4) <> 0))  OR ((capabilities&1073741824) <> 0)) AND
	--	(
	--		(
	--			(
	--				[TA].clientId  = sec.clientId
	--				OR
	--				(
	--					sec.clientId = 0 AND sec.clientGroupId = 0
	--					AND sec.archGroupId = 0 AND sec.libraryId = 0 AND sec.vtContainerId = 0 AND sec.vtPolicyId = 0 AND sec.vtShelfId = 0 AND sec.reviewSetId=0
	--					AND sec.querySetId = 0 AND sec.downloadSetId = 0 AND sec.ermId = 0 AND sec.legalHoldId = 0 AND sec.tagId = 0 AND sec.cdPolicyId = 0
	--					AND sec.complianceReportId = 0 AND sec.taskId = 0 AND sec.workflowId = 0 AND sec.logMonitoringPolicyId = 0 AND sec.arrayId = 0 AND sec.cloudId = 0
	--					AND sec.userGroupId = 0 AND sec.providerId = 0
	--				)
	--			)
	--			OR
	--			([TA].clientId = 0 AND sec.clientGroupId = [TA].clientGroupId)
	--		)
	--		AND ([TA].appTypeId     = sec.appTypeId   OR  [TA].appTypeId = 0  OR sec.appTypeId = 0 )
	--		AND ([TA].instanceId    = sec.instanceId  OR  [TA].instanceId  = 0  OR sec.instanceId = 0 )
	--		AND ([TA].backupsetId   = sec.backupSetId OR  [TA].backupsetId = 0  OR sec.backupSetId = 0 )
	--		AND ([TA].subclientId   = sec.subClientId OR  [TA].subclientId = 0  OR sec.subClientId = 0 )
	--		AND NOT
	--		(
	--			[TA].clientId = 0 AND [TA].clientGroupId = 0 AND [TA].appTypeId = 0 AND
	--			[TA].instanceId = 0 AND [TA].backupsetId = 0 AND [TA].subclientId = 0 AND
	--			[TA].MediaAgentId = 0 AND [TA].policyId = 0 AND [TA].trackingPolicyId = 0
	--		)
	--	)
	--)
	--LEFT OUTER JOIN dbo.APP_ClientGroup WITH (NOLOCK) ON [TA].clientGroupId = dbo.APP_ClientGroup.id
	--LEFT OUTER JOIN dbo.APP_Client WITH (NOLOCK) ON [TA].clientId = dbo.APP_Client.id
	--LEFT OUTER JOIN dbo.APP_Client MAEntity WITH (NOLOCK) ON [TA].mediaAgentId = MAEntity.id
	--LEFT OUTER JOIN dbo.APP_iDAType WITH (NOLOCK) ON [TA].apptypeId = dbo.APP_iDAType.type
	--LEFT OUTER JOIN dbo.APP_Application WITH (NOLOCK) ON [TA].subclientId = dbo.APP_Application.id
	--LEFT OUTER JOIN dbo.APP_BackupSetName WITH (NOLOCK) ON [TA].backupsetId = dbo.APP_BackupSetName.id
	--LEFT OUTER JOIN dbo.APP_InstanceName WITH (NOLOCK) ON [TA].instanceId = dbo.APP_InstanceName.id
	--WHERE   ( ( [TA].[clientId] = [APP].[clientId] )
	--			OR ( [TA].[clientId] = 0 AND [TA].[clientGroupId] IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE clientId=[APP].[clientId]))
	--		)
	--		AND ( [TA].[apptypeId] = [APP].[appTypeId]
	--				OR [TA].[apptypeId] = 0
	--			)
	--		AND ( [TA].[instanceId] = [APP].[instance]
	--				OR [TA].[instanceId] = 0
	--			)
	--		AND ( [TA].[backupsetId] = [APP].[backupSet]
	--				OR [TA].[backupsetId] = 0
	--			)
	--		AND ( [TA].[subclientId] = [APP].[id]
	--				OR [TA].[subclientId] = 0
	--			)
--	select 'debug3',* from  #AssocEntity
	--MR:161005 - REMOVE IF ENTITY HAS BEEN EXCLUDED
	DELETE [#AssocEntity]
	FROM
	(
		SELECT taskId FROM TM_AssocEntity (NOLOCK)
		WHERE exclude = 1
		AND policyId = @policyId
		AND
		(
			copyId = @copyId OR @copyId = 0
		)
	) T
	WHERE T.taskId = [#AssocEntity].taskId
	--LIST OF JOB TASK
	INSERT  INTO @taskTble
	SELECT DISTINCT
			taskId
	FROM    [#AssocEntity]
--	SELECT 'debug3',* from @tasktble
--	select 'debug4',* from tm_task where taskid in ( select taskid from @tasktble)
	----------------------------
	--CONSTRUCT THE XML---------
	----------------------------
-- -- SP BODY BEGIN : TM_ComputeStartTimeForClientTbl.spb ----------------------------------------------------------------------------------------------------------------------------------
IF object_id('tempdb.dbo.#Clients_Timezone_StartTime') is NOT NULL
BEGIN
	DROP TABLE #Clients_Timezone_StartTime
END
CREATE TABLE #Clients_Timezone_StartTime(clientId INT, timezoneName NVARCHAR(MAX), jobStartTime INT DEFAULT -1, taskID INT DEFAULT 0, patternID INT DEFAULT 0 )
CREATE CLUSTERED INDEX Clients_Timezone_StartTime_clientId_taskID_Index ON #Clients_Timezone_StartTime (clientId, taskID)
IF object_id('tempdb.dbo.#SubClients_Timezone_StartTime') is NOT NULL
BEGIN
	DROP TABLE #SubClients_Timezone_StartTime
END
CREATE TABLE #SubClients_Timezone_StartTime(appId INT, timezoneName NVARCHAR(MAX), jobStartTime INT DEFAULT -1, taskID INT DEFAULT 0)
CREATE CLUSTERED INDEX SubClients_Timezone_StartTime_appId_Index ON #SubClients_Timezone_StartTime (appId)
-- -- SP BODY END : TM_ComputeStartTimeForClientTbl.spb ------------------------------------------------------------------------------------------------------------------------------------
	INSERT INTO #Clients_Timezone_StartTime(clientId , timezoneName , jobStartTime , taskID , patternID )
	SELECT DISTINCT AssocEntity.clientId, NULL, -1, AssocEntity.taskId, 0
	FROM #AssocEntity AssocEntity
	WHERE AssocEntity.clientId>0
	-- Call stored procedure to compute timezone and start time for clients.
	EXEC TM_ComputeStarttimeForClient
	-- for plan entities association, reset subclient and its parent info
	UPDATE #AssocEntity
	SET clientId =0, apptypeId = 0,instanceId = 0,backupsetId = 0,subclientId = 0 ,
	clientName = NULL,displayName =NULL,appTypeName = NULL,subclientName =NULL ,backupsetName =NULL, instanceName = NULL
WHERE assocType = 158
	IF OBJECT_ID('tempdb.dbo.#AssocEntity_Final') IS NOT null
		DROP TABLE #AssocEntity_Final
	SELECT DISTINCT assocType , taskId, clientGroupId  , clientGroupName , clientId  , clientName ,displayName , apptypeId,appTypeName,
		policyId  , policyName ,mediaAgentId ,mediaAgentName , instanceId  ,instanceName, backupsetId ,copyId ,copyName , srmReportSet ,
		srmReportType ,srmReportName , backupsetName ,subclientId  , subclientName , agentlessPolicyId ,SidbStoreId ,SidbStoreName ,exclude , planId, planName
	INTO #AssocEntity_Final
	FROM #AssocEntity
	SET @xmlText =
		( SELECT	 --TASKLIST
			( SELECT 	--TASK
				[TM_Task].taskId AS '@taskId' ,
				[TM_Task].taskName AS '@taskName' ,
				[TM_Task].taskType AS '@taskType' ,
				[TM_Task].alertId AS '@alertId' ,
				[NTnotificationRule].notificationName AS '@alertName' ,
				[TM_Task].ownerId AS '@ownerId' ,
				[TM_Task].runUserId AS '@runUserId' ,
				[TM_Task].description AS '@description' ,
				USR.login AS '@ownerName' ,
				[TM_Task].policyType AS '@policyType' ,
				--dbo.GetEntityCount([TM_Task].taskId) AS '@associatedObjects' ,
				[TM_Task].GUID ,
				( SELECT -- alert
							[TM_Task].alertId AS '@alertId' ,
							NT.notificationName AS '@alertName'
					FROM    dbo.NTnotificationRule
							AS NT WITH (NOLOCK)
					WHERE   NT.id = [TM_Task].alertId
				FOR
					XML PATH('alert') ,
						TYPE
				) ,
				( SELECT-- origCC
							[TM_Task].origCCId AS '@commCellId'
				FOR
					XML PATH('originalCC') ,
						TYPE
				) ,
				( SELECT  --TaskFlags
							[TM_Task].disabled AS '@disabled' ,
							[TM_Task].uninstalled AS '@uninstalled' ,
							[TM_Task].isEZOperation AS '@isEZOperation',
CASE WHEN [TM_Task].flags & 0x80 <> 0 THEN 1
							ELSE 0
							END AS '@isIndexBackup'
				FOR
					XML PATH('taskFlags') ,
						TYPE
				)
			FOR
				XML PATH('task') ,
					TYPE
			) ,
			( SELECT  --APPGROUP
						( SELECT  --GROUP SELECTED
									TFIL.filter_value AS '@appGroupId'
							FROM    TM_AssocFilter
									AS TFIL
							WHERE   TFIL.filter_type = 1
									AND TFIL.taskId = [TM_Task].taskId
						FOR
							XML PATH('appGroups') ,
								TYPE
						) ,
						( SELECT  --TYPES SELECTED
									TFIL.filter_value AS '@appTypeId'
							FROM    TM_AssocFilter
									AS TFIL
							WHERE   TFIL.filter_type = 2
									AND TFIL.taskId = [TM_Task].taskId
						FOR
							XML PATH('appTypes') ,
								TYPE
						)
			FOR
				XML PATH('appGroup') ,
					TYPE
			) ,
			( SELECT --NEXT SCHEDULES
						datediff(second, '01/01/1970', dbo.ClientLocalToUTCTime(RAS.nextRunTime,2)) '@nextScheduleTime',
						--ABS(datediff(second, '01/01/1970', dbo.UTCToClientLocalTime(GETDATE(), 2)) - datediff(second, '01/01/1970', dbo.UTCToClientLocalTime(RAS.nextRunTime, 2))) '@relativeTime',
						ABS(datediff(second, '01/01/1970', RAS.nextRunTime) - datediff(second, '01/01/1970', GETDATE())) '@relativeTime',
						(SELECT ASSOC.clientId '@clientId'
							FOR
							XML PATH('client') ,
								TYPE
						) ,
						(SELECT STASK.subTaskId '@subtaskId',
							STASK.taskId '@taskId'
							FOR
							XML PATH('subtask') ,
								TYPE
						) ,
						(SELECT TimeZoneId '@TimeZoneID' FROM SchedTimeZone WITH (NOLOCK)
							WHERE TimeZoneStdName = dbo.GetClientTimeZone(ASSOC.clientId)
							FOR
							XML PATH('timeZone') ,
								TYPE
						)
				FROM		#AssocEntity_Final AS ASSOC
						INNER JOIN TM_SubTask AS STASK WITH (NOLOCK) ON STASK.taskId = ASSOC.taskId
						INNER JOIN TM_PatternAssoc
								AS PAS WITH (NOLOCK) ON PAS.subTaskId = STASK.subTaskId
						INNER JOIN TM_Pattern
								AS PAT WITH (NOLOCK) ON PAT.patternId = PAS.patternId
						INNER JOIN TM_RunTime
								AS NRT WITH (NOLOCK) ON NRT.patternId = PAS.patternId
						INNER JOIN TM_RunTimeAssoc
								AS RAS WITH (NOLOCK) ON RAS.runTimeId = NRT.runTimeId
AND (PAT.tzId <> 1001 OR (PAT.tzId = 1001 AND RAS.timeZoneNames = dbo.GetClientTimeZone(ASSOC.clientId)))
								AND RAS.processed = 0
								AND PAT.deleted = 0
						INNER JOIN #Clients_Timezone_StartTime Clients_Timezone_StartTime ON
							Clients_Timezone_StartTime.clientID = ASSOC.clientId
							AND Clients_Timezone_StartTime.jobStartTime = RAS.jobStartTime
							AND Clients_Timezone_StartTime.taskId = STASK.taskId
							-- Pick the runtime association where jobStartTime matches.
						LEFT OUTER JOIN APP_Application AS APP WITH (NOLOCK) ON APP.dataArchGrpId = @policyId OR @policyId = 0
				WHERE		STASK.subTaskId = PAS.subTaskId
						AND STASK.taskId = [TM_Task].taskId
AND PAT.tzId = 1001
				AND   ( ( ( [policyId] = @policyId
								OR ( [policyId] = 0 AND @policyId = 0 )
							)
						AND ( [copyId] = @copyId
								OR ( [copyId] = 0 AND [policyId] <> 0)
								OR @copyId = 0
							)
						) OR	--NEEDED TO SHOW ASSOCIATION AT STORAGE POLICY LEVEL
						(
							(( ASSOC.[clientId] = [APP].[clientId] )
								OR ( ASSOC.[clientId] = 0) --AND [CA].[clientId] = ASSOC.[clientId]
							)
							AND ( ASSOC.[apptypeId] = [APP].[appTypeId]
									OR ASSOC.[apptypeId] = 0
								)
							AND ( ASSOC.[instanceId] = [APP].[instance]
									OR ASSOC.[instanceId] = 0
								)
							AND ( ASSOC.[backupsetId] = [APP].[backupSet]
									OR ASSOC.[backupsetId] = 0
								)
							AND ( ASSOC.[subclientId] = [APP].[id]
									OR ASSOC.[subclientId] = 0
								)
						)
					)
			FOR
				XML PATH('nextScheduleTimes') ,
					TYPE
			) ,
			( SELECT DISTINCT --ASSOC
						ASSOC.assocType '@_type_' ,
						ASSOC.clientGroupId '@clientGroupId' ,
						ASSOC.clientGroupName '@clientGroupName' ,
						ASSOC.clientId '@clientId' ,
						ASSOC.clientName '@clientName' ,
						ASSOC.displayName '@displayName' ,
						ASSOC.apptypeId '@applicationId' ,
						ASSOC.appTypeName '@appName' ,
						ASSOC.policyId '@storagePolicyId' ,
						ASSOC.policyName '@storagePolicyName' ,
						ASSOC.mediaAgentId '@mediaAgentId',
						ASSOC.mediaAgentName '@mediaAgentName',
						ASSOC.instanceId '@instanceId' ,
						CASE CHARINDEX('', ASSOC.instanceName)
							WHEN 0 THEN	ASSOC.instanceName
							ELSE
								'|'+REPLACE(ASSOC.instanceName,
								'', '|#12!')
							END '@instanceName',
						ASSOC.backupsetId '@backupsetId' ,
						ASSOC.copyId '@copyId' ,
						ASSOC.copyName '@copyName' ,
						ASSOC.srmReportSet '@srmReportSet',
						ASSOC.srmReportType '@srmTemplateId',
						ASSOC.srmReportName '@srmTemplateName',
						ASSOC.backupsetName '@backupsetName' ,
						ASSOC.subclientId '@subclientId' ,
						ASSOC.subclientName '@subclientName',
						ASSOC.agentlessPolicyId '@agentlessPolicyId',
						ASSOC.SidbStoreId '@sidbStoreId',
						ASSOC.SidbStoreName '@sidbStoreName',
						ASSOC.planId '@planId',
						ASSOC.planName '@planName',
						ASSOC.exclude 'flags/@exclude'
				FROM      #AssocEntity_Final AS ASSOC
				LEFT OUTER JOIN APP_Application AS APP WITH (NOLOCK) ON APP.dataArchGrpId = @policyId OR @policyId = 0
				--INNER JOIN APP_ClientGroupAssoc AS CA ON CA.clientId = APP.clientId OR CA.clientGroupId = ASSOC.clientGroupId --THIS IS SLOWING RESP, DON'T REMBER WHY NEEDED
				WHERE     ASSOC.taskId = [TM_Task].taskId
				AND  ((( ASSOC.[policyId] = @policyId
								OR ( ASSOC.[policyId] = 0 AND @policyId = 0 )
							)
						AND ( ASSOC.[copyId] = @copyId
								OR ( ASSOC.[copyId] = 0 AND @copyId = 0 )
							)
						)
						OR	--NEEDED TO SHOW ASSOCIATION AT STORAGE POLICY LEVEL
						(
							(( ASSOC.[clientId] = [APP].[clientId] )
								OR ( ASSOC.[clientId] = 0) --AND [CA].[clientId] = ASSOC.[clientId]
							)
							AND ( ASSOC.[apptypeId] = [APP].[appTypeId]
									OR ASSOC.[apptypeId] = 0
								)
							AND ( ASSOC.[instanceId] = [APP].[instance]
									OR ASSOC.[instanceId] = 0
								)
							AND ( ASSOC.[backupsetId] = [APP].[backupSet]
									OR ASSOC.[backupsetId] = 0
								)
							AND ( ASSOC.[subclientId] = [APP].[id]
									OR ASSOC.[subclientId] = 0
								)
						)
					)
				AND exclude = 0
			FOR
				XML PATH('associations') ,
					TYPE
			) ,
			( SELECT		--SUBTASKINFO
						--TASK RUN TIME FROM TM_RunTime WITH (NOLOCK) Table
						NRT.nextTime AS '@nextScheduleTime' ,
						ABS(datediff(second, '01/01/1970', GETUTCDATE()) - datediff(second, '01/01/1970', NRT.nextRunTime)) '@relativeTime',
						( SELECT	DISTINCT --SUBTASK
									STASK.subTaskId AS '@subTaskId' ,
									STASK.subTaskType AS '@subTaskType' ,
									STASK.operationType AS '@operationType' ,
									STASK.flags AS '@flags' ,
									STASK.subTaskOrder AS '@subTaskOrder' ,
									STASK.subTaskName AS '@subTaskName'
						FOR
							XML PATH('subTask') ,
								TYPE
						) ,
						( SELECT --PATTERN
									PAT.patternId '@patternId' ,
									PAT.name '@name' ,
									PAT.flags '@flags' ,
									PAT.freq_type '@freq_type' ,
									PAT.freq_interval '@freq_interval' ,
									PAT.freq_relative_interval '@freq_relative_interval' ,
									PAT.freq_recurrence_factor '@freq_recurrence_factor' ,
									PAT.freq_subday_interval '@freq_subday_interval' ,
									PAT.skipOccurence '@skipOccurence' ,
									PAT.skipDayNumber '@skipDayNumber' ,
									PAT.local_start_date '@active_start_date' ,
									PAT.active_start_time '@active_start_time' ,
									PAT.local_end_date '@active_end_date' ,
									PAT.active_end_time '@active_end_time' ,
									PAT.active_end_occurence '@active_end_occurence' ,
									PAT.description '@description' ,
									PAT.freq_restart_interval '@freq_restart_interval',
									( SELECT  --TimeZone
									PAT.tzId AS '@TimeZoneID'
									FOR
									XML
									PATH('timeZone') ,
									TYPE
									) ,
									( SELECT  --Calendar
									PAT.calendarId AS '@calendarId'
									FOR
									XML
									PATH('calendar') ,
									TYPE
									),
									( SELECT  --Repeat Pattern
									REP.onOccurence AS '@occurrence',
									REP.onDay AS '@onDay',
									REP.repeatOn AS '@repeatOn',
									REP.onDayNumber AS '@onDayNumber',
									1				  AS '@exception',
									REP.description AS '@description'
									FROM TM_RepeatPattern AS REP WITH (NOLOCK)
									WHERE REP.patternId = PAT.patternId
									FOR
									XML
									PATH('repeatPattern') ,
									TYPE
									)
							FROM    TM_Pattern AS PAT WITH (NOLOCK),
									TM_PatternAssoc PASOC WITH (NOLOCK)
							WHERE   [PASOC].[patternId] = PAT.[patternId]
									AND PASOC.subTaskId = STASK.subTaskId
									AND PAT.deleted = 0
						FOR
							XML PATH('pattern') ,
								TYPE
						) ,
						( SELECT  --OPTIONS
									SOPTIONS.xmlValue.query('/TMMsg_JobOption/*') AS 'options'
							FROM    TM_SubTaskXMLOptions SOPTIONS WITH (NOLOCK)
							WHERE   SOPTIONS.subTaskId = STASK.subTaskId
						FOR
							XML PATH('') ,
								TYPE
						)
				FROM      TM_subTask AS STASK WITH (NOLOCK)
						LEFT OUTER JOIN TM_PatternAssoc
							AS PAS WITH (NOLOCK) ON PAS.subTaskId = STASK.subTaskId
						LEFT OUTER JOIN TM_Pattern
							AS PAT WITH (NOLOCK) ON PAT.patternId = PAS.patternId
						LEFT OUTER JOIN TM_RunTime
							AS NRT WITH (NOLOCK) ON NRT.patternId = PAS.patternId
									AND NRT.processed = 0
				WHERE     STASK.subTaskId = PAS.subTaskId
						AND STASK.taskId = [TM_Task].taskId
						AND PAT.deleted = 0
			FOR
				XML PATH('subTasks') ,
					TYPE
			)
			FROM   dbo.TM_Task WITH (NOLOCK)
				LEFT OUTER JOIN dbo.UMUsers AS USR WITH (NOLOCK) ON dbo.TM_Task.ownerId = USR.id
				LEFT OUTER JOIN dbo.NTnotificationRule WITH (NOLOCK) ON dbo.NTnotificationRule.id = dbo.TM_Task.alertId
			WHERE  dbo.TM_Task.taskId IN ( SELECT
										taskId
										FROM
										@taskTble )
				AND ( [TM_Task].[deleted] = 0
						AND [TM_Task].[invalid] = 0
						AND [TM_Task].[uninstalled] = 0
						AND [TM_Task].[savedReport] = 0
					) --AND [TM_RunTime].[processed] = 0)
AND ( [TM_Task].[taskType] IN ( 2, 4 ) )
		FOR
			XML PATH('taskDetail') ,
				ROOT('TMMsg_GetTaskListResp')
		)
	IF @xmlText IS null
	BEGIN
		SET @xmlText = '<TMMsg_GetTaskListResp/>'
	END
	IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
		DROP TABLE #AssocEntity
	IF OBJECT_ID('tempdb.dbo.#AssocEntity_Final') IS NOT null
		DROP TABLE #AssocEntity_Final
	IF object_id('tempdb.dbo.#Clients_Timezone_StartTime') is NOT NULL
		DROP TABLE #Clients_Timezone_StartTime
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetStoragePolicyTaskList')
	delete from GxQscripts where name = 'TM_GetStoragePolicyTaskList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetStoragePolicyTaskList')
	delete from GXDBVersions where aliasname = 'TM_GetStoragePolicyTaskList'
GO

insert into GXDBVersions values(2, 'TM_GetStoragePolicyTaskList',  'v1.14.2.15.4.1', 'TM_GetStoragePolicyTaskList', 'v1.14.2.15.4.1')
GO

