

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetReplicationSchedules.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  TM_GetReplicationSchedules						|
--	|		 Procedure to get VSA replication schedules list				|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_GetReplicationSchedules')
BEGIN
	print '>>> Drop Stored Procedure: TM_GetReplicationSchedules <<<'
	drop procedure TM_GetReplicationSchedules
END
IF EXISTS (select * from GxQscripts where name='TM_GetReplicationSchedules')
	delete from GxQscripts where name = 'TM_GetReplicationSchedules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetReplicationSchedules')
	delete from GXDBVersions where aliasname = 'TM_GetReplicationSchedules'
GO
print '... Creating Procedure: TM_GetReplicationSchedules'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_GetReplicationSchedules
  @i_userId INT=0,
  @i_localeId INT=0,
  @i_applicationId INT=0,
  @i_appGroupId INT=0,
  @i_taskId INT=0
AS
  DECLARE @o_xml XML
SET NOCOUNT ON
DECLARE @errorCode          INT = 0
DECLARE @errorString        NVARCHAR(MAX) = ''
BEGIN TRY
    SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @_EV_VIEW                   BIGINT = POWER(2, 31-1)
DECLARE @_EV_SCHEDULE_APPLICATION   BIGINT = POWER(2, 3-1)
DECLARE @_EV_RESTORE_IN_PLACE       BIGINT = POWER(2, 20-1)
DECLARE @_EV_RESTORE_OUTOF_PLACE    BIGINT = POWER(2, 22-1)
	DECLARE @_ANY_BIT_SET BIGINT = @_EV_VIEW | @_EV_SCHEDULE_APPLICATION | @_EV_RESTORE_IN_PLACE | @_EV_RESTORE_OUTOF_PLACE
	IF object_id('tempdb.dbo.#entitiesWithViewSchedCapability') is not null
		DROP TABLE #entitiesWithViewSchedCapability
create table  #entitiesWithViewSchedCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 0, 0, '#entitiesWithViewSchedCapability'
	IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
		DROP TABLE #AssocEntity
	SELECT DISTINCT dbo.TM_AssocEntity.assocType ,
			dbo.TM_AssocEntity.taskId ,
			dbo.TM_AssocEntity.clientGroupId ,
			dbo.TM_AssocEntity.clientId ,
			dbo.TM_AssocEntity.apptypeId ,
			dbo.TM_AssocEntity.instanceId ,
			dbo.TM_AssocEntity.backupsetId ,
			dbo.TM_AssocEntity.subclientId ,
			dbo.TM_AssocEntity.policyId ,
			dbo.TM_AssocEntity.copyId ,
			dbo.TM_AssocEntity.mediaAgentId,
			dbo.TM_AssocEntity.srmReportSet AS srmReportSet,
			dbo.TM_AssocEntity.srmReportType AS srmReportType,
			dbo.TM_AssocEntity.trackingPolicyId AS trackingPolicyId,
			dbo.TM_AssocEntity.agentlessPolicyId,
			dbo.TM_AssocEntity.workflowId,
			dbo.TM_AssocEntity.sidbStoreId,
			dbo.TM_AssocEntity.exclude
	INTO    #AssocEntity
	FROM    dbo.TM_AssocEntity WITH (NOLOCK)
INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = dbo.TM_AssocEntity.taskId AND TA.TaskType IN ( 2 , 4 )
INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = dbo.TM_AssocEntity.taskId AND SA.subTaskType=3
            LEFT OUTER JOIN APP_ClientGroupAssoc GA WITH (NOLOCK) ON GA.clientGroupId=dbo.TM_AssocEntity.clientGroupId AND dbo.TM_AssocEntity.clientId = 0  --MAKE SURE ASSOCIATION IS ONLY FOR CLIENT GROUP
            INNER JOIN #entitiesWithViewSchedCapability sec ON  @i_userId = TA.ownerId OR
            ((capabilities & @_ANY_BIT_SET) <> 0) AND
            (
                (
                    (
                        (((capabilities & @_EV_RESTORE_IN_PLACE) <> 0) OR ((capabilities & @_EV_RESTORE_OUTOF_PLACE) <> 0)) AND ((capabilities & @_EV_SCHEDULE_APPLICATION) <> 0))  OR ((capabilities & @_EV_VIEW) <> 0)
                    )
                AND
                (
                    ( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
                        (
                            (
                                (dbo.TM_AssocEntity.clientId <> 0 AND
                                    (dbo.TM_AssocEntity.clientId = sec.clientId  OR (
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
                                        )
                                    )
                                )
                                OR
                                (
                                    dbo.TM_AssocEntity.clientId = 0
                                    AND
                                    dbo.TM_AssocEntity.clientGroupId <> 0
                                    AND
                                    (   --ASSOCIATION AT CLIENT GROUP
                                        sec.clientGroupId = dbo.TM_AssocEntity.clientGroupId --SECURITY AT CLIENT GROUP
                                        OR --SECURITY AT CLIENT WHICH BELONGS TO CLIENT GROUP
                                        (
                                            sec.clientId = GA.clientId
                                            AND --CHECK FOR WHEN CLIENTID = 0 WILL GIVE FALSE POSITIVE WHEN ASSOCIATION IS NOT A CLIENT ENTITY
                                            GA.clientId > 0
                                        )
                                        --dbo.TM_AssocEntity.clientGroupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE clientId=sec.clientId)
                                    )
                                )
                            )
                            AND (dbo.TM_AssocEntity.appTypeId     = sec.appTypeId   OR  dbo.TM_AssocEntity.appTypeId = 0  OR sec.appTypeId = 0 )
                            AND (dbo.TM_AssocEntity.instanceId    = sec.instanceId  OR  dbo.TM_AssocEntity.instanceId  = 0  OR sec.instanceId = 0 )
                            AND (dbo.TM_AssocEntity.backupsetId   = sec.backupSetId OR  dbo.TM_AssocEntity.backupsetId = 0  OR sec.backupSetId = 0 )
                            AND (dbo.TM_AssocEntity.subclientId   = sec.subClientId OR  dbo.TM_AssocEntity.subclientId = 0  OR sec.subClientId = 0 )
                            AND (TA.taskId   = sec.taskId OR sec.taskId = 0 )
                        )
                        OR --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
                        (
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
                        )
                    )
                )
            )
	IF object_id('tempdb.dbo.#subTaskTble') is not null
        DROP TABLE #subTaskTble
    CREATE TABLE #subTaskTble (
        subTaskId   INT,
		subTaskName nvarchar(2048),
		subTaskOptionsXml  XML,
		taskId		INT,
		taskDisabled	INT,
		associatedClientId INT,
		associatedAppTypeId INT
    )
	IF @i_taskId <> 0
	BEGIN
		IF @i_applicationId <> 0
		BEGIN
			insert into #subTaskTble (subTaskId,subTaskName,subTaskOptionsXml,taskId,taskDisabled,associatedClientId,associatedAppTypeId)
			select S.subtaskId, S.subTaskName,st.xmlValue,S.taskId,T.disabled,A.clientId,A.apptypeId
			from TM_SubTask S
			inner join TM_Task T on S.taskId = T.taskId
			inner join TM_SubTaskXMLOptions st on st.subTaskId = S.subTaskId
			inner join #AssocEntity A on A.taskId = S.taskId
			where operationType = 1007
			and T.deleted = 0 and T.invalid = 0 and T.hidden = 0 and T.uninstalled = 0 and A.apptypeId = @i_applicationId
			and T.taskId = @i_taskId
		END
		ELSE
		BEGIN
			insert into #subTaskTble (subTaskId,subTaskName,subTaskOptionsXml,taskId,taskDisabled,associatedClientId,associatedAppTypeId)
			select S.subtaskId, S.subTaskName,st.xmlValue,S.taskId,T.disabled,A.clientId,A.apptypeId
			from TM_SubTask S
			inner join TM_Task T on S.taskId = T.taskId
			inner join TM_SubTaskXMLOptions st on st.subTaskId = S.subTaskId
			inner join #AssocEntity A on A.taskId = S.taskId
			where operationType = 1007
			and T.deleted = 0 and T.invalid = 0 and T.hidden = 0 and T.uninstalled = 0
			and T.taskId = @i_taskId
		END
	END
	ELSE
	BEGIN
		IF @i_applicationId <> 0
		BEGIN
			insert into #subTaskTble (subTaskId,subTaskName,subTaskOptionsXml,taskId,taskDisabled,associatedClientId,associatedAppTypeId)
			select S.subtaskId, S.subTaskName,st.xmlValue,S.taskId,T.disabled,A.clientId,A.apptypeId
			from TM_SubTask S
			inner join TM_Task T on S.taskId = T.taskId
			inner join TM_SubTaskXMLOptions st on st.subTaskId = S.subTaskId
			inner join #AssocEntity A on A.taskId = S.taskId
			where operationType = 1007
			and T.deleted = 0 and T.invalid = 0 and T.hidden = 0 and T.uninstalled = 0 and A.apptypeId = @i_applicationId
		END
		ELSE
		BEGIN
			insert into #subTaskTble (subTaskId,subTaskName,subTaskOptionsXml,taskId,taskDisabled,associatedClientId,associatedAppTypeId)
			select S.subtaskId, S.subTaskName,st.xmlValue,S.taskId,T.disabled,A.clientId,A.apptypeId
			from TM_SubTask S
			inner join TM_Task T on S.taskId = T.taskId
			inner join TM_SubTaskXMLOptions st on st.subTaskId = S.subTaskId
			inner join #AssocEntity A on A.taskId = S.taskId
			where operationType = 1007
			and T.deleted = 0 and T.invalid = 0 and T.hidden = 0 and T.uninstalled = 0
		END
	END
	-- if @i_appGroupId is set delete the replication schedules that do not belong to that group
	IF @i_appGroupId > 0
	BEGIN
		DELETE ST
		FROM #subTaskTble ST
		WHERE ST.associatedAppTypeId NOT IN (SELECT DISTINCT appTypeId FROM APP_AppTypeGroupAssoc WHERE appGroupId = @i_appGroupId)
	END
    -- delete auto created schedules by replicaiton plan
	-- for auto created schedules useAllocationPolicyForRestore will be set
	-- delete from #subTaskTble
	-- where isnull(subTaskOptionsXml.value('(/TMMsg_JobOption/restoreOptions/@useAllocationPolicyForRestore)[1]','int'),0) = 1
	SET @o_xml = (select
	(select S.taskId '@taskId',
		(select S.taskDisabled '@disabled'
			FOR XML PATH  ('taskFlags') , TYPE)
		FOR XML PATH  ('task') , TYPE),
	(select isNull(C.id,0) '@clientId', isNull(C.name,'') '@clientName',C.displayName '@displayName',S.associatedAppTypeId '@applicationId'
		FOR XML PATH('associations') ,Type ),
	(select (select S.subTaskId '@subTaskId', S.subTaskName '@subTaskName'
				FOR XML PATH('subTask') ,Type ),
			(select -- setting default replication type to LiveSync if not present
				(select isnull(S.subTaskOptionsXml.value('(/TMMsg_JobOption/restoreOptions/@replicationType)[1]','int'),0) as '@replicationType',
CASE WHEN S.associatedAppTypeId = 81
					THEN (select S.subTaskOptionsXml.query('/TMMsg_JobOption/restoreOptions/sqlServerRstOption/database') FOR XML PATH('sqlServerRstOption'), Type)
					ELSE
					(select S.subTaskOptionsXml.query('/TMMsg_JobOption/restoreOptions/virtualServerRstOption/vCenterInstance'),
							S.subTaskOptionsXml.query('/TMMsg_JobOption/restoreOptions/virtualServerRstOption/allocationPolicy')
						FOR XML PATH('virtualServerRstOption') ,Type
					)
					END,
					(select S.subTaskOptionsXml.query('/TMMsg_JobOption/restoreOptions/destination'))
					FOR XML PATH('restoreOptions') ,Type
				)
				FOR XML PATH('options') ,Type )
		FOR XML PATH('subTasks') ,Type )
	from #subTaskTble S
	inner join APP_Client C on S.associatedClientId = C.id
	FOR XML PATH('taskDetail') ,
	ROOT('TMMsg_GetTaskListResp'))
	IF @o_xml IS null
	BEGIN
		SET @o_xml = '<TMMsg_GetTaskListResp/>'
	END
	IF object_id('tempdb.dbo.#entitiesWithViewSchedCapability') is not null
		DROP TABLE #entitiesWithViewSchedCapability
	IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
		DROP TABLE #AssocEntity
	IF OBJECT_ID('tempdb.dbo.#subTaskTble') IS NOT null
        DROP TABLE #subTaskTble
	IF OBJECT_ID('tempdb.dbo.#TM_GetReplicationSchedulesExtXmlTbl') IS NOT NULL
		INSERT INTO #TM_GetReplicationSchedulesExtXmlTbl(repInfo)
		SELECT @o_xml
	ELSE
		select @o_xml as o_xmlString
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = ERROR_MESSAGE()
	set @o_xml =(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
                            FOR XML PATH('TMMsg_GenericResp'), TYPE)
	select @o_xml as o_xmlString
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetReplicationSchedules')
	delete from GxQscripts where name = 'TM_GetReplicationSchedules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetReplicationSchedules')
	delete from GXDBVersions where aliasname = 'TM_GetReplicationSchedules'
GO

insert into GXDBVersions values(2, 'TM_GetReplicationSchedules',  '00000000000000000000', 'TM_GetReplicationSchedules', '00000000000000000000')
GO

