

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetPolicyTaskList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetPolicyTaskList.sp,v $ $Id: TM_GetPolicyTaskList.sp,v 1.13.2.18.4.1 2021/01/13 14:35:29 mnatarajan Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 02/14/2012
-- Description:	Get the list of OSC schedules.
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_GetPolicyTaskList')
BEGIN
	print '>>> Drop Stored Procedure: TM_GetPolicyTaskList <<<'
	drop procedure TM_GetPolicyTaskList
END
IF EXISTS (select * from GxQscripts where name='TM_GetPolicyTaskList')
	delete from GxQscripts where name = 'TM_GetPolicyTaskList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetPolicyTaskList')
	delete from GXDBVersions where aliasname = 'TM_GetPolicyTaskList'
GO
print '... Creating Procedure: TM_GetPolicyTaskList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_GetPolicyTaskList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userId integer,
  @localeId_in integer,
  @xmlText XML	OUTPUT
AS
BEGIN
SET NOCOUNT ON
	DECLARE @isUserAdmin INT
	DECLARE @clientId INT = 0
	DECLARE @taskId INT
	DECLARE @subTaskId INT
	DECLARE @forDDB INT =   ISNULL(( SELECT ref.value('@forDDB', 'int')
									FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
								), 0)
	DECLARE @isEdgeDrive INT =   ISNULL(( SELECT ref.value('@isEdgeDrive', 'int')
									FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
								), 0)
	DECLARE @isSystem INT =   ISNULL(( SELECT ref.value('@isSystem', 'int')
									FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
								), 0)
	DECLARE @isAuxAutoCopy INT =   ISNULL(( SELECT ref.value('@isAuxAutoCopy', 'int')
									FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
								), 0)
	IF @forDDB = 1
SET @forDDB = 0x20
	IF @isEdgeDrive = 1
SET @isEdgeDrive = 0x40
	IF @isSystem = 1
SET @isSystem = 0x4
	IF @isAuxAutoCopy = 1
SET @isAuxAutoCopy = 0x400
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	--INITIALIZATION
	--== AEB Performance
	IF object_id('tempdb.dbo.#taskTble') is not null
		DROP TABLE #taskTble
	CREATE TABLE #taskTble (
		taskId		INT,
		subTaskId	INT,
		subTaskType	INT,
		entityCount INT DEFAULT 0,
		PRIMARY KEY (taskId, subTaskId)
	)
	EXECUTE sec_isUserAdmin   @i_userid = @userId ,@o_isUserAdmin = @isUserAdmin  OUTPUT
	IF @isUserAdmin = 1 OR EXISTS (SELECT 1 FROM GXGlobalParam WHERE name='IgnoreSchedulePolicySecurityCheck' AND CAST(value AS NVARCHAR(MAX))='1')
	BEGIN
		INSERT INTO #taskTble (taskId, subTaskId, subTaskType)
			SELECT
				t.taskId,
				st.subTaskId,
				ISNULL(stt.subTaskType, 0)
			FROM TM_Task t WITH (NOLOCK)
				CROSS APPLY (
					SELECT TOP 1
						s.subTaskId
					FROM TM_SubTask s WITH (NOLOCK)
					LEFT OUTER JOIN TM_PatternAssoc a (NOLOCK) ON a.subTaskId = s.subTaskId
					LEFT OUTER JOIN TM_Pattern p (NOLOCK) ON p.patternId = a.patternId
OUTER APPLY ( SELECT 1 Ordering FROM  tm_subtaskoptions STO (NOLOCK) WHERE Sto.subTaskId =s.subTaskId AND optionid=458405394 and value =4) Custom
					WHERE s.taskId = t.taskId
					AND
					(
						p.deleted = 0 OR p.deleted IS NULL
					)
					ORDER BY Isnull(custom.Ordering,0) asc --MR 195943
				) st
				LEFT OUTER JOIN (
					SELECT
						s.subTaskId,
						MIN(s.subTaskType) subTaskType	-- want type 1 before 3
					FROM TM_SubTask s WITH (NOLOCK)
					WHERE s.subTaskType IN (1, 3)
					GROUP BY s.subTaskId
				) stt ON
					stt.subTaskId = st.subTaskId
WHERE t.taskType = 4
				AND	(
					@isSystem = 0
					OR (t.flags & @isSystem) = @isSystem
				)
				AND (
					@forDDB = 0
					OR (t.flags & @forDDB) = @forDDB
				)
				AND (
					@isEdgeDrive = 0
					OR (t.flags & @isEdgeDrive) = @isEdgeDrive
				)
				AND (
					@isSystem = 0
					OR (t.flags & @isSystem) = @isSystem
				)
				AND (
					@isAuxAutoCopy = 0
					OR (t.flags & @isAuxAutoCopy) = @isAuxAutoCopy
				)
	END
	ELSE
	BEGIN
		IF object_id('tempdb.dbo.#taskList') is not null
			DROP TABLE #taskList
		CREATE TABLE #taskList (taskId INT NOT NULL)
		CREATE CLUSTERED INDEX taskList_taskId_Index ON #taskList (taskId)
		--MR=164867 - USER WITHOUT RIGHTS SHOULD NOT BE ABLE TO VIEW SCHEDULE POLICIES
EXEC sec_getNonIdaObjectsForThisUser @userId, 35, 0, '#taskList'
		IF object_id('tempdb.dbo.#entitiesWithViewSchedCapability') is not null
		DROP TABLE #entitiesWithViewSchedCapability
create table  #entitiesWithViewSchedCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		EXEC sec_getUserObjects @userId, 0, 0, '#entitiesWithViewSchedCapability'
		-- needed so that we can join on a user with no privilages
		--IF (SELECT COUNT(*) FROM #entitiesWithViewSchedCapability) = 0
		--AVOID DUPLICATE ROWS WHEN CHECKING OWNER
		--BEGIN
		--	INSERT INTO #entitiesWithViewSchedCapability (capabilities, flag, commCellId, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subClientId,
		--	mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId, reviewSetId, querySetId, downloadSetId, ermId, legalHoldId, tagId, cdPolicyId, complianceReportId, taskId)
		--	VALUES (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
		--END
DECLARE @_EV_VIEW                   BIGINT = POWER(2, 31-1)
DECLARE @_EV_SCHEDULE_APPLICATION   INT = POWER(2, 3-1)
DECLARE @_EV_BACKUP                 INT = POWER(2, 12-1)
		IF OBJECT_ID('tempdb.dbo.#AssocEntityForBck') IS NOT null
			DROP TABLE #AssocEntityForBck
		CREATE TABLE #AssocEntityForBck
		(
				taskId INT
		)
		CREATE NONCLUSTERED INDEX AssocEntityForBck_taskId_Index ON #AssocEntityForBck (taskId)
		-- 2048 is Data protection capability
		-- 4 is agent scheduling capability
		-- 1073741824 is View capability
		declare @doesUserHaveCCAssoc int = 0
		if exists(select 1 from #entitiesWithViewSchedCapability sec where
				( (((capabilities& @_EV_BACKUP) <> 0) AND ((capabilities & @_EV_SCHEDULE_APPLICATION) <> 0)) OR ((capabilities&@_EV_VIEW) <> 0)) AND
( sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0 )
			)
		begin
			set @doesUserHaveCCAssoc=1
		end
		if @doesUserHaveCCAssoc=1
		begin
			Insert into #AssocEntityForBck
			SELECT distinct TA.taskId
			FROM    dbo.TM_Task TA WITH (NOLOCK)
				INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = TA.taskId AND SA.subTaskType=2
		end
		else
		begin
			-- 2048 is Data protection capability
			-- 4 is agent scheduling capability
			-- 1073741824 is View capability
			Insert into #AssocEntityForBck
			SELECT sec.taskId
			FROM #entitiesWithViewSchedCapability sec
			WHERE sec.taskId>0
			AND ( (((capabilities& @_EV_BACKUP) <> 0) AND ((capabilities & @_EV_SCHEDULE_APPLICATION) <> 0)) OR ((capabilities&@_EV_VIEW) <> 0))
			UNION
			SELECT ASS.taskId
			FROM TM_Associations ASS (NOLOCK) INNER JOIN #entitiesWithViewSchedCapability sec
			on  (ASS.clientId = sec.clientId AND sec.clientId > 0)
				WHERE (ASS.appTypeId     = sec.appTypeId   OR  ASS.appTypeId = 0  OR sec.appTypeId = 0 )
				AND (ASS.instanceId    = sec.instanceId  OR  ASS.instanceId  = 0  OR sec.instanceId = 0 )
				AND (ASS.backupsetId   = sec.backupSetId OR  ASS.backupsetId = 0  OR sec.backupSetId = 0 )
				AND (ASS.subclientId   = sec.subClientId OR  ASS.subclientId = 0  OR sec.subClientId = 0 )
				AND ( (((capabilities& @_EV_BACKUP) <> 0) AND ((capabilities & @_EV_SCHEDULE_APPLICATION) <> 0)) OR ((capabilities&@_EV_VIEW) <> 0))
			UNION
			-- check for security on client groups below.
			SELECT ASS.taskId
			FROM TM_AssocEntity ASS INNER JOIN #entitiesWithViewSchedCapability sec
			ON ASS.clientId = 0 AND sec.clientGroupId = ASS.clientGroupId AND ASS.clientGroupId>0 --OR
			AND ( (((capabilities& @_EV_BACKUP) <> 0) AND ((capabilities & @_EV_SCHEDULE_APPLICATION) <> 0)) OR ((capabilities&@_EV_VIEW) <> 0))
		end
		IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
			DROP TABLE #AssocEntity
		CREATE TABLE #AssocEntity
		(
				taskId INT
		)
		--DO BACKUP SCHEDULES SECURITY CHECK
		INSERT INTO    #AssocEntity
		SELECT distinct TA.taskId
		FROM    dbo.TM_Task TA WITH (NOLOCK)
				INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = TA.taskId AND SA.subTaskType=2
				INNER JOIN #AssocEntityForBck Ass ON (Ass.taskId=TA.taskId )
				WHERE taskType = 4
				AND
				(
					@isSystem = 0
					OR
					TA.flags & @isSystem = @isSystem
				)
				AND
				(
					@forDDB = 0
					OR
					TA.flags & @forDDB = @forDDB
				)
				AND
				(
					@isEdgeDrive = 0
					OR
					TA.flags & @isEdgeDrive = @isEdgeDrive
				)
				AND
				(
					@isAuxAutoCopy = 0
					OR
					TA.flags & @isAuxAutoCopy = @isAuxAutoCopy
				)
				INSERT INTO    #AssocEntity
				SELECT distinct TA.taskId
				FROM    dbo.TM_Task TA WITH (NOLOCK)
				LEFT OUTER JOIN TM_AssocEntity ASS WITH (NOLOCK) ON TA.taskId = ASS.taskId
				INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = TA.taskId AND SA.subTaskType=2
				INNER JOIN #entitiesWithViewSchedCapability sec ON
				((capabilities&1073743876) <> 0 OR @userId = TA.ownerId) AND
					--((EV_BACKUP AND EV_MANAGE_APPLICATION) OR EV_VISIBILITY)
					( (((capabilities&2048) <> 0) AND ((capabilities & 4) <> 0)) OR ((capabilities&1073741824) <> 0) ) and sec.clientId>0
				INNER JOIN App_clientGroupAssoc WITH (NOLOCK) on App_clientGroupAssoc.clientId = sec.clientId AND
					(ASS.clientId = 0 AND ASS.clientGroupId = App_clientGroupAssoc.clientGroupId AND ASS.clientGroupId>0)
WHERE taskType = 4
				AND
				(
					@isSystem = 0
					OR
					TA.flags & @isSystem = @isSystem
				)
				AND
				(
					@forDDB = 0
					OR
					TA.flags & @forDDB = @forDDB
				)
				AND
				(
					@isEdgeDrive = 0
					OR
					TA.flags & @isEdgeDrive = @isEdgeDrive
				)
				AND
				(
					@isAuxAutoCopy = 0
					OR
					TA.flags & @isAuxAutoCopy = @isAuxAutoCopy
				)
--select * from #AssocEntity
		--DO ADMIN SCHEDULES SECURITY CHECK
		INSERT INTO #AssocEntity
		SELECT TA.taskId
		FROM    dbo.TM_Task TA WITH (NOLOCK)
				LEFT OUTER JOIN TM_AssocEntity ASS WITH (NOLOCK) ON TA.taskId = ASS.taskId
INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = TA.taskId AND SA.subTaskType IN (1, 4, 5)
				INNER JOIN #entitiesWithViewSchedCapability sec ON
				((capabilities&1073741825) <> 0 OR @userId = TA.ownerId) AND
				(
					--EV_SCHEDULE_ADMIN  OR EV_VISIBILITY
					(((capabilities&1) <> 0) OR ((capabilities&1073741824) <> 0))
					AND
					(
						( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
							(
								(
									(ASS.clientId = sec.clientId OR sec.clientId = 0)  AND sec.clientGroupId = 0
									--CLIENTID AND GROUPID WILL BE 0 WHEN SECURITY ASSOCIATION IS AT BELOW ENTITIES
									AND sec.mediaAgentId = 0 AND sec.archGroupId = 0 AND sec.libraryId = 0 AND sec.vtContainerId = 0 AND sec.vtPolicyId = 0 AND sec.vtShelfId = 0
									AND sec.reviewSetId = 0 AND sec.querySetId = 0 AND sec.downloadSetId = 0 AND sec.ermId = 0 AND sec.legalHoldId = 0 AND sec.tagId = 0 AND sec.cdPolicyId = 0
									AND sec.complianceReportId = 0 AND sec.taskId = 0 AND sec.workflowId = 0 AND sec.logMonitoringPolicyId = 0 AND sec.arrayId = 0 AND sec.cloudId = 0
									AND sec.userGroupId = 0 AND sec.providerId = 0 AND sec.entityId1 = 0 AND sec.entityId2 = 0 AND sec.entityId3 = 0 AND sec.entityId4 = 0 AND sec.entityId5 = 0
									AND sec.entityId6 = 0 AND sec.entityId7 = 0 AND sec.entityId8 = 0 AND sec.entityId9 = 0
								)
								OR
								(ASS.clientId = 0 AND sec.clientGroupId = ASS.clientGroupId)
							)
							AND (ASS.policyId      = sec.archGroupId OR  (ASS.policyId = 0  AND sec.archGroupId = 0) )
							AND (ASS.trackingPolicyId  = sec.vtPolicyId OR  (ASS.trackingPolicyId = 0  AND sec.vtPolicyId = 0 ))
							--IGNORE SECURITY CHECK FOR ADMIN TASK FOR NOW, IT WILL BE DONE AT THE VIEW LEVEL BELOW
							AND NOT (ASS.clientId = 0 AND ASS.clientGroupId = 0 AND ASS.appTypeId = 0 AND
							ASS.instanceId = 0 AND ASS.backupsetId = 0 AND ASS.subclientId = 0 AND
							ASS.MediaAgentId = 0 AND ASS.policyId = 0 AND ASS.trackingPolicyId = 0 AND ASS.copyId = 0)
						)
						OR --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
						(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
						)
						OR (TA.taskId   = sec.taskId)
					)
				)
WHERE taskType = 4
				AND
				(
					@isSystem = 0
					OR
					TA.flags & @isSystem = @isSystem
				)
				AND
				(
					@isAuxAutoCopy = 0
					OR
					TA.flags & @isAuxAutoCopy = @isAuxAutoCopy
				)
				INSERT INTO #taskTble (taskId, subTaskId, subTaskType)
					SELECT
						t.taskId,
						st.subTaskId,
						ISNULL(stt.subTaskType, 0)
					FROM TM_Task t WITH (NOLOCK)
						CROSS APPLY (
							SELECT TOP 1
								s.subTaskId
							FROM TM_SubTask s WITH (NOLOCK)
							LEFT OUTER JOIN TM_PatternAssoc a (NOLOCK) ON a.subTaskId = s.subTaskId
							LEFT OUTER JOIN TM_Pattern p (NOLOCK) ON p.patternId = a.patternId
OUTER APPLY ( SELECT 1 Ordering FROM  tm_subtaskoptions STO (NOLOCK) WHERE Sto.subTaskId =s.subTaskId AND optionid=458405394 and value =4) custom
							WHERE s.taskId = t.taskId
							AND
							(
								p.deleted = 0 OR p.deleted IS NULL
							)
							ORDER BY Isnull(custom.Ordering,0) asc --MR 195943
						) st
					JOIN #taskList TL ON TL.taskId = t.taskId
						LEFT OUTER JOIN (
							SELECT
								s.subTaskId,
								MIN(s.subTaskType) subTaskType	-- want type 1 before 3
							FROM TM_SubTask s WITH (NOLOCK)
							WHERE s.subTaskType IN (1, 3)
							GROUP BY s.subTaskId
						) stt ON
							stt.subTaskId = st.subTaskId
WHERE t.taskType = 4
						AND
						(
							t.ownerId = @userId AND @isAuxAutoCopy = 0
						)
						OR t.taskId IN (SELECT distinct ae.taskId FROM #AssocEntity ae)
		IF object_id('tempdb.dbo.#taskList') is not null
			DROP TABLE #taskList
		IF object_id('tempdb.dbo.#entitiesWithViewSchedCapability') is not null
			DROP TABLE #entitiesWithViewSchedCapability
		--select * from #AssocEntity
		--select * from @taskTble
	END
	DECLARE @subTaskType INT = 0
	DECLARE @UseOldTaskEntityCountSPs INT = 0
	SELECT
		@UseOldTaskEntityCountSPs = value
	FROM GXGlobalParam
	WHERE
		name = N'UseOldTaskEntityCountSPs'
		AND modified = 0
	IF (@UseOldTaskEntityCountSPs = 0)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#TM_GetAdminEntityCountDataSet_taskTble') is not null
			DROP TABLE #TM_GetAdminEntityCountDataSet_taskTble
		CREATE TABLE #TM_GetAdminEntityCountDataSet_taskTble (
			taskId				INT,
			subTaskId			INT,
			subTaskType			INT,
			entityCount			INT DEFAULT 0,
			PRIMARY KEY (taskId, subTaskId)
		)
		IF OBJECT_ID('tempdb.dbo.#TM_GetBackupEntityCountDataSet_taskTble') is not null
			DROP TABLE #TM_GetBackupEntityCountDataSet_taskTble
		CREATE TABLE #TM_GetBackupEntityCountDataSet_taskTble (
			taskId				INT,
			subTaskId			INT,
			subTaskType			INT,
			entityCount			INT DEFAULT 0,
			PRIMARY KEY (taskId, subTaskId)
		)
		-- Populate External Admin Entity Table
		INSERT INTO #TM_GetAdminEntityCountDataSet_taskTble (taskId, subTaskId, subTaskType)
			SELECT
				taskId,
				subTaskId,
				subTaskType
			FROM #taskTble
			WHERE
				subTaskType = 1			-- SUB_TASK_TYPE_ADMIN
		DECLARE @admRowCount INT = @@ROWCOUNT
		-- Populate External Admin Entity Table
		INSERT INTO #TM_GetBackupEntityCountDataSet_taskTble (taskId, subTaskId, subTaskType)
			SELECT
				taskId,
				subTaskId,
				subTaskType
			FROM #taskTble
			WHERE
				subTaskType NOT IN (1, 3)	-- SUB_TASK_TYPE_ADMIN, SUB_TASK_TYPE_RESTORE
		DECLARE @bkupRowCount INT = @@ROWCOUNT
		-- Compute Task Entity Counts on External Tables and then update local table with count info
		DECLARE @spRC	INT = 0
		IF (@admRowCount > 0)
		BEGIN
			EXEC @spRC = TM_GetAdminEntityCountDataSet
			UPDATE tt
				SET entityCount = et.entityCount
			FROM #taskTble tt
				INNER JOIN #TM_GetAdminEntityCountDataSet_taskTble et ON
					et.taskId = tt.taskId
					AND et.subTaskId = tt.subTaskId
		END
		IF (@bkupRowCount > 0)
		BEGIN
			EXEC @spRC = TM_GetBackupEntityCountDataSet
			UPDATE tt
				SET entityCount = et.entityCount
			FROM #taskTble tt
				INNER JOIN #TM_GetBackupEntityCountDataSet_taskTble et ON
					et.taskId = tt.taskId
					AND et.subTaskId = tt.subTaskId
		END
		IF OBJECT_ID('tempdb.dbo.#TM_GetAdminEntityCountDataSet_taskTble') is not null
			DROP TABLE #TM_GetAdminEntityCountDataSet_taskTble
		IF OBJECT_ID('tempdb.dbo.#TM_GetBackupEntityCountDataSet_taskTble') is not null
			DROP TABLE #TM_GetBackupEntityCountDataSet_taskTble
	END
	ELSE
	BEGIN
		DECLARE CalculateEntityCountCursor CURSOR FOR
			SELECT
				t.taskId,
				t.subTaskId,
				t.subTaskType
			FROM #taskTble t
		OPEN CalculateEntityCountCursor
		FETCH FROM CalculateEntityCountCursor INTO @taskId, @subTaskId, @subTaskType
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF (@subTaskType = 1)
			BEGIN
				DECLARE @o_countAdmin INT = 0
				EXEC TM_GetAdminEntityCount @taskId, @subTaskId, @o_countAdmin OUTPUT
				UPDATE #taskTble
					SET entityCount = @o_countAdmin
				WHERE taskId = @taskId
					AND subTaskId = @subTaskId
			END
			ELSE IF (@subTaskType <> 3)
			BEGIN
				DECLARE @o_count INT = 0
				EXEC TM_GetBackupEntityCount @taskId,
						@subTaskId, NULL, @o_count OUTPUT
				UPDATE  #taskTble
					SET entityCount = @o_count
				WHERE taskId = @taskId
					AND subTaskId = @subTaskId
			END
			FETCH FROM CalculateEntityCountCursor INTO @taskId, @subTaskId, @subTaskType
		END
		CLOSE CalculateEntityCountCursor
		DEALLOCATE CalculateEntityCountCursor
	END
	SET @xmlText = ( SELECT	 --TASKLIST
							( SELECT 	--TASK
										[TM_Task].taskId AS '@taskId' ,
										[TM_Task].taskName AS '@taskName' ,
										[TM_Task].taskType AS '@taskType' ,
										[TM_Task].alertId AS '@alertId' ,
										[TM_Task].ownerId AS '@ownerId' ,
										[TM_Task].runUserId AS '@runUserId' ,
										[TM_Task].description AS '@description' ,
										USR.login AS '@ownerName' ,
										[TM_Task].policyType AS '@policyType' ,
										ASS.entityCount '@associatedObjects' ,
										[TM_Task].GUID ,
										( SELECT -- alert
													[TM_Task].alertId AS '@alertId' ,
													NT.notificationName AS '@alertName'
											FROM    dbo.NTnotificationRule
													AS NT WITH (NOLOCK)
											WHERE   NT.id = [TM_Task].alertId
										FOR
											XML PATH('alert') ,
												TYPE
										) ,
										(SELECT
											[TM_Task].taskId AS '@taskId',
											[TM_Task].taskName AS '@taskName'
										FOR
											XML PATH ('task'),
												TYPE
										),
										( SELECT-- origCC
													[TM_Task].origCCId AS '@commCellId'
										FOR
											XML PATH('originalCC') ,
												TYPE
										) ,
										( SELECT  --TaskFlags
													[TM_Task].disabled AS '@disabled' ,
													[TM_Task].uninstalled AS '@uninstalled' ,
													[TM_Task].isEZOperation AS '@isEZOperation',
													CASE [TM_Task].flags&32
													WHEN 32 THEN 1
													ELSE 0
													END '@forDDB',
CASE WHEN [TM_Task].flags & 0x40 <> 0 THEN 1
													ELSE 0
													END AS '@isEdgeDrive',
CASE WHEN [TM_Task].flags & 0x80 <> 0 THEN 1
													ELSE 0
													END AS '@isIndexBackup',
CASE WHEN [TM_Task].flags & 0x80000 <> 0 THEN 1
						                            ELSE 0
						                            END AS '@isEdiscovery'
										FOR
											XML PATH('taskFlags') ,
												TYPE
										)
							FOR
								XML PATH('task') ,
									TYPE
							) ,
							( SELECT  --APPGROUP
										( SELECT  --GROUP SELECTED
													TFIL.filter_value AS '@appGroupId',
													AIT.groupName AS '@appGroupName'
										FROM    TM_AssocFilter AS TFIL WITH (NOLOCK)
												LEFT JOIN APP_AppTypeGroup as AIT ON TFIL.filter_value = AIT.appTypeGroupId
												AND AIT.typeOfGroup = 3
										WHERE   TFIL.filter_type = 1
												AND TFIL.taskId = [TM_Task].taskId
												ORDER BY AIT.groupName
										FOR
											XML PATH('appGroups') ,
												TYPE
										) ,
										( SELECT  --TYPES SELECTED
													TFIL.filter_value AS '@appTypeId'
											FROM    TM_AssocFilter
													AS TFIL
											WHERE   TFIL.filter_type = 2
													AND TFIL.taskId = [TM_Task].taskId
										FOR
											XML PATH('appTypes') ,
												TYPE
										)
							FOR
								XML PATH('appGroup') ,
									TYPE
							)
						FROM   dbo.TM_Task WITH (NOLOCK)
							INNER JOIN #taskTble AS ASS ON ASS.taskId = dbo.TM_Task.taskId
							LEFT OUTER JOIN dbo.UMUsers AS USR WITH (NOLOCK) ON dbo.TM_Task.ownerId = USR.id
							LEFT OUTER JOIN dbo.NTnotificationRule WITH (NOLOCK) ON dbo.NTnotificationRule.id = dbo.TM_Task.alertId
						WHERE  [TM_Task].[deleted] = 0
							AND [TM_Task].[invalid] = 0
							AND [TM_Task].[uninstalled] = 0
							AND [TM_Task].[hidden] = 0
								--AND [TM_RunTime].[processed] = 0)
AND [TM_Task].[taskType] = 4
					FOR
						XML PATH('taskDetail') ,
							ROOT('TMMsg_GetTaskListResp')
					)
	IF @xmlText IS null
	BEGIN
		SET @xmlText = '<TMMsg_GetTaskListResp/>'
	END
	IF OBJECT_ID('tempdb.dbo.#taskTble') IS NOT null
		DROP TABLE #taskTble
	IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
		DROP TABLE #AssocEntity
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetPolicyTaskList')
	delete from GxQscripts where name = 'TM_GetPolicyTaskList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetPolicyTaskList')
	delete from GXDBVersions where aliasname = 'TM_GetPolicyTaskList'
GO

insert into GXDBVersions values(2, 'TM_GetPolicyTaskList',  'v1.13.2.18.4.1', 'TM_GetPolicyTaskList', 'v1.13.2.18.4.1')
GO

