

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetOSCTaskList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetOSCTaskList.sp,v $ $Id: TM_GetOSCTaskList.sp,v 1.25.2.42.8.2 2021/02/18 21:29:40 mnatarajan Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 02/14/2012
-- Description:	Get the list of OSC schedules.
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_GetOSCTaskList')
BEGIN
	print '>>> Drop Stored Procedure: TM_GetOSCTaskList <<<'
	drop procedure TM_GetOSCTaskList
END
IF EXISTS (select * from GxQscripts where name='TM_GetOSCTaskList')
	delete from GxQscripts where name = 'TM_GetOSCTaskList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetOSCTaskList')
	delete from GXDBVersions where aliasname = 'TM_GetOSCTaskList'
GO
print '... Creating Procedure: TM_GetOSCTaskList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_GetOSCTaskList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userId integer,
  @localeId_in integer,
  @xmlText XML	OUTPUT
AS
BEGIN
SET NOCOUNT ON
	DECLARE @i_clientId INT = 0
	DECLARE @clientId INT = 0
	DECLARE @isForMA INT = 0
	DECLARE @updateCCR INT = 0
	DECLARE @instanceId INT
	DECLARE @backupsetId INT
	DECLARE @subclientId INT
	DECLARE @appTypeId INT
	DECLARE @clientVersion int
	DECLARE @userCentricClientExists INT = 0
DECLARE @pausedBlackListedFlag INT = (CAST(0x1 AS INT) | CAST(0x20 AS INT))
	--MSSQL one minute RPO dump sweep changes
	DECLARE @isMediaAgent INT
	DECLARE @nowTime integer = dbo.GetUnixTime (GetUTCdate())
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	--CREATE THE TEMP TABLE--
	IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
		DROP TABLE #AssocEntity
	CREATE TABLE #AssocEntity
	(
			assocId INT DEFAULT 0,
			assocType INT DEFAULT 0,
			taskId INT,
			subTaskId INT,
			clientGroupId INT DEFAULT 0,
			clientId INT,
			apptypeId INT DEFAULT 0,
			instanceId INT DEFAULT 0,
			backupsetId INT DEFAULT 0,
			subclientId INT DEFAULT 0,
			upgrade INT DEFAULT 0,
			exclude INT,
			operationType INT,
			isSyncIntervalApplicable INT DEFAULT 0,
			isDumpSweepEnabled INT DEFAULT 0,
			osTypeOfClient NVARCHAR(64) DEFAULT '',
			isDumpSubclientOfMA INT DEFAULT 0,
			hasSupportedMAForDump INT DEFAULT 0
	)
	CREATE CLUSTERED INDEX AssocEntity_taskId_clientId_Idx ON #AssocEntity(taskId, clientId)
	IF OBJECT_ID('tempdb.dbo.#InstallInfo') IS NOT null
		DROP TABLE #InstallInfo
    CREATE TABLE #InstallInfo
    (
			taskId INT,
			subTaskId INT,
			operationType INT,
			clientGroupId INT,
			clientId INT,
			exclude INT,
            _type_ INT
	)
	CREATE CLUSTERED INDEX InstallInfo_taskId_Idx ON #InstallInfo(taskId)
	IF OBJECT_ID('tempdb.dbo.#subTaskXmlOptions') IS NOT null
		DROP TABLE #subTaskXmlOptions
	CREATE TABLE #subTaskXmlOptions
	(
		subTaskId int,
		subTaskXmlOptions xml,
		isAssociatedToMASubclient INT DEFAULT 0,
		resetUseStorageSpaceFromMA INT DEFAULT 0,
		isForMediaAgentAttrPresent INT DEFAULT 0,
		dumpSweepFeature	INT DEFAULT 0,
		isDumpSubclient INT DEFAULT 0,
		hasSupportedMAForDump INT DEFAULT 0,
		PRIMARY KEY (subTaskId, isDumpSubclient, hasSupportedMAForDump)
	)
	IF OBJECT_ID('tempdb.dbo.#MAAssocEntities') IS NOT null
		DROP TABLE #MAAssocEntities
    CREATE TABLE #MAAssocEntities
    (
			subclientId INT PRIMARY KEY,
			appTypeId INT,
			instanceId INT,
			backupsetId INT,
			clientId INT
	)
	IF OBJECT_ID('tempdb.dbo.#PlanAutoSubclients') IS NOT null
		DROP TABLE #PlanAutoSubclients
    CREATE TABLE #PlanAutoSubclients
    (
			assocId INT,
			subclientId INT,
			taskId INT,
			subtaskId INT,
			operationType INT
	)
	CREATE CLUSTERED INDEX PlanAutoSubclients_subclientId_taskId_Idx ON #PlanAutoSubclients(subclientId,taskId)
	--THIS IS VIEW SCHEDULES
	BEGIN
		--GET CLIENT
		SET @i_clientId = ISNULL(( SELECT ref.value('@clientId', 'int')
									FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
								), 0)
		--GET APPTYPE
		SET @apptypeId = ISNULL(( SELECT    ref.value('@applicationId', 'int')
									FROM      @xmlText.nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
								), 0)
		--GET INSTANCE
		SET @instanceId = ISNULL(( SELECT   ref.value('@instanceId', 'int')
									FROM     @xmlText.nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
									), 0)
		--GET BACKUPSET
		SET @backupsetId = ISNULL(( SELECT  ref.value('@backupsetId', 'int')
									FROM    @xmlText.nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
									), 0)
		--GET SUBCLIENT
		SET @subclientId = ISNULL(( SELECT ref.value('@subclientId', 'int')
									FROM @xmlText.nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
									), 0)
		IF (@subclientId <> 0)	--GET MISSING INFO USING SC ID
		BEGIN
			SELECT TOP 1 @i_clientId=clientId, @appTypeId=appTypeId, @instanceId=instance, @backupSetId=backupSet FROM APP_Application WITH(NOLOCK) WHERE (id=@subclientId OR @subclientId=0) AND (clientId=@clientId OR @clientId=0) AND
					(appTypeId=@appTypeId OR @appTypeId=0) AND (instance=@instanceId OR @instanceId=0) AND (backupSet=@backupSetId OR @backupSetId=0)
		END
		ELSE IF (@backupSetId <> 0)	--GET MISSING INFO EXCEPT SC ID USING BS ID
		BEGIN
			SELECT TOP 1 @i_clientId=clientId, @appTypeId=appTypeId, @instanceId=instance FROM APP_Application WITH(NOLOCK) WHERE (id=@subclientId OR @subclientId=0) AND (clientId=@clientId OR @clientId=0) AND
					(appTypeId=@appTypeId OR @appTypeId=0) AND (instance=@instanceId OR @instanceId=0) AND (backupSet=@backupSetId)
		END
		ELSE IF (@instanceId <> 0)	--GET MISSING INFO EXCEPT SC AND BS ID USING INST ID
		BEGIN
			SELECT TOP 1 @i_clientId=clientId, @appTypeId=appTypeId FROM APP_Application WITH(NOLOCK) WHERE (id=@subclientId OR @subclientId=0) AND (clientId=@clientId OR @clientId=0) AND
					(appTypeId=@appTypeId OR @appTypeId=0) AND (instance=@instanceId)
		END
		SELECT @updateCCR = ISNULL(value, 0) FROM GXGlobalParam (NOLOCK) WHERE name = 'updateCCRForClient'
		IF @i_clientId > 0 AND @updateCCR != 0
		BEGIN
			EXEC JMUpdateCCR @i_clientId, 0
		END
		--MSSQL 1 min RPO
		DECLARE @MSSQLsupportedReleaseVersionForDumpSweeep INT = 20
		--Oracle & SAP HANA
		DECLARE @SAPORAsupportedReleaseVersionForDumpSweeep INT = 20
		--Informix support version
		DECLARE @InformixsupportedReleaseVersionForDumpSweeep INT = 21
		--Oracle RAC
		DECLARE @OracleRACsupportedReleaseVersionForDumpSweeep INT = 21
		-- for clients whose release id < SP17 then do not send the dump option to client.
		-- Filter out Dump Sweep option for MAs other than windows and linux and this will be regular OSC
		IF EXISTS(SELECT 1 FROM MMHost WITH(NOLOCK)
			INNER JOIN simInstalledPackages SP (NOLOCK) ON SP.clientId = @i_clientId
			AND  MMHost.ClientId = @i_clientId AND MMHost.MmHostEnabled = 1
			AND SP.HighestSP >= @MSSQLsupportedReleaseVersionForDumpSweeep
			INNER JOIN App_Client (NOLOCK) ON @i_clientId = App_Client.id
			INNER JOIN simOperatingSystem os WITH(READUNCOMMITTED) ON App_Client.simOperatingSystemId = os.id
			WHERE os.type = 'Windows' OR os.subtype = 'Linux'
		)
		BEGIN
			SET @isMediaAgent = 1
			--Fetching list of subclients for whom to send the parameter to say they need to do a sweep
			INSERT INTO #MAAssocEntities(subclientId)
			EXEC ArchGetSubclientListFromMA @i_clientId
			UPDATE MAA
			SET MAA.instanceId = APP.instance, MAA.clientId = APP.clientId, MAA.appTypeId = APP.appTypeId, MAA.backupsetId = APP.backupSet
			FROM #MAAssocEntities MAA
			INNER JOIN APP_Application APP ON MAA.subclientId = APP.id
		END
		ELSE
			SET @isMediaAgent = 0
		DECLARE @clients TABLE(clientId INT PRIMARY KEY, isForMA INT DEFAULT 0)
		-- Insert the given client
		INSERT INTO @clients
		VALUES(@i_clientId, 0)
		-- If it is laptop, insert the user centric client if needed.
		IF @instanceId = 0 -- means all other entities as 0 and it is client level.
		AND EXISTS (SELECT 1 FROM APP_Client WHERE id = @i_clientId AND status & 0x1000 <> 0) -- laptop client
		BEGIN
			INSERT INTO @clients
			SELECT DISTINCT UC.componentNameId, 0
			FROM APP_ClientProp UC
			INNER JOIN APP_ClientProp PC ON UC.componentNameId = PC.componentNameId AND PC.modified = 0 AND PC.attrName = 'Physical Client Id' AND PC.attrVal = CAST(@i_clientId AS NVARCHAR(10)) -- With physical client as this laptop client
			WHERE UC.attrName = 'User Centric Client' AND UC.modified = 0 AND UC.attrVal = '1' -- User centric clients
			-- If we have any user centric client, then remove the backup client
			IF @@ROWCOUNT > 0
			BEGIN
				SET @userCentricClientExists = 1
			END
		END
		IF @isMediaAgent = 1 AND
			EXISTS( SELECT 1 FROM #MAAssocEntities)
		BEGIN
			INSERT INTO @clients
			SELECT DISTINCT MAA.clientId, 1
				FROM #MAAssocEntities MAA
		END
		-- If user centric client exists, dont send backup schedules for physical client(@i_clientId)
		--BACKUP SCHEDULES WITH ASSOCIATION AT CLIENT LEVEL
		INSERT INTO    #AssocEntity
		(assocId, assocType, taskId, subTaskId, clientGroupId, clientId, apptypeId, instanceId, backupsetId, subclientId, upgrade, exclude, operationType, isSyncIntervalApplicable)
		SELECT DISTINCT TE.assocId,
				TE.assocType ,
				TA.taskId ,
				SA.subTaskId,
				TE.clientGroupId ,
				CASE WHEN TE.clientId IS NULL OR TE.clientId = 0 THEN C.clientId --NEED THIS BECAUSE DIFF BETWEEN UPDATE SCHEDULES AND BACKUP SCHEDULES
				ELSE
				TE.clientId
				END ,
				TE.apptypeId ,
				TE.instanceId ,
				TE.backupsetId ,
				TE.subclientId,
				0,
				TE.exclude,
				SA.operationType,
				0
		FROM    TM_Task TA WITH (READUNCOMMITTED)
				INNER JOIN TM_AssocEntity TE WITH (READUNCOMMITTED) ON TA.taskId = TE.taskId
				INNER JOIN @clients C ON TE.clientId = C.clientId
INNER JOIN TM_SubTask SA WITH (READUNCOMMITTED) ON SA.taskId = TA.taskId AND SA.subTaskType = 2
				INNER JOIN TM_PatternAssoc PA WITH (READUNCOMMITTED) ON PA.subTaskId = SA.subTaskId
				INNER JOIN TM_Pattern P WITH (READUNCOMMITTED) ON P.patternId = PA.patternId
WHERE P.freq_type=1024
				AND TA.[deleted] = 0
				AND TA.[invalid] = 0
				AND TA.[uninstalled] = 0
				AND TA.[savedReport] = 0
				AND TA.[disabled] = 0
AND TA.[taskType] IN ( 2, 4 )
				AND ( C.clientId <> @i_clientId OR @userCentricClientExists = 0)
		UNION
			SELECT DISTINCT TE.assocId,
			TE.assocType ,
			TA.taskId ,
			SA.subTaskId,
			TE.clientGroupId ,
			CASE WHEN TE.clientId IS NULL OR TE.clientId = 0 THEN C.clientId --NEED THIS BECAUSE DIFF BETWEEN UPDATE SCHEDULES AND BACKUP SCHEDULES
			ELSE
			TE.clientId
			END ,
			TE.apptypeId ,
			TE.instanceId ,
			TE.backupsetId ,
			TE.subclientId,
			SO.value,
			TE.exclude,
			SA.operationType,
			0
	FROM    TM_Task TA WITH (READUNCOMMITTED)
			LEFT OUTER JOIN TM_AssocEntity TE WITH (READUNCOMMITTED) ON TA.taskId = TE.taskId
			INNER JOIN @clients C ON C.clientId = TE.clientId AND C.isForMA = 0 -- isForMA = 0 denotes regular clients for whom dump sweep schedule should not be sent, this check is present for install schedules
INNER JOIN TM_SubTask SA WITH (READUNCOMMITTED) ON SA.taskId = TA.taskId AND SA.subTaskType = 1 AND SA.operationType = 4026
			INNER JOIN TM_PatternAssoc PA WITH (READUNCOMMITTED) ON PA.subTaskId = SA.subTaskId
			INNER JOIN TM_Pattern P WITH (READUNCOMMITTED) ON P.patternId = PA.patternId
LEFT OUTER JOIN TM_SubTaskOptions SO WITH (READUNCOMMITTED) ON SO.subTaskId = SA.subTaskId AND optionId = 967538445
WHERE P.freq_type=1024
			AND C.clientId > 0
			AND TE.clientId = C.clientId
			AND TA.[deleted] = 0
			AND TA.[invalid] = 0
			AND TA.[uninstalled] = 0
			AND TA.[savedReport] = 0
			AND TA.[disabled] = 0
AND TA.[taskType] IN ( 2, 4 )
			AND ( C.clientId <> @i_clientId OR @userCentricClientExists = 0)
		UNION
		SELECT DISTINCT TE.assocId,
			TE.assocType ,
			TA.taskId ,
			SA.subTaskId,
			TE.clientGroupId ,
			C.clientId,  --NEED THIS BECAUSE DIFF BETWEEN UPDATE SCHEDULES AND BACKUP SCHEDULES
			TE.apptypeId ,
			TE.instanceId ,
			TE.backupsetId ,
			TE.subclientId,
			SO.value,
			TE.exclude,
			SA.operationType,
			0
	FROM    TM_Task TA WITH (READUNCOMMITTED)
			INNER JOIN TM_AssocEntity TE WITH (READUNCOMMITTED) ON TA.taskId = TE.taskId
INNER JOIN TM_SubTask SA WITH (READUNCOMMITTED) ON SA.taskId = TA.taskId AND SA.subTaskType = 1 AND SA.operationType = 4026
			INNER JOIN TM_PatternAssoc PA WITH (READUNCOMMITTED) ON PA.subTaskId = SA.subTaskId
			INNER JOIN TM_Pattern P WITH (READUNCOMMITTED) ON P.patternId = PA.patternId
			INNER JOIN App_ClientGroupAssoc WITH (READUNCOMMITTED) ON App_ClientGroupAssoc.clientGroupId = TE.clientGroupId
			INNER JOIN @clients C ON C.clientId = App_ClientGroupAssoc.clientId AND C.isForMA = 0 -- isForMA = 0 denotes regular clients for whom dump sweep schedule should not be sent, this check is present for install schedules
LEFT OUTER JOIN TM_SubTaskOptions SO WITH (READUNCOMMITTED) ON SO.subTaskId = SA.subTaskId AND optionId = 967538445
WHERE P.freq_type=1024
			AND C.clientId > 0
			AND TA.[deleted] = 0
			AND TA.[invalid] = 0
			AND TA.[uninstalled] = 0
			AND TA.[savedReport] = 0
			AND TA.[disabled] = 0
AND TA.[taskType] IN ( 2, 4 )
			AND ( C.clientId <> @i_clientId OR @userCentricClientExists = 0)
		--BACKUP SCHEDULES WITH ASSOCIATION AT CLIENT GROUP LEVEL
		-- Handle all client groups selection for OSC schedule in policy.
		INSERT INTO    #AssocEntity
		(assocId, assocType, taskId, subTaskId, clientGroupId, clientId, apptypeId, instanceId, backupsetId, subclientId, upgrade, exclude, operationType, isSyncIntervalApplicable)
		SELECT TE.assocId,
				TE.assocType ,
				TA.taskId ,
				SA.subTaskId,
				TE.clientGroupId ,
				CASE WHEN TE.clientId IS NULL OR TE.clientId = 0 THEN C.clientId --NEED THIS BECAUSE DIFF BETWEEN UPDATE SCHEDULES AND BACKUP SCHEDULES
				ELSE
				TE.clientId
				END ,
				TE.apptypeId ,
				TE.instanceId ,
				TE.backupsetId ,
				TE.subclientId,
				0,
				TE.exclude,
				SA.operationType,
				0
		FROM    TM_Task TA WITH (READUNCOMMITTED)
				INNER JOIN TM_AssocEntity TE WITH (READUNCOMMITTED) ON TA.taskId = TE.taskId
INNER JOIN TM_SubTask SA WITH (READUNCOMMITTED) ON SA.taskId = TA.taskId AND SA.subTaskType = 2
				INNER JOIN TM_PatternAssoc PA WITH (READUNCOMMITTED) ON PA.subTaskId = SA.subTaskId
				INNER JOIN TM_Pattern P WITH (READUNCOMMITTED) ON P.patternId = PA.patternId
				-- Check for client association to client group for @clientId
				INNER JOIN APP_ClientGroupAssoc CGA WITH (READUNCOMMITTED) ON CGA.clientGroupId = TE.clientGroupId AND TE.clientId = 0
				INNER JOIN @clients C ON C.clientId = CGA.clientId
WHERE P.freq_type = 1024
				AND TA.[deleted] = 0
				AND TA.[invalid] = 0
				AND TA.[uninstalled] = 0
				AND TA.[savedReport] = 0
				AND TA.[disabled] = 0
AND TA.[taskType] IN ( 2, 4 )
		UNION
		-- Handle scenario all client groups.
		SELECT TE.assocId,
				TE.assocType ,
				TA.taskId ,
				SA.subTaskId,
				TE.clientGroupId ,
				CASE WHEN TE.clientId IS NULL OR TE.clientId = 0 THEN C.clientId --NEED THIS BECAUSE DIFF BETWEEN UPDATE SCHEDULES AND BACKUP SCHEDULES
				ELSE
				TE.clientId
				END ,
				TE.apptypeId ,
				TE.instanceId ,
				TE.backupsetId ,
				TE.subclientId,
				0,
				TE.exclude,
				SA.operationType,
				0
		FROM    TM_Task TA WITH (READUNCOMMITTED)
				INNER JOIN TM_AssocEntity TE WITH (READUNCOMMITTED) ON TA.taskId = TE.taskId
				INNER JOIN App_ClientGroupAssoc CGA WITH (READUNCOMMITTED) ON -- all client group entity selection and all client selection
				(
TE.assocType = 27 -- all client groups selected
				)
				INNER JOIN @clients C ON C.clientId = CGA.clientId
INNER JOIN TM_SubTask SA WITH (READUNCOMMITTED) ON SA.taskId = TA.taskId AND SA.subTaskType = 2
				INNER JOIN TM_PatternAssoc PA WITH (READUNCOMMITTED) ON PA.subTaskId = SA.subTaskId
				INNER JOIN TM_Pattern P WITH (READUNCOMMITTED) ON P.patternId = PA.patternId
WHERE P.freq_type = 1024
				AND TA.[deleted] = 0
				AND TA.[invalid] = 0
				AND TA.[uninstalled] = 0
				AND TA.[savedReport] = 0
				AND TA.[disabled] = 0
AND TA.[taskType] IN ( 2, 4 )
				AND TE.clientGroupId = 0 AND TE.clientId = 0
			UNION
			-- Handle scenario all clients.
			SELECT TE.assocId,
				TE.assocType ,
				TA.taskId ,
				SA.subTaskId,
				TE.clientGroupId ,
				CASE WHEN TE.clientId IS NULL OR TE.clientId = 0 THEN C.clientId --NEED THIS BECAUSE DIFF BETWEEN UPDATE SCHEDULES AND BACKUP SCHEDULES
				ELSE
				TE.clientId
				END ,
				TE.apptypeId ,
				TE.instanceId ,
				TE.backupsetId ,
				TE.subclientId,
				0,
				TE.exclude,
				SA.operationType,
				0
		FROM    TM_Task TA WITH (READUNCOMMITTED)
				INNER JOIN TM_AssocEntity TE WITH (READUNCOMMITTED) ON TA.taskId = TE.taskId
				INNER JOIN App_Client CL WITH (READUNCOMMITTED) ON -- all client selection
				(
TE.assocType = 2 -- all clients selected
				)
				INNER JOIN @clients C ON C.clientId = CL.id
INNER JOIN TM_SubTask SA WITH (READUNCOMMITTED) ON SA.taskId = TA.taskId AND SA.subTaskType = 2
				INNER JOIN TM_PatternAssoc PA WITH (READUNCOMMITTED) ON PA.subTaskId = SA.subTaskId
				INNER JOIN TM_Pattern P WITH (READUNCOMMITTED) ON P.patternId = PA.patternId
WHERE P.freq_type = 1024
				AND TA.[deleted] = 0
				AND TA.[invalid] = 0
				AND TA.[uninstalled] = 0
				AND TA.[savedReport] = 0
				AND TA.[disabled] = 0
AND TA.[taskType] IN ( 2, 4 )
				AND TE.clientId = 0
			INSERT INTO #PlanAutoSubclients(assocId,subclientId,taskId,subtaskId,operationType)
			SELECT DISTINCT AE.assocId, APP.id, AE.taskId, SA.subtaskId, SA.operationType
			FROM APP_Application APP WITH (READUNCOMMITTED)
				INNER JOIN @clients C ON C.clientId = APP.clientId
				INNER JOIN APP_SubClientProp SCP WITH (READUNCOMMITTED) ON SCP.componentNameId = APP.id AND SCP.attrName = 'Associated Plan' AND SCP.cs_attrName = CHECKSUM(N'Associated Plan')
				INNER JOIN TM_AssocEntity AE WITH (READUNCOMMITTED) ON CAST(AE.entityId AS NVARCHAR(10)) = SCP.attrVal AND AE.assocType = 158
				INNER JOIN TM_Task TA WITH (READUNCOMMITTED) ON TA.taskId = AE.taskId
				INNER JOIN TM_SubTask SA WITH (READUNCOMMITTED) ON SA.taskId = TA.taskId AND SA.subTaskType = 2
				INNER JOIN TM_PatternAssoc PA WITH (READUNCOMMITTED) ON PA.subTaskId = SA.subTaskId
				INNER JOIN TM_Pattern P WITH (READUNCOMMITTED) ON P.patternId = PA.patternId
			WHERE P.freq_type = 1024
				AND TA.[deleted] = 0
				AND TA.[invalid] = 0
				AND TA.[uninstalled] = 0
				AND TA.[savedReport] = 0
				AND TA.[disabled] = 0
				AND TA.[taskType] IN ( 2, 4 )
		INSERT INTO    #AssocEntity
		(assocId, assocType, taskId, subTaskId, clientGroupId, clientId, apptypeId, instanceId, backupsetId, subclientId, upgrade, exclude, operationType, isSyncIntervalApplicable)
		SELECT PA.assocId,
				158,
				PA.taskId ,
				PA.subTaskId,
				0,
				APP.clientId ,
				APP.apptypeId ,
				APP.instance,
				APP.backupSet ,
				PA.subclientId,
				0,
				0,
				PA.operationType,
				0
		FROM    #PlanAutoSubclients PA
				INNER JOIN APP_Application APP WITH(READUNCOMMITTED) ON APP.id = PA.subclientId
            DELETE #InstallInfo
			--UPDATE SCHEDULES WITH ASSOCIATION AT CLIENT GROUP AND CLIENT LEVEL
			--INSTALL UPDATE ONLY AT CLIENT LEVEL
            IF ( @appTypeId=0 AND @instanceId=0 AND @backupsetId=0 AND @subclientId=0 )
            BEGIN
                INSERT INTO #InstallInfo
                (taskId, subTaskId, operationType, clientGroupId, clientId, exclude, _type_)
	            SELECT DISTINCT
		            T.taskId,
		            T.subTaskId,
		            T.operationType,
		            gr.value('@clientGroupId', 'INT') clientgroupId,
		            gr.value('@clientId', 'INT') clientId,
		            ISNULL(gr.value('flags[1]/@exclude', 'INT'), 0) exclude,
		            gr.value('@_type_', 'INT') _type_
	            FROM
								(
		            SELECT
					TA.taskId ,
					SA.subTaskId,
					SA.operationType,
			            CAST(X.value AS XML) xmlValue
			FROM    TM_Task TA WITH (READUNCOMMITTED)
INNER JOIN TM_SubTask SA WITH (READUNCOMMITTED) ON SA.taskId = TA.taskId AND SA.subTaskType = 1 AND SA.operationType = 4020
					INNER JOIN TM_PatternAssoc PA WITH (READUNCOMMITTED) ON PA.subTaskId = SA.subTaskId
					INNER JOIN TM_Pattern P WITH (READUNCOMMITTED) ON P.patternId = PA.patternId
INNER JOIN TM_SubTaskOptions X (READUNCOMMITTED) ON X.subTaskId = SA.subTaskId AND X.optionId = 239177580
WHERE P.freq_type=1024
					AND TA.[deleted] = 0
					AND TA.[invalid] = 0
					AND TA.[uninstalled] = 0
					AND TA.[savedReport] = 0
					AND TA.[disabled] = 0
AND TA.[taskType] IN ( 2, 4 )
	            ) T
	            CROSS APPLY T.xmlValue.nodes('//clientAndClientGroups') G(gr)
				INSERT INTO #AssocEntity
				(taskId, subTaskId, clientId, operationType, exclude, upgrade)
	            SELECT T.taskId, T.subTaskId, T.clientId, operationType, exclude, SO.value
	            FROM
	            (
			        SELECT taskId, subTaskId, operationType, exclude, C.clientId
			        FROM #InstallInfo I
		            JOIN APP_ClientGroupAssoc G (READUNCOMMITTED) ON G.clientGroupId = I.clientGroupId
					JOIN @clients C ON G.clientId = C.clientId AND C.isForMA = 0
			        UNION
			        SELECT taskId, subTaskId, operationType, exclude, C.clientId
			        FROM #InstallInfo I
					JOIN @clients C ON C.clientId = I.clientId AND C.isForMA = 0
			        UNION
			        SELECT taskId, subTaskId, operationType, exclude, I.clientId
			        FROM #InstallInfo I
					JOIN @clients C ON C.clientId = I.clientId AND C.isForMA = 0
						WHERE _type_ = 2
			        UNION
			        SELECT taskId, subTaskId, operationType, exclude, C.clientId
			        FROM #InstallInfo I
					INNER JOIN App_ClientGroupAssoc CGA ON -- all client group entity selection and all client selection
					(
(I.clientGroupId = 0 and I._type_ = 27)  -- all client groups selected
					)
					JOIN @clients C ON CGA.clientId = C.clientId AND C.isForMA = 0
	            ) T
LEFT OUTER JOIN TM_SubTaskOptions SO WITH (READUNCOMMITTED) ON SO.subTaskId = T.subTaskId AND SO.optionId = 967538445
            END
			--REMOVE SYNTHETIC AUTOCOPY SCHEDULES
			DELETE #AssocEntity
			FROM #AssocEntity AE
WHERE EXISTS(SELECT * FROM TM_SubTaskOptions SO WHERE SO.subTaskId = AE.subTaskId AND SO.optionId = 1013376701 AND SO.value = '1')
			-- Check and insert the schedule for Edge Drive if it is laptop client and if edge is configured
			-- and it is not in deconfigured state
			IF EXISTS(	SELECT 1
						FROM APP_Client C
						INNER JOIN APP_Application APP ON C.id = APP.clientId AND APP.subclientStatus & 8 = 8 --CV_STATUS_DEFAULT
						INNER JOIN APP_BackupSetName BS ON APP.backupSet = BS.id AND BS.status & 8 = 8 --CV_STATUS_DEFAULT
						INNER JOIN @clients CL ON C.id = CL.clientId
						WHERE C.status & 0x1000 = 0x1000 --CV_STATUS_PERSONAL_WKSTN
						AND CL.isForMA = 0
						AND C.status & 6 = 0 -- (CV_STATUS_UNINSTALLED | CV_STATUS_DELETED)
						AND APP.appTypeId IN (SELECT appTypeId FROM GetAppTypesForAppGroup(35,0)) and APP.appTypeId <> 13
						AND APP.subclientStatus & 6 = 0 -- (CV_STATUS_UNINSTALLED | CV_STATUS_DELETED)
					 )
			BEGIN
				-- return only edge drive schedule
				INSERT INTO    #AssocEntity
				(assocId, assocType, taskId, subTaskId, clientGroupId, clientId, apptypeId, instanceId, backupsetId, subclientId, upgrade, exclude, operationType, isSyncIntervalApplicable)
				SELECT TE.assocId, TE.assocType, TE.taskId, TE.subTaskId, 0, SC.clientId, APP.appTypeId, APP.instance, APP.backupset, APP.id, '', TE.exclude, TE.operationType,0
				FROM App_SyncCloudConfig SC WITH(NOLOCK)
INNER JOIN App_SyncCloudFolder SF WITH(NOLOCK) ON SF.syncWebFolderId = SC.syncWebFolderId AND SF.flag & 0x10 <> 0
				INNER JOIN APP_Application APP WITH(NOLOCK) ON SC.subclientId = APP.id
				OUTER APPLY
				(
					SELECT TA.assocId, TA.assocType, T.taskId, S.subTaskId,TA.exclude, S.operationType
					FROM  TM_Task T(nolock)
					INNER JOIN TM_AssocEntity TA(nolock) ON T.taskId = TA.TaskId
					INNER JOIN TM_SubTask S WITH(NOLOCK) ON T.taskId = S.taskId
					WHERE T.flags & CAST(0x40 as INT) <> 0 --TASK_FLAGS_EDGE_DRIVE
					AND T.disabled = 0
				) AS TE
				INNER JOIN @clients C ON SC.clientId = C.clientId AND C.isForMA = 0 AND SC.flag & @pausedBlackListedFlag = 0 -- Not paused or blacklisted.
			END
		--
				--select * from #AssocEntity
		--
			--REMOVE UPGRADE SCHEDULES FOR CLIENTS THAT HAVE ALREADY BEEN UPGRADED
			DECLARE @CSReleaseId INT = (SELECT TOP 1 id FROM simAllGalaxyRel WITH (NOLOCK) ORDER BY id DESC)
			-- DELETE UPGRADE SCHEDULE IF VERSION IS SAME AS CS
			DELETE AE
			FROM #AssocEntity AE
			INNER JOIN App_client AC on AE.clientId = AC.id
WHERE operationType = 4020
			AND	AE.upgrade = 1
			AND AC.releaseId = @CSReleaseId
			--REMOVE UPDATE SCHEDULES FOR WHICH CLIENT HAS BEEN EXCLUDED
			DELETE #AssocEntity
			FROM #AssocEntity E
			JOIN #InstallInfo I ON E.taskId = I.taskId
			AND I.exclude = 1
			AND
			(
				I.clientId = E.clientId --CLIENT WAS EXCLUDED
				OR
				I.clientId IS NULL  --CLIENT GROUP WHICH HAS THE CLIENT WAS EXCLUDED
			)
			-- DELETE UPDATE SCHEDULES FOR CLIENTS THAT HAVE UPGRADE SCHEDULES OR CLIENT MIGHT NEVER START THE UPGRADE SCHEDULE
			DELETE AE
			FROM #AssocEntity AE
			INNER JOIN APP_Client AC ON AE.clientId = AC.id
WHERE AE.operationType = 4020
			AND AE.upgrade = 0	-- DOES NOT DELETE BACKUP SCHEDULES BECAUSE VALUE IS NULL
			AND EXISTS (SELECT 1 FROM #AssocEntity WHERE upgrade = 1)
			AND AC.releaseId <> @CSReleaseId
			DECLARE @ExcludedAssocEntity TABLE
			(
				taskId INT,
				clientId INT,
				apptypeId INT DEFAULT 0,
				instanceId INT DEFAULT 0,
				backupsetId INT DEFAULT 0,
				subclientId INT DEFAULT 0,
				exclude INT
			)
			INSERT INTO @ExcludedAssocEntity
			SELECT
				E.taskId,
				E.clientId,
				E.apptypeId,
				E.instanceId,
				E.backupsetId,
				E.subclientId,
				E.exclude
			FROM #AssocEntity E
				WHERE E.exclude = 1
			--INSERT NEW ENTITY
			INSERT INTO #AssocEntity
			(assocId, assocType, taskId, subTaskId, clientGroupId, clientId, apptypeId, instanceId, backupsetId, subclientId, upgrade, exclude, operationType, isSyncIntervalApplicable)
			SELECT 0, 7, AE.taskId, AE.subTaskId, 0, APP.clientId, APP.appTypeId, APP.instance, APP.backupSet, APP.id, 0, 0, operationType,0
			FROM #AssocEntity AE
			INNER JOIN @clients C ON C.clientId = AE.clientId
			INNER JOIN APP_Application APP WITH (READUNCOMMITTED) ON
				(
					(
						APP.clientId = AE.clientId AND AE.clientId > 0
						AND (APP.appTypeId = AE.apptypeId OR AE.apptypeId = 0)
						AND (APP.instance = AE.instanceId OR AE.instanceId = 0)
						AND (APP.backupSet = AE.backupsetId OR AE.backupsetId = 0)
					)
					OR (AE.clientId = 0 AND AE.clientGroupId = 0 AND APP.clientId = C.clientId AND AE.assocType = 2) -- TAKE CARE OF SCHEDULES FOR ALL CLIENTS
				)
			LEFT JOIN @ExcludedAssocEntity EAE ON
			(
				EAE.clientId=APP.clientId
					AND ( EAE.apptypeId=APP.apptypeId OR EAE.apptypeId=0)
					AND (EAE.instanceId=APP.instance OR EAE.instanceId=0)
					AND (EAE.backupsetId=APP.backupSet OR EAE.backupsetId=0)
					AND (EAE.subclientId=APP.id OR EAE.subclientId=0)
					AND (EAE.taskId = AE.taskId)
			)
			WHERE APP.appTypeId < 1000
			AND (APP.subclientStatus & 54 = 0)		-- CV_STATUS_UNINSTALLED, CV_STATUS_DELETED, CV_STATUS_DUMMY, CV_STATUS_HIDDEN
			AND AE.subclientId = 0					-- ONLY SCHEDULES NOT ASSOCIATED AT SUBCLIENT LEVEL
			AND APP.clientId = C.clientId
			--AND NOT EXISTS (SELECT 1 FROM APP_backupsetprop (NOLOCK) WHERE modified = 0 AND attrName = N'OnDemand Backupset' AND attrVal = N'1' AND componentNameId=APP.backupSet)
AND operationType NOT IN ( 4020, 4026)
			AND EAE.clientId IS NULL
	--
			--select * from #AssocEntity
	--
			--REMOVE ORIGINAL ENTITY TO AVOID DUPLICATE
			DELETE #AssocEntity
			WHERE (subclientId=0
				AND (clientId>0 OR clientGroupId>0)		-- DO NOT REMOVE UPDATE SCHEDULES
			)
AND operationType NOT IN ( 4020, 4026)
	--
			--REMOVE TASKS FOR WHICH CLIENT IS EXCLUDED FROM ASSOCIATION
			DELETE #AssocEntity
			FROM #AssocEntity AE
			INNER JOIN @clients C ON C.clientId = AE.clientId
			INNER JOIN TM_AssocEntity TAE ON TAE.assocId=AE.assocId
			WHERE TAE.exclude=1 AND TAE.taskId = AE.taskId
			-- Remove Tasks which are not for given instance/backupset/subclient.
			DELETE #AssocEntity
			FROM #AssocEntity AE
			where (AE.instanceId <> @instanceId AND @instanceId>0) OR
			(AE.backupsetId <> @backupsetId AND @backupsetId>0) OR
			(AE.subclientId <> @subclientId AND @subclientId>0) OR
			(AE.apptypeId <> @appTypeId AND @appTypeId>0)
			-- Remove OSC schedules specific to SQL and Oracle Agents for 10.0 clients since client side logic is there in 11.0 only
			DELETE AE
			FROM #AssocEntity AE
			INNER JOIN @clients C ON C.clientId = AE.clientId
			INNER JOIN APP_Client AC ON AC.id = C.clientId
WHERE AE.apptypeId in (22, 81, 80, 61, 59, 77) -- same as supported appTypes list in OscAgentFactory.cpp
				AND AC.releaseId <= 15
		--deleting assoc entities which are already handled from MAAssocEntities or which are incomplete
		-- This might happen when schedules are associated at instance level or client level.
		DELETE #AssocEntity
			FROM #AssocEntity AE
			INNER JOIN #MAAssocEntities MAAssocEntitiesForClient ON AE.clientId = MAAssocEntitiesForClient.clientId
			LEFT JOIN #MAAssocEntities MAAssocEntities
			ON (AE.instanceId = MAAssocEntities.instanceId OR AE.instanceId=0) AND
			(AE.backupsetId = MAAssocEntities.backupsetId OR AE.backupsetId=0) AND
			(AE.subclientId = MAAssocEntities.subclientId OR AE.subclientId=0) AND
			(AE.apptypeId = MAAssocEntities.appTypeId OR AE.apptypeId=0) AND
			(AE.clientId = MAAssocEntities.clientId )
			WHERE MAAssocEntities.instanceId IS NULL
		--Update association to say that it is a dumping subclient if subclient has mount path in the same client
		--or if subclient is part of input client and does not have mapping in mount path yet.
		UPDATE AE
		SET AE.isDumpSubClientOfMA = 1
		FROM #AssocEntity AE
		WHERE AE.clientId > 0 AND @isMediaAgent = 1 AND AE.clientId = @i_clientId AND AE.subclientId > 0
		-- Override client IDs for backup schedules with laptop clientid. This is for user centric clients.
		UPDATE #AssocEntity
		SET clientId = @i_clientId
		WHERE subclientId > 0
		-- Remove system created subclients like indexbackup and ddb subclient
		delete AssocEntity
		from #AssocEntity AssocEntity inner join App_subclientprop with (readuncommitted)
		on AssocEntity.subclientId=App_subclientprop.componentNameId
		and App_subclientprop.modified=0
		and App_subclientprop.attrName in ('Index SubClient','DDB Backup') --CV_IS_INDEX_SUBCLIENT,'CV_DDB_BACKUP_FLAG'
		and App_subclientprop.cs_attrName IN (CHECKSUM(N'Index SubClient'),CHECKSUM(N'DDB Backup') ) --CV_IS_INDEX_SUBCLIENT,'CV_DDB_BACKUP_FLAG'
		and App_subclientprop.attrval='1'
		--select * from #AssocEntity
		--REMOVE CLIENTS WHICH DO NOT HAVE VALID FILTER ASSOCIATION
	    DELETE #AssocEntity
	    FROM #AssocEntity T
	    WHERE
	    (
		    EXISTS ( SELECT taskId
					    FROM [TM_AssocFilter] WITH (NOLOCK)
					    WHERE taskId = T.taskId
				    )
		    AND NOT EXISTS
		    ( SELECT taskId
			    FROM [TM_AssocFilter] FLT WITH (NOLOCK)
			    WHERE FLT.taskId = T.taskId
			    AND
			    (  -- filter_type, 1 is appgroup and 2 is individual apptype
				    (
					    FLT.filter_type = 2
					    AND
					    (
						    FLT.filter_value = @appTypeId
						    OR
						    ( @appTypeId = 0 AND FLT.filter_value IN (SELECT APP_Application.appTypeId FROM APP_Application WITH (NOLOCK) WHERE id = T.subclientId) )
					    )
				    )
				    OR
				    (
					    FLT.filter_type = 1
					    AND EXISTS
					    (
						    SELECT FLT.filter_value
						    FROM [APP_AppTypeGroupAssoc] WITH (NOLOCK)
						    WHERE appGroupId = FLT.filter_value
						    AND
						    (
							    [APP_AppTypeGroupAssoc].appTypeId = @appTypeId
							    OR
							    ( @appTypeId = 0 AND [APP_AppTypeGroupAssoc].appTypeId IN (SELECT APP_Application.appTypeId FROM APP_Application WITH (NOLOCK) WHERE id = T.subclientId) )
						    )
					    )
				    )
			    )
		    )
	    )
		--Based on whether support exists for sweeping on MA we need to filter out useStorageSpaceFromMA options for those subclients
		UPDATE ASSOC
		SET ASSOC.hasSupportedMAForDump = 1
		FROM #AssocEntity ASSOC
		INNER JOIN APP_Application APP WITH(READUNCOMMITTED) ON ASSOC.subclientId = APP.id
		INNER JOIN ArchGroup AG WITH(READUNCOMMITTED) ON AG.id = APP.logArchGrpID
	    INNER JOIN MMDatapath DP WITH (READUNCOMMITTED) ON AG.defaultCopy = DP.CopyId
	    INNER JOIN MMDrivePool DVP WITH (READUNCOMMITTED) ON DP.DrivePoolId = DVP.DrivePoolId AND DP.SpareGroupId = 0
	    INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON DVP.MasterPoolId = MP.MasterPoolId
	    INNER JOIN MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED) ON  MSD.MountPathId = MP.MountPathId
	    INNER JOIN MMDeviceController DC WITH (READUNCOMMITTED) ON DC.DeviceId = MSD.DeviceId
	    LEFT OUTER JOIN APP_VMToPMMap VC WITH(READUNCOMMITTED) ON DC.clientId = VC.VMClientId
	    INNER JOIN App_Client C WITH (READUNCOMMITTED) ON C.id = ISNULL(VC.PMClientId,DC.clientId)
	    INNER JOIN simOperatingSystem SO WITH (READUNCOMMITTED) ON C.simOperatingSystemId = SO.id
	    INNER JOIN simInstalledPackages SI WITH (READUNCOMMITTED) ON C.id = SI.ClientId
WHERE DP.Flag & 4 > 0
AND DC.deviceAccessType & (16|32|128) = 0
			AND MP.MountPathTypeId <> 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
			AND (SO.Name  LIKE 'Linux' OR SO.Name LIKE 'Windows%')
			AND (C.ReleaseId > 16 OR (C.ReleaseId = 16 AND SI.HighestSP >= @MSSQLsupportedReleaseVersionForDumpSweeep))
			AND ASSOC.clientId > 0 AND ASSOC.subclientId > 0
		-- First retrieve all subtask options so that we can modify them later.
		Insert into #subTaskXmlOptions(subTaskId,subTaskXmlOptions,isDumpSubclient, hasSupportedMAForDump)
		SELECT DISTINCT AssocEntity.subTaskId,NULL,AssocEntity.isDumpSubclientOfMA, AssocEntity.hasSupportedMAForDump
			FROM #AssocEntity AssocEntity
		UPDATE STXO
			SET  subTaskXmlOptions = xmlValue.query('/TMMsg_JobOption/*')
		FROM #subTaskXmlOptions STXO
		INNER JOIN TM_SubTaskXMLOptions XO ON STXO.subTaskId = XO.subTaskId
		-- Update whether schedule has minSync interval applicable for each subclient.
		Update AssocEntity
		set isSyncIntervalApplicable = 1
		from #AssocEntity AssocEntity
		INNER JOIN App_SyncCloudConfig CF WITH (READUNCOMMITTED) ON CF.subclientId=AssocEntity.subclientId
		INNER JOIN App_SyncCloudFolder WF WITH (READUNCOMMITTED) ON CF.syncWebFolderId = WF.syncWebFolderId
WHERE WF.flag&CAST(0x1 AS INT) = 0
AND CF.flag&CAST(0x1 AS INT) = 0
		AND CF.syncType&1=1
		AND WF.syncWebFolderId NOT IN (
				SELECT SFV.syncWebFolderId FROM App_SyncCloudFolders SFV  -- VIEW FOR SHARE
				WHERE SFV.FLAG <> 0 --CHECK THAT FOLDER IS A SHARE
				)
		update subTaskXmlOptions
		set subTaskXmlOptions.modify('delete //./automaticSchedulePattern/@minSyncInterval')
		from #subTaskXmlOptions subTaskXmlOptions
		inner join
		(
			select AssocEntity.subTaskId
			from #AssocEntity AssocEntity
			where isSyncIntervalApplicable=0
			except
			select AssocEntity.subTaskId
			from #AssocEntity AssocEntity
			where isSyncIntervalApplicable=1
		) schedules
		 on
		schedules.subTaskId = subTaskXmlOptions.subTaskId
		update subTaskXmlOptions
		set subTaskXmlOptions.modify('delete //./automaticSchedulePattern/@minSyncIntervalMinutes')
		from #subTaskXmlOptions subTaskXmlOptions
		inner join
		(
			select AssocEntity.subTaskId from #AssocEntity AssocEntity
			where isSyncIntervalApplicable=0
			except
			select AssocEntity.subTaskId from #AssocEntity AssocEntity
			where isSyncIntervalApplicable=1
		) schedules
		 on
		schedules.subTaskId = subTaskXmlOptions.subTaskId
--- CODE BELOW HERE IS FROM TM_OSCDumpSweepProcessing.spb  ----------
--Media agent driven properties handling for dump sweep feature
	IF @isMediaAgent = 1
	BEGIN
		update subTaskXmlOptions
		SET dumpSweepFeature = 1
		FROM #subTaskXmlOptions subTaskXmlOptions
		WHERE subTaskXmlOptions.exist('/commonOpts[1]/automaticSchedulePattern[1]/@useStorageSpaceFromMA') = 1
		--update xml options saying that the operation is sweep process on media agent
		update STX
		SET isAssociatedToMASubclient = 1
		FROM #subTaskXmlOptions STX
		INNER JOIN #AssocEntity AE ON AE.subTaskId = STX.subTaskId
		INNER JOIN #MAAssocEntities MAS ON AE.subclientId = MAS.subclientId
		WHERE STX.dumpSweepFeature = 1
		update #subTaskXmlOptions
		SET isForMediaAgentAttrPresent = 1
		WHERE subTaskXmlOptions.exist('/commonOpts[1]/automaticSchedulePattern[1]/@isForMediaAgent') = 1
		AND dumpSweepFeature = 1
		update STX
		SET subTaskXmlOptions.modify('replace value of (commonOpts[1]/automaticSchedulePattern[1]/@isForMediaAgent)[1] with sql:variable("@isMediaAgent")')
		FROM #subTaskXmlOptions STX
		WHERE  isForMediaAgentAttrPresent = 1 AND isAssociatedToMASubclient = 1
		AND STX.dumpSweepFeature = 1
		update STX
		set subTaskXmlOptions.modify('insert (attribute isForMediaAgent {1}) into (/commonOpts[1]/automaticSchedulePattern)[1]')
		FROM #subTaskXmlOptions STX
		WHERE  isForMediaAgentAttrPresent <> 1 AND isAssociatedToMASubclient = 1
		AND STX.dumpSweepFeature = 1
		--remove sweepStartTime for non media agents
		update STX
		SET subTaskXmlOptions.modify('delete (/commonOpts[1]/automaticSchedulePattern[1]/@sweepStartTime)[1]')
		FROM #subTaskXmlOptions STX
		WHERE isForMediaAgentAttrPresent <> 1 AND isAssociatedToMASubclient = 0
		AND STX.dumpSweepFeature = 1
		--remove isForMediaAgent when subclient is for dump and dump sweep feature is enabled
		update STX
		SET subTaskXmlOptions.modify('delete (/commonOpts[1]/automaticSchedulePattern[1]/@isForMediaAgent)[1]')
		FROM #subTaskXmlOptions STX
		WHERE STX.dumpSweepFeature = 1 AND STX.isDumpSubclient = 1
	END
IF EXISTS(SELECT 1 FROM #AssocEntity WHERE appTypeId IN (81, 22, 80, 135, 3 ))
	BEGIN
		--Do below processing for dump sweep only if SQL, oracle subclients are present.
		DECLARE @clientReleaseId INT, @clientVersionId INT
		set @clientReleaseId = (SELECT TOP 1 MAX(SP.HighestSP) FROM simInstalledPackages SP where SP.clientId = @i_clientId)
		set @clientVersionId = (SELECT C.releaseId FROM APP_Client C where C.id = @i_clientId)
		update subTaskXmlOptions
		SET resetUseStorageSpaceFromMA = 1
		FROM #subTaskXmlOptions subTaskXmlOptions
		INNER JOIN #AssocEntity AE ON AE.subTaskId = subTaskXmlOptions.subTaskId
		WHERE ((@clientVersionId = 16 AND @clientReleaseId < @MSSQLsupportedReleaseVersionForDumpSweeep) OR @clientVersionId < 16)
		AND @clientReleaseId IS NOT NULL
AND AE.appTypeId IN (81)
		--Reset Dump sweep processing if < release for Oracle and SAP HANA
		update subTaskXmlOptions
		SET resetUseStorageSpaceFromMA = 1
		FROM #subTaskXmlOptions subTaskXmlOptions
		INNER JOIN #AssocEntity AE ON AE.subTaskId = subTaskXmlOptions.subTaskId
		WHERE ((@clientVersionId = 16 AND @clientReleaseId < @SAPORAsupportedReleaseVersionForDumpSweeep) OR @clientVersionId < 16)
		AND @clientReleaseId IS NOT NULL
AND AE.appTypeId IN (22, 135)
		--Reset Dump sweep processing if < release for Oracle RAC
		update subTaskXmlOptions
		SET resetUseStorageSpaceFromMA = 1
		FROM #subTaskXmlOptions subTaskXmlOptions
		INNER JOIN #AssocEntity AE ON AE.subTaskId = subTaskXmlOptions.subTaskId
		WHERE ((@clientVersionId = 16 AND @clientReleaseId < @OracleRACsupportedReleaseVersionForDumpSweeep) OR @clientVersionId < 16)
		AND @clientReleaseId IS NOT NULL
AND AE.appTypeId IN (80)
		--Reset Dump sweep processing if release < 21 for Informix
		update subTaskXmlOptions
		SET resetUseStorageSpaceFromMA = 1
		FROM #subTaskXmlOptions subTaskXmlOptions
		INNER JOIN #AssocEntity AE ON AE.subTaskId = subTaskXmlOptions.subTaskId
		WHERE ((@clientVersionId = 16 AND @clientReleaseId < @InformixsupportedReleaseVersionForDumpSweeep) OR @clientVersionId < 16)
		AND @clientReleaseId IS NOT NULL
AND AE.appTypeId IN (3)
		UPDATE AE
		SET osTypeOfClient = os.type
		FROM #AssocEntity AE
		INNER JOIN APP_Client c WITH(READUNCOMMITTED) ON AE.clientId = c.id
		INNER JOIN simOperatingSystem os WITH(READUNCOMMITTED) ON c.simOperatingSystemId = os.id
		INNER JOIN simInstalledPackages SP ON SP.clientId = c.id -- Join with SimInstalledPackages to handle pseudo clients. For Psuedo clients there is no OS.
		--For non supported MA reset the feature
		update subTaskXmlOptions
		SET resetUseStorageSpaceFromMA = 1
		FROM #subTaskXmlOptions subTaskXmlOptions
		INNER JOIN #AssocEntity AE ON AE.subTaskId = subTaskXmlOptions.subTaskId
		AND AE.hasSupportedMAForDump = 0 AND subTaskXmlOptions.hasSupportedMAForDump = 0
		-- Restricting dump sweep feature for linux clients of MSSQL apptype
		-- Filter out Dump Sweep option for Linux clients of MSSQL and this should be just regular OSC.
		update STX
		SET resetUseStorageSpaceFromMA = 1
		--SET subTaskXmlOptions.modify('delete (/commonOpts[1]/automaticSchedulePattern[1]/@useStorageSpaceFromMA)[1]')
		FROM #subTaskXmlOptions STX
		INNER JOIN #AssocEntity AE ON AE.subTaskId = STX.subTaskId
		WHERE AE.osTypeOfClient <> 'Windows' AND AE.osTypeOfClient <> '' -- To handle pseudo clients
AND (STX.isAssociatedToMASubclient = 0 OR AE.isDumpSubclientOfMA = 1) AND AE.apptypeId = 81
		-- Filter dump sweep option for SQL AG Replica clients associated to non windows clients or which are less than SP version 16.
		update STX
		SET resetUseStorageSpaceFromMA = 1
		--SET subTaskXmlOptions.modify('delete (/commonOpts[1]/automaticSchedulePattern[1]/@useStorageSpaceFromMA)[1]')
		FROM #subTaskXmlOptions STX
		INNER JOIN
		(
			SELECT DISTINCT STX.subTaskId, os.Type, APP_Client.releaseId, MAX(SimInstalledPackages.HighestSP) as versionId FROM #subTaskXmlOptions STX
			INNER JOIN #AssocEntity AE ON AE.subTaskId = STX.subTaskId
			INNER JOIN APP_InstanceProp instance WITH(READUNCOMMITTED) ON AE.instanceId = instance.componentNameID
			AND instance.attrName = N'Availability Replicas' and instance.modified = 0
			OUTER APPLY (SELECT CAST(instance.attrVal AS XML) ) as T(x)
			OUTER APPLY T.X.nodes('App_SQLAvailabilityReplicas/SQLAvailabilityReplicasList/replicaClient') as M(C)
			INNER JOIN App_Client (NOLOCK) ON M.C.value('@clientId', 'INT') = App_Client.id
			INNER JOIN simOperatingSystem os WITH(READUNCOMMITTED) ON App_Client.simOperatingSystemId = os.id
			INNER JOIN SimInstalledPackages  (NOLOCK) ON App_Client.id = SimInstalledPackages.clientID
			GROUP BY STX.subTaskId, os.Type, APP_Client.releaseId
		)  NonDumpSweepSchedules
		ON NonDumpSweepSchedules.subTaskId = STX.subTaskId
		WHERE ((NonDumpSweepSchedules.releaseId = 16 AND NonDumpSweepSchedules.versionId < @MSSQLsupportedReleaseVersionForDumpSweeep) OR NonDumpSweepSchedules.releaseId < 16)
		OR NonDumpSweepSchedules.Type <> 'Windows'
		update subTaskXmlOptions
		set subTaskXmlOptions.modify('delete //./automaticSchedulePattern/@useStorageSpaceFromMA')
		from #subTaskXmlOptions subTaskXmlOptions
		WHERE resetUseStorageSpaceFromMA = 1 AND subTaskXmlOptions.exist('//./automaticSchedulePattern[1]/@useStorageSpaceFromMA') = 1
		--Restricting regular log backups for dump sweep SQL Subclients
		/*
			Logic is :
				For the subclients which have been associated to dump sweep schedule, insert in Subclient prop
		*/
		DECLARE @dumpSweepEnabled INT = 1
		UPDATE AE
		SET isDumpSweepEnabled = 1
		FROM #AssocEntity AE
		INNER JOIN #subTaskXmlOptions STXO (NOLOCK) ON AE.subTaskId = STXO.subTaskId AND AE.hasSupportedMAForDump = STXO.hasSupportedMAForDump
		AND STXO.subTaskXmlOptions.exist('//./automaticSchedulePattern[@useStorageSpaceFromMA=sql:variable("@dumpSweepEnabled")]') = 1
AND AE.appTypeId IN (81, 22, 80, 135,3)
		-- Set the dump Sweep schedule enabled property on subclient so that IDA can convert regular backups to dump sweep backups.
		INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
		SELECT DISTINCT AE.subclientId, 'Dump Sweep Schedule', 7, 1, @nowTime,0,0 -- CV_PROP_DUMP_SWEEP_SCHEDULE
		FROM #AssocEntity AE
		LEFT JOIN App_SubclientProp (NOLOCK) SCP ON AE.subclientId = SCP.componentNameId
			AND SCP.attrname = 'Dump Sweep Schedule' --CV_PROP_DUMP_SWEEP_SCHEDULE
			AND SCP.cs_attrName = CHECKSUM(N'Dump Sweep Schedule') --CV_PROP_DUMP_SWEEP_SCHEDULE
			AND SCP.modified = 0
		WHERE SCP.attrVal IS NULL
		AND AE.isDumpSweepEnabled = 1
AND AE.apptypeId IN ( 81 )
		-- Set dump sweep schedule enabled property on instance for Oracle, SAP HANA
		-- Age of instance properties
		INSERT INTO APP_InstanceProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
		SELECT DISTINCT AE.instanceId, 'Dump Sweep Schedule', 7, 1, @nowTime,0,0 -- CV_PROP_DUMP_SWEEP_SCHEDULE
		FROM #AssocEntity AE
		LEFT JOIN App_InstanceProp (NOLOCK) AIP ON AE.instanceId = AIP.componentNameId
			AND AIP.attrname = 'Dump Sweep Schedule' --CV_PROP_DUMP_SWEEP_SCHEDULE
			AND AIP.modified = 0
		WHERE AIP.attrVal IS NULL
		AND AE.isDumpSweepEnabled = 1
AND AE.apptypeId IN (22, 80, 135,3)
		--For SAP HANA update backupset prop also
		INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT DISTINCT AE.backupsetId, 'Dump Sweep Schedule', 7, 1, @nowTime,0 -- CV_PROP_DUMP_SWEEP_SCHEDULE
		FROM #AssocEntity AE
		LEFT JOIN App_BackupSetProp (NOLOCK) ABP ON AE.backupsetId = ABP.componentNameId
			AND ABP.attrname = 'Dump Sweep Schedule' --CV_PROP_DUMP_SWEEP_SCHEDULE
			AND ABP.modified = 0
		WHERE ABP.attrVal IS NULL
		AND AE.isDumpSweepEnabled = 1
AND AE.apptypeId IN (135,3)
	END
	-- Remove this property from existing subclients where no longer applicable.
	DELETE App_SubclientProp
	FROM App_SubclientProp
	INNER JOIN
	(
		SELECT App_SubclientProp.ID FROM App_SubclientProp (NOLOCK)
		INNER JOIN App_Application (NOLOCK) ON App_SubclientProp.componentNameID = App_Application.ID
		AND App_SubclientProp.attrName = 'Dump Sweep Schedule' --CV_PROP_DUMP_SWEEP_SCHEDULE
		AND App_SubclientProp.cs_attrName = CHECKSUM(N'Dump Sweep Schedule') --CV_PROP_DUMP_SWEEP_SCHEDULE
		AND App_SubclientProp.modified = 0
		AND (App_Application.instance = @instanceId OR @instanceId=0)
		AND (App_Application.backupSet = @backupsetId OR @backupsetId=0)
		AND (App_Application.Id = @subclientId OR @subclientId=0)
		AND (App_Application.apptypeId = @appTypeId OR @appTypeId=0)
		INNER JOIN @clients clients ON clients.clientID = App_Application.ClientID AND clients.isForMA = 0
		LEFT JOIN #AssocEntity DSA ON App_SubclientProp.componentNameID = DSA.subclientId
		AND DSA.isDumpSweepEnabled = 1
		WHERE DSA.subclientId IS NULL
	) DeletedSubclientProps
	ON DeletedSubclientProps.Id = App_SubclientProp.Id
	-- For oracle and SAP instances update the modified instead.
	UPDATE AIP
	SET AIP.modified = @nowTime
	 FROM APP_InstanceProp AIP
	INNER JOIN
	(
		SELECT APP_InstanceProp.id FROM APP_InstanceProp (NOLOCK)
		INNER JOIN App_Application (NOLOCK) ON APP_InstanceProp.componentNameID = App_Application.instance
		AND APP_InstanceProp.attrName = 'Dump Sweep Schedule' --CV_PROP_DUMP_SWEEP_SCHEDULE
		AND APP_InstanceProp.modified = 0
		AND (App_Application.instance = @instanceId OR @instanceId=0)
		AND (App_Application.backupSet = @backupsetId OR @backupsetId=0)
		AND (App_Application.Id = @subclientId OR @subclientId=0)
		AND (App_Application.apptypeId = @appTypeId OR @appTypeId=0)
		INNER JOIN @clients clients ON clients.clientID = App_Application.ClientID AND clients.isForMA = 0
		LEFT JOIN #AssocEntity DSA ON APP_InstanceProp.componentNameID = DSA.instanceId
		AND DSA.isDumpSweepEnabled = 1
		WHERE DSA.instanceId IS NULL
AND App_Application.appTypeId IN (22, 80, 135,3)
	)IP
	ON IP.id = AIP.id AND AIP.modified = 0
	-- For SAP HANA update modified
	UPDATE ABP
	SET ABP.modified = @nowTime
	 FROM APP_BackupSetProp ABP
	INNER JOIN
	(
		SELECT APP_BackupSetProp.id FROM APP_BackupSetProp (NOLOCK)
		INNER JOIN App_Application (NOLOCK) ON APP_BackupSetProp.componentNameId = App_Application.backupSet
		AND APP_BackupSetProp.attrName = 'Dump Sweep Schedule' --CV_PROP_DUMP_SWEEP_SCHEDULE
		AND APP_BackupSetProp.modified = 0
		AND (App_Application.instance = @instanceId OR @instanceId=0)
		AND (App_Application.backupSet = @backupsetId OR @backupsetId=0)
		AND (App_Application.Id = @subclientId OR @subclientId=0)
		AND (App_Application.apptypeId = @appTypeId OR @appTypeId=0)
		INNER JOIN @clients clients ON clients.clientID = App_Application.ClientID AND clients.isForMA = 0
		LEFT JOIN #AssocEntity DSA ON APP_BackupSetProp.componentNameID = DSA.backupsetId
		AND DSA.isDumpSweepEnabled = 1
		WHERE DSA.backupsetId IS NULL
AND App_Application.appTypeId IN (135,3)
	)IP
	ON IP.id = ABP.id AND ABP.modified = 0
--- CODE ABOVE HERE IS FROM TM_OSCDumpSweepProcessing.spb  ----------
		---------------------------
		--CONSTRUCT THE XML---------
		----------------------------
		SET @xmlText =	( SELECT	 --TASKLIST
							( SELECT 	--TASK
										[TM_Task].taskId AS '@taskId' ,
										[TM_Task].taskType AS '@taskType' ,
										[TM_Task].policyType AS '@policyType'
							FOR
								XML PATH('task') ,
									TYPE
							) ,
							( SELECT DISTINCT --ASSOC
										ASSOC.assocType '@_type_' ,
										ASSOC.clientGroupId '@clientGroupId' ,
										ASSOC.clientId '@clientId' ,
										ASSOC.apptypeId '@applicationId' ,
										ASSOC.instanceId '@instanceId' ,
										ASSOC.backupsetId '@backupsetId' ,
										ASSOC.subclientId '@subclientId'
								FROM      #AssocEntity AS ASSOC
								WHERE ASSOC.taskId=AEM.taskId
								AND AEM.subTaskId = ASSOC.subTaskId
								AND AEM.isDumpSubclientOfMA = ASSOC.isDumpSubclientOfMA
								AND AEM.hasSupportedMAForDump = ASSOC.hasSupportedMAForDump
							FOR
								XML PATH('associations') ,
									TYPE
							) ,
							( SELECT		--SUBTASKINFO
										--TASK RUN TIME FROM TM_RunTime WITH (READUNCOMMITTED) Table
										( SELECT	DISTINCT --SUBTASK
													STASK.subTaskId AS '@subTaskId' ,
													STASK.subTaskType AS '@subTaskType' ,
													STASK.operationType AS '@operationType' ,
													STASK.subTaskName AS '@subTaskName'
										FOR
											XML PATH('subTask') ,
												TYPE
										) ,
										( SELECT  --OPTIONS
													SOPTIONS.subTaskXmlOptions AS 'options'
											FROM    #subTaskXmlOptions SOPTIONS
											WHERE   SOPTIONS.subTaskId = STASK.subTaskId
													AND SOPTIONS.isDumpSubclient = AEM.isDumpSubclientOfMA
													AND SOPTIONS.hasSupportedMAForDump = AEM.hasSupportedMAForDump
													AND AEM.subTaskId = SOPTIONS.subTaskId
											FOR XML PATH('') ,TYPE
										)
								FROM		TM_subTask AS STASK WITH (NOLOCK)
								WHERE		STASK.taskId = [TM_Task].taskId
								and STASK.subTaskId in
								(
									select distinct AssocEntity.subTaskId
									from #AssocEntity AssocEntity  WITH (NOLOCK)
								)
							FOR
								XML PATH('subTasks') ,
									TYPE
							)
						FROM   dbo.TM_Task WITH (READUNCOMMITTED)
						INNER JOIN
						(
							SELECT DISTINCT AE.subTaskId, AE.taskId, AE.isDumpSubclientOfMA, AE.hasSupportedMAForDump FROM #AssocEntity AE
						) AEM
						ON AEM.taskId = TM_Task.taskId
					FOR
						XML PATH('taskDetail') ,
							ROOT('TMMsg_GetTaskListResp')
					)
	END
	IF @xmlText IS null
	BEGIN
		SET @xmlText = '<TMMsg_GetTaskListResp/>'
	END
	IF OBJECT_ID('tempdb.dbo.#InstallInfo') IS NOT null
		DROP TABLE #InstallInfo
	IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
		DROP TABLE #AssocEntity
	IF OBJECT_ID('tempdb.dbo.#subTaskXmlOptions') IS NOT null
		DROP TABLE #subTaskXmlOptions
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetOSCTaskList')
	delete from GxQscripts where name = 'TM_GetOSCTaskList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetOSCTaskList')
	delete from GXDBVersions where aliasname = 'TM_GetOSCTaskList'
GO

insert into GXDBVersions values(2, 'TM_GetOSCTaskList',  'v1.25.2.42.8.2', 'TM_GetOSCTaskList', 'v1.25.2.42.8.2')
GO

