

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetNextScheduleRunTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_GetNextScheduleRunTime')
BEGIN
	print '>>> Drop Stored Procedure: TM_GetNextScheduleRunTime <<<'
	drop procedure TM_GetNextScheduleRunTime
END
IF EXISTS (select * from GxQscripts where name='TM_GetNextScheduleRunTime')
	delete from GxQscripts where name = 'TM_GetNextScheduleRunTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetNextScheduleRunTime')
	delete from GXDBVersions where aliasname = 'TM_GetNextScheduleRunTime'
GO
print '... Creating Procedure: TM_GetNextScheduleRunTime'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_GetNextScheduleRunTime
  @inSubClientId INT,
  @inBkpLevel INT,
  @inCountDisabled INT,
  @inCountRunningJob INT,
  @inIgnoreJobId INT = 0
AS
  DECLARE @nextRunTime INTEGER
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- -- SP BODY BEGIN : TM_ComputeStartTimeForClientTbl.spb ----------------------------------------------------------------------------------------------------------------------------------
IF object_id('tempdb.dbo.#Clients_Timezone_StartTime') is NOT NULL
BEGIN
	DROP TABLE #Clients_Timezone_StartTime
END
CREATE TABLE #Clients_Timezone_StartTime(clientId INT, timezoneName NVARCHAR(MAX), jobStartTime INT DEFAULT -1, taskID INT DEFAULT 0, patternID INT DEFAULT 0 )
CREATE CLUSTERED INDEX Clients_Timezone_StartTime_clientId_taskID_Index ON #Clients_Timezone_StartTime (clientId, taskID)
IF object_id('tempdb.dbo.#SubClients_Timezone_StartTime') is NOT NULL
BEGIN
	DROP TABLE #SubClients_Timezone_StartTime
END
CREATE TABLE #SubClients_Timezone_StartTime(appId INT, timezoneName NVARCHAR(MAX), jobStartTime INT DEFAULT -1, taskID INT DEFAULT 0)
CREATE CLUSTERED INDEX SubClients_Timezone_StartTime_appId_Index ON #SubClients_Timezone_StartTime (appId)
-- -- SP BODY END : TM_ComputeStartTimeForClientTbl.spb ------------------------------------------------------------------------------------------------------------------------------------
DECLARE @jmBkpLevel INT = 0
DECLARE @BackupTasks TABLE
(taskId INT, subTaskId INT, useJobStartTime INT DEFAULT 0, lastSuccessBkupTime INT, freqInterval INT, patternType INT, jobStartTime INT DEFAULT -1, patternID INT,
PRIMARY KEY(subTaskId))
DECLARE @tmBkpLevelTbl TABLE
(bkpLevel INT)
DECLARE @nowTimeUTC INT = dbo.getUnixtime(getutcdate())
SET	@jmBkpLevel = @inBkpLevel
IF @inSubClientId>0
BEGIN
	DECLARE @parentAppId INT = 0
	-- pick a non deleted parent.
	SELECT TOP 1 @parentAppId = parentAppId FROM JMVSAAppJobLink (NOLOCK)
	INNER JOIN App_Application (NOLOCK) ON childAppId = @inSubClientId AND parentAppId = App_Application.Id
	ORDER BY parentAppId desc
	IF @parentAppId>0
	BEGIN
		SET @inSubClientId = @parentAppId
	END
END
IF @inBkpLevel <> 0
BEGIN
	-- Full
	IF @inBkpLevel & 1 = 1
	BEGIN
		INSERT INTO @tmBkpLevelTbl
VALUES(1), (4)
		-- A constant for full backup levels defined in CvConstDef.h;
		-- FULL=1, SYNTHETICFULL=64, SYNTHETIC_FULL_AND_INCR=128, SEL_OFFLINE_FULL=1024 and SEL_ONLINE_FULL=32768.
		SET	@jmBkpLevel = @jmBkpLevel | (1+64+128+1024+32768)
	END
	-- Incremental
	IF @inBkpLevel & 2 = 2
	BEGIN
		INSERT INTO @tmBkpLevelTbl
VALUES(2), (6)
	END
	-- Differential
	IF @inBkpLevel & 4 = 4
	BEGIN
		INSERT INTO @tmBkpLevelTbl
VALUES(3)
	END
	-- Synthetic Full
	IF @inBkpLevel & 64 = 64
	BEGIN
		INSERT INTO @tmBkpLevelTbl
VALUES(4)
	END
END
DECLARE @defaultCCId INT = 2
DECLARE	@l_ClientId  INT
DECLARE	@l_appTypeId INT
DECLARE	@l_instance  INT
DECLARE	@l_backupSet INT
DECLARE @l_counter INT
SET @l_counter = 0
-- Duration to offset from current UTC time in case computed next backup time is less than current time.
DECLARE @NextBackupTimeOffset INT = 300
DECLARE @retVal INT = 0
SELECT	@l_clientId = clientId, @l_appTypeId = appTypeId, @l_instance = instance, @l_backupSet = backupSet
FROM	APP_Application WITH (NOLOCK)
WHERE	id = @inSubClientId
declare @clientTimeZone nvarchar(max)
set @clientTimeZone = dbo.getclienttimezone(@l_ClientId)
if (@clientTimeZone IS null)
begin
	set @clientTimeZone = dbo.getclienttimezone(2)
end
SET	@nextRunTime = 0
IF @inCountRunningJob > 0
BEGIN
	IF @l_appTypeId = 1000 -- For Admin job, DR Backup
		SELECT	@nextRunTime = servStart
		FROM	JMAdminJobInfoTable WITH (NOLOCK)
		WHERE	opType = 11
		AND ( (@inBkpLevel = 0) OR (ER_BkpLevel & @jmBkpLevel) <> 0)
		AND commCellId = @defaultCCId
		AND		(@inIgnoreJobId = 0 OR @inIgnoreJobId <> JobId)
	ELSE
		SELECT	@nextRunTime = jobStartTime
		FROM	JMJobInfo INFO WITH (NOLOCK)
		INNER JOIN JMBkpJobInfo BKP WITH (NOLOCK) ON INFO.jobId = BKP.jobId AND INFO.commCellId = BKP.commCellId
		WHERE BKP.applicationId = @inSubClientId
		AND ( (@inBkpLevel = 0) OR (bkpLevel & @jmBkpLevel) <> 0)
		AND INFO.commCellId = @defaultCCId
		AND opType <> 60 -- SNAPTOTAPE
		AND		(@inIgnoreJobId = 0 OR @inIgnoreJobId <> INFO.JobId)
END
IF @nextRunTime = 0
BEGIN
	INSERT	INTO @BackupTasks(taskId,subTaskId, freqInterval, patternType, patternID)
SELECT DISTINCT STASK.taskId, STASK.subTaskId, CASE WHEN P.freq_type = 4096 THEN P.freq_interval ELSE 0 END, P.freq_type, P.PatternId
	FROM TM_SubTask STASK WITH (NOLOCK)
    INNER JOIN TM_PatternAssoc PA WITH (NOLOCK) ON STASK.subTaskId = PA.subTaskId
	INNER JOIN TM_Pattern P WITH (NOLOCK) ON PA.patternId = P.patternId AND P.freq_type NOT IN(1024) -- Exclude Automatic as they dont have a runtime
INNER JOIN TM_Task TASK WITH (NOLOCK) ON TASK.taskId = STASK.taskId AND TASK.taskType IN (2, 4)
	INNER JOIN dbo.TM_Associations ASSOC (NOLOCK) ON TASK.taskId = ASSOC.taskId
INNER JOIN TM_SubTaskOptions SOPT WITH (NOLOCK) ON STASK.subTaskId = SOPT.subTaskId AND SOPT.optionId = 458405394
	LEFT OUTER JOIN TM_AssocFilter FILTER WITH (NOLOCK) ON TASK.taskId = FILTER.taskId
WHERE STASK.subTaskType = 2
	AND		( (ASSOC.clientId > 0
				AND (ASSOC.clientId = 0 OR ASSOC.clientId = @l_ClientId
				AND (ASSOC.apptypeId = 0 OR ASSOC.apptypeId = @l_appTypeId
				AND (ASSOC.instanceId = 0 OR ASSOC.instanceId = @l_instance
				AND (ASSOC.backupsetId = 0 OR ASSOC.backupsetId = @l_backupSet
				AND (ASSOC.subclientId = 0 OR ASSOC.subclientId = @inSubClientId)
			   )))))
			   OR  (ASSOC.clientGroupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc CGA WITH (NOLOCK) WHERE CGA.clientId = @l_ClientId) AND ASSOC.clientId = 0)
			   OR ASSOC.assocType = 2 -- All clients
			   -- 27 All client groups ALL_CLIENT_GROUPS_ENTITY = 27
			   OR (ASSOC.assocType = 27 AND EXISTS(SELECT 1 FROM App_ClientGroupAssoc(NOLOCK) WHERE App_ClientGroupAssoc.clientId = @l_ClientId) )
			 )
	AND (TASK.disabled = 0 OR @inCountDisabled <> 0)
	AND ( (FILTER.filter_type IS NULL)
		  OR (FILTER.filter_type = 1 AND @l_appTypeId IN (SELECT appTypeId FROM APP_AppTypeGroupAssoc WITH (NOLOCK) WHERE appGroupId=FILTER.filter_value)) -- AssocFilterTypeConst appGroup
		  OR (FILTER.filter_type = 2 AND FILTER.filter_value = @l_appTypeId) -- AssocFilterTypeConst Apptype
		 )
	AND ( (@inBkpLevel = 0 ) OR SOPT.value IN (SELECT bkpLevel FROM @tmBkpLevelTbl) )
	-- Fix to handle exclude
	DELETE BT
	FROM @BackupTasks BT
	INNER JOIN TM_AssocEntity TE WITH(NOLOCK)
	ON TE.taskId = BT.taskId AND TE.exclude = 1
					AND TE.clientId = @l_ClientId
					AND (TE.apptypeId = @l_appTypeId OR TE.apptypeId = 0)
					AND (TE.instanceId = @l_instance OR TE.instanceId = 0)
					AND (TE.backupsetId = @l_backupSet OR TE.backupsetId = 0)
					AND (TE.subclientId = @inSubClientId OR TE.subclientId = 0)
	-- If there are no schedules associated to subclient and its subclient for discovered VM client, then we have to return next backup time from parent VSA subclient.
IF (NOT EXISTS(SELECT 1 FROM @BackupTasks) AND @inSubClientId>0 AND @l_appTypeId = 106 )
	BEGIN
		DECLARE @parentVSAAppId INT = 0
		DECLARE @inIgnoreJobIdParent INT = @inIgnoreJobId
		-- Pick the parent VM subclient from latest job. If the parent VM is deleted then reutrn 0.
		SELECT TOP 1 @parentVSAAppId = JMJobDataLink.parentAppId FROM JMJobDataLink (NOLOCK)
		INNER JOIN App_Application (NOLOCK) ON JMJobDataLink.childAppId = @inSubClientId AND JMJobDataLink.parentAppId = App_Application.Id
		AND LinkType=7 -- LINK_TYPE_FOR_VSA_V2_PARENT_CHILD
		ORDER BY JMJobDataLink.parentJobId DESC
		IF @inIgnoreJobId>0
		BEGIN
			-- Pick the parent VM jobID corresponding to child jobId. If the parent VM is deleted then reutrn 0.
			SELECT TOP 1 @inIgnoreJobIdParent = JMJobDataLink.parentJobId FROM JMJobDataLink (NOLOCK)
			WHERE childJobID = @inIgnoreJobId
			AND LinkType=7 -- LINK_TYPE_FOR_VSA_V2_PARENT_CHILD
			ORDER BY JMJobDataLink.parentJobId DESC
		END
		-- To avoid recursive call
		IF @parentVSAAppId = @inSubClientId
		BEGIN
			IF OBJECT_ID('tempdb..#TM_GetNextScheduleRunTimeResultTable') IS NOT NULL
			BEGIN
				INSERT INTO #TM_GetNextScheduleRunTimeResultTable
				SELECT 0
			END
			ELSE
			BEGIN
				SELECT	0
			END
			RETURN	0
		END
		-- If the parent subclient is deleed then return 0.
IF EXISTS(SELECT 1 FROM App_Application where id = @parentVSAAppId AND (subclientStatus & 0x00004) <> 0 )
		BEGIN
			IF OBJECT_ID('tempdb..#TM_GetNextScheduleRunTimeResultTable') IS NOT NULL
			BEGIN
				INSERT INTO #TM_GetNextScheduleRunTimeResultTable
				SELECT 0
			END
			ELSE
			BEGIN
				SELECT	0
			END
			RETURN	0
		END
		IF @parentVSAAppId>0
		BEGIN
			EXEC @retVal = TM_GetNextScheduleRunTime @parentVSAAppId, @inBkpLevel, @inCountDisabled ,@inCountRunningJob ,@inIgnoreJobIdParent
			RETURN @retVal
		END
	END
	-- Adding continuous schedule changes for getting last successful job start time
IF EXISTS(SELECT 1 FROM @BackupTasks WHERE patternType = 4096)
	BEGIN
		UPDATE RT
			SET useJobStartTime = CASE WHEN O.Value = '1' THEN 1 ELSE 0 END
			FROM @BackupTasks RT
			JOIN TM_SubTaskOptions O (NOLOCK) ON O.subTaskId = RT.subTaskId AND O.optionId = 414240771	--_COMMONOPTION_USE_JOB_START_TIME_FOR_CONTINUOUS_SCHEDULE
			AND @inBkpLevel <> 4 --Ignore synthetic fulls
AND patternType = 4096
		IF @l_appTypeId != 137 --_CV_APPTYPE_EXCHANGE_ONEPASS
		BEGIN
			DECLARE @currentJobStartTime INT = -1
			SELECT @currentJobStartTime = jobStartTime
					FROM    JMJobInfo INFO WITH (NOLOCK)
					INNER JOIN JMBkpJobInfo BKP WITH (NOLOCK) ON INFO.jobId = BKP.jobId AND INFO.commCellId = BKP.commCellId
					WHERE BKP.applicationId = @inSubClientId
					AND ( (@inBkpLevel = 0) OR (bkpLevel & @jmBkpLevel) <> 0)
					AND INFO.commCellId = @defaultCCId
					AND opType <> 60 -- SNAPTOTAPE
					AND     (@inIgnoreJobId = 0 OR @inIgnoreJobId <> INFO.JobId)
			--Active job running, so always consider this time
			IF @currentJobStartTime <> -1
			BEGIN
				UPDATE OuterRT
				SET OuterRT.lastSuccessBkupTime = CASE WHEN useJobStartTime = 1 THEN @currentJobStartTime ELSE @nowTimeUTC END
FROM @BackupTasks OuterRT WHERE OuterRT.patternType = 4096
			END
			ELSE
			BEGIN
				DECLARE @maxServEndDate INT = 0
				DECLARE @maxServStartDate INT = 0
				SELECT @maxServEndDate = MAX(BS.servEndDate), @maxServStartDate = MAX(BS.servStartDate)
				FROM JMBkpStats BS WHERE BS.appId = @inSubClientId AND BS.commCellId = @defaultCCId
				UPDATE OuterRT
					SET OuterRT.lastSuccessBkupTime = CASE WHEN OuterRT.useJobStartTime = 0 THEN @maxServEndDate ELSE @maxServStartDate END
				FROM @BackupTasks OuterRT
WHERE OuterRT.patternType = 4096
				AND OuterRT.lastSuccessBkupTime IS NULL
			END
		END
		-- For exchange directly consider the subtaskid from JMBkpStats
		IF @l_appTypeId = 137
		BEGIN
			-- First we check if there is a job running already and take its time
			UPDATE OuterRT
					SET OuterRT.lastSuccessBkupTime = CASE WHEN useJobStartTime = 1 THEN T.endDate ELSE @nowTimeUTC END
				FROM @BackupTasks OuterRT
				INNER JOIN (
					SELECT RT.subTaskId, JI.jobStartTime as endDate
						FROM @BackupTasks RT
JOIN JMBkpJobInfo BI (NOLOCK) ON BI.backupTaskId = RT.subTaskId AND RT.patternType = 4096
						INNER JOIN JMJobInfo JI ON JI.jobId = BI.jobId AND JI.commCellId = BI.commCellId
						AND JI.commCellId = 2
						AND BI.applicationId = @inSubClientId
						GROUP BY RT.subTaskId, JI.jobStartTime
					)T
				ON OuterRT.subTaskId = T.subTaskId
AND OuterRT.patternType = 4096
			UPDATE OuterRT
				SET OuterRT.lastSuccessBkupTime = T.endDate
			FROM @BackupTasks OuterRT
			INNER JOIN (
							SELECT RI.subTaskId, RI.useJobStartTime,
							CASE WHEN RI.useJobStartTime = 0 THEN MAX(servEndDate) ELSE MAX(servStartDate) END endDate
							FROM JMBkpStats BS
JOIN @BackupTasks RI ON RI.subTaskId = BS.subTaskId AND BS.commCellId = @defaultCCId AND RI.patternType = 4096
							GROUP BY RI.subTaskId, RI.useJobStartTime
						) T
				ON OuterRT.subTaskId = T.subTaskId
AND OuterRT.patternType = 4096
				AND OuterRT.useJobStartTime = T.useJobStartTime
				WHERE OuterRT.lastSuccessBkupTime IS NULL
		END
		-- It could happen that jobs from continuous schedules using job start time may run for really long time and then when we do  RT.lastSuccessBkupTime + (RT.freqInterval * 60)
		-- is less than current time. So we return value less then current time to AppgetSubclientCommonproperties and we may end up not showing next backup time in admin console on subclient
		-- details page. Since AppgetSubclientCommonproperties resets next backup time to 0 in case its less than current time.
		UPDATE RT
		SET lastSuccessBkupTime = @nowTimeUTC+@NextBackupTimeOffset-(RT.freqInterval * 60)
		FROM @BackupTasks RT
WHERE RT.patternType = 4096
		AND ( ( RT.lastSuccessBkupTime + (RT.freqInterval * 60) ) < @nowTimeUTC )
	END
	-- UPDATE job start time for entries in backup tasks table.
	INSERT INTO #Clients_Timezone_StartTime(clientId , timezoneName , jobStartTime , taskID , patternID )
	SELECT DISTINCT @l_clientId, NULL, -1, taskId, patternID
	FROM @BackupTasks
IF @l_appTypeId=106
	BEGIN
		INSERT INTO #SubClients_Timezone_StartTime(appId , timezoneName, jobStartTime, taskID )
		SELECT DISTINCT @inSubClientId, NULL,-1, taskId
		FROM @BackupTasks
    END
	-- Call stored procedure to compute timezone and start time for clients.
	EXEC TM_ComputeStarttimeForClient
	IF EXISTS(SELECT 1 FROM #SubClients_Timezone_StartTime WHERE timezoneName IS NOT NULL AND LEN(timezoneName)>0)
	BEGIN
		SELECT @clientTimeZone = timezoneName FROM #SubClients_Timezone_StartTime
	END
	--update job start if set at subclient level
	IF EXISTS(SELECT 1 FROM #SubClients_Timezone_StartTime  WHERE jobStartTime>=0)
	BEGIN
		UPDATE BackupTasks
		SET jobStartTime = #SubClients_Timezone_StartTime.jobStartTime
		FROM @BackupTasks BackupTasks
		INNER JOIN #SubClients_Timezone_StartTime ON BackupTasks.taskID = #SubClients_Timezone_StartTime.taskID
		AND #SubClients_Timezone_StartTime.jobStartTime>=0
	END
	ELSE
	BEGIN
		UPDATE BackupTasks
		SET jobStartTime = allClientsTable.jobStartTime
		FROM @BackupTasks BackupTasks
		INNER JOIN #Clients_Timezone_StartTime  allClientsTable ON allClientsTable.taskID = BackupTasks.taskID
		AND allClientsTable.patternId = BackupTasks.patternId
		WHERE allClientsTable.jobStartTime>=0
	END
	/*
	This is to identify jobs that are submitted by task manager but are still in queue to be picked by Job Manager.
	They are not yet entered into JMJobInfo or JMAdminJobInfoTable but still should be considered as running jobs
	*/
	IF @inCountRunningJob > 0
	BEGIN
		SELECT TOP 1 @nextRunTime = dbo.GetUnixTime(dbo.ClientLocalToUTCTime( dbo.GetDateTime(TMJR.created), 2))
		FROM TM_JobRequest TMJR WITH (NOLOCK)
		INNER JOIN TM_Jobs TMJ WITH (NOLOCK) ON TMJR.jobRequestId = TMJ.jobRequestId
		INNER JOIN @BackupTasks T ON T.subTaskId = TMJR.subTaskId
		WHERE (TMJ.status = 0 OR TMJ.status = 1 OR TMJ.status = 4097)
	END
	IF @nextRunTime = 0
	BEGIN
		SELECT	TOP 1 @nextRunTime = dbo.GetUnixTime(NextRunTimes.nextRunTime)
		from
		(
			select RT.nextRunTime
			FROM TM_RunTime RT WITH (NOLOCK)
			INNER JOIN TM_PatternAssoc PA WITH (NOLOCK) ON RT.patternId = PA.patternId
			INNER JOIN TM_PATTERN P WITH (NOLOCK) ON P.patternId = PA.patternId
			INNER JOIN @BackupTasks S ON PA.subTaskId = S.subTaskId
			WHERE RT.processed = 0
			AND P.tzId<>1001
AND S.patternType <> 4096
			union
			select dbo.ClientLocalToUTCTime( RTA.nextRunTime,2)
			FROM TM_RunTime RT WITH (NOLOCK)
			INNER JOIN TM_PatternAssoc PA WITH (NOLOCK) ON RT.patternId = PA.patternId
			INNER JOIN TM_PATTERN P WITH (NOLOCK) ON P.patternId = PA.patternId
			INNER JOIN @BackupTasks S ON PA.subTaskId = S.subTaskId
			INNER JOIN TM_RunTimeAssoc RTA WITH (NOLOCK) on RTA.runtimeId=RT.runtimeId
			WHERE RTA.processed = 0
			and P.tzId=1001
			AND RTA.timezoneNames = @clientTimeZone
AND S.patternType <> 4096
			AND RTA.jobStartTime = S.jobStartTime
			union
			SELECT dbo.GetDateTime(RT.lastSuccessBkupTime + (RT.freqInterval * 60))
FROM @BackupTasks RT WHERE RT.patternType = 4096
		) NextRunTimes
		ORDER BY NextRunTimes.nextRunTime
	END
END
	/*
	We have an issue that when the TM_RunTime is queried at the same time that the scheduled time is hit - task scheduler will
	be in the process of marking the existing row as processed = 1 and will insert a new row with processed = 0 indicating
	that is the upcoming scheduled time. When we query the table after the old row is marked processed but before a new row gets
	inserted we won't get any results which will suggest there is no upcoming schedule which is wrong.
	So we keep querying the table until we get a valid row or our wait time reached 12 seconds
	Scheduler thread updates the table once every 10 secs - so waiting for 12 secs max makes sense
	*/
	-- Below no need to check for TM_runtimeassoc since checking whether runtime is processed is enough. If RTA is marked processed, then run time will also be processed.
	WHILE(
	@nextRunTime = 0 AND @l_counter < 12
	AND EXISTS (SELECT	RT.nextRunTime
				FROM TM_RunTime RT WITH (NOLOCK)
				INNER JOIN TM_PatternAssoc PA WITH (NOLOCK) ON RT.patternId = PA.patternId
				INNER JOIN @BackupTasks S ON PA.subTaskId = S.subTaskId
				WHERE RT.processed = 1)
	)
	BEGIN
		WAITFOR DELAY '00:00:01'
		SELECT	TOP 1 @nextRunTime = dbo.GetUnixTime(NextRunTimes.nextRunTime)
		from
		(
			select RT.nextRunTime
			FROM TM_RunTime RT WITH (NOLOCK)
			INNER JOIN TM_PatternAssoc PA WITH (NOLOCK) ON RT.patternId = PA.patternId
			INNER JOIN TM_PATTERN P WITH (NOLOCK) ON P.patternId = PA.patternId
			INNER JOIN @BackupTasks S ON PA.subTaskId = S.subTaskId
			WHERE RT.processed = 0
			and P.tzId<>1001
			union
			select dbo.ClientLocalToUTCTime( RTA.nextRunTime,2)
			FROM TM_RunTime RT WITH (NOLOCK)
			INNER JOIN TM_PatternAssoc PA WITH (NOLOCK) ON RT.patternId = PA.patternId
			INNER JOIN TM_PATTERN P WITH (NOLOCK) ON P.patternId = PA.patternId
			INNER JOIN @BackupTasks S ON PA.subTaskId = S.subTaskId
			INNER JOIN TM_RunTimeAssoc RTA WITH (NOLOCK) on RTA.runtimeId=RT.runtimeId
			WHERE RTA.processed = 0
			and P.tzId=1001
			and RTA.timezoneNames = @clientTimeZone
			AND RTA.jobStartTime = S.jobStartTime
		) NextRunTimes
		ORDER BY NextRunTimes.nextRunTime
        SET @l_counter = @l_counter + 1
	END
IF OBJECT_ID('tempdb..#TM_GetNextScheduleRunTimeResultTable') IS NOT NULL
BEGIN
	INSERT INTO #TM_GetNextScheduleRunTimeResultTable
	SELECT @nextRunTime
END
ELSE
BEGIN
	SELECT	@nextRunTime
END
RETURN	@nextRunTime;
IF object_id('tempdb.dbo.#Clients_Timezone_StartTime') is NOT NULL
BEGIN
	DROP TABLE #Clients_Timezone_StartTime
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetNextScheduleRunTime')
	delete from GxQscripts where name = 'TM_GetNextScheduleRunTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetNextScheduleRunTime')
	delete from GXDBVersions where aliasname = 'TM_GetNextScheduleRunTime'
GO

insert into GXDBVersions values(2, 'TM_GetNextScheduleRunTime',  '00000000000000000000', 'TM_GetNextScheduleRunTime', '00000000000000000000')
GO

