

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetNextRunTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetNextRunTime.sp,v $ $Id: TM_GetNextRunTime.sp,v 1.1.274.1 2018/03/27 08:07:43 jiechen Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 06/08/2010
-- Description:	Get the next run time for a client .
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_GetNextRunTime <<<'

IF EXISTS (select * from sysobjects where name='TM_GetNextRunTime')
	drop procedure TM_GetNextRunTime
IF EXISTS (select * from GxQscripts where name='TM_GetNextRunTime')
	delete from GxQscripts where name = 'TM_GetNextRunTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetNextRunTime')
	delete from GXDBVersions where aliasname = 'TM_GetNextRunTime'
GO
print '... Creating Procedure: TM_GetNextRunTime'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_GetNextRunTime
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @xmlText XML
AS
BEGIN
SET NOCOUNT ON
	DECLARE @i_clientId INT
	SET @i_clientId = ISNULL(( SELECT ref.value('@clientId',
												  'int')
								 FROM   @xmlText . nodes('TMMsg_GetNextRunTimeReq') R ( ref )
								), 0)
	SET @xmlText = (SELECT TOP 1 nextTime '@nextRunTime'
					FROM TM_RunTime
					WHERE patternId IN (
						SELECT patternId FROM TM_PatternAssoc WHERE subTaskId IN (
							SELECT subTaskId FROM TM_SubTask WHERE taskId IN (
								SELECT taskId FROM TM_AssocEntity
								WHERE clientId = @i_clientId OR clientGroupId IN (
									SELECT clientGroupId FROM APP_clientGroupAssoc WHERE clientId = @i_clientId
									)
								)
							)
						) AND processed = 0 ORDER BY nextTime ASC
					FOR
						XML PATH('TMMsg_GetNextRunTimeResp') )
	SELECT @xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetNextRunTime')
	delete from GxQscripts where name = 'TM_GetNextRunTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetNextRunTime')
	delete from GXDBVersions where aliasname = 'TM_GetNextRunTime'
GO

insert into GXDBVersions values(2, 'TM_GetNextRunTime',  '00010001027400010000', 'TM_GetNextRunTime', '00010001027400010000')
GO

