

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetJobRequestEntities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetJobRequestEntities.sp,v $ $Id: TM_GetJobRequestEntities.sp,v 1.2.192.2 2018/03/20 00:38:41 jiechen Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 05/08/2012
-- Description:	Get all the subclients that started
-- with the same job request .
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_GetJobRequestEntities <<<'

IF EXISTS (select * from sysobjects where name='TM_GetJobRequestEntities')
	drop procedure TM_GetJobRequestEntities
IF EXISTS (select * from GxQscripts where name='TM_GetJobRequestEntities')
	delete from GxQscripts where name = 'TM_GetJobRequestEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetJobRequestEntities')
	delete from GXDBVersions where aliasname = 'TM_GetJobRequestEntities'
GO
print '... Creating Procedure: TM_GetJobRequestEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_GetJobRequestEntities
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @xmlText XML
AS
BEGIN
SET NOCOUNT ON
	DECLARE @i_jobId BIGINT
	DECLARE @o_ErrorCode integer=0
	DECLARE @o_ErrorString NVARCHAR(1024)
	DECLARE @clientId INT = 0
	DECLARE @jobRequestId INT = 0
	DECLARE @subTaskId INT = 0
	SET @i_jobId = ISNULL(( SELECT ref.value('@jobId',
												  'bigint')
								 FROM   @xmlText . nodes('JobManager_GetJobRequestEntitiesReq') R ( ref )
								), 0)
	IF @i_jobId > 0
	BEGIN
		SELECT TOP 1 @clientId=AP.clientId, @jobRequestId=JR.jobRequestId, @subTaskId=JR.subTaskId
		FROM TM_Jobs TJ WITH (NOLOCK)
		INNER JOIN TM_JobRequest JR WITH (NOLOCK) ON JR.jobRequestId=TJ.jobRequestId
		LEFT OUTER JOIN JMBkpJobInfo JI WITH (NOLOCK) ON JI.jobId=TJ.jobId
		LEFT OUTER JOIN JMBkpStats JS WITH (NOLOCK) ON JS.jobId=TJ.jobId
		INNER JOIN APP_Application AP WITH (NOLOCK) ON AP.id=JI.applicationId OR AP.id=JS.appId
		WHERE TJ.jobId = @i_jobId
		SET @xmlText = (
			SELECT
			@jobRequestId '@jobRequestId',
(SELECT DISTINCT 7 '@_type_', AP.clientId '@clientId', AP.appTypeId '@applicationId',
			AP.instance '@instanceId', AP.backupSet '@backupsetId', AP.id '@subclientId'
			FROM TM_Jobs TJ WITH (NOLOCK)
			INNER JOIN TM_JobRequest JR WITH (NOLOCK) ON JR.jobRequestId=TJ.jobRequestId
			LEFT OUTER JOIN JMBkpJobInfo JI WITH (NOLOCK) ON JI.jobId=TJ.jobId
			LEFT OUTER JOIN JMBkpStats JS WITH (NOLOCK) ON JS.jobId=TJ.jobId
			INNER JOIN APP_Application AP WITH (NOLOCK) ON AP.id=JI.applicationId OR AP.id=JS.appId
			WHERE AP.clientId=@clientId AND JR.jobRequestId=@jobRequestId
			FOR XML PATH('subclients'), TYPE),
( SELECT @subTaskId '@subtaskId', 68 '@_type_'
				FOR XML PATH('subTaskEntity'), TYPE)
			FOR XML PATH('JobManager_GetJobRequestEntitiesResp'), TYPE
		)
		IF @clientId = 0
			SET @o_ErrorString = 'JobId [' + CAST(@i_jobId AS VARCHAR(10)) + '] did not return any results'
	END
	ELSE
	BEGIN
		SET @o_ErrorCode = -1
		SET @o_ErrorString = 'Missing JobId in request'
	END
	IF @xmlText IS NULL
	BEGIN
		SET @o_ErrorCode = -1
		SET @xmlText = ( SELECT
				( SELECT @o_ErrorCode '@errorCode', @o_ErrorString '@errorString'
					FOR XML PATH('error'), TYPE
				)
		FOR XML PATH(''),
		ROOT('TMMsg_GenericResp'))
	END
	SELECT @xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetJobRequestEntities')
	delete from GxQscripts where name = 'TM_GetJobRequestEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetJobRequestEntities')
	delete from GXDBVersions where aliasname = 'TM_GetJobRequestEntities'
GO

insert into GXDBVersions values(2, 'TM_GetJobRequestEntities',  '00010002019200020000', 'TM_GetJobRequestEntities', '00010002019200020000')
GO

