

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetJobCompletedPatterns.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetJobCompletedPatterns.sp,v $ $Id: TM_GetJobCompletedPatterns.sp,v 1.27.2.80.16.1 2021/03/03 03:13:04 mnatarajan Exp $";
---- ============================================================================
---- Author:		Sergio Bonilla
---- Create date:	05/10/2014
---- Description:	Get the information to start a Job Completed schedule.
---- ============================================================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_GetJobCompletedPatterns')
BEGIN
	print '>>> Drop Stored Procedure: TM_GetJobCompletedPatterns <<<'
	drop procedure TM_GetJobCompletedPatterns
END
IF EXISTS (select * from GxQscripts where name='TM_GetJobCompletedPatterns')
	delete from GxQscripts where name = 'TM_GetJobCompletedPatterns'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetJobCompletedPatterns')
	delete from GXDBVersions where aliasname = 'TM_GetJobCompletedPatterns'
GO
print '... Creating Procedure: TM_GetJobCompletedPatterns'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_GetJobCompletedPatterns
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @oErrorCode integer OUTPUT,
  @oErrorString nvarchar(MAX) OUTPUT
AS
SET NOCOUNT ON
BEGIN
	DECLARE @nowTime DATETIME = GETDATE()
	DECLARE @nowUtcTime DATETIME = GETUTCDATE()
	DECLARE @nowUtcUnix INT = datediff(second, '01/01/1970', @nowUtcTime)
	DECLARE @runTimeId INT = 0
	DECLARE @nowTimeUnix INT = datediff(second, '01/01/1970', @nowTime)
	DECLARE @timeZoneName NVARCHAR(MAX) = ISNULL((SELECT dbo.GetClientTimeZone(2)), '')
	DECLARE @startSyntheticFullAfterOSC INT = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='startSyntheticFullAfterOSC'), 1)
	DECLARE @minutesToCheckForAutoSyntheticFulls INT = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='minutesToCheckForAutoSyntheticFulls'), 30)
	DECLARE @runTimeTable table (runTimeId INT, patternId INT)
DECLARE @logChanges INT = ISNULL((SELECT CAST(value AS NVARCHAR(1024)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='logAfterJobCompletesSchedulesInfo'), 1)
	DECLARE @disableVMRevertReplication INT = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='disableVMRevertReplication'), 0)
	-- By default its not supported for now. We will enable once its supported from IDA side also.
	DECLARE @supportLiveSyncForSQLDump INT = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='supportLiveSyncForDumpSQL'), 0)
	DECLARE @lastCSFailoverTime INT = 0
	-- No need to use logShipping subclient. We can block replication for failover live sync schedule till new backup happens since we dont know whether reconfiguration ran and finding updated second instance happened or not.
	DECLARE @LIVESYNC_COMPLETE INT = 1
	DECLARE @LIVESYNC_PENDING INT = 2
	DECLARE @LIVESYNC_RUNNING INT = 3
	DECLARE @LIVESYNC_PAUSED INT = 4
	DECLARE @LIVESYNC_FAILED INT = 5
	DECLARE @LIVESYNC_DISABLED INT = 6
	DECLARE @LIVESYNC_ENABLED INT = 7
	DECLARE @LIVESYNC_VALIDATION_FAILED INT = 8
	DECLARE @LIVESYNC_JOB_QUEUED INT = 9
	DECLARE @LIVESYNC_REVERT_FAILED INT = 10
	DECLARE @LIVESYNC_STARTING INT = 11
	SELECT @lastCSFailoverTime = value FROM GxGlobalParam WITH (NOLOCK)
WHERE name='nCvFailoverTime'
	AND Modified=0
	SET @oErrorCode = 0
	SET @oErrorString = ''
	IF object_id('tempdb.dbo.#completedPattern_initInfoTable') is not null
		DROP TABLE #completedPattern_initInfoTable
	CREATE TABLE #completedPattern_initInfoTable
				(stId INT, tkId INT, patId INT, cgId INT, clId INT, apId INT, instId INT, bsId INT, scId INT, destClientId INT, destAppTypeId INT DEFAULT 0, destInstanceId INT DEFAULT 0, opType INT,
copyPrecedenceApplicable INT, copyPrecedence INT, freq_type INT, tkDisabled INT, status INT, syncRestore INT, baselineJobId INT, restoreSource NVARCHAR(1024) DEFAULT '',freq_interval INT DEFAULT 0)
	CREATE CLUSTERED INDEX completedPattern_initInfoTable_tkId_repGuid_sourceGuid_Index1 ON #completedPattern_initInfoTable ([tkId], [clId], [destClientId])
	IF object_id('tempdb.dbo.#completedPattern_IdaInfoTable') is not null
		DROP TABLE #completedPattern_IdaInfoTable
	CREATE TABLE #completedPattern_IdaInfoTable
				(stId INT, tkId INT, patId INT, cgId INT, clId INT, apId INT, instId INT, bsId INT, scId INT, destClientId INT, destAppTypeId INT DEFAULT 0, destInstanceId INT DEFAULT 0, lastSuccessBkupTime INT, opType INT,
jId BIGINT, copyPrecedenceApplicable INT, copyPrecedence INT, freq_type INT, tkDisabled INT, lastSyncedBkpJob INT DEFAULT 0, status INT DEFAULT 0, bkpJobsToSync VARCHAR(1024) DEFAULT '',
replicationId INT DEFAULT 0, lastScheduleRunTime INT DEFAULT 0, flags INT DEFAULT 0, lastRestoreTime INT DEFAULT 0, syncRestore INT, baselineJobId INT, restoreSource NVARCHAR(1024) DEFAULT '',
bkpLevel INT DEFAULT 0,freq_interval INT DEFAULT 0, isSubclientIdComputed INT DEFAULT 0, restoreDestination NVARCHAR(1024) DEFAULT '', lastBackupForReplication INT DEFAULT 0, isDumpSweepSc INT DEFAULT 0)
	CREATE CLUSTERED INDEX completedPattern_IdaInfoTable_tkId_repGuid_sourceGuid_replicationId_Index1 ON #completedPattern_IdaInfoTable ([tkId], [replicationId], [clId], [destClientId])
	IF object_id('tempdb.dbo.#completedPattern_runTimeInfoTable') is not null
		DROP TABLE #completedPattern_runTimeInfoTable
	CREATE TABLE #completedPattern_runTimeInfoTable (stId INT, taskId INT, patId INT, cgId INT DEFAULT 0, clId INT DEFAULT 0, apId INT DEFAULT 0, instId INT DEFAULT 0, bsId INT DEFAULT 0, scId INT DEFAULT 0,
				lastSuccessBkupTime INT DEFAULT 0, opType INT, freq_type INT, tkDisabled INT DEFAULT 0, status INT DEFAULT 0, copyPrecedenceApplicable INT DEFAULT 0, copyPrecedence INT DEFAULT 0,freq_interval INT DEFAULT 0)
	CREATE CLUSTERED INDEX completedPattern_runTimeInfoTable_taskId_stId_Index1 ON #completedPattern_runTimeInfoTable ([taskId], [stId])
	IF object_id('tempdb.dbo.#completedPattern_InfoTable') is not null
		DROP TABLE #completedPattern_InfoTable
	CREATE TABLE #completedPattern_InfoTable
				(stId INT, tkId INT, patId INT, nextTime INT, opType INT, freq_type INT, optionId BIGINT, value NVARCHAR(MAX))
	CREATE CLUSTERED INDEX completedPattern_InfoTable_tkId_Index1 ON #completedPattern_InfoTable ([tkId])
	IF object_id('tempdb.dbo.#auxCopyTable') is not null
		DROP TABLE #auxCopyTable
	CREATE TABLE #auxCopyTable
				(subTaskId INT, subclientId INT, maxCopiedTime INT, maxJobEndTime INT)
	CREATE CLUSTERED INDEX auxCopyTable_subclientId_Index1 ON #auxCopyTable ([subclientId])
	IF object_id('tempdb.dbo.#output_IdaInfoTable') is not null
		DROP TABLE #output_IdaInfoTable
	CREATE TABLE #output_IdaInfoTable
				(replicationId INT, tkId INT, restoreSource NVARCHAR(1024), statusIn INT, lastBackupTimeIn INT, bkpJobsToSyncIn VARCHAR(1024), action NVARCHAR(100), statusOut INT, lastBackupTimeOut INT, bkpJobsToSyncOut VARCHAR(1024), time DATETIME, isDumpSweepSc INT)
	CREATE CLUSTERED INDEX output_IdaInfoTable_replicationId_Index1 ON #output_IdaInfoTable ([replicationId])
--
	INSERT INTO #completedPattern_runTimeInfoTable
	(stId, taskId, patId, cgId, clId, apId, instId, bsId, scId, opType, freq_type, tkDisabled,freq_interval)
	SELECT ST.subTaskId, ST.taskId, PT.patternId, AE.clientGroupId, AE.clientId, AE.apptypeId, AE.instanceId, AE.backupsetId, AE.subclientId, ST.operationType, PT.freq_type, T.disabled,
CASE WHEN PT.freq_type = 4096 THEN PT.freq_interval ELSE 0 END
	FROM TM_SubTask ST WITH (NOLOCK)
	JOIN TM_PatternAssoc PA WITH (NOLOCK) ON PA.subTaskId = ST.subTaskId
	JOIN TM_Pattern PT WITH (NOLOCK) ON PT.patternId = PA.patternId
	JOIN TM_AssocEntity AE WITH (NOLOCK) ON AE.taskId = ST.taskId
	JOIN TM_Task T WITH (NOLOCK) ON T.taskId = ST.taskId
	WHERE T.deleted = 0
	--AND T.disabled = 0
--AND PT.freq_type = 4096
AND AE.apptypeId != 106
	-- We need to process replication schedules of all frequency types. Daily, weely etc and trigger replication jobs if needed for "After each backup job completes" only
AND ST.operationType =   1007
	UNION
	SELECT ST.subTaskId, ST.taskId, PT.patternId, AE.clientGroupId, AE.clientId, AE.apptypeId, AE.instanceId, AE.backupsetId, AE.subclientId, ST.operationType, PT.freq_type, T.disabled, 0
	FROM TM_SubTask ST WITH (NOLOCK)
	JOIN TM_PatternAssoc PA WITH (NOLOCK) ON PA.subTaskId = ST.subTaskId
	JOIN TM_Pattern PT WITH (NOLOCK) ON PT.patternId = PA.patternId
	JOIN TM_AssocEntity AE WITH (NOLOCK) ON AE.taskId = ST.taskId
	JOIN TM_Task T WITH (NOLOCK) ON T.taskId = ST.taskId
	WHERE @startSyntheticFullAfterOSC = 1
	AND T.deleted = 0
	AND T.disabled = 0
AND PT.freq_type = 1024
--
	IF EXISTS(SELECT * FROM #completedPattern_runTimeInfoTable)
	BEGIN
IF @startSyntheticFullAfterOSC = 1 AND EXISTS (SELECT 1 FROM #completedPattern_runTimeInfoTable WHERE freq_type = 1024)
		BEGIN
			--GET ENTRIES WHICH HAVE OPTION
			INSERT INTO #completedPattern_InfoTable
			SELECT stId, taskId, patId, ISNULL(MAX(R.nextTime), 0), opType, freq_type, SO.optionId, SO.value
			FROM #completedPattern_runTimeInfoTable RT
JOIN TM_SubTaskOptions SO (NOLOCK) ON SO.subTaskId = RT.stId AND SO.optionId = 1013376701 AND value = '1'
			LEFT OUTER JOIN TM_RunTime R (NOLOCK) ON R.patternId = RT.patId
WHERE RT.freq_type = 1024
			GROUP BY stId, taskId, patId, opType, freq_type, SO.optionId, SO.value
--
			DELETE #completedPattern_runTimeInfoTable
WHERE freq_type = 1024
--
			--ADD ENTRIES FOR WHICH INTERVAL HAS PASSED
			INSERT #completedPattern_runTimeInfoTable
			(stId, taskId, patId, lastSuccessBkupTime, opType, freq_type)
SELECT T.stId, T.tkId, T.patId, T.nextTime, T.opType, 1024 FROM
			(
				SELECT DISTINCT stId, tkId, patId, nextTime, opType
			FROM #completedPattern_InfoTable I
JOIN TM_SubTaskOptions D (NOLOCK) ON D.subTaskId = I.stId AND D.optionId = 1765126965 AND ISNUMERIC(D.value) = 1 AND CAST(D.value AS INT) > 0
JOIN TM_SubTaskOptions BL (NOLOCK) ON BL.subTaskId = D.subTaskId AND BL.optionId = 458405394 AND BL.value = 4	--_BACKUPOPTION_BACKUP_LEVEL, _BACKUP_LEVEL_SYNTHETIC_FULL		ONLY ENTRIES FOR WICH BACKUP LEVEL IS SYNTHETIC FULL
				UNION
				SELECT DISTINCT stId, tkId, patId, nextTime, opType
				FROM #completedPattern_InfoTable I
JOIN TM_SubTaskOptions D (NOLOCK) ON D.subTaskId = I.stId AND D.optionId = 328367274 AND ISNUMERIC(D.value) = 1 AND CAST(D.value AS INT) > 0		--  DATABKPOTION_ENABLE_RUN_FULL_CONSOLIDATION_BACKUP		SUBTASK FOR WHICH FULL CONSOLIDATION OPTION IS SET IN SCHEDULER
JOIN TM_SubTaskOptions BL (NOLOCK) ON BL.subTaskId = D.subTaskId AND BL.optionId = 458405394 AND BL.value = 4	--_BACKUPOPTION_BACKUP_LEVEL, _BACKUP_LEVEL_SYNTHETIC_FULL		ONLY ENTRIES FOR WICH BACKUP LEVEL IS SYNTHETIC FULL
				UNION
				SELECT DISTINCT stId, tkId, patId, nextTime, opType
				FROM #completedPattern_InfoTable I
JOIN TM_SubTaskOptions D (NOLOCK) ON D.subTaskId = I.stId AND D.optionId = 1778633837 AND ISNUMERIC(D.value) = 1 AND CAST(D.value AS INT) > 0		--  DATABKPOTION_ENABLE_RUN_FULL_CONSOLIDATION_BACKUP		SUBTASK FOR WHICH FULL CONSOLIDATION OPTION IS SET IN SCHEDULER
JOIN TM_SubTaskOptions BL (NOLOCK) ON BL.subTaskId = D.subTaskId AND BL.optionId = 458405394 AND BL.value = 4	--_BACKUPOPTION_BACKUP_LEVEL, _BACKUP_LEVEL_SYNTHETIC_FULL		ONLY ENTRIES FOR WICH BACKUP LEVEL IS SYNTHETIC FULL
			) T
			WHERE (T.nextTime+(@minutesToCheckForAutoSyntheticFulls *60) < @nowTimeUnix)
		END
--
IF EXISTS (SELECT 1 FROM #completedPattern_runTimeInfoTable WHERE opType = 1007 )
		BEGIN
			INSERT INTO #completedPattern_initInfoTable
			(stId, tkId, patId, cgId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, opType, copyPrecedenceApplicable, copyPrecedence, freq_type, tkDisabled,
				syncRestore, baselineJobId, restoreSource,freq_interval)
			SELECT stId, taskId, patId, cgId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, opType, copyPrecedenceApplicable, copyPrecedence, freq_type, tkDisabled,
				syncRestore, baselineJobId, ISNULL(restoreSource, ''),freq_interval
			FROM
			(
				SELECT RI.stId, RI.taskId, RI.patId, RI.cgId, RI.clId, RI.apId, RI.instId, RI.bsId, RI.scId, CASE WHEN ds.value('destinationInstance[1]/@clientId', 'INT') IS NULL THEN ds.value('destClient[1]/@clientId', 'INT') ELSE ds.value('destinationInstance[1]/@clientId', 'INT') END destClientId,
				ISNULL(ds.value('destinationInstance[1]/@applicationId', 'INT'), 0) destAppTypeId, ISNULL(ds.value('destinationInstance[1]/@instanceId', 'INT'), 0) destInstanceId, RI.opType,
				ro.value('browseOption[1]/mediaOption[1]/copyPrecedence[1]/@copyPrecedenceApplicable', 'INT') copyPrecedenceApplicable, ro.value('browseOption[1]/mediaOption[1]/copyPrecedence[1]/@copyPrecedence', 'INT') copyPrecedence,
				ro.value('commonOptions[1]/@syncRestore', 'INT') syncRestore, ro.value('commonOptions[1]/@baselineJobId', 'INT') baselineJobId, RI.freq_type, RI.tkDisabled,
CASE WHEN RI.apId = 81 THEN sq.value('@val','NVARCHAR(MAX)')
WHEN RI.apId = 37 OR RI.apId = 62 THEN '' -- For db2 and db2 unix, replication is at backupset level. So no need to have restoreSource.
				ELSE fs.value('@val','NVARCHAR(MAX)') END restoreSource, RI.freq_interval
				FROM #completedPattern_runTimeInfoTable RI
				JOIN TM_SubTaskXMLOptions SO WITH (NOLOCK) ON SO.subTaskId = RI.stId
				CROSS APPLY SO.xmlValue.nodes('TMMsg_JobOption/restoreOptions') R(ro)
				CROSS APPLY	ro.nodes('./destination') D(ds)
				OUTER APPLY ro.nodes('./sqlServerRstOption/restoreSource') Q(sq)
				OUTER APPLY ro.nodes('./fileOption/sourceItem') F(fs)
WHERE  RI.apId <> 106
			) T
			GROUP BY stId, taskId, patId, cgId, clId, apId, instId, bsId, scId, opType, copyPrecedenceApplicable, copyPrecedence, freq_type, tkDisabled,
					destClientId, destAppTypeId, destInstanceId, syncRestore, baselineJobId, restoreSource,freq_interval
			INSERT INTO #completedPattern_IdaInfoTable
			(stId, tkId, patId, cgId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, lastSuccessBkupTime, opType, jId, copyPrecedenceApplicable,
				copyPrecedence, freq_type, tkDisabled, syncRestore, baselineJobId, restoreSource,freq_interval)
			SELECT stId, tkId, patId, cgId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, MAX(lastSuccessBkupTime) lastSuccessBkupTime, opType, MAX(jobId) jobId, copyPrecedenceApplicable,
				copyPrecedence, freq_type, tkDisabled, syncRestore, baselineJobId, restoreSource, freq_interval
			FROM
			(
				SELECT RI.stId, RI.tkId, RI.patId, RI.cgId, RI.clId, RI.apId, RI.instId, RI.bsId, RI.scId, RI.destClientId, RI.destAppTypeId, RI.destInstanceId, RI.opType, JB.servEndDate lastSuccessBkupTime, JB.jobId,
				RI.copyPrecedenceApplicable, RI.copyPrecedence, RI.syncRestore, RI.baselineJobId, RI.freq_type, RI.tkDisabled, RI.restoreSource, RI.freq_interval
				FROM #completedPattern_initInfoTable RI
				JOIN APP_Application APP (NOLOCK) ON APP.backupSet = RI.bsId
				AND dbo.IsSubClientValid(APP.appTypeId, APP.subclientStatus, 0) = 1 AND ( APP.subclientStatus & (4|2)  =0) -- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED)
				LEFT OUTER JOIN JMBkpStats JB WITH (NOLOCK) ON JB.appId = APP.id	--ADD ENTRY EVEN IF JOB FAIL SO THAT ENTRY IS THERE FOR EXISTING SCHEDULE CHECK
					AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
					AND JB.opType in (4 /*BACKUP*/,  59 /*SNAPBACKUP*/, 18 /*BACKUP3RD*/) -- No need for synthfull to identify last backup time.
					AND JB.jobId >= ISNULL(baselineJobId, 0)
					AND JB.servEndDate <= (@nowUtcUnix - ISNULL(RI.freq_interval*60,0) ) --In case replication job is to be launched in a delayed fashion then we pick up last backup time before the delay is met.
				LEFT OUTER JOIN App_SubclientProp WITH (NOLOCK) ON App_SubclientProp.componentNameID = APP.id AND App_SubclientProp.attrName='Enable Snap Backups' --  CV_PROP_ENABLE_SNAP_BACKUPS_NAME
					AND App_SubClientProp.cs_attrName = CHECKSUM(N'Enable Snap Backups')
					AND App_SubclientProp.attrVal = '1'
WHERE  RI.apId NOT IN (106, 81 ,135 ) OR
( RI.apId = 135 AND App_SubclientProp.attrVal IS NOT NULL)
			) T
			GROUP BY stId, tkId, patId, cgId, clId, apId, instId, bsId, scId, opType, copyPrecedenceApplicable, copyPrecedence, freq_type, tkDisabled,
					destClientId, destAppTypeId, destInstanceId, syncRestore, baselineJobId, restoreSource,freq_interval
			-- FOR SQL identify based on latest successful backup. For
			IF @supportLiveSyncForSQLDump>0
			BEGIN
				INSERT INTO #completedPattern_IdaInfoTable
					(stId, tkId, patId, cgId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, lastSuccessBkupTime, opType, jId, copyPrecedenceApplicable,
						copyPrecedence, freq_type, tkDisabled, syncRestore, baselineJobId, restoreSource,freq_interval,isDumpSweepSc)
				SELECT RI.stId, RI.tkId, RI.patId, RI.cgId, RI.clId, RI.apId, RI.instId, RI.bsId, SDI.appId scId, RI.destClientId, RI.destAppTypeId, RI.destInstanceId, SDI.LastOkBackupTime lastSuccessBkupTime, RI.opType, 0,
				RI.copyPrecedenceApplicable, RI.copyPrecedence, RI.freq_type, RI.tkDisabled, RI.syncRestore, RI.baselineJobId, RI.restoreSource, RI.freq_interval, 1
				FROM #completedPattern_initInfoTable RI
						JOIN APP_Application APP (NOLOCK) ON APP.backupSet = RI.bsId
						AND dbo.IsSubClientValid(APP.appTypeId, APP.subclientStatus, 0) = 1 AND ( APP.subclientStatus & (4|2) =0)	-- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED)
						JOIN SqlDatabaseInfo SDI (NOLOCK) ON RI.instId = SDI.instanceId AND SDI.appId = APP.id
						JOIN SqlDBBackupInfo on SDI.LastBackupSetId = SqlDBBackupInfo.id
						AND SDI.LastOkBackupTime != SqlDBBackupInfo.backup_finish_Date -- To identify databases backed up by dump sweep schedules, lastOkbackuptime for DB should vary from backup finish data for corresponding LastBackupSetId from SqlDatabaseInfo
						JOIN sqlNames SN (NOLOCK) ON SN.id = SDI.databaseId
						JOIN sqlNames2 SN2 (NOLOCK) ON SN2.id = SN.sqlId AND RI.restoreSource = SN2.name
WHERE RI.apId =  81
			END
			-- if we dont have TL backups for restoreSource (SQL IDA) then check whether we have full backup and if so, fill that in temp table.
			IF EXISTS(SELECT 1 FROM #completedPattern_initInfoTable RI
				LEFT JOIN #completedPattern_IdaInfoTable IdaTbl ON RI.stId = IdaTbl.stId AND RI.instId = idaTbl.instId AND RI.restoreSource = idaTbl.restoreSource
				WHERE IdaTbl.stId IS NULL
AND RI.apId =  81 )
			BEGIN
				INSERT INTO #completedPattern_IdaInfoTable
				(stId, tkId, patId, cgId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, lastSuccessBkupTime, opType, jId, copyPrecedenceApplicable,
					copyPrecedence, freq_type, tkDisabled, syncRestore, baselineJobId, restoreSource,freq_interval)
				SELECT stId, tkId, patId, cgId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, lastSuccessBkupTime, opType, jobId, copyPrecedenceApplicable,
					copyPrecedence, freq_type, tkDisabled, syncRestore, baselineJobId, restoreSource, freq_interval FROM
				(
				SELECT RI.stId, RI.tkId, RI.patId, RI.cgId, RI.clId, RI.apId, RI.instId, RI.bsId, SBI.appId scId, RI.destClientId, RI.destAppTypeId, RI.destInstanceId, RI.opType, NULL lastSuccessBkupTime, SBI.jobId,
					RI.copyPrecedenceApplicable, RI.copyPrecedence, RI.syncRestore, RI.baselineJobId, RI.freq_type, RI.tkDisabled, RI.restoreSource, RI.freq_interval,
					ROW_NUMBER() OVER (PARTITION BY RI.stId, RI.instId, RI.restoreSource ORDER BY SBI.backup_finish_date DESC) AS rowId
					FROM #completedPattern_initInfoTable RI
					LEFT JOIN #completedPattern_IdaInfoTable IdaTbl ON RI.stId = IdaTbl.stId AND RI.instId = idaTbl.instId AND RI.restoreSource = idaTbl.restoreSource
							JOIN APP_Application APP (NOLOCK) ON APP.backupSet = RI.bsId AND dbo.IsSubClientValid(APP.appTypeId, APP.subclientStatus, 0) = 1 AND ( APP.subclientStatus & (4|2) =0)	-- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED)
							JOIN sqlDbBackupInfo SBI (NOLOCK) ON RI.instId = SBI.instanceId AND SBI.appId = APP.id
							JOIN sqlNames SN (NOLOCK) ON SN.id = SBI.sqlNameId
							JOIN sqlNames2 SN2 (NOLOCK) ON SN2.id = SN.sqlId AND RI.restoreSource = SN2.name
					WHERE IdaTbl.stId IS NULL AND EXISTS(SELECT 1 FROM JMBkpStats JB WITH (NOLOCK) WHERE JB.jobId = SBI.jobId
						AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
						AND JB.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/) -- No need for synthfull to identify last backup time.
						AND JB.jobId >= ISNULL(RI.baselineJobId, 0)
						AND JB.BKpLevel NOT IN (1,4) --- Dont consider full or differential backups.
						AND JB.servEndDate <= (@nowUtcUnix - ISNULL(RI.freq_interval*60,0) ) --In case replication job is to be launched in a delayed fashion then we pick up last backup time before the delay is met.
					)
AND RI.apId =  81
				) T
				WHERE T.rowId = 1
			END
			-- if we dont have TL backups for restoreSource (SQL IDA) then check whether we have full backup and if so, fill that in temp table.
			IF EXISTS(SELECT 1 FROM #completedPattern_initInfoTable RI
				LEFT JOIN #completedPattern_IdaInfoTable IdaTbl ON RI.stId = IdaTbl.stId AND RI.instId = idaTbl.instId AND RI.restoreSource = idaTbl.restoreSource
				WHERE IdaTbl.stId IS NULL
AND RI.apId =  81 )
			BEGIN
				-- For replications where there are no TL backups, identify last full or differential job
				INSERT INTO #completedPattern_IdaInfoTable
				(stId, tkId, patId, cgId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, lastSuccessBkupTime, opType, jId, copyPrecedenceApplicable,
					copyPrecedence, freq_type, tkDisabled, syncRestore, baselineJobId, restoreSource,freq_interval)
				SELECT stId, tkId, patId, cgId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, lastSuccessBkupTime, opType, jobId, copyPrecedenceApplicable,
					copyPrecedence, freq_type, tkDisabled, syncRestore, baselineJobId, restoreSource, freq_interval FROM
				(
				SELECT RI.stId, RI.tkId, RI.patId, RI.cgId, RI.clId, RI.apId, RI.instId, RI.bsId, SBI.appId scId, RI.destClientId, RI.destAppTypeId, RI.destInstanceId, RI.opType, NULL lastSuccessBkupTime, SBI.jobId,
					RI.copyPrecedenceApplicable, RI.copyPrecedence, RI.syncRestore, RI.baselineJobId, RI.freq_type, RI.tkDisabled, RI.restoreSource, RI.freq_interval,
					ROW_NUMBER() OVER (PARTITION BY RI.stId, RI.instId, RI.restoreSource ORDER BY SBI.backup_finish_date DESC) AS rowId
					FROM #completedPattern_initInfoTable RI
					LEFT JOIN #completedPattern_IdaInfoTable IdaTbl ON RI.stId = IdaTbl.stId AND RI.instId = idaTbl.instId AND RI.restoreSource = idaTbl.restoreSource
							JOIN APP_Application APP (NOLOCK) ON APP.backupSet = RI.bsId AND dbo.IsSubClientValid(APP.appTypeId, APP.subclientStatus, 0) = 1 AND ( APP.subclientStatus & (4|2) =0)	-- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED)
							JOIN sqlDbBackupInfo SBI (NOLOCK) ON RI.instId = SBI.instanceId AND SBI.appId = APP.id
							JOIN sqlNames SN (NOLOCK) ON SN.id = SBI.sqlNameId
							JOIN sqlNames2 SN2 (NOLOCK) ON SN2.id = SN.sqlId AND RI.restoreSource = SN2.name
					WHERE IdaTbl.stId IS NULL AND EXISTS(SELECT 1 FROM JMBkpStats JB WITH (NOLOCK) WHERE JB.jobId = SBI.jobId
						AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
						AND JB.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/) -- No need for synthfull to identify last backup time.
						AND JB.jobId >= ISNULL(RI.baselineJobId, 0)
						AND JB.BKpLevel IN (1,4) --- Consider full or differential backups for replications which dont have TL backups yet.
						AND JB.servEndDate <= (@nowUtcUnix - ISNULL(RI.freq_interval*60,0) ) --In case replication job is to be launched in a delayed fashion then we pick up last backup time before the delay is met.
					)
AND RI.apId =  81
				) T
				WHERE T.rowId = 1
			END
			-- Update restore destination depending on the index of source.
			-- Adding distinct below since on customer setup where they have configured live sync schedules for multiple paths
			-- source and destinations from XML list are not read correctly in order.
			-- So existing replication is deleted and new one is created wiht incorrect source and destination pair.
			;WITH FSSubtasks (subTaskId)
			AS
			(
				SELECT DISTINCT stID
				FROM #completedPattern_IdaInfoTable RI
				INNER JOIN App_AppTypeGroupAssoc ON RI.apId = App_AppTypeGroupAssoc.appTypeid AND App_AppTypeGroupAssoc.typeOfGroup = 0
				INNER JOIN App_AppTypeGroup ON App_AppTypeGroup.typeOfGroup = 0 AND
				App_AppTypeGroup.groupName='APPGRP_FileSystemIDA'
				AND App_AppTypeGroupAssoc.appGroupId = App_AppTypeGroup.appTypeGroupId
			),
			SourceItems (subtaskId,RestoreSource , SourceIndex) AS
			(
			SELECT FSSubtasks.subTaskId, SO.value as RestoreSource, ROW_NUMBER() OVER (PARTITION BY FSSubtasks.subTaskId ORDER BY SO.id ) as SourceIndex
				FROM FSSubtasks JOIN TM_SubTaskOptions SO WITH (NOLOCK) ON SO.subTaskId = FSSubtasks.subTaskId
				AND SO.optionId=150001
			),
			DestItems (subtaskId,DestPath , SourceIndex) AS
			(
				SELECT FSSubtasks.subTaskId, SO.value as DestPAth, ROW_NUMBER() OVER (PARTITION BY FSSubtasks.subTaskId ORDER BY SO.id ) as SourceIndex
				FROM FSSubtasks JOIN TM_SubTaskOptions SO WITH (NOLOCK) ON SO.subTaskId = FSSubtasks.subTaskId
				AND SO.optionId=150002
			)
			UPDATE RI
			SET restoreDestination = DestItems.DestPAth
			FROM #completedPattern_IdaInfoTable RI
			INNER JOIN SourceItems ON
			RI.StId = SourceItems.subTaskID AND RI.restoreSource = SourceItems.RestoreSource
			INNER JOIN DestItems ON DestItems.subTaskId = SourceItems.subTaskID AND SourceItems.SourceIndex = DestItems.SourceIndex
			--REMOVE ENTRIES FOR WHICH BASE JOB HAS NOT COMPLETED
			--DELETE #completedPattern_IdaInfoTable
			--WHERE baselineJobId IS NOT NULL AND baselineJobId > 0 AND baselineJobId > jId
			--REMOVE ENTRIES FROM TEMP TABLE THEY WILL GET REPOPULATED BELOW
			DELETE #completedPattern_runTimeInfoTable
WHERE opType = 1007
			--CLEAR LAST BACKUP TIME WHEN COPY PRECEDENCE IS SET TO AVOID STARTING WHEN BACKUP HAS RUN BUT NOTHING HAS BEEN COPIED
			UPDATE #completedPattern_IdaInfoTable
			SET lastSuccessBkupTime = 0
			WHERE copyPrecedenceApplicable = 1
			-- Computed above during insertion into #completedPattern_IdaInfoTable table.
			/*
			UPDATE #completedPattern_IdaInfoTable
				SET scId = T.appId,
                bkpLevel = T.Level,
				isSubclientIdComputed = 1
				FROM
				(
					SELECT APP.id appId, J.name, J.tkId taskId, ISNULL(BS.bkpLevel,BJ.bkpLevel) level, J.instId instIdInner
					FROM
					(
						SELECT RI.instId, SN2.name, RI.tkId, MAX(SBI.jobId) mJobId
						FROM sqlDbBackupInfo SBI (NOLOCK)
						JOIN sqlNames SN (NOLOCK) ON SN.id = SBI.sqlNameId
						JOIN sqlNames2 SN2 (NOLOCK) ON SN2.id = SN.sqlId
						JOIN #completedPattern_IdaInfoTable RI ON RI.restoreSource = SN2.name AND RI.instId = SBI.instanceId
						GROUP BY RI.instId, RI.tkId, SN2.name
					) J
LEFT JOIN JMBkpStats BS (NOLOCK) ON BS.jobId = J.mJobId AND BS.commcellId = 2
LEFT JOIN JMBkpJobInfo BJ (NOLOCK) ON BJ.jobId = J.mJobId AND BJ.commcellId = 2
					LEFT JOIN APP_Application APP (NOLOCK) ON (APP.id = BS.appId OR APP.id = BJ.applicationId) AND dbo.IsSubClientValid(APP.appTypeId, APP.subclientStatus, 0) = 1 AND ( APP.subclientStatus & (4|2) =0)  -- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED)
					-- Removed commcellID check to handle migrated subclients.
					WHERE APP.id IS NOT NULL AND APP.id>0
				) T
				WHERE T.name = restoreSource
				AND T.taskId = tkId
				AND T.instIdInner = instId
AND apId = 81
				*/
			UPDATE #completedPattern_IdaInfoTable
				SET scId = ISNULL(
									(
										SELECT MAX(T.appId)
										FROM
										(
											SELECT appId FROM JMBkpStats JS WITH (NOLOCK)
											JOIN APP_Application APP (NOLOCK) ON APP.id = JS.appId AND dbo.IsSubClientValid(APP.appTypeId, APP.subclientStatus, 0) = 1 AND ( APP.subclientStatus & (4|2) =0) -- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED)
AND APP.origCCId=2 AND JS.commcellId = 2
											WHERE JS.jobId = baselineJobId
											UNION
											SELECT appId FROM JMBkpStats JS WITH (NOLOCK)
											JOIN APP_Application APP (NOLOCK) ON APP.id = JS.appId AND dbo.IsSubClientValid(APP.appTypeId, APP.subclientStatus, 0) = 1 AND ( APP.subclientStatus & (4|2) =0) -- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED)
AND APP.origCCId=2 AND JS.commcellId = 2
											WHERE JS.jobId = jId
										) T
									), 0
							),
					isSubclientIdComputed = 1
			--ORACLE AGENTS SCHEDULES ARE ALWAYS CREATED AT BACKUPSET LEVEL AND SUBCLIENT IS -1. REPLICATION CAN START ON BACKUP FOR ANY OF SUBCLIENTS ON BACKUPSET
			WHERE ISNULL(scId, 0) <= 0
AND apId <> 81
			-- In case baselineJob is still running then subclient may not be computed from above code. So below code to from jobinof table also.
			UPDATE #completedPattern_IdaInfoTable
				SET scId = JMBkpJobInfo.applicationId ,
				isSubclientIdComputed = 1
FROM #completedPattern_IdaInfoTable INNER JOIN JMBkpJobInfo WITH (NOLOCK) ON #completedPattern_IdaInfoTable.baseLineJobID = JMBkpJobInfo.jobId AND JMBkpJobInfo.commcellId = 2
			--ORACLE AGENTS SCHEDULES ARE ALWAYS CREATED AT BACKUPSET LEVEL AND SUBCLIENT IS -1. REPLICATION CAN START ON BACKUP FOR ANY OF SUBCLIENTS ON BACKUPSET
			WHERE ISNULL(scId, 0) <= 0
AND apId <> 81
			UPDATE #completedPattern_IdaInfoTable
			SET replicationId = T.repId,
			lastScheduleRunTime = lastRunTime,
			lastSyncedBkpJob = lastJobSynced,
			status = syncStatus
			FROM
			(
				SELECT taskId, subclientId, restoreSource resSource, replicationId repId, lastRunTime, status syncStatus, backupsetId,lastSyncedBkpJob lastJobSynced,restoreDestination resDestination
				FROM APP_LiveSyncReplication LS
				-- Flags = 1 indicates replication pair deleted
				where (flags&1)=0
			) T
			WHERE T.taskId = tkId
			-- Dont always match based on subclientId. Since for SQL and oracle Idas, subclientID can change depending on latest backup and if SQL db changed from one subclient content to another.
			AND (
				(T.subclientId = scId AND isSubclientIdComputed = 0) OR (T.backupsetId = bsId AND isSubclientIdComputed=1)
			)
			AND ISNULL(T.resSource, '') = restoreSource
			AND ISNULL(T.resDestination, '') = ISNULL(restoreDestination,'')
			UPDATE #completedPattern_IdaInfoTable
			SET lastRestoreTime =
			(
				SELECT rstTime
				FROM
				(
					SELECT MAX(servEndTime) rstTime, stId subTaskId
					FROM JMRestoreStats R (NOLOCK)
					JOIN #completedPattern_IdaInfoTable I ON I.stId = R.subTaskId AND I.bsId = R.bkpSetID
					WHERE R.status in ( 1,3,14)
					GROUP BY stId
				) T
				WHERE T.subTaskId = stId
			)
			DELETE #completedPattern_IdaInfoTable
			FROM
			(
				--REMOVE ANY SCHEDULES WHICH RUN TIME HAS BEEN CALCULATED BUT NOT PICKED UP BY SCHEDULER
				SELECT stId subTaskId
				FROM #completedPattern_IdaInfoTable RT
				JOIN TM_RunTime R (NOLOCK) ON R.patternId = RT.patId
				JOIN TM_Pattern P (NOLOCK) ON P.patternId = R.patternId
				--REMOVE ANY SCHEDULES WHICH RUN TIME HAS BEEN MARKED PROCESSED BUT RUN TIME ASSOC IS NOT MARKED PROCESSED. In case there is any exception in processing then runtime is marked processed but runtime assoc is marked processed. So when backup runs, this admin SP ends up
				-- inserting into runtime assoc again.
				JOIN TM_RunTimeAssoc RA (NOLOCK) ON RA.runtimeId = R.runtimeId
				WHERE R.processed = 0 OR RA.processed = 0
				UNION
				--REMOVE BACKUP SCHEDULES THAT ARE ALREADY RUNNING
				SELECT RT.stId subTaskId
				FROM #completedPattern_IdaInfoTable RT
				JOIN JMBkpJobInfo (NOLOCK) BI ON BI.backupTaskId = RT.stId
				--ONLY CHECK RUNNING FOR SCHEDULE, POLICIES WILL HAVE SEVERAL ASSOCIATIONS SO IT'S OK IF IT'S RUNNING CHECK WILL BE DONE IN TM_GetBackupEntity
JOIN TM_Task (NOLOCK) T ON T.taskId = RT.tkId AND T.taskType = 2
				UNION
			--REMOVE ADMIN SCHEDULES THAT ARE ALREADY RUNNING
				SELECT RT.stId subTaskId FROM #completedPattern_IdaInfoTable RT
				JOIN JMAdminJobInfoTable (NOLOCK) AI ON AI.subTaskId = RT.stId
				UNION
				-- Remove log shipping failover live sync schedules where test failover on destination client is in progress.
				SELECT RT.stId subTaskId FROM #completedPattern_IdaInfoTable RT
				INNER JOIN TM_Subtask(NOLOCK) ON TM_Subtask.subtaskId = RT.stId
AND (TM_Subtask.flags & 0x200000)>0 -- Check for schedules with live sync failover schedule flag set.
				INNER JOIN App_ClientProp (NOLOCK) ON App_ClientProp.attrName = 'TestFailoverInProgress' --CV_PROP_TEST_FAILOVER_PROGRESS
				AND App_ClientProp.modified = 0
				AND App_ClientProp.attrVal = '1'
INNER JOIN TM_subtaskOptions (NOLOCK) on TM_subtaskOptions.optionId = 293753447 and TM_subtaskoptions.subtaskid = TM_subtask.subtaskId
				and TM_subtaskOptions.value=convert(nvarchar(100),  App_ClientProp.componentNameId)
WHERE opType = 1007
AND apId = 81
			) T
			WHERE T.subTaskId = stId
AND freq_type = 4096
--
			-- For Sql which are replicating dbs backed up via dumpsweep, we need to trigger replication job for those dbs seperately. So we need  seperate jobs for regular dbs and dump DBs
			-- So modifying check for running schedules appropriately.
			DELETE #completedPattern_IdaInfoTable
			FROM
			(
			--REMOVE RESTORE SCHEDULES THAT ARE ALREADY RUNNING
				SELECT RT.stId subTaskId,
					CASE WHEN TM_JobOptions.Value IS NULL THEN 0 ELSE 1 END isDumpSweepReplicationJob
				FROM #completedPattern_IdaInfoTable RT
				JOIN JMRstJobInfo (NOLOCK) RI ON RI.rstTaskID = RT.stId
				LEFT JOIN TM_JobOptions (NOLOCK) ON TM_JobOptions.jobID = RI.JobID
AND TM_JobOptions.optionId = 120020 -- RST_IS_REPLICATION_DUMP_SWEEP
				AND TM_JobOptions.value = '1'
				UNION
				--GET INFORMATION FOR ANY REPLICATION JOBS THAT HAVE BEEN SUBMITTED TO START BUT JOB MANAGER HAS NOT STARTED
				SELECT RT.stId subTaskId,
					CASE WHEN TM_JobOptions.Value IS NULL THEN 0 ELSE 1 END isDumpSweepReplicationJob
				FROM #completedPattern_IdaInfoTable RT
				JOIN TM_JobRequest R (NOLOCK) ON R.subTaskId = RT.stId
				JOIN TM_Jobs J (NOLOCK) ON J.jobRequestId = R.jobRequestId AND J.status IN (0, 1,4097)  -- Refer to SP JMGetJopbsToProcessed there is an intermeridate state where 4096 flag is set
				LEFT JOIN TM_JobOptions (NOLOCK) ON TM_JobOptions.jobID = J.JobID
AND TM_JobOptions.optionId = 120020 -- RST_IS_REPLICATION_DUMP_SWEEP
				AND TM_JobOptions.value = '1'
			) T
			WHERE T.subTaskId = stId
			AND T.isDumpSweepReplicationJob = isDumpSweepSc
AND freq_type = 4096
				UPDATE #completedPattern_IdaInfoTable
   				SET copyPrecedenceApplicable = T.copyPrecedenceApplicable,
				copyPrecedence = T.copyPrecedence
				FROM
				(
					SELECT copyPrecedenceApplicable, copyPrecedence, I.stId subTaskId, I.tkId taskId
					FROM #completedPattern_IdaInfoTable I
WHERE opType IN (1001, 1002)		--_TASK_OPERATION_TYPE_RESTORE, _TASK_OPERATION_TYPE_POWER_RESTORE
				) T
				WHERE T.subTaskId = stId
			--GET THE LAST COPY TIME FOR SCHEDULES WITH COPY PRECEDENSE SET
			INSERT INTO #auxCopyTable (subTaskId, subclientId, maxJobEndTime, maxCopiedTime)
			SELECT S.subTaskId subTaskId, S.subclientId, MAX(jobEndTime) maxJobEndTime, MAX(maxCopiedTime) maxCopiedTime
			FROM
			(
				SELECT F.subTaskId subTaskId, F.subclientId, J.servEndDate jobEndTime, J.cycleSequence,
					--ROW_NUMBER() OVER (PARTITION BY F.SubtaskId, F.subclientId ORDER BY J.servEndDate) CopiedCycleSequenceNum, MAX(copiedTime) maxCopiedTime
					ROW_NUMBER() OVER (PARTITION BY F.SubtaskId, F.subclientId ORDER BY J.servEndDate) + ISNULL(T.auxcopied,0) CopiedCycleSequenceNum,
					--(SELECT COUNT(*) FROM JMBkpStats B (NOLOCK) WHERE  F.subclientId = B.AppId AND J.fullCycleNum = B.FullCycleNum AND J.cycleSequence > B.cycleSequence AND B.Status IN (1, 3) and B.DataStatus = 3 AND B.servEndDate <= (@nowUtcUnix - ISNULL(F.freq_interval*60,0) )  ) ,
					ISNULL(T.cycleSeq,0) + 1 ActualCycleSeq,
					MAX(copiedTime) maxCopiedTime
				FROM
				(
					SELECT subTaskId, subclientId, archGrpId, archGrpCopyId, MAX(fullCycleNum) FullCycleNum, ROW_NUMBER() OVER (PARTITION BY SubtaskId, subclientId ORDER BY MAX(fullCycleNum) DESC) FullCycleNumSPs, MAX(copyPrecedence) copyPrecedence,
					freq_interval
					FROM
					(
						SELECT IT.stId subTaskId, S.AppId subclientId, S.archGrpId, S.archGrpCopyId, MAX(fullCycleNum) FullCycleNum, MAX(IT.copyPrecedence) copyPrecedence,IT.freq_interval
						FROM #completedPattern_IdaInfoTable IT
						-- for oracle RAC,oracle subclients we have to wait for both data and log jobs to be aux copied
JOIN JMJobDataStats (NOLOCK) S ON S.appId = IT.scId AND IT.apId NOT IN ( 22, 80 )
						JOIN archGroupCopy (NOLOCK) AC ON AC.archGroupId = S.archGrpId AND AC.copy = IT.copyPrecedence AND AC.id = S.archGrpCopyId
						JOIN JMBkpStats (NOLOCK) J ON J.jobId = S.jobId AND J.commCellId = S.commCellId
						AND J.servEndDate <= (@nowUtcUnix - ISNULL(IT.freq_interval*60,0) ) --In case replication job is to be launched in a delayed fashion then we pick up last backup time before the delay.
						--AND J.jobId >= ISNULL(IT.baselineJobId, 0) For getting the latest cycle aux copied, we dont need to check if it was greater than baseline job. We need to only check last job aux copied > baseline job
						LEFT OUTER JOIN App_SubclientProp WITH (NOLOCK) ON App_SubclientProp.componentNameID = S.AppId AND App_SubclientProp.attrName='Enable Snap Backups' --  CV_PROP_ENABLE_SNAP_BACKUPS_NAME
						AND App_SubClientProp.cs_attrName = CHECKSUM(N'Enable Snap Backups')
						AND App_SubclientProp.attrVal = '1'
						WHERE IT.copyPrecedenceApplicable = 1
						AND J.bkpLevel IN (1, 64, 128, 16384, 1024,32768) -- 1024 (SEL_OFFLINE_FULL): selective offline full , 32768 (0x8000)= SEL_ONLINE_FULL selective online full
AND ( ( IT.apId = 135 AND App_SubclientProp.attrVal IS NOT NULL) OR IT.apId != 135 )
						GROUP BY IT.scId, S.archGrpId, S.archGrpCopyId, S.AppId, S.JobId, S.CommCellId, IT.stId,IT.freq_interval
						HAVING MAX(S.status) = 100 AND MIN(S.Status) = 100
					) T
					GROUP BY subTaskId, subclientId, archGrpId, archGrpCopyId,freq_interval
				) F
				JOIN JMBkpStats (NOLOCK) J ON J.appId = F.subclientId AND J.fullCycleNum = F.FullCycleNum
				AND J.servEndDate <= (@nowUtcUnix - ISNULL(F.freq_interval*60,0) ) --In case replication job is to be launched in a delayed fashion then we pick up last backup time before the delay.
				JOIN JMJobDataStats (NOLOCK) D ON J.jobId = D.jobId AND J.commCellId = D.commCellId
				JOIN archGroupCopy (NOLOCK) AC ON AC.archGroupId = D.archGrpId AND AC.copy = F.copyPrecedence AND AC.id = D.archGrpCopyId
				CROSS APPLY
				(
					SELECT SUM(CASE WHEN INNERQ.DataStatus = 3 THEN 1 ELSE 0 END) auxcopied, COUNT(1) cycleSeq
					FROM JMBkpStats INNERQ
					WHERE INNERQ.appId = J.AppId AND INNERQ.fullCycleNum = J.FullCycleNum AND J.cycleSequence > INNERQ.cycleSequence AND INNERQ.Status IN (1, 3, 14)
				) T
				WHERE  F.FullCycleNumSPs = 1
				GROUP BY F.subclientId, J.servEndDate, J.cycleSequence, F.subTaskId, J.fullCycleNum,F.freq_interval,T.AuxCopied,T.cycleSeq
				HAVING MAX(D.status) = 100 AND MIN(D.Status) = 100
			) S
			WHERE  S.ActualCycleSeq = S.CopiedCycleSequenceNum
			GROUP BY S.subclientId, S.subTaskId
			OPTION (MAXDOP 2) --TM_GetJobCompletedPatterns has high CPU usage on prodCS. So forcing MAXDOP here to avoid hogging CPU Resources
			-- check whether there are any ORacle RAC or ORacle live sync schedules with copy precedence. IF so do below.
			IF EXISTS(SELECT 1 FROM #completedPattern_IdaInfoTable IT
WHERE IT.apId IN ( 22, 80  ) AND IT.copyPrecedenceApplicable = 1
			)
			BEGIN
			INSERT INTO #auxCopyTable (subTaskId, subclientId, maxJobEndTime, maxCopiedTime)
			SELECT S.subTaskId subTaskId, S.subclientId, MAX(jobEndTime) maxJobEndTime, MAX(maxCopiedTime) maxCopiedTime
			FROM
			(
				SELECT F.subTaskId subTaskId, F.subclientId, J.servEndDate jobEndTime, J.cycleSequence,
					--ROW_NUMBER() OVER (PARTITION BY F.SubtaskId, F.subclientId ORDER BY J.servEndDate) CopiedCycleSequenceNum, MAX(copiedTime) maxCopiedTime
					ROW_NUMBER() OVER (PARTITION BY F.SubtaskId, F.subclientId ORDER BY J.servEndDate) + ISNULL(T.auxcopied,0) CopiedCycleSequenceNum,
					--(SELECT COUNT(*) FROM JMBkpStats B (NOLOCK) WHERE  F.subclientId = B.AppId AND J.fullCycleNum = B.FullCycleNum AND J.cycleSequence > B.cycleSequence AND B.Status IN (1, 3) and B.DataStatus = 3 AND B.servEndDate <= (@nowUtcUnix - ISNULL(F.freq_interval*60,0) )  ) ,
					ISNULL(T.cycleSeq,0) + 1 ActualCycleSeq,
					CASE WHEN ISNULL(MAX(DataJobDataStats.copiedTime),0)>ISNULL(MAX(LogJobDataStats.copiedTime),0) THEN ISNULL(MAX(DataJobDataStats.copiedTime),0)
					ELSE ISNULL(MAX(LogJobDataStats.copiedTime),0)
					END maxCopiedTime
				FROM
				(
					SELECT subTaskId, subclientId, MAX(fullCycleNum) FullCycleNum, ROW_NUMBER() OVER (PARTITION BY SubtaskId, subclientId ORDER BY MAX(fullCycleNum) DESC) FullCycleNumSPs, MAX(copyPrecedence) copyPrecedence,
					freq_interval
					FROM
					(
						SELECT IT.stId subTaskId, App_Application.Id subclientId, MAX(fullCycleNum) FullCycleNum, MAX(IT.copyPrecedence) copyPrecedence,IT.freq_interval
						FROM #completedPattern_IdaInfoTable IT
						-- for oracle RAC,oracle subclients we have to wait for both data and log jobs to be aux copied. Also we have to check for all subclients on oracle instance.
						JOIN App_Application (NOLOCK) ON IT.instId = App_Application.instance AND (subclientstatus & (4|2))=0
						JOIN JMBkpStats (NOLOCK) J ON J.appId = App_Application.Id AND J.commCellId = 2 -- DEFAULT_COMMCELL_ID
						AND J.status in (1,3,14)	--_JMSUCCESS,_PARTIALSUCCESS,_JMSUCCESSWITHWARNINGS
						AND J.opType!=14		--_Synthetic Full
						AND J.servEndDate <= (@nowUtcUnix - ISNULL(IT.freq_interval*60,0) ) --In case replication job is to be launched in a delayed fashion then we pick up last backup time before the delay.
						AND J.bkpLevel IN (1, 64, 128, 16384, 1024,32768) -- 1024 (SEL_OFFLINE_FULL): selective offline full , 32768 (0x8000)= SEL_ONLINE_FULL selective online full
AND IT.apId IN ( 22, 80  ) AND IT.copyPrecedenceApplicable = 1
LEFT JOIN ArchFile (NOLOCK) DataAF ON J.JobId = DataAF.JobId AND (DataAF.fileType & 1) > 0 AND DataAF.CommcellId = 2 -- CVA_AF_PIPE_DATA_FLAG
LEFT JOIN ArchFile (NOLOCK) LogAF ON  J.JobId = logAF.JobId  AND (logAF.fileType & 4) > 0 AND logAF.CommcellId = 2 -- CVA_AF_PIPE_DATA_FLAG
LEFT JOIN JMJobDataStats (NOLOCK) DataJobDataStats ON DataJobDataStats.appId = App_Application.Id AND DataJobDataStats.dataType = 1 AND DataAF.JobId = DataJobDataStats.JobId AND DataJobDataStats.CommcellId = 2 -- Data
LEFT JOIN JMJobDataStats (NOLOCK) LogJobDataStats ON  LogJobDataStats.appId =  App_Application.Id AND LogJobDataStats.dataType = 4  AND logAF.JobId = LogJobDataStats.JobId   AND LogJobDataStats.CommcellId = 2 -- Log
						LEFT JOIN archGroupCopy (NOLOCK) DataAC ON DataAF.archGroupId = DataJobDataStats.archGrpId AND DataAC.copy = IT.copyPrecedence AND DataAC.id = DataJobDataStats.archGrpCopyId
						LEFT JOIN archGroupCopy (NOLOCK) LogAC ON LogAC.archGroupId = LogJobDataStats.archGrpId AND LogAC.copy = IT.copyPrecedence AND LogAC.id = LogJobDataStats.archGrpCopyId
						WHERE  (DataAF.JobId IS NULL OR
							( DataAF.JobId IS NOT NULL AND DataJobDataStats.jobId IS NOT NULL AND DataAC.copy IS NOT NULL)
						) AND
						(logAF.JobId IS NULL OR
							( logAF.JobId IS NOT NULL AND LogJobDataStats.jobId IS NOT NULL AND LogAC.copy IS NOT NULL)
						)
						GROUP BY App_Application.Id,IT.stId,IT.freq_interval, J.JobId
						HAVING MAX(CASE WHEN  DataAF.JobId IS NOT NULL THEN DataJobDataStats.status ELSE 100 END) = 100
						AND MIN(CASE WHEN  DataAF.JobId IS NOT NULL THEN DataJobDataStats.status ELSE 100 END) = 100
						AND MAX(CASE WHEN  logAF.JobId IS NOT NULL THEN LogJobDataStats.status ELSE 100 END) = 100
						AND MIN(CASE WHEN  logAF.JobId IS NOT NULL THEN LogJobDataStats.status ELSE 100 END) = 100
					) T
					GROUP BY subTaskId, subclientId, freq_interval
				) F
				JOIN JMBkpStats (NOLOCK) J ON J.appId = F.subclientId AND J.fullCycleNum = F.FullCycleNum
				AND J.status in (1,3,14)	--_JMSUCCESS,_PARTIALSUCCESS,_JMSUCCESSWITHWARNINGS
				AND J.opType!=14		--_Synthetic Full
				AND J.servEndDate <= (@nowUtcUnix - ISNULL(F.freq_interval*60,0) ) --In case replication job is to be launched in a delayed fashion then we pick up last backup time before the delay.
				CROSS APPLY
				(
					SELECT SUM(CASE WHEN INNERQ.DataStatus = 3 THEN 1 ELSE 0 END) auxcopied, COUNT(1) cycleSeq
					FROM JMBkpStats INNERQ
					WHERE INNERQ.appId = J.AppId AND INNERQ.fullCycleNum = J.FullCycleNum AND J.cycleSequence > INNERQ.cycleSequence AND INNERQ.Status IN (1, 3, 14)
				) T
LEFT JOIN ArchFile (NOLOCK) DataAF ON J.JobId = DataAF.JobId AND (DataAF.fileType & 1) > 0 AND DataAF.CommcellId = 2 -- CVA_AF_PIPE_DATA_FLAG
LEFT JOIN ArchFile (NOLOCK) logAF ON  J.JobId = logAF.JobId  AND (logAF.fileType & 4) > 0 AND logAF.CommcellId = 2 -- CVA_AF_PIPE_DATA_FLAG
LEFT JOIN JMJobDataStats (NOLOCK) DataJobDataStats ON DataJobDataStats.appId = J.appId AND DataJobDataStats.dataType = 1 AND DataAF.JobId = DataJobDataStats.JobId AND DataJobDataStats.CommcellId = 2 -- Data
LEFT JOIN JMJobDataStats (NOLOCK) LogJobDataStats ON  LogJobDataStats.appId =  J.appId AND LogJobDataStats.dataType = 4 AND logAF.JobId = LogJobDataStats.JobId AND LogJobDataStats.CommcellId = 2 -- Log
				LEFT JOIN archGroupCopy (NOLOCK) DataAC ON DataAF.archGroupId = DataJobDataStats.archGrpId AND DataAC.copy = F.copyPrecedence AND DataAC.id = DataJobDataStats.archGrpCopyId
				LEFT JOIN archGroupCopy (NOLOCK) LogAC ON LogAC.archGroupId = LogJobDataStats.archGrpId AND LogAC.copy = F.copyPrecedence AND LogAC.id = LogJobDataStats.archGrpCopyId
				WHERE  F.FullCycleNumSPs = 1
				AND (DataAF.JobId IS NULL OR
							( DataAF.JobId IS NOT NULL AND DataJobDataStats.jobId IS NOT NULL AND DataAC.copy IS NOT NULL)
				)
				AND (logAF.JobId IS NULL OR
						( logAF.JobId IS NOT NULL AND LogJobDataStats.jobId IS NOT NULL AND LogAC.copy IS NOT NULL)
				)
				GROUP BY F.subclientId, J.servEndDate, J.cycleSequence, F.subTaskId, J.fullCycleNum,F.freq_interval,T.AuxCopied,T.cycleSeq
				HAVING MAX(CASE WHEN  DataAF.JobId IS NOT NULL THEN DataJobDataStats.status ELSE 100 END) = 100
						AND MIN(CASE WHEN  DataAF.JobId IS NOT NULL THEN DataJobDataStats.status ELSE 100 END) = 100
						AND MAX(CASE WHEN  logAF.JobId IS NOT NULL THEN LogJobDataStats.status ELSE 100 END) = 100
						AND MIN(CASE WHEN  logAF.JobId IS NOT NULL THEN LogJobDataStats.status ELSE 100 END) = 100
			) S
			WHERE  S.ActualCycleSeq = S.CopiedCycleSequenceNum
			GROUP BY S.subclientId, S.subTaskId
			OPTION (MAXDOP 2) --TM_GetJobCompletedPatterns has high CPU usage on prodCS. So forcing MAXDOP here to avoid hogging CPU Resources
			END
			-- Now remove entries where baseLinejob>0 and where baseLinejob isnt aux copied.
			DELETE auxCopyTable FROM #auxCopyTable auxCopyTable
			INNER JOIN #completedPattern_IdaInfoTable IT
			ON IT.copyPrecedenceApplicable = 1
			AND IT.stId = auxCopyTable.subTaskId
			AND IT.baseLineJobId > 0
INNER JOIN JMBkpStats ON IT.baseLineJobId = JMBkpStats.jobId AND JMBkpStats.CommcellID = 2  -- Default commcellID
			AND auxCopyTable.maxJobEndTime<JMBkpStats.servEndDate
			--SET LAST RUN TIME FOR ADMIN SCHEDULES
			UPDATE #completedPattern_IdaInfoTable
				SET lastSuccessBkupTime = ISNULL(
													(SELECT MAX(servEnd)
														FROM JMAdminJobStatsTable (NOLOCK) S
														WHERE S.subTaskId = stId
													), lastSuccessBkupTime
												)
WHERE opType = 1007
			-- We dont need OpType check below since its already done above.
--AND opType NOT IN (1, 2, 1001, 1002, 1005, 1006)
			--SET LAST RUN TIME FOR BACKUP AND RESTORE SCHEDULES
			--FOR A REGUALR RESTORE SCHEDULE LOOK AT THE LAST TIME A BACKUP RAN FOR THE SUBCLIENT
			UPDATE #completedPattern_IdaInfoTable
				SET lastSuccessBkupTime = ISNULL(
													(
														SELECT MAX(endDate)
														FROM
														(
															SELECT servEndDate endDate
															FROM JMBkpStats (NOLOCK) BS
															LEFT JOIN App_AppTypeGroup ON App_AppTypeGroup.typeOfGroup = 0 AND
															App_AppTypeGroup.groupName='APPGRP_FileSystemIDA'
															LEFT JOIN App_AppTypeGroupAssoc ON apId = App_AppTypeGroupAssoc.appTypeid AND App_AppTypeGroupAssoc.typeOfGroup = 0
															AND App_AppTypeGroupAssoc.appGroupId = App_AppTypeGroup.appTypeGroupId
															WHERE BS.appId = scId
															AND BS.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
															AND BS.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/ , 18 /*BACKUP3RD*/ ) -- No need for synthfull to identify last backup time.
															AND copyPrecedenceApplicable = 0
															AND BS.jobId >= ISNULL(baselineJobId, 0)
															-- MR 213748 Sync job running after scan marked backup job is going to pending state
															-- For FS apptype, we should update lastSuccessBkupTime  only when backup job has backed up something.
															AND (BS.dataBackedUp>0 OR (BS.dataBackedUp = 0 AND App_AppTypeGroupAssoc.typeOfGroup IS NULL) )
															AND BS.servEndDate <= (@nowUtcUnix - ISNULL(freq_interval*60,0) ) --In case replication job is to be launched in a delayed fashion then we pick up last backup time before the delay.
															UNION
															SELECT maxCopiedTime endDate
															FROM #auxCopyTable AT
															WHERE AT.subclientId = scId AND AT.subTaskId = stId
															AND copyPrecedenceApplicable = 1
AND apId NOT IN ( 22, 80  )
															UNION
															SELECT maxCopiedTime endDate
															FROM #auxCopyTable AT
															INNER JOIN App_application (NOLOCK) ON App_application.instance = instId AND (subclientstatus & (4|2))=0
															WHERE AT.subclientId = App_application.Id AND AT.subTaskId = stId
															AND copyPrecedenceApplicable = 1
AND apId IN ( 22, 80  )
														) T
													), 0
												)
WHERE opType = 1007
AND apId <> 81 --For SQL, we compute lastSuccessbkpTime during insertion into #completedPattern_IdaInfoTable
--AND opType IN (1, 2, 1001, 1002, 1005, 1006, 1007)
			-- For SQL update last success backup time and backup level based on jobId.
			UPDATE completedPattern_IdaInfoTable
			SET lastSuccessBkupTime = JMBkpStats.servEndDate,
			bkpLevel = JMBkpStats.bkpLevel
			FROM #completedPattern_IdaInfoTable completedPattern_IdaInfoTable
			INNER JOIN JMBkpStats ON completedPattern_IdaInfoTable.jId = JMBkpStats.jobID AND
JMBkpStats.commcellId = 2
AND apId = 81
			AND completedPattern_IdaInfoTable.copyPrecedenceApplicable = 0
			--Update backup level where copy precedence is applicable. Its needed for SQL to avoid triggering live sync when full job is aux copied. And its not first full.
			-- For SQL apptype where copy precedence is involved, lets compute lastSuccessbkuptime from auxCopyTable table.
			UPDATE IdaInfoTbl
			SET bkpLevel = JMBkpStats.bkpLevel,
			lastSuccessBkupTime = AT.maxCopiedTime
			FROM #completedPattern_IdaInfoTable IdaInfoTbl
			INNER JOIN #auxCopyTable AT ON AT.subclientId = IdaInfoTbl.scId AND AT.subTaskId = IdaInfoTbl.stId
AND IdaInfoTbl.opType = 1007
			AND IdaInfoTbl.copyPrecedenceApplicable = 1
AND IdaInfoTbl.apId = 81 -- Do this for sql apptype only.
			INNER JOIN JMBkpStats ON JMBkpStats.appID = IdaInfoTbl.scId
AND JMBkpStats.commcellID = 2  -- default commcell ID
			AND JMBkpStats.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/ , 18 /*BACKUP3RD*/ ) -- No need for synthfull to identify last backup time.
			AND AT.maxJobEndTime = JMBkpStats.servEndDate
			-- Update last backup time for log shipping subclient in case no successful backup has happened after failover.
			UPDATE completedPattern_IdaInfoTable
			SET lastSuccessBkupTime = 0
			FROM #completedPattern_IdaInfoTable completedPattern_IdaInfoTable
			INNER JOIN TM_Subtask(NOLOCK) ON TM_Subtask.subtaskId = completedPattern_IdaInfoTable.stId
AND (TM_Subtask.flags & 0x200000)>0 -- Check for schedules with live sync failover schedule flag set.
WHERE opType = 1007
--AND opType IN (1, 2, 1001, 1002, 1005, 1006, 1007)
			AND lastSuccessBkupTime < @lastCSFailoverTime
			-- AND ISNULL(scId, 0) = @logShippingScID AND @logShippingScID<>0
			-- No need to use logShipping subclient. We can block replication for failover live sync schedule till new backup happens since we dont know whether reconfiguration ran and finding updated second instance happened or not.
AND apId = 81
			UPDATE #completedPattern_IdaInfoTable
			SET lastBackupForReplication = ISNULL(
													(
														SELECT MAX(endDate)
														FROM
														(
															SELECT maxJobEndTime endDate
															FROM #auxCopyTable AT
															WHERE AT.subclientId = scId AND AT.subTaskId = stId
															AND copyPrecedenceApplicable = 1
AND apId NOT IN ( 22, 80  )
															UNION
															SELECT maxJobEndTime endDate
															FROM #auxCopyTable AT
															INNER JOIN App_application (NOLOCK) ON App_application.instance = instId AND (subclientstatus & (4|2))=0
															WHERE AT.subclientId = App_application.Id AND AT.subTaskId = stId
															AND copyPrecedenceApplicable = 1
AND apId IN ( 22, 80  )
														) T
													), lastSuccessBkupTime
												)
WHERE opType = 1007
			UPDATE #completedPattern_IdaInfoTable
			SET status = @LIVESYNC_PENDING
            WHERE lastScheduleRunTime < lastSuccessBkupTime
			--GET LIST OF REGULAR BACKUP JOBS TO BE REPLICATED
			-- For replications at subclient level like FS ida, SQL let us compute backups pending to sync for that specific subclient.
			UPDATE #completedPattern_IdaInfoTable
				SET bkpJobsToSync = ISNULL((STUFF((
					SELECT TOP 10 ', ' + CAST(JB.jobid AS VARCHAR)
					FROM JMBkpStats (NOLOCK) JB
					WHERE JB.appId = scId
					AND JB.jobId > lastSyncedBkpJob
					AND lastSyncedBkpJob > 0
					AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
					AND JB.opType in (4 /*BACKUP*/ , 18 /*BACKUP3RD*/)
					ORDER BY JB.jobId DESC
					FOR XML PATH(''), TYPE).value('.[1]', 'NVARCHAR(1024)'), 1, 2, '')),
				'')
			WHERE copyPrecedenceApplicable = 0
			AND isSubclientIdComputed = 0
			-- For replications at backupset/instance level like oracle,oracle RAC let us compute backups pending to sync for that specific backupset.
			UPDATE #completedPattern_IdaInfoTable
				SET bkpJobsToSync = ISNULL((STUFF((
					SELECT TOP 10 ', ' + CAST(JB.jobid AS VARCHAR)
					FROM JMBkpStats (NOLOCK) JB
					INNER JOIN App_Application (NOLOCK) ON
					JB.appId = App_Application.ID
					AND App_Application.backupset = bsId
					WHERE JB.jobId > lastSyncedBkpJob
					AND lastSyncedBkpJob > 0
					AND JB.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
					AND JB.opType in (4 /*BACKUP*/ , 18 /*BACKUP3RD*/)
					ORDER BY JB.jobId DESC
					FOR XML PATH(''), TYPE).value('.[1]', 'NVARCHAR(1024)'), 1, 2, '')),
				'')
			WHERE copyPrecedenceApplicable = 0
			AND isSubclientIdComputed = 1
			--GET LIST OF BACKUP JOBS THAT HAVE BEEN AUXCOPIED TO BE REPLICATED
			-- For replications at subclient level like FS ida, SQL let us compute backups aux copied pending to sync for that specific subclient.
			UPDATE #completedPattern_IdaInfoTable
				SET bkpJobsToSync = ISNULL((STUFF((
					SELECT TOP 10 ', ' + CAST(J2.jobid AS VARCHAR)
					FROM JMBkpStats J1 (NOLOCK)
					JOIN #auxCopyTable AU ON AU.subclientId = J1.appId AND AU.maxJobEndTime = J1.servEndDate
					JOIN JMBkpStats J2 (NOLOCK) ON J2.appId = J1.appId AND J2.fullCycleNum = J1.fullCycleNum
					WHERE J2.appId = scId AND AU.subTaskId = stId
					AND J2.jobId > lastSyncedBkpJob
					AND J2.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/, 18 /*BACKUP3RD*/ )
					AND J2.jobId <= J1.jobId
					AND lastSyncedBkpJob > 0
					ORDER BY J2.jobId DESC
					FOR XML PATH(''), TYPE).value('.[1]', 'NVARCHAR(1024)'), 1, 2, '')),
				'')
			WHERE copyPrecedenceApplicable = 1
			AND isSubclientIdComputed = 0
			--GET LIST OF BACKUP JOBS THAT HAVE BEEN AUXCOPIED TO BE REPLICATED
			-- For replications at subclient level like Oracle let us compute backups aux copied pending to sync for that specific backupset.
			UPDATE #completedPattern_IdaInfoTable
				SET bkpJobsToSync = ISNULL((STUFF((
					SELECT TOP 10 ', ' + CAST(J2.jobid AS VARCHAR)
					FROM JMBkpStats J1 (NOLOCK)
					JOIN #auxCopyTable AU ON AU.subclientId = J1.appId AND AU.maxJobEndTime = J1.servEndDate
					JOIN JMBkpStats J2 (NOLOCK) ON J2.appId = J1.appId AND J2.fullCycleNum = J1.fullCycleNum
					INNER JOIN App_Application (NOLOCK) ON J2.appId = App_Application.ID
					AND App_Application.backupset = bsId
					WHERE AU.subTaskId = stId
					AND J2.jobId > lastSyncedBkpJob
					AND J2.opType in (4 /*BACKUP*/, 59 /*SNAPBACKUP*/, 18 /*BACKUP3RD*/ )
					AND J2.jobId <= J1.jobId
					AND lastSyncedBkpJob > 0
					ORDER BY J2.jobId DESC
					FOR XML PATH(''), TYPE).value('.[1]', 'NVARCHAR(1024)'), 1, 2, '')),
				'')
			WHERE copyPrecedenceApplicable = 1
			AND isSubclientIdComputed = 1
			MERGE APP_LiveSyncReplication LS
			USING
			(
				SELECT replicationId, tkId, stId, clId, apId, instId, bsId, scId, destClientId, destAppTypeId, destInstanceId, status, flags, lastSuccessBkupTime, lastScheduleRunTime, lastRestoreTime, restoreSource,bkpJobsToSync, restoreDestination,lastBackupForReplication, isDumpSweepSc
				FROM #completedPattern_IdaInfoTable WHERE destClientId > 0
				AND scID IS NOT NULL -- Dont consider replication entries where scID is computed as NULL to avoid inserting them.
			) AS RT ON RT.clId = LS.clientId AND RT.apId = LS.appTypeId AND RT.instId = LS.instanceId AND RT.bsId = LS.backupsetId AND RT.destClientId = LS.destClientId AND RT.restoreSource = LS.restoreSource
				AND RT.destAppTypeId = LS.destAppTypeId AND RT.destInstanceId = LS.destInstanceId AND RT.stId = LS.subTaskId AND ISNULL(RT.restoreSource, '') = ISNULL(LS.restoreSource, '')
				AND ISNULL(RT.restoreDestination, '') = ISNULL(LS.restoreDestination, '')
				-- Flags = 1 indicates replication pair deleted
				AND (LS.flags&1)=0
			WHEN MATCHED THEN
				UPDATE SET
					LS.lastBackupTime = RT.lastSuccessBkupTime,
					LS.status = RT.status,
					LS.flags = RT.flags,
					LS.lastRestoreTime = ISNULL(RT.lastRestoreTime, 0),
					LS.bkpJobsToSync = RT.bkpJobsToSync,
					LS.subclientId = CASE WHEN RT.scId IS NULL OR RT.scId<=0 THEN LS.subclientId ELSE RT.scId END,
					LS.lastBackupForReplication = RT.lastBackupForReplication,
					LS.isDumpSweepSc = RT.isDumpSweepSc
			WHEN NOT MATCHED BY TARGET THEN
				INSERT (taskId, subTaskId, clientId, appTypeId, instanceId, backupsetId, subclientId, destClientId, destAppTypeId, destInstanceId,
						options, configuration, lastRestoreTime, lastBackupTime, lastRunTIme, lastSyncTime, created, modified, lastSyncedBkpJob, bkpJobsToSync, flags, status, restoreSource,restoreDestination, lastBackupForReplication, isDumpSweepSc)
				VALUES (RT.tkId, RT.stId, RT.clId, RT.apId, RT.instId, RT.bsId, RT.scId,RT.destCLientId, RT.destAppTypeId, RT.destInstanceId,
						'', NULL, 0, 0, 0, 0, @nowTimeUnix, 0, 0, 0, RT.flags, RT.status, RT.restoreSource, ISNULL(RT.restoreDestination,''), RT.lastBackupForReplication, RT.isDumpSweepSc )
			--WHEN NOT MATCHED BY SOURCE THEN
			--	UPDATE SET LS.Flags = 1
			OUTPUT INSERTED.replicationId, INSERTED.taskId, INSERTED.restoreSource, INSERTED.status, INSERTED.lastBackupTime, INSERTED.bkpJobsToSync,
			$action, DELETED.status, DELETED.lastBackupTime, DELETED.bkpJobsToSync, @nowTime, INSERTED.isDumpSweepSc INTO #output_IdaInfoTable
			;
			-- Flags = 1 indicates replication pair deleted
			--REMOVE FROM OUTPUT TABLE ANY ENTRIES WHICH HAVE NOT CHANGED
			DELETE #output_IdaInfoTable WHERE statusIn=statusOut AND lastBackupTimeIn=lastBackupTimeOut AND bkpJobsToSyncIn = bkpJobsToSyncOut AND action = 'UPDATE'
			-- Mark flags where schedule is being processed but the restore source isnt part of schedule any more.
			-- Also restore job for this schedule should not be running.
			UPDATE LS
			SET flags=1
			FROM APP_LiveSyncReplication LS INNER JOIN #completedPattern_IdaInfoTable RT
			ON RT.clId = LS.clientId AND RT.apId = LS.appTypeId AND RT.instId = LS.instanceId AND RT.bsId = LS.backupsetId AND RT.destClientId = LS.destClientId
				AND RT.destAppTypeId = LS.destAppTypeId AND RT.destInstanceId = LS.destInstanceId AND RT.stId = LS.subTaskId
			LEFT OUTER JOIN JMRstJobInfo JR (NOLOCK) ON JR.rstTaskID = LS.subTaskId
			LEFT JOIN #completedPattern_IdaInfoTable RTLeft
			ON RTLeft.clId = LS.clientId AND RTLeft.apId = LS.appTypeId AND RTLeft.instId = LS.instanceId AND RTLeft.bsId = LS.backupsetId AND RTLeft.destClientId = LS.destClientId
				AND RTLeft.destAppTypeId = LS.destAppTypeId AND RTLeft.destInstanceId = LS.destInstanceId AND RTLeft.stId = LS.subTaskId AND RTLeft.restoreSource = LS.restoreSource
				AND ISNULL(RTLeft.restoreDestination,'') = ISNULL(LS.restoreDestination,'')
			WHERE RTLeft.clId IS NULL AND JR.rstTaskID IS NULL
			DELETE #completedPattern_IdaInfoTable
			WHERE tkDisabled = 1
			-- DELETE where restore already ran after backup.
			DELETE #completedPattern_IdaInfoTable
			WHERE lastScheduleRunTime > lastSuccessBkupTime
			AND freq_interval > 0
			IF NOT EXISTS(SELECT * FROM #completedPattern_IdaInfoTable)
			BEGIN
				SET @oErrorString = 'All schedules have been disabled'
				-- In case there are no schedules to process then we could end up not inserting run time for automatic synthetic full schedules also because there were no site replication schedules.
				GOTO EXIT_PROCESS_RTINFO
			END
			IF EXISTS(SELECT 1 FROM JMJobAction (NOLOCK) WHERE opType=28 AND action=1 AND clientId = 1 AND appType = 0 AND mediaAgentID = 1)
			BEGIN
				SET @oErrorString = 'Schedules will skipped because scheduler activity is disable'
				GOTO EXIT_SP
			END
-- Remove all entries where freq type is not 4096 _4096
			DELETE #completedPattern_IdaInfoTable
WHERE freq_type != 4096
			--SET REPLICATION ID FOR NEW ENTRIES ADDED TO TABLE
			UPDATE #completedPattern_IdaInfoTable
			SET replicationId = OU.replicationId
			FROM #completedPattern_IdaInfoTable IDA
			JOIN #output_IdaInfoTable OU ON OU.tkId = IDA.tkId AND OU.restoreSource = IDA.restoreSource
			WHERE IDA.replicationId = 0
			--REMOVE ANY RUNTIME FOR WHICH INTERVAL TIME HAS NOT PASSED
			DELETE #completedPattern_IdaInfoTable
			FROM
			(
				SELECT tkId taskId
				FROM #completedPattern_IdaInfoTable RT
JOIN TM_PatternAssoc (NOLOCK) PA ON PA.subTaskId = RT.stId AND RT.freq_type = 4096
				JOIN TM_Pattern (NOLOCK) P ON P.patternId = PA.patternId
				WHERE (P.freq_interval*60)+RT.lastSuccessBkupTime > @nowUtcUnix
			) T
WHERE freq_type = 4096
			AND tkId = T.taskId
			-- Check to ensure lastSuccessBkpupTime = 0 and if so, remove it since backup hasnt happened. Call done seperately here and removed from below since if there was only one live sync schedule with no backup, then Inner query below returned 0 rows and hence entries with
			-- lastSuccessBkupTime = 0 didnt get removed.
			DELETE #completedPattern_IdaInfoTable
			WHERE lastSuccessBkupTime = 0
			--REMOVE ANY FOR WHICH BASE JOB HAS NOT RUN
			DELETE #completedPattern_IdaInfoTable
			FROM
			(
				SELECT RT.tkId, RT.replicationId repId
				FROM #completedPattern_IdaInfoTable RT
				WHERE
				(
					RT.baselineJobId IS NOT NULL
					AND
					(
						NOT EXISTS(SELECT 1 FROM TM_Jobs JS (NOLOCK) WHERE JS.jobId >= RT.baselineJobId)		--BASE JOBID HAS NOT BEEN CREATED
						OR
						(
							--BASE JOBID HAS NOT COMPLETED
							NOT EXISTS(
								SELECT 1 FROM JMBkpStats JS (NOLOCK) WHERE JS.appId = scId AND JS.jobId >= RT.baselineJobId
							)
							AND		--BASE JOBID IS CURRENTLY RUNNING
							EXISTS(
								SELECT 1 FROM JMBkpJobInfo JS (NOLOCK) WHERE JS.applicationId = scId AND JS.jobId >= RT.baselineJobId
							)
						)
					)
				)
				OR --RESTORE JOB ALREADY RAN AFTER BACKUP
				EXISTS(
					-- For FS agents, we want to delete only last backup is before last replication start. There could be cases where last aux copy/last backup ran after restore start but before restore end. And we dont trigger replication in such cases after the last backup/aux copy.
					SELECT RS.servStartTime FROM JMRestoreStats RS (NOLOCK)
					LEFT JOIN JMJobOptions (NOLOCK) ON RS.jobId = JMJobOptions.jobId
					AND JMJobOptions.attributeName='Source path'
					LEFT JOIN App_AppTypeGroup ON App_AppTypeGroup.typeOfGroup = 0 AND
					App_AppTypeGroup.groupName='APPGRP_FileSystemIDA'
					LEFT JOIN App_AppTypeGroupAssoc ON apId = App_AppTypeGroupAssoc.appTypeid AND App_AppTypeGroupAssoc.typeOfGroup = 0
					AND App_AppTypeGroupAssoc.appGroupId = App_AppTypeGroup.appTypeGroupId
					WHERE RS.subTaskId = RT.stId AND RT.baselineJobId > 0 AND RS.servEndTime > lastSuccessBkupTime
					AND (App_AppTypeGroupAssoc.typeOfGroup IS NULL OR JMJobOptions.attributeValue= restoreSource) -- For FS agents, we want to compute servEndTime based on restore source. For other agents we want to compute servEndtime based on last retsore job from schedule.
					AND freq_interval = 0
AND apId != 135
					UNION
					SELECT RS.servEndTime FROM JMRestoreStats RS (NOLOCK)
					LEFT JOIN JMJobOptions ON RS.jobId = JMJobOptions.jobId
					AND JMJobOptions.attributeName='Source path'
					LEFT JOIN App_AppTypeGroup ON App_AppTypeGroup.typeOfGroup = 0 AND
					App_AppTypeGroup.groupName='APPGRP_FileSystemIDA'
					LEFT JOIN App_AppTypeGroupAssoc ON apId = App_AppTypeGroupAssoc.appTypeid AND App_AppTypeGroupAssoc.typeOfGroup = 0
					AND App_AppTypeGroupAssoc.appGroupId = App_AppTypeGroup.appTypeGroupId
					WHERE RS.subTaskId = RT.stId AND RT.baselineJobId IS NULL
					AND (
						-- For FS agents, we want to look at start time of last restore job since ida uses toTime passed by scheduler during job start. For other agents we want to compute servEndtime based on last restore job end time from schedule.
						(RS.servEndTime > lastSuccessBkupTime AND
							(App_AppTypeGroupAssoc.typeOfGroup IS NULL OR copyPrecedenceApplicable != 1)
						) OR
						(RS.servStartTime > lastSuccessBkupTime AND App_AppTypeGroupAssoc.typeOfGroup IS NOT NULL AND copyPrecedenceApplicable = 1)
					)
					AND (App_AppTypeGroupAssoc.typeOfGroup IS NULL OR JMJobOptions.attributeValue= restoreSource)
					AND freq_interval = 0
AND apId != 135
					UNION
					SELECT RS.servStartTime FROM JMRestoreStats RS (NOLOCK)
					WHERE RS.subTaskId = RT.stId
					AND freq_interval = 0
AND apId = 135
					AND RS.servStartTime > lastSuccessBkupTime
				)
				UNION
				--FOR SQL AGENT ONLY START REPLICATION AFTER TRANSACTION LOG JOBS, EXCEPT FOR THE FIRST TIME
				SELECT I.tkId, I.replicationId repId
				FROM #completedPattern_IdaInfoTable I
				JOIN APP_LiveSyncReplication R (NOLOCK) ON R.replicationId = I.replicationId
                AND I.bkpLevel IN (1, 4) --FULL, DIFFERENTIAL
				AND I.lastScheduleRunTime > 0	--THE SCHEDULE HAS RUN AT LEAST ONCE
AND I.apId = 81
			) T
			WHERE replicationId = T.repId
			-- Delete for which operation window for restore operation type isnt met.
--- CODE BELOW HERE IS FROM TM_AppIdTblCreate.spb  ----------
		-------------------------------
		--CREATE TEMP TABLE------------
		-------------------------------
		-- None of these temp tables should ever exist when this procedure is called!
		if object_id('tempdb.dbo.#appIdTbl') is not null
    		DROP TABLE #appIdTbl
		CREATE TABLE #appIdTbl (
			appId INT,
			appTypeId INT,
			clientId INT,
			instanceId INT,
			backupsetId INT,
			STATUS INT,
			bkpLevel INT,
			storagePolicy INT,
timezoneName nvarchar(255) DEFAULT '',
			ignoreHigherLevelOpWindowRules	INT DEFAULT 0,
			jmOperationType INT DEFAULT 0,
			taskID			INT DEFAULT 0,
			parentJobId int DEFAULT 0,
			parentAppID int DEFAULT 0,
			vmDiscovered INT DEFAULT 0,
			utcdateTime     DATETIME DEFAULT '1970-01-01 00:00:00.000', -- Needed for Predict SLA project where we need to identify if backup time is outside operation window.
			stID		INT DEFAULT 0
		)
		CREATE CLUSTERED INDEX appIdTbl_idx ON #appIdTbl (appId)
		CREATE NONCLUSTERED INDEX appIdTbl_clientId_idx ON #appIdTbl ([clientId])
		CREATE NONCLUSTERED INDEX appIdTbl_appTypeId_idx ON #appIdTbl ([appTypeId])
		CREATE NONCLUSTERED INDEX appIdTbl_timezoneName_idx ON #appIdTbl ([timezoneName])
--- CODE ABOVE HERE IS FROM TM_AppIdTblCreate.spb  ----------
			INSERT INTO #appIdTbl(clientId, appTypeID, taskId, jmOperationType)
			SELECT DISTINCT destClientId, apId, tkId, 8 --OPERATION_DATA_RECOVERY
			FROM #completedPattern_IdaInfoTable
			EXEC TMFilterSubclientsByOperationWindow 0
			-- Remove those entries which are not there.
			DELETE completedPattern_IdaInfoTable FROM #completedPattern_IdaInfoTable completedPattern_IdaInfoTable
			LEFT JOIN #appIdTbl appIdTbl ON completedPattern_IdaInfoTable.destClientId = appIdTbl.clientID AND completedPattern_IdaInfoTable.apId = appIdTbl.appTypeID
			AND completedPattern_IdaInfoTable.tkID = appIdTbl.taskId
			WHERE appIdTbl.taskId IS NULL
		--REPOPULATE ENTRIES IN TEMP TABLE USED TO START THE JOBS
			--INSERT WITHOUT THE STATUS OR MULBIPLE ENTRIES WILL BE CREATED FOR THAT SCHEDULE
			INSERT #completedPattern_runTimeInfoTable
			(stId, taskId, patId, cgId, clId, apId, instId, bsId, scId, lastSuccessBkupTime, opType, freq_type, tkDisabled)
			SELECT DISTINCT stId, tkId, patId, cgId, clId, apId, instId, bsId, 0, MAX(lastSuccessBkupTime), opType, freq_type, tkDisabled
			FROM #completedPattern_IdaInfoTable
			GROUP BY stId, tkId, patId, cgId, clId, apId, instId, bsId, opType, freq_type, tkDisabled
		    --SET STATUS WHEN REPLICATIONS ARE PENDING
		    UPDATE #completedPattern_runTimeInfoTable
		    SET status = ISNULL((
			    SELECT TOP 1 status FROM #completedPattern_IdaInfoTable
			    WHERE tkId = taskId
			    AND status IN (@LIVESYNC_PENDING)
			    ORDER BY status
			    ), status)
		END
--
		UPDATE APP_LiveSyncReplication
		SET status = @LIVESYNC_STARTING,
		lastRunTime = @nowUtcUnix - (T.freq_interval*60)
		FROM APP_LiveSyncReplication
		INNER JOIN
		(
			SELECT I.replicationId, I.freq_interval
			FROM #completedPattern_runTimeInfoTable R
			JOIN #completedPattern_IdaInfoTable I ON I.tkId = R.taskId
			AND I.status = R.status AND R.status = @LIVESYNC_PENDING
		) T
		ON T.ReplicationId = APP_LiveSyncReplication.ReplicationId
		-- Flags = 1 indicates replication pair deleted
		and (Flags&1)=0
EXIT_PROCESS_RTINFO:
		-- Automatic synthetic full schedules should not be processed when scheduler activity is disabled. Especially When no Site replication schedules are present.
		IF EXISTS(SELECT 1 FROM JMJobAction (NOLOCK) WHERE opType=28 AND action=1 AND clientId = 1 AND appType = 0 AND mediaAgentID = 1)
		BEGIN
			SET @oErrorString = 'Schedules will skipped because scheduler activity is disable'
			DELETE FROM #completedPattern_runTimeInfoTable
		END
		--START JOB FOR THOSE ENTRIES WHICH ARE LEFT
		SET @oErrorString = 'Failed after completing step 6'
		--ADD TM_RUNTIME TABLE
		INSERT TM_RunTime
		(patternId, occurence, flags, nextRunTime, processed, firing, nextTime)
			OUTPUT INSERTED.runTimeId, INSERTED.patternId
				INTO @runTimeTable
		SELECT R.patId, 1, 0, @nowTime, 0, 0, @nowTimeUnix
		FROM #completedPattern_runTimeInfoTable R
		SET @oErrorString = 'Failed after completing step 7'
		--ADD TM_RUNTIMEASSOC TABLE
		INSERT TM_RunTimeAssoc
		(runTimeId, timeZoneNames, nextRunTime, flags, processed, firing)
		SELECT RT.runTimeId, @timeZoneName, @nowTime, 0, 0, 0
		FROM TM_RunTime RT WITH (NOLOCK)
		JOIN #completedPattern_runTimeInfoTable R ON R.patId = RT.patternId AND RT.processed = 0
		JOIN @runTimeTable T ON T.runTimeId = RT.runTimeId		--REGULAR SCHEDULES ALREDAY HAVE AN ENTRY IN TM_RunTime WITH processed = 0. ONLY INSERT NEW ENTRIES ADDED ABOVE
		SET @oErrorString = ''
	END
EXIT_SP:
	IF @oErrorCode = 0
	BEGIN
		IF @logChanges = 1 AND EXISTS(SELECT 1 FROM @runTimeTable)
			SET @oErrorString = (
			SELECT @oErrorString '@info',
			(
				SELECT
				(
					SELECT RI.taskId '@taskId', RI.stId '@subTaskId', RI.patId '@patternId', R.runTimeId '@runTimeId'
					FOR XML PATH('subTaskInfo'), TYPE
				)
				FROM #completedPattern_runTimeInfoTable RI
				LEFT OUTER JOIN @runTimeTable R ON R.patternId = RI.patId
				FOR XML PATH(''), TYPE
			)
			FOR XML PATH('LoggingAfterJobCompletesResponse')
		)
		ELSE
			SET @oErrorString = ''
	END
	IF object_id('tempdb.dbo.#completedPattern_initInfoTable') is not null
		DROP TABLE #completedPattern_initInfoTable
	IF object_id('tempdb.dbo.#completedPattern_IdaInfoTable') is not null
		DROP TABLE #completedPattern_IdaInfoTable
	IF object_id('tempdb.dbo.#completedPattern_runTimeInfoTable') is not null
		DROP TABLE #completedPattern_runTimeInfoTable
	IF object_id('tempdb.dbo.#completedPattern_InfoTable') is not null
		DROP TABLE #completedPattern_InfoTable
	IF object_id('tempdb.dbo.#auxCopyTable') is not null
		DROP TABLE #auxCopyTable
	IF object_id('tempdb.dbo.#output_IdaInfoTable') is not null
		DROP TABLE #output_IdaInfoTable
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetJobCompletedPatterns')
	delete from GxQscripts where name = 'TM_GetJobCompletedPatterns'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetJobCompletedPatterns')
	delete from GXDBVersions where aliasname = 'TM_GetJobCompletedPatterns'
GO

insert into GXDBVersions values(2, 'TM_GetJobCompletedPatterns',  'v1.27.2.80.16.1', 'TM_GetJobCompletedPatterns', 'v1.27.2.80.16.1')
GO

