

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetEmailShareDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetEmailShareDetails.sp,v $ $Id: TM_GetEmailShareDetails.sp,v 1.7.2.2 2018/03/27 08:48:01 jiechen Exp $";
-- =============================================
-- Author:		Jaya Rama Raju Inavolu
-- Create date: 08/19/2013
-- Description:	To get the email server details
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_GetEmailShareDetails <<<'

IF EXISTS (select * from sysobjects where name='TM_GetEmailShareDetails')
	drop procedure TM_GetEmailShareDetails
IF EXISTS (select * from GxQscripts where name='TM_GetEmailShareDetails')
	delete from GxQscripts where name = 'TM_GetEmailShareDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetEmailShareDetails')
	delete from GXDBVersions where aliasname = 'TM_GetEmailShareDetails'
GO
print '... Creating Procedure: TM_GetEmailShareDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_GetEmailShareDetails
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @commcellId int,
  @mailSizeInKB bigint,
  @userGUID varchar(256),
  @localeId int,
  @personalMessage NVARCHAR(MAX)
AS
  DECLARE @smtpAddress nvarchar(256)
  DECLARE @smtpPort int
  DECLARE @displayName nvarchar(256)
  DECLARE @strFrom nvarchar(256)
  DECLARE @smtpUserName nvarchar(256)
  DECLARE @smtpPassword nvarchar(256)
  DECLARE @smtpSSL int
  DECLARE @reqCred int
  DECLARE @userName nvarchar(256)
  DECLARE @strSubject nvarchar(256)
  DECLARE @strBody nvarchar(1024)
BEGIN
	DECLARE @emailShareSizeToAttach	int
	DECLARE @paramMsgId			INT
	DECLARE @emailMsg			NVARCHAR(MAX) = ''
	DECLARE @clickMsg			NVARCHAR(MAX) = ''
	DECLARE @emailWithUrl		NVARCHAR(MAX) = '<table style="width: 90%; background:#F4F4F4; border: 1px solid black;"><tr><td style="mso-line-height-rule:exactly; line-height:25px;">{@SENDERMESSAGE}<br/>{@DOWNLOADMEASSAGE}</td> </tr><tr><td style="border-top: 1px solid black; mso-line-height-rule:exactly; line-height:25px;"><br/>{@LINKMESSAGE}<br/>{@COMMENTS}<br/>{@CONTACTUSMESSAGE}</a></td></tr></table>'
	DECLARE @emailWithAttach	NVARCHAR(MAX) = '<table style="width: 90%; background:#F4F4F4; border: 1px solid black;"><tr><td style="mso-line-height-rule:exactly; line-height:25px;">{@SENDERMESSAGE}<br/>{@ATTACHEDMEASSAGE}</td></tr><tr><td style="mso-line-height-rule:exactly; line-height:25px;"><br/>{@COMMENTS}<br/>{@CONTACTUSMESSAGE}</a></td></tr></table>'
	SET @smtpAddress  = ISNULL((SELECT smtpServer from APP_CommCell with (nolock) where id = @commcellId),'')
	SET @smtpPort     = ISNULL((select cast(value as int) From GXGlobalParam with (nolock) where name = 'EVSMTPport' and modified = 0),0)
	SET @displayName = ISNULL((select cast(value as nvarchar(256)) From GXGlobalParam with (nolock) where name = 'EVSMTPDisplayName' and modified = 0),'')
	SET @strFrom     = ISNULL((select cast(email as nvarchar(256)) From UMUsers where userGuid = @userGUID), '')
	if @strFrom is null or @strFrom=''
	begin
		SET @strFrom     = ISNULL((select cast(value as nvarchar(256)) From GXGlobalParam with (nolock) where name = 'EVSMTPSender' and modified = 0),'')
	end
	SET @smtpPassword = ISNULL((select cast(value as nvarchar(256)) From GXGlobalParam with (nolock) where name = 'EVSMTPPassword' and modified = 0),'')
	SET @smtpUserName = ISNULL((select cast(value as nvarchar(256)) From GXGlobalParam with (nolock) where name = 'EVSMTPUsername' and modified = 0),'')
	SET @smtpSSL     = ISNULL((select cast(value as int) From GXGlobalParam with (nolock) where name = 'EVSMTPSSL' and modified = 0),0)
	SET @reqCred     = ISNULL((select cast(value as int) From GXGlobalParam with (nolock) where name = 'EVSMTPIsCredentialRequired' and modified = 0),0)
	SET @userName    = ISNULL((select cast(login as nvarchar(256)) From UMUsers where userGuid = @userGUID), '')
	SET @emailShareSizeToAttach = ISNULL((select cast(value as int) From GXGlobalParam(NOLOCK) Where name = 'EMailShareSizeInKB' and modified = 0), 3*1024) --Default 3MB
SET @paramMsgId = (2520 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @strSubject = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=@paramMsgId and LocaleID=@localeId)
	SET @strSubject = REPLACE(@strSubject, '^1%s', @userName)
	SET @strSubject = ISNULL((select cast(value as nvarchar(256)) From GXGlobalParam with (nolock) where name = 'EMailShareSubject' and modified = 0), @strSubject)
	IF @mailSizeInKB > @emailShareSizeToAttach
		SET @strBody = ISNULL((select cast(value as nvarchar(1024)) From GXGlobalParam(NOLOCK) Where name = 'EMailShareBody1' and modified = 0), @emailWithUrl) -- With URL link
	ELSE
		SET @strBody = ISNULL((select cast(value as nvarchar(1024)) From GXGlobalParam(NOLOCK) Where name = 'EMailShareBody2' and modified = 0), @emailWithAttach) -- As attachment
SET @paramMsgId = (2514 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @emailMsg = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=@paramMsgId and LocaleID=@localeId)
	SET @emailMsg = REPLACE(@emailMsg, '^1%s', '{@SENDER}')
	SET @strBody = REPLACE(@strBody, '{@SENDERMESSAGE}', @emailMsg)
SET @paramMsgId = (2515 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @emailMsg = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=@paramMsgId and LocaleID=@localeId)
	SET @strBody = REPLACE(@strBody, '{@DOWNLOADMEASSAGE}', @emailMsg)
SET @paramMsgId = (2516 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @clickMsg = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=@paramMsgId and LocaleID=@localeId)
	SET @clickMsg = REPLACE(@clickMsg, '^1%s', '<a href="{@LINK}">')
	SET @clickMsg = REPLACE(@clickMsg, '^2%s', '</a> ')
SET @paramMsgId = (2517 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @emailMsg = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=@paramMsgId and LocaleID=@localeId)
	SET @emailMsg = REPLACE(@emailMsg, '^1%s', '{@TIMESTAMP}')
	SET @emailMsg = REPLACE(@emailMsg, '^2%s', @clickMsg)
	SET @strBody = REPLACE(@strBody, '{@LINKMESSAGE}', @emailMsg)
SET @paramMsgId = (2518 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @emailMsg = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=@paramMsgId and LocaleID=@localeId)
	SET @emailMsg = REPLACE(@emailMsg, '^1%s', '<a href="{@CONTACTUS}">')
	SET @strBody = REPLACE(@strBody, '{@CONTACTUSMESSAGE}', @emailMsg)
SET @paramMsgId = (2519 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @emailMsg = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=@paramMsgId and LocaleID=@localeId)
	SET @strBody = REPLACE(@strBody, '{@ATTACHEDMEASSAGE}', @emailMsg)
	IF LEN(@personalMessage) > 0
	BEGIN
SET @paramMsgId = (239 | (CAST(POWER(2, 24) AS BIGINT) * 74))
		SET @emailMsg = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=@paramMsgId and LocaleID=@localeId)
		SET @emailMsg = @emailMsg + '"' + @personalMessage + '" <br/>'
		SET @strBody = REPLACE(@strBody, '{@COMMENTS}', @emailMsg)
	END
	ELSE
	BEGIN
		SET @strBody = REPLACE(@strBody, '{@COMMENTS}', '')
	END
	SELECT @smtpAddress as smtpAddress, @smtpPort as smtpPort, @displayName as displayName, @strFrom as strFrom, @smtpUserName as smtpUserName, @smtpPassword as smtpPassword, @smtpSSL as smtpSSL, @reqCred as reqCred, @userName as userName, @strSubject as strSubject, @strBody as strBody
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetEmailShareDetails')
	delete from GxQscripts where name = 'TM_GetEmailShareDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetEmailShareDetails')
	delete from GXDBVersions where aliasname = 'TM_GetEmailShareDetails'
GO

insert into GXDBVersions values(2, 'TM_GetEmailShareDetails',  '00010007000200020000', 'TM_GetEmailShareDetails', '00010007000200020000')
GO

