

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetDataSourceTaskList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetDataSourceTaskList.sp,v $ $Id: TM_GetDataSourceTaskList.sp,v 1.1.2.2 2019/12/06 15:24:31 rengu Exp $";
-- ================================================================
-- Author:		Rohith  Engu
-- Create date: 09/20/2019
-- Description:	Get the list of schedules for Inventory (data source) id.
-- ================================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='TM_GetDataSourceTaskList')
BEGIN
	print '>>> Drop Stored Procedure: TM_GetDataSourceTaskList <<<'
	drop procedure TM_GetDataSourceTaskList
END
IF EXISTS (select * from GxQscripts where name='TM_GetDataSourceTaskList')
	delete from GxQscripts where name = 'TM_GetDataSourceTaskList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetDataSourceTaskList')
	delete from GXDBVersions where aliasname = 'TM_GetDataSourceTaskList'
GO
print '... Creating Procedure: TM_GetDataSourceTaskList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_GetDataSourceTaskList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userId integer,
  @localeId_in integer,
  @dataSourceId integer,
  @xmlText XML	OUTPUT
AS
BEGIN
SET NOCOUNT ON
	--INITIALIZATION
	DECLARE @taskTble TABLE ( taskId INT )
	DECLARE @operationFilter TABLE ( operationType INT )
	DECLARE @subTaskFilter TABLE ( subTaskType INT )
    --GET OPERATION TYPES
    INSERT  INTO @operationFilter
            SELECT  ref.value('@val', 'int') AS operationType
            FROM    @xmlText.nodes('TMMsg_GetTaskListReq/filter/operationTypes') R ( ref )
	IF EXISTS ( SELECT 1 FROM SEDatasource WITH(NOLOCK) WHERE DataSourceId = @dataSourceId)
	BEGIN
		INSERT INTO  @taskTble
		SELECT DISTINCT TA.taskId
		FROM TM_Task TA WITH (NOLOCK)
INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = TA.taskId AND SA.subTaskType = 1 AND SA.operationType = 5025
		INNER JOIN TM_SubTaskOptions STO WITH (NOLOCK) ON SA.subTaskId = STO.subTaskId
INNER JOIN TM_AssocEntity AE WITH(NOLOCK) ON TA.taskId = AE.taskId AND AE.entityId = @dataSourceId AND AE.assocType = 132
		INNER JOIN #entitiesWithViewSchedCapability sec ON  @userId = TA.ownerId OR
		((capabilities&1073741825) <> 0) AND
		(
			--EV_SCHEDULE_ADMIN  OR EV_VISIBILITY
			(((capabilities&1) <> 0) OR ((capabilities&1073741824) <> 0))
			AND
			(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
			)
		)
	END
	----------------------------
	--CONSTRUCT THE XML---------
	----------------------------
	SET @xmlText =
		( SELECT	 --TASKLIST
			--TASK
			[TM_Task].taskId AS 'task/@taskId' ,
			[TM_Task].taskName AS 'task/@taskName' ,
			[TM_Task].taskType AS 'task/@taskType' ,
			[TM_Task].alertId AS 'task/@alertId' ,
			[NTnotificationRule].notificationName AS 'task/@alertName' ,
			[TM_Task].ownerId AS 'task/@ownerId' ,
			[TM_Task].runUserId AS 'task/@runUserId' ,
			[TM_Task].description AS 'task/@description' ,
			USR.login AS 'task/@ownerName' ,
			[TM_Task].policyType AS 'task/@policyType' ,
			[TM_Task].GUID AS 'task/GUID',
			( SELECT -- alert
						[TM_Task].alertId AS '@alertId' ,
						NT.notificationName AS '@alertName'
				FROM    dbo.NTnotificationRule
						AS NT WITH (NOLOCK)
				WHERE   NT.id = [TM_Task].alertId
			FOR
				XML PATH('alert') ,
					TYPE
			) ,
			[TM_Task].origCCId AS 'originalCC/@commCellId',
			--TaskFlags
			[TM_Task].disabled AS 'taskFlags/@disabled' ,
			[TM_Task].uninstalled AS 'taskFlags/@uninstalled' ,
			[TM_Task].isEZOperation AS 'taskFlags/@isEZOperation',
CASE WHEN [TM_Task].flags & 0x80000 <> 0 THEN 1
			ELSE 0
			END AS 'taskFlags/@isEdiscovery',
			(
				SELECT DS.DataSourceName '@seaDataSourceName',
					   DS.DataSourceId '@seaDataSourceId',
				ASS.assoctype '@_type_'
FROM SEDatasource DS INNER JOIN TM_AssocEntity ASS (NOLOCK) ON ASS.entityId = DS.DataSourceId AND ASS.assocType = 132
				WHERE ASS.taskId = [TM_Task].taskId
				AND ASS.entityId = @dataSourceId
				FOR
					XML PATH('associations') ,
						TYPE
			) ,
			( SELECT		--SUBTASKINFO
						--TASK RUN TIME FROM TM_RunTime WITH (NOLOCK) Table
						NRT.nextTime AS '@nextScheduleTime' ,
						ABS(datediff(second, '01/01/1970', GETUTCDATE()) - datediff(second, '01/01/1970', NRT.nextRunTime)) '@relativeTime',
						--SUBTASK
						STASK.subTaskId AS 'subTask/@subTaskId' ,
						STASK.subTaskType AS 'subTask/@subTaskType' ,
						STASK.operationType AS 'subTask/@operationType' ,
						STASK.flags AS 'subTask/@flags' ,
						STASK.subTaskOrder AS 'subTask/@subTaskOrder' ,
						STASK.subTaskName AS 'subTask/@subTaskName',
						( SELECT --PATTERN
									PAT.patternId '@patternId' ,
									PAT.name '@name' ,
									PAT.flags '@flags' ,
									PAT.freq_type '@freq_type' ,
									PAT.freq_interval '@freq_interval' ,
									PAT.freq_relative_interval '@freq_relative_interval' ,
									PAT.freq_recurrence_factor '@freq_recurrence_factor' ,
									PAT.freq_subday_interval '@freq_subday_interval' ,
									PAT.skipOccurence '@skipOccurence' ,
									PAT.skipDayNumber '@skipDayNumber' ,
									PAT.local_start_date '@active_start_date' ,
									PAT.active_start_time '@active_start_time' ,
									PAT.local_end_date '@active_end_date' ,
									PAT.active_end_time '@active_end_time' ,
									PAT.active_end_occurence '@active_end_occurence' ,
									PAT.description '@description' ,
									PAT.freq_restart_interval '@freq_restart_interval',
									PAT.tzId AS 'timeZone/@TimeZoneID',
									PAT.calendarId AS 'calendar/@calendarId',
									( SELECT  --Repeat Pattern
									REP.onOccurence AS '@occurrence',
									REP.onDay AS '@onDay',
									REP.repeatOn AS '@repeatOn',
									REP.onDayNumber AS '@onDayNumber',
									1				  AS '@exception',
									REP.description AS '@description'
									FROM TM_RepeatPattern AS REP WITH (NOLOCK)
									WHERE REP.patternId = PAT.patternId
									FOR
									XML
									PATH('repeatPattern') ,
									TYPE
									)
							FROM    TM_Pattern AS PAT WITH (NOLOCK),
									TM_PatternAssoc PASOC WITH (NOLOCK)
							WHERE   [PASOC].[patternId] = PAT.[patternId]
									AND PASOC.subTaskId = STASK.subTaskId
									AND PAT.deleted = 0
						FOR
							XML PATH('pattern') ,
								TYPE
						) ,
						( SELECT  --OPTIONS
									SOPTIONS.xmlValue.query('/TMMsg_JobOption/*') AS 'options'
							FROM    TM_SubTaskXMLOptions SOPTIONS WITH (NOLOCK)
							WHERE   SOPTIONS.subTaskId = STASK.subTaskId
						FOR
							XML PATH('') ,
								TYPE
						)
				FROM      TM_subTask AS STASK WITH (NOLOCK)
						LEFT OUTER JOIN TM_PatternAssoc
							AS PAS WITH (NOLOCK) ON PAS.subTaskId = STASK.subTaskId
						LEFT OUTER JOIN TM_Pattern
							AS PAT WITH (NOLOCK) ON PAT.patternId = PAS.patternId
						LEFT OUTER JOIN TM_RunTime
							AS NRT WITH (NOLOCK) ON NRT.patternId = PAS.patternId
									AND NRT.processed = 0
				WHERE     STASK.subTaskId = PAS.subTaskId
						AND STASK.taskId = [TM_Task].taskId
						AND PAT.deleted = 0
			FOR
				XML PATH('subTasks') ,
					TYPE
			)
			FROM   dbo.TM_Task WITH (NOLOCK)
				LEFT OUTER JOIN dbo.UMUsers AS USR WITH (NOLOCK) ON dbo.TM_Task.ownerId = USR.id
				LEFT OUTER JOIN dbo.NTnotificationRule WITH (NOLOCK) ON dbo.NTnotificationRule.id = dbo.TM_Task.alertId
			WHERE  dbo.TM_Task.taskId IN ( SELECT
										taskId
										FROM
										@taskTble )
				AND ( [TM_Task].[deleted] = 0
						AND [TM_Task].[invalid] = 0
						AND [TM_Task].[uninstalled] = 0
						AND [TM_Task].[savedReport] = 0
					) --AND [TM_RunTime].[processed] = 0)
AND ( [TM_Task].[taskType] IN ( 2, 4 ) )
		FOR
			XML PATH('taskDetail') ,
			ROOT('TMMsg_GetTaskListResp')
		)
	IF @xmlText IS null
	BEGIN
		SET @xmlText = '<TMMsg_GetTaskListResp/>'
	END
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetDataSourceTaskList')
	delete from GxQscripts where name = 'TM_GetDataSourceTaskList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetDataSourceTaskList')
	delete from GXDBVersions where aliasname = 'TM_GetDataSourceTaskList'
GO

insert into GXDBVersions values(2, 'TM_GetDataSourceTaskList',  '00010001000200020000', 'TM_GetDataSourceTaskList', '00010001000200020000')
GO

