

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetContinuousPatterns.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetContinuousPatterns.sp,v $ $Id: TM_GetContinuousPatterns.sp,v 1.1.2.16.14.1 2021/01/21 05:47:19 mnatarajan Exp $";
---- ============================================================================
---- Author:		Sergio Bonilla
---- Create date:	05/10/2014
---- Description:	Add entries in runtime tables for contuous pattern schedule.
---- ============================================================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_GetContinuousPatterns')
BEGIN
	print '>>> Drop Stored Procedure: TM_GetContinuousPatterns <<<'
	drop procedure TM_GetContinuousPatterns
END
IF EXISTS (select * from GxQscripts where name='TM_GetContinuousPatterns')
	delete from GxQscripts where name = 'TM_GetContinuousPatterns'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetContinuousPatterns')
	delete from GXDBVersions where aliasname = 'TM_GetContinuousPatterns'
GO
print '... Creating Procedure: TM_GetContinuousPatterns'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_GetContinuousPatterns
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @oErrorCode integer OUTPUT,
  @oErrorString nvarchar(MAX) OUTPUT
AS
SET NOCOUNT ON
BEGIN
	DECLARE @nowTime DATETIME = GETDATE()
	DECLARE @nowUtcTime DATETIME = GETUTCDATE()
	DECLARE @nowUtcUnix INT = datediff(second, '01/01/1970', @nowUtcTime)
	DECLARE @runTimeId INT = 0
	DECLARE @nowTimeUnix INT = datediff(second, '01/01/1970', @nowTime)
	DECLARE @timeZoneName NVARCHAR(MAX) = ISNULL((SELECT dbo.GetClientTimeZone(2)), '')
	DECLARE @runTimeTable table (runTimeId INT, patternId INT)
	DECLARE @updateRunTimeTable table (runTimeId INT, patternId INT)
	DECLARE @insertRunTimeTable table (runTimeId INT, patternId INT)
DECLARE @logChanges INT = ISNULL((SELECT CAST(value AS NVARCHAR(1024)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='logContinuousSchedulesInfo'), 1)
	DECLARE @defaultSchedulePolicyRunTimeInsertInterval INT = 300
	DECLARE @schedulePolicyRunTimeInsertInterval INT = @defaultSchedulePolicyRunTimeInsertInterval
	-- Read from Gxglobalparam nContinuousRunTimeSchedPolicyFreq to overwrite schedule policy insert interval
	SELECT @schedulePolicyRunTimeInsertInterval = CAST(value AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name='nContinuousRunTimeSchedPolicyFreq' -- CV_CONTINUOUS_SCHED_POLICY_FREQ
	IF @schedulePolicyRunTimeInsertInterval<1 -- Set it to default value.
	BEGIN
		SET @schedulePolicyRunTimeInsertInterval = @defaultSchedulePolicyRunTimeInsertInterval
	END
	SET @oErrorCode = 0
	SET @oErrorString = ''
	IF object_id('tempdb.dbo.#completedPattern_runTimeInfoTable') is not null
		DROP TABLE #completedPattern_runTimeInfoTable
	CREATE TABLE #completedPattern_runTimeInfoTable (stId INT, taskId INT, patId INT, cgId INT, clId INT, appTypeId INT, instId INT, bsId INT, scId INT, lastSuccessBkupTime INT, opType INT, freq_type INT,
				tkDisabled INT, taskType INT, bkpLevel INT DEFAULT 0, useJobStartTime INT DEFAULT 0,nextBkupTime INT DEFAULT 0,
				runTimeInsertInterval INT )
	CREATE CLUSTERED INDEX #completedPattern_runTimeInfoTable_taskId_stId_Index1 ON #completedPattern_runTimeInfoTable ([taskId], [stId])
--
	IF EXISTS(SELECT 1 FROM JMJobAction (NOLOCK) WHERE opType=28 AND action=1 AND clientId = 1 AND appType = 0 AND mediaAgentID = 1)
	BEGIN
		SET @oErrorString = 'Schedules will skipped because scheduler activity is disable'
		GOTO EXIT_SP
	END
	INSERT INTO #completedPattern_runTimeInfoTable
	(stId, taskId, patId, cgId, clId, appTypeId, instId, bsId, scId, lastSuccessBkupTime, opType, freq_type, tkDisabled, taskType, runTimeInsertInterval)
	SELECT ST.subTaskId, ST.taskId, PT.patternId, AE.clientGroupId, AE.clientId, AE.apptypeId, AE.instanceId, AE.backupsetId, AE.subclientId, 0, ST.operationType, PT.freq_type, T.disabled, T.taskType,
CASE WHEN T.flags & 0x400000 >0 THEN 30 ELSE @schedulePolicyRunTimeInsertInterval END
	FROM TM_SubTask ST WITH (NOLOCK)
	JOIN TM_PatternAssoc PA WITH (NOLOCK) ON PA.subTaskId = ST.subTaskId
	JOIN TM_Pattern PT WITH (NOLOCK) ON PT.patternId = PA.patternId
	LEFT OUTER JOIN TM_AssocEntity AE WITH (NOLOCK) ON AE.taskId = ST.taskId
	JOIN TM_Task T WITH (NOLOCK) ON T.taskId = ST.taskId
	WHERE T.deleted = 0
	AND T.disabled = 0
AND PT.freq_type = 4096
	AND PT.freq_interval != 0
AND ST.operationType != 1007
	SET @oErrorString = 'Failed after completing step 1'
	IF EXISTS(SELECT * FROM #completedPattern_runTimeInfoTable)
	BEGIN
		UPDATE #completedPattern_runTimeInfoTable
		SET bkpLevel =
			CASE
WHEN T.value = 15 --_BACKUP_LEVEL_STUBBING
					THEN 2097152 /*CVBkpLevel.STUB*/
				ELSE T.value
			END
		FROM
		(
			SELECT O.value, O.subTaskId
			FROM #completedPattern_runTimeInfoTable RI
JOIN TM_SubTask S (NOLOCK) ON S.subTaskId = RI.stId AND S.operationType = RI.opType AND S.operationType = 2 --_TASK_OPERATION_TYPE_BACKUP
JOIN TM_SubTaskOptions O (NOLOCK) ON O.subTaskId = S.subTaskId AND O.optionId = 458405394	--_BACKUPOPTION_BACKUP_LEVEL
		) T
		WHERE stId = T.subTaskId
		DELETE #completedPattern_runTimeInfoTable
		FROM
		(
			--REMOVE ANY SCHEDULES WHICH RUN TIME HAS BEEN CALCULATED BUT NOT PICKED UP BY SCHEDULER
			SELECT stId subTaskId
			FROM #completedPattern_runTimeInfoTable RT
			JOIN TM_RunTime R (NOLOCK) ON R.patternId = RT.patId
			JOIN TM_Pattern P (NOLOCK) ON P.patternId = R.patternId
			--REMOVE ANY SCHEDULES WHICH RUN TIME HAS BEEN MARKED PROCESSED BUT RUN TIME ASSOC IS NOT MARKED PROCESSED. In case there is any exception in processing then runtime is marked processed but runtime assoc is marked processed. So when backup runs, this admin SP ends up
			-- inserting into runtime assoc again.
			JOIN TM_RunTimeAssoc RA (NOLOCK) ON RA.runtimeId = R.runtimeId
			WHERE R.processed = 0 OR RA.processed = 0
			UNION
			--REMOVE BACKUP SCHEDULES THAT ARE ALREADY RUNNING EXCEPT FOR EXCHANGE AGENTS WHICH CAN HAVE MULTIPLE JOBS AT SAME TIME
			SELECT RT.stId subTaskId
			FROM #completedPattern_runTimeInfoTable RT
JOIN JMBkpJobInfo (NOLOCK) BI ON BI.backupTaskId = RT.stId AND RT.taskType = 2 --_TASK_TYPE_SCHEDULE
			--ONLY CHECK RUNNING FOR SCHEDULE, POLICIES WILL HAVE SEVERAL ASSOCIATIONS SO IT'S OK IF IT'S RUNNING CHECK WILL BE DONE IN TM_GetBackupEntity
AND RT.appTypeId != 137  --_CV_APPTYPE_EXCHANGE_ONEPASS
			UNION
			--REMOVE EXCHANGE AGENTS BACKUP SCHEDULES THAT ARE ALREADY RUNNING AND BACKUP LEVEL MATCH
			SELECT RT.stId subTaskId
			FROM #completedPattern_runTimeInfoTable RT
JOIN JMBkpJobInfo (NOLOCK) BI ON BI.backupTaskId = RT.stId AND RT.taskType = 2 --_TASK_TYPE_SCHEDULE
			--ONLY CHECK RUNNING FOR SCHEDULE, POLICIES WILL HAVE SEVERAL ASSOCIATIONS SO IT'S OK IF IT'S RUNNING CHECK WILL BE DONE IN TM_GetBackupEntity
AND RT.appTypeId = 137  --_CV_APPTYPE_EXCHANGE_ONEPASS
				AND BI.bkpLevel = RT.bkpLevel
			UNION
		--REMOVE RESTORE SCHEDULES THAT ARE ALREADY RUNNING
			SELECT RT.stId subTaskId
			FROM #completedPattern_runTimeInfoTable RT
			JOIN JMRstJobInfo (NOLOCK) RI ON RI.rstTaskID = RT.stId
			UNION
		--REMOVE ADMIN SCHEDULES THAT ARE ALREADY RUNNING
			SELECT RT.stId subTaskId
			FROM #completedPattern_runTimeInfoTable RT
JOIN JMAdminJobInfoTable (NOLOCK) AI ON AI.subTaskId = RT.stId AND RT.taskType = 2 --_TASK_TYPE_SCHEDULE
			-- For schedule policies check for which entities to trigger is done in TM_GetAdminEntity
		) T
		WHERE T.subTaskId = stId
AND freq_type = 4096
		-- Compute the next run time for all backup schedules first.
		EXEC TM_ComputeNextStartTime 1,0
--
		--SET LAST RUN TIME FOR ADMIN SCHEDULES
		-- We dont consider useJobStartTime for synthetic full schedules even if set.
		UPDATE RT
		SET useJobStartTime = CASE WHEN O.Value = '1' THEN 1 ELSE 0 END
		FROM #completedPattern_runTimeInfoTable RT
JOIN TM_SubTaskOptions O (NOLOCK) ON O.subTaskId = RT.stId AND O.optionId = 414240771	--_COMMONOPTION_USE_JOB_START_TIME_FOR_CONTINUOUS_SCHEDULE
AND bkpLevel <> 4 --_BACKUP_LEVEL_SYNTHETIC_FULL
		UPDATE #completedPattern_runTimeInfoTable
			SET lastSuccessBkupTime = ISNULL(
												(SELECT CASE WHEN useJobStartTime = 0 THEN MAX(servEnd) ELSE MAX(S.servStart) END
													FROM JMAdminJobStatsTable (NOLOCK) S
													WHERE S.subTaskId = stId
												), lastSuccessBkupTime
											)
WHERE freq_type = 4096
AND opType NOT IN (1, 2, 1001, 1002, 1005, 1006)
		--SET LAST RUN TIME FOR BACKUP SCHEDULES
		UPDATE #completedPattern_runTimeInfoTable
			SET lastSuccessBkupTime = T.endDate
		FROM #completedPattern_runTimeInfoTable RIOuter
		INNER JOIN (
						SELECT RI.scId,RI.stId, RI.useJobStartTime,
						MAX(servEndDate) endDate
						FROM JMBkpStats (NOLOCK) BS
						JOIN #completedPattern_runTimeInfoTable RI ON RI.scId = BS.appId
AND RI.appTypeId != 137  --_CV_APPTYPE_EXCHANGE_ONEPASS
AND RI.taskType = 2
AND RI.appTypeId != 81  --_CV_APPTYPE_MSSQL
							AND RI.useJobStartTime = 0
						GROUP BY RI.scId,RI.stId, RI.useJobStartTime
						UNION
						SELECT RI.scId,RI.stId, RI.useJobStartTime,
						MAX(servEndDate) endDate
						FROM JMBkpStats (NOLOCK) BS
						JOIN #completedPattern_runTimeInfoTable RI ON RI.scId = BS.appId
AND RI.appTypeId = 137  --_CV_APPTYPE_EXCHANGE_ONEPASS
							AND RI.stId = BS.subTaskId
AND RI.taskType = 2
							AND RI.useJobStartTime = 0
							GROUP BY RI.scId,RI.stId, RI.useJobStartTime
						UNION
						SELECT RI.scId,RI.stId, RI.useJobStartTime,
						MAX(servEndDate) endDate
						FROM JMBkpStats (NOLOCK) BS
						JOIN #completedPattern_runTimeInfoTable RI ON RI.scId = BS.appId
AND RI.appTypeId = 81  --_CV_APPTYPE_EXCHANGE_ONEPASS
AND RI.taskType = 2
							-- For SQL Ida they allow full and TL to be run at the same time. So last backup time is dependent on backup level. For Tl backup level defined at schedule, last backup time is last TL backup time on subclient.
							-- For full/differential schedule, last backup time is full/differential TL backup time on Sc.
							AND (dbo.GetBackupLevel(RI.bkpLevel) = BS.bkpLevel )  --_CV_APPTYPE_MSSQL
							AND RI.useJobStartTime = 0
							GROUP BY RI.scId,RI.stId, RI.useJobStartTime
					) T
ON RIOuter.freq_type = 4096
AND RIOuter.taskType = 2
AND RIOuter.opType IN (1, 2)
		AND RIOuter.scId = T.scId
		AND RIOuter.stId = T.stId
		AND RIOuter.useJobStartTime = T.useJobStartTime
		-- For backup schedules where useJobStartTime is set set the next backup time.
		UPDATE #completedPattern_runTimeInfoTable
			SET nextBkupTime = T.endDate
		FROM #completedPattern_runTimeInfoTable RIOuter
		INNER JOIN
		(
			-- Find next run time from app_subclientprop
			SELECT RI.scId,RI.stId, RI.useJobStartTime,
			MAX(NextScProp.attrVal) endDate
			FROM App_SubclientProp (NOLOCK) NextScProp
			JOIN #completedPattern_runTimeInfoTable RI ON RI.scId = NextScProp.componentNameId
				AND RI.useJobStartTime = 1
				AND NextScProp.cs_attrName = Checksum(N'Next backup start time Continuous '+CONVERT(NVARCHAR(10),RI.stId ))  -- CV_SC_PROP_NEXT_BACKUP_START_TIME
				AND NextScProp.attrName = 'Next backup start time Continuous '+CONVERT(NVARCHAR(10),RI.stId ) -- CV_SC_PROP_NEXT_BACKUP_START_TIME
				AND NextScProp.modified = 0
				GROUP BY RI.scId,RI.stId, RI.useJobStartTime
		) T
ON RIOuter.freq_type = 4096
AND RIOuter.taskType = 2
AND RIOuter.opType IN (1, 2)
		AND RIOuter.scId = T.scId
		AND RIOuter.stId = T.stId
		AND RIOuter.useJobStartTime = T.useJobStartTime
		--SET LAST RUN TIME FOR RESTORE SCHEDULES
		UPDATE RI
			SET lastSuccessBkupTime = ISNULL(
												(
													SELECT MAX(endDate)
													FROM
													(
														SELECT CASE WHEN useJobStartTime = 0 THEN MAX(servEndTime) ELSE MAX(servStartTime) END endDate
														FROM JMRestoreStats (NOLOCK) RS WHERE RI.bsId = RS.bkpSetID
													) T
												), 0
											)
			FROM #completedPattern_runTimeInfoTable RI
WHERE freq_type = 4096
AND taskType = 2
AND opType IN (1001, 1002, 1005, 1006)
		--REMOVE ANY RUNTIME FOR WHICH INTERVAL TIME HAS NOT PASSED
		DELETE #completedPattern_runTimeInfoTable
		FROM
		(
			SELECT taskId tkId, taskType
			FROM #completedPattern_runTimeInfoTable RT
JOIN TM_PatternAssoc (NOLOCK) PA ON PA.subTaskId = RT.stId AND RT.freq_type = 4096
			JOIN TM_Pattern (NOLOCK) P ON P.patternId = PA.patternId
			WHERE (P.freq_interval*60)+RT.lastSuccessBkupTime > @nowUtcUnix
		) T
WHERE freq_type = 4096
AND T.taskType = 2
		AND taskId = T.tkId
		-- For schedules where next run time attribute is set we honour that instead of looking at last backup time.
		AND nextBkupTime = 0
		DELETE #completedPattern_runTimeInfoTable
WHERE freq_type = 4096
AND taskType = 2
		-- For schedules where next run time attribute is set we honour that instead of looking at last backup time.
		AND nextBkupTime > 0
		AND nextBkupTime > @nowUtcUnix
		-- For schedule policies we need to insert into run time only every 5 mins.
		-- For schedule policies, TM_GetBackupEntity handles everything.
		DELETE #completedPattern_runTimeInfoTable
		FROM
		(
			-- First we identify all subtasks which have run time still not processed. We need to remove from temp table since
			-- we dont need to insert into TM_runtime again.
			SELECT RT.stId subtaskId,RT.taskType
			FROM #completedPattern_runTimeInfoTable RT
JOIN TM_PatternAssoc (NOLOCK) PA ON PA.subTaskId = RT.stId AND RT.freq_type = 4096
			JOIN TM_Pattern (NOLOCK) P ON P.patternId = PA.patternId
			JOIN TM_RunTime (NOLOCK) RNonProcessed ON RNonProcessed.patternId = P.patternId AND RNonProcessed.processed = 0
WHERE RT.taskType = 4
			-- We identify all subtasks which have run time processed less than 5 mins before.
			UNION
			SELECT RT.stId subtaskId,RT.taskType
			FROM #completedPattern_runTimeInfoTable RT
JOIN TM_PatternAssoc (NOLOCK) PA ON PA.subTaskId = RT.stId AND RT.freq_type = 4096
			JOIN TM_Pattern (NOLOCK) P ON P.patternId = PA.patternId
			JOIN TM_RunTime (NOLOCK) RProcessed ON RProcessed.patternId = P.patternId AND RProcessed.processed = 1
WHERE RT.taskType = 4
			GROUP BY RT.stId,RT.taskType
			HAVING MAX(RProcessed.nextTime)+MAX(RT.RuntimeInsertInterval) > @nowUtcUnix
		) T
WHERE freq_type = 4096
AND T.taskType = 4
		AND stId = T.subtaskId
		--START JOB FOR THOSE ENTRIES WHICH ARE LEFT
		SET @oErrorString = 'Failed after completing step 6'
		--Update TM_RUNTIME TABLE for existing runtimes and add if new schedule
		UPDATE RT
		  SET
			  RT.occurence = RT.occurence + 1,
			  RT.flags = 0,
			  RT.nextRunTime = @nowUtcTime,
			  RT.processed = 0,
			  RT.firing = 0,
			  RT.nextTime = @nowUtcUnix
		OUTPUT INSERTED.runTimeId,
			   INSERTED.patternId
			   INTO @updateRunTimeTable
		FROM TM_RunTime RT WITH(NOLOCK)
			 INNER JOIN #completedPattern_runTimeInfoTable R ON RT.patternId = R.patId
			 INNER JOIN
			 (
	 			SELECT MAX(RTInner.runtimeId) rtId, RTInner.patternId patId
	 			FROM TM_Runtime RTInner WITH(NOLOCK)
	 				 INNER JOIN #completedPattern_runTimeInfoTable RInner ON RInner.patId = RTInner.patternId
	 																		 AND RTInner.processed = 1
				GROUP BY RTInner.patternId
			 ) T ON T.rtId = RT.runTimeId AND T.patId = RT.patternId
		UPDATE RTA
			SET
				RTA.nextRunTime = @nowTime,
				RTA.timeZoneNames = @timeZoneName,
				RTA.processed = 0,
				RTA.firing = 0
		FROM TM_RunTimeAssoc RTA
		INNER JOIN
			 (
	 			SELECT MAX(RTAInner.nextRuntime) nextRuntime, RTAInner.runTimeAssocId rtaId, RTAInner.runTimeId runTimeId
	 			FROM TM_RuntimeAssoc RTAInner WITH(NOLOCK)
	 				 JOIN @updateRunTimeTable  RInner ON RInner.runtimeId = RTAInner.runtimeId
				GROUP BY RTAInner.runTimeAssocId, RTAInner.runTimeId
			 )T ON T.rtaId= RTA.runTimeAssocId
			 WHERE RTA.nextRunTime = T.nextRunTime
			 AND RTA.runTimeId = T.runTimeId
		INSERT TM_RunTime
		(patternId, occurence, flags, nextRunTime, processed, firing, nextTime)
			OUTPUT INSERTED.runTimeId, INSERTED.patternId
				INTO @insertRunTimeTable
		SELECT DISTINCT R.patId, 1, 0, @nowUtcTime, 0, 0, @nowUtcUnix
		FROM #completedPattern_runTimeInfoTable R
		LEFT JOIN @updateRunTimeTable RT ON RT.patternId = R.patId
		WHERE RT.patternId IS NULL
		SET @oErrorString = 'Failed after completing step 7'
		--ADD TM_RUNTIMEASSOC TABLE
		--REGULAR SCHEDULES ALREDAY HAVE AN ENTRY IN TM_RunTime WITH processed = 0. ONLY INSERT NEW ENTRIES ADDED
		INSERT TM_RunTimeAssoc
		(runTimeId, timeZoneNames, nextRunTime, flags, processed, firing)
		SELECT DISTINCT RT.runTimeId, @timeZoneName, @nowTime, 0, 0, 0
		FROM TM_RunTime RT WITH (NOLOCK)
		JOIN #completedPattern_runTimeInfoTable R ON R.patId = RT.patternId
		JOIN @insertRunTimeTable T ON T.runTimeId = RT.runTimeId
		INSERT INTO @runTimeTable
		SELECT runtimeId, patternId FROM @updateRunTimeTable
		UNION
		SELECT runtimeId, patternId FROM @insertRunTimeTable
	END
	SET @oErrorString = ''
EXIT_SP:
	IF @oErrorCode = 0
	BEGIN
		IF @logChanges = 1 AND EXISTS(SELECT 1 FROM @runTimeTable)
			SET @oErrorString = (
			SELECT @oErrorString '@info',
			(
				SELECT
				(
					SELECT RI.taskId '@taskId', RI.stId '@subTaskId', RI.patId '@patternId', R.runTimeId '@runTimeId'
					FOR XML PATH('subTaskInfo'), TYPE
				)
				FROM #completedPattern_runTimeInfoTable RI
				LEFT OUTER JOIN @runTimeTable R ON R.patternId = RI.patId
				FOR XML PATH(''), TYPE
			)
			FOR XML PATH('LoggingContinuousResponse')
		)
		ELSE
			SET @oErrorString = ''
	END
	IF object_id('tempdb.dbo.#completedPattern_runTimeInfoTable') is not null
		DROP TABLE #completedPattern_runTimeInfoTable
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetContinuousPatterns')
	delete from GxQscripts where name = 'TM_GetContinuousPatterns'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetContinuousPatterns')
	delete from GXDBVersions where aliasname = 'TM_GetContinuousPatterns'
GO

insert into GXDBVersions values(2, 'TM_GetContinuousPatterns',  'v1.1.2.16.14.1', 'TM_GetContinuousPatterns', 'v1.1.2.16.14.1')
GO

