

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetCommCellTaskList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetCommCellTaskList.sp,v $ $Id: TM_GetCommCellTaskList.sp,v 1.23.2.34.4.1 2021/01/13 14:35:33 mnatarajan Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 02/14/2012
-- Description:	Get the list of schedules at CS level.
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_GetCommCellTaskList')
BEGIN
	print '>>> Drop Stored Procedure: TM_GetCommCellTaskList <<<'
	drop procedure TM_GetCommCellTaskList
END
IF EXISTS (select * from GxQscripts where name='TM_GetCommCellTaskList')
	delete from GxQscripts where name = 'TM_GetCommCellTaskList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetCommCellTaskList')
	delete from GXDBVersions where aliasname = 'TM_GetCommCellTaskList'
GO
print '... Creating Procedure: TM_GetCommCellTaskList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_GetCommCellTaskList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userId integer,
  @localeId_in integer,
  @xmlText XML	OUTPUT
AS
BEGIN
SET NOCOUNT ON
	DECLARE @isUserAdmin INT = 0
	DECLARE @isCalendar INT = 0
	DECLARE @taskId INT
	DECLARE @subTaskId INT
	DECLARE @EZPolicyFilter INT = 0
	DECLARE @optionId BIGINT = 0
	DECLARE @optionVal NVARCHAR(MAX) = ''
	DECLARE @clientType INT =3
	DECLARE @schedulePolicyId INT = 0
--INITIALIZATION
	DECLARE @operationFilter TABLE ( operationType INT )
	DECLARE @subTaskFilter TABLE ( subTaskType INT )
	DECLARE @entityCount TABLE ( taskId INT, nCount INT )
	DECLARE @optionFilter TABLE (optionId BIGINT, value NVARCHAR(MAX))
	DECLARE @isSystem INT = 0
	DECLARE @getAllDetails INT = 0
	SET @schedulePolicyId = ISNULL(( SELECT ref.value('@schedulePolicyId', 'int')
							FROM @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
							), 0)
	IF object_id('tempdb.dbo.#taskTble') is not null
		DROP TABLE #taskTble
	CREATE TABLE #taskTble (
		taskId		INT,
		subTaskId	INT,
		taskType	INT
		PRIMARY KEY (taskId, subTaskId)
	)
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	EXECUTE sec_isUserAdmin   @i_userid = @userId ,@o_isUserAdmin = @isUserAdmin  OUTPUT
	-- 2048 is Data protection capability
	-- 4 is agent scheduling capability
	-- 1073741824 is View capability
	-- Compute all commcell level capability checks here for performance improvement. Using them in queries below causes performance issues.
	DECLARE @doesUserHaveCCBackupCap	INT = 0
	DECLARE @doesUserHaveCCAdminCap		INT = 0
	DECLARE @doesUserHaveCCReportCap	INT = 0
	DECLARE @canUserSeeAllAdminSchedules INT = 0
	DECLARE @canUserSeeAllReports		INT = 0
	DECLARE @doesUserHaveCCViewCap INT = 0
DECLARE @_EV_VIEW                   BIGINT = POWER(2, 31-1)
DECLARE @_EV_SCHEDULE_APPLICATION   INT = POWER(2, 3-1)
DECLARE @_EV_BACKUP                 INT = POWER(2, 12-1)
DECLARE @_EV_SCHEDULE_ADMIN			INT = POWER(2, 1-1)
	DECLARE @defaultTaskIdForDA INT = 0
	SELECT @defaultTaskIdForDA = TM_Task.taskID FROM TM_Task (NOLOCK)
WHERE deleted = 0 AND (flags & 0x10000 ) <> 0
	DECLARE @doesUserHaveCCRestoreCap INT = 0
	IF EXISTS(SELECT 1 FROM #entitiesWithViewSchedCapability sec WHERE
			( (((capabilities& @_EV_BACKUP) <> 0) AND ((capabilities & @_EV_SCHEDULE_APPLICATION) <> 0)) OR ((capabilities&@_EV_VIEW) <> 0)) AND
( sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0 )
		)
	BEGIN
		SET @doesUserHaveCCBackupCap = 1
	END
	IF EXISTS(SELECT 1 FROM #entitiesWithViewSchedCapability sec WHERE
            ( (capabilities & @_EV_VIEW) <> 0)
AND ( sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0 )
		)
    BEGIN
        SET @doesUserHaveCCViewCap = 1
    END
	IF EXISTS(SELECT 1 FROM #entitiesWithViewSchedCapability sec WHERE
			( (capabilities& @_EV_SCHEDULE_ADMIN) <> 0 OR (capabilities & @_EV_VIEW) <> 0) AND
( sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0 )
		)
	BEGIN
		SET @doesUserHaveCCAdminCap = 1
	END
	IF EXISTS(SELECT 1 FROM #entitiesWithViewSchedCapability sec
				WHERE sec.capabilities&16384=16384	--EV_MANAGE_USER
				AND
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
			)
	BEGIN
		SET @doesUserHaveCCReportCap = 1
	END
	IF EXISTS(SELECT 1 FROM #entitiesWithViewSchedCapability sec
			WHERE --EV_SCHEDULE_ADMIN OR EV_VISIBILITY
					(
						((capabilities & 1) <> 0) OR ((capabilities&1073741824) <> 0)
					)
					AND
					(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
					)
			)
	BEGIN
		SET @canUserSeeAllAdminSchedules = 1
	END
	IF EXISTS(SELECT 1 FROM #entitiesWithViewSchedCapability sec
						WHERE
						--EV_SCHEDULE_ADMIN OR EV_RUN_REPORTS  OR EV_VISIBILITY
						(
							((capabilities & 1) <> 0) OR ((capabilities & 16384) <> 0) OR ((capabilities&1073741824) <> 0)
						)
						AND
						(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
						)
	)
	BEGIN
		SET @canUserSeeAllReports = 1
	END
	IF EXISTS(SELECT 1 FROM #entitiesWithViewSchedCapability sec WHERE
			--( ((EV_RESTORE_IN_PLACE OR EV_RESTORE_OUTOF_PLACE) AND (EV_MANAGE_APPLICATION)) OR EV_VISIBILITY)
			(
				( ( ( (capabilities&524288) <> 0) OR ((capabilities&2097152) <> 0)) AND ((capabilities & 4) <> 0))  OR ((capabilities&1073741824) <> 0)
			) AND
( sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0 )
		)
	BEGIN
		SET @doesUserHaveCCRestoreCap = 1
	END
	--IF object_id('tempdb.dbo.#entitiesWithViewSchedCapability') is not null
	--	DROP TABLE #entitiesWithViewSchedCapability
	--create table #entitiesWithViewSchedCapability ( [capabilities] bigint NOT null, [flag] int NOT null default 0, [commCellId] int NOT null, [clientGroupId] int NOT null, [clientId] int NOT null, [appTypeId] int NOT null, [instanceId] int NOT null, [backupsetId] int NOT null, [subClientId] int NOT null, [mediaAgentId] int NOT null, [libraryId] int NOT null, [archGroupId] int NOT null, [vtContainerId] int NOT null, [vtPolicyId] int NOT null, [vtShelfId] int NOT null, [reviewSetId] int NOT null default 0, [querySetId] int NOT null default 0, [downloadSetId] int NOT null default 0, [ermId] int NOT null default 0, [legalHoldId] int NOT null default 0, [tagId] int NOT null default 0, [cdPolicyId] int NOT null default 0, [complianceReportId] int NOT null default 0, [taskId]        int	NOT null default 0)
	--EXEC sec_getUserObjects @userId, 0, 0, '#entitiesWithViewSchedCapability'
	-- needed so that we can join on a user with no privilages
	--IF (SELECT COUNT(*) FROM #entitiesWithViewSchedCapability) = 0
	--AVOID DUPLICATE ROWS WHEN CHECKING OWNER
	--BEGIN
	--	INSERT INTO #entitiesWithViewSchedCapability (capabilities, flag, commCellId, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subClientId,
	--	mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId, reviewSetId, querySetId, downloadSetId, ermId, legalHoldId, tagId, cdPolicyId, complianceReportId, taskId)
	--	VALUES (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
	--END
	--CREATE THE TEMP TABLE--
	IF OBJECT_ID('tempdb.dbo.#Assocociations') IS NOT null
		DROP TABLE #Assocociations
	CREATE TABLE #Assocociations
	(
			assocType INT,
			taskId INT,
			clientGroupId INT,
			clientId INT,
			apptypeId INT,
			instanceId INT,
			backupsetId INT,
			subclientId INT,
			policyId INT,
			copyId INT,
			mediaAgentId INT,
			srmReportSet INT,
			srmReportType INT,
			trackingPolicyId INT,
			agentlessPolicyId INT,
			workflowId INT,
			sidbStoreId INT,
			exclude INT,
			planID INT
	)
	IF OBJECT_ID('tempdb.dbo.#AdminAssocociations') IS NOT null
		DROP TABLE #AdminAssocociations
	CREATE TABLE #AdminAssocociations
	(
			assocType INT,
			taskId INT,
			clientGroupId INT,
			clientId INT,
			apptypeId INT,
			instanceId INT,
			backupsetId INT,
			subclientId INT,
			policyId INT,
			copyId INT,
			mediaAgentId INT,
			srmReportSet INT,
			srmReportType INT,
			trackingPolicyId INT,
			agentlessPolicyId INT,
			workflowId INT,
			sidbStoreId INT,
			exclude INT,
			ownerId INT
	)
	CREATE INDEX AdminAssocociations_taskId_clientId_clientGroupId_Idx ON #AdminAssocociations(taskId, clientId, clientGroupId)
	IF OBJECT_ID('tempdb.dbo.#BackupAssocociations') IS NOT null
		DROP TABLE #BackupAssocociations
	CREATE TABLE #BackupAssocociations
	(
			assocType INT,
			taskId INT,
			clientGroupId INT,
			clientId INT,
			apptypeId INT,
			instanceId INT,
			backupsetId INT,
			subclientId INT,
			policyId INT,
			copyId INT,
			mediaAgentId INT,
			srmReportSet INT,
			srmReportType INT,
			trackingPolicyId INT,
			agentlessPolicyId INT,
			workflowId INT,
			sidbStoreId INT,
			exclude INT,
			ownerId INT,
			planID INT
	)
	CREATE INDEX BackupAssocociations_taskId_clientId_clientGroupId_Idx ON #BackupAssocociations(taskId, clientId, clientGroupId)
	IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
		DROP TABLE #AssocEntity
	CREATE TABLE #AssocEntity
	(
			assocType INT,
			taskId INT,
			clientGroupId INT,
			clientId INT,
			apptypeId INT,
			instanceId INT,
			backupsetId INT,
			subclientId INT,
			policyId INT,
			policyName NVARCHAR(1024),
			copyId INT,
			mediaAgentId INT,
			mediaAgentName NVARCHAR(1024),
			srmReportSet INT,
			srmReportType INT,
			srmReportName NVARCHAR(1024),
			copyName  NVARCHAR(1024),
			clientGroupName  NVARCHAR(1024),
			clientName  NVARCHAR(1024),
			displayName  NVARCHAR(1024),
			appTypeName  NVARCHAR(1024),
			subclientName  NVARCHAR(1024),
			backupsetName  NVARCHAR(1024),
			instanceName NVARCHAR(1024),
			trackingPolicyId INT,
			agentlessPolicyId INT,
			workflowId INT,
			workflowName NVARCHAR(1024),
			sidbStoreId int,
			sidbStoreName NVARCHAR(1024),
			exclude INT,
			timeZoneId INT,
			timeZoneName NVARCHAR(1024),
			jobStartTime INT DEFAULT -1,
			planID INT,
			PlanName NVARCHAR(1024)
	)
	IF object_id('tempdb.dbo.#taskList') is not null
		DROP TABLE #taskList
	CREATE TABLE #taskList (taskId INT NOT NULL)
	IF object_id('tempdb.dbo.#displayNameSubtaskXML') is not null
		DROP TABLE #displayNameSubtaskXML
	CREATE TABLE #displayNameSubtaskXML (subtaskId INT NOT NULL, xmlValue XML)
	IF object_id('tempdb.dbo.#clientAndCG') is not null
		DROP TABLE #clientAndCG
	CREATE TABLE #clientAndCG(subtaskId INT, clientName NVARCHAR(MAX), displayName NVARCHAR(MAX), clientId INT, _type_ INT)
	IF object_id('tempdb.dbo.#CCGXML') is not null
		DROP TABLE #CCGXML
	CREATE TABLE #CCGXML(subtaskId INT, xmlValue XML)
	--DO BACKUP SCHEDULES SECURITY CHECK
	INSERT INTO    #BackupAssocociations
	SELECT DISTINCT dbo.TM_AssocEntity.assocType ,
			dbo.TM_AssocEntity.taskId ,
			dbo.TM_AssocEntity.clientGroupId ,
			dbo.TM_AssocEntity.clientId ,
			dbo.TM_AssocEntity.apptypeId ,
			dbo.TM_AssocEntity.instanceId ,
			dbo.TM_AssocEntity.backupsetId ,
			dbo.TM_AssocEntity.subclientId ,
			dbo.TM_AssocEntity.policyId ,
			dbo.TM_AssocEntity.copyId ,
			dbo.TM_AssocEntity.mediaAgentId,
			dbo.TM_AssocEntity.srmReportSet AS srmReportSet,
			dbo.TM_AssocEntity.srmReportType AS srmReportType,
			dbo.TM_AssocEntity.trackingPolicyId AS trackingPolicyId,
			dbo.TM_AssocEntity.agentlessPolicyId,
			dbo.TM_AssocEntity.workflowId,
			dbo.TM_AssocEntity.sidbStoreId,
			dbo.TM_AssocEntity.exclude,
			TA.ownerId,
			0
	FROM	dbo.TM_AssocEntity WITH (NOLOCK)
			INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = dbo.TM_AssocEntity.taskId
INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = dbo.TM_AssocEntity.taskId AND SA.subTaskType = 2
			AND TM_AssocEntity.assocType!=158 -- plan entity
	UNION
	SELECT 7, -- subclient association type
					@defaultTaskIdForDA ,
					0 ,
					Ref.clientId,
					Ref.appTypeId,
					Ref.instance,
					Ref.backupset,
					Ref.subclientId ,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0
		FROM dbo.TM_AssocForDefaultDATask Ref
	UNION
			--Expand association for subclients from plan
			SELECT dbo.TM_AssocEntity.assocType ,
					dbo.TM_AssocEntity.taskId ,
					dbo.TM_AssocEntity.clientGroupId ,
					App_Application.clientId ,
					App_Application.apptypeId ,
					App_Application.instance ,
					App_Application.backupset ,
					App_Application.Id ,
					dbo.TM_AssocEntity.policyId ,
					dbo.TM_AssocEntity.copyId ,
					dbo.TM_AssocEntity.mediaAgentId,
					dbo.TM_AssocEntity.srmReportSet AS srmReportSet,
					dbo.TM_AssocEntity.srmReportType AS srmReportType,
					dbo.TM_AssocEntity.trackingPolicyId AS trackingPolicyId,
					dbo.TM_AssocEntity.agentlessPolicyId,
					dbo.TM_AssocEntity.workflowId,
					dbo.TM_AssocEntity.sidbStoreId,
					dbo.TM_AssocEntity.exclude,
					TA.ownerId,
					dbo.TM_AssocEntity.entityId
			FROM	dbo.TM_AssocEntity WITH (NOLOCK)
					INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = dbo.TM_AssocEntity.taskId
INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = dbo.TM_AssocEntity.taskId AND SA.subTaskType = 2
					AND TM_AssocEntity.assoctype = 158-- plan entity
					LEFT JOIN App_SubclientProp SCP WITH(NOLOCK) ON SCP.attrName = 'Associated Plan' AND SCP.cs_attrName = CHECKSUM(N'Associated Plan')
					AND SCP.modified = 0
					AND CAST(TM_AssocEntity.entityId AS NVARCHAR(10)) = SCP.attrVal
					LEFT JOIN App_Application (NOLOCK) ON App_Application.id = SCP.componentNameId
	INSERT INTO    #Assocociations
	--FIRST LOOK AT CAPABILITIES FOR OWNER AND NON CLIENT GROUP ASSOCIATION
	SELECT  AEN.assocType ,
			AEN.taskId ,
			AEN.clientGroupId ,
			AEN.clientId ,
			AEN.apptypeId ,
			AEN.instanceId ,
			AEN.backupsetId ,
			AEN.subclientId ,
			AEN.policyId ,
			AEN.copyId ,
			AEN.mediaAgentId,
			AEN.srmReportSet AS srmReportSet,
			AEN.srmReportType AS srmReportType,
			AEN.trackingPolicyId AS trackingPolicyId,
			AEN.agentlessPolicyId,
			AEN.workflowId,
			AEN.sidbStoreId,
			AEN.exclude,
			AEN.planId
	FROM	#BackupAssocociations AEN
			INNER JOIN #entitiesWithViewSchedCapability sec ON
			((capabilities&1073743876) <> 0) AND
			(
				--((EV_BACKUP AND EV_MANAGE_APPLICATION) OR EV_VISIBILITY)
				(
					(((capabilities&2048) <> 0) AND ((capabilities & 4) <> 0)) OR ((capabilities&1073741824) <> 0))
				AND
				(
					( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
						(
							(
								AEN.clientId <> 0 AND AEN.clientId = sec.clientId
							)
						)
						AND (AEN.appTypeId     = sec.appTypeId   OR  AEN.appTypeId = 0  OR sec.appTypeId = 0 )
						AND (AEN.instanceId    = sec.instanceId  OR  AEN.instanceId  = 0  OR sec.instanceId = 0 )
						AND (AEN.backupsetId   = sec.backupSetId OR  AEN.backupsetId = 0  OR sec.backupSetId = 0 )
						AND (AEN.subclientId   = sec.subClientId OR  AEN.subclientId = 0  OR sec.subClientId = 0 )
						AND (AEN.taskId   = sec.taskId OR sec.taskId = 0 )
					)
				)
			)
--
	UNION
--
	SELECT  AEN.assocType ,
			AEN.taskId ,
			AEN.clientGroupId ,
			AEN.clientId ,
			AEN.apptypeId ,
			AEN.instanceId ,
			AEN.backupsetId ,
			AEN.subclientId ,
			AEN.policyId ,
			AEN.copyId ,
			AEN.mediaAgentId,
			AEN.srmReportSet AS srmReportSet,
			AEN.srmReportType AS srmReportType,
			AEN.trackingPolicyId AS trackingPolicyId,
			AEN.agentlessPolicyId,
			AEN.workflowId,
			AEN.sidbStoreId,
			AEN.exclude,
			AEN.planId
	FROM	#BackupAssocociations AEN
			JOIN APP_ClientGroupAssoc GA WITH (NOLOCK) ON GA.clientGroupId=AEN.clientGroupId AND AEN.clientId = 0	--MAKE SURE ASSOCIATION IS ONLY FOR CLIENT GROUP
			INNER JOIN #entitiesWithViewSchedCapability sec ON
			((capabilities&1073743876) <> 0) AND
			(
				--((EV_BACKUP AND EV_MANAGE_APPLICATION) OR EV_VISIBILITY)
				(
					(((capabilities&2048) <> 0) AND ((capabilities & 4) <> 0)) OR ((capabilities&1073741824) <> 0))
				AND
				(
					( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
						(
							(
								AEN.clientId = 0
								AND
								AEN.clientGroupId <> 0
								AND
								(	--ASSOCIATION AT CLIENT GROUP
									sec.clientGroupId = AEN.clientGroupId --SECURITY AT CLIENT GROUP
								)
							)
						)
						AND (AEN.appTypeId     = sec.appTypeId   OR  AEN.appTypeId = 0  OR sec.appTypeId = 0 )
						AND (AEN.instanceId    = sec.instanceId  OR  AEN.instanceId  = 0  OR sec.instanceId = 0 )
						AND (AEN.backupsetId   = sec.backupSetId OR  AEN.backupsetId = 0  OR sec.backupSetId = 0 )
						AND (AEN.subclientId   = sec.subClientId OR  AEN.subclientId = 0  OR sec.subClientId = 0 )
						AND (AEN.taskId   = sec.taskId OR sec.taskId = 0 )
					)
				)
			)
--
	UNION
--
	SELECT  AEN.assocType ,
			AEN.taskId ,
			AEN.clientGroupId ,
			AEN.clientId ,
			AEN.apptypeId ,
			AEN.instanceId ,
			AEN.backupsetId ,
			AEN.subclientId ,
			AEN.policyId ,
			AEN.copyId ,
			AEN.mediaAgentId,
			AEN.srmReportSet AS srmReportSet,
			AEN.srmReportType AS srmReportType,
			AEN.trackingPolicyId AS trackingPolicyId,
			AEN.agentlessPolicyId,
			AEN.workflowId,
			AEN.sidbStoreId,
			AEN.exclude,
			AEN.planId
	FROM	#BackupAssocociations AEN
			JOIN APP_ClientGroupAssoc GA WITH (NOLOCK) ON GA.clientGroupId=AEN.clientGroupId AND AEN.clientId = 0	--MAKE SURE ASSOCIATION IS ONLY FOR CLIENT GROUP
			INNER JOIN #entitiesWithViewSchedCapability sec ON
			((capabilities&1073743876) <> 0) AND
			(
				--((EV_BACKUP AND EV_MANAGE_APPLICATION) OR EV_VISIBILITY)
				(
					(((capabilities&2048) <> 0) AND ((capabilities & 4) <> 0)) OR ((capabilities&1073741824) <> 0))
				AND
				(
					( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
						(
							(
								AEN.clientId = 0
								AND
								AEN.clientGroupId <> 0
								AND
								(
									--SECURITY AT CLIENT WHICH BELONGS TO CLIENT GROUP
									(
										sec.clientId = GA.clientId
										AND	--CHECK FOR WHEN CLIENTID = 0 WILL GIVE FALSE POSITIVE WHEN ASSOCIATION IS NOT A CLIENT ENTITY
										GA.clientId > 0
									)
								)
							)
						)
						AND (AEN.appTypeId     = sec.appTypeId   OR  AEN.appTypeId = 0  OR sec.appTypeId = 0 )
						AND (AEN.instanceId    = sec.instanceId  OR  AEN.instanceId  = 0  OR sec.instanceId = 0 )
						AND (AEN.backupsetId   = sec.backupSetId OR  AEN.backupsetId = 0  OR sec.backupSetId = 0 )
						AND (AEN.subclientId   = sec.subClientId OR  AEN.subclientId = 0  OR sec.subClientId = 0 )
						AND (AEN.taskId   = sec.taskId OR sec.taskId = 0 )
					)
				)
			)
			-- Also add all associations for schedules created by user and all schedules if he has commcell level association
			UNION
			SELECT AEN.assocType ,
			AEN.taskId ,
			AEN.clientGroupId ,
			AEN.clientId ,
			AEN.apptypeId ,
			AEN.instanceId ,
			AEN.backupsetId ,
			AEN.subclientId ,
			AEN.policyId ,
			AEN.copyId ,
			AEN.mediaAgentId,
			AEN.srmReportSet AS srmReportSet,
			AEN.srmReportType AS srmReportType,
			AEN.trackingPolicyId AS trackingPolicyId,
			AEN.agentlessPolicyId,
			AEN.workflowId,
			AEN.sidbStoreId,
			AEN.exclude,
			AEN.planId
			FROM	#BackupAssocociations AEN
			WHERE @userId = AEN.ownerId OR @doesUserHaveCCBackupCap = 1
	--select * from #Assocociations
	--DO RESTORE SCHEDULES SECURITY CHECK
	INSERT INTO    #Assocociations
	SELECT dbo.TM_AssocEntity.assocType ,
			dbo.TM_AssocEntity.taskId ,
			dbo.TM_AssocEntity.clientGroupId ,
			dbo.TM_AssocEntity.clientId ,
			dbo.TM_AssocEntity.apptypeId ,
			dbo.TM_AssocEntity.instanceId ,
			dbo.TM_AssocEntity.backupsetId ,
			dbo.TM_AssocEntity.subclientId ,
			dbo.TM_AssocEntity.policyId ,
			dbo.TM_AssocEntity.copyId ,
			dbo.TM_AssocEntity.mediaAgentId,
			dbo.TM_AssocEntity.srmReportSet AS srmReportSet,
			dbo.TM_AssocEntity.srmReportType AS srmReportType,
			dbo.TM_AssocEntity.trackingPolicyId AS trackingPolicyId,
			dbo.TM_AssocEntity.agentlessPolicyId,
			dbo.TM_AssocEntity.workflowId,
			dbo.TM_AssocEntity.sidbStoreId,
			dbo.TM_AssocEntity.exclude,
			0
	FROM    dbo.TM_AssocEntity WITH (NOLOCK)
			INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = dbo.TM_AssocEntity.taskId AND TA.deleted = 0 AND TA.TaskType IN (2,4) -- schedule /schedule policy
INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = dbo.TM_AssocEntity.taskId AND SA.subTaskType=3
			INNER JOIN #entitiesWithViewSchedCapability sec ON
			((capabilities&1076363268) <> 0) AND
			(
				(
					(
						--((EV_RESTORE_IN_PLACE OR EV_RESTORE_OUTOF_PLACE) AND (EV_MANAGE_APPLICATION)) OR EV_VISIBILITY)
						(((capabilities&524288) <> 0) OR ((capabilities&2097152) <> 0)) AND ((capabilities & 4) <> 0))  OR ((capabilities&1073741824) <> 0)
					)
				AND
				(
					( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
						(
							(dbo.TM_AssocEntity.clientId <> 0 AND dbo.TM_AssocEntity.clientId = sec.clientId  )
							AND (dbo.TM_AssocEntity.appTypeId     = sec.appTypeId   OR  dbo.TM_AssocEntity.appTypeId = 0  OR sec.appTypeId = 0 )
							AND (dbo.TM_AssocEntity.instanceId    = sec.instanceId  OR  dbo.TM_AssocEntity.instanceId  = 0  OR sec.instanceId = 0 )
							AND (dbo.TM_AssocEntity.backupsetId   = sec.backupSetId OR  dbo.TM_AssocEntity.backupsetId = 0  OR sec.backupSetId = 0 )
							AND (dbo.TM_AssocEntity.subclientId   = sec.subClientId OR  dbo.TM_AssocEntity.subclientId = 0  OR sec.subClientId = 0 )
							AND (TA.taskId   = sec.taskId OR sec.taskId = 0 )
						)
					)
				)
			)
			-- Return Restore schedules where user is owner and user has Restore capability at CS level.
			UNION
			SELECT dbo.TM_AssocEntity.assocType ,
			dbo.TM_AssocEntity.taskId ,
			dbo.TM_AssocEntity.clientGroupId ,
			dbo.TM_AssocEntity.clientId ,
			dbo.TM_AssocEntity.apptypeId ,
			dbo.TM_AssocEntity.instanceId ,
			dbo.TM_AssocEntity.backupsetId ,
			dbo.TM_AssocEntity.subclientId ,
			dbo.TM_AssocEntity.policyId ,
			dbo.TM_AssocEntity.copyId ,
			dbo.TM_AssocEntity.mediaAgentId,
			dbo.TM_AssocEntity.srmReportSet AS srmReportSet,
			dbo.TM_AssocEntity.srmReportType AS srmReportType,
			dbo.TM_AssocEntity.trackingPolicyId AS trackingPolicyId,
			dbo.TM_AssocEntity.agentlessPolicyId,
			dbo.TM_AssocEntity.workflowId,
			dbo.TM_AssocEntity.sidbStoreId,
			dbo.TM_AssocEntity.exclude,
			0
	FROM    dbo.TM_AssocEntity WITH (NOLOCK)
			INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = dbo.TM_AssocEntity.taskId AND TA.deleted = 0 AND TA.TaskType IN (2,4)  -- schedule /schedule policy
INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = dbo.TM_AssocEntity.taskId AND SA.subTaskType=3
			WHERE @userId = TA.ownerId  OR @doesUserHaveCCRestoreCap = 1
			-- Not adding logic to return restore schedules where user has restore capability at CG and schedule is associatged to CG. This isnt valid case since restore schedule cannot be associated to CG
			-- Also not adding to return restore schedules where user has restore capability at client and schedule is associated to CG and client is part of CG.
			-- Not converting logic for below lines from before change
			/*
			OR
                                 (
                                     dbo.TM_AssocEntity.clientId = 0
                                     AND
                                     dbo.TM_AssocEntity.clientGroupId <> 0
                                     AND
                                     (   --ASSOCIATION AT CLIENT GROUP
                                         sec.clientGroupId = dbo.TM_AssocEntity.clientGroupId --SECURITY AT CLIENT GROUP
                                         OR --SECURITY AT CLIENT WHICH BELONGS TO CLIENT GROUP
                                         (
                                             sec.clientId = GA.clientId
                                             AND --CHECK FOR WHEN CLIENTID = 0 WILL GIVE FALSE POSITIVE WHEN ASSOCIATION IS NOT A CLIENT ENTITY
                                             GA.clientId > 0
                                         )
                                         --dbo.TM_AssocEntity.clientGroupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE clientId=sec.clientId)
                                     )
                                 )
*/
	--select * from #Assocociations
	--DO ADMIN SCHEDULES SECURITY CHECK
	INSERT INTO    #AdminAssocociations
	SELECT DISTINCT dbo.TM_AssocEntity.assocType ,
			dbo.TM_AssocEntity.taskId ,
			dbo.TM_AssocEntity.clientGroupId ,
			dbo.TM_AssocEntity.clientId ,
			dbo.TM_AssocEntity.apptypeId ,
			dbo.TM_AssocEntity.instanceId ,
			dbo.TM_AssocEntity.backupsetId ,
			dbo.TM_AssocEntity.subclientId ,
			dbo.TM_AssocEntity.policyId ,
			dbo.TM_AssocEntity.copyId ,
			dbo.TM_AssocEntity.mediaAgentId,
			dbo.TM_AssocEntity.srmReportSet AS srmReportSet,
			dbo.TM_AssocEntity.srmReportType AS srmReportType,
			dbo.TM_AssocEntity.trackingPolicyId AS trackingPolicyId,
			dbo.TM_AssocEntity.agentlessPolicyId,
			dbo.TM_AssocEntity.workflowId,
			dbo.TM_AssocEntity.sidbStoreId,
			dbo.TM_AssocEntity.exclude,
			TA.ownerId
	FROM	dbo.TM_AssocEntity WITH (NOLOCK)
			INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = dbo.TM_AssocEntity.taskId
INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = dbo.TM_AssocEntity.taskId AND SA.subTaskType IN (1, 4, 5)
	INSERT INTO    #Assocociations
	--FIRST LOOK AT CAPABILITIES FOR OWNER AND NON CLIENT GROUP ASSOCIATION
	SELECT  AEN.assocType ,
			AEN.taskId ,
			AEN.clientGroupId ,
			AEN.clientId ,
			AEN.apptypeId ,
			AEN.instanceId ,
			AEN.backupsetId ,
			AEN.subclientId ,
			AEN.policyId ,
			AEN.copyId ,
			AEN.mediaAgentId,
			AEN.srmReportSet AS srmReportSet,
			AEN.srmReportType AS srmReportType,
			AEN.trackingPolicyId AS trackingPolicyId,
			AEN.agentlessPolicyId,
			AEN.workflowId,
			AEN.sidbStoreId,
			AEN.exclude,
			0
	FROM	#AdminAssocociations AEN
			INNER JOIN #entitiesWithViewSchedCapability sec ON
			((capabilities&1073741825) <> 0) AND
			(
				--EV_SCHEDULE_ADMIN  OR EV_VISIBILITY
				(((capabilities&1) <> 0) OR ((capabilities&1073741824) <> 0))
				AND
				(
					( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
						(
							(
								AEN.clientId <> 0
								AND
								(
									AEN.clientId = sec.clientId
								)
							)
						)
						AND (AEN.policyId = sec.archGroupId OR  (AEN.policyId = 0  AND sec.archGroupId = 0) )
						AND (AEN.trackingPolicyId  = sec.vtPolicyId OR  (AEN.trackingPolicyId = 0  AND sec.vtPolicyId = 0 ))
						AND (AEN.taskId = sec.taskId OR sec.taskId = 0 )
						--IGNORE SECURITY CHECK FOR ADMIN TASK FOR NOW, IT WILL BE DONE AT THE VIEW LEVEL BELOW
						AND NOT (AEN.clientId = 0 AND AEN.clientGroupId = 0 AND AEN.appTypeId = 0
							AND AEN.instanceId = 0 AND AEN.backupsetId = 0 AND AEN.subclientId = 0
							AND AEN.MediaAgentId = 0 AND AEN.policyId = 0 AND AEN.trackingPolicyId = 0 AND AEN.copyId = 0
						)
					)
				)
			)
--
	UNION
--
	--NOW LOOK AT CAPABILITIES GIVEN AT THE CLIENT GROUP
	SELECT  AEN.assocType ,
			AEN.taskId ,
			AEN.clientGroupId ,
			AEN.clientId ,
			AEN.apptypeId ,
			AEN.instanceId ,
			AEN.backupsetId ,
			AEN.subclientId ,
			AEN.policyId ,
			AEN.copyId ,
			AEN.mediaAgentId,
			AEN.srmReportSet AS srmReportSet,
			AEN.srmReportType AS srmReportType,
			AEN.trackingPolicyId AS trackingPolicyId,
			AEN.agentlessPolicyId,
			AEN.workflowId,
			AEN.sidbStoreId,
			AEN.exclude,
			0
	FROM	#AdminAssocociations AEN
			JOIN APP_ClientGroupAssoc GA WITH (NOLOCK) ON GA.clientGroupId=AEN.clientGroupId AND AEN.clientId = 0	--MAKE SURE ASSOCIATION IS ONLY FOR CLIENT GROUP
			INNER JOIN #entitiesWithViewSchedCapability sec ON
			((capabilities&1073741825) <> 0) AND
			(
				--EV_SCHEDULE_ADMIN  OR EV_VISIBILITY
				(((capabilities&1) <> 0) OR ((capabilities&1073741824) <> 0))
				AND
				(
					( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
						(
							(
								AEN.clientId = 0
								AND
								AEN.clientGroupId <> 0
								AND
								(	--ASSOCIATION AT CLIENT GROUP
									sec.clientGroupId = AEN.clientGroupId --SECURITY AT CLIENT GROUP
								)
							)
						)
						AND (AEN.policyId = sec.archGroupId OR  (AEN.policyId = 0  AND sec.archGroupId = 0) )
						AND (AEN.trackingPolicyId  = sec.vtPolicyId OR  (AEN.trackingPolicyId = 0  AND sec.vtPolicyId = 0 ))
						AND (AEN.taskId   = sec.taskId OR sec.taskId = 0 )
						--IGNORE SECURITY CHECK FOR ADMIN TASK FOR NOW, IT WILL BE DONE AT THE VIEW LEVEL BELOW
						AND NOT (AEN.clientId = 0 AND AEN.clientGroupId = 0 AND AEN.appTypeId = 0
							AND AEN.instanceId = 0 AND AEN.backupsetId = 0 AND AEN.subclientId = 0
							AND AEN.MediaAgentId = 0 AND AEN.policyId = 0 AND AEN.trackingPolicyId = 0 AND AEN.copyId = 0
						)
					)
				)
			)
--
	UNION
--
	--NOW LOOK AT CAPABILITIES CLIENT ASSOCIATED TO THE GROUP
	SELECT  AEN.assocType ,
			AEN.taskId ,
			AEN.clientGroupId ,
			AEN.clientId ,
			AEN.apptypeId ,
			AEN.instanceId ,
			AEN.backupsetId ,
			AEN.subclientId ,
			AEN.policyId ,
			AEN.copyId ,
			AEN.mediaAgentId,
			AEN.srmReportSet AS srmReportSet,
			AEN.srmReportType AS srmReportType,
			AEN.trackingPolicyId AS trackingPolicyId,
			AEN.agentlessPolicyId,
			AEN.workflowId,
			AEN.sidbStoreId,
			AEN.exclude,
			0
	FROM	#AdminAssocociations AEN
			JOIN APP_ClientGroupAssoc GA WITH (NOLOCK) ON GA.clientGroupId=AEN.clientGroupId AND AEN.clientId = 0	--MAKE SURE ASSOCIATION IS ONLY FOR CLIENT GROUP
			INNER JOIN #entitiesWithViewSchedCapability sec ON
			((capabilities&1073741825) <> 0) AND
			(
				--EV_SCHEDULE_ADMIN  OR EV_VISIBILITY
				(((capabilities&1) <> 0) OR ((capabilities&1073741824) <> 0))
				AND
				(
					( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
						(
							(
								AEN.clientId = 0
								AND
								AEN.clientGroupId <> 0
								AND
								(	--ASSOCIATION AT CLIENT GROUP
									(
										sec.clientId = GA.clientId
										AND	--CHECK FOR WHEN CLIENTID = 0 WILL GIVE FALSE POSITIVE WHEN ASSOCIATION IS NOT A CLIENT ENTITY
										GA.clientId > 0
									)
								)
							)
						)
						AND (AEN.policyId = sec.archGroupId OR  (AEN.policyId = 0  AND sec.archGroupId = 0) )
						AND (AEN.trackingPolicyId  = sec.vtPolicyId OR  (AEN.trackingPolicyId = 0  AND sec.vtPolicyId = 0 ))
						AND (AEN.taskId   = sec.taskId OR sec.taskId = 0 )
						--IGNORE SECURITY CHECK FOR ADMIN TASK FOR NOW, IT WILL BE DONE AT THE VIEW LEVEL BELOW
						AND NOT (AEN.clientId = 0 AND AEN.clientGroupId = 0 AND AEN.appTypeId = 0
							AND AEN.instanceId = 0 AND AEN.backupsetId = 0 AND AEN.subclientId = 0
							AND AEN.MediaAgentId = 0 AND AEN.policyId = 0 AND AEN.trackingPolicyId = 0 AND AEN.copyId = 0
						)
					)
				)
			)
	-- Also add all associations for schedules created by user and all schedules if he has commcell level association
			UNION
	SELECT  AEN.assocType ,
			AEN.taskId ,
			AEN.clientGroupId ,
			AEN.clientId ,
			AEN.apptypeId ,
			AEN.instanceId ,
			AEN.backupsetId ,
			AEN.subclientId ,
			AEN.policyId ,
			AEN.copyId ,
			AEN.mediaAgentId,
			AEN.srmReportSet AS srmReportSet,
			AEN.srmReportType AS srmReportType,
			AEN.trackingPolicyId AS trackingPolicyId,
			AEN.agentlessPolicyId,
			AEN.workflowId,
			AEN.sidbStoreId,
			AEN.exclude,
			0
			FROM	#AdminAssocociations AEN
			WHERE @doesUserHaveCCAdminCap = 1 OR AEN.ownerId = @userId OR @doesUserHaveCCViewCap = 1
			UNION
	SELECT  AEN.assocType ,
			AEN.taskId ,
			AEN.clientGroupId ,
			AEN.clientId ,
			AEN.apptypeId ,
			AEN.instanceId ,
			AEN.backupsetId ,
			AEN.subclientId ,
			AEN.policyId ,
			AEN.copyId ,
			AEN.mediaAgentId,
			AEN.srmReportSet AS srmReportSet,
			AEN.srmReportType AS srmReportType,
			AEN.trackingPolicyId AS trackingPolicyId,
			AEN.agentlessPolicyId,
			AEN.workflowId,
			AEN.sidbStoreId,
			AEN.exclude,
			0
			FROM	#AdminAssocociations AEN
			INNER JOIN #entitiesWithViewSchedCapability sec ON sec.workflowID =  AEN.workflowId AND AEN.workflowId>0 -- Non admin User with view capability on any entity like client can see all admin schedules which have associations because of check. Unless we check for AEN.workflowId>0
			AND ((capabilities&@_EV_VIEW) <> 0)
			--workflow level check for workflows from TM_assocEntity
	--INSERT ENTITY INFORMATION
	if object_id('tempdb.dbo.#clientTimezoneTbl') is not null
		DROP TABLE #clientTimezoneTbl
    CREATE TABLE #clientTimezoneTbl ( clientId INT, timezoneName nvarchar(1024) primary key (clientId) )
DECLARE @pseudoClient_status BIGINT = 0x200000
SET @pseudoClient_status = @pseudoClient_status | 0x0400 | 0x0200 | 0x0040 | 0x4000000
	DECLARE @csTimezone nvarchar(max) = dbo.GetClientTimezone(2) -- CS timezone.
	-- Avoid using function to compute client timezone.
    Insert into #clientTimezoneTbl
    select distinct A.Id,
		CASE
              WHEN tz.TimeZoneId IS NOT NULL THEN tz.TimeZoneStdName
              WHEN P.componentNameId IS NOT NULL THEN RIGHT(P.attrVal, CHARINDEX(':', REVERSE(P.attrVal)) - 1)
              WHEN ( (A.status & @pseudoClient_status) > 0) OR S.ClientId IS NULL THEN @csTimezone
			  ELSE NULL
       END
    from APP_Client A
	LEFT OUTER JOIN APP_ClientProp P ON
              P.componentNameId = A.Id
              AND P.attrName = N'timezone'
              AND P.modified = 0
       LEFT OUTER JOIN APP_ClientProp P2 ON
              P2.componentNameId = A.Id
              AND P2.attrName = N'timezone id'
              AND P2.modified = 0
	   LEFT OUTER JOIN SchedTimeZone tz ON
              P2.attrVal IS NOT NULL
              AND P2.attrVal = CAST(tz.TimeZoneID AS VARCHAR(12))
		LEFT OUTER JOIN simInstalledPackages S ON S.ClientId = A.id
	INSERT INTO    #AssocEntity
	SELECT DISTINCT ASS.assocType ,
			ASS.taskId ,
			ASS.clientGroupId ,
			CASE WHEN assocType!=158 THEN ASS.clientId ELSE 0 END, -- 158 : plan_entity
			CASE WHEN assocType!=158 THEN ASS.apptypeId ELSE 0 END ,
			CASE WHEN assocType!=158 THEN ASS.instanceId ELSE 0 END,
			CASE WHEN assocType!=158 THEN ASS.backupsetId ELSE 0 END,
			CASE WHEN assocType!=158 THEN ASS.subclientId ELSE 0 END,
			ASS.policyId ,
			dbo.archGroup.name AS policyName ,
			ASS.copyId ,
			ASS.mediaAgentId,
			MAEntity.name       AS mediaAgentName,
			ASS.srmReportSet AS srmReportSet,
			ASS.srmReportType AS srmReportType,
			'' AS srmReportName,
			dbo.archGroupCopy.name AS copyName ,
			dbo.APP_ClientGroup.name AS clientGroupName ,
			CASE WHEN assocType!=158 THEN dbo.APP_Client.name ELSE NULL END AS clientName ,
			CASE WHEN assocType!=158 THEN dbo.APP_Client.displayName ELSE NULL END AS displayName ,
			CASE WHEN assocType!=158 THEN dbo.APP_iDAType.name ELSE NULL END AS appTypeName ,
			CASE WHEN assocType!=158 THEN dbo.APP_Application.subclientName ELSE NULL END,
			CASE WHEN assocType!=158 THEN dbo.APP_BackupSetName.name ELSE NULL END AS backupsetName ,
			CASE WHEN assocType!=158 THEN dbo.APP_InstanceName.name ELSE NULL END AS instanceName,
			ASS.trackingPolicyId AS trackingPolicyId,
			ASS.agentlessPolicyId,
			ASS.workflowId,
			WF.Name,
			ASS.sidbStoreId,
			IdxSIDBStore.sidbStoreName,
			ASS.exclude,
			TZ.TimeZoneId,
			TZ.TimeZoneStdName,
			-1, -- default value for job start time
			ASS.planId,
			App_Plan.name
	FROM #Assocociations ASS
			LEFT OUTER JOIN dbo.archGroup WITH (NOLOCK) ON ASS.policyId = dbo.archGroup.id AND ASS.policyId > 0
			LEFT OUTER JOIN dbo.archGroupCopy WITH (NOLOCK) ON ASS.copyId = dbo.archGroupCopy.id AND ASS.copyId >0
			--LEFT OUTER JOIN dbo.CRReportTemplates WITH (NOLOCK) ON ASS.srmReportType = CRReportTemplates.id AND ASS.srmReportType > 0 -- CRReportTemplates table is being removed
			LEFT OUTER JOIN dbo.APP_ClientGroup WITH (NOLOCK) ON ASS.clientGroupId = dbo.APP_ClientGroup.id AND ASS.clientGroupId > 0
			LEFT OUTER JOIN dbo.APP_Client WITH (NOLOCK) ON ASS.clientId = dbo.APP_Client.id
			LEFT OUTER JOIN dbo.APP_iDAType WITH (NOLOCK) ON ASS.apptypeId = dbo.APP_iDAType.type --AND ASS.clientId > 0
			LEFT OUTER JOIN dbo.APP_InstanceName WITH (NOLOCK) ON ASS.instanceId = dbo.APP_InstanceName.id
			LEFT OUTER JOIN dbo.APP_Client MAEntity WITH (NOLOCK) ON ASS.mediaAgentId = MAEntity.id
			LEFT OUTER JOIN dbo.APP_BackupSetName WITH (NOLOCK) ON ASS.backupsetId = dbo.APP_BackupSetName.id
			LEFT OUTER JOIN dbo.APP_Application WITH (NOLOCK) ON ASS.subclientId = dbo.APP_Application.id
			LEFT OUTER JOIN #clientTimezoneTbl clientTimezoneTbl ON ASS.clientId = clientTimezoneTbl.clientId and  ASS.clientId>0 AND ASS.assocType!=158
			LEFT OUTER JOIN SchedTimeZone TZ WITH (NOLOCK) ON TZ.TimeZoneStdName = clientTimezoneTbl.timezoneName  AND ASS.assocType!=158
			LEFT OUTER JOIN WF_Definition WF (NOLOCK) ON WF.WorkflowId = ASS.workflowId
			LEFT OUTER JOIN dbo.IdxSIDBStore WITH (NOLOCK) ON ASS.sidbStoreId = IdxSIDBStore.SIDBStoreId
			LEFT OUTER JOIN dbo.App_Plan WITH (NOLOCK) ON ASS.planId = App_Plan.Id AND
ASS.assocType = 158
	--select * from #AssocEntity
	-- GET IF IT IS FOR CALENDAR
	SET @isCalendar	=	ISNULL(( SELECT ref.value('@isCalendar', 'int')
										FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
									), 0)
	IF @isCalendar <> 0
	BEGIN
		INSERT  INTO @entityCount
				SELECT  taskId ,
						0
				FROM    TM_Task WITH (NOLOCK)
				WHERE   [TM_Task].[deleted] = 0
						AND [TM_Task].[invalid] = 0
						AND [TM_Task].[uninstalled] = 0
AND ([TM_Task].[taskType] = 4 OR
[TM_Task].[taskType] = 2)
		DECLARE @UseOldTaskEntityCountSPs INT = 0
		SELECT
			@UseOldTaskEntityCountSPs = value
		FROM GXGlobalParam
		WHERE
			name = N'UseOldTaskEntityCountSPs'
			AND modified = 0
		IF (@UseOldTaskEntityCountSPs = 0)
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#TM_GetAdminEntityCountDataSet_taskTble') is not null
				DROP TABLE #TM_GetAdminEntityCountDataSet_taskTble
			CREATE TABLE #TM_GetAdminEntityCountDataSet_taskTble (
				taskId				INT,
				subTaskId			INT,
				subTaskType			INT,
				entityCount			INT DEFAULT 0,
				PRIMARY KEY (taskId, subTaskId)
			)
			IF OBJECT_ID('tempdb.dbo.#TM_GetBackupEntityCountDataSet_taskTble') is not null
				DROP TABLE #TM_GetBackupEntityCountDataSet_taskTble
			CREATE TABLE #TM_GetBackupEntityCountDataSet_taskTble (
				taskId				INT,
				subTaskId			INT,
				subTaskType			INT,
				entityCount			INT DEFAULT 0,
				PRIMARY KEY (taskId, subTaskId)
			)
			-- Populate External Admin Entity Table
			INSERT INTO #TM_GetAdminEntityCountDataSet_taskTble (taskId, subTaskId, subTaskType)
				SELECT DISTINCT		-- @entityCount table may have duplicates based on original implementation?
					t.taskId,
					st.subTaskId,
					st.subTaskType
				FROM @entityCount t
					CROSS APPLY (
						SELECT TOP 1
							s.subTaskId,
							s.subTaskType
						FROM TM_SubTask s WITH(NOLOCK)
							OUTER APPLY (
								SELECT
									1 Ordering
								FROM  tm_subtaskoptions STO WITH(NOLOCK)
								WHERE
									STO.subTaskId = s.subTaskId
AND STO.optionid = 458405394		-- BACKUPOPTION_BACKUP_LEVEL
									AND STO.value = 4
							) Custom
						WHERE
							s.taskId = t.taskId
						ORDER BY ISNULL(Custom.Ordering, 0) ASC
					) st
				WHERE
st.subTaskType = 1			-- SUB_TASK_TYPE_ADMIN
			DECLARE @admRowCount INT = @@ROWCOUNT
			-- Populate External Backup Entity Table
			INSERT INTO #TM_GetBackupEntityCountDataSet_taskTble (taskId, subTaskId, subTaskType)
				SELECT DISTINCT		-- @entityCount table may have duplicates based on original implementation?
					t.taskId,
					st.subTaskId,
					st.subTaskType
				FROM @entityCount t
					CROSS APPLY (
						SELECT TOP 1
							s.subTaskId,
							s.subTaskType
						FROM TM_SubTask s WITH(NOLOCK)
							OUTER APPLY (
								SELECT
									1 Ordering
								FROM  tm_subtaskoptions STO WITH(NOLOCK)
								WHERE
									STO.subTaskId = s.subTaskId
AND STO.optionid = 458405394		-- BACKUPOPTION_BACKUP_LEVEL
									AND STO.value = 4
							) Custom
						WHERE
							s.taskId = t.taskId
						ORDER BY ISNULL(Custom.Ordering, 0) ASC
					) st
				WHERE
st.subTaskType NOT IN ( 1, 3 )	-- SUB_TASK_TYPE_ADMIN, SUB_TASK_TYPE_RESTORE
			DECLARE @bkupRowCount INT = @@ROWCOUNT
			-- Compute Task Entity Counts on External Tables and then update local table with count info
			DECLARE @spRC	INT = 0
			IF (@admRowCount > 0)
			BEGIN
				EXEC @spRC = TM_GetAdminEntityCountDataSet
				UPDATE tt
					SET nCount = et.entityCount
				FROM @entityCount tt
					INNER JOIN #TM_GetAdminEntityCountDataSet_taskTble et ON
						et.taskId = tt.taskId
			END
			IF (@bkupRowCount > 0)
			BEGIN
				EXEC @spRC = TM_GetBackupEntityCountDataSet
				UPDATE tt
					SET nCount = et.entityCount
				FROM @entityCount tt
					INNER JOIN #TM_GetBackupEntityCountDataSet_taskTble et ON
						et.taskId = tt.taskId
			END
			IF OBJECT_ID('tempdb.dbo.#TM_GetAdminEntityCountDataSet_taskTble') is not null
				DROP TABLE #TM_GetAdminEntityCountDataSet_taskTble
			IF OBJECT_ID('tempdb.dbo.#TM_GetBackupEntityCountDataSet_taskTble') is not null
				DROP TABLE #TM_GetBackupEntityCountDataSet_taskTble
		END
		ELSE
		BEGIN
			DECLARE CalculateEntityCountCursor CURSOR
			FOR SELECT DISTINCT
			taskId
			FROM    @entityCount
			OPEN CalculateEntityCountCursor
			FETCH FROM CalculateEntityCountCursor INTO @taskId
			WHILE @@FETCH_STATUS = 0
				BEGIN
					SET @subTaskId = ( SELECT TOP 1
												s.subTaskId
										FROM     TM_SubTask s WITH (NOLOCK)
OUTER APPLY ( SELECT 1 Ordering FROM  tm_subtaskoptions STO (NOLOCK) WHERE Sto.subTaskId =s.subTaskId AND optionid=458405394 and value =4) Custom
										WHERE    s.taskId = @taskId
										ORDER BY isnull(Custom.Ordering,0) asc
										)
					IF ( EXISTS ( SELECT    *
										FROM      TM_SubTask WITH (NOLOCK)
										WHERE     subTaskId = @subTaskId
AND subTaskType = 1 )
						)
						BEGIN
							DECLARE @o_countAdmin INT = 0
							EXEC TM_GetAdminEntityCount @taskId, @subTaskId, @o_countAdmin OUTPUT
							UPDATE  @entityCount
							SET     nCount = @o_countAdmin
							WHERE   taskId = @taskId
						END
					ELSE IF ( NOT EXISTS ( SELECT    *
										FROM      TM_SubTask WITH (NOLOCK)
										WHERE     subTaskId = @subTaskId
AND subTaskType = 3 )
						)
						BEGIN
								DECLARE @o_count2 INT = 0
								EXEC TM_GetBackupEntityCount @taskId,
										@subTaskId, NULL, @o_count2 OUTPUT
							UPDATE  @entityCount
							SET     nCount = @o_count2
							WHERE   taskId = @taskId
						END
					FETCH FROM CalculateEntityCountCursor INTO @taskId
				END
			CLOSE CalculateEntityCountCursor
			DEALLOCATE CalculateEntityCountCursor
		END
	END
	--GET isSystem flag
	SET @isSystem = ISNULL(( SELECT ref.value('@isSystem', 'int')
								FROM @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
							), 0)
	--GET getAllDetails flag
	SET @getAllDetails = ISNULL(( SELECT   ref.value('@getAllDetails', 'int')
								FROM     @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )), 0)
	--GET EZPOLICY SCHEDULE
	SET @EZPolicyFilter  =   ISNULL(( SELECT ref.value('@EZPolicyFilter', 'int')
									FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
								), 0)
    --GET OPERATION TYPES
    INSERT  INTO @operationFilter
            SELECT  ref.value('@val', 'int') AS operationType
            FROM    @xmlText.nodes('TMMsg_GetTaskListReq/filter/operationTypes') R ( ref )
    --GET OPTIONS FILTER
    INSERT  INTO @optionFilter
            SELECT  ref.value('@optionId', 'bigint') AS optionId, ref.value('@value', 'NVARCHAR(MAX)') AS value
            FROM    @xmlText.nodes('TMMsg_GetTaskListReq/filter/options') R ( ref )
	IF (SELECT COUNT(*) FROM @operationFilter) = 0
		INSERT @operationFilter (operationType)
		VALUES (0)
	DECLARE @reportUserId INT = 0
IF EXISTS(SELECT 1 FROM @optionFilter WHERE optionId = 140019)
	BEGIN
SET @reportUserId = CAST((SELECT TOP 1 value FROM @optionFilter WHERE optionId = 140019) AS INT) --COM_USER_ID
DELETE FROM @optionFilter WHERE optionId = 140019 -- delete it so we dont try a match on job options for that
	END
	-- MR : https:--engweb.commvault.com/engtools/defect/221879 tenant admin can't view his own created schedule policies if there are no associations
EXEC sec_getNonIdaObjectsForThisUser @userId, 35, 0, '#taskList'
	INSERT INTO #taskTble
	SELECT DISTINCT S.taskId, S.subTaskId, T.taskType
	FROM TM_SubTaskOptions SO
	JOIN TM_SubTask S ON S.subTaskId = SO.subTaskId
JOIN TM_Task T ON T.taskId = S.taskId AND (@isSystem = 0 OR (T.flags & 0x4) <> 0)
	--JOIN #AssocEntity AE ON AE.taskId = T.taskId OR T.ownerId=@userId
	JOIN @operationFilter F ON (F.operationType = S.operationType or F.operationType=0)
	LEFT JOIN #subTaskList subTaskList ON subTaskList.subtaskID = S.subTaskId
	LEFT JOIN #taskList taskList ON taskList.taskId = T.taskId
	LEFT JOIN TM_AssocWorkFlowEntity TWF ON TWF.taskId = T.taskId
	WHERE ( @reportUserId = 0 AND (
									(T.taskId in (SELECT taskId FROM #AssocEntity))
									OR
(T.taskId in (SELECT taskId FROM TM_SubTask WITH (NOLOCK) WHERE subTaskType = 1))
									OR
									( taskList.taskId IS NOT NULL AND taskList.taskId>0) --MR : 221879 tenant admin can't view his own created schedule policies if there are no associations
									OR
									(T.ownerId = @userId)
									OR
									(@isUserAdmin = 1)
									OR ( subTaskList.subtaskID IS NOT NULL AND subTaskList.subtaskID>0)
									)
			)
			OR
			(
				(
					@reportUserId <> 0
					AND
					(
						T.ownerId = @reportUserId OR @doesUserHaveCCReportCap = 1
						OR ( subTaskList.subtaskID IS NOT NULL AND subTaskList.subtaskID>0)
						OR ( taskList.taskId IS NOT NULL AND taskList.taskId>0) --MR : 221879 tenant admin can't view his own created schedule policies if there are no associations
					)
				)
			)
		OR
		(
			TWF.taskId IS NOT NULL
			AND
			(
				T.ownerId = @userId
				OR @doesUserHaveCCViewCap = 1
				OR EXISTS (SELECT TOP 1 TWF.taskId FROM #entitiesWithViewSchedCapability sec where sec.workflowID = TWF.workflowId AND ((capabilities&@_EV_VIEW) <> 0))
			)
		)
AND T.taskType NOT IN (1)
	--MR=164867 - USER WITHOUT RIGHTS SHOULD NOT BE ABLE TO VIEW SCHEDULE POLICIES
	IF @isUserAdmin = 0
	BEGIN
		DELETE taskTble
 		FROM #taskTble taskTble
		INNER JOIN TM_Task T on taskTble.taskId = T.taskId
WHERE taskTble.taskType = 4
		AND taskTble.taskId NOT IN (SELECT taskId FROM #taskList)
		AND T.policyType <> 13
	END
	IF (SELECT COUNT(*) FROM @optionFilter) > 0
	BEGIN
		DELETE taskTble
		FROM #taskTble taskTble
		left join
		(
			-- Get all matching subtasks -- get all subtasks - get subtasks which dont match
			--get all subtasks
			SELECT T.subTaskId,T.taskId FROM #taskTble T
			except
			(
				-- find all subtasks which dont match
				SELECT T.subTaskId,T.taskId FROM #taskTble T
				cross join @optionFilter optionFilter
				left join TM_SubTaskOptions SO on SO.subTaskId = T.subTaskId and SO.optionId = optionFilter.optionId and SO.value=optionFilter.value
				where SO.optionId is null
			)
		) T on
		T.taskId = taskTble.taskId
		where T.taskId is null
	END
-- -- SP BODY BEGIN : TM_ComputeStartTimeForClientTbl.spb ----------------------------------------------------------------------------------------------------------------------------------
IF object_id('tempdb.dbo.#Clients_Timezone_StartTime') is NOT NULL
BEGIN
	DROP TABLE #Clients_Timezone_StartTime
END
CREATE TABLE #Clients_Timezone_StartTime(clientId INT, timezoneName NVARCHAR(MAX), jobStartTime INT DEFAULT -1, taskID INT DEFAULT 0, patternID INT DEFAULT 0 )
CREATE CLUSTERED INDEX Clients_Timezone_StartTime_clientId_taskID_Index ON #Clients_Timezone_StartTime (clientId, taskID)
IF object_id('tempdb.dbo.#SubClients_Timezone_StartTime') is NOT NULL
BEGIN
	DROP TABLE #SubClients_Timezone_StartTime
END
CREATE TABLE #SubClients_Timezone_StartTime(appId INT, timezoneName NVARCHAR(MAX), jobStartTime INT DEFAULT -1, taskID INT DEFAULT 0)
CREATE CLUSTERED INDEX SubClients_Timezone_StartTime_appId_Index ON #SubClients_Timezone_StartTime (appId)
-- -- SP BODY END : TM_ComputeStartTimeForClientTbl.spb ------------------------------------------------------------------------------------------------------------------------------------
	INSERT INTO #Clients_Timezone_StartTime(clientId , timezoneName , jobStartTime , taskID , patternID )
	SELECT DISTINCT AssocEntity.clientId, NULL, -1, AssocEntity.taskId, 0
	FROM #AssocEntity AssocEntity
	WHERE AssocEntity.clientId>0
	-- Add all subclients of VSA apptype. Include only cases where schedule is associated at subclient level.
	INSERT INTO #SubClients_Timezone_StartTime(appId , timezoneName, jobStartTime, taskID)
	SELECT DISTINCT subclientId, NULL, -1, AssocEntity.taskId
	FROM #AssocEntity AssocEntity
	INNER JOIN App_Application (NOLOCK) ON AssocEntity.subclientID = App_application.Id
AND App_application.apptypeID = 106
	--Processing to convert clientname to display name for install schedules
	--fetch all xml options for install schedules which this user can view
	INSERT INTO #displayNameSubtaskXML
	SELECT STXO.subtaskId, STXO.xmlValue
		FROM TM_SubTaskXMLOptions STXO
		INNER JOIN #subTaskList STL ON STL.subTaskId = STXO.subTaskId
INNER JOIN TM_SubTask ST ON ST.subTaskId = STL.subTaskId AND ST.operationType = 4020
	--select the clientAndClientGroups node into another table
	INSERT INTO #clientAndCG
	SELECT #displayNameSubtaskXML.subtaskId,
		C.name, --clientName
		ISNULL(C.displayName,C.name), --displayName
		ISNULL(R.ref.value('@clientId[1]','INT'),0), @clientType
	FROM   #displayNameSubtaskXML
	CROSS APPLY #displayNameSubtaskXML.xmlValue.nodes('*//clientAndClientGroups') R(ref)
	LEFT JOIN APP_Client C ON C.id = ISNULL(R.ref.value('@clientId[1]','INT'),0)
	WHERE R.ref.value('@_type_[1]','INT') = @clientType
	--We need to process this for only client associations, deleting others
	UPDATE T
	SET xmlValue.modify('delete //./clientAndClientGroups[@_type_ = sql:variable("@clientType")]')
	FROM #displayNameSubtaskXML T
	INSERT INTO #CCGXML
	SELECT DISTINCT CCG.subtaskId, ''
	FROM #clientAndCG CCG
	UPDATE #CCGXML
	SET xmlValue =
		(SELECT DISTINCT
				   CCG.clientName , CCG.displayName, CCG.clientId , CCG._type_
				   FROM #clientAndCG CCG
				   WHERE CCG.subtaskId = #CCGXML.subtaskId
				   FOR XML RAW ('clientAndClientGroups')
		)
	FROM #CCGXML
	UPDATE T set xmlValue.modify('insert sql:column("sq.NewData") as first into (//./updateOption)[1]')
	FROM #displayNameSubtaskXML T
		CROSS APPLY(
			SELECT #CCGXML.xmlValue
			FROM #CCGXML
			WHERE T.subtaskId = #CCGXML.subtaskId
		) sq(NewData)
	-- Call stored procedure to compute timezone and start time for clients.
	EXEC TM_ComputeStarttimeForClient
	UPDATE #AssocEntity
	SET jobStartTime = ISNULL(NULLIF(SubClients_Timezone_StartTime.jobStartTime,-1),#Clients_Timezone_StartTime.jobStartTime )
	FROM #AssocEntity AssocEntity
	INNER JOIN #Clients_Timezone_StartTime ON AssocEntity.clientID = #Clients_Timezone_StartTime.clientId
	AND Assocentity.taskID = #Clients_Timezone_StartTime.taskID
	LEFT JOIN #SubClients_Timezone_StartTime SubClients_Timezone_StartTime ON Assocentity.subclientID = SubClients_Timezone_StartTime.appId
	AND Assocentity.taskID = SubClients_Timezone_StartTime.taskID
	IF @getAllDetails = 1
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
		DROP TABLE #AssocEntity
		DECLARE getTaskDetailCur CURSOR FOR SELECT taskId FROM #taskTble
		DECLARE @taskDetailList TABLE(taskDetails XML)
		DECLARE @task_Id INT
		OPEN getTaskDetailCur
		FETCH NEXT FROM getTaskDetailCur INTO @task_Id
		WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO @taskDetailList
			EXEC dbo.TM_GetTaskDetail @task_Id, @userId, @localeId_in
			FETCH NEXT FROM getTaskDetailCur INTO @task_Id
		END
		CLOSE getTaskDetailCur
			DEALLOCATE getTaskDetailCur
		SET @xmlText = (SELECT
				taskDetails.query('/TMMsg_GetTaskDetailResp/taskInfo/*') AS '*'
				FROM @taskDetailList
				FOR XML PATH('taskDetail'),
				ROOT('TMMsg_GetTaskListResp'))
	END
	ELSE IF (SELECT COUNT(*) FROM @optionFilter) > 0
	BEGIN
		SET @xmlText = ( SELECT	 --TASKLIST
					( SELECT 	--TASK
								[TM_Task].taskId AS '@taskId' ,
								[TM_Task].taskName AS '@taskName' ,
								[TM_Task].taskType AS '@taskType' ,
								[TM_Task].alertId AS '@alertId' ,
								[NTnotificationRule].notificationName AS '@alertName' ,
								[TM_Task].ownerId AS '@ownerId' ,
								[TM_Task].runUserId AS '@runUserId' ,
								[TM_Task].description AS '@description' ,
								USR.login AS '@ownerName' ,
								[TM_Task].policyType AS '@policyType' ,
								--dbo.GetEntityCount([TM_Task].taskId) AS '@associatedObjects' ,
								(SELECT TOP 1
									nCount
									FROM    @entityCount
									WHERE   taskId = [TM_Task].taskId
									) AS '@associatedObjects' ,
								[TM_Task].GUID ,
								( SELECT -- alert
											[TM_Task].alertId AS '@alertId' ,
											NT.notificationName AS '@alertName'
									FROM    dbo.NTnotificationRule
											AS NT WITH (NOLOCK)
									WHERE   NT.id = [TM_Task].alertId
								FOR
									XML PATH('alert') ,
										TYPE
								) ,
								(SELECT
									[TM_Task].taskId AS '@taskId',
									[TM_Task].taskName AS '@taskName'
								FOR
									XML PATH ('task'),
										TYPE
								),
								( SELECT-- origCC
											[TM_Task].origCCId AS '@commCellId'
								FOR
									XML PATH('originalCC') ,
										TYPE
								) ,
								( SELECT  --TaskFlags
											[TM_Task].disabled AS '@disabled' ,
											[TM_Task].uninstalled AS '@uninstalled' ,
											[TM_Task].isEZOperation AS '@isEZOperation',
CASE WHEN [TM_Task].flags & 0x40 <> 0 THEN 1
											ELSE 0
											END AS '@isEdgeDrive',
CASE WHEN [TM_Task].flags & 0x80 <> 0 THEN 1
											ELSE 0
											END AS '@isIndexBackup',
CASE WHEN [TM_Task].flags & 0x80000 <> 0 THEN 1
				                            ELSE 0
				                            END AS '@isEdiscovery'
								FOR
									XML PATH('taskFlags') ,
										TYPE
								)
					FOR
						XML PATH('task') ,
							TYPE
					) ,
					( SELECT  --APPGROUP
								( SELECT  --GROUP SELECTED
											TFIL.filter_value AS '@appGroupId'
									FROM    TM_AssocFilter
											AS TFIL WITH (NOLOCK)
									WHERE   TFIL.filter_type = 1
											AND TFIL.taskId = [TM_Task].taskId
								FOR
									XML PATH('appGroups') ,
										TYPE
								) ,
								( SELECT  --TYPES SELECTED
											TFIL.filter_value AS '@appTypeId'
									FROM    TM_AssocFilter
											AS TFIL WITH (NOLOCK)
									WHERE   TFIL.filter_type = 2
											AND TFIL.taskId = [TM_Task].taskId
								FOR
									XML PATH('appTypes') ,
										TYPE
								)
					FOR
						XML PATH('appGroup') ,
							TYPE
					) ,
					( SELECT --NEXT SCHEDULES
								datediff(second, '01/01/1970', dbo.ClientLocalToUTCTime(RAS.nextRunTime,2)) '@nextScheduleTime',
								--ABS(datediff(second, '01/01/1970', dbo.UTCToClientLocalTime(GETDATE(), 2)) - datediff(second, '01/01/1970', dbo.UTCToClientLocalTime(RAS.nextRunTime, 2))) '@relativeTime',
								ABS(datediff(second, '01/01/1970', RAS.nextRunTime) - datediff(second, '01/01/1970', GETDATE())) '@relativeTime',
								(SELECT ASSOC.clientId '@clientId'
									FOR
									XML PATH('client') ,
										TYPE
								) ,
								(SELECT STASK.subTaskId '@subtaskId',
									STASK.taskId '@taskId'
									FOR
									XML PATH('subtask') ,
										TYPE
								) ,
								(SELECT TimeZoneId '@TimeZoneID' FROM SchedTimeZone WITH (NOLOCK)
									WHERE TimeZoneStdName = ASSOC.timeZoneName
									FOR
									XML PATH('timeZone') ,
										TYPE
								)
						FROM		#AssocEntity AS ASSOC
								INNER JOIN TM_SubTask AS STASK WITH (NOLOCK) ON STASK.taskId = ASSOC.taskId
								INNER JOIN TM_PatternAssoc
										AS PAS WITH (NOLOCK) ON PAS.subTaskId = STASK.subTaskId
								INNER JOIN TM_Pattern
										AS PAT WITH (NOLOCK) ON PAT.patternId = PAS.patternId
								INNER JOIN TM_RunTime
										AS NRT WITH (NOLOCK) ON NRT.patternId = PAS.patternId
								INNER JOIN TM_RunTimeAssoc
										AS RAS WITH (NOLOCK) ON RAS.runTimeId = NRT.runTimeId
										AND RAS.processed = 0
										-- Pick the runtime association where jobStartTime matches.
						WHERE		STASK.subTaskId = PAS.subTaskId
								AND STASK.taskId = [TM_Task].taskId
AND PAT.tzId = 1001
								AND PAT.deleted = 0
								AND RAS.jobStartTime = Assoc.JobStartTime
								AND RAS.timeZoneNames = Assoc.timezoneName
					FOR
						XML PATH('nextScheduleTimes') ,
							TYPE
					) ,
					( SELECT DISTINCT --ASSOC
								ASSOC.assocType '@_type_' ,
								ASSOC.clientGroupId '@clientGroupId' ,
								ASSOC.clientGroupName '@clientGroupName' ,
								ASSOC.clientId '@clientId' ,
								ASSOC.clientName '@clientName' ,
								ASSOC.displayName '@displayName' ,
								ASSOC.apptypeId '@applicationId' ,
								ASSOC.appTypeName '@appName' ,
								ASSOC.policyId '@storagePolicyId' ,
								ASSOC.policyName '@storagePolicyName' ,
								ASSOC.mediaAgentId '@mediaAgentId',
								ASSOC.mediaAgentName '@mediaAgentName',
								ASSOC.instanceId '@instanceId' ,
								CASE CHARINDEX('', ASSOC.instanceName)
									WHEN 0 THEN	ASSOC.instanceName
									ELSE
										'|'+REPLACE(ASSOC.instanceName,
										'', '|#12!')
									END '@instanceName',
								ASSOC.backupsetId '@backupsetId' ,
								ASSOC.copyId '@copyId' ,
								ASSOC.copyName '@copyName' ,
								ASSOC.srmReportSet '@srmReportSet',
								ASSOC.srmReportType '@srmTemplateId',
								ASSOC.srmReportName '@srmTemplateName',
								ASSOC.backupsetName '@backupsetName' ,
								ASSOC.subclientId '@subclientId' ,
								ASSOC.subclientName '@subclientName',
								ASSOC.agentlessPolicyId '@agentlessPolicyId',
								ASSOC.workflowId '@workflowId',
								ASSOC.workflowName '@workflowName',
								ASSOC.SidbStoreId '@sidbStoreId',
								ASSOC.SidbStoreName '@sidbStoreName',
								ASSOC.planId '@planId',
								ASSOC.planName '@planName',
								ASSOC.exclude 'flags/@exclude'
						FROM      #AssocEntity AS ASSOC
						INNER JOIN TM_SubTask AS STASK WITH (NOLOCK) ON STASK.taskId = ASSOC.taskId
						INNER JOIN TM_PatternAssoc
								AS PAS WITH (NOLOCK) ON PAS.subTaskId = STASK.subTaskId
						INNER JOIN TM_Pattern
								AS PAT WITH (NOLOCK) ON PAT.patternId = PAS.patternId
						LEFT OUTER JOIN TM_RunTime
								AS NRT WITH (NOLOCK) ON NRT.patternId = PAT.patternId AND NRT.processed=0
						LEFT OUTER JOIN TM_RunTimeAssoc
								AS RAS WITH (NOLOCK) ON RAS.runTimeId = NRT.runTimeId
								AND (PAT.tzId <> 1001 OR (PAT.tzId = 1001 AND RAS.timeZoneNames = ASSOC.timeZoneName))
								AND RAS.processed = 0
						WHERE     ASSOC.taskId = [TM_Task].taskId
						AND exclude=0
						AND PAT.deleted = 0
					FOR
						XML PATH('associations') ,
							TYPE
					) ,
					(
						SELECT WFASS.entityTitle as '@workflowTitle',
						WFASS.workflowOption as '@workflowJobOptions',
						WF.WorkflowId 'workflow/@workflowId',
						WF.Name 'workflow/@workflowName',
						WFASS.clientId as 'clientEntity/@clientId'
						FROM WF_Definition WF (NOLOCK)
						JOIN TM_AssocWorkFlowEntity WFASS (NOLOCK) ON WFASS.workflowId = WF.workflowId
						WHERE WFASS.taskId = [TM_Task].taskId
						FOR
							XML PATH('workflows') ,
								TYPE
					),
					( SELECT		--SUBTASKINFO
	--TASK RUN TIME FROM TM_RunTime Table
								NRT.nextTime AS '@nextScheduleTime' ,
								ABS(datediff(second, '01/01/1970', GETUTCDATE()) - datediff(second, '01/01/1970', NRT.nextRunTime)) '@relativeTime',
								( SELECT	DISTINCT --SUBTASK
											STASK.subTaskId AS '@subTaskId' ,
											STASK.subTaskType AS '@subTaskType' ,
											STASK.operationType AS '@operationType' ,
											STASK.flags AS '@flags' ,
											STASK.subTaskOrder AS '@subTaskOrder' ,
											STASK.subTaskName AS '@subTaskName'
								FOR
									XML PATH('subTask') ,
										TYPE
								) ,
								( SELECT --PATTERN
											PAT.patternId '@patternId' ,
											PAT.name '@name' ,
											PAT.flags '@flags' ,
											PAT.freq_type '@freq_type' ,
											PAT.freq_interval '@freq_interval' ,
											PAT.freq_relative_interval '@freq_relative_interval' ,
											PAT.freq_recurrence_factor '@freq_recurrence_factor' ,
											PAT.freq_subday_interval '@freq_subday_interval' ,
											PAT.skipOccurence '@skipOccurence' ,
											PAT.skipDayNumber '@skipDayNumber' ,
											PAT.local_start_date '@active_start_date' ,
											PAT.active_start_time '@active_start_time' ,
											PAT.local_end_date '@active_end_date' ,
											PAT.active_end_time '@active_end_time' ,
											PAT.active_end_occurence '@active_end_occurence' ,
											PAT.description '@description' ,
											PAT.freq_restart_interval '@freq_restart_interval',
											( SELECT  --TimeZone
											PAT.tzId AS '@TimeZoneID'
											FOR
											XML
											PATH('timeZone') ,
											TYPE
											) ,
											( SELECT  --Calendar
											PAT.calendarId AS '@calendarId'
											FOR
											XML
											PATH('calendar') ,
											TYPE
											),
											( SELECT  --Repeat Pattern
											REP.onOccurence AS '@occurrence',
											REP.onDay AS '@onDay',
											REP.repeatOn AS '@repeatOn',
											REP.onDayNumber AS '@onDayNumber',
											1				  AS '@exception',
											REP.description AS '@description'
											FROM TM_RepeatPattern AS REP WITH (NOLOCK)
											WHERE REP.patternId = PAT.patternId
											FOR
											XML
											PATH('repeatPattern') ,
											TYPE
											)
									FROM    TM_Pattern AS PAT WITH (NOLOCK),
											TM_PatternAssoc PASOC WITH (NOLOCK)
									WHERE   [PASOC].[patternId] = PAT.[patternId]
											AND PASOC.subTaskId = STASK.subTaskId
											AND PAT.deleted = 0
								FOR
									XML PATH('pattern') ,
										TYPE
								) ,
CASE WHEN STASK.operationType <> 4020
									THEN( SELECT  --OPTIONS
												SOPTIONS.xmlValue.query('/TMMsg_JobOption/*') AS 'options'
												FROM    TM_SubTaskXMLOptions SOPTIONS
												WHERE   SOPTIONS.subTaskId = STASK.subTaskId
											FOR
												XML PATH('') ,
													TYPE
										)
									ELSE( SELECT  --OPTIONS
												SOPTIONS.xmlValue.query('/TMMsg_JobOption/*') AS 'options'
												FROM    #displayNameSubtaskXML SOPTIONS
												WHERE   SOPTIONS.subTaskId = STASK.subTaskId
											FOR
												XML PATH('') ,
													TYPE
										)
									END
							FROM      TM_subTask AS STASK WITH (NOLOCK)
									LEFT OUTER JOIN TM_PatternAssoc
										AS PAS WITH (NOLOCK) ON PAS.subTaskId = STASK.subTaskId
									LEFT OUTER JOIN TM_Pattern
										AS PAT WITH (NOLOCK) ON PAT.patternId = PAS.patternId
									LEFT OUTER JOIN TM_RunTime
										AS NRT WITH (NOLOCK) ON NRT.patternId = PAS.patternId
												AND NRT.processed = 0
									LEFT OUTER JOIN #subTaskList subTaskList ON subTaskList.subtaskID = STASK.subTaskId
									LEFT OUTER JOIN #taskList taskList ON STASK.taskId = taskList.taskId
							WHERE     STASK.subTaskId = PAS.subTaskId
								AND STASK.taskId = [TM_Task].taskId
								AND PAT.deleted = 0
								AND
								(
subTaskType <> 1
									OR
									(
subTaskType = 1
										AND
										(
											(
STASK.operationType NOT IN (4004) AND @canUserSeeAllAdminSchedules = 1
											)
											OR
											(
STASK.operationType IN (4004) AND @canUserSeeAllReports = 1
											)
											OR
											(
												[TM_Task].taskId in (SELECT taskId FROM #AssocEntity)
											)
											OR (taskList.taskId IS NOT NULL AND taskList.taskId>0)
											OR [TM_Task].ownerId = @userId
											-- User is associated to the schedule directly.
											OR (subTaskList.subtaskID IS NOT NULL AND subTaskList.subtaskID>0)
											OR TM_Task.policyType = 13 -- workflow policy type & workflow schedule policy security check is already done above
										)
									)
								)
					FOR
						XML PATH('subTasks') , TYPE
					)
				FROM   dbo.TM_Task WITH (NOLOCK)
					INNER JOIN
						(
							select distinct taskTble.taskId from #taskTble taskTble
						) AS ASS ON ASS.taskId = dbo.TM_Task.taskId
					--INNER JOIN dbo.TM_AssocEntity ON dbo.TM_AssocEntity.taskId = dbo.TM_Task.taskId
					LEFT OUTER JOIN dbo.UMUsers AS USR WITH (NOLOCK) ON dbo.TM_Task.ownerId = USR.id
					LEFT OUTER JOIN dbo.NTnotificationRule WITH (NOLOCK) ON dbo.NTnotificationRule.id = dbo.TM_Task.alertId
						LEFT OUTER JOIN TM_SubTask S WITH (NOLOCK) ON S.taskId = dbo.TM_Task.taskId
						JOIN @operationFilter OPF ON OPF.operationType = S.operationType OR OPF.operationType = 0
					WHERE  [TM_Task].[deleted] = 0
							AND [TM_Task].[invalid] = 0
							--AND [TM_Task].[uninstalled] = 0
							AND [TM_Task].[savedReport] = 0
							AND
							( [TM_Task].taskId in (SELECT taskId FROM #AssocEntity)	--MR46115 Do not show schedule policy w/ 0 association on CS schedule tab
								OR
								(
[TM_Task].taskId in (SELECT taskId FROM TM_SubTask WITH (NOLOCK) WHERE subTaskType = 1 )
								)
								OR ([TM_Task].ownerId = @userId)
							)
AND ( [TM_Task].[taskType] IN ( 2, 4  ) )
							AND (TM_Task.isEZOperation = @EZPolicyFilter OR @EZPolicyFilter = 0)
				FOR
					XML PATH('taskDetail') ,
						ROOT('TMMsg_GetTaskListResp')
				)
	END
	ELSE
	BEGIN
		IF @schedulePolicyId <> 0
		BEGIN
			delete from #taskTble
			where taskId != @schedulePolicyId
		END
		SET @xmlText = ( SELECT	 --TASKLIST
						( SELECT 	--TASK
									[TM_Task].taskId AS '@taskId' ,
									[TM_Task].taskName AS '@taskName' ,
									[TM_Task].taskType AS '@taskType' ,
									[TM_Task].alertId AS '@alertId' ,
									[NTnotificationRule].notificationName AS '@alertName' ,
									[TM_Task].ownerId AS '@ownerId' ,
									[TM_Task].runUserId AS '@runUserId' ,
									[TM_Task].description AS '@description' ,
									USR.login AS '@ownerName' ,
									[TM_Task].policyType AS '@policyType' ,
									--dbo.GetEntityCount([TM_Task].taskId) AS '@associatedObjects' ,
									(SELECT TOP 1
										nCount
										FROM    @entityCount
										WHERE   taskId = [TM_Task].taskId
										) AS '@associatedObjects' ,
									[TM_Task].GUID ,
									( SELECT -- alert
												[TM_Task].alertId AS '@alertId' ,
												NT.notificationName AS '@alertName'
										FROM    dbo.NTnotificationRule
												AS NT WITH (NOLOCK)
										WHERE   NT.id = [TM_Task].alertId
									FOR
										XML PATH('alert') ,
											TYPE
									) ,
									(SELECT
										[TM_Task].taskId AS '@taskId',
										[TM_Task].taskName AS '@taskName'
									FOR
										XML PATH ('task'),
											TYPE
									),
									( SELECT-- origCC
												[TM_Task].origCCId AS '@commCellId'
									FOR
										XML PATH('originalCC') ,
											TYPE
									) ,
									( SELECT  --TaskFlags
												[TM_Task].disabled AS '@disabled' ,
												[TM_Task].uninstalled AS '@uninstalled' ,
												[TM_Task].isEZOperation AS '@isEZOperation',
CASE WHEN [TM_Task].flags & 0x40 <> 0 THEN 1
												ELSE 0
												END AS '@isEdgeDrive',
CASE WHEN [TM_Task].flags & 0x80 <> 0 THEN 1
												ELSE 0
												END AS '@isIndexBackup',
CASE WHEN [TM_Task].flags & 0x80000 <> 0 THEN 1
					                            ELSE 0
					                            END AS '@isEdiscovery'
									FOR
										XML PATH('taskFlags') ,
											TYPE
									)
						FOR
							XML PATH('task') ,
								TYPE
						) ,
						( SELECT  --APPGROUP
									( SELECT  --GROUP SELECTED
												TFIL.filter_value AS '@appGroupId'
										FROM    TM_AssocFilter
												AS TFIL WITH (NOLOCK)
										WHERE   TFIL.filter_type = 1
												AND TFIL.taskId = [TM_Task].taskId
									FOR
										XML PATH('appGroups') ,
											TYPE
									) ,
									( SELECT  --TYPES SELECTED
												TFIL.filter_value AS '@appTypeId'
										FROM    TM_AssocFilter
												AS TFIL WITH (NOLOCK)
										WHERE   TFIL.filter_type = 2
												AND TFIL.taskId = [TM_Task].taskId
									FOR
										XML PATH('appTypes') ,
											TYPE
									)
						FOR
							XML PATH('appGroup') ,
								TYPE
						) ,
						( SELECT --NEXT SCHEDULES
									datediff(second, '01/01/1970', dbo.ClientLocalToUTCTime(RAS.nextRunTime,2)) '@nextScheduleTime',
									--ABS(datediff(second, '01/01/1970', dbo.UTCToClientLocalTime(GETDATE(), 2)) - datediff(second, '01/01/1970', dbo.UTCToClientLocalTime(RAS.nextRunTime, 2))) '@relativeTime',
									ABS(datediff(second, '01/01/1970', RAS.nextRunTime) - datediff(second, '01/01/1970', GETDATE())) '@relativeTime',
									(SELECT ASSOC.clientId '@clientId'
										FOR
										XML PATH('client') ,
											TYPE
									) ,
									(SELECT STASK.subTaskId '@subtaskId',
										STASK.taskId '@taskId'
										FOR
										XML PATH('subtask') ,
											TYPE
									) ,
									(SELECT TimeZoneId '@TimeZoneID' FROM SchedTimeZone WITH (NOLOCK)
										WHERE TimeZoneStdName = ASSOC.timeZoneName
										FOR
										XML PATH('timeZone') ,
											TYPE
									)
							FROM		#AssocEntity AS ASSOC
									INNER JOIN TM_SubTask AS STASK WITH (NOLOCK) ON STASK.taskId = ASSOC.taskId
									INNER JOIN TM_PatternAssoc
											AS PAS WITH (NOLOCK) ON PAS.subTaskId = STASK.subTaskId
									INNER JOIN TM_Pattern
											AS PAT WITH (NOLOCK) ON PAT.patternId = PAS.patternId
									INNER JOIN TM_RunTime
											AS NRT WITH (NOLOCK) ON NRT.patternId = PAS.patternId
									INNER JOIN TM_RunTimeAssoc
											AS RAS WITH (NOLOCK) ON RAS.runTimeId = NRT.runTimeId
											AND RAS.processed = 0
									-- Pick the runtime association where jobStartTime matches.
							WHERE		STASK.subTaskId = PAS.subTaskId
									AND STASK.taskId = [TM_Task].taskId
AND PAT.tzId = 1001
									AND PAT.deleted = 0
									AND RAS.jobStartTime = Assoc.JobStartTime
									AND RAS.timeZoneNames = Assoc.timezoneName
						FOR
							XML PATH('nextScheduleTimes') ,
								TYPE
						) ,
						( SELECT DISTINCT --ASSOC
									ASSOC.assocType '@_type_' ,
									ASSOC.clientGroupId '@clientGroupId' ,
									ASSOC.clientGroupName '@clientGroupName' ,
									ASSOC.clientId '@clientId' ,
									ASSOC.clientName '@clientName' ,
									ASSOC.displayName '@displayName' ,
									ASSOC.apptypeId '@applicationId' ,
									ASSOC.appTypeName '@appName' ,
									ASSOC.policyId '@storagePolicyId' ,
									ASSOC.policyName '@storagePolicyName' ,
									ASSOC.mediaAgentId '@mediaAgentId',
									ASSOC.mediaAgentName '@mediaAgentName',
									ASSOC.instanceId '@instanceId' ,
									CASE CHARINDEX('', ASSOC.instanceName)
										WHEN 0 THEN	ASSOC.instanceName
										ELSE
											'|'+REPLACE(ASSOC.instanceName,
											'', '|#12!')
										END '@instanceName',
									ASSOC.backupsetId '@backupsetId' ,
									ASSOC.copyId '@copyId' ,
									ASSOC.copyName '@copyName' ,
									ASSOC.srmReportSet '@srmReportSet',
									ASSOC.srmReportType '@srmTemplateId',
									ASSOC.srmReportName '@srmTemplateName',
									ASSOC.backupsetName '@backupsetName' ,
									ASSOC.subclientId '@subclientId' ,
									ASSOC.subclientName '@subclientName',
									ASSOC.agentlessPolicyId '@agentlessPolicyId',
									ASSOC.workflowId '@workflowId',
									ASSOC.workflowName '@workflowName',
									ASSOC.planId '@planId',
									ASSOC.planName '@planName',
									ASSOC.exclude 'flags/@exclude'
							FROM      #AssocEntity AS ASSOC
							INNER JOIN TM_SubTask AS STASK WITH (NOLOCK) ON STASK.taskId = ASSOC.taskId
							INNER JOIN TM_PatternAssoc
									AS PAS WITH (NOLOCK) ON PAS.subTaskId = STASK.subTaskId
							INNER JOIN TM_Pattern
									AS PAT WITH (NOLOCK) ON PAT.patternId = PAS.patternId
							LEFT OUTER JOIN TM_RunTime
									AS NRT WITH (NOLOCK) ON NRT.patternId = PAT.patternId AND NRT.processed=0
							LEFT OUTER JOIN TM_RunTimeAssoc
									AS RAS WITH (NOLOCK) ON RAS.runTimeId = NRT.runTimeId
									AND (PAT.tzId <> 1001 OR (PAT.tzId = 1001 AND RAS.timeZoneNames = ASSOC.timeZoneName))
									AND RAS.processed = 0
							WHERE     ASSOC.taskId = [TM_Task].taskId
							AND exclude=0
							AND PAT.deleted = 0
						FOR
							XML PATH('associations') ,
								TYPE
						) ,
						(
							SELECT WFASS.entityTitle as '@workflowTitle',
							WFASS.workflowOption as '@workflowJobOptions',
							WF.WorkflowId 'workflow/@workflowId',
							WF.Name 'workflow/@workflowName',
							WFASS.clientId as 'clientEntity/@clientId'
							FROM WF_Definition WF (NOLOCK)
							JOIN TM_AssocWorkFlowEntity WFASS (NOLOCK) ON WFASS.workflowId = WF.workflowId
							WHERE WFASS.taskId = [TM_Task].taskId
							FOR
								XML PATH('workflows') ,
									TYPE
						),
						( SELECT		--SUBTASKINFO
		--TASK RUN TIME FROM TM_RunTime Table
									NRT.nextTime AS '@nextScheduleTime' ,
									ABS(datediff(second, '01/01/1970', GETUTCDATE()) - datediff(second, '01/01/1970', NRT.nextRunTime)) '@relativeTime',
									( SELECT	DISTINCT --SUBTASK
												STASK.subTaskId AS '@subTaskId' ,
												STASK.subTaskType AS '@subTaskType' ,
												STASK.operationType AS '@operationType' ,
												STASK.flags AS '@flags' ,
												STASK.subTaskOrder AS '@subTaskOrder' ,
												STASK.subTaskName AS '@subTaskName'
									FOR
										XML PATH('subTask') ,
											TYPE
									) ,
									( SELECT --PATTERN
												PAT.patternId '@patternId' ,
												PAT.name '@name' ,
												PAT.flags '@flags' ,
												PAT.freq_type '@freq_type' ,
												PAT.freq_interval '@freq_interval' ,
												PAT.freq_relative_interval '@freq_relative_interval' ,
												PAT.freq_recurrence_factor '@freq_recurrence_factor' ,
												PAT.freq_subday_interval '@freq_subday_interval' ,
												PAT.skipOccurence '@skipOccurence' ,
												PAT.skipDayNumber '@skipDayNumber' ,
												PAT.local_start_date '@active_start_date' ,
												PAT.active_start_time '@active_start_time' ,
												PAT.local_end_date '@active_end_date' ,
												PAT.active_end_time '@active_end_time' ,
												PAT.active_end_occurence '@active_end_occurence' ,
												PAT.description '@description' ,
												PAT.freq_restart_interval '@freq_restart_interval',
												( SELECT  --TimeZone
												PAT.tzId AS '@TimeZoneID'
												FOR
												XML
												PATH('timeZone') ,
												TYPE
												) ,
												( SELECT  --Calendar
												PAT.calendarId AS '@calendarId'
												FOR
												XML
												PATH('calendar') ,
												TYPE
												),
												( SELECT  --Repeat Pattern
												REP.onOccurence AS '@occurrence',
												REP.onDay AS '@onDay',
												REP.repeatOn AS '@repeatOn',
												REP.onDayNumber AS '@onDayNumber',
												1				  AS '@exception',
												REP.description AS '@description'
												FROM TM_RepeatPattern AS REP WITH (NOLOCK)
												WHERE REP.patternId = PAT.patternId
												FOR
												XML
												PATH('repeatPattern') ,
												TYPE
												)
										FROM    TM_Pattern AS PAT WITH (NOLOCK),
												TM_PatternAssoc PASOC WITH (NOLOCK)
										WHERE   [PASOC].[patternId] = PAT.[patternId]
												AND PASOC.subTaskId = STASK.subTaskId
												AND PAT.deleted = 0
									FOR
										XML PATH('pattern') ,
											TYPE
									) ,
CASE WHEN STASK.operationType <> 4020
									THEN( SELECT  --OPTIONS
												SOPTIONS.xmlValue.query('/TMMsg_JobOption/*') AS 'options'
												FROM    TM_SubTaskXMLOptions SOPTIONS
												WHERE   SOPTIONS.subTaskId = STASK.subTaskId
											FOR
												XML PATH('') ,
													TYPE
										)
									ELSE( SELECT  --OPTIONS
												SOPTIONS.xmlValue.query('/TMMsg_JobOption/*') AS 'options'
												FROM    #displayNameSubtaskXML SOPTIONS
												WHERE   SOPTIONS.subTaskId = STASK.subTaskId
											FOR
												XML PATH('') ,
													TYPE
										)
									END
								FROM      TM_subTask AS STASK WITH (NOLOCK)
										LEFT OUTER JOIN TM_PatternAssoc
											AS PAS WITH (NOLOCK) ON PAS.subTaskId = STASK.subTaskId
										LEFT OUTER JOIN TM_Pattern
											AS PAT WITH (NOLOCK) ON PAT.patternId = PAS.patternId
										LEFT OUTER JOIN TM_RunTime
											AS NRT WITH (NOLOCK) ON NRT.patternId = PAS.patternId
													AND NRT.processed = 0
										LEFT OUTER JOIN #subTaskList subTaskList ON subTaskList.subtaskID = STASK.subTaskId
										LEFT OUTER JOIN #taskList taskList ON STASK.taskId = taskList.taskId
								WHERE     STASK.subTaskId = PAS.subTaskId
									AND STASK.taskId = [TM_Task].taskId
									AND PAT.deleted = 0
									AND
									(
subTaskType <> 1
										OR
										(
subTaskType = 1
											AND
											(
												(
STASK.operationType NOT IN (4004) AND @canUserSeeAllAdminSchedules = 1
												)
												OR
												(
STASK.operationType IN (4004) AND @canUserSeeAllReports = 1
												)
												OR
												(
													[TM_Task].taskId in (SELECT DISTINCT taskId FROM #AssocEntity)
												)
												OR (taskList.taskId IS NOT NULL AND taskList.taskId>0)
												OR [TM_Task].ownerId = @userId
												-- User is associated to the schedule directly.
												OR (subTaskList.subtaskID IS NOT NULL AND subTaskList.subtaskID>0)
												OR TM_Task.policyType = 13 -- workflow policy type
											)
										)
									)
						FOR
							XML PATH('subTasks') , TYPE
						)
					FROM   dbo.TM_Task WITH (NOLOCK)
						INNER JOIN
						(
							select distinct taskTble.taskId from #taskTble taskTble
						) AS ASS ON ASS.taskId = dbo.TM_Task.taskId
						--INNER JOIN dbo.TM_AssocEntity ON dbo.TM_AssocEntity.taskId = dbo.TM_Task.taskId
						LEFT OUTER JOIN #taskList taskList ON ASS.taskId = taskList.taskId
						LEFT OUTER JOIN dbo.UMUsers AS USR WITH (NOLOCK) ON dbo.TM_Task.ownerId = USR.id
						LEFT OUTER JOIN dbo.NTnotificationRule WITH (NOLOCK) ON dbo.NTnotificationRule.id = dbo.TM_Task.alertId
						--LEFT OUTER JOIN TM_SubTask S WITH (NOLOCK) ON S.taskId = dbo.TM_Task.taskId
						--JOIN @operationFilter OPF ON OPF.operationType = S.operationType OR OPF.operationType = 0
				WHERE  [TM_Task].[deleted] = 0
						AND [TM_Task].[invalid] = 0
						--AND [TM_Task].[uninstalled] = 0
						AND [TM_Task].[savedReport] = 0
						AND
						( [TM_Task].taskId in (SELECT DISTINCT taskId FROM #AssocEntity)	--MR46115 Do not show schedule policy w/ 0 association on CS schedule tab
							OR
							(
[TM_Task].taskId in (SELECT taskId FROM TM_SubTask WITH (NOLOCK) WHERE subTaskType = 1 )
							)
							OR ([TM_Task].ownerId = @userId)
							OR (@isUserAdmin = 1)
							OR (taskList.taskId IS NOT NULL AND taskList.taskId>0)
						)
						AND [TM_Task].taskId not in (SELECT taskId FROM TM_SubTask WITH (NOLOCK) WHERE OperationType = 5014 )
AND ( [TM_Task].[taskType] IN ( 2, 4  ) )
						AND [TM_Task].[hidden] = 0
						AND (TM_Task.isEZOperation = @EZPolicyFilter OR @EZPolicyFilter = 0)
			FOR
				XML PATH('taskDetail') ,
					ROOT('TMMsg_GetTaskListResp')
			)
	END
	IF @xmlText IS null
	BEGIN
		SET @xmlText = '<TMMsg_GetTaskListResp/>'
	END
	IF OBJECT_ID('tempdb.dbo.#taskTble') IS NOT null
		DROP TABLE #taskTble
	IF OBJECT_ID('tempdb.dbo.#Assocociations') IS NOT null
		DROP TABLE #Assocociations
	IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
		DROP TABLE #AssocEntity
	IF OBJECT_ID('tempdb.dbo.#AdminAssocociations') IS NOT null
		DROP TABLE #AdminAssocociations
	IF OBJECT_ID('tempdb.dbo.#BackupAssocociations') IS NOT null
		DROP TABLE #BackupAssocociations
	IF object_id('tempdb.dbo.#subTaskList') is not null
		DROP TABLE #subTaskList
	IF object_id('tempdb.dbo.#taskList') is not null
		DROP TABLE #taskList
	IF object_id('tempdb.dbo.#displayNameSubtaskXML') is not null
		DROP TABLE #displayNameSubtaskXML
	IF object_id('tempdb.dbo.#clientAndCG') is not null
		DROP TABLE #clientAndCG
	IF object_id('tempdb.dbo.#CCGXML') is not null
		DROP TABLE #CCGXML
	IF object_id('tempdb.dbo.#Clients_Timezone_StartTime') is NOT NULL
	BEGIN
		DROP TABLE #Clients_Timezone_StartTime
	END
	IF object_id('tempdb.dbo.#SubClients_Timezone_StartTime') is NOT NULL
	BEGIN
		DROP TABLE #SubClients_Timezone_StartTime
	END
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetCommCellTaskList')
	delete from GxQscripts where name = 'TM_GetCommCellTaskList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetCommCellTaskList')
	delete from GXDBVersions where aliasname = 'TM_GetCommCellTaskList'
GO

insert into GXDBVersions values(2, 'TM_GetCommCellTaskList',  'v1.23.2.34.4.1', 'TM_GetCommCellTaskList', 'v1.23.2.34.4.1')
GO

