

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetClientEntityTaskList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetClientEntityTaskList.sp,v $ $Id: TM_GetClientEntityTaskList.sp,v 1.17.42.31.4.2 2021/05/03 05:09:05 mnatarajan Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 02/14/2012
-- Description:	Get the list of OSC schedules.
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_GetClientEntityTaskList')
BEGIN
	print '>>> Drop Stored Procedure: TM_GetClientEntityTaskList <<<'
	drop procedure TM_GetClientEntityTaskList
END
IF EXISTS (select * from GxQscripts where name='TM_GetClientEntityTaskList')
	delete from GxQscripts where name = 'TM_GetClientEntityTaskList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetClientEntityTaskList')
	delete from GXDBVersions where aliasname = 'TM_GetClientEntityTaskList'
GO
print '... Creating Procedure: TM_GetClientEntityTaskList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_GetClientEntityTaskList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userId integer,
  @localeId_in integer,
  @clientGroupId integer,
  @clientId integer,
  @appTypeId integer,
  @instanceId integer,
  @backupsetId integer,
  @subclientId integer,
  @xmlText XML	OUTPUT
AS
BEGIN
SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @type INT
DECLARE @allBackup INT = 1
DECLARE @allRestore INT = 8
DECLARE @allAdmin INT = 2000
DECLARE @subTaskTypeAdmin INT = 1
DECLARE @subTaskTypeBackup INT = 2
DECLARE @subTaskTypeRestore INT = 3
	DECLARE @allTasks INT = 0
	DECLARE @showAllTasks INT = 0
	DECLARE @nowUtcTime DATETIME = GETUTCDATE()
	DECLARE @nowUtcUnix INT = datediff(second, '01/01/1970', @nowUtcTime)
--INITIALIZATION
	IF object_id('tempdb.dbo.#taskTble') is not null 		DROP TABLE #taskTble
	Create TABLE #taskTble( taskId INT )
	CREATE CLUSTERED INDEX taskTble_taskId_Index ON #taskTble (taskId)
	IF object_id('tempdb.dbo.#taskAppTypeTbleForAssocFilter') is not null 		DROP TABLE #taskAppTypeTbleForAssocFilter
	Create TABLE #taskAppTypeTbleForAssocFilter( taskId INT, clientId INT, appTypeId INT primary key(taskId,clientId, appTypeId) )
	DECLARE @operationFilter TABLE ( operationType INT )
	DECLARE @subTaskFilter TABLE ( subTaskType INT )
	--IF object_id('tempdb.dbo.#entitiesWithViewSchedCapability') is not null
	--	DROP TABLE #entitiesWithViewSchedCapability
	--SEC_TABLE_DEFINE(#entitiesWithViewSchedCapability)
	--EXEC sec_getUserObjects @userId, 0, 0, '#entitiesWithViewSchedCapability'
	-- needed so that we can join on a user with no privilages
	--IF (SELECT COUNT(*) FROM #entitiesWithViewSchedCapability) = 0
	--AVOID DUPLICATE ROWS WHEN CHECKING OWNER
	--BEGIN
	--	INSERT INTO #entitiesWithViewSchedCapability (capabilities, flag, commCellId, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subClientId,
	--	mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId, reviewSetId, querySetId, downloadSetId, ermId, legalHoldId, tagId, cdPolicyId, complianceReportId, taskId)
	--	VALUES (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
	--END
	--GET TYPE
	SET @type = ISNULL(( SELECT ref.value('@type', 'int')
							FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
						), 0)
	--CREATE THE TEMP TABLE--
	IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
		DROP TABLE #AssocEntity
	CREATE TABLE #AssocEntity
	(
			assocType INT,
			taskId INT,
			clientGroupId INT,
			clientId INT,
			apptypeId INT,
			instanceId INT,
			backupsetId INT,
			subclientId INT,
			policyId INT,
			policyName NVARCHAR(1024),
			copyId INT,
			mediaAgentId INT,
			mediaAgentName NVARCHAR(1024),
			srmReportSet INT,
			srmReportType INT,
			srmReportName NVARCHAR(1024),
			copyName  NVARCHAR(1024),
			clientGroupName  NVARCHAR(1024),
			clientName  NVARCHAR(1024),
			displayName  NVARCHAR(1024),
			appTypeName  NVARCHAR(1024),
			subclientName  NVARCHAR(1024),
			backupsetName  NVARCHAR(1024),
			instanceName NVARCHAR(1024),
			trackingPolicyId INT,
			agentlessPolicyId INT,
			exclude INT,
			nextRunTime INT DEFAULT 0,
			planId INT DEFAULT 0,
			planName NVARCHAR(1024) DEFAULT''
	)
	-- 2048 is Data protection capability
	-- 4 is agent scheduling capability
	-- 1073741824 is View capability
	DECLARE @doesUserHaveCCAssoc INT = 0
	DECLARE @doesUserHaveCCAdminCap		INT = 0
DECLARE @_EV_VIEW                   BIGINT = POWER(2, 31-1)
DECLARE @_EV_SCHEDULE_APPLICATION   INT = POWER(2, 3-1)
DECLARE @_EV_BACKUP                 INT = POWER(2, 12-1)
DECLARE @_EV_SCHEDULE_ADMIN			INT = POWER(2, 1-1)
	if exists(select 1 from #entitiesWithViewSchedCapability sec where
			( (((capabilities& @_EV_BACKUP) <> 0) AND ((capabilities & @_EV_SCHEDULE_APPLICATION) <> 0)) OR ((capabilities&@_EV_VIEW) <> 0)) AND
( sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0 )
		)
	BEGIN
		set @doesUserHaveCCAssoc=1
	END
	IF EXISTS(SELECT 1 FROM #entitiesWithViewSchedCapability sec WHERE
			( (capabilities& @_EV_SCHEDULE_ADMIN) <> 0 OR (capabilities & @_EV_VIEW) <> 0) AND
( sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0 )
		)
	BEGIN
		SET @doesUserHaveCCAdminCap = 1
	END
	IF OBJECT_ID('tempdb.dbo.#TM_AssocEntityFromTbl') IS NOT null
            DROP TABLE #TM_AssocEntityFromTbl
	SELECT *
	INTO #TM_AssocEntityFromTbl
	FROM TM_AssocEntity
	-- Fill appType if its 0 and subclient is passed.
	IF (@appTypeId = 0 AND @subclientId>0)
	BEGIN
		SELECT @appTypeId = appTypeID FROM App_application (NOLOCK) WHERE id = @subclientId
	END
	-- Removing code for associating to default analytics schedule policy since schedule policy is not being used now
	-- Create same index as tm_assocentity
	CREATE INDEX TM_AssocEntityFromTbl_taskId_exclude_idx on #TM_AssocEntityFromTbl (taskId, exclude) include (clientId, apptypeId, instanceId, backupsetId, subclientId)
	--DO BACKUP SCHEDULES SECURITY CHECK
	INSERT INTO    #AssocEntity
	SELECT DISTINCT TM_AssocEntity.assocType ,
		TM_AssocEntity.taskId ,
		TM_AssocEntity.clientGroupId ,
		TM_AssocEntity.clientId ,
		TM_AssocEntity.apptypeId ,
		TM_AssocEntity.instanceId ,
		TM_AssocEntity.backupsetId ,
		TM_AssocEntity.subclientId ,
		TM_AssocEntity.policyId ,
		'' AS policyName ,
		TM_AssocEntity.copyId ,
		TM_AssocEntity.mediaAgentId,
		dbo.APP_Client.name AS mediaAgentName,
		TM_AssocEntity.srmReportSet AS srmReportSet,
		TM_AssocEntity.srmReportType AS srmReportType,
		'' AS srmReportName,
		'' AS copyName ,
		dbo.APP_ClientGroup.name AS clientGroupName ,
		dbo.APP_Client.name AS clientName ,
		dbo.APP_Client.displayName AS displayName ,
		dbo.APP_iDAType.name AS appTypeName ,
		dbo.APP_Application.subclientName ,
		dbo.APP_BackupSetName.name AS backupsetName ,
		dbo.APP_InstanceName.name AS instanceName,
		TM_AssocEntity.trackingPolicyId AS trackingPolicyId,
		TM_AssocEntity.agentlessPolicyId,
		TM_AssocEntity.exclude,
		0,
		0,
		''
	FROM #TM_AssocEntityFromTbl TM_AssocEntity WITH (NOLOCK)
		INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = TM_AssocEntity.taskId
		INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = TM_AssocEntity.taskId
			AND
			(
SA.subTaskType=2
				OR
				(
SA.subTaskType=1
					AND
SA.operationType IN (4028, 4043, 5020,  4022, 5023 , 5025 )	--MR:113482 - BACKUP COPY CAN BE CREATED FOR SUBCLIENT. WILL HAVE POLICYID AND SUBCLIENTID.
				)
			)
		INNER JOIN #entitiesWithViewSchedCapability sec ON  @userId = TA.ownerId OR
		((capabilities&1073743876) <> 0) AND
		(
			--((EV_BACKUP AND EV_MANAGE_APPLICATION) OR EV_VISIBILITY)
			(
				(((capabilities&2048) <> 0) AND ((capabilities & 4) <> 0)) OR ((capabilities&1073741824) <> 0))
			AND
			(
				( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
					(
						-- Security check is not done correctly when user is associated to review set.
						(
						(TM_AssocEntity.clientId = sec.clientId  AND TM_AssocEntity.clientId>0
						)
						OR
						(TM_AssocEntity.clientId = 0 AND
							(sec.clientGroupId = TM_AssocEntity.clientGroupId and TM_AssocEntity.clientGroupId>0 --OR
								--dbo.TM_AssocEntity.clientGroupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId=sec.clientId)
							)
						)
						)
					AND (TM_AssocEntity.appTypeId     = sec.appTypeId   OR  TM_AssocEntity.appTypeId = 0  OR sec.appTypeId = 0 )
					AND (TM_AssocEntity.instanceId    = sec.instanceId  OR  TM_AssocEntity.instanceId  = 0  OR sec.instanceId = 0 )
					AND (TM_AssocEntity.backupsetId   = sec.backupSetId OR  TM_AssocEntity.backupsetId = 0  OR sec.backupSetId = 0 )
					AND (TM_AssocEntity.subclientId   = sec.subClientId OR  TM_AssocEntity.subclientId = 0  OR sec.subClientId = 0 )
					AND (TA.taskId   = sec.taskId OR sec.taskId = 0 )
					)
					OR --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
					(
						@doesUserHaveCCAssoc = 1
					)
				)
			)
		)
		LEFT OUTER JOIN dbo.APP_ClientGroup WITH (NOLOCK) ON TM_AssocEntity.clientGroupId = dbo.APP_ClientGroup.id
		LEFT OUTER JOIN dbo.APP_Client WITH (NOLOCK) ON TM_AssocEntity.clientId = dbo.APP_Client.id OR TM_AssocEntity.mediaAgentId = dbo.APP_Client.id
		LEFT OUTER JOIN dbo.APP_iDAType WITH (NOLOCK) ON TM_AssocEntity.apptypeId = dbo.APP_iDAType.type
		LEFT OUTER JOIN dbo.APP_Application WITH (NOLOCK) ON TM_AssocEntity.subclientId = dbo.APP_Application.id
		LEFT OUTER JOIN dbo.APP_BackupSetName WITH (NOLOCK) ON TM_AssocEntity.backupsetId = dbo.APP_BackupSetName.id
		LEFT OUTER JOIN dbo.APP_InstanceName WITH (NOLOCK) ON TM_AssocEntity.instanceId = dbo.APP_InstanceName.id
		WHERE   ( ( TM_AssocEntity.[clientId] = @clientId and @clientId>0 )
					OR ( @clientId = 0 AND @clientGroupId = 0 )
					OR ( TM_AssocEntity.[clientId] = 0 AND TM_AssocEntity.[clientGroupId] = 0 ) -- In case Task is associated to all clients.
					OR ( TM_AssocEntity.[clientId] = 0 AND @clientGroupId > 0 AND TM_AssocEntity.[clientGroupId] = @clientGroupId )
					--OR ( TM_AssocEntity.[clientId] = 0 AND @clientId > 0 AND TM_AssocEntity.[clientGroupId] IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE clientId=@clientId))
				)
				AND ( TM_AssocEntity.[apptypeId] = @appTypeId
						OR @appTypeId = 0
						OR TM_AssocEntity.[apptypeId] = 0
					)
				AND ( TM_AssocEntity.[instanceId] = @instanceId
						OR @instanceId = 0
						OR TM_AssocEntity.[instanceId] = 0
					)
				AND ( TM_AssocEntity.[backupsetId] = @backupsetId
						OR @backupsetId = 0
						OR TM_AssocEntity.[backupsetId] = 0
					)
				AND ( TM_AssocEntity.[subclientId] = @subclientId
						OR @subclientId = 0
						OR TM_AssocEntity.[subclientId] = 0
					)
AND TM_AssocEntity.assocType NOT IN ( 132,158) -- filtering SEA DATA SOURCE ENTITY AND PLAN ENTITY
			UNION
			-- Now find schedules/policies associated at client group level and view schedules is done on one of its clients. Do for below case where owner isnt considered.
			SELECT dbo.TM_AssocEntity.assocType ,
		dbo.TM_AssocEntity.taskId ,
		dbo.TM_AssocEntity.clientGroupId ,
		dbo.TM_AssocEntity.clientId ,
		dbo.TM_AssocEntity.apptypeId ,
		dbo.TM_AssocEntity.instanceId ,
		dbo.TM_AssocEntity.backupsetId ,
		dbo.TM_AssocEntity.subclientId ,
		dbo.TM_AssocEntity.policyId ,
		'' AS policyName ,
		dbo.TM_AssocEntity.copyId ,
		dbo.TM_AssocEntity.mediaAgentId,
		NULL AS mediaAgentName,
		dbo.TM_AssocEntity.srmReportSet AS srmReportSet,
		dbo.TM_AssocEntity.srmReportType AS srmReportType,
		'' AS srmReportName,
		'' AS copyName ,
		dbo.APP_ClientGroup.name AS clientGroupName ,
		NULL AS clientName ,
		NULL AS displayName ,
		'Default Application Type Name' AS appTypeName , -- default app name for type 0
		NULL ,
		NULL AS backupsetName ,
		NULL AS instanceName,
		dbo.TM_AssocEntity.trackingPolicyId AS trackingPolicyId,
		dbo.TM_AssocEntity.agentlessPolicyId,
		dbo.TM_AssocEntity.exclude,
		0,0,''
	FROM dbo.TM_AssocEntity WITH (NOLOCK)
		INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = dbo.TM_AssocEntity.taskId
		INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = dbo.TM_AssocEntity.taskId
			AND
			(
SA.subTaskType=2
				OR
				(
SA.subTaskType=1
					AND
SA.operationType IN (4028, 4043, 5020 , 5023, 5025 )	--MR:113482 - BACKUP COPY CAN BE CREATED FOR SUBCLIENT. WILL HAVE POLICYID AND SUBCLIENTID.
				)
			)
		INNER JOIN App_clientGroupAssoc WITH (NOLOCK) ON (TM_AssocEntity.clientId = 0 AND TM_AssocEntity.clientGroupId = App_clientGroupAssoc.clientGroupId AND TM_AssocEntity.clientGroupId>0)
		-- changed the order of joins since condition before caused the no of security rows matching join condition to be extremely high and delay output in some cases.
		-- If we try with userId = 1 on prodCS. So changed it to return one dummy row to allow condition @userId = TA.ownerId to be matched since its inner join
		INNER JOIN
		(
			select clientId from #entitiesWithViewSchedCapability where
			((capabilities&1073743876) <> 0) AND
			--((EV_BACKUP AND EV_MANAGE_APPLICATION) OR EV_VISIBILITY)
			(
				(((capabilities&2048) <> 0) AND ((capabilities & 4) <> 0)) OR ((capabilities&1073741824) <> 0)
			)
			UNION
			SELECT 0
		) sec ON (App_clientGroupAssoc.clientId = sec.clientId or @doesUserHaveCCAssoc=1 OR @userId = TA.ownerId)
		INNER JOIN dbo.APP_ClientGroup WITH (NOLOCK) ON dbo.TM_AssocEntity.clientGroupId = dbo.APP_ClientGroup.id
		WHERE   ( App_clientGroupAssoc.clientId = @clientId and @clientId>0 ) OR
		(dbo.TM_AssocEntity.clientGroupId = @clientGroupId and @clientGroupId > 0 )
AND TM_AssocEntity.assocType NOT IN ( 132,158) -- filtering SEA DATA SOURCE ENTITY AND PLAN ENTITY
			UNION
			-- Now find schedules/policies associated at client group level and view schedules is done on one of its clients. Do for below case where owner isnt considered.
			-- Above condition didnt handle task security
			SELECT dbo.TM_AssocEntity.assocType ,
		dbo.TM_AssocEntity.taskId ,
		dbo.TM_AssocEntity.clientGroupId ,
		dbo.TM_AssocEntity.clientId ,
		dbo.TM_AssocEntity.apptypeId ,
		dbo.TM_AssocEntity.instanceId ,
		dbo.TM_AssocEntity.backupsetId ,
		dbo.TM_AssocEntity.subclientId ,
		dbo.TM_AssocEntity.policyId ,
		'' AS policyName ,
		dbo.TM_AssocEntity.copyId ,
		dbo.TM_AssocEntity.mediaAgentId,
		NULL AS mediaAgentName,
		dbo.TM_AssocEntity.srmReportSet AS srmReportSet,
		dbo.TM_AssocEntity.srmReportType AS srmReportType,
		'' AS srmReportName,
		'' AS copyName ,
		dbo.APP_ClientGroup.name AS clientGroupName ,
		NULL AS clientName ,
		NULL AS displayName ,
		'Default Application Type Name' AS appTypeName , -- default app name for type 0
		NULL ,
		NULL AS backupsetName ,
		NULL AS instanceName,
		dbo.TM_AssocEntity.trackingPolicyId AS trackingPolicyId,
		dbo.TM_AssocEntity.agentlessPolicyId,
		dbo.TM_AssocEntity.exclude,
		0,0,''
	FROM dbo.TM_AssocEntity WITH (NOLOCK)
		INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = dbo.TM_AssocEntity.taskId
		INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = dbo.TM_AssocEntity.taskId
			AND
			(
SA.subTaskType=2
				OR
				(
SA.subTaskType=1
					AND
SA.operationType IN (4028, 4043, 5020, 5023 ,5025 )	--MR:113482 - BACKUP COPY CAN BE CREATED FOR SUBCLIENT. WILL HAVE POLICYID AND SUBCLIENTID.
				)
			)
		INNER JOIN App_clientGroupAssoc WITH (NOLOCK) ON (TM_AssocEntity.clientId = 0 AND TM_AssocEntity.clientGroupId = App_clientGroupAssoc.clientGroupId AND TM_AssocEntity.clientGroupId>0)
		-- changed the order of joins since condition before caused the no of security rows matching join condition to be extremely high and delay output in some cases.
		-- If we try with userId = 1 on prodCS. So changed it to return one dummy row to allow condition @userId = TA.ownerId to be matched since its inner join
		INNER JOIN #entitiesWithViewSchedCapability sec ON sec.TaskId = TA.taskId
		INNER JOIN dbo.APP_ClientGroup WITH (NOLOCK) ON dbo.TM_AssocEntity.clientGroupId = dbo.APP_ClientGroup.id
		WHERE   ( App_clientGroupAssoc.clientId = @clientId and @clientId>0 ) OR
		(dbo.TM_AssocEntity.clientGroupId = @clientGroupId and @clientGroupId > 0 )
AND TM_AssocEntity.assocType NOT IN ( 132,158) -- filtering SEA DATA SOURCE ENTITY AND PLAN ENTITY
		--Fetch all associations from plan based assoc entity without client Group
		UNION
		SELECT DISTINCT TMA.assocType ,
			TMA.taskId ,
			TMA.clientGroupId ,
			TMA.clientId ,
			TMA.apptypeId ,
			TMA.instanceId ,
			TMA.backupsetId ,
			TMA.subclientId ,
			TM_AssocEntity.policyId ,
			'' AS policyName ,
			TM_AssocEntity.copyId ,
			TM_AssocEntity.mediaAgentId,
			'' AS mediaAgentName,
			TM_AssocEntity.srmReportSet AS srmReportSet,
			TM_AssocEntity.srmReportType AS srmReportType,
			'' AS srmReportName,
			'' AS copyName ,
			'' AS clientGroupName ,
			C.name AS clientName ,
			C.displayName AS displayName ,
			IDA.name AS appTypeName ,
			APP.subclientName AS subclientName ,
			BK.name AS backupsetName ,
			INS.name AS instanceName,
			TM_AssocEntity.trackingPolicyId AS trackingPolicyId,
			TM_AssocEntity.agentlessPolicyId,
			TM_AssocEntity.exclude,
			0,
			P.id AS planId,
			P.name AS planName
		FROM #TM_AssocEntityFromTbl TM_AssocEntity WITH (NOLOCK)
			INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = TM_AssocEntity.taskId
			INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = TM_AssocEntity.taskId
AND SA.subTaskType=2
			INNER JOIN #entitiesWithViewSchedCapability sec ON  @userId = TA.ownerId OR
			(
				(capabilities&1073743876 <> 0)
				AND
				(	--((EV_BACKUP AND EV_MANAGE_APPLICATION) OR EV_VISIBILITY)
					(
						((capabilities&2048 <> 0) AND (capabilities & 4 <> 0))
						OR
						(capabilities&1073741824 <> 0)
					)
					OR --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
					(
						@doesUserHaveCCAssoc = 1
					)
				)
			)
			INNER JOIN dbo.TM_Associations TMA WITH (NOLOCK) ON TMA.taskId = TM_AssocEntity.taskId
			AND
			(
				((TMA.clientId = @clientId AND @clientId > 0))
				AND ((TMA.appTypeId = @appTypeId AND @appTypeId > 0) OR (@appTypeId = 0))
				AND ((TMA.instanceId = @instanceId AND @instanceId > 0) OR (@instanceId = 0))
				AND ((TMA.backupSetId = @backupsetId AND @backupsetId > 0) OR (@backupsetId = 0))
				AND ((TMA.subclientId = @subclientId AND @subclientId > 0) OR (@subclientId = 0))
            )
			INNER JOIN dbo.APP_Plan P WITH (NOLOCK) ON TMA.entityId = P.id
			INNER JOIN APP_Application APP WITH(NOLOCK) ON APP.id = TMA.subclientId AND APP.subclientStatus & 4 = 0
			LEFT JOIN APP_BackupSetName BK WITH(NOLOCK) ON BK.id = TMA.backupSetId
			LEFT JOIN APP_InstanceName INS WITH(NOLOCK) ON INS.id = TMA.instanceId
			LEFT JOIN APP_Client C WITH(NOLOCK) ON C.id = TMA.clientId
			LEFT JOIN APP_iDAType IDA WITH (NOLOCK) ON TMA.apptypeId = IDA.type
WHERE TMA.assocType = 158 AND @clientGroupId = 0
		--Fetch associations when clientGroup information is provided
		UNION
		SELECT DISTINCT TMA.assocType ,
			TMA.taskId ,
			TMA.clientGroupId ,
			TMA.clientId ,
			TMA.apptypeId ,
			TMA.instanceId ,
			TMA.backupsetId ,
			TMA.subclientId ,
			TM_AssocEntity.policyId ,
			'' AS policyName ,
			TM_AssocEntity.copyId ,
			TM_AssocEntity.mediaAgentId,
			'' AS mediaAgentName,
			TM_AssocEntity.srmReportSet AS srmReportSet,
			TM_AssocEntity.srmReportType AS srmReportType,
			'' AS srmReportName,
			'' AS copyName ,
			CG.name AS clientGroupName ,
			C.name AS clientName ,
			C.displayName AS displayName ,
			IDA.name AS appTypeName ,
			APP.subclientName AS subclientName ,
			BK.name AS backupsetName ,
			INS.name AS instanceName,
			TM_AssocEntity.trackingPolicyId AS trackingPolicyId,
			TM_AssocEntity.agentlessPolicyId,
			TM_AssocEntity.exclude,
			0,
			P.id AS planId,
			P.name AS planName
		FROM #TM_AssocEntityFromTbl TM_AssocEntity WITH (NOLOCK)
			INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = TM_AssocEntity.taskId
			INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = TM_AssocEntity.taskId
AND SA.subTaskType=2
			INNER JOIN #entitiesWithViewSchedCapability sec ON  @userId = TA.ownerId OR
			(
				(capabilities&1073743876 <> 0)
				AND
				(	--((EV_BACKUP AND EV_MANAGE_APPLICATION) OR EV_VISIBILITY)
					(
						((capabilities&2048 <> 0) AND (capabilities & 4 <> 0))
						OR
						(capabilities&1073741824 <> 0)
					)
					OR --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
					(
						@doesUserHaveCCAssoc = 1
					)
				)
			)
			INNER JOIN dbo.TM_Associations TMA WITH (NOLOCK) ON TMA.taskId = TM_AssocEntity.taskId
			AND
			(
				(
					(TMA.clientId IN (SELECT CGA.clientId FROM APP_ClientGroupAssoc CGA WITH(NOLOCK) WHERE CGA.clientGroupId = @clientGroupId AND @clientGroupId > 0))
					AND
					((TMA.clientId = @clientId AND @clientId > 0) OR @clientId = 0)
				)
				AND ((TMA.appTypeId = @appTypeId AND @appTypeId > 0) OR (@appTypeId = 0))
				AND ((TMA.instanceId = @instanceId AND @instanceId > 0) OR (@instanceId = 0))
				AND ((TMA.backupSetId = @backupsetId AND @backupsetId > 0) OR (@backupsetId = 0))
				AND ((TMA.subclientId = @subclientId AND @subclientId > 0) OR (@subclientId = 0))
            )
			INNER JOIN dbo.APP_Plan P WITH (NOLOCK) ON TMA.entityId = P.id
			INNER JOIN APP_Application APP WITH(NOLOCK) ON APP.id = TMA.subclientId AND APP.subclientStatus & 4 = 0
			LEFT JOIN APP_BackupSetName BK WITH(NOLOCK) ON BK.id = TMA.backupSetId
			LEFT JOIN APP_InstanceName INS WITH(NOLOCK) ON INS.id = TMA.instanceId
			LEFT JOIN APP_Client C WITH(NOLOCK) ON C.id = TMA.clientId
			LEFT JOIN APP_iDAType IDA WITH (NOLOCK) ON TMA.apptypeId = IDA.type
			LEFT JOIN APP_ClientGroup CG WITH(NOLOCK) ON CG.id = @clientGroupId
WHERE TMA.assocType = 158
	DELETE #AssocEntity WHERE policyId > 0 AND clientId = 0		--MR:113482 - REMOVE ASSOCIATION WITH ONLY POLICYID
--select * from #AssocEntity
	--LM Schdules
if
	  (@subclientId=0 and
	  @instanceId=0 and
	  @backupsetId=0 )
      begin
	INSERT INTO    #AssocEntity
	SELECT DISTINCT  0 ,
			TA.taskId ,
			dbo.APP_ClientGroup.Id ,
			dbo.APP_Client.Id ,
			0 ,
			0 ,
			0 ,
			0 ,
			0 ,
			' ' AS policyName ,
			0 ,
			0,
			' ' AS mediaAgentName,
			0 AS srmReportSet,
			0 AS srmReportType,
			' 'AS srmReportName,
		    ' ' AS copyName ,
			dbo.APP_ClientGroup.name AS clientGroupName ,
			dbo.APP_Client.name AS clientName ,
			dbo.APP_Client.displayName AS displayName ,
			'' AS appTypeName ,
			'' ,
			'' AS backupsetName ,
			'' AS instanceName,
			0 AS trackingPolicyId,
			0,
			0,
			0,0,''
			FROM	dbo.APP_MonitorAssocEntity  MAE WITH (NOLOCK)
INNER JOIN  TM_SubTaskOptions STO WITH (NOLOCK) on STO.optionId=1464199408 and value=monitorPolicyId
			inner join TM_SubTask ST WITH (NOLOCK) on STO.subTaskId=ST.subTaskId
			INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = ST.taskId
			INNER JOIN APP_MonitorTemplateAssoc  MPT on MAE.monitorPolicyId=MPT.monitorPolicyId
			LEFT OUTER JOIN dbo.APP_ClientGroup WITH (NOLOCK) ON (MAE.clientGroupId = dbo.APP_ClientGroup.id and MAE.flags=28)
			LEFT OUTER JOIN dbo.APP_Client WITH (NOLOCK) ON MAE.clientId = dbo.APP_Client.id  OR  MAE.flags=2
				INNER JOIN #entitiesWithViewSchedCapability sec ON  @userId = TA.ownerId OR
			((capabilities&1073741825) <> 0) AND
			(
				--EV_SCHEDULE_ADMIN  OR EV_VISIBILITY
				(((capabilities&1) <> 0) OR ((capabilities&1073741824) <> 0))
				AND
				(
					( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
						(
							dbo.APP_client.Id = sec.clientId
							OR
							(MAE.clientId = 0 AND
								(sec.clientGroupId =MAE.clientGroupId   OR
									MAE.clientGroupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId=sec.clientId)
								)
								AND MAE.flags=28
							)
						)
						AND (TA.taskId   = sec.taskId OR sec.taskId = 0 )
						--IGNORE SECURITY CHECK FOR ADMIN TASK FOR NOW, IT WILL BE DONE AT THE VIEW LEVEL BELOW
					)
					OR --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
					(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
					)
				)
			)
			where ( ( dbo.APP_Client.id = @clientId )
					OR ( @clientId = 0 AND @clientGroupId = 0 )
					OR ( MAE.clientId = 0 AND MAE.clientGroupId = @clientGroupId and MAE.flags=28 AND @clientGroupId>0)
					OR ( MAE.flags=28 and MAE.clientId = 0 AND MAE.clientGroupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE clientId=@clientId))
				)
				and APP_Client.id!=0
				and APP_Client.id not in ( select clientId from APP_MonitorAssocEntity where exclude=1 and monitorPolicyId=MAE.monitorPolicyId)
				AND APP_Client.releaseId>=15
				AND ( (templateId<>2 AND templateId<>5)
					OR(templateId=2 AND (simOperatingSystemId in( select id from simOperatingSystem WITH (NOLOCK) where TYPE='Windows')))
					OR (templateId=5 AND (simOperatingSystemId in( select id from simOperatingSystem WITH (NOLOCK) where TYPE='Unix'))))
				AND specialClientFlags&2<>2
		end
	--DO RESTORE SCHEDULES SECURITY CHECK
	INSERT INTO    #AssocEntity
	SELECT DISTINCT dbo.TM_AssocEntity.assocType ,
		dbo.TM_AssocEntity.taskId ,
		dbo.TM_AssocEntity.clientGroupId ,
		dbo.TM_AssocEntity.clientId ,
		dbo.TM_AssocEntity.apptypeId ,
		dbo.TM_AssocEntity.instanceId ,
		dbo.TM_AssocEntity.backupsetId ,
		dbo.TM_AssocEntity.subclientId ,
		dbo.TM_AssocEntity.policyId ,
		'' AS policyName ,
		dbo.TM_AssocEntity.copyId ,
		dbo.TM_AssocEntity.mediaAgentId,
		dbo.APP_Client.name AS mediaAgentName,
		dbo.TM_AssocEntity.srmReportSet AS srmReportSet,
		dbo.TM_AssocEntity.srmReportType AS srmReportType,
		'' AS srmReportName,
		'' AS copyName ,
		dbo.APP_ClientGroup.name AS clientGroupName ,
		dbo.APP_Client.name AS clientName ,
		dbo.APP_Client.displayName AS displayName ,
		dbo.APP_iDAType.name AS appTypeName ,
		dbo.APP_Application.subclientName ,
		dbo.APP_BackupSetName.name AS backupsetName ,
		dbo.APP_InstanceName.name AS instanceName,
		dbo.TM_AssocEntity.trackingPolicyId AS trackingPolicyId,
		dbo.TM_AssocEntity.agentlessPolicyId,
		dbo.TM_AssocEntity.exclude,
		0,0,''
	FROM dbo.TM_AssocEntity WITH (NOLOCK)
		INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = dbo.TM_AssocEntity.taskId
INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = dbo.TM_AssocEntity.taskId AND SA.subTaskType=3
		INNER JOIN #entitiesWithViewSchedCapability sec ON  @userId = TA.ownerId OR
		((capabilities&1076363268) <> 0) AND
		(
			(
				(
					--((EV_RESTORE_IN_PLACE OR EV_RESTORE_OUTOF_PLACE) AND (EV_MANAGE_APPLICATION)) OR EV_VISIBILITY)
					(((capabilities&524288) <> 0) OR ((capabilities&2097152) <> 0)) AND ((capabilities & 4) <> 0))  OR ((capabilities&1073741824) <> 0)
				)
			AND
			(
				( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
					(
						(
						(dbo.TM_AssocEntity.clientId = sec.clientId AND sec.clientId>0 )
						OR
						(dbo.TM_AssocEntity.clientId = 0 AND
							(sec.clientGroupId = dbo.TM_AssocEntity.clientGroupId OR
								dbo.TM_AssocEntity.clientGroupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId=sec.clientId)
							)
						)
					)
					AND (dbo.TM_AssocEntity.appTypeId     = sec.appTypeId   OR  dbo.TM_AssocEntity.appTypeId = 0  OR sec.appTypeId = 0 )
					AND (dbo.TM_AssocEntity.instanceId    = sec.instanceId  OR  dbo.TM_AssocEntity.instanceId  = 0  OR sec.instanceId = 0 )
					AND (dbo.TM_AssocEntity.backupsetId   = sec.backupSetId OR  dbo.TM_AssocEntity.backupsetId = 0  OR sec.backupSetId = 0 )
					AND (dbo.TM_AssocEntity.subclientId   = sec.subClientId OR  dbo.TM_AssocEntity.subclientId = 0  OR sec.subClientId = 0 )
					AND (TA.taskId   = sec.taskId OR sec.taskId = 0 )
					)
					OR --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
					(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
					)
				)
			)
		)
		LEFT OUTER JOIN dbo.APP_ClientGroup WITH (NOLOCK) ON dbo.TM_AssocEntity.clientGroupId = dbo.APP_ClientGroup.id
		LEFT OUTER JOIN dbo.APP_Client WITH (NOLOCK) ON dbo.TM_AssocEntity.clientId = dbo.APP_Client.id OR dbo.TM_AssocEntity.mediaAgentId = dbo.APP_Client.id
		LEFT OUTER JOIN dbo.APP_iDAType WITH (NOLOCK) ON dbo.TM_AssocEntity.apptypeId = dbo.APP_iDAType.type
		LEFT OUTER JOIN dbo.APP_Application WITH (NOLOCK) ON dbo.TM_AssocEntity.subclientId = dbo.APP_Application.id
		LEFT OUTER JOIN dbo.APP_BackupSetName WITH (NOLOCK) ON dbo.TM_AssocEntity.backupsetId = dbo.APP_BackupSetName.id
		LEFT OUTER JOIN dbo.APP_InstanceName WITH (NOLOCK) ON dbo.TM_AssocEntity.instanceId = dbo.APP_InstanceName.id
		WHERE   ( ( dbo.TM_AssocEntity.[clientId] = @clientId and @clientId>0)
					OR ( @clientId = 0 AND @clientGroupId = 0 )
					OR ( dbo.TM_AssocEntity.[clientId] = 0 AND @clientGroupId > 0 and dbo.TM_AssocEntity.[clientGroupId] = @clientGroupId )
					OR ( dbo.TM_AssocEntity.[clientId] = 0 AND @clientId > 0 AND dbo.TM_AssocEntity.[clientGroupId] IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE clientId=@clientId))
				)
				AND ( dbo.TM_AssocEntity.[apptypeId] = @appTypeId
						OR @appTypeId = 0
						OR dbo.TM_AssocEntity.[apptypeId] = 0
					)
				AND ( dbo.TM_AssocEntity.[instanceId] = @instanceId
						OR @instanceId = 0
						OR dbo.TM_AssocEntity.[instanceId] = 0
					)
				AND ( dbo.TM_AssocEntity.[backupsetId] = @backupsetId
						OR @backupsetId = 0
						OR dbo.TM_AssocEntity.[backupsetId] = 0
					)
				AND ( dbo.TM_AssocEntity.[subclientId] = @subclientId
						OR @subclientId = 0
						OR dbo.TM_AssocEntity.[subclientId] = 0
					)
	--select * from #AssocEntity
	-------------------------------------------------------------------------------------------------------------------------------
	---********************************************************----
	--Virtualize Me Schedules And Data Analytics Schedule
	---********************************************************----
	--Fetch Virtualize Me and Data Analytics schedules if the request is done at client level only.
	--For apptype, instance, backupset and subclient level these schedules need not be fetched.
	--Virtualize Me and Data Analytics schedules can be created only at client level.
	IF(@appTypeId = 0 AND @instanceId = 0 AND @backupSetId = 0 AND @subclientId = 0)
	BEGIN
		INSERT INTO #AssocEntity
		SELECT DISTINCT 0,
					TM_AssocEntity.taskId,
					TM_AssocEntity.clientGroupId,
					dbo.App_Client.id,						--have only clientName.
					0,
					0,
					0,
					0,
					0,
					' ' as policyName,
					0,
					0,
					' ' as mediaAgentName,
					0,
					0,
					' ' as srmReportName,
					' ' as copyName,
					dbo.App_ClientGroup.Name as clientGroupName,
					dbo.App_Client.name as clientName,
					dbo.App_Client.displayName as displayName,
					' ' as appTypeName,
					' ',
					' ' as backupsetName,
					' ' as instanceName,
					0 as trackingpolicyid,
					0,
					0,
					0,0,''
		FROM TM_AssocEntity WITH (NOLOCK)
		INNER JOIN TM_Task TA WITH (NOLOCK) ON TA.taskId = TM_AssocEntity . taskId
		INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = TA.taskId
AND SA.operationType IN (4041, 4022)
		INNER JOIN #entitiesWithViewSchedCapability AS sec
			ON TA.ownerId = @userid OR
			@doesUserHaveCCAdminCap = 1 OR
			((capabilities&1073741825) <> 0) AND
				(
					--EV_SCHEDULE_ADMIN  OR EV_VISIBILITY
					(((capabilities&1) <> 0) OR ((capabilities&1073741824) <> 0))
					AND
					(
						( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
							(
								(dbo.TM_AssocEntity.clientId = sec.clientId  )
								OR
								-- schedule is associated to CG
								( dbo.TM_AssocEntity.clientId = 0 AND
									sec.clientGroupId = dbo.TM_AssocEntity.clientGroupId and dbo.TM_AssocEntity.clientGroupId>0
								)
							)
		                )
					)
				)
		LEFT OUTER JOIN dbo.APP_Client WITH (NOLOCK) ON dbo.TM_AssocEntity.clientId = dbo.APP_Client.id
		LEFT OUTER JOIN dbo.APP_ClientGroup WITH (NOLOCK) ON dbo.TM_AssocEntity.clientGroupId = dbo.APP_ClientGroup.id
		LEFT OUTER JOIN App_clientGroupAssoc WITH (NOLOCK) ON (TM_AssocEntity.clientId = 0 AND TM_AssocEntity.clientGroupId = App_clientGroupAssoc.clientGroupId AND TM_AssocEntity.clientGroupId>0)
		-- check whether view schedules is done at CG level or client level
		WHERE (dbo.TM_AssocEntity.clientId = @clientid AND @clientid>0) -- schedule is associated to client and view schedules done on client.
			OR (dbo.TM_AssocEntity.clientGroupId = @clientGroupID AND @clientGroupID>0) -- schedule is associated to client group and view schedules done on client group node.
			OR (App_clientGroupAssoc.clientId Is NOT NULL AND App_clientGroupAssoc.clientId = @clientid AND @clientid>0) -- schedule is associated to client group and view schedules done on client node.
	END
	--------------------------------------------------------------------------------------------------------------------
	--GET OPERATION TYPES
	INSERT  INTO @operationFilter
		SELECT  ref.value('@val', 'int') AS operationType
		FROM    @xmlText.nodes('TMMsg_GetTaskListReq/filter/operationTypes') R ( ref )
	--LIST OF JOB TASK
	INSERT  INTO #taskTble
	SELECT DISTINCT
			taskId
	FROM    [#AssocEntity]
	--Get Configuration policy schedules on a subclient if subclient has CI policy associations
	IF @doesUserHaveCCAdminCap = 1 AND
		@subclientId > 0 AND
		EXISTS ( SELECT 1 FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Content Indexing Policy ID' AND modified = 0 AND cs_attrName = CHECKSUM(N'Content Indexing Policy ID'))
	BEGIN
		INSERT INTO #taskTble
		SELECT DISTINCT ST.taskId
			FROM APP_Application AAP WITH (NOLOCK)
			INNER JOIN APP_SubClientProp SCP WITH(NOLOCK) ON AAP.id = SCP.componentNameId AND SCP.attrName = 'Content Indexing Policy ID'
				AND SCP.modified = 0 AND SCP.cs_attrName = CHECKSUM(N'Content Indexing Policy ID') AND AAP.id = @subclientId
INNER JOIN TM_SubtaskOptions STO WITH(NOLOCK) ON STO.value =  SCP.attrVal AND STO.optionId = 78814566
INNER JOIN TM_SubTask ST WITH(NOLOCK) ON ST.subTaskId = STO.subTaskId AND ST.operationType = 5022 AND ST.subTaskType = 1
	END
	-- do not show install schedules for index server clients
	DECLARE @isIndexServerClient INT = dbo.IsDistributedPseudoClient(@clientId)
	--ONLY SHOW INSTALL UPDATE AT CLIENT LEVEL
	IF ( ( @clientId > 0 OR @clientGroupId>0 )
		AND @appTypeId=0 AND @instanceId=0 AND @backupsetId=0 AND @subclientId=0 AND @isIndexServerClient =0
		)
	BEGIN
		-- INSERT INSTALL UPDATE SCHEDULE WHERE CLIENT GROUP AND CLIENT ARE PASS AS OPTIONS
		INSERT INTO #taskTble
			SELECT DISTINCT taskId
			FROM TM_SubTask AS ST WITH (NOLOCK)
			WHERE ST.subTaskId IN (
				SELECT subTaskId FROM
				TM_subTaskOptions WITH (NOLOCK)
WHERE (optionId = 239177580 AND ST.operationType=4020 AND
					(
						(CAST(value AS XML).exist('/clientAndClientGroups/@clientId')=1 AND CAST(value AS XML).value('(/clientAndClientGroups/@clientId)[1]', 'INT') = @clientId AND @clientId>0)
							OR (
								(CAST(value AS XML).exist('/clientAndClientGroups/@clientGroupId')=1 AND CAST(value AS XML).value('(/clientAndClientGroups/@clientGroupId)[1]', 'INT') IN (
								SELECT  clientGroupId
								FROM    APP_ClientGroupAssoc CG WITH (NOLOCK)
								WHERE   clientId = @clientId AND @clientId>0 )
								)
								AND
								CAST(value AS XML).exist('/clientAndClientGroups/@clientId')=0
							)
							OR CAST(value AS XML).exist('/clientAndClientGroups/@_type_[.="2"]')=1
						    OR (CAST(value AS XML).exist('/clientAndClientGroups/@clientGroupId')=1 AND CAST(value AS XML).value('(/clientAndClientGroups/@clientGroupId)[1]', 'INT') = @clientGroupId AND @clientGroupId>0)
						)
					)
				)
				AND NOT EXISTS ( SELECT  taskId
										FROM    #taskTble AS TT
										WHERE TT.taskId = ST.taskId)
				--AND @appTypeId=0 AND @instanceId=0 AND @backupsetId=0 AND @subclientId=0 --SHOW INSTALL SCHEDULE ONLY AT CLIENT LEVEL
	END
	--- PRUNE TASK WHICH DONOT HAVE VALID FILTER ASSOCIATIONS OR ARE FOR ONDEMAND BACKUPSET (MR-39351)
	--- THIS IS TRUE ONLY FOR POLICY
	DELETE #taskTble
	FROM #taskTble T
INNER JOIN [TM_Task] AS TSK WITH (NOLOCK) ON T.taskId = TSK.taskId AND TSK.taskType = 4
					INNER JOIN #AssocEntity ASSC WITH (NOLOCK) ON T.taskId = ASSC.taskId
	WHERE
	( @backupsetId <> 0 AND
			EXISTS (SELECT componentNameId
					FROM App_BackupSetProp WITH (NOLOCK)
					WHERE attrName = 'OnDemand Backupset' AND attrVal=1 AND componentNameId=@backupsetId
					)
	)
	OR
	(
		ASSC.exclude=1
		AND ASSC.clientId=@clientId AND @clientId>0
		AND ( ASSC.[apptypeId] = @appTypeId
				OR ASSC.[apptypeId] = 0
			)
		AND ( ASSC.[instanceId] = @instanceId
				OR ASSC.[instanceId] = 0
			)
		AND ( ASSC.[backupsetId] = @backupsetId
				OR ASSC.[backupsetId] = 0
			)
		AND ( ASSC.[subclientId] = @subclientId
				OR ASSC.[subclientId] = 0
			)
	)
	OR
	(
		ASSC.exclude=1
		AND ASSC.clientGroupId=@clientGroupId AND @clientGroupId>0
		AND ASSC.clientId=0
		-- when using "View schedules" from Client Computer Groups for a client, associations with excluded subclients for schedule policies are not displayed anymore TR 190417-126
		-- Dont remove from task table because a subclient is excluded from client from within CG node.
	)
	Insert into #taskAppTypeTbleForAssocFilter(taskId , clientId, appTypeId)
	select distinct ASSC.taskId, @clientId, App_application.appTypeId
	from #AssocEntity ASSC
	inner join App_application on @clientId>0 and App_application.clientId = @clientId and
	(App_application.appTypeId = @appTypeId OR @appTypeId = 0) and
	(ASSC.clientId = App_application.clientId OR ASSC.clientId = 0) and  -- if schedule is associated to client group level and we are viewing schedules at client level, then it will be part of assoc list if client is part of schedules associated CG.
	(ASSC.apptypeId = App_application.appTypeId OR ASSC.apptypeId = 0)
	union
	select distinct ASSC.taskId, App_application.clientId, App_application.appTypeId
	from #AssocEntity ASSC
	inner join App_ClientGroupAssoc on
	(ASSC.clientGroupId = App_ClientGroupAssoc.clientGroupId OR
		(ASSC.clientGroupId = 0 and ASSC.assocType = 27) -- all client groups selected
	)
	and App_ClientGroupAssoc.clientGroupId = @clientGroupId and @clientGroupId>0 AND @clientId = 0 -- Do this only if we request for this at client group level and not all client level.
	inner join App_application on App_application.clientId = App_ClientGroupAssoc.clientId
	DELETE #taskTble
	FROM #taskTble T
	inner join
	(
		SELECT T.taskId
			FROM [TM_AssocFilter] WITH (NOLOCK)
			inner join #taskTble T on
			TM_AssocFilter.taskId = T.taskId
			except
              ( SELECT T.taskId
                     FROM [TM_AssocFilter] FLT WITH (NOLOCK)
					 inner join #taskTble T on
					FLT.taskId = T.taskId
INNER JOIN [TM_Task] AS TSK WITH (NOLOCK) ON T.taskId = TSK.taskId AND TSK.taskType = 4
					INNER JOIN #AssocEntity ASSC WITH (NOLOCK) ON T.taskId = ASSC.taskId
					INNER JOIN #taskAppTypeTbleForAssocFilter taskAppTypeTbleForAssocFilter WITH (NOLOCK) ON
					taskAppTypeTbleForAssocFilter.taskId = ASSC.taskId AND
					(taskAppTypeTbleForAssocFilter.ClientId = ASSC.ClientId OR ASSC.ClientId=0) AND
					(taskAppTypeTbleForAssocFilter.appTypeId = ASSC.appTypeId OR ASSC.appTypeId=0)
					left join APP_AppTypeGroupAssoc on
					(
                            FLT.filter_type = 1 and FLT.filter_value=APP_AppTypeGroupAssoc.appGroupId
                    )
                    where
                     (  -- filter_type, 1 is appgroup and 2 is individual apptype
                           (
                                  FLT.filter_type = 2 AND FLT.filter_value = taskAppTypeTbleForAssocFilter.appTypeId
                           )
                           OR
                           (
                                  FLT.filter_type = 1 AND APP_AppTypeGroupAssoc.appTypeId is not null and APP_AppTypeGroupAssoc.appTypeId = taskAppTypeTbleForAssocFilter.appTypeId
                           )
                     )
              )
		) DeletedTasks
		on DeletedTasks.TaskId = T.TaskId
	-- FILTER OUT SRM REPORTS FROM CLIENT LEVEL
	--IF (@srmReportSet = 0) and (@srmReportType = 0)
	--	DELETE #taskTble
	--	WHERE taskId  IN ( SELECT taskId
	--						FROM [TM_SubTask] WITH (NOLOCK)
	--						WHERE TM_SubTask.operationType = TASK_OPERATION_TYPE_SRM_REPORT)
--	SELECT 'debug2',* from #taskTble
--	select 'debug3',* from tm_task where taskid in ( select taskid from #taskTble)
-- -- SP BODY BEGIN : TM_ComputeStartTimeForClientTbl.spb ----------------------------------------------------------------------------------------------------------------------------------
IF object_id('tempdb.dbo.#Clients_Timezone_StartTime') is NOT NULL
BEGIN
	DROP TABLE #Clients_Timezone_StartTime
END
CREATE TABLE #Clients_Timezone_StartTime(clientId INT, timezoneName NVARCHAR(MAX), jobStartTime INT DEFAULT -1, taskID INT DEFAULT 0, patternID INT DEFAULT 0 )
CREATE CLUSTERED INDEX Clients_Timezone_StartTime_clientId_taskID_Index ON #Clients_Timezone_StartTime (clientId, taskID)
IF object_id('tempdb.dbo.#SubClients_Timezone_StartTime') is NOT NULL
BEGIN
	DROP TABLE #SubClients_Timezone_StartTime
END
CREATE TABLE #SubClients_Timezone_StartTime(appId INT, timezoneName NVARCHAR(MAX), jobStartTime INT DEFAULT -1, taskID INT DEFAULT 0)
CREATE CLUSTERED INDEX SubClients_Timezone_StartTime_appId_Index ON #SubClients_Timezone_StartTime (appId)
-- -- SP BODY END : TM_ComputeStartTimeForClientTbl.spb ------------------------------------------------------------------------------------------------------------------------------------
	INSERT INTO #Clients_Timezone_StartTime(clientId , timezoneName , jobStartTime , taskID , patternID )
	SELECT DISTINCT AssocEntity.clientId, NULL, -1, AssocEntity.taskId, 0
	FROM #AssocEntity AssocEntity
	WHERE clientID > 0
	-- Add all subclients of VSA apptype. Include only cases where schedule is associated at subclient level.
	-- Or view schedules is done at subclient level.
	INSERT INTO #SubClients_Timezone_StartTime(appId , timezoneName, jobStartTime, taskId )
	SELECT DISTINCT subclientId, NULL, -1, AssocEntity.taskId
	FROM #AssocEntity AssocEntity
	INNER JOIN App_Application (NOLOCK) ON AssocEntity.subclientID = App_application.Id
AND App_application.apptypeID = 106
IF @subclientId > 0  AND @appTypeID = 106
	BEGIN
		INSERT INTO #SubClients_Timezone_StartTime(appId , timezoneName, jobStartTime, taskId )
		SELECT DISTINCT @subclientId, NULL, -1 , #AssocEntity.taskId
		FROM #AssocEntity
		LEFT JOIN #SubClients_Timezone_StartTime ON #SubClients_Timezone_StartTime.appID = @subclientID
		AND #SubClients_Timezone_StartTime.taskID = #AssocEntity.taskID
		WHERE #SubClients_Timezone_StartTime.taskID IS NULL
	END
	-- Call stored procedure to compute timezone and start time for clients.
	EXEC TM_ComputeStarttimeForClient
	-- if subclient has timezone then that takes precedence over clients timezone
IF @subclientId > 0  AND @appTypeID = 106
	BEGIN
		IF EXISTS(SELECT 1 FROM #SubClients_Timezone_StartTime WHERE appid = @subclientId AND timezoneName IS NOT NULL AND LEN(timezoneName)>0 )
		BEGIN
			UPDATE #Clients_Timezone_StartTime
			SET timezoneName = #SubClients_Timezone_StartTime.timezoneName
			FROM #Clients_Timezone_StartTime INNER JOIN #SubClients_Timezone_StartTime
			ON #SubClients_Timezone_StartTime.appId = @subclientId
			AND #Clients_Timezone_StartTime.clientID = @clientId
		END
		IF EXISTS(SELECT 1 FROM #SubClients_Timezone_StartTime WHERE appid = @subclientId AND jobStartTime IS NOT NULL AND jobStartTime>=0 )
		BEGIN
			UPDATE #Clients_Timezone_StartTime
			SET jobStartTime  = #SubClients_Timezone_StartTime.jobStartTime
			FROM #Clients_Timezone_StartTime INNER JOIN #SubClients_Timezone_StartTime
			ON #SubClients_Timezone_StartTime.AppId = @subclientId
			AND #Clients_Timezone_StartTime.clientID = @clientId
			-- Update only for plan schedules. So match on taskId also
			AND #Clients_Timezone_StartTime.taskID = #SubClients_Timezone_StartTime.taskID
		END
	END
	-- Populating last successful time for the backup schedules on each task
	--Change--
		UPDATE AE
		SET AE.nextRunTime = IIF(CONVERT(int, SCP.attrVal) > @nowUtcUnix, CONVERT(int, SCP.attrVal),0)
	FROM #AssocEntity AE
		INNER JOIN APP_Application APP ON APP.id = AE.subclientId
		INNER JOIN APP_SubClientProp SCP ON SCP.componentNameId = APP.id
		INNER JOIN TM_SubTask ST ON AE.taskId = ST.taskId
		INNER JOIN TM_PatternAssoc PA ON PA.subTaskId = ST.subTaskId
INNER JOIN TM_Pattern P ON P.patternId = PA.patternId AND P.freq_type = 4096
	WHERE SCP.attrName = 'Next backup start time Continuous '+CONVERT(NVARCHAR(10),ST.subTaskId ) -- CV_SC_PROP_NEXT_BACKUP_START_TIME
		AND SCP.cs_attrName = Checksum(N'Next backup start time Continuous '+CONVERT(NVARCHAR(10), ST.subTaskId ))  -- CV_SC_PROP_NEXT_BACKUP_START_TIME
		AND
		(
			AE.subclientId > 0
		)
	UPDATE AE
		SET AE.nextRunTime = IIF(CONVERT(int, SCP.attrVal) > @nowUtcUnix, CONVERT(int, SCP.attrVal),0)
	FROM #AssocEntity AE
		INNER JOIN APP_Application APP ON APP.id = @subclientId
		INNER JOIN APP_SubClientProp SCP ON SCP.componentNameId = APP.id
		INNER JOIN TM_SubTask ST ON AE.taskId = ST.taskId
		INNER JOIN TM_PatternAssoc PA ON PA.subTaskId = ST.subTaskId
INNER JOIN TM_Pattern P ON P.patternId = PA.patternId AND P.freq_type = 4096
	WHERE SCP.attrName = 'Next backup start time Continuous '+CONVERT(NVARCHAR(10),ST.subTaskId ) -- CV_SC_PROP_NEXT_BACKUP_START_TIME
		AND SCP.cs_attrName = Checksum(N'Next backup start time Continuous '+CONVERT(NVARCHAR(10), ST.subTaskId ))  -- CV_SC_PROP_NEXT_BACKUP_START_TIME
		AND AE.nextRuntime=0
	----
	----------------------------
	--CONSTRUCT THE XML---------
	----------------------------
	SET @xmlText =
		( SELECT	 --TASKLIST
			( SELECT 	--TASK
				[TM_Task].taskId AS '@taskId' ,
				[TM_Task].taskName AS '@taskName' ,
				[TM_Task].taskType AS '@taskType' ,
				[TM_Task].alertId AS '@alertId' ,
				[NTnotificationRule].notificationName AS '@alertName' ,
				[TM_Task].ownerId AS '@ownerId' ,
				[TM_Task].runUserId AS '@runUserId' ,
				[TM_Task].description AS '@description' ,
				USR.login AS '@ownerName' ,
				[TM_Task].policyType AS '@policyType' ,
				[TM_Task].GUID ,
				( SELECT -- alert
							[TM_Task].alertId AS '@alertId' ,
							NT.notificationName AS '@alertName'
					FROM    dbo.NTnotificationRule
							AS NT WITH (NOLOCK)
					WHERE   NT.id = [TM_Task].alertId
				FOR
					XML PATH('alert') ,
						TYPE
				) ,
				(SELECT
					[TM_Task].taskId AS '@taskId',
					[TM_Task].taskName AS '@taskName'
				FOR
					XML PATH ('task'),
						TYPE
				),
				( SELECT-- origCC
							[TM_Task].origCCId AS '@commCellId'
				FOR
					XML PATH('originalCC') ,
						TYPE
				) ,
				( SELECT  --TaskFlags
							[TM_Task].disabled AS '@disabled' ,
							[TM_Task].uninstalled AS '@uninstalled' ,
							[TM_Task].isEZOperation AS '@isEZOperation',
CASE WHEN [TM_Task].flags & 0x4 <> 0 THEN 1
							ELSE 0
							END AS '@isSystem',
CASE WHEN [TM_Task].flags & 0x40 <> 0 THEN 1
							ELSE 0
							END AS '@isEdgeDrive',
CASE WHEN [TM_Task].flags & 0x80 <> 0 THEN 1
							ELSE 0
							END AS '@isIndexBackup',
CASE WHEN [TM_Task].flags & 0x80000 <> 0 THEN 1
							ELSE 0
							END AS '@isEdiscovery'
				FOR
					XML PATH('taskFlags') ,
						TYPE
				)
			FOR
				XML PATH('task') ,
					TYPE
			) ,
			( SELECT  --APPGROUP
						( SELECT  --GROUP SELECTED
									TFIL.filter_value AS '@appGroupId'
							FROM    TM_AssocFilter
									AS TFIL
							WHERE   TFIL.filter_type = 1
									AND TFIL.taskId = [TM_Task].taskId
						FOR
							XML PATH('appGroups') ,
								TYPE
						) ,
						( SELECT  --TYPES SELECTED
									TFIL.filter_value AS '@appTypeId'
							FROM    TM_AssocFilter
									AS TFIL
							WHERE   TFIL.filter_type = 2
									AND TFIL.taskId = [TM_Task].taskId
						FOR
							XML PATH('appTypes') ,
								TYPE
						)
			FOR
				XML PATH('appGroup') ,
					TYPE
			) ,
			( SELECT --NEXT SCHEDULES
						datediff(second, '01/01/1970', dbo.ClientLocalToUTCTime(T.nextRunTime,2)) '@nextScheduleTime',
						--ABS(datediff(second, '01/01/1970', dbo.UTCToClientLocalTime(GETDATE(), 2)) - datediff(second, '01/01/1970', dbo.UTCToClientLocalTime(RAS.nextRunTime, 2))) '@relativeTime',
						ABS(datediff(second, '01/01/1970', T.nextRunTime) - datediff(second, '01/01/1970', GETDATE())) '@relativeTime',
						(SELECT T.clientId '@clientId'
							FOR
							XML PATH('client') ,
								TYPE
						) ,
						(SELECT
								T.clientId '@clientId',
								T.apptypeId '@applicationId',
								T.instanceId '@instanceId',
								T.backupsetId '@backupsetId',
								T.subclientId '@subclientId'
							FOR
							XML PATH('entity') ,
								TYPE
						) ,
						(SELECT T.subTaskId '@subtaskId',
							T.taskId '@taskId'
							FOR
							XML PATH('subtask') ,
								TYPE
						) ,
						(SELECT TimeZoneId '@TimeZoneID' FROM SchedTimeZone WITH (NOLOCK)
							WHERE TimeZoneStdName = dbo.GetClientTimeZone(T.clientId)
							FOR
							XML PATH('timeZone') ,
								TYPE
						)
				FROM
				(
							SELECT RAS.nextRunTime , ASSOC.clientId , STASK.subTaskId , STASK.taskId, ASSOC.apptypeId, ASSOC.instanceId, ASSOC.backupsetId, ASSOC.subclientId
							FROM #AssocEntity AS ASSOC
								INNER JOIN TM_SubTask AS STASK WITH (NOLOCK) ON STASK.taskId = ASSOC.taskId
								INNER JOIN TM_PatternAssoc
										AS PAS WITH (NOLOCK) ON PAS.subTaskId = STASK.subTaskId
								INNER JOIN TM_Pattern
										AS PAT WITH (NOLOCK) ON PAT.patternId = PAS.patternId
								INNER JOIN TM_RunTime
										AS NRT WITH (NOLOCK) ON NRT.patternId = PAS.patternId
								INNER JOIN TM_RunTimeAssoc
										AS RAS WITH (NOLOCK) ON RAS.runTimeId = NRT.runTimeId
AND (PAT.tzId <> 1001 OR (PAT.tzId = 1001 ) )
										AND RAS.processed = 0
								INNER JOIN #Clients_Timezone_StartTime Clients_Timezone_StartTime ON
								Clients_Timezone_StartTime.clientID = ASSOC.clientId
								AND Clients_Timezone_StartTime.taskId = ASSOC.taskId
								LEFT JOIN #SubClients_Timezone_StartTime SubClients_Timezone_StartTime ON
								SubClients_Timezone_StartTime.appId = ASSOC.subclientID
								AND SubClients_Timezone_StartTime.taskID = ASSOC.taskID
								-- Pick the runtime association where jobStartTime matches.
							WHERE	STASK.subTaskId = PAS.subTaskId
								AND STASK.taskId = [TM_Task].taskId
AND PAT.tzId = 1001
								AND PAT.deleted = 0
								AND RAS.jobStartTime = ISNULL(NULLIF(SubClients_Timezone_StartTime.jobStartTime,-1),Clients_Timezone_StartTime.jobStartTime)
								AND RAS.timeZoneNames = ISNULL(SubClients_Timezone_StartTime.timezoneName,Clients_Timezone_StartTime.timeZoneName)
							UNION
								SELECT dbo.GETDATETIME(ASSOC.nextRunTime), ASSOC.clientId, STASK.subTaskId, STASK.taskId, ASSOC.apptypeId, ASSOC.instanceId, ASSOC.backupsetId, ASSOC.subclientId
								FROM #AssocEntity AS ASSOC
									INNER JOIN TM_SubTask AS STASK WITH (NOLOCK) ON STASK.taskId = ASSOC.taskId
									INNER JOIN TM_PatternAssoc
											AS PAS WITH (NOLOCK) ON PAS.subTaskId = STASK.subTaskId
									INNER JOIN TM_Pattern
											AS PAT WITH (NOLOCK) ON PAT.patternId = PAS.patternId
								WHERE STASK.subTaskId = PAS.subTaskId
									AND STASK.taskId = [TM_Task].taskId
AND PAT.freq_Type = 4096
									AND PAT.deleted = 0
AND PAT.tzId <> 1001
									AND ASSOC.nextRunTime > 0
						)T
				FOR
				XML PATH('nextScheduleTimes') ,
					TYPE
			) ,
			( SELECT DISTINCT --ASSOC
						ASSOC.assocType '@_type_' ,
						ASSOC.clientGroupId '@clientGroupId' ,
						ASSOC.clientGroupName '@clientGroupName' ,
						ASSOC.clientId '@clientId' ,
						ASSOC.clientName '@clientName' ,
						ASSOC.displayName '@displayName' ,
						ASSOC.apptypeId '@applicationId' ,
						ASSOC.appTypeName '@appName' ,
						ASSOC.policyId '@storagePolicyId' ,
						ASSOC.policyName '@storagePolicyName' ,
						ASSOC.mediaAgentId '@mediaAgentId',
						ASSOC.mediaAgentName '@mediaAgentName',
						ASSOC.instanceId '@instanceId' ,
						CASE CHARINDEX('', ASSOC.instanceName)
							WHEN 0 THEN	ASSOC.instanceName
							ELSE
								'|'+REPLACE(ASSOC.instanceName,
								'', '|#12!')
							END '@instanceName',
						ASSOC.backupsetId '@backupsetId' ,
						ASSOC.copyId '@copyId' ,
						ASSOC.copyName '@copyName' ,
						ASSOC.srmReportSet '@srmReportSet',
						ASSOC.srmReportType '@srmTemplateId',
						ASSOC.srmReportName '@srmTemplateName',
						ASSOC.backupsetName '@backupsetName' ,
						ASSOC.subclientId '@subclientId' ,
						ASSOC.subclientName '@subclientName',
						ASSOC.agentlessPolicyId '@agentlessPolicyId',
						ASSOC.planId '@planId',
						ASSOC.planName '@planName',
						ASSOC.exclude 'flags/@exclude'
				FROM      #AssocEntity AS ASSOC
				WHERE     ASSOC.taskId = [TM_Task].taskId
				AND exclude=0
			FOR
				XML PATH('associations') ,
					TYPE
			) ,
			( SELECT		--SUBTASKINFO
						--TASK RUN TIME FROM TM_RunTime WITH (NOLOCK) Table
						NRT.nextTime AS '@nextScheduleTime' ,
						ABS(datediff(second, '01/01/1970', GETUTCDATE()) - datediff(second, '01/01/1970', NRT.nextRunTime)) '@relativeTime',
						( SELECT	DISTINCT --SUBTASK
									STASK.subTaskId AS '@subTaskId' ,
									STASK.subTaskType AS '@subTaskType' ,
									STASK.operationType AS '@operationType' ,
									STASK.flags AS '@flags' ,
									STASK.subTaskOrder AS '@subTaskOrder' ,
									STASK.subTaskName AS '@subTaskName'
						FOR
							XML PATH('subTask') ,
								TYPE
						) ,
						( SELECT --PATTERN
									PAT.patternId '@patternId' ,
									PAT.name '@name' ,
									PAT.flags '@flags' ,
									PAT.freq_type '@freq_type' ,
									PAT.freq_interval '@freq_interval' ,
									PAT.freq_relative_interval '@freq_relative_interval' ,
									PAT.freq_recurrence_factor '@freq_recurrence_factor' ,
									PAT.freq_subday_interval '@freq_subday_interval' ,
									PAT.skipOccurence '@skipOccurence' ,
									PAT.skipDayNumber '@skipDayNumber' ,
									PAT.local_start_date '@active_start_date' ,
									PAT.active_start_time '@active_start_time' ,
									PAT.local_end_date '@active_end_date' ,
									PAT.active_end_time '@active_end_time' ,
									PAT.active_end_occurence '@active_end_occurence' ,
									PAT.description '@description' ,
									PAT.freq_restart_interval '@freq_restart_interval',
									( SELECT  --TimeZone
									PAT.tzId AS '@TimeZoneID'
									FOR
									XML
									PATH('timeZone') ,
									TYPE
									) ,
									( SELECT  --Calendar
									PAT.calendarId AS '@calendarId'
									FOR
									XML
									PATH('calendar') ,
									TYPE
									),
									( SELECT  --Repeat Pattern
									REP.onOccurence AS '@occurrence',
									REP.onDay AS '@onDay',
									REP.repeatOn AS '@repeatOn',
									REP.onDayNumber AS '@onDayNumber',
									1				  AS '@exception',
									REP.description   AS '@description'
									FROM TM_RepeatPattern AS REP WITH (NOLOCK)
									WHERE REP.patternId = PAT.patternId
									FOR
									XML
									PATH('repeatPattern') ,
									TYPE
									)
							FROM    TM_Pattern AS PAT WITH (NOLOCK),
									TM_PatternAssoc PASOC WITH (NOLOCK)
							WHERE   [PASOC].[patternId] = PAT.[patternId]
									AND PASOC.subTaskId = STASK.subTaskId
									AND PAT.deleted = 0
						FOR
							XML PATH('pattern') ,
								TYPE
						) ,
						( SELECT  --OPTIONS
									SOPTIONS.xmlValue.query('/TMMsg_JobOption/*') AS 'options'
							FROM    TM_SubTaskXMLOptions SOPTIONS WITH (NOLOCK)
							WHERE   SOPTIONS.subTaskId = STASK.subTaskId
						FOR
							XML PATH('') ,
								TYPE
						)
				FROM      TM_subTask AS STASK WITH (NOLOCK)
						LEFT OUTER JOIN TM_PatternAssoc
							AS PAS WITH (NOLOCK) ON PAS.subTaskId = STASK.subTaskId
						LEFT OUTER JOIN TM_Pattern
							AS PAT WITH (NOLOCK) ON PAT.patternId = PAS.patternId
						LEFT OUTER JOIN TM_RunTime
							AS NRT WITH (NOLOCK) ON NRT.patternId = PAS.patternId
									AND NRT.processed = 0
				WHERE     STASK.subTaskId = PAS.subTaskId
						AND STASK.taskId = [TM_Task].taskId
						AND PAT.deleted = 0
			FOR
				XML PATH('subTasks') ,
					TYPE
			)
			FROM   dbo.TM_Task WITH (NOLOCK)
				LEFT OUTER JOIN dbo.UMUsers AS USR WITH (NOLOCK) ON dbo.TM_Task.ownerId = USR.id
				LEFT OUTER JOIN dbo.NTnotificationRule WITH (NOLOCK) ON dbo.NTnotificationRule.id = dbo.TM_Task.alertId
			WHERE  dbo.TM_Task.taskId IN ( SELECT
										taskId
										FROM #taskTble )
				AND ( [TM_Task].[deleted] = 0
						AND [TM_Task].[invalid] = 0
						AND [TM_Task].[uninstalled] = 0
						AND [TM_Task].[savedReport] = 0
					) --AND [TM_RunTime].[processed] = 0)
AND ( [TM_Task].[taskType] IN ( 2, 4 ) )
		FOR
			XML PATH('taskDetail') ,
				ROOT('TMMsg_GetTaskListResp')
		)
	IF @xmlText IS null
	BEGIN
		SET @xmlText = '<TMMsg_GetTaskListResp/>'
	END
	IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
		DROP TABLE #AssocEntity
	IF object_id('tempdb.dbo.#taskTble') is not null
		DROP TABLE #taskTble
	IF object_id('tempdb.dbo.#taskAppTypeTbleForAssocFilter') is not null
		DROP TABLE #taskAppTypeTbleForAssocFilter
	IF OBJECT_ID('tempdb.dbo.#TM_AssocEntityFromTbl') IS NOT null
            DROP TABLE #TM_AssocEntityFromTbl
	IF object_id('tempdb.dbo.#Clients_Timezone_StartTime') is NOT NULL
	BEGIN
		DROP TABLE #Clients_Timezone_StartTime
	END
	IF object_id('tempdb.dbo.#SubClients_Timezone_StartTime') is NOT NULL
	BEGIN
		DROP TABLE #SubClients_Timezone_StartTime
	END
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetClientEntityTaskList')
	delete from GxQscripts where name = 'TM_GetClientEntityTaskList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetClientEntityTaskList')
	delete from GXDBVersions where aliasname = 'TM_GetClientEntityTaskList'
GO

insert into GXDBVersions values(2, 'TM_GetClientEntityTaskList',  'v1.17.42.31.4.2', 'TM_GetClientEntityTaskList', 'v1.17.42.31.4.2')
GO

