

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetBkpSchedForAllSubclient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_GetBkpSchedForAllSubclient <<<'

IF EXISTS (select * from sysobjects where name='TM_GetBkpSchedForAllSubclient')
	drop procedure TM_GetBkpSchedForAllSubclient
IF EXISTS (select * from GxQscripts where name='TM_GetBkpSchedForAllSubclient')
	delete from GxQscripts where name = 'TM_GetBkpSchedForAllSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetBkpSchedForAllSubclient')
	delete from GXDBVersions where aliasname = 'TM_GetBkpSchedForAllSubclient'
GO
print '... Creating Procedure: TM_GetBkpSchedForAllSubclient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_GetBkpSchedForAllSubclient
AS
 DECLARE @taskId INT
 DECLARE @schedulePolicy nvarchar(510)
 DECLARE @scheduleId INT
 DECLARE @scheduleName nvarchar(510)
 DECLARE @scheduleTask nvarchar(50)
 DECLARE @scheduleBackupType varchar(50)
 DECLARE @schedPattern nvarchar(max)
 DECLARE @schednextbackuptime dateTime
 DECLARE @clientName nvarchar(510)
 DECLARE @idataAgent nvarchar(1024)
 DECLARE @backupset nvarchar(256)
 DECLARE @instance nvarchar(1024)
 DECLARE @subclient nvarchar(256)
IF  object_id('tempdb.dbo.#backuptaskInfo') is not null DROP TABLE #backupTaskInfo
IF  object_id('tempdb.dbo.#backupEntities') is not null DROP TABLE #backupEntities
CREATE TABLE #backuptaskInfo(
id int NOT NULL IDENTITY (1,1),
taskId int,
scheduePolicy nvarchar(510),
scheduleId int,
scheduleName nvarchar(510),
scheduletask nvarchar(50),
schedbackuptype varchar(50),
schedpattern nvarchar(max),
schednextbackuptime datetime
)
CREATE TABLE #backupEntities(
o_taskId		   INT,
o_appId        INT,
o_appTypeId    INT,
o_clientId     INT,
o_instanceId   INT,
o_backupsetId  INT,
o_status       INT,
o_bkpLevel     INT
)
declare @idCounter int = 0
declare @TkId int = 0
declare @STkId int=0
declare @subclientsBackedup table
(
      o_appId        INT,
      o_appTypeId    INT,
      o_clientId     INT,
      o_instanceId   INT,
      o_backupsetId  INT,
      o_status       INT,
      o_bkpLevel     INT
)
INSERT into #backuptaskInfo
SELECT DISTINCT
TASK.taskId,TASK.taskName,STASK.subTaskId,ISNULL(STASK.subTaskName,''),
scheduletask=
CASE STASK.subTasktype
 WHEN 1 THEN 'Administration'
 WHEN 2 THEN 'Backup'
 WHEN 3 THEN 'Restore'
 ELSE 'OTHER'
 END,
 schedbackuptype=
 CASE CONVERT(int,SOPT.value)
  WHEN 1 THEN 'Full'
  WHEN 2 THEN 'Incremental'
  WHEN 3 THEN 'Differential'
  WHEN 4 THEN 'Synthetic Full'
  WHEN 5 THEN 'ASR'
 ELSE 'Unknown'
 END,
 PAT.description,
 RTASSOC.nextRunTime
FROM
		TM_Task as TASK LEFT OUTER JOIN
        TM_SubTask as STASK ON TASK.taskId = STASK.taskId  JOIN
        TM_SubTaskOptions as SOPT ON STASK.subTaskId = SOPT.subTaskId JOIN
        TM_PatternAssoc AS PATASSOC ON PATASSOC.subTaskId = STASK.subTaskId JOIN
        TM_Pattern AS PAT ON PAT.patternId = PATASSOC.patternId  JOIN
        TM_RunTime AS RT ON RT.patternId = PAT.patternId  JOIN
        TM_RunTimeAssoc AS RTASSOC ON RTASSOC.runTimeId = RT.runTimeId
WHERE
		STASK.subTaskType IN (2,4) AND
        SOPT.optionId = 458405394 AND  SOPT.value IN ('1', '2', '3', '4', '6','7') AND
        RTASSOC.processed = 0 AND RTASSOC.firing = 0 AND
        RT.processed = 0 AND RT.firing =  0 AND
        ISNULL(TASK.disabled, 0) = 0 AND TASK.invalid = 0 AND TASK.uninstalled = 0
WHILE (1=1)
BEGIN
	SELECT TOP 1 @idCounter = #backuptaskInfo.id, @TkId = #backuptaskInfo.taskId, @STkId=#backuptaskInfo.scheduleId
	FROM #backuptaskInfo
	WHERE @idCounter < id
	ORDER BY id ASC
	IF @@ROWCOUNT = 0 BREAK;
	delete from @subclientsBackedup
    Insert into @subclientsBackedup
    Exec TM_GetBackupEntity @TkId,@STkId,'',0
	INSERT INTO #backupEntities
	SELECT DISTINCT @TkId,o_appId,o_appTypeId,o_clientId,o_instanceId, o_backupsetId,o_status,o_bkpLevel
	FROM @subclientsBackedup
END
SELECT DISTINCT T.taskId,T.scheduePolicy,T.scheduleId,t.scheduleName,T.scheduletask,T.schedbackuptype,T.schedpattern,T.schednextbackuptime,
AC.name 'clientname', AIda.name 'iDataAgent', AB.name 'backupset',AI.name 'instance', AA.subclientName 'subclient'
FROM #backuptaskInfo T JOIN #backupEntities E ON T.taskId=E.o_taskId JOIN
APP_Client AC ON AC.id=E.o_clientId JOIN
APP_iDAType AIda ON AIda.type = E.o_appTypeId JOIN
APP_BackupSetName AB ON AB.id = E.o_backupsetId JOIN
APP_InstanceName AI ON AI.id = E.o_instanceId JOIN
APP_Application AA ON AA.id = E.o_appId
DROP TABLE #backupEntities
DROP TABLE #backuptaskInfo
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetBkpSchedForAllSubclient')
	delete from GxQscripts where name = 'TM_GetBkpSchedForAllSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetBkpSchedForAllSubclient')
	delete from GXDBVersions where aliasname = 'TM_GetBkpSchedForAllSubclient'
GO

insert into GXDBVersions values(2, 'TM_GetBkpSchedForAllSubclient',  '00000000000000000000', 'TM_GetBkpSchedForAllSubclient', '00000000000000000000')
GO

