

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetBackupLevel.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetBackupLevel.sp,v $ $Id: TM_GetBackupLevel.sp,v 1.9.60.1 2017/02/10 20:42:00 sjohnson Exp $";
-- =============================================
-- Author:		Anand Vibhor
-- Create date: 01/28/2006
-- Description:	Get the appId on which job is going to run
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_GetBackupLevel <<<'

IF EXISTS (select * from sysobjects where name='TM_GetBackupLevel')
	drop procedure TM_GetBackupLevel
IF EXISTS (select * from GxQscripts where name='TM_GetBackupLevel')
	delete from GxQscripts where name = 'TM_GetBackupLevel'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetBackupLevel')
	delete from GXDBVersions where aliasname = 'TM_GetBackupLevel'
GO
print '... Creating Procedure: TM_GetBackupLevel'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_GetBackupLevel
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_taskId integer,
  @i_subTaskId integer,
  @InputTableArg nvarchar(255),
  @OutputTableArg nvarchar(255) OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
BEGIN TRY
	DECLARE @taskType INT
	DECLARE @operationType INT
	--Get the patternId And TaskId
	--SET THE FLAGS OF TASK
	SET @taskType = (SELECT taskType from TM_Task where taskId = @i_taskId)
	--SET THE OPERATION TYPE
	SET @operationType = (SELECT operationType from TM_SubTask where subTaskId = @i_subTaskId)
	-------------------------------
	--CREATE TEMP TABLE------------
	-------------------------------
	-- None of these temp tables should ever exist when this procedure is called!
	if object_id('tempdb.dbo.#bkpLevelTbl') is not null
    			DROP TABLE #bkpLevelTbl
	CREATE TABLE #bkpLevelTbl ( appId INT,  appTypeId INT, status INT, bkpLevel INT)
	----------------------------------
	--INSERT THE ENTRIES IN TEMP TABLE
	----------------------------------
	EXEC ('INSERT INTO #bkpLevelTbl SELECT appId, appTypeId, status , 0 FROM ' + @InputTableArg )
	UPDATE #bkpLevelTbl SET bkpLevel = (SELECT dbo.getbackuplevel(operationType) FROM TM_SubTask where subTaskId = @i_subTaskId)
	---------------------------------
	--UPDATE THE LEVEL BASED ON RULES
	---------------------------------
	--1. NDS appType can have FULL backup only
UPDATE #bkpLevelTbl SET bkpLevel = 1 where appTypeId = 10
	--2. EXCHANGE DB JOB LEVEL ARE BASED ON PRE SELECTED TYPE
	UPDATE #bkpLevelTbl  SET bkpLevel = (SELECT dbo.getbackuplevel(
	(SELECT (ISNULL(
	(SELECT CAST(attrVal as INT) from APP_Subclientprop where modified = 0 and attrName = N'Backup Level' AND componentNameId = #bkpLevelTbl.appId)
	, 2))))) --DEFAULT VALUE IS INCR
WHERE appTypeId IN (15, 9, 53)
	--LEGACY_CV_APPTYPE_15 15 CV_APPTYPE_MSEXCHANGE_DATABASE 53 UNUSED_CV_APPTYPE_9 9
	--3. LOTUS NOTES TRANSACTION LOG WILL HAVE INCR BACKUP ONLY INCR = 2
UPDATE #bkpLevelTbl  SET bkpLevel = 2 where appTypeId IN (6,51,59,77) AND(( status & 0x0080 ) <> 0x0080)  --CV_STATUS_TRAN_LOG			0x0080
	--3. Convert INCR to FULL for old SQL FFG backup
UPDATE #bkpLevelTbl  SET bkpLevel = 1 where bkpLevel = 2 AND  appTypeId IN (4,16,70) AND  (status &2 <> 2)
	--3. Convert INCR to FULL for SHAREPOINT DB
UPDATE #bkpLevelTbl  SET bkpLevel = 1 where bkpLevel = 2 AND  appTypeId IN (32,69)
	--4.Convert INCR to UPDATE REPLICA for QR Job
UPDATE #bkpLevelTbl  SET bkpLevel = 8192 where bkpLevel = 2 AND  appTypeId IN (47,50)
	--5.Convert FULL to CREATE REPLICA for QR Job
UPDATE #bkpLevelTbl  SET bkpLevel = 2048 where bkpLevel = 1 AND  appTypeId IN (47,50)
	--5.IF run TRUNC LOG AFTER INCR selected FOR SQL AND SYBASE
UPDATE #bkpLevelTbl  SET bkpLevel = 256 where apptypeId in ( 4, 5,16, 70, 81)   AND
EXISTS( SELECT value from TM_SubTaskOptions where  subTaskId = @i_subTaskId AND taskId = @i_taskId AND optionId = 974354278)
	EXEC ( 'INSERT INTO ' + @OutputTableArg + ' SELECT * FROM #bkpLevelTbl' )
END TRY
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
    EXECUTE dbo.PrintError;
    -- Rollback any active or uncommittable transactions before
    -- inserting information in the ErrorLog
END CATCH;
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetBackupLevel')
	delete from GxQscripts where name = 'TM_GetBackupLevel'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetBackupLevel')
	delete from GXDBVersions where aliasname = 'TM_GetBackupLevel'
GO

insert into GXDBVersions values(2, 'TM_GetBackupLevel',  '00010009006000010000', 'TM_GetBackupLevel', '00010009006000010000')
GO

