

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetAllJobOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetAllJobOptions.sp,v $ $Id: TM_GetAllJobOptions.sp,v 1.8 2012/03/22 23:09:25 sbonilla Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 08/15/2009
-- Description:	Wrapper for GetAllJobOptions
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_GetAllJobOptions <<<'

IF EXISTS (select * from sysobjects where name='TM_GetAllJobOptions')
	drop procedure TM_GetAllJobOptions
IF EXISTS (select * from GxQscripts where name='TM_GetAllJobOptions')
	delete from GxQscripts where name = 'TM_GetAllJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetAllJobOptions')
	delete from GXDBVersions where aliasname = 'TM_GetAllJobOptions'
GO
print '... Creating Procedure: TM_GetAllJobOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_GetAllJobOptions
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @jobId bigint
AS
  DECLARE @o_type INT
  DECLARE @o_optionId bigint
  DECLARE @o_value NVARCHAR(MAX)	
--NVARCHAR(MAX) NEEDS TO GO LAST
BEGIN
		DECLARE @taskId		INT
		DECLARE @subTaskId	INT
		DECLARE @refTime	INT
		SELECT TOP 1 @taskId=[taskId], @subTaskId=[subTaskId], @refTime=[created] FROM TM_JobRequest WITH (READUNCOMMITTED) WHERE jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WITH (READUNCOMMITTED) WHERE [jobId]=@jobId)
		--GET THE LIST OF OPTION VALUES FROM THE TM_JOBOPTIONS TABLE
		--Need to ignore duplicate options created when setting an option for a particular job in TaskInterfaceDB::setOptions
		SELECT DISTINCT type, optionId, value FROM TM_JobOptions WITH (READUNCOMMITTED) WHERE (jobId=@jobId)
		UNION ALL
		SELECT DISTINCT type, optionId, value FROM TM_JobOptions AS TJ WITH (READUNCOMMITTED) WHERE (
				(jobId=0 AND subTaskId=@subTaskId AND created <= @refTime AND (modified=0 OR modified > @refTime))
			) AND
			NOT EXISTS(SELECT * FROM TM_JobOptions AS LT WITH (READUNCOMMITTED) WHERE (jobId=@jobId) AND LT.optionId = TJ.optionId)
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetAllJobOptions')
	delete from GxQscripts where name = 'TM_GetAllJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetAllJobOptions')
	delete from GXDBVersions where aliasname = 'TM_GetAllJobOptions'
GO

insert into GXDBVersions values(2, 'TM_GetAllJobOptions',  '00010008000000000000', 'TM_GetAllJobOptions', '00010008000000000000')
GO

