

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetAllFileOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetAllFileOptions.sp,v $ $Id: TM_GetAllFileOptions.sp,v 1.4 2012/06/29 16:28:20 sbonilla Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 05/25/2010
-- Description:	Wrapper for TM_GetAllFileOptions
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_GetAllFileOptions <<<'

IF EXISTS (select * from sysobjects where name='TM_GetAllFileOptions')
	drop procedure TM_GetAllFileOptions
IF EXISTS (select * from GxQscripts where name='TM_GetAllFileOptions')
	delete from GxQscripts where name = 'TM_GetAllFileOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetAllFileOptions')
	delete from GXDBVersions where aliasname = 'TM_GetAllFileOptions'
GO
print '... Creating Procedure: TM_GetAllFileOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_GetAllFileOptions
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @jobId bigint,
  @fileBegin int,
  @fileEnd int
AS
  DECLARE @o_type INT
  DECLARE @o_optionId bigint
  DECLARE @o_value NVARCHAR(MAX)
BEGIN
	DECLARE @taskId		INT
	DECLARE @subTaskId	INT
	DECLARE @refTime	INT
	SELECT TOP 1 @taskId=[taskId], @subTaskId=[subTaskId], @refTime=[created] FROM TM_JobRequest WITH (READUNCOMMITTED) WHERE jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WITH (READUNCOMMITTED) WHERE [jobId]=@jobId)
	--Get the list of option values from the TM_JobOptions table
	IF (@fileEnd = 0)
		SELECT type, optionId, value FROM TM_JobOptions WITH (READUNCOMMITTED) WHERE (jobId=@jobId AND optionId = @fileBegin)
		UNION ALL
		SELECT type, optionId, value FROM TM_JobOptions AS TJ WITH (READUNCOMMITTED) WHERE (
				(jobId=0 AND subTaskId=@subTaskId AND created <= @refTime AND (modified=0 OR modified > @refTime))
			) AND optionId = @fileBegin AND
			NOT EXISTS(SELECT * FROM TM_JobOptions AS LT WITH (READUNCOMMITTED) WHERE (jobId=@jobId) AND LT.optionId = TJ.optionId)
	ELSE
		SELECT type, optionId, value FROM TM_JobOptions WITH (READUNCOMMITTED) WHERE (jobId=@jobId AND optionId >= @fileBegin AND optionId <= @fileEnd)
		UNION ALL
		SELECT type, optionId, value FROM TM_JobOptions AS TJ WITH (READUNCOMMITTED) WHERE (
				(jobId=0 AND subTaskId=@subTaskId AND created <= @refTime AND (modified=0 OR modified > @refTime))
			) AND optionId >= @fileBegin AND optionId <= @fileEnd AND
			NOT EXISTS(SELECT * FROM TM_JobOptions AS LT WITH (READUNCOMMITTED) WHERE (jobId=@jobId) AND LT.optionId = TJ.optionId)
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetAllFileOptions')
	delete from GxQscripts where name = 'TM_GetAllFileOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetAllFileOptions')
	delete from GXDBVersions where aliasname = 'TM_GetAllFileOptions'
GO

insert into GXDBVersions values(2, 'TM_GetAllFileOptions',  '00010004000000000000', 'TM_GetAllFileOptions', '00010004000000000000')
GO

