

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GetAdminEntityCountDataSet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GetAdminEntityCountDataSet.sp,v $ $Id: TM_GetAdminEntityCountDataSet.sp,v 1.1.2.10.4.2 2021/03/09 23:01:24 mnatarajan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_GetAdminEntityCountDataSet')
BEGIN
	print '>>> Drop Stored Procedure: TM_GetAdminEntityCountDataSet <<<'
	drop procedure TM_GetAdminEntityCountDataSet
END
IF EXISTS (select * from GxQscripts where name='TM_GetAdminEntityCountDataSet')
	delete from GxQscripts where name = 'TM_GetAdminEntityCountDataSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetAdminEntityCountDataSet')
	delete from GXDBVersions where aliasname = 'TM_GetAdminEntityCountDataSet'
GO
print '... Creating Procedure: TM_GetAdminEntityCountDataSet'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_GetAdminEntityCountDataSet
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
	DECLARE @dbgPrint	TINYINT = 0	-- normally 0
	IF OBJECT_ID('tempdb.dbo.#TM_GetAdminEntityCountDataSet_taskTble') IS NULL
	BEGIN
		PRINT 'TM_GetAdminEntityCountDataSet: Warning no external inputted table #TM_GetAdminEntityCountDataSet_taskTble'
		RETURN 1
	END
	DECLARE @nowUtcTime DATETIME = GETUTCDATE()
	DECLARE @nowUtcUnix INT = datediff(second, '01/01/1970', @nowUtcTime)
	-- External Inputted Table
	--IF OBJECT_ID('tempdb.dbo.#TM_GetAdminEntityCountDataSet_taskTble') is not null
	--	DROP TABLE #TM_GetAdminEntityCountDataSet_taskTble
	--CREATE TABLE #TM_GetAdminEntityCountDataSet_taskTble (
	--	taskId				INT,
	--	subTaskId			INT,
	--	subTaskType			INT,
	--	entityCount			INT DEFAULT NULL,
	--	PRIMARY KEY (taskId, subTaskId)
	--)
	-- Simulate Test Table
	--INSERT INTO #TM_GetAdminEntityCountDataSet_taskTble (taskId, subTaskId, subTaskType)
	--	SELECT taskId, subTaskId, subTaskType FROM Aaron_taskTable
	IF OBJECT_ID('tempdb.dbo.#TaskTableData') is not null
		DROP TABLE #TaskTableData
	CREATE TABLE #TaskTableData (
		taskId							INT,
		subTaskId						INT,
		subTaskType						INT,
		operationType					INT DEFAULT NULL,
		taskType						INT DEFAULT NULL,
		policyType						INT DEFAULT NULL,
		initiatedFrom					INT DEFAULT NULL,
		isEdgeDrivePolicy				TINYINT DEFAULT NULL,
		isDefaultDataAnalyticsSched		TINYINT DEFAULT NULL,
		backupLevel						INT DEFAULT NULL,
		aeProcessIt						TINYINT DEFAULT 0,		-- Used only by TM_GetAdminEntityCountDataSet SP, but needs to created in TM_GetBackupEntityCountDataSet SP and default to 1 instead for SPBody
		isPlanSchedulePolicy			INT DEFAULT 0,
		PRIMARY KEY (taskId, subTaskId)
	)
	CREATE NONCLUSTERED INDEX TaskTableData_idx1 ON #TaskTableData (operationType, taskType)
	BEGIN TRY
		INSERT INTO #TaskTableData (
			taskId,
			subTaskId,
			subTaskType,		-- should be subTaskType 1 only
			operationType,
			taskType,
			policyType,
			initiatedFrom,
			isEdgeDrivePolicy,
			isDefaultDataAnalyticsSched,
			backupLevel,
			isPlanSchedulePolicy
		)
			SELECT
				et.taskId,
				et.subTaskId,
				et.subTaskType,
				stk.operationType,
				tk.taskType,
				tk.policyType,
				tk.initiatedFrom,
				CASE
					WHEN(tk.flags & 0x40) <> 0		-- TASK_FLAGS_EDGE_DRIVE
						THEN 1
					ELSE 0
				END isEdgeDrivePolicy,
				CASE
					WHEN(tk.flags & 0x10000) <> 0		-- TASK_FLAGS_DATA_ANALYTICS
						THEN 1
					ELSE 0
				END isDefaultDataAnalyticsSched,
				CASE
					WHEN sto.subTaskId IS NOT NULL THEN sto.value
					WHEN sto.subTaskId IS NULL
							AND et.taskId = 5020
							AND tk.taskType = 4
						THEN 2		-- BACKUP_LEVEL_INCREMENTAL
					ELSE NULL
				END backupLevel,
				CASE
WHEN(tk.flags & 536870912 ) <> 0		-- PLAN_ASSOCIATED_ENTITY
						THEN 1
					ELSE 0
				END isPlanSchedulePolicy
			FROM #TM_GetAdminEntityCountDataSet_taskTble et
				INNER JOIN TM_Task tk WITH (NOLOCK) ON
					tk.taskId = et.taskId
					--AND et.subTaskType = 1		-- External Table should already be filtered
				INNER JOIN TM_SubTask stk WITH(NOLOCK) ON
					stk.subTaskId = et.subTaskId
				LEFT JOIN TM_SubTaskOptions sto WITH (NOLOCK) ON
					sto.subTaskId = et.subTaskId
					AND sto.optionId = 458405394	--  BACKUPOPTION_BACKUP_LEVEL
					-- only needed for this OpType and Task Type
					AND stk.operationType = 5020
					AND tk.taskType = 4
		DECLARE @i_initFrom INT = 0;		--== used below
		--IF @operationType = 5020 AND @taskType = 4
IF EXISTS (SELECT 1 FROM #TaskTableData WHERE (operationType = 5020 OR operationType = 5023 )
AND ( taskType = 4 OR taskType = 2 ) )
		BEGIN
			IF (@dbgPrint = 1)
				PRINT 'TM_GetAdminEntityCountDataSet: IF EXISTS (SELECT 1 FROM #TaskTableData WHERE (operationType = 5020 or operationType=5023) AND (taskType = 4 Or taskType=2) )'
			-- Flag only rows that need to be processed by this if block in the SPBodies
			UPDATE #TaskTableData
				SET aeProcessIt = 1
			WHERE
( operationType = 5020 OR operationType = 5023 )
AND ( taskType = 4 OR taskType = 2 )
--- CODE BELOW FROM TM_GetBackupEntityCntIncludeDataSet.spb  ----------
BEGIN
	-------------------------------
	--CREATE TEMP TABLE------------
	-------------------------------
	-- None of these temp tables should ever exist when this procedure is called!
	IF OBJECT_ID('tempdb.dbo.#appIdTbl') IS NOT NULL
		DROP TABLE #appIdTbl
	CREATE TABLE #appIdTbl (
		taskId			INT,
		stId			INT, -- include subtaskID also since filters vary on schedule options.
		appId			INT,
		appTypeId		INT,
		clientId		INT,
		instanceId		INT,
		backupsetId		INT,
		status			INT,
		bkpLevel		INT,
		storagePolicy	INT,
		utcdateTime     DATETIME DEFAULT '1970-01-01 00:00:00.000', -- Needed for Predict SLA project where we need to identify if backup time is outside operation window.
		checkOpWindow	INT	DEFAULT 1,
		timezoneName  NVARCHAR(255) DEFAULT '',
		jobStartTime    INT DEFAULT -1
	)
	CREATE CLUSTERED INDEX appIdTbl_idx ON #appIdTbl (appId, taskId, stId)
	CREATE NONCLUSTERED INDEX appIdTbl_clientId_idx ON #appIdTbl (clientId)
	CREATE NONCLUSTERED INDEX appIdTbl_appTypeId_idx ON #appIdTbl (appTypeId)
	--CREATE NONCLUSTERED INDEX appIdTbl_timezoneName_idx ON #appIdTbl (timezoneName)
	IF OBJECT_ID('tempdb.dbo.#taskAllEntities') IS NOT NULL
		DROP TABLE #taskAllEntities
	CREATE TABLE #taskAllEntities (
		taskId		INT PRIMARY KEY
	)
	INSERT INTO #taskAllEntities (taskId)
		SELECT DISTINCT
			ae.taskId
		FROM TM_AssocEntity ae
			INNER JOIN #TaskTableData tc ON
				ae.taskId = tc.taskId
				AND ae.clientGroupId = 0
				AND ae.clientId = 0
				AND ae.appTypeId = 0
				AND ae.instanceId = 0
				AND ae.backupsetId = 0
				AND ae.subClientId = 0
				AND ae.entityId = 0
	----------------------------------
	--GET ALL ASSOCIATED CLIENTS------
	----------------------------------
	INSERT INTO #appIdTbl (
		taskid,
		stId,
		appId,
		appTypeId,
		clientId,
		instanceId,
		backupsetId,
		status,
		bkpLevel,
		storagePolicy
	)
		--CLIENT GROUP
		SELECT DISTINCT
			tc.taskId,
			tc.subTaskId,
			APP.id,
			APP.appTypeId,
			APP.clientId,
			APP.instance,
			APP.backupset,
			APP.subclientStatus,
			tc.backupLevel,
			APP.dataArchGrpID
		FROM APP_Application AS APP
			INNER JOIN APP_ClientGroupAssoc CGA ON
				APP.clientId = CGA.clientId
			INNER JOIN TM_AssocEntity AE ON
				AE.clientId = 0
				AND AE.exclude = 0
				AND CGA.clientGroupId = AE.clientGroupId
				AND AE.entityId = 0
			INNER JOIN #TaskTableData tc ON
				AE.taskId = tc.taskId
				AND tc.aeProcessIt = 1
		--ALL APPID WITH SAME GROUPID
		UNION ALL
		SELECT DISTINCT
			tc.taskId,
			tc.subTaskId,
			APP.id,
			APP.appTypeId,
			APP.clientId,
			APP.instance,
			APP.backupset,
			APP.subclientStatus,
			tc.backupLevel,
			APP.dataArchGrpID
		FROM APP_Application AS APP
			INNER JOIN APP_AppTypeGroupAssoc ATGA ON
				APP.appNumber = ATGA.appTypeId
			INNER JOIN TM_AssocFilter AF ON
				ATGA.appGroupId = AF.filter_value
				AND AF.filter_type = 1
			INNER JOIN #TaskTableData tc ON
				AF.taskId = tc.taskId
				AND tc.aeProcessIt = 1
			INNER JOIN #taskAllEntities tae ON
				AF.taskId = tae.taskId
		--ALL APPID WITH SAME APPTYPES
		UNION ALL
		SELECT DISTINCT
			tc.taskId,
			tc.subTaskId,
			APP.id,
			APP.appTypeId,
			APP.clientId,
			APP.instance,
			APP.backupset,
			APP.subclientStatus,
			tc.backupLevel,
			APP.dataArchGrpID
		FROM APP_Application AS APP
			INNER JOIN APP_iDAType IT ON
				APP.appTypeId = IT.type
			INNER JOIN TM_AssocFilter AF ON
				IT.type = AF.filter_value
				AND AF.filter_type = 2
			INNER JOIN #TaskTableData tc ON
				AF.taskId = tc.taskId
				AND tc.aeProcessIt = 1
				AND AF.taskId IN (
					SELECT
						tae.taskId
					FROM #taskAllEntities tae
				)
		UNION ALL
		SELECT DISTINCT
			tc.taskId,
			tc.subTaskId,
			APP.id,
			APP.appTypeId,
			APP.clientId,
			APP.instance,
			APP.backupset,
			APP.subclientStatus,
			tc.backupLevel,
			APP.dataArchGrpID
		FROM APP_Application AS APP		-- corrected full outer join error
			INNER JOIN APP_iDAType IT ON
				APP.appTypeId = IT.type
			LEFT OUTER JOIN (
				SELECT DISTINCT
					AF.taskId,
					AF.filter_value
				FROM #TaskTableData tc
					INNER JOIN TM_AssocFilter AF ON
						tc.taskId = AF.taskId
						AND tc.aeProcessIt = 1
						AND AF.filter_type = 2
			) AF ON
				IT.type = AF.filter_value
			CROSS JOIN (
				SELECT DISTINCT
					ot.taskId,
					ot.backupLevel,
					ot.subTaskId
				FROM #TaskTableData ot
					INNER JOIN #taskAllEntities t ON
						t.taskId = ot.taskId
						AND ot.aeProcessIt = 1
					LEFT OUTER JOIN TM_AssocFilter AF ON
						ot.taskId = AF.taskId
						AND AF.filter_type = 2
				WHERE
					AF.taskId IS NULL
			) tc
			--== May need to filter against IT.type again???
		WHERE
			AF.taskId IS NULL
		--ALL APPID WITH APPTYPEID = 0
		UNION ALL
		SELECT DISTINCT
			tc.taskId,
			tc.subTaskId,
			APP.id,
			APP.appTypeId,
			APP.clientId,
			APP.instance,
			APP.backupset,
			APP.subclientStatus,
			tc.backupLevel,
			APP.dataArchGrpID
		FROM APP_Application AS APP
			INNER JOIN TM_AssocEntity AS TM ON
				APP.clientId = TM.clientId
				AND TM.appTypeId = 0
				AND TM.exclude = 0
				AND TM.entityId = 0
			INNER JOIN #TaskTableData tc ON
				TM.taskId = tc.taskId
				AND tc.aeProcessIt = 1
		--ALL APPID WITH SAME APPTYPE AND CLIENTID = 0
		UNION ALL
		SELECT DISTINCT
			at.taskId,
			at.subTaskId,
			APP.id,
			APP.appTypeId,
			APP.clientId,
			APP.instance,
			APP.backupset,
			APP.subclientStatus,
			at.backupLevel,
			APP.dataArchGrpID
		FROM APP_Application AS APP
			INNER JOIN (
				SELECT DISTINCT
					te.appTypeId,
					tc.taskId,
					tc.subTaskId,
					tc.backupLevel
				FROM TM_AssocEntity te
					INNER JOIN #TaskTableData tc ON
						te.taskId = tc.taskId
						AND tc.aeProcessIt = 1
						AND te.clientid = 0
						AND te.exclude = 0
						AND te.entityId = 0
				) at ON
					at.appTypeId = APP.appTypeId
		--ALL APPID WITH INSTANCE = 0
		UNION ALL
		SELECT DISTINCT
			tc.taskId,
			tc.subTaskId,
			APP.id,
			APP.appTypeId,
			APP.clientId,
			APP.instance,
			APP.backupset,
			APP.subclientStatus,
			tc.backupLevel,
			APP.dataArchGrpID
		FROM APP_Application AS APP
			INNER JOIN TM_AssocEntity AS TM ON
				APP.clientId = TM.clientId
				AND APP.appTypeId = TM.appTypeId
				AND TM.instanceId = 0
				AND TM.exclude = 0
				AND TM.entityId = 0
			INNER JOIN #TaskTableData tc ON
				TM.taskId = tc.taskId
				AND tc.aeProcessIt = 1
		--ALL APPID WITH BACKUPSET = 0
		UNION ALL
		SELECT DISTINCT
			tc.taskId,
			tc.subtaskId,
			APP.id,
			APP.appTypeId,
			APP.clientId,
			APP.instance,
			APP.backupset,
			APP.subclientStatus,
			tc.backupLevel,
			APP.dataArchGrpID
		FROM APP_Application AS APP
			INNER JOIN TM_AssocEntity AS TM ON
				APP.clientId = TM.clientId
				AND APP.appTypeId = TM.appTypeId
				AND APP.instance = TM.instanceId
				AND TM.backupsetId = 0
				AND TM.exclude = 0
				AND TM.entityId = 0
			INNER JOIN #TaskTableData tc ON
				TM.taskId = tc.taskId
				AND tc.aeProcessIt = 1
		--ALL APPID WITH SUBCLIENT = 0
		UNION ALL
		SELECT DISTINCT
			tc.taskId,
			tc.subTaskId,
			APP.id,
			APP.appTypeId,
			APP.clientId,
			APP.instance,
			APP.backupset,
			APP.subclientStatus,
			tc.backupLevel,
			APP.dataArchGrpID
		FROM APP_Application AS APP
			INNER JOIN TM_AssocEntity AS TM ON
				APP.clientId = TM.clientId
				AND APP.appTypeId = TM.appTypeId
				AND APP.instance = TM.instanceId
				AND APP.backupset = TM.backupsetId
				AND TM.subclientId = 0
				AND TM.exclude = 0
				AND TM.entityId = 0
			INNER JOIN #TaskTableData tc ON
				TM.taskId = tc.taskId
				AND tc.aeProcessIt = 1
		--ALL APPID
		UNION ALL
		SELECT DISTINCT
			tc.taskId,
			tc.subTaskId,
			APP.id,
			APP.appTypeId,
			APP.clientId,
			APP.instance,
			APP.backupset,
			APP.subclientStatus,
			tc.backupLevel,
			APP.dataArchGrpID
		FROM APP_Application AS APP
			INNER JOIN TM_AssocEntity AS TM ON
				APP.clientId = TM.clientId
				AND APP.appTypeId = TM.appTypeId
				AND APP.instance = TM.instanceId
				AND APP.backupset = TM.backupsetId
				AND TM.subclientId = APP.Id
				AND TM.exclude = 0
				AND TM.entityId = 0
			INNER JOIN #TaskTableData tc ON
				TM.taskId = tc.taskId
				AND tc.aeProcessIt = 1
		--plan Associated entities
		UNION ALL
			SELECT DISTINCT
				tc.taskId,
				tc.subTaskId,
				APP.id,
				APP.appTypeId,
				APP.clientId,
				APP.instance,
				APP.backupset,
				APP.subclientStatus,
				tc.backupLevel,
				APP.dataArchGrpID
			FROM APP_Application AS APP WITH(NOLOCK)
			INNER JOIN APP_SubClientProp SCP WITH(NOLOCK) ON SCP.componentNameId = APP.id
			INNER JOIN TM_AssocEntity AE WITH(NOLOCK) ON CAST(AE.entityId AS NVARCHAR(1024)) = SCP.attrVal AND AE.assocType = 158
			INNER JOIN #TaskTableData tc ON
				AE.taskId = tc.taskId
				AND tc.aeProcessIt = 1
			WHERE SCP.attrName = 'Associated Plan' AND SCP.modified = 0 AND SCP.cs_attrName = CHECKSUM(N'Associated Plan')
			AND AE.taskId = tc.taskId
			AND AE.exclude = 0
			AND AE.entityId > 0
END
--- CODE ABOVE FROM TM_GetBackupEntityCntIncludeDataSet.spb  ----------
--- CODE BELOW FROM TM_GetBackupEntityCntExcludeDataSet.spb  ----------
BEGIN
	-- No need to exclude cloud laptop clients since we are pushing workqueue for them now.
	---------------------------
	--EXCLUSION----------------
	---------------------------
	IF OBJECT_ID('tempdb.dbo.#ExclApps') IS NOT NULL
		DROP TABLE #ExclApps
	CREATE TABLE #ExclApps (
		appId		INT,
		taskId		INT,
		PRIMARY KEY (appId, taskId)
	)
	INSERT INTO #ExclApps (appId, taskId)
		--CLIENT GROUP
		SELECT
			APP.id,
			ot.taskId
		FROM APP_Application APP
			INNER JOIN APP_ClientGroupAssoc cga ON
				APP.clientId = cga.clientId
			INNER JOIN TM_AssocEntity ae ON
				ae.clientGroupId = cga.clientGroupId
				AND ae.clientId = 0
				AND ae.exclude = 1
			INNER JOIN #TaskTableData ot ON
				ae.taskId = ot.taskId
				AND ot.aeProcessIt = 1
		--ALL APPID WITH APPTYPEID = 0
		UNION
		SELECT
			APP.id,
			ot.taskId
		FROM APP_Application AS APP
			INNER JOIN TM_AssocEntity AS TM ON
				APP.clientId = TM.clientId
				AND TM.appTypeId = 0
				AND TM.exclude = 1
			INNER JOIN #TaskTableData ot ON
				TM.taskId = ot.taskId
				AND ot.aeProcessIt = 1
		--ALL APPID WITH SAME APPTYPE AND CLIENTID = 0
		UNION
		SELECT
			APP.id,
			ot.taskId
		FROM APP_Application AS APP
			INNER JOIN TM_AssocEntity ae ON
				ae.appTypeId = APP.appTypeId
				AND ae.clientId = 0
				AND ae.exclude = 1
			INNER JOIN #TaskTableData ot ON
				ae.taskId = ot.taskId
				AND ot.aeProcessIt = 1
		--ALL APPID WITH INSTANCE = 0
		UNION
		SELECT
			APP.id,
			ot.taskId
		FROM APP_Application AS APP
			INNER JOIN TM_AssocEntity AS TM ON
				APP.clientId = TM.clientId
				AND APP.appTypeId = TM.appTypeId
				AND TM.instanceId = 0
				AND TM.exclude = 1
			INNER JOIN #TaskTableData ot ON
				TM.taskId = ot.taskId
				AND ot.aeProcessIt = 1
		--ALL APPID WITH BACKUPSET = 0
		UNION
		SELECT
			APP.id,
			ot.taskId
		FROM APP_Application AS APP
			INNER JOIN TM_AssocEntity AS TM ON
				APP.clientId = TM.clientId
				AND APP.appTypeId = TM.appTypeId
				AND APP.instance = TM.instanceId
				AND TM.backupsetId = 0
				AND TM.exclude = 1
			INNER JOIN #TaskTableData ot ON
				TM.taskId = ot.taskId
				AND ot.aeProcessIt = 1
		--ALL APPID WITH SUBCLIENT = 0
		UNION
		SELECT
			APP.id,
			ot.taskId
		FROM APP_Application AS APP
			INNER JOIN TM_AssocEntity AS TM ON
				APP.clientId = TM.clientId
				AND APP.appTypeId = TM.appTypeId
				AND APP.instance = TM.instanceId
				AND APP.backupset = TM.backupsetId
				AND TM.subclientId = 0
				AND TM.exclude = 1
			INNER JOIN #TaskTableData ot ON
				TM.taskId = ot.taskId
				AND ot.aeProcessIt = 1
		--ALL APPID
		UNION
		SELECT
			APP.id,
			ot.taskId
		FROM APP_Application AS APP
			INNER JOIN TM_AssocEntity AS TM ON
				APP.clientId = TM.clientId
				AND APP.appTypeId = TM.appTypeId
				AND APP.instance = TM.instanceId
				AND APP.backupset = TM.backupsetId
				AND TM.subclientId = APP.Id
				AND TM.exclude = 1
			INNER JOIN #TaskTableData ot ON
				TM.taskId = ot.taskId
				AND ot.aeProcessIt = 1
		UNION
		SELECT
			APROP.componentNameId,
			OT.taskId
		FROM TM_Task task WITH (NOLOCK)
			INNER JOIN TM_AssocEntity TM WITH (NOLOCK) ON
				(task.flags & 128) = 128
				AND @i_initFrom NOT IN (1, 2)		-- INIT_FROM_TYPE_GUI INIT_FROM_TYPE_COMMANDLINE
				AND TM.taskId = task.taskId
			INNER JOIN APP_SubClientProp APROP WITH (NOLOCK) ON
				TM.subclientId = APROP.componentNameId
				AND APROP.cs_attrName = CHECKSUM(N'Index SubClient')
				AND APROP.attrName = N'Index SubClient'
				AND APROP.attrVal = N'1'
			INNER JOIN #TaskTableData ot ON ot.aeProcessIt = 1
			AND ot.taskId!=task.taskId
		UNION
		-- For case manager index copy jobs, support only case manager clients.
		SELECT
			APP.id,
			ot.taskId
		FROM APP_Application AS APP
		INNER JOIN #appIdTbl appIdTbl ON APP.Id = appIdTbl.appId
		INNER JOIN #TaskTableData ot ON
		appIdTbl.taskId = ot.taskId
		AND ot.aeProcessIt = 1
		LEFT JOIN App_ClientProp ON
					APP.clientId = App_ClientProp.ComponentNameId
					AND App_ClientProp.attrName = 'Case Manager Pseudo Client'  --- CV_PROP_CASE_MANAGER_PSEUDO_CLIENT = "Case Manager Pseudo Client";
WHERE operationType = 5023
			AND (App_ClientProp.attrVal IS NULL OR App_ClientProp.attrVal = '0')
		UNION
		-- for plan schedule policy dont include case manager subclients
			SELECT appIdTbl.appId,
			ot.taskId
		FROM #appIdTbl appIdTbl
		INNER JOIN #TaskTableData ot ON
		appIdTbl.taskId = ot.taskId
		AND ot.aeProcessIt = 1
		INNER JOIN App_ClientProp ON
					appIdTbl.clientId = App_ClientProp.ComponentNameId
					AND App_ClientProp.attrName = 'Case Manager Pseudo Client'  --- CV_PROP_CASE_MANAGER_PSEUDO_CLIENT = "Case Manager Pseudo Client";
					AND App_ClientProp.attrVal = '1'
WHERE operationType = 5023
			AND isPlanSchedulePolicy = 1
	DELETE a
	FROM #appIdTbl a
		INNER JOIN #ExclApps ex ON
			ex.appId = a.appId
			AND ex.taskId = a.taskId
	IF OBJECT_ID('tempdb.dbo.#ExclApps') IS NOT NULL
		DROP TABLE #ExclApps
END
--- CODE ABOVE FROM Op from TM_GetBackupEntityCntExcludeDataSet.spb  ----------
			-- Update 5020,5023 / 4 counts in external inputted table
			UPDATE et
				SET entityCount = ct.cnt
			FROM #TM_GetAdminEntityCountDataSet_taskTble et
				INNER JOIN (
					SELECT
						ot.taskId,
						COUNT(DISTINCT  a.appid) cnt
					FROM #TaskTableData ot
						INNER JOIN #appIdTbl a ON
							a.taskId = ot.taskId
							AND ot.aeProcessIt = 1
					GROUP BY
						ot.taskId
				) ct ON
					ct.taskId = et.taskId
					--AND et.subTaskType = 1
		END	--== IF EXISTS (SELECT 1 FROM #TaskTableData WHERE (operationType = 5020 or operationType=5023) AND (taskType = 4 Or taskType=2) ) )
		-- Now process rows that are not OpType 5020 etc
IF EXISTS (SELECT 1 FROM #TaskTableData WHERE (operationType <> 5020 AND operationType<>5023 ) OR (taskType <> 4 AND taskType <> 2))
		BEGIN
			IF (@dbgPrint = 1)
				PRINT 'TM_GetAdminEntityCountDataSet: IF EXISTS (SELECT 1 FROM #TaskTableData WHERE (operationType <> 5020 AND operationType<> 5023) OR (taskType <> 4 AND taskType <> 2))'
--- CODE BELOW HERE IS FROM TM_GetAdminEntityCntDataSet.spb  ----------
BEGIN
	DECLARE @excludeStatus INT = 54; -- (CV_STATUS_UNINSTALLED | CV_STATUS_DELETED | CV_STATUS_DUMMY | CV_STATUS_HIDDEN)
	IF OBJECT_ID('tempdb.dbo.#OtherTasks') is not null
		DROP TABLE #OtherTasks
	CREATE TABLE #OtherTasks (
		taskId						INT,
		subTaskId					INT,
		subTaskType					INT,
		operationType				INT,
		policyType					INT,
		ddbVerificationLevel		NVARCHAR(MAX) DEFAULT '0',
		subClientBasedAnalytics		INT DEFAULT 0,
		onlineCrawlJobOption		NVARCHAR(32) DEFAULT '0',
		isOnlineCrawlJob			INT DEFAULT 0,
		isDataAnalytics2Job			INT DEFAULT 0,
		isClientLevelJob			INT DEFAULT -1,	-- -1 Not Set to 0 or 1 meaning it is neither type
		indexServerClientID			INT DEFAULT 0,
		PRIMARY KEY (taskId, subTaskId)
	)
	INSERT INTO #OtherTasks (
		taskId,
		subTaskId,
		subTaskType,		-- Should only be subTaskType 1
		operationType,
		policyType,
		ddbVerificationLevel,
		subClientBasedAnalytics,
		onlineCrawlJobOption,
		isOnlineCrawlJob,
		isDataAnalytics2Job,
		indexServerClientID
	)
	SELECT
		dt.taskId,
		dt.subTaskId,
		dt.subTaskType,
		dt.operationType,
		dt.policyType,
		opt.ddbVerificationLevel,
		opt.subClientBasedAnalytics,
		opt.onlineCrawlJobOption,
		CASE
			WHEN dt.operationType = 4022 AND opt.onlineCrawlJobOption <> '0' THEN 1
			ELSE 0
		END isOnlineCrawlJob,
		CASE
			WHEN dt.operationType = 4022 AND opt.subClientBasedAnalytics <> 0 THEN 1
			ELSE 0
		END isDataAnalytics2Job,
		opt.indexServerClientID
	FROM #TaskTableData dt
		INNER JOIN (
			SELECT
				subTaskId,
				ISNULL([1616894445], '0') ddbVerificationLevel,
				ISNULL([300510029], 0) subClientBasedAnalytics,
				ISNULL([136250708], '0') onlineCrawlJobOption,
				ISNULL([2101836446],0) indexServerClientID
			FROM (
					SELECT
						dt.subTaskId,
						sto.optionId,
						sto.value
					FROM #TaskTableData dt
						LEFT OUTER JOIN TM_SubTaskOptions sto WITH(NOLOCK) ON
							dt.subTaskId = sto.subTaskId
					WHERE
						-- Only want Task that match these settings, Task matching these settings performed above
						dt.operationType <> 5020
						OR (
							dt.operationType = 5020
							AND dt.taskType <> 4
						)
				) o
				PIVOT (MAX(value) FOR optionId IN ([1616894445], [300510029], [136250708],[2101836446])) d
		) opt ON
			opt.subTaskId = dt.subTaskId
	WHERE
		-- Only want Task that match these settings, Task matching these settings performed above if block check
		dt.operationType <> 5020
		OR (
			dt.operationType = 5020
			AND dt.taskType <> 4
		)
	-------------------------------
	--CREATE TEMP TABLE------------
	-------------------------------
	-- None of these temp tables should ever exist when this procedure is called!
	IF OBJECT_ID('tempdb.dbo.#assocTbl') IS NOT NULL
		DROP TABLE #assocTbl
	CREATE TABLE #assocTbl
	(
		opType				  INT,	-- operation that add the row to table
		taskId				  INT,
		policyId              INT DEFAULT 0,
		copyId                INT DEFAULT 0,
		srmReportSet          INT DEFAULT 0,
		srmReportType         INT DEFAULT 0,
		trackingPolicyId      INT DEFAULT 0,
		mediaAgentId          INT DEFAULT 0,
		agentLessPolicyId     INT DEFAULT 0,
		workFlowId            INT DEFAULT 0,
		sidbStoreId           INT DEFAULT 0,
		libraryId             INT DEFAULT 0,
		logMonitoringPolicyId INT DEFAULT 0,
		entityId			  INT DEFAULT 0,
		entityType			  INT DEFAULT 0,
		dataSourceId		  INT DEFAULT 0,
		clientGroupId         INT DEFAULT 0,
		clientId              INT DEFAULT 0,
		appTypeId             INT DEFAULT 0,
		instanceId            INT DEFAULT 0,
		backupsetId           INT DEFAULT 0,
		appId                 INT DEFAULT 0,
		exclude               INT DEFAULT 0,
		workflowOption        NVARCHAR(MAX)
	)
	CREATE CLUSTERED INDEX assocTbl_taskId_idx ON #assocTbl (taskId, opType)
	CREATE NONCLUSTERED INDEX assocTbl_policyId_sidbStoreId_Index1 ON #assocTbl (policyId, sidbStoreId)
	-- Assoc Table OpType Settings
	DECLARE @isAssocForDefaultDATaskOpType	INT = 1,	-- TM_AssocForDefaultDATask OpType
			@isClientLevelJobOpType			INT = 2,	-- isClientLevelJob = 1 OpType
			@isNotClientLevelJobOpType		INT = 3,	-- isClientLevelJob = 0 OpType
			@is4007DDbOpType				INT = 4,	-- ot.operationType = 4007 /*TASK_OPERATION_TYPE_ARCHIVE_CHECK*/ AND ot.ddbVerificationLevel <> '0'
			@isPolicyType13OpType			INT = 5,	-- policyType = 13
			@UnknownOpType					INT = 6,
			@inventoryCrawlOptype			INT = 7		--operationType = 5025 /*TASK_OPERATION_TYPE_INVENTORY_CRAWL*/
	IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.isDataAnalytics2Job = 1 OR ot.isOnlineCrawlJob = 1)
	BEGIN
		IF (@dbgPrint = 1)
			PRINT 'TM_GetAdminEntityCntDataSet: IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.isDataAnalytics2Job = 1 OR ot.isOnlineCrawlJob = 1)'
		-- Compute Is Client Level Job: -1 indicates it is neither
		UPDATE ot
			SET isClientLevelJob = q.isClientLevelJob
		FROM #OtherTasks ot
			INNER JOIN (
				SELECT DISTINCT
					ot.taskId,
					CASE
						WHEN TM.taskId IS NULL THEN 1
						ELSE 0
					END isClientLevelJob
				FROM #OtherTasks ot
					INNER JOIN TM_AssocEntity TM ON
						ot.taskId = TM.taskId
						AND TM.exclude = 0
						AND (
							TM.clientId = 0
							OR TM.clientGroupId <> 0
						)
				WHERE
					ot.isDataAnalytics2Job = 1
					OR ot.isOnlineCrawlJob = 1
			) q ON
				q.taskId = ot.taskId
				AND ot.isClientLevelJob <> q.isClientLevelJob
		INSERT INTO #assocTbl (
			opType,
			taskId,
			clientId,
			appTypeId,
			instanceId,
			backupsetId,
			appId
		)
			SELECT DISTINCT
				@isAssocForDefaultDATaskOpType,
				cj.taskId,
				d.clientId,
				d.appTypeId,
				d.instance,
				d.backupset,
				d.subclientID
			FROM TM_AssocForDefaultDATask d
				CROSS JOIN (
					SELECT DISTINCT
						ot.taskId
					FROM #TaskTableData dt
						INNER JOIN #OtherTasks ot ON
							ot.taskId = dt.taskId
							AND dt.isDefaultDataAnalyticsSched = 1
							AND ot.isDataAnalytics2Job = 1
				) cj
		IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.isClientLevelJob = 1)
		BEGIN
			IF (@dbgPrint = 1)
				PRINT 'TM_GetAdminEntityCntDataSet: IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.isClientLevelJob = 1)'
			--== execute function once to get data rows
			DECLARE @AppTypesForAppGroup35 TABLE (
				appTypeId	INT PRIMARY KEY
			)
			INSERT INTO @AppTypesForAppGroup35 (appTypeId)
				SELECT DISTINCT
					appTypeId
				FROM GetAppTypesForAppGroup(35, 0)
				UNION
SELECT 134
			INSERT INTO #assocTbl (
				opType,
				taskId,
				clientId,
				appTypeId,
				instanceId,
				backupsetId,
				appId
			)
				SELECT DISTINCT
					@isClientLevelJobOpType,
					TM.taskId,
					APP.clientId,
					APP.appTypeId,
					APP.instance,
					APP.backupset,
					APP.id
				FROM APP_Application AS APP WITH (NOLOCK)
					INNER JOIN TM_AssocEntity AS TM ON
						(
							APP.clientId = TM.clientId
							AND (
								(
									TM.subclientId <> 0
									AND TM.subclientId = APP.id
								) --SubClient Level
								OR (
									TM.instanceId <> 0
									AND TM.appTypeId = APP.appTypeID
									AND TM.instanceId = APP.instance
									AND TM.backupsetId = 0
									AND TM.subclientId = 0
								) -- TM.instanceId <> -> Instance level Job.
								OR (
									TM.instanceId = 0
									AND TM.appTypeId = 0
								)-- For Client level
							)
							AND TM.clientGroupId = 0
							AND TM.exclude = 0
						)
						AND (APP.subclientStatus & @excludeStatus) = 0 -- Exclude invalid subclients
						AND APP.appTypeId IN (
								SELECT DISTINCT
									appTypeId
								FROM GetAppTypesForAppGroup(137, 0)
							) -- APPGRP_Analytics2JobSupported
					INNER JOIN #OtherTasks ot ON
						ot.taskId = TM.taskId
						AND ot.isClientLevelJob = 1
			IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.isDataAnalytics2Job = 1)
			BEGIN
				IF (@dbgPrint = 1)
					PRINT 'TM_GetAdminEntityCntDataSet: IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.isDataAnalytics2Job = 1)'
				--Delete the entries for not supported type
				DELETE assoc
				FROM #assocTbl assoc
					INNER JOIN #OtherTasks ot ON
						ot.taskId = assoc.taskId
						AND ot.isDataAnalytics2Job = 1
						AND ot.isOnlineCrawlJob = 0 -- Online crawl will be handled in next block
					INNER JOIN APP_InstanceProp instProp WITH (NOLOCK) ON
						assoc.instanceId = instProp.componentNameId
						AND instProp.attrName = 'Cloud Apps Instance Type'
						AND instProp.modified = 0
				WHERE
					assoc.opType = @isClientLevelJobOpType
					AND assoc.appTypeId = 134		-- CV_APPTYPE_CLOUD_APPS
					AND instProp.attrVal NOT IN (N'1', N'2', N'5', N'6', N'7')	--GOOGLE_MAIL,GOOGLE_DRIVE,AMAZON_S3,AZURE_BLOB,ONEDRIVE
				DELETE assoc
				FROM #assocTbl assoc
					INNER JOIN #OtherTasks ot ON
						ot.taskId = assoc.taskId
						AND ot.isDataAnalytics2Job = 1
						AND ot.isOnlineCrawlJob = 0 -- Online crawl will be handled in next block
					INNER JOIN APP_BackupSetName BS WITH (NOLOCK) ON
						assoc.backupsetId = BS.id
				WHERE
					assoc.opType = @isClientLevelJobOpType
					AND assoc.appTypeId = 78			-- CV_APPTYPE_MS_SHAREPOINTV2_DOC
					AND (BS.status & 0x4000) = 0	-- CV_STATUS_ONDEMAND_SP_DOC_BSET
					AND (BS.status & 0x80000) = 0	-- CV_STATUS_SP_OFFICE365_BSET
				--Delete all non -default subclients for FS
				DELETE assoc
				FROM #assocTbl assoc
					INNER JOIN #OtherTasks ot ON
						ot.taskId = assoc.taskId
						AND ot.isDataAnalytics2Job = 1
						AND ot.isOnlineCrawlJob = 0
					INNER JOIN APP_Application app WITH (NOLOCK) ON
						assoc.appId = app.id
					INNER JOIN APP_BackupSetName bkpSet WITH (NOLOCK) ON
						bkpSet.id = app.backupSet
				WHERE
					assoc.opType = @isClientLevelJobOpType
					AND (
						(app.subclientStatus  & 0x00008) = 0	-- CV_STATUS_DEFAULT
						OR (bkpSet.status & 0x00008) = 0		-- CV_STATUS_DEFAULT
					)
					AND assoc.appTypeId IN (SELECT appTypeId FROM @AppTypesForAppGroup35)
				-- Data Analytics jobs for VSA agent is NOT support at client level but only supported at client group level.
				-- So dont spawn DA job for vsa agent at client level.
				-- To identify Analytics job do below only when index server attribute is set. We dont want to affect file indexing MR 271273
				DELETE assoc
				FROM #assocTbl assoc
					INNER JOIN #OtherTasks ot ON
						ot.taskId = assoc.taskId
						AND ot.isDataAnalytics2Job = 1
						AND ot.isOnlineCrawlJob = 0
						AND ot.indexServerClientID > 0
WHERE assoc.appTypeId= 106
				AND assoc.opType = @isClientLevelJobOpType
			END
			IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.isOnlineCrawlJob = 1)
			BEGIN
				IF (@dbgPrint = 1)
					PRINT 'TM_GetAdminEntityCntDataSet: IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.isOnlineCrawlJob = 1)'
				--Delete all non -default subclients if 'Indexing datasource id' is not present
				-- It should be present either at subclient or client level.
				DELETE assoc
				FROM #assocTbl assoc
					INNER JOIN #OtherTasks ot ON
						ot.taskId = assoc.taskId
						AND ot.isOnlineCrawlJob = 1
					INNER JOIN APP_Application app WITH (NOLOCK) ON
						assoc.appId = app.id
					INNER JOIN APP_BackupSetName bkpSet WITH (NOLOCK) ON
						bkpSet.id = app.backupSet
					LEFT JOIN APP_ClientProp cProp WITH (NOLOCK) ON
						assoc.clientId = cProp.componentNameId
						AND cProp.attrName = 'Indexing datasource id'
					LEFT JOIN APP_SubClientProp sProp WITH (NOLOCK) ON
						assoc.appId = sProp.componentNameId
						AND sProp.attrName = 'Indexing datasource id'
						AND sProp.cs_attrName = CHECKSUM(N'Indexing datasource id')
						AND sProp.modified = 0
				WHERE
					assoc.opType = @isClientLevelJobOpType
					AND (
						sProp.componentNameId IS NULL
						AND cProp.componentNameId IS NULL
					)
					AND assoc.appTypeId IN (SELECT appTypeId FROM @AppTypesForAppGroup35)
				--Online Crawl is supported only for FS
				DELETE assoc
				FROM #assocTbl assoc
					INNER JOIN #OtherTasks ot ON
						ot.taskId = assoc.taskId
						AND ot.isOnlineCrawlJob = 1
				WHERE
					assoc.opType = @isClientLevelJobOpType
					AND assoc.appTypeId NOT IN (SELECT appTypeId FROM @AppTypesForAppGroup35)
			END
		END
		IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.isClientLevelJob = 0)
		BEGIN
			IF (@dbgPrint = 1)
				PRINT 'TM_GetAdminEntityCntDataSet: IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.isClientLevelJob = 0)'
			INSERT INTO #assocTbl
			(
				opType,
				taskId,
				clientGroupId,
				clientId,
				appTypeId,
				instanceId,
				backupsetId,
				appId
			)
				SELECT
					@isNotClientLevelJobOpType,
					TA.taskId,
					TA.clientGroupId,
					TA.clientId,
					TA.apptypeId,
					TA.instanceId,
					TA.backupsetId,
					TA.subclientId
				FROM TM_AssocEntity TA WITH (NOLOCK)
					INNER JOIN #OtherTasks ot ON
						ot.isClientLevelJob = 0
						AND ot.taskId = TA.taskId
						AND TA.exclude = 0;
		END
	END -- IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.isDataAnalytics2Job = 1 OR ot.isOnlineCrawlJob = 1)
	IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.operationType = 4007 /*TASK_OPERATION_TYPE_ARCHIVE_CHECK*/ AND ot.ddbVerificationLevel <> '0')
	BEGIN
		IF (@dbgPrint = 1)
			PRINT 'TM_GetAdminEntityCntDataSet: IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.operationType = 4007 /*TASK_OPERATION_TYPE_ARCHIVE_CHECK*/ AND ot.ddbVerificationLevel <> ''0'')'
		--SIDB STORE ID
		INSERT INTO #assocTbl (
			opType,
			taskId,
			policyId,
			copyId,
			sidbStoreId,
			exclude
		)
			-- SIDB STORE ID IS SELECTED
			SELECT
				@is4007DDbOpType,
				TA.taskId,
				TA.policyId,
				TA.copyId,
				TA.sidbStoreId,
				TA.exclude
			FROM TM_AssocEntity TA WITH (NOLOCK)
				INNER JOIN #OtherTasks ot ON
					ot.taskId = TA.taskId
					AND ot.operationType = 4007
					AND ot.ddbVerificationLevel <> '0'
			WHERE
				TA.agentlessPolicyId = 0
				AND TA.clientGroupId = 0
				AND TA.clientId = 0
				AND TA.trackingPolicyId = 0
				AND TA.MediaAgentId = 0
				AND TA.agentlessPolicyId = 0
				AND TA.libraryId = 0
				AND TA.logMonitoringPolicyId = 0
				AND TA.sidbStoreId > 0
			UNION	--STORAGE POLICY IS SELECTED BUT NOT COPY ID
			SELECT
				@is4007DDbOpType,
				TA.taskId,
				AC.archGroupId,
				AC.id,
				CS.SIDBStoreId,
				TA.exclude
			FROM archGroupCopy AC WITH (NOLOCK)
				JOIN archCopySIDBStore CS WITH (NOLOCK) ON
					AC.id = CS.copyId
					AND (CS.flags & 4 > 0)		-- IDX_COPY_DDB_ACTIVE
				JOIN TM_AssocEntity TA WITH (NOLOCK) ON
					TA.policyId = AC.archGroupId
				INNER JOIN #OtherTasks ot ON
					ot.taskId = TA.taskId
					AND ot.operationType = 4007
					AND ot.ddbVerificationLevel <> '0'
			WHERE
				TA.agentlessPolicyId = 0
				AND TA.clientGroupId = 0
				AND TA.clientId = 0
				AND TA.trackingPolicyId = 0
				AND TA.MediaAgentId = 0
				AND TA.agentlessPolicyId = 0
				AND TA.sidbStoreId = 0
				AND TA.libraryId = 0
				AND TA.logMonitoringPolicyId = 0
				AND TA.workflowId = 0
				AND AC.type <> 5 -- REMOVE TRANSITIVE COPY
				AND TA.policyId = AC.archGroupId
				AND TA.copyId = 0
			UNION	--STORAGE POLICY AND COPY ID ARE SELECTED
			SELECT
				@is4007DDbOpType,
				TA.taskId,
				AC.archGroupId,
				AC.id,
				CS.SIDBStoreId,
				TA.exclude
			FROM archGroupCopy AC WITH (NOLOCK)
				JOIN archCopySIDBStore CS WITH (NOLOCK) ON
					AC.id = CS.copyId
					AND (CS.flags & 4 > 0)		-- IDX_COPY_DDB_ACTIVE
				JOIN TM_AssocEntity TA WITH (NOLOCK) ON
					TA.policyId = AC.archGroupId
					AND TA.copyId = AC.id
				INNER JOIN #OtherTasks ot ON
					ot.taskId = TA.taskId
					AND ot.operationType = 4007
					AND ot.ddbVerificationLevel <> '0'
			WHERE
				TA.agentlessPolicyId = 0
				AND TA.clientGroupId = 0
				AND TA.clientId = 0
				AND TA.trackingPolicyId = 0
				AND TA.MediaAgentId = 0
				AND TA.agentlessPolicyId = 0
				AND TA.sidbStoreId = 0
				AND TA.libraryId = 0
				AND TA.logMonitoringPolicyId = 0
				AND TA.workflowId = 0
				AND AC.type <> 5 -- REMOVE TRANSITIVE COPY
			UNION	--SELECT ALL SIDB STORE IDS
			SELECT
				@is4007DDbOpType,
				TA.taskId,
				AC.archGroupId,
				AC.id,
				CS.SIDBStoreId,
				TA.exclude
			FROM archGroupCopy AC WITH (NOLOCK)
				JOIN archCopySIDBStore CS WITH (NOLOCK) ON
					AC.id = CS.copyId
					AND (CS.flags & 4 > 0)		-- IDX_COPY_DDB_ACTIVE
				JOIN TM_AssocEntity TA WITH (NOLOCK) ON
					TA.assocType = 155
				INNER JOIN #OtherTasks ot ON
					ot.taskId = TA.taskId
					AND ot.operationType = 4007
					AND ot.ddbVerificationLevel <> '0'
			WHERE TA.agentlessPolicyId = 0
					AND TA.clientGroupId = 0
					AND TA.clientId = 0
					AND TA.trackingPolicyId = 0
					AND TA.MediaAgentId = 0
					AND TA.agentlessPolicyId = 0
					AND TA.sidbStoreId = 0
					AND TA.libraryId = 0
					AND TA.logMonitoringPolicyId = 0
					AND CS.SIDBStoreId > 0
		---------------------------
		--EXCLUSION----------------
		---------------------------
		--EXCLUDED SIDB STORE ID ASSOCIATION
		DELETE assoc
		FROM #assocTbl assoc,
			(
				SELECT
					policyId pId,
					copyId cId,
					sidbStoreId sdbId,
					taskId
				FROM #assocTbl A
				WHERE
					exclude = 1
					AND opType = @is4007DDbOpType
			) T
		WHERE
			assoc.opType = @is4007DDbOpType
			AND t.taskId = Assoc.taskId
			AND (
				T.sdbId = assoc.sidbStoreId
				OR (
					T.pId = assoc.policyId
					AND T.cId = assoc.copyId
					AND T.sdbId = 0
				)
				OR (
					T.pId = assoc.policyId
					AND T.cId = 0
					AND T.sdbId = 0
				)
				OR sidbStoreId = 0 		--REMOVE ENTRIES WITHOUT SIDB STORE
			)
		--IF A GDSP STORE IS NOT ASSOCIATED TO SCHEDULE POLICY, REMOVE FROM THE LIST THE SIDB STORE ID OF THE GDSP PRIMARY COPY
		DELETE A
		FROM #assocTbl A
			INNER JOIN (
					SELECT
					CS.SIDBStoreId,
					AG.id,
					A.TaskID
				FROM archGroup AG
					INNER JOIN archCopySIDBStore CS ON (AG.flags & 256) > 0		-- CVA_SP_GLOBAL_DEDUP_FLAG
					AND AG.defaultCopy = CS.copyId
					AND (CS.flags & 4) > 0		-- IDX_COPY_DDB_ACTIVE
					INNER JOIN #assocTbl A ON
					A.opType = @is4007DDbOpType
					LEFT JOIN #assocTbl B ON
					B.policyId = AG.id
					AND B.TaskId = A.TaskId
				WHERE B.policyId IS NULL
			) T ON
				T.SIDBStoreId = A.sidbStoreId
				AND T.TaskId = A.TaskId
		WHERE
			A.opType = @is4007DDbOpType
		--MR151197 - FOR DUPLICATE SIDB JOB SHOULD GET LAUNCHED ON GDSP COPY ONLY
		DELETE A
		FROM #assocTbl A
			INNER JOIN (
				SELECT
					sidbStoreId,
					taskId,
					COUNT(sidbStoreId) n
				FROM #assocTbl
				WHERE opType = @is4007DDbOpType
				GROUP BY
					sidbStoreId,taskId
			) T ON
				T.sidbStoreId = A.sidbStoreId
				AND A.taskId = T.taskId
				AND T.n > 1
			INNER JOIN archGroupCopy AC(NOLOCK) ON
				A.copyId = AC.id
				AND AC.dedupeFlags&268435456 <> 268435456  --_CVA_HOST_GLOBAL_DEDUP_STORE_FLAG
		WHERE
			A.opType = @is4007DDbOpType
	END
	IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.policyType = 13)	--POLICY_TYPE_WORKFLOW
	BEGIN
		IF (@dbgPrint = 1)
			PRINT 'TM_GetAdminEntityCntDataSet: IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.policyType = 13)'
		INSERT INTO #assocTbl (
			opType,
			taskId,
			workFlowId,
			clientId,
			exclude,
			workflowOption
		)
			SELECT
				@isPolicyType13OpType,
				w.taskId,
				w.workflowId,
				w.clientId,
				w.exclude,
				w.workflowOption
			FROM TM_AssocWorkFlowEntity w (NOLOCK)
				INNER JOIN #OtherTasks ot ON
					ot.taskId = w.taskId
	END
	IF EXISTS (
		SELECT 1
		FROM #OtherTasks ot
		WHERE
			ot.policyType <> 13 --POLICY_TYPE_WORKFLOW
			AND NOT (
				ot.operationType = 4007 /*TASK_OPERATION_TYPE_ARCHIVE_CHECK*/
				AND ot.ddbVerificationLevel <> '0'
			)
			AND ot.isClientLevelJob = -1	-- Not Set
	)
	BEGIN
		IF (@dbgPrint = 1)
			PRINT 'TM_GetAdminEntityCntDataSet: IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.policyType <> 13....)'
		--STORAGE POLICY JOBS
		INSERT INTO #assocTbl (
			opType,
			taskId,
			policyId,
			copyId
		)
			SELECT
				@UnknownOpType,
				TA.taskId,
				TA.policyId,
				TA.copyId			--GET STORAGE POLICY ASSOCIATIONS WITH NO EXCLUDE COPY
			FROM TM_AssocEntity TA WITH (NOLOCK)
				INNER JOIN #OtherTasks ot ON
					ot.taskId = TA.taskId
					AND (
						ot.policyType <> 13 --POLICY_TYPE_WORKFLOW
						AND NOT (
							ot.operationType = 4007 /*TASK_OPERATION_TYPE_ARCHIVE_CHECK*/
							AND ot.ddbVerificationLevel <> '0'
						)
						AND ot.isClientLevelJob = -1	-- Not Set
					)
			WHERE
				TA.exclude = 0
				AND TA.agentlessPolicyId = 0
				AND TA.clientGroupId = 0
				AND TA.clientId = 0
				AND TA.trackingPolicyId = 0
				AND TA.MediaAgentId = 0
				AND TA.agentlessPolicyId = 0
				AND TA.sidbStoreId = 0
				AND TA.libraryId = 0
				AND TA.logMonitoringPolicyId = 0
				AND TA.policyId>0
				AND NOT EXISTS (
					SELECT
						1
					FROM TM_AssocEntity WITH (NOLOCK)
					WHERE
						taskId = TA.taskId
						AND exclude = 1
						AND TA.policyId = policyId
				)
			UNION
			SELECT
				@UnknownOpType,
				TA.taskId,
				AC.archGroupId,
				AC.id
				--GET STORAGE POLICY ASSOCIATIONS WITH EXCLUDE COPY
			FROM archGroupCopy AC WITH (NOLOCK)
				INNER JOIN TM_AssocEntity TA WITH (NOLOCK) ON
					TA.policyId = AC.archGroupId
				INNER JOIN #OtherTasks ot ON
					ot.taskId = TA.taskId
					AND (
						ot.policyType <> 13 --POLICY_TYPE_WORKFLOW
						AND NOT (
							ot.operationType = 4007 /*TASK_OPERATION_TYPE_ARCHIVE_CHECK*/
							AND ot.ddbVerificationLevel <> '0'
						)
						AND ot.isClientLevelJob = -1	-- Not Set
					)
			WHERE
				--(AC.flags & 16384) = 0 Changed in update form 76388. Aux copy schedule policy might not kick off jobs if associations contains exclusion
				--AND AC.id <> TA.copyId AND TA.copyId > 0
				TA.agentlessPolicyId = 0
				AND TA.clientGroupId = 0
				AND TA.clientId = 0
				AND TA.trackingPolicyId = 0
				AND TA.MediaAgentId = 0
				AND TA.agentlessPolicyId = 0
				AND TA.sidbStoreId = 0
				AND TA.libraryId = 0
				AND TA.logMonitoringPolicyId = 0
				AND TA.workflowId = 0
				AND AC.type <> 5 --CVA_AGCOPYTYPE_TRANSITIVE REMOVE TRANSITIVE COPY
				AND exclude = 1
				AND TA.policyId = AC.archGroupId
				AND NOT EXISTS
				(
					SELECT
						1
					FROM archGroup WITH (NOLOCK)
					WHERE
						defaultCopy = AC.id
				)  -- REMOVE BACKUPCOPY ARCH COPY
				AND EXISTS
				(
					SELECT
						1
					FROM TM_AssocEntity WITH (NOLOCK)
					WHERE
						taskId = TA.taskId
						AND exclude = 1
						AND TA.policyId = AC.archGroupId
				)
			UNION
			SELECT
				@UnknownOpType,
				TA.taskId,
				TA.policyId,
				TA.copyId
			FROM TM_AssocEntity TA WITH (NOLOCK)
				INNER JOIN #OtherTasks ot ON
					ot.taskId = TA.taskId
					AND (
						ot.policyType <> 13 --POLICY_TYPE_WORKFLOW
						AND NOT (
							ot.operationType = 4007 /*TASK_OPERATION_TYPE_ARCHIVE_CHECK*/
							AND ot.ddbVerificationLevel <> '0'
						)
						AND ot.isClientLevelJob = -1	-- Not Set
					)
			WHERE
				TA.agentlessPolicyId = 0
				AND TA.clientGroupId = 0
				AND TA.clientId = 0
				AND TA.trackingPolicyId = 0
				AND TA.MediaAgentId = 0
				AND TA.agentlessPolicyId = 0
				AND TA.sidbStoreId = 0
				AND TA.libraryId = 0
				AND TA.logMonitoringPolicyId = 0
				AND TA.workflowId = 0
				AND TA.exclude = 0
				AND TA.policyId>0
				AND NOT EXISTS
				(
					SELECT
						1
					FROM TM_AssocEntity WITH (NOLOCK)
					WHERE
						taskId = TA.taskId
						AND exclude = 1
				)
			UNION
			SELECT
				@UnknownOpType,
				TA.taskId,
				AGC.archGroupId,
				0
			FROM TM_AssocEntity TA WITH (NOLOCK)
				INNER JOIN #OtherTasks ot ON
					ot.taskId = TA.taskId
					AND (
						ot.policyType <> 13 --POLICY_TYPE_WORKFLOW
						AND NOT (
							ot.operationType = 4007 /*TASK_OPERATION_TYPE_ARCHIVE_CHECK*/
							AND ot.ddbVerificationLevel <> '0'
						)
						AND ot.isClientLevelJob = -1	-- Not Set
					)
				INNER JOIN ArchGroup AG WITH (NOLOCK) ON
				TA.agentlessPolicyId = 0
				AND TA.clientGroupId = 0
				AND TA.clientId = 0
				AND TA.trackingPolicyId = 0
				AND TA.MediaAgentId = 0
				AND TA.agentlessPolicyId = 0
				AND TA.sidbStoreId = 0
				AND TA.libraryId = 0
				AND TA.logMonitoringPolicyId = 0
				AND TA.workflowId = 0
				AND TA.exclude = 0
				AND TA.policyId=0
				AND TA.copyId=0
AND TA.assocType = 16
				INNER JOIN archGroupCopy AGC WITH (NOLOCK)
				ON AGC.archGroupId = AG.Id
				AND AGC.id <> AG.defaultCopy AND AGC.id <> AG.defaultSnapCopy
AND (AG.flags & ((256|16384 | 8388608 ))= 0)
				AND AGC.isActive != 0 AND AGC.startTime <= @nowUtcUnix
				AND AGC.type <> 5  -- REMOVE TRANSITIVE COPY
				LEFT JOIN TM_AssocEntity ExcludedTA WITH (NOLOCK) ON ExcludedTA.taskId = TA.taskId
				AND ExcludedTA.exclude = 1
				AND ExcludedTA.policyId =  AGC.archGroupId
				WHERE ExcludedTA.taskId IS NULL
	END
IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.operationType = 5025)
	BEGIN
		IF (@dbgPrint = 1)
			PRINT 'TM_GetAdminEntityCntDataSet: IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.operationType = 5025 /*TASK_OPERATION_TYPE_INVENTORY_CRAWL*/)'
		--DataSource Id
		INSERT INTO #assocTbl (
			opType,
			taskId,
			entityId,
			entityType,
			exclude
		)
			SELECT
				@inventoryCrawlOptype,
				TA.taskId,
				TA.entityId,
				TA.assocType,
				TA.exclude
			FROM TM_AssocEntity TA WITH (NOLOCK)
				INNER JOIN #OtherTasks ot ON
					ot.taskId = TA.taskId
					AND ot.operationType = 5025
			WHERE
				TA.agentlessPolicyId = 0
				AND TA.clientGroupId = 0
				AND TA.clientId = 0
				AND TA.trackingPolicyId = 0
				AND TA.MediaAgentId = 0
				AND TA.agentlessPolicyId = 0
				AND TA.libraryId = 0
				AND TA.logMonitoringPolicyId = 0
				AND TA.sidbStoreId = 0
				AND TA.assoctype = 132
				AND TA.entityId > 0
	END
	IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.isDataAnalytics2Job = 0 AND ot.isOnlineCrawlJob = 0) -- Data analytics job is at client herirarchy level
	BEGIN
		IF (@dbgPrint = 1)
			PRINT 'TM_GetAdminEntityCntDataSet: IF EXISTS (SELECT 1 FROM #OtherTasks ot WHERE ot.isDataAnalytics2Job = 0 AND ot.isOnlineCrawlJob = 0)'
		--EXCLUDED STORAGE POLICY COPY ASSOCIATION
		DELETE assoc
		FROM #assocTbl assoc
			INNER JOIN #OtherTasks ot ON
				ot.taskId = assoc.taskId
				AND ot.isDataAnalytics2Job = 0
				AND ot.isOnlineCrawlJob = 0
			INNER JOIN TM_AssocEntity (NOLOCK) TA ON
			TA.exclude = 1
			AND TA.taskId = assoc.taskId
			AND TA.copyId>0
			AND TA.copyId = assoc.copyId
		-- Handle Storage policy exclusion
		DELETE assoc
		FROM #assocTbl assoc
			INNER JOIN #OtherTasks ot ON
				ot.taskId = assoc.taskId
				AND ot.isDataAnalytics2Job = 0
				AND ot.isOnlineCrawlJob = 0
			INNER JOIN TM_AssocEntity (NOLOCK) TA ON
			TA.exclude = 1
			AND TA.taskId = assoc.taskId
			AND TA.copyId=0
			AND TA.policyId = assoc.policyId
	END
END
--- CODE ABOVE HERE IS FROM TM_GetAdminEntityCndDataSet.spb  ----------
			IF OBJECT_ID('tempdb.dbo.#assocTbl2') is not null
				DROP TABLE #assocTbl2
			-- Eliminate Duplicate rows before performing entity counts
			SELECT DISTINCT
				*
			INTO #assocTbl2
			FROM #assocTbl
			-- Clustered index screws up counts??????
			--CREATE CLUSTERED INDEX assocTbl2_idx ON #assocTbl2 (taskId, subTaskId)
			-- Compute Task Entity Counts
			UPDATE et
				SET entityCount = ct.cnt
			FROM #TM_GetAdminEntityCountDataSet_taskTble et
				INNER JOIN (
					SELECT
						ot.taskId,
						ot.subTaskId,
						COUNT(DISTINCT a.appid) cnt
					FROM #OtherTasks ot
						INNER JOIN #assocTbl2 a ON
							a.taskId = ot.taskId
							AND ot.operationType = 4007		-- TASK_OPERATION_TYPE_ARCHIVE_CHECK
							AND a.sidbStoreId <> 0
						INNER JOIN #TaskTableData td ON
							td.taskType = 4				-- TASK_TYPE_SCHEDULE_POLICY
							AND td.taskId = ot.taskId
					GROUP BY
						ot.taskId,
						ot.subTaskId
				) ct ON
					ct.taskId = et.taskId
					AND ct.subTaskId = et.subTaskId
					AND et.subTaskType = 1
			UPDATE et
				SET entityCount = ct.cnt
			FROM #TM_GetAdminEntityCountDataSet_taskTble et
				INNER JOIN (
					SELECT
						ot.taskId,
						ot.subTaskId,
						COUNT(1) cnt
					FROM #OtherTasks ot
						INNER JOIN #assocTbl2 a ON
							a.taskId = ot.taskId
							AND a.opType = @isPolicyType13OpType
					GROUP BY
						ot.taskId,
						ot.subTaskId
				) ct ON
					ct.taskId = et.taskId
					AND ct.subTaskId = et.subTaskId
					AND et.subTaskType = 1
			UPDATE et
				SET entityCount = ct.cnt
			FROM #TM_GetAdminEntityCountDataSet_taskTble et
				INNER JOIN (
					SELECT
						ot.taskId,
						ot.subTaskId,
						COUNT(1) cnt
					FROM #OtherTasks ot
						INNER JOIN #assocTbl2 a ON
							a.taskId = ot.taskId
							AND ot.isDataAnalytics2Job = 1
					GROUP BY
						ot.taskId,
						ot.subTaskId
				) ct ON
					ct.taskId = et.taskId
					AND ct.subTaskId = et.subTaskId
					AND et.subTaskType = 1
			UPDATE et
				SET entityCount = ct.cnt
			FROM #TM_GetAdminEntityCountDataSet_taskTble et
				INNER JOIN (
					SELECT
						ot.taskId,
						ot.subTaskId,
						COUNT(1) cnt
					FROM #OtherTasks ot
						INNER JOIN #assocTbl2 a ON
							a.taskId = ot.taskId
							AND a.policyId <> 0
					GROUP BY
						ot.taskId,
						ot.subTaskId
				) ct ON
					ct.taskId = et.taskId
					AND ct.subTaskId = et.subTaskId
					AND et.subTaskType = 1
			UPDATE et
				SET entityCount = 0
			FROM #TM_GetAdminEntityCountDataSet_taskTble et
			WHERE
				et.entityCount IS NULL
				AND et.subTaskType = 1
		END
	END TRY
	---------------------------------------------
	-- THIS IS THE RESPONSE IF ALL WENT WELL ----
	---------------------------------------------
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		RETURN 1
	END CATCH
	RETURN 0
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GetAdminEntityCountDataSet')
	delete from GxQscripts where name = 'TM_GetAdminEntityCountDataSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GetAdminEntityCountDataSet')
	delete from GXDBVersions where aliasname = 'TM_GetAdminEntityCountDataSet'
GO

insert into GXDBVersions values(2, 'TM_GetAdminEntityCountDataSet',  'v1.1.2.10.4.2', 'TM_GetAdminEntityCountDataSet', 'v1.1.2.10.4.2')
GO

