

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_GenerateSchedBkpAssocCache.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_GenerateSchedBkpAssocCache.sp,v $ $Id: TM_GenerateSchedBkpAssocCache.sp,v 1.5.60.1 2017/02/10 20:42:00 sjohnson Exp $";
-- =============================================
-- Author:		Anand Vibhor
-- Create date: 01/28/2006
-- Description:	Generate the cache of appId for the given subtaskId
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_GenerateSchedBkpAssocCache <<<'

IF EXISTS (select * from sysobjects where name='TM_GenerateSchedBkpAssocCache')
	drop procedure TM_GenerateSchedBkpAssocCache
IF EXISTS (select * from GxQscripts where name='TM_GenerateSchedBkpAssocCache')
	delete from GxQscripts where name = 'TM_GenerateSchedBkpAssocCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GenerateSchedBkpAssocCache')
	delete from GXDBVersions where aliasname = 'TM_GenerateSchedBkpAssocCache'
GO
print '... Creating Procedure: TM_GenerateSchedBkpAssocCache'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_GenerateSchedBkpAssocCache
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_subTaskId integer
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
BEGIN TRY
--BEGIN TRAN	--START THE TRANSACTION
	DECLARE @errorCode INT
	DECLARE @errorString varchar(MAX)
	DECLARE @taskId INT
	DECLARE @created INT
	SET @created = dbo.getUnixtime(GETUTCDATE())
	SET @taskId = (SELECT taskId FROM TM_SubTask where subtaskId = @i_subTaskId)
	IF object_id('tempdb.dbo.#tmpAppEntryTbl') is not null
    					DROP TABLE #tmpAppEntryTbl
		CREATE TABLE #tmpAppEntryTbl ( appId INT,  appTypeId INT, clientId INT,instanceId INT, backupsetId INT,  status INT)
	EXEC TM_GetBackupEntity  @taskId, @i_subTaskId, #tmpAppEntryTbl
	INSERT INTO TM_AssocEntityCache SELECT @taskId, @i_subTaskId, 0, @created,clientId, appTypeId, instanceId, backupsetId, appId FROM #tmpAppEntryTbl
UPDATE  [TM_SubTask] SET [flags] = flags | CAST(0x8 AS INT) where subtaskId = @i_subTaskId  --SUBTASK_ASSOC_CACHE    0x8
--COMMIT TRAN
END TRY
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to get error information.
    EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
    -- Rollback any active or uncommittable transactions before
    -- inserting information in the ErrorLog
--    IF XACT_STATE() <> 0
--    BEGIN
--        ROLLBACK TRANSACTION;
--    END
END CATCH;
SET NOCOUNT OFF
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
SELECT	1			         as TAG,
		NULL		         as Parent,
	@errorCode			     as [TMMsg_GenericResp!1!errorCode],
	@errorString	         as [TMMsg_GenericResp!1!errorMessage]
FOR XML EXPLICIT
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_GenerateSchedBkpAssocCache')
	delete from GxQscripts where name = 'TM_GenerateSchedBkpAssocCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_GenerateSchedBkpAssocCache')
	delete from GXDBVersions where aliasname = 'TM_GenerateSchedBkpAssocCache'
GO

insert into GXDBVersions values(2, 'TM_GenerateSchedBkpAssocCache',  '00010005006000010000', 'TM_GenerateSchedBkpAssocCache', '00010005006000010000')
GO

